#include "stdafx.h"

#include <Compiler.h>

#define BREAK_EIP(checkEip)  (obp+0x00401000>=checkEip)

void NativeCode::PutEx( const NativeCode &nativeCode )
{
	long baseOffset = GetSize();

	// R[hobt@ǉ
	Put( nativeCode.GetBuffer(), nativeCode.GetSize() );

	// XPW[ǉ
	BOOST_FOREACH( const Schedule &schedule, nativeCode.schedules )
	{
		this->schedules.push_back(
			Schedule(
				schedule.GetType(),
				baseOffset + schedule.GetOffset(),
				schedule.GetLongPtrValue()
			)
		);
	}

	// \[XR[hsԍƃlCeBuR[hʒȗΉǉ
	BOOST_FOREACH( const SourceLine &sourceLine, nativeCode.sourceLines )
	{
		this->sourceLines.push_back(
			SourceLine(
				sourceLine.GetLineNum(),
				baseOffset + sourceLine.GetNativeCodePos(),
				sourceLine.GetSourceIndex(),
				sourceLine.GetSourceCodePos(),
				sourceLine.GetCodeType()
			)
		);
	}
}

void NativeCode::PutEx( long l, Schedule::Type scheduleType )
{
	if( scheduleType == Schedule::CatchAddress )
	{
		const UserProc *pUserProc = &UserProc::CompilingUserProc();
		if( UserProc::IsGlobalAreaCompiling() )
		{
			pUserProc = UserProc::pGlobalProc;
		}
		PutCatchAddressSchedule( pUserProc, l );
	}
	else
	{
		if( scheduleType != Schedule::None )
		{
			schedules.push_back( Schedule( scheduleType, GetSize() ) );
		}

		Put( l );
	}
}

void NativeCode::PutUserProcSchedule( const UserProc *pUserProc, bool isCall )
{
	pUserProc->Using();

	Schedule schedule( pUserProc, GetSize() );
	if( isCall == false )
	{
		schedule.SpecifyAddressOf();
	}
	schedules.push_back( schedule );

	Put( (long)0 );
}

void NativeCode::PutCatchAddressSchedule( const UserProc *pUserProc, long codePos )
{
	pUserProc->Using();

	Schedule schedule( pUserProc, GetSize() );
	schedule.SpecifyCatchAddress();
	schedules.push_back( schedule );

	Put( codePos );
}

void NativeCode::PutDllProcSchedule( const DllProc *pDllProc )
{
	pDllProc->Using();

	schedules.push_back( Schedule( pDllProc, GetSize() ) );

	Put( (long)0 );
}

void NativeCode::PutVtblSchedule( const CClass *pClass )
{
	schedules.push_back( Schedule( pClass, GetSize() ) );

	Put( (long)0 );
}

void NativeCode::NextSourceLine()
{
	if( sourceLines.size() )
	{
		if( sourceLines.back().GetNativeCodePos() == GetSize() )
		{
			sourceLines.back().SetSourceCodePos( cp );
			return;
		}
	}

	extern BOOL bDebugSupportProc;
	extern BOOL bSystemProc;
	DWORD sourceLineType = 0;
	if( bDebugSupportProc )
	{
		sourceLineType |= CODETYPE_DEBUGPROC;
	}
	if( bSystemProc )
	{
		sourceLineType |= CODETYPE_SYSTEMPROC;
	}
	sourceLines.push_back(
		SourceLine(
			(long)sourceLines.size(),
			GetSize(),
			compiler.GetObjectModule().GetCurrentSourceIndex(),
			cp,
			sourceLineType
		)
	);
}

void NativeCode::ResetDataSectionBaseOffset( long dataSectionBaseOffset )
{
	BOOST_FOREACH( const Schedule &schedule, schedules )
	{
		if( schedule.GetType() == Schedule::DataTable )
		{
			Overwrite(
				schedule.GetOffset(),
				GetLong( schedule.GetOffset() ) + dataSectionBaseOffset
			);
		}
	}
}
void NativeCode::ResetSourceIndexes( long sourceIndexBase )
{
	BOOST_FOREACH( SourceLine &sourceLine, sourceLines )
	{
		sourceLine.SetSourceIndex( sourceLine.GetSourceIndex() + sourceIndexBase );
	}
}
