#include <jenga/include/common/Exception.h>
#include <jenga/include/smoothie/SmoothieException.h>
#include <jenga/include/smoothie/LexicalAnalysis.h>
#include <jenga/include/smoothie/BasicFixed.h>

#include <windows.h>

bool IsVariableTopChar(char c){
	if((c>='A'&&c<='Z')||(c>='a'&&c<='z')||c=='_')
	{
		return true;
	}
	return false;
}
bool IsVariableChar(char c){
	if((c>='A'&&c<='Z')||(c>='a'&&c<='z')||(c>='0'&&c<='9')||
		c=='%'||c=='!'||c=='#'||c=='$'||
		c=='_'||c=='.')
	{
		return true;
	}
	return false;
}
bool IsBlank(char c){
	if(c==' '||c=='\t') return 1;
	return 0;
}
int GetOneParameter(const char *Parameter,int pos,char *retAns){
	int i,i2,i3,IsStr;
	for(i=pos,i2=0,IsStr=0;;i++,i2++){
		if(Parameter[i]=='\"') IsStr^=1;
		else if(Parameter[i]=='('&&IsStr==0){
			i3=GetStringInPare(retAns+i2,Parameter+i);
			i+=i3-1;
			i2+=i3-1;
			continue;
		}
		else if(Parameter[i]=='['&&IsStr==0){
			i3=GetStringInBracket(retAns+i2,Parameter+i);
			i+=i3-1;
			i2+=i3-1;
			continue;
		}
		else if(Parameter[i]==','&&IsStr==0){
			retAns[i2]=0;
			i++;
			break;
		}

		if(IsCommandDelimitation(Parameter[i])&&IsStr==0
			|| Parameter[i] == ')' && IsStr == 0 ){
				retAns[i2]=0;
				break;
		}

		retAns[i2]=Parameter[i];
	}
	return i;
}
int JumpOneParameter(char *Parameter,int i){
	int i2,IsStr;
	for(i2=0,IsStr=0;;i++,i2++){
		if(Parameter[i]=='\"') IsStr^=1;
		else if(Parameter[i]=='('&&IsStr==0){
			i=JumpStringInPare(Parameter,i+1);
			continue;
		}
		else if(Parameter[i]=='['&&IsStr==0){
			i=JumpStringInBracket(Parameter,i+1);
			continue;
		}
		else if(Parameter[i]==','&&IsStr==0){
			i++;
			break;
		}
		if(IsCommandDelimitation(Parameter[i])) break;
	}
	return i;
}
int GetStringInQuotation(char *buffer,char *ReadBuffer){
	int i;

	if(ReadBuffer[0]=='\"'){
		buffer[0]=ReadBuffer[0];
		i=1;
	}
	else i=0;

	for(;;i++){
		buffer[i]=ReadBuffer[i];
		if(IsDBCSLeadByte(ReadBuffer[i])){
			i++;
			buffer[i]=ReadBuffer[i];
			continue;
		}
		if(ReadBuffer[i]=='\"'){
			i++;
			buffer[i]=0;
			break;
		}
		if(ReadBuffer[i]=='\0') return 0;
	}
	return i;
}
int GetStringInPare(char *buffer,const char *ReadBuffer){
	int i,IsStr,PareNum;
	for(i=0,IsStr=0,PareNum=0;;i++){
		buffer[i]=ReadBuffer[i];
		if(IsDBCSLeadByte(ReadBuffer[i])){
			i++;
			buffer[i]=ReadBuffer[i];
			continue;
		}
		if(ReadBuffer[i]=='\"') IsStr^=1;
		else if(ReadBuffer[i]=='('&&IsStr==0) PareNum++;
		else if(ReadBuffer[i]==')'&&IsStr==0){
			PareNum--;
			if(PareNum==0){
				i++;
				buffer[i]=0;
				break;
			}
		}
		else if(ReadBuffer[i]=='\0') return 0;
	}
	return i;
}
int GetStringInBracket(char *buffer,const char *ReadBuffer){
	int i,IsStr,PareNum;
	for(i=0,IsStr=0,PareNum=0;;i++){
		buffer[i]=ReadBuffer[i];
		if(IsDBCSLeadByte(ReadBuffer[i])){
			i++;
			buffer[i]=ReadBuffer[i];
			continue;
		}
		if(ReadBuffer[i]=='\"') IsStr^=1;
		else if(ReadBuffer[i]=='['&&IsStr==0) PareNum++;
		else if(ReadBuffer[i]==']'&&IsStr==0){
			PareNum--;
			if(PareNum==0){
				i++;
				buffer[i]=0;
				break;
			}
		}
		else if(ReadBuffer[i]=='\0') return 0;
	}
	return i;
}
int GetStringInGenericBracket(char *buffer,const char *ReadBuffer){
	int i,IsStr,PareNum;
	for(i=0,IsStr=0,PareNum=0;;i++){
		buffer[i]=ReadBuffer[i];
		if(IsDBCSLeadByte(ReadBuffer[i])){
			i++;
			buffer[i]=ReadBuffer[i];
			continue;
		}
		if(ReadBuffer[i]=='\"') IsStr^=1;
		else if(ReadBuffer[i]=='<'&&IsStr==0) PareNum++;
		else if(ReadBuffer[i]=='>'&&IsStr==0){
			PareNum--;
			if(PareNum==0){
				i++;
				buffer[i]=0;
				break;
			}
		}
		else if(ReadBuffer[i]=='\0') return 0;
	}
	return i;
}
int JumpStringInPare(const char *buffer,int pos){
	int PareNum;
	for(PareNum=1;;pos++){
		if(buffer[pos]=='\"'){
			for(pos++;;pos++){
				if(buffer[pos]=='\"') break;
			}
			continue;
		}
		else if(buffer[pos]=='(') PareNum++;
		else if(buffer[pos]==')'){
			PareNum--;
			if(PareNum==0) return pos;
		}
		else if(buffer[pos]=='\0') break;
	}
	return 0;
}
int JumpStringInBracket(const char *buffer,int pos){
	int PareNum;
	for(PareNum=1;;pos++){
		if(buffer[pos]=='\"'){
			for(pos++;;pos++){
				if(buffer[pos]=='\"') break;
			}
			continue;
		}
		else if(buffer[pos]=='[') PareNum++;
		else if(buffer[pos]==']'){
			PareNum--;
			if(PareNum==0) return pos;
		}
		else if(buffer[pos]=='\0') break;
	}
	return 0;
}
bool IsCommandDelimitation( char c ){
	if( c == '\n' || c == ':' || c == '\0' ){
		return true;
	}

	return false;
}

int GetStringInPare_RemovePare(char *buffer,const char *ReadBuffer){
	int i,IsStr,PareNum;
	for(i=0,IsStr=0,PareNum=1;;i++){
		buffer[i]=ReadBuffer[i];
		if(IsDBCSLeadByte(ReadBuffer[i])){
			i++;
			buffer[i]=ReadBuffer[i];
			continue;
		}
		if(ReadBuffer[i]=='\"') IsStr^=1;
		else if(ReadBuffer[i]=='('&&IsStr==0) PareNum++;
		else if(ReadBuffer[i]==')'&&IsStr==0){
			PareNum--;
			if(PareNum==0){
				buffer[i]=0;
				break;
			}
		}
		else if(ReadBuffer[i]=='\0') return 0;
	}
	return i;
}

void SplitParameter( const std::string &src, Jenga::Common::Strings &dests, bool isClear )
{
	const char *buffer = src.c_str();
	int i = 0;

	if( isClear )
	{
		dests.clear();
	}

	while( buffer[i] )
	{
		char result[8192];
		i = GetOneParameter( buffer, i, result );
		dests.push_back( result );
	}
}


bool SplitMemberName( const char *desc, char *object, char *member, ReferenceKind &refType ){
	int lastIndex = -1;
	for( int i=0; desc[i]; i++ ){
		if( desc[i] == '(' ){
			i=JumpStringInPare(desc,i+1);
			continue;
		}
		else if( desc[i] == '[' ){
			i=JumpStringInBracket(desc,i+1);
			continue;
		}
		else if(desc[i]=='.'||(desc[i]==1&&desc[i+1]==ESC_PSMEM)){
			lastIndex = i;
		}
	}
	if( lastIndex == -1 ){
		if( object )
		{
			object[0] = 0;
		}
		lstrcpy( member, desc );
		return false;
	}

	if(desc[lastIndex]=='.'){
		lstrcpy(member,desc+lastIndex+1);
		refType = RefDot;
	}
	else{
		lstrcpy(member,desc+lastIndex+2);
		refType = RefPointer;
	}

	if( object ){
		lstrcpy( object, desc );
		object[lastIndex]=0;
	}

	return true;
}
bool SplitMemberName( const char *desc, char *object, char *member ){
	ReferenceKind dummyRefType;
	return SplitMemberName( desc, object, member, dummyRefType );
}

void SplitSyntacticForAs( const char *src, char *varName, char *typeName)
{
	int i = 0;
	for( ; ; i++ )
	{
		if( src[i] == '\0' || src[i] == 1 && src[i+1] == ESC_AS )
		{
			varName[i] = 0;
			break;
		}
		varName[i] = src[i];
	}

	if( src[i] )
	{
		lstrcpy( typeName, src + i + 2 );
	}
	else
	{
		typeName[i] = 0;
	}
}

char *calcNames[255] = {
	"xor",
};
void InitCalcNames()
{
	if( calcNames[CALC_XOR] )
	{
		return;
	}

	memset( calcNames, 0, 255 * sizeof(char *) );
	calcNames[CALC_XOR] = "xor";
	calcNames[CALC_OR] = "or";
	calcNames[CALC_AND] = "and";
	calcNames[CALC_NOT] = "Not";
	calcNames[CALC_PE] = "<=";
	calcNames[CALC_QE] = ">=";
	calcNames[CALC_NOTEQUAL] = "<>";
	calcNames[CALC_EQUAL] = "=(compare)";
	calcNames[CALC_P] = "<";
	calcNames[CALC_Q] = ">";
	calcNames[CALC_SHL] = "<<";
	calcNames[CALC_SHR] = ">>";
	calcNames[CALC_ADDITION] = "+";
	calcNames[CALC_SUBTRACTION] = "-";
	calcNames[CALC_STRPLUS] = "&";
	calcNames[CALC_MOD] = "mod";
	calcNames[CALC_PRODUCT] = "*";
	calcNames[CALC_QUOTIENT] = "/";
	calcNames[CALC_INTQUOTIENT] = "\\";
	calcNames[CALC_AS] = "As";
	calcNames[CALC_BYVAL] = "ByVal";
	calcNames[CALC_MINUSMARK] = "-(mark)";
	calcNames[CALC_POWER] = "^";
	calcNames[CALC_SUBSITUATION] = "=";
	calcNames[CALC_ARRAY_GET] = "[]";
	calcNames[CALC_ARRAY_SET] = "[]=";
}
void GetCalcName(int idCalc,char *name){
	InitCalcNames();

	if( calcNames[idCalc] == NULL )
	{
		SmoothieException::Throw();
	}
	lstrcpy( name, calcNames[idCalc] );
}
BYTE ToCalcId( const char *name )
{
	InitCalcNames();

	for( int i=0; i<255; i++ )
	{
		if( calcNames[i] )
		{
			if( lstrcmp( name, calcNames[i] ) == 0 )
			{
				return i;
			}
		}
	}
	SmoothieException::Throw();
	return 0;
}

std::string Operator_NaturalStringToCalcMarkString( const std::string &name )
{
	if( name[0] == 1 && name[1] == ESC_OPERATOR )
	{
		BYTE calcId = ToCalcId( name.c_str()+2 );
		char temporary[255];
		temporary[0] = name[0];
		temporary[1] = name[1];
		temporary[2] = calcId;
		temporary[3] = 0;
		return temporary;
	}
	return name;
}
std::string Operator_CalcMarkStringToNaturalString( const std::string &name )
{
	if( name[0] == 1 && name[1] == ESC_OPERATOR )
	{
		BYTE calcId = name[2];
		char temporary[255], calcName[255];
		GetCalcName( calcId, calcName );
		temporary[0] = name[0];
		temporary[1] = name[1];
		lstrcpy( temporary+2, calcName );
		return temporary;
	}
	return name;
}

bool IsGenericTypeSourcePart( const char *buffer )
{
	if( buffer[0] != '<' )
	{
		Jenga::Throw( "Ӑ}Ȃɑ΂IsGenericTypeSourcePart֐Ă΂ꂽ" );
		return false;
	}

	int i=1, scopeCount=1;
	for( ; ; i++ )
	{
		if( buffer[i] == '\0' )
		{
			break;
		}
		if( buffer[i] == '<' )
		{
			scopeCount++;
		}
		else if( buffer[i] == '>' )
		{
			scopeCount--;

			if( scopeCount == 0 )
			{
				break;
			}
		}
	}

	if( buffer[i] != '>' )
	{
		return false;
	}


	/////////////////////////////////////////////////////////////////
	// '>'ɑ𔻒肷
	/////////////////////////////////////////////////////////////////

	i++;
	while( IsBlank( buffer[i] ) )
	{
		i++;
	}

	if( IsVariableChar( buffer[i] ) )
	{
		return false;
	}

	return true;
}
