#include "../BasicCompiler_Common/common.h"
#include "Opcode.h"

void ExtendStackTo32(int type);
void ExtendStackTo64(int type){
	if(Is64Type(type)) return;

	//32rbgɊg
	ExtendStackTo32(type);

	//64rbgɊg
	if(IsSignedType(type)){
		//

		//pop eax
		op_pop(REG_EAX);

		//cdq
		op_cdq();

		//push edx
		op_push(REG_EDX);

		//push eax
		op_push(REG_EAX);
	}
	else{
		//Ȃ

		//pop eax
		op_pop(REG_EAX);

		//push 0
		op_push_value(0);

		//push eax
		op_push(REG_EAX);
	}
}
void ExtendStackTo32(int type){
	if(GetTypeSize(type,-1)==sizeof(long)) return;

	if(Is64Type(type)){
		//pop eax
		op_pop(REG_EAX);

		//pop edx
		op_pop(REG_EDX);

		//push eax
		op_push(REG_EAX);
	}
	else if(type==DEF_INTEGER){
		//pop eax
		op_pop(REG_EAX);

		//movsx eax,ax
		OpBuffer[obp++]=(char)0x0F;
		OpBuffer[obp++]=(char)0xBF;
		OpBuffer[obp++]=(char)0xC0;

		//push eax
		op_push(REG_EAX);
	}
	else if(type==DEF_WORD){
		//pop eax
		op_pop(REG_EAX);

		//and eax,0000FFFFh
		OpBuffer[obp++]=(char)0x25;
		*((long *)(OpBuffer+obp))=0x0000FFFF;
		obp+=sizeof(long);

		//push eax
		op_push(REG_EAX);
	}
	else if(type==DEF_CHAR){
		//pop eax
		op_pop(REG_EAX);

		//movsx eax,al
		OpBuffer[obp++]=(char)0x0F;
		OpBuffer[obp++]=(char)0xBE;
		OpBuffer[obp++]=(char)0xC0;

		//push eax
		op_push(REG_EAX);
	}
	else if(type==DEF_BYTE||type==DEF_BOOLEAN){
		//pop eax
		op_pop(REG_EAX);

		//and eax,000000FFh
		OpBuffer[obp++]=(char)0x25;
		*((long *)(OpBuffer+obp))=0x000000FF;
		obp+=sizeof(long);

		//push eax
		op_push(REG_EAX);
	}
}
void ExtendStackTo16(int type){
	if(type==DEF_CHAR){
		//pop eax
		op_pop(REG_EAX);

		//movsx eax,al
		OpBuffer[obp++]=(char)0x0F;
		OpBuffer[obp++]=(char)0xBE;
		OpBuffer[obp++]=(char)0xC0;

		//push eax
		op_push(REG_EAX);
	}
	else if(type==DEF_BYTE){
		//pop eax
		op_pop(REG_EAX);

		//and eax,000000FFh
		OpBuffer[obp++]=(char)0x25;
		*((long *)(OpBuffer+obp))=0x000000FF;
		obp+=sizeof(long);

		//push eax
		op_push(REG_EAX);
	}
}
void ExtendStackTo8(int type){
	if(Is64Type(type)){
		//pop eax
		op_pop(REG_EAX);

		//pop edx
		op_pop(REG_EDX);

		//push eax
		op_push(REG_EAX);
	}
}


void ChangeTypeToWhole(int OldType,int NewType){
	if(OldType==DEF_DOUBLE){
		if(Is64Type(NewType)){
			//fld qword ptr[esp]
			op_fld_ptr_esp(DEF_DOUBLE);

			//fistp qword ptr[esp]
			fpu_cast();
			OpBuffer[obp++]=(char)0xDF;
			OpBuffer[obp++]=(char)0x3C;
			OpBuffer[obp++]=(char)0x24;
			fpu_cast_end();
		}
		else{
			//fld qword ptr[esp]
			op_fld_ptr_esp(DEF_DOUBLE);

			//add esp,4
			op_add_esp(4);

			//fistp dword ptr[esp]
			fpu_cast();
			OpBuffer[obp++]=(char)0xDB;
			OpBuffer[obp++]=(char)0x1C;
			OpBuffer[obp++]=(char)0x24;
			fpu_cast_end();
		}
	}
	else if(OldType==DEF_SINGLE){
		if(Is64Type(NewType)){
			//fld dword ptr[esp]
			op_fld_ptr_esp(DEF_SINGLE);

			//sub esp,4
			op_sub_esp(4);

			//fistp qword ptr[esp]
			fpu_cast();
			OpBuffer[obp++]=(char)0xDF;
			OpBuffer[obp++]=(char)0x3C;
			OpBuffer[obp++]=(char)0x24;
			fpu_cast_end();
		}
		else{
			//fld dword ptr[esp]
			op_fld_ptr_esp(DEF_SINGLE);

			//fistp dword ptr[esp]
			fpu_cast();
			OpBuffer[obp++]=(char)0xDB;
			OpBuffer[obp++]=(char)0x1C;
			OpBuffer[obp++]=(char)0x24;
			fpu_cast_end();
		}
	}
	else{
		//琮֕ϊ

		if(Is64Type(NewType)){
			ExtendStackTo64(OldType);
		}
		else if(GetTypeSize(NewType,-1)==sizeof(long)){
			ExtendStackTo32(OldType);
		}
		else if(GetTypeSize(NewType,-1)==sizeof(short)){
			ExtendStackTo16(OldType);
		}
		else if(GetTypeSize(NewType,-1)==sizeof(char)){
			ExtendStackTo8(OldType);
		}
	}
}
