#include "stdafx.h"

#ifdef _AMD64_
#include "../../BasicCompiler64/opcode.h"
#else
#include "../../BasicCompiler32/opcode.h"
#endif

#include <Exception.h>

namespace Exception{

class TryScope
{
public:
	const PertialSchedule *pPertialScheduleForCatchAddress;
	TryScope()
	{
	}
	~TryScope()
	{
	}

	void RegistPertialScheduleForCatchAddress( const PertialSchedule *pPertialScheduleForCatchAddress )
	{
		this->pPertialScheduleForCatchAddress = pPertialScheduleForCatchAddress;
	}

	void AddCatch()
	{
	}

	void EndTry()
	{
	}
};
typedef std::vector<TryScope> TryScopes;

TryScopes tryScopes;

void TryCommand()
{
	if( UserProc::IsGlobalAreaCompiling() )
	{
		SetError();
	}

	tryScopes.push_back( TryScope() );

	int backCp = cp;

	char temporary[1024];
	lstrcpy( temporary, "ExceptionService.BeginTryScope( _System_GetNowScopeCatchAddresses() As VoidPtr, _System_GetBp() As LONG_PTR, _System_GetSp() As LONG_PTR )" );
	MakeMiddleCode( temporary );
	ChangeOpcode( temporary );

	cp = backCp;
}
void CatchCommand()
{
	if( tryScopes.size() == 0 )
	{
		SetError(1,NULL,cp);
		return;
	}

	compiler.codeGenerator.opfix( tryScopes.back().pPertialScheduleForCatchAddress, compiler.codeGenerator.GetNativeCodeSize() );
}
void FinallyCommand()
{
}
void EndTryCommand()
{
	if( tryScopes.size() == 0 )
	{
		SetError(1,NULL,cp);
		return;
	}

	int backCp = cp;

	char temporary[1024];
	lstrcpy( temporary, "_System_pobj_AllThreads->GetCurrentException()->EndTryScope()" );
	MakeMiddleCode( temporary );
	ChangeOpcode( temporary );

	cp = backCp;

	tryScopes.pop_back();
}

void ThrowCommand( const char *Parameter )
{
	int backCp = cp;

	char temporary[1024];
	lstrcpy( temporary, "_System_pobj_AllThreads->GetCurrentException()->_Throw()" );
	MakeMiddleCode( temporary );
	ChangeOpcode( temporary );

	cp = backCp;
}

void Opcode_Func_System_GetNowScopeCatchAddress()
{
	if( tryScopes.size() == 0 )
	{
		SetError(1,NULL,cp);
		return;
	}

#ifdef _WIN64
	//mov rax,catchAddress
	const PertialSchedule *pPertialSchedule = compiler.codeGenerator.op_mov_RV( sizeof(long), REG_RAX, 0, Schedule::CatchAddress, true );
#else
	//mov eax,catchAddress
	const PertialSchedule *pPertialSchedule = compiler.codeGenerator.op_mov_RV( REG_EAX, 0, Schedule::CatchAddress, true );
#endif

	tryScopes.back().RegistPertialScheduleForCatchAddress( pPertialSchedule );

	/*
	int dataTableOffset = compiler.GetObjectModule().dataTable.Add( static_cast<LONG_PTR>(0) );

#ifdef _WIN64
	//mov rax,dataTableOffset
	compiler.codeGenerator.op_mov_RV( sizeof(_int64), REG_RAX, dataTableOffset, Schedule::DataTable);
#else
	//mov eax,dataTableOffset
	compiler.codeGenerator.op_mov_RV( REG_EAX, dataTableOffset, Schedule::DataTable);
#endif
	*/
}


}	// Exception
