#include "stdafx.h"

#include <jenga/include/common/Environment.h>
#include <jenga/include/common/Path.h>
#include <jenga/include/common/Directory.h>

#include <jenga/include/smoothie/Smoothie.h>

#include <Class.h>
#include <Compiler.h>

#include <../Enum.h>

#include "../BasicCompiler_Common/common.h"
#include "../BasicCompiler_Common/DebugSection.h"
#include "Opcode.h"


////////////////////////////
// ֐̍\̃|C^
////////////////////////////

// O[o֐AÓI\bh
const UserProc
	*pSub_System_StartupProgram,
	*pSub_System_GlobalArea,
	*pSub_DebugSys_StartProc,
	*pSub_DebugSys_EndProc,
	*pSub_DebugSys_SaveContext,
	*pSub_System_GetEip,
	*pSub_System_InitDllGlobalVariables,
	*pSub_System_InitStaticLocalVariables,
	*pSub_System_Call_Destructor_of_GlobalObject,
	*pSub_System_End,
	*pSub_System_GetSp,
	*pSub_pow,
	*pSub_calloc,
	*pSub_realloc,
	*pSub_free,
	*pSub_System_GC_malloc_ForObject,
	*pSub_System_GC_malloc_ForObjectPtr,
	*pSub_System_GC_free_for_SweepingDelete,
	*pSubStaticMethod_System_TypeBase_InitializeUserTypes,
	*pSubStaticMethod_System_TypeBase_InitializeUserTypesForBaseType;

// I\bh
const UserProc
	*pUserProc_System_CGarbageCollection_RegisterGlobalRoots;


//////////////////////////////
// eZNV̈ʒuƃTCY
int FileSize_CodeSection,
	FileSize_ExportSection,
	FileSize_ImportSection,
	FileSize_DataSection,
	FileSize_RWSection,
	FileSize_RSrcSection,
	FileSize_RelocSection,
	FileSize_DebugSection;
int FilePos_CodeSection,
	FilePos_ExportSection,
	FilePos_ImportSection,
	FilePos_DataSection,
	FilePos_RWSection,
	FilePos_RSrcSection,
	FilePos_RelocSection,
	FilePos_DebugSection;
int MemSize_CodeSection,
	MemSize_ExportSection,
	MemSize_ImportSection,
	MemSize_DataSection,
	MemSize_RWSection,
	MemSize_RSrcSection,
	MemSize_RelocSection,
	MemSize_DebugSection;
int MemPos_CodeSection,
	MemPos_ExportSection,
	MemPos_ImportSection,
	MemPos_DataSection,
	MemPos_RWSection,
	MemPos_RSrcSection,
	MemPos_RelocSection,
	MemPos_DebugSection;
int bUse_CodeSection,
	bUse_ExportSection,
	bUse_ImportSection,
	bUse_DataSection,
	bUse_RWSection,
	bUse_RSrcSection,
	bUse_RelocSection,
	bUse_DebugSection;


void Compile(void){
	extern HWND hMainDlg;
	extern HWND hOwnerEditor;
	extern HANDLE hHeap;
	extern BOOL bDebugCompile;
	extern DWORD ImageBase;
	extern int obp_AllocSize;
	extern char *basbuf;
	extern char OutputFileName[MAX_PATH];
	int i,i2,i3,i4,i5;
	char temporary[MAX_PATH],*temp2;
	HANDLE hFile;


	//R[hZNṼ̈ʒu
	MemPos_CodeSection=		0x1000;

	//f[^ZNṼ̈ʒuij
	MemPos_DataSection=		0x10000000;


	//GNX|[g ZNV𗘗p邩ǂ
	if( compiler.IsDll() ) bUse_ExportSection=1;
	else bUse_ExportSection=0;


	// ÓIN
	compiler.StaticLink( compiler.staticLibraries );


	//////////////////
	// f[^e[u
	if(bDebugCompile){
		compiler.GetObjectModule().dataTable.Add( (long)0x00000002 );
	}


	//////////////////////
	// R[hȌ
	//////////////////////

	//dG[Ǘ̃mہiO[öRpCpj
	extern char **SynonymErrorWords;
	extern int SynonymErrorNum;
	SynonymErrorNum=0;
	SynonymErrorWords=(char **)HeapAlloc(hHeap,0,1);

	//񋓑̂ɊւW
	CEnumParent::InitEnum();

	//񋓑̂NXR[h𐶐
	char *temp;
	temp=CEnumParent::GenerateSourceCode();
	AddSourceCode(temp);
	HeapDefaultFree(temp);

	// Oԏ擾
	NamespaceSupporter::CollectNamespaces(
		compiler.GetObjectModule().GetCurrentSource().GetBuffer(),
		compiler.GetObjectModule().meta.GetNamespaces()
	);

	// fQ[gɊւW
	{
		compiler.GetObjectModule().meta.GetDelegates().Collect(
			compiler.GetObjectModule().GetCurrentSource()
		);
		compiler.GetObjectModule().meta.GetDelegates().Iterator_Init();

		// fQ[gNXR[h𐶐
		std::string tempSource;
		compiler.GetObjectModule().meta.GetDelegates().GenerateSourceCode( tempSource );
		AddSourceCode( tempSource.c_str() );
	}

	//NX擾iڍ׏GetAllClassInfoŎ擾j
	//   CollectProcedures֐̒ŎQƂIuWFNgOɎ擾B
	//     IuWFNg̓e܂ł͎擾Ȃ
	compiler.GetObjectModule().meta.GetClasses().CollectClassesForNameOnly( compiler.GetObjectModule().GetCurrentSource() );

	//TypeDef
	compiler.GetObjectModule().meta.GetTypeDefs().CollectTypeDefs();

	//萔擾
	GetConstInfo();

	//Tu[`i[U[`ADLL֐j̎ʎqAAhX擾
	compiler.pCompilingClass = NULL;
	CollectProcedures(
		compiler.GetObjectModule().GetCurrentSource(),
		compiler.GetObjectModule().meta.GetUserProcs(),
		compiler.GetObjectModule().meta.GetDllProcs()
	);

	// NX擾i - CollectProcedurešɌĂяoj
	compiler.GetObjectModule().meta.GetClasses().GetAllClassInfo();

	// Tu[`i[U[`ADLL֐j̃Ce[^̏
	compiler.GetObjectModule().meta.GetUserProcs().Iterator_Init();
	compiler.GetObjectModule().meta.GetDllProcs().Iterator_Init();


	//R[hƍsԍ̊֌W
	extern SourceLines oldSourceLines;
	oldSourceLines.clear();


	///////////////////////////
	// ŒKvȊ֐擾
	///////////////////////////
	cp=-1;

	if(pSub_System_StartupProgram=GetSubHash("_System_StartupProgram",1))
		pSub_System_StartupProgram->Using();

	if(pSub_System_GlobalArea=GetSubHash(compiler.globalAreaProcName.c_str(),1))
	{
		pSub_System_GlobalArea->Using();
		pSub_System_GlobalArea->ThisIsAutoGenerationProc();
	}

	if(pSub_DebugSys_StartProc=GetSubHash("_DebugSys_StartProc",1))
		pSub_DebugSys_StartProc->Using();

	if(pSub_DebugSys_EndProc=GetSubHash("_DebugSys_EndProc",1))
		pSub_DebugSys_EndProc->Using();

	if(pSub_DebugSys_SaveContext=GetSubHash("_DebugSys_SaveContext",1))
		pSub_DebugSys_SaveContext->Using();

	if(pSub_System_GetEip=GetSubHash("_System_GetEip",1)){
		pSub_System_GetEip->Using();
		pSub_System_GetEip->ThisIsSystemProc();
	}

	if(pSub_System_InitDllGlobalVariables=GetSubHash("_System_InitDllGlobalVariables",1)){
		pSub_System_InitDllGlobalVariables->Using();
		pSub_System_InitDllGlobalVariables->ThisIsSystemProc();
	}

	if(pSub_System_InitStaticLocalVariables=GetSubHash("_System_InitStaticLocalVariables",1)){
		pSub_System_InitStaticLocalVariables->Using();
		pSub_System_InitStaticLocalVariables->ThisIsSystemProc();
	}

	if(pSub_System_Call_Destructor_of_GlobalObject=GetSubHash("_System_Call_Destructor_of_GlobalObject",1)){
		pSub_System_Call_Destructor_of_GlobalObject->Using();
		pSub_System_Call_Destructor_of_GlobalObject->ThisIsSystemProc();
	}

	if(pSub_System_End=GetSubHash("_System_End",1)){
		pSub_System_End->Using();
	}

	if(pSub_System_GetSp=GetSubHash("_System_GetSp",1)){
		pSub_System_GetSp->Using();
		pSub_System_GetSp->ThisIsSystemProc();
	}

	if(pSub_pow=GetSubHash("pow",1))
		pSub_pow->Using();

	if(pSub_calloc=GetSubHash("calloc",1))
		pSub_calloc->Using();

	if(pSub_realloc=GetSubHash("realloc",1))
		pSub_realloc->Using();

	if(pSub_free=GetSubHash("free",1))
		pSub_free->Using();

	if( pSub_System_GC_malloc_ForObject = GetSubHash( "_System_GC_malloc_ForObject",1 ) )
		pSub_System_GC_malloc_ForObject->Using();

	if( pSub_System_GC_malloc_ForObjectPtr = GetSubHash( "_System_GC_malloc_ForObjectPtr",1 ) )
		pSub_System_GC_malloc_ForObjectPtr->Using();

	if( pSub_System_GC_free_for_SweepingDelete = GetSubHash( "_System_GC_free_for_SweepingDelete",1 ) )
		pSub_System_GC_free_for_SweepingDelete->Using();

	if( pSubStaticMethod_System_TypeBase_InitializeUserTypes = GetSubHash( "ActiveBasic.Core._System_TypeBase.InitializeUserTypes",1 ) ){
		pSubStaticMethod_System_TypeBase_InitializeUserTypes->Using();
		pSubStaticMethod_System_TypeBase_InitializeUserTypes->ThisIsAutoGenerationProc();
	}

	if( pSubStaticMethod_System_TypeBase_InitializeUserTypesForBaseType = GetSubHash( "ActiveBasic.Core._System_TypeBase.InitializeUserTypesForBaseType",1 ) ){
		pSubStaticMethod_System_TypeBase_InitializeUserTypesForBaseType->Using();
		pSubStaticMethod_System_TypeBase_InitializeUserTypesForBaseType->ThisIsAutoGenerationProc();
	}

	if( pUserProc_System_CGarbageCollection_RegisterGlobalRoots = GetClassMethod( "_System_CGarbageCollection", "RegisterGlobalRoots" ) ){
		pUserProc_System_CGarbageCollection_RegisterGlobalRoots->Using();
		pUserProc_System_CGarbageCollection_RegisterGlobalRoots->ThisIsAutoGenerationProc();
	}

	//P[V
	pobj_Reloc=new CReloc();

	//WX^̃ubLOǗ邽߂̃IuWFNg𐶐
	pobj_BlockReg=new CBlockReg;

	//LVJXR[v
	compiler.codeGenerator.lexicalScopes.Init(0);


	/////////////////////////////////////////////////////////////////
	// fobORpCp̃O𐶐
	/////////////////////////////////////////////////////////////////
#ifdef _DEBUG
	{
		ofstream ofs("middle_code.txt");
		ofs << basbuf << endl;
		ofs.close();
	}
#endif


	//////////////////////
	// O[os̈
	//////////////////////

	cp=-1;
	UserProc::CompileStartForGlobalArea();

	if( !compiler.IsDll() ){
		// OԂĂ邩`FbN
		if( compiler.GetNamespaceSupporter().GetLivingNamespaceScopes().size() ){
			SetError();
		}

		//xǗIuWFNg
		compiler.codeGenerator.gotoLabels.clear();

		//GotoxXPW[
		compiler.codeGenerator.gotoLabelSchedules.clear();

		//With̃m
		extern WITHINFO WithInfo;
		WithInfo.ppName=(char **)HeapAlloc(hHeap,0,1);
		WithInfo.pWithCp=(int *)HeapAlloc(hHeap,0,1);
		WithInfo.num=0;

		//ContinueAhX
		compiler.codeGenerator.ClearContinueArea();

		//X^bNt[ǗpNXI
		pobj_sf=new StackFrame();

		// R[hΏۂI
		compiler.codeGenerator.Select( compiler.GetObjectModule().globalNativeCode );

		trace_for_sourcecodestep( " O[ö̃RpCJn" );


		//
		//breakpoint;

		if( compiler.IsCore() )
		{
			//sub rsp,X^bNt[TCY
			compiler.codeGenerator.op_sub_RV( sizeof(_int64), REG_RSP, 0x108 );

			if(bDebugCompile){
				//fobOp̕ϐ`
				DebugVariable();
			}

			//GCp̕ϐ`
			InitGCVariables();

			//_System_StartupProgram̌Ăяo
			compiler.codeGenerator.op_call(pSub_System_StartupProgram);
		}

		// _System_GlobalArea ̌Ăяo
		compiler.codeGenerator.op_call( pSub_System_GlobalArea );


		if( !compiler.IsStaticLibrary() )
		{
			///////////////////////////////////////
			// O[oϐ̉
			///////////////////////////////////////

			//call _System_End
			extern const UserProc *pSub_System_End;
			compiler.codeGenerator.op_call(pSub_System_End);


			//add rsp,X^bNt[TCY
			compiler.codeGenerator.op_add_RV( REG_RSP, 0x108 );

			//xor rax,raxirax0ɏj
			compiler.codeGenerator.op_zero_reg(REG_RAX);

			//ret
			compiler.codeGenerator.op_ret();
		}

		//X^bNt[XPW[s
		pobj_sf->RunningSchedule( 0x100 );
		delete pobj_sf;
		pobj_sf=0;

		//O[os̈̃R[hTCY
		extern int GlobalOpBufferSize;
		GlobalOpBufferSize = compiler.linker.GetNativeCode().GetSize();

		//With̃
		for(i=0;i<WithInfo.num;i++){
			SetError(22,"With",WithInfo.pWithCp[i]);
			HeapDefaultFree(WithInfo.ppName[i]);
		}
		HeapDefaultFree(WithInfo.ppName);
		HeapDefaultFree(WithInfo.pWithCp);

		// OԂĂ邩`FbN
		if( compiler.GetNamespaceSupporter().GetLivingNamespaceScopes().size() ){
			SetError(63,NULL,-1);
		}

	}
	else{
		////////////////
		// DLL̏ꍇ
		////////////////


	}

	//dG[Ǘ̃iO[öpj
	for(i=0;i<SynonymErrorNum;i++) HeapDefaultFree(SynonymErrorWords[i]);
	HeapDefaultFree(SynonymErrorWords);


	StepCompileProgress();


	/////////////////////
	// [Js̈
	/////////////////////

	//vV[WRpCJn
	cp=0;
	CompileLocal();

	// I
	///////////////////////

	StepCompileProgress();


	//WX^̃ubLOǗ邽߂̃IuWFNgj
	delete pobj_BlockReg;

	//lCeBuR[h͂܂
	//////////////////////////////////////////////////////////



	trace( "R[hI܂B" );


	if( compiler.IsStaticLibrary() )
	{
		// ÓINCu

		// i[fBNg
		Jenga::Common::Path path( OutputFileName );
		Jenga::Common::Directory dir( path.GetDriveName() + path.GetDirName(), true );

		// 
		if( !compiler.GetObjectModule().Write( OutputFileName ) )
		{
			MessageBox(0,"XML݂Ɏs","test",0);
		}
		return;
	}

	extern BOOL bError;
	if( !bError )
	{
		CompileMessage( "N..." );
	}


	compiler.linker.Link( compiler.GetObjectModule() );

	extern SourceLines oldSourceLines;
	oldSourceLines = compiler.linker.GetNativeCode().GetSourceLines();


	/////////////////////////////////////////////////////////////////
	// vtbl̍\z
	/////////////////////////////////////////////////////////////////

	compiler.GetObjectModule().meta.GetClasses().GenerateVTables();



	////////////////////////////////
	// ňUO
	////////////////////////////////
	Diagnose();



	////////////////////////////////
	// gpDLL֐̃`FbN
	////////////////////////////////
	compiler.GetObjectModule().meta.GetDllProcs().Iterator_Reset();
	while( compiler.GetObjectModule().meta.GetDllProcs().Iterator_HasNext() )
	{
		const DllProc *pDllProc = compiler.GetObjectModule().meta.GetDllProcs().Iterator_GetNext();

		if( !pDllProc->IsUsing() ){
			continue;
		}
/*
		//G[`FbN
		HINSTANCE hLib;
		hLib=LoadLibrary( pDllProc->GetDllFileName().c_str() );
		if(!hLib){
			extern char OutputFileName[MAX_PATH];
			char temp2[MAX_PATH],temp3[MAX_PATH];
			_splitpath(OutputFileName,temp2,temp3,NULL,NULL);
			lstrcat(temp2,temp3);
			lstrcpy(temp3,pDllProc->GetDllFileName().c_str());
			GetFullPath(temp3,temp2);
			hLib=LoadLibrary(temp3);

			if(!hLib){
				SetError(-106,pDllProc->GetDllFileName().c_str(),pDllProc->GetCodePos());
			}
		}

		if(hLib){
			if(!GetProcAddress(hLib,pDllProc->GetAlias().c_str())){
				FreeLibrary(hLib);
				SetError(-107,pDllProc->GetAlias(),pDllProc->GetCodePos());
			}
			FreeLibrary(hLib);
		}
*/
	}



	/////////////////////////////
	// \[Xf[^ǂݍ
	/////////////////////////////
	extern char ResourceFileName[MAX_PATH];
	GetResourceData(ResourceFileName);


	//////////////////////////////
	// GNX|[giDLL̂݁j
	//////////////////////////////
	IMAGE_EXPORT_DIRECTORY ImageExportDirectory;
	DWORD *lpdwExportAddressTable;
	DWORD *lpdwExportNamePointerTable;
	WORD *lpwExportOrdinalTable;
	char lpExportNames[8192];
	int ExportNamesLength;
	int ExportNum;
	int DllMain_EntryPoint;

	DllMain_EntryPoint=-1;
	ExportNum=0;
	ExportNamesLength=0;
	lpdwExportAddressTable=(DWORD *)HeapAlloc(hHeap,0,1);
	lpdwExportNamePointerTable=(DWORD *)HeapAlloc(hHeap,0,1);
	lpwExportOrdinalTable=(WORD *)HeapAlloc(hHeap,0,1);

	if(bUse_ExportSection){
		_splitpath(OutputFileName,NULL,NULL,lpExportNames,temporary);
		lstrcat(lpExportNames,temporary);
		ExportNamesLength=lstrlen(lpExportNames)+1;

		UserProc *pUserProc,*psi2;
		while(1){
			//ɃT[`
			temporary[0]=0;
			compiler.GetObjectModule().meta.GetUserProcs().Iterator_Reset();
			while( compiler.GetObjectModule().meta.GetUserProcs().Iterator_HasNext() )
			{
				pUserProc = compiler.GetObjectModule().meta.GetUserProcs().Iterator_GetNext();
				if(pUserProc->IsExport()){
					if(temporary[0]=='\0'){
						lstrcpy(temporary,pUserProc->GetName().c_str());
						psi2=pUserProc;
					}
					else{
						i3=lstrlen(temporary);
						i4=(int)pUserProc->GetName().size();
						if(i3<i4) i3=i4;
						if(memcmp(temporary,pUserProc->GetName().c_str(),i3)>0){
							lstrcpy(temporary,pUserProc->GetName().c_str());
							psi2=pUserProc;
						}
					}
				}
			}
			if(psi2==0) break;
			pUserProc=psi2;

			pUserProc->ExportOff();

			if( pUserProc->GetName() == "DllMain" ){
				DllMain_EntryPoint = pUserProc->GetBeginOpAddress();
			}

			lpdwExportAddressTable=(DWORD *)HeapReAlloc(hHeap,0,lpdwExportAddressTable,(ExportNum+1)*sizeof(DWORD));
			lpdwExportAddressTable[ExportNum] = pUserProc->GetBeginOpAddress();

			lpdwExportNamePointerTable=(DWORD *)HeapReAlloc(hHeap,0,lpdwExportNamePointerTable,(ExportNum+1)*sizeof(DWORD));
			lpdwExportNamePointerTable[ExportNum]=ExportNamesLength;

			lpwExportOrdinalTable=(WORD *)HeapReAlloc(hHeap,0,lpwExportOrdinalTable,(ExportNum+1)*sizeof(WORD));
			lpwExportOrdinalTable[ExportNum]=ExportNum;

			lstrcpy(lpExportNames+ExportNamesLength,pUserProc->GetName().c_str());
			ExportNamesLength+=lstrlen(lpExportNames+ExportNamesLength)+1;

			ExportNum++;
		}
		for(i=0;i<ExportNum;i++){
			lpdwExportNamePointerTable[i]+=
				sizeof(IMAGE_EXPORT_DIRECTORY)+	//GNX|[gfBNge[uщz
				ExportNum*sizeof(DWORD)+		//GNX|[g AhX e[uщz
				ExportNum*sizeof(DWORD)+		//GNX|[g|C^ e[uщz
				ExportNum*sizeof(WORD);			//GNX|[ge[uщz
		}

		ImageExportDirectory.Characteristics=0;
		ImageExportDirectory.TimeDateStamp=(DWORD)time(NULL);
		ImageExportDirectory.MajorVersion=0;
		ImageExportDirectory.MinorVersion=0;
		ImageExportDirectory.Name=sizeof(IMAGE_EXPORT_DIRECTORY)+
			ExportNum*sizeof(DWORD)+	//GNX|[g AhX e[uщz
			ExportNum*sizeof(DWORD)+	//GNX|[g|C^ e[uщz
			ExportNum*sizeof(WORD);		//GNX|[ge[uщz
		ImageExportDirectory.Base=1;
		ImageExportDirectory.NumberOfFunctions=ExportNum;
		ImageExportDirectory.NumberOfNames=ExportNum;
		ImageExportDirectory.AddressOfFunctions=sizeof(IMAGE_EXPORT_DIRECTORY);
		ImageExportDirectory.AddressOfNames=ImageExportDirectory.AddressOfFunctions+ExportNum*sizeof(DWORD);
		ImageExportDirectory.AddressOfNameOrdinals=ImageExportDirectory.AddressOfNames+ExportNum*sizeof(DWORD);
	}


	/////////////////////
	//C|[gDLL
	/////////////////////

	/*
	C|[g AhX e[uibNAbvƓeAvOsɎsAhXɏj
	bNAbv e[uiqgRVAj
	IMAGE_IMPORT_DESCRIPTOR1[size=0x14]	C|[gwb_
	IMAGE_IMPORT_DESCRIPTOR2[size=0x14]
	IMAGE_IMPORT_DESCRIPTOR3[size=0x14]
	...
	Dll1[size=0x10]
	Dll2[size=0x10]
	Dll3[size=0x10]
	...
	qge[ui֐𗅗񂵂́j
	*/

	/*
	IMAGE_IMPORT_DESCRIPTOR1[size=0x14]	C|[gwb_
	IMAGE_IMPORT_DESCRIPTOR2[size=0x14]
	IMAGE_IMPORT_DESCRIPTOR3[size=0x14]
	...
	Dll1[size=0x10]
	Dll2[size=0x10]
	Dll3[size=0x10]
	...
	bNAbv e[uiqgRVAj
	qge[u
	C|[g AhX e[uibNAbvƓeAvOsɎsAhXɏj
	*/

	char **ppDllNames=(char **)HeapAlloc(hHeap,0,1);

	int ImportDllNum=0;

	compiler.GetObjectModule().meta.GetDllProcs().Iterator_Reset();
	while( compiler.GetObjectModule().meta.GetDllProcs().Iterator_HasNext() )
	{
		const DllProc *pDllProc = compiler.GetObjectModule().meta.GetDllProcs().Iterator_GetNext();

		if( !pDllProc->IsUsing() ){
			continue;
		}

		if( pDllProc->GetDllFileName().size() > 16 ){
			SetError(7,NULL,cp);
			break;
		}
		for(i2=0;i2<ImportDllNum;i2++){
			if( pDllProc->GetDllFileName() == ppDllNames[i2] ){
				break;
			}
		}
		if(i2==ImportDllNum){
			ppDllNames=(char **)HeapReAlloc(hHeap,0,ppDllNames,(ImportDllNum+1)*sizeof(char **));
			ppDllNames[ImportDllNum]=(char *)HeapAlloc(hHeap,HEAP_ZERO_MEMORY,16);
			lstrcpy(ppDllNames[ImportDllNum],pDllProc->GetDllFileName().c_str());
			ImportDllNum++;
		}
	}

	//IMAGE_IMPORT_DESCRIPTORAyуbNAbv e[u TCY̌vZ
	IMAGE_IMPORT_DESCRIPTOR *pImportDescriptor;
	int LookupSize;
	LookupSize=0;
	pImportDescriptor=(IMAGE_IMPORT_DESCRIPTOR *)HeapAlloc(hHeap,0,(ImportDllNum+1)*sizeof(IMAGE_IMPORT_DESCRIPTOR));
	for(i=0;i<ImportDllNum;i++){
		//IMAGE_IMPORT_DESCRIPTOR
		pImportDescriptor[i].OriginalFirstThunk=LookupSize;	//ōČvZ
		pImportDescriptor[i].TimeDateStamp=0;
		pImportDescriptor[i].ForwarderChain=0;
		pImportDescriptor[i].Name=i*0x10;	//ōČvZ

		compiler.GetObjectModule().meta.GetDllProcs().Iterator_Reset();
		while( compiler.GetObjectModule().meta.GetDllProcs().Iterator_HasNext() )
		{
			const DllProc *pDllProc = compiler.GetObjectModule().meta.GetDllProcs().Iterator_GetNext();

			if( !pDllProc->IsUsing() ){
				continue;
			}

			if( pDllProc->GetDllFileName() == ppDllNames[i] ){
				//bNAbvf[^̃TCYǉ
				LookupSize+=sizeof(_int64);
			}
		}
		LookupSize+=sizeof(_int64);	//NULLp
	}
	memset(&pImportDescriptor[i],0,sizeof(IMAGE_IMPORT_DESCRIPTOR));
	for(i=0;i<ImportDllNum;i++){
		//C|[gAhXe[u̍ǉ
		pImportDescriptor[i].OriginalFirstThunk+=LookupSize;

		//DLLւ̍ǉ
		pImportDescriptor[i].Name+=
			LookupSize+			//C|[g AhX e[u
			LookupSize+			//bNAbve[u
			(ImportDllNum+1)*sizeof(IMAGE_IMPORT_DESCRIPTOR);	//IMAGE_IMPORT_DESCRIPTOR
	}

	//bNAbv e[uAqg e[u
	unsigned _int64 *pLookupTable;
	pLookupTable=(unsigned _int64 *)HeapAlloc(hHeap,0,LookupSize*sizeof(_int64)+1);
	char *pHintTable;
	int HintSize,HintAllocSize;
	HintSize=0;
	HintAllocSize=128*2;
	pHintTable=(char *)HeapAlloc(hHeap,0,HintAllocSize);
	for(i=0,i5=0;i<ImportDllNum;i++){
		compiler.GetObjectModule().meta.GetDllProcs().Iterator_Reset();
		while( compiler.GetObjectModule().meta.GetDllProcs().Iterator_HasNext() )
		{
			DllProc *pDllProc = compiler.GetObjectModule().meta.GetDllProcs().Iterator_GetNext();

			if( !pDllProc->IsUsing() ){
				continue;
			}

			if( pDllProc->GetDllFileName() == ppDllNames[i] ){
				//bNAbv̈ʒuZbgiɃC|[g AhX e[uɃZbgȂj
				pDllProc->SetLookupAddress( i5*sizeof(_int64) );

				//bNAbv e[u̒lZbg
				pLookupTable[i5++]=
					LookupSize+			//C|[g AhX e[u
					LookupSize+			//bNAbve[u
					(ImportDllNum+1)*sizeof(IMAGE_IMPORT_DESCRIPTOR)+	//IMAGE_IMPORT_DESCRIPTOR
					ImportDllNum*0x10+	//DLL̗
					HintSize;			//qgւ̃ItZbg

				//qg e[u
				pHintTable[HintSize++]=0;
				pHintTable[HintSize++]=0;
				lstrcpy(pHintTable+HintSize,pDllProc->GetAlias().c_str());
				i4=(int)pDllProc->GetAlias().size();
				HintSize+=i4+1;
				if(i4%2==0) pHintTable[HintSize++]=0;

				if(HintAllocSize<HintSize+128){
					HintAllocSize+=128;
					pHintTable=(char *)HeapReAlloc(hHeap,0,pHintTable,HintAllocSize);
				}
			}
		}
		pLookupTable[i5++]=0;
	}


	if( compiler.IsDll() ){
		//DLL̏ꍇ̓P[V
		//Ȑ͊eZNṼ̃TCY肵ĂēxsB
		pobj_Reloc->ResetRelocBuffer();
	}



	//O[oϐ\̂obt@̗Lɂzus
	//ifobOŗpj
	BOOST_FOREACH( Variable *pVar, compiler.GetObjectModule().meta.GetGlobalVars() ){
		if(pVar->GetOffsetAddress()&0x80000000){
			pVar->SetOffsetAddress(
				(pVar->GetOffsetAddress()&0x7FFFFFFF)
				+ compiler.GetObjectModule().meta.GetGlobalVars().initAreaBuffer.GetSize()
			);
		}
	}



	////////////////////////////////////
	// fobOZNV𐶐
	////////////////////////////////////

	//fobOZNV𐶐
	CDebugSection *pobj_DebugSection;
	pobj_DebugSection=new CDebugSection();
	extern BOOL bDebugCompile;
	extern BOOL bError;
	if(bDebugCompile&&bError==0){
		CompileMessage( "fobO𐶐Ă܂B" );

		pobj_DebugSection->make();

		CompileMessage( "fobO̐܂B" );
	}



	/////////////////////////////////////
	// eZNV̈ʒuƃTCYvZ
	/////////////////////////////////////

	//R[hZbṼt@C̃TCY
	if(compiler.linker.GetNativeCode().GetSize()%FILE_ALIGNMENT)
	{
		FileSize_CodeSection =
			compiler.linker.GetNativeCode().GetSize()
			+ (FILE_ALIGNMENT-compiler.linker.GetNativeCode().GetSize()%FILE_ALIGNMENT);
	}
	else
	{
		FileSize_CodeSection = compiler.linker.GetNativeCode().GetSize();
	}
	if(FileSize_CodeSection) bUse_CodeSection=1;
	else bUse_CodeSection=0;

	//GNX|[gZNṼt@C̃TCY
	i=	sizeof(IMAGE_EXPORT_DIRECTORY)+	//GNX|[gfBNge[uщz
		ExportNum*sizeof(DWORD)+		//GNX|[g AhX e[uщz
		ExportNum*sizeof(DWORD)+		//GNX|[g|C^ e[uщz
		ExportNum*sizeof(WORD)+			//GNX|[ge[uщz
		ExportNamesLength;				//V{obt@
	if(bUse_ExportSection){
		if(i%FILE_ALIGNMENT) FileSize_ExportSection=i+(FILE_ALIGNMENT-i%FILE_ALIGNMENT);
		else FileSize_ExportSection=i;
	}
	else FileSize_ExportSection=0;

	//C|[gZNṼt@C̃TCY
	i=
		LookupSize+			//C|[g AhX e[u
		LookupSize+			//bNAbve[u
		(ImportDllNum+1)*sizeof(IMAGE_IMPORT_DESCRIPTOR)+	//IMAGE_IMPORT_DESCRIPTOR
		ImportDllNum*0x10+	//DLL̗
		HintSize;			//qg
	if(i%FILE_ALIGNMENT) FileSize_ImportSection=i+(FILE_ALIGNMENT-i%FILE_ALIGNMENT);
	else FileSize_ImportSection=i;
	bUse_ImportSection=1;	//C|[gZNV͕K݂

	//f[^ZNṼt@C̃TCY
	if(compiler.GetObjectModule().dataTable.GetSize()%FILE_ALIGNMENT) FileSize_DataSection=compiler.GetObjectModule().dataTable.GetSize()+(FILE_ALIGNMENT-compiler.GetObjectModule().dataTable.GetSize()%FILE_ALIGNMENT);
	else FileSize_DataSection=compiler.GetObjectModule().dataTable.GetSize();
	if(FileSize_DataSection) bUse_DataSection=1;
	else bUse_DataSection=0;

	//C^uZNṼt@C̃TCYiO[oϐ݂̏̂i[j
	if( compiler.GetObjectModule().meta.GetGlobalVars().initAreaBuffer.GetSize() % FILE_ALIGNMENT )
	{
		FileSize_RWSection =
			compiler.GetObjectModule().meta.GetGlobalVars().initAreaBuffer.GetSize()
			+ (FILE_ALIGNMENT-compiler.GetObjectModule().meta.GetGlobalVars().initAreaBuffer.GetSize()%FILE_ALIGNMENT);
	}
	else{
		if( compiler.GetObjectModule().meta.GetGlobalVars().initAreaBuffer.GetSize() )
		{
			FileSize_RWSection = compiler.GetObjectModule().meta.GetGlobalVars().initAreaBuffer.GetSize();
		}
		else FileSize_RWSection=FILE_ALIGNMENT;
	}
	bUse_RWSection=1;

	//\[XZNṼt@C̃TCY
	char *RSrcSectionBuffer;
	int RSrcSectionSize;
	RSrcSectionBuffer=GetRSrcSectionBuffer(&RSrcSectionSize);
	if(RSrcSectionSize%FILE_ALIGNMENT) FileSize_RSrcSection=RSrcSectionSize+(FILE_ALIGNMENT-RSrcSectionSize%FILE_ALIGNMENT);
	else FileSize_RSrcSection=RSrcSectionSize;
	if(FileSize_RSrcSection) bUse_RSrcSection=1;
	else bUse_RSrcSection=0;

	//P[VZNṼt@C̃TCY
	if(pobj_Reloc->length%FILE_ALIGNMENT) FileSize_RelocSection=pobj_Reloc->length+(FILE_ALIGNMENT-pobj_Reloc->length%FILE_ALIGNMENT);
	else FileSize_RelocSection=pobj_Reloc->length;
	if(FileSize_RelocSection) bUse_RelocSection=1;
	else bUse_RelocSection=0;

	//fobOZNṼt@C̃TCY
	if(pobj_DebugSection->length%FILE_ALIGNMENT) FileSize_DebugSection=pobj_DebugSection->length+(FILE_ALIGNMENT-pobj_DebugSection->length%FILE_ALIGNMENT);
	else FileSize_DebugSection=pobj_DebugSection->length;
	if(FileSize_DebugSection) bUse_DebugSection=1;
	else bUse_DebugSection=0;


	//eZbṼt@C̈ʒu
	FilePos_CodeSection=	EXE_HEADER_SIZE;
	FilePos_ExportSection=	FilePos_CodeSection+
							FileSize_CodeSection;
	FilePos_ImportSection=	FilePos_ExportSection+
							FileSize_ExportSection;
	FilePos_DataSection=	FilePos_ImportSection+
							FileSize_ImportSection;
	FilePos_RWSection=		FilePos_DataSection+
							FileSize_DataSection;
	FilePos_RSrcSection=	FilePos_RWSection+
							FileSize_RWSection;
	FilePos_RelocSection=	FilePos_RSrcSection+
							FileSize_RSrcSection;
	FilePos_DebugSection=	FilePos_RelocSection+
							FileSize_RelocSection;

	//R[hZbṼ̃TCY
	if(FileSize_CodeSection%MEM_ALIGNMENT) MemSize_CodeSection=FileSize_CodeSection+(MEM_ALIGNMENT-FileSize_CodeSection%MEM_ALIGNMENT);
	else MemSize_CodeSection=FileSize_CodeSection;

	//GNX|[gZNṼ̃TCY
	if(FileSize_ExportSection%MEM_ALIGNMENT) MemSize_ExportSection=FileSize_ExportSection+(MEM_ALIGNMENT-FileSize_ExportSection%MEM_ALIGNMENT);
	else MemSize_ExportSection=FileSize_ExportSection;

	//C|[gZNṼ̃TCY
	if(FileSize_ImportSection%MEM_ALIGNMENT) MemSize_ImportSection=FileSize_ImportSection+(MEM_ALIGNMENT-FileSize_ImportSection%MEM_ALIGNMENT);
	else MemSize_ImportSection=FileSize_ImportSection;

	//f[^ZNṼ̃TCY
	if(FileSize_DataSection%MEM_ALIGNMENT) MemSize_DataSection=FileSize_DataSection+(MEM_ALIGNMENT-FileSize_DataSection%MEM_ALIGNMENT);
	else MemSize_DataSection=FileSize_DataSection;

	//C^uZNṼ̃TCY
	i = compiler.GetObjectModule().meta.GetGlobalVars().initAreaBuffer.GetSize()
		+ compiler.GetObjectModule().meta.GetGlobalVars().GetAllSize();
	if(i%MEM_ALIGNMENT) MemSize_RWSection=i+(MEM_ALIGNMENT-i%MEM_ALIGNMENT);
	else MemSize_RWSection=i;

	//\[XZNṼ̃TCY
	if(FileSize_RSrcSection%MEM_ALIGNMENT) MemSize_RSrcSection=FileSize_RSrcSection+(MEM_ALIGNMENT-FileSize_RSrcSection%MEM_ALIGNMENT);
	else MemSize_RSrcSection=FileSize_RSrcSection;

	//P[VZNṼ̃TCY
	if(FileSize_RelocSection%MEM_ALIGNMENT) MemSize_RelocSection=FileSize_RelocSection+(MEM_ALIGNMENT-FileSize_RelocSection%MEM_ALIGNMENT);
	else MemSize_RelocSection=FileSize_RelocSection;

	//fobOZNṼ̃TCY
	if(FileSize_DebugSection%MEM_ALIGNMENT) MemSize_DebugSection=FileSize_DebugSection+(MEM_ALIGNMENT-FileSize_DebugSection%MEM_ALIGNMENT);
	else MemSize_DebugSection=FileSize_DebugSection;


	//eZbṼ̈ʒu
	if(bUse_ExportSection)	MemPos_ExportSection=	0x1000+
													MemSize_CodeSection;
	else					MemPos_ExportSection=0;
	if(bUse_ImportSection)	MemPos_ImportSection=	0x1000+
													MemSize_CodeSection+
													MemSize_ExportSection;
	else					MemPos_ImportSection=0;
	if(bUse_DataSection)	MemPos_DataSection=		0x1000+
													MemSize_CodeSection+
													MemSize_ExportSection+
													MemSize_ImportSection;
	else					MemPos_DataSection=0;
	if(bUse_RWSection)		MemPos_RWSection=		0x1000+
													MemSize_CodeSection+
													MemSize_ExportSection+
													MemSize_ImportSection+
													MemSize_DataSection;
	else					MemPos_RWSection=0;
	if(bUse_RSrcSection)	MemPos_RSrcSection=		0x1000+
													MemSize_CodeSection+
													MemSize_ExportSection+
													MemSize_ImportSection+
													MemSize_DataSection+
													MemSize_RWSection;
	else					MemPos_RSrcSection=0;
	if(bUse_RelocSection)	MemPos_RelocSection=	0x1000+
													MemSize_CodeSection+
													MemSize_ExportSection+
													MemSize_ImportSection+
													MemSize_DataSection+
													MemSize_RWSection+
													MemSize_RSrcSection;
	else					MemPos_RelocSection=0;
	if(bUse_DebugSection)	MemPos_DebugSection=	0x1000+
													MemSize_CodeSection+
													MemSize_ExportSection+
													MemSize_ImportSection+
													MemSize_DataSection+
													MemSize_RWSection+
													MemSize_RSrcSection+
													MemSize_RelocSection;
	else					MemPos_DebugSection=0;



	////////////////////////////
	// GNX|[g̍Ĕzu
	////////////////////////////
	if(bUse_ExportSection){
		for(i=0;i<ExportNum;i++){
			lpdwExportAddressTable[i]+=MemPos_CodeSection;
			lpdwExportNamePointerTable[i]+=MemPos_ExportSection;
		}

		ImageExportDirectory.Name+=						MemPos_ExportSection;
		ImageExportDirectory.AddressOfFunctions+=		MemPos_ExportSection;
		ImageExportDirectory.AddressOfNames+=			MemPos_ExportSection;
		ImageExportDirectory.AddressOfNameOrdinals+=	MemPos_ExportSection;
	}


	////////////////////////////
	// C|[g̍Ĕzu
	////////////////////////////
	for(i=0,i5=0;i<ImportDllNum;i++){
		//IMAGE_IMPORT_DESCRIPTOR
		pImportDescriptor[i].OriginalFirstThunk+=MemPos_ImportSection;
		pImportDescriptor[i].Name+=MemPos_ImportSection;

		//C|[g AhX e[uibNAbv e[uj
		pImportDescriptor[i].FirstThunk=pImportDescriptor[i].OriginalFirstThunk-
			LookupSize;			//bNAbve[u

		compiler.GetObjectModule().meta.GetDllProcs().Iterator_Reset();
		while( compiler.GetObjectModule().meta.GetDllProcs().Iterator_HasNext() )
		{
			const DllProc *pDllProc = compiler.GetObjectModule().meta.GetDllProcs().Iterator_GetNext();

			if( !pDllProc->IsUsing() ){
				continue;
			}

			if( pDllProc->GetDllFileName() == ppDllNames[i] ){
				//bNAbv e[u
				pLookupTable[i5++]+=MemPos_ImportSection;
			}
		}
		i5++;
	}


	////////////////////////////////////////
	//z֐f[^e[uXPW[
	compiler.GetObjectModule().meta.GetClasses().ActionVtblSchedule( ImageBase, MemPos_CodeSection, MemPos_DataSection );


	if( compiler.IsDll() ){
		//DLL̏ꍇ̓P[V𐶐
		pobj_Reloc->ResetRelocBuffer();
	}

	compiler.linker.SetDataTable( compiler.GetObjectModule().dataTable );

	compiler.linker.SetImageBase( ImageBase );
	compiler.linker.ResolveDataTableSchedules( MemPos_DataSection );
	compiler.linker.ResolveDllProcSchedules( MemPos_CodeSection, MemPos_ImportSection, LookupSize, HintSize );
	compiler.linker.ResolveUserProcSchedules( MemPos_CodeSection );
	compiler.linker.ResolveGlobalVarSchedules( MemPos_RWSection );
	compiler.linker.ResolveVtblSchedule( MemPos_DataSection );
	compiler.linker.ResolveTypeInfoSchedule( MemPos_DataSection );


	////////////////////////////////
	// \[XAhXXPW[
	extern DWORD *lpdwRSrcAddrSchedule;
	extern int RSrcAddrScheduleNum;
	for(i=0;i<RSrcAddrScheduleNum;i++){
		*(DWORD *)(RSrcSectionBuffer+lpdwRSrcAddrSchedule[i])+=MemPos_RSrcSection;
	}
	HeapDefaultFree(lpdwRSrcAddrSchedule);


	//DosX^u
	char *DosStubBuffer;
	int DosStubSize;
	hFile=CreateFile(
		( Jenga::Common::Environment::GetAppDir() + "\\SubOperation\\dosstub.pgm" ).c_str(),
		GENERIC_READ,0,NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
	if(hFile==INVALID_HANDLE_VALUE){
		MessageBox(hOwnerEditor,"dosstub.pgm̓ǂݍ݂Ɏs","error",MB_OK);
		goto EndWriteOpcode;
	}
	DosStubSize=GetFileSize(hFile,NULL);
	DosStubBuffer=(char *)HeapAlloc(hHeap,0,DosStubSize);
	ReadFile(hFile,DosStubBuffer,DosStubSize,(DWORD *)&i2,NULL);
	CloseHandle(hFile);


	extern BOOL bError;
	if(bError) goto EndWriteOpcode;


	////////////////////////////
	// EXEt@C̃wb_
	////////////////////////////

	IMAGE_DOS_HEADER ImageDosHeader;
	ImageDosHeader.e_magic=	0x5A4D;
	ImageDosHeader.e_cblp=	0x0090;
	ImageDosHeader.e_cp=	0x0003;
	ImageDosHeader.e_crlc=	0;
	ImageDosHeader.e_cparhdr=4;
	ImageDosHeader.e_minalloc=0x0000;
	ImageDosHeader.e_maxalloc=0xFFFF;
	ImageDosHeader.e_ss=	0x0000;
	ImageDosHeader.e_sp=	0x00B8;
	ImageDosHeader.e_csum=	0x0000;
	ImageDosHeader.e_ip=	0x0000;
	ImageDosHeader.e_cs=	0x0000;
	ImageDosHeader.e_lfarlc=0x0040;
	ImageDosHeader.e_ovno=	0x0000;
	ImageDosHeader.e_res[0]=0;
	ImageDosHeader.e_res[1]=0;
	ImageDosHeader.e_res[2]=0;
	ImageDosHeader.e_res[3]=0;
	ImageDosHeader.e_oemid=	0x0000;
	ImageDosHeader.e_oeminfo=0x0000;
	ImageDosHeader.e_res2[0]=0;
	ImageDosHeader.e_res2[1]=0;
	ImageDosHeader.e_res2[2]=0;
	ImageDosHeader.e_res2[3]=0;
	ImageDosHeader.e_res2[4]=0;
	ImageDosHeader.e_res2[5]=0;
	ImageDosHeader.e_res2[6]=0;
	ImageDosHeader.e_res2[7]=0;
	ImageDosHeader.e_res2[8]=0;
	ImageDosHeader.e_res2[9]=0;
	ImageDosHeader.e_lfanew=0x0100;	//PEwb_̈ʒu


	/////////////////////////////////////////////
	// PEwb_
	/////////////////////////////////////////////

	IMAGE_NT_HEADERS64 ImagePeHdr;
	ImagePeHdr.Signature=IMAGE_NT_SIGNATURE;

	//}V^Cv
	ImagePeHdr.FileHeader.Machine=				IMAGE_FILE_MACHINE_AMD64;

	ImagePeHdr.FileHeader.NumberOfSections=		bUse_CodeSection+
												bUse_ExportSection+
												bUse_ImportSection+
												bUse_DataSection+
												bUse_RWSection+
												bUse_RSrcSection+
												bUse_RelocSection+
												bUse_DebugSection;	//ZNV
	ImagePeHdr.FileHeader.TimeDateStamp=		(DWORD)time(NULL);
	ImagePeHdr.FileHeader.PointerToSymbolTable=	0x00000000;
	ImagePeHdr.FileHeader.NumberOfSymbols=		0x00000000;
	ImagePeHdr.FileHeader.SizeOfOptionalHeader=	IMAGE_SIZEOF_NT_OPTIONAL64_HEADER;
	if( compiler.IsDll() ){
		ImagePeHdr.FileHeader.Characteristics=	IMAGE_FILE_EXECUTABLE_IMAGE|
												IMAGE_FILE_DLL|
												IMAGE_FILE_LARGE_ADDRESS_AWARE;
	}
	else{
		ImagePeHdr.FileHeader.Characteristics=	IMAGE_FILE_RELOCS_STRIPPED|
												IMAGE_FILE_EXECUTABLE_IMAGE|
												IMAGE_FILE_LARGE_ADDRESS_AWARE;
	}

	ImagePeHdr.OptionalHeader.Magic=				IMAGE_NT_OPTIONAL_HDR64_MAGIC;
	ImagePeHdr.OptionalHeader.MajorLinkerVersion=	5;
	ImagePeHdr.OptionalHeader.MinorLinkerVersion=	0;
	ImagePeHdr.OptionalHeader.SizeOfCode=			FileSize_CodeSection;	//R[hTCYi.text̃ZbVTCYj
	ImagePeHdr.OptionalHeader.SizeOfInitializedData=FileSize_DataSection;	//f[^TCYi.datãZbVTCYj
	ImagePeHdr.OptionalHeader.SizeOfUninitializedData=0;					//f[^̃TCYiȂj
	if( compiler.IsDll() ){
		if(DllMain_EntryPoint==-1)
			ImagePeHdr.OptionalHeader.AddressOfEntryPoint=0;
		else
			ImagePeHdr.OptionalHeader.AddressOfEntryPoint=MemPos_CodeSection+DllMain_EntryPoint;
	}
	else ImagePeHdr.OptionalHeader.AddressOfEntryPoint=	MemPos_CodeSection;
	ImagePeHdr.OptionalHeader.BaseOfCode=			MemPos_CodeSection;	//.text̃AhX

	ImagePeHdr.OptionalHeader.ImageBase=			ImageBase;		//C[Wx[X
	ImagePeHdr.OptionalHeader.SectionAlignment=		MEM_ALIGNMENT;		//ZNVACg
	ImagePeHdr.OptionalHeader.FileAlignment=		FILE_ALIGNMENT;
	ImagePeHdr.OptionalHeader.MajorOperatingSystemVersion=4;
	ImagePeHdr.OptionalHeader.MinorOperatingSystemVersion=0;
	ImagePeHdr.OptionalHeader.MajorImageVersion=	0;
	ImagePeHdr.OptionalHeader.MinorImageVersion=	0;
	ImagePeHdr.OptionalHeader.MajorSubsystemVersion=4;
	ImagePeHdr.OptionalHeader.MinorSubsystemVersion=0;
	ImagePeHdr.OptionalHeader.Win32VersionValue=	0;
	ImagePeHdr.OptionalHeader.SizeOfImage=			EXE_HEADER_SIZE+
													MemSize_CodeSection+
													MemSize_ExportSection+
													MemSize_ImportSection+
													MemSize_DataSection+
													MemSize_RWSection+
													MemSize_RSrcSection+
													MemSize_RelocSection+
													MemSize_DebugSection;//ׂẴC[WTCY
	ImagePeHdr.OptionalHeader.SizeOfHeaders=		EXE_HEADER_SIZE;//wb_TCY
	ImagePeHdr.OptionalHeader.CheckSum=				0;
	extern unsigned short TypeOfSubSystem;
	ImagePeHdr.OptionalHeader.Subsystem=			TypeOfSubSystem;
	ImagePeHdr.OptionalHeader.DllCharacteristics=	0;
	ImagePeHdr.OptionalHeader.SizeOfStackReserve=	0x00100000;
	ImagePeHdr.OptionalHeader.SizeOfStackCommit=	0x00001000;
	ImagePeHdr.OptionalHeader.SizeOfHeapReserve=	0x00100000;
	ImagePeHdr.OptionalHeader.SizeOfHeapCommit=		0x00001000;
	ImagePeHdr.OptionalHeader.LoaderFlags=			0;
	ImagePeHdr.OptionalHeader.NumberOfRvaAndSizes=	IMAGE_NUMBEROF_DIRECTORY_ENTRIES;

	//f[^ fBNVi
	ImagePeHdr.OptionalHeader.DataDirectory[0].VirtualAddress=MemPos_ExportSection;
	ImagePeHdr.OptionalHeader.DataDirectory[0].Size=FileSize_ExportSection;
	ImagePeHdr.OptionalHeader.DataDirectory[1].VirtualAddress=	//IMAGE_IMPORT_DESCRIPTORw
		MemPos_ImportSection+
		LookupSize+	//C|[g AhX e[u
		LookupSize;	//bNAbv e[u
	ImagePeHdr.OptionalHeader.DataDirectory[1].Size=(ImportDllNum+1)*sizeof(IMAGE_IMPORT_DESCRIPTOR);
	ImagePeHdr.OptionalHeader.DataDirectory[2].VirtualAddress=MemPos_RSrcSection;
	ImagePeHdr.OptionalHeader.DataDirectory[2].Size=RSrcSectionSize;
	ImagePeHdr.OptionalHeader.DataDirectory[3].VirtualAddress=0;
	ImagePeHdr.OptionalHeader.DataDirectory[3].Size=0;
	ImagePeHdr.OptionalHeader.DataDirectory[4].VirtualAddress=0;
	ImagePeHdr.OptionalHeader.DataDirectory[4].Size=0;
	ImagePeHdr.OptionalHeader.DataDirectory[5].VirtualAddress=MemPos_RelocSection;
	ImagePeHdr.OptionalHeader.DataDirectory[5].Size=pobj_Reloc->length;
	ImagePeHdr.OptionalHeader.DataDirectory[6].VirtualAddress=0;
	ImagePeHdr.OptionalHeader.DataDirectory[6].Size=0;
	ImagePeHdr.OptionalHeader.DataDirectory[7].VirtualAddress=0;
	ImagePeHdr.OptionalHeader.DataDirectory[7].Size=0;
	ImagePeHdr.OptionalHeader.DataDirectory[8].VirtualAddress=0;
	ImagePeHdr.OptionalHeader.DataDirectory[8].Size=0;
	ImagePeHdr.OptionalHeader.DataDirectory[9].VirtualAddress=0;
	ImagePeHdr.OptionalHeader.DataDirectory[9].Size=0;
	ImagePeHdr.OptionalHeader.DataDirectory[10].VirtualAddress=0;
	ImagePeHdr.OptionalHeader.DataDirectory[10].Size=0;
	ImagePeHdr.OptionalHeader.DataDirectory[11].VirtualAddress=0;
	ImagePeHdr.OptionalHeader.DataDirectory[11].Size=0;
	ImagePeHdr.OptionalHeader.DataDirectory[12].VirtualAddress=MemPos_ImportSection;//C|[g AhX e[u
	ImagePeHdr.OptionalHeader.DataDirectory[12].Size=LookupSize;
	ImagePeHdr.OptionalHeader.DataDirectory[13].VirtualAddress=0;
	ImagePeHdr.OptionalHeader.DataDirectory[13].Size=0;
	ImagePeHdr.OptionalHeader.DataDirectory[14].VirtualAddress=0;
	ImagePeHdr.OptionalHeader.DataDirectory[14].Size=0;
	ImagePeHdr.OptionalHeader.DataDirectory[15].VirtualAddress=0;
	ImagePeHdr.OptionalHeader.DataDirectory[15].Size=0;


	//R[hZNVwb_
	IMAGE_SECTION_HEADER CodeSectionHeader;
	memset((char *)CodeSectionHeader.Name,0,IMAGE_SIZEOF_SHORT_NAME);
	lstrcpy((char *)CodeSectionHeader.Name,".text");
	CodeSectionHeader.Misc.VirtualSize=			MemSize_CodeSection;
	CodeSectionHeader.VirtualAddress=			MemPos_CodeSection;	//JnAhX
	CodeSectionHeader.SizeOfRawData=			FileSize_CodeSection;
	CodeSectionHeader.PointerToRawData=			FilePos_CodeSection;	//t@C̊JnAhX
	CodeSectionHeader.PointerToRelocations=		0;
	CodeSectionHeader.PointerToLinenumbers=		0;
	CodeSectionHeader.NumberOfRelocations=		0;
	CodeSectionHeader.NumberOfLinenumbers=		0;
	CodeSectionHeader.Characteristics=			IMAGE_SCN_MEM_EXECUTE|
												IMAGE_SCN_MEM_READ|
												IMAGE_SCN_CNT_CODE;

	//GNX|[gZNVwb_
	IMAGE_SECTION_HEADER ExportSectionHeader;
	memset((char *)ExportSectionHeader.Name,0,IMAGE_SIZEOF_SHORT_NAME);
	lstrcpy((char *)ExportSectionHeader.Name,".edata");
	ExportSectionHeader.Misc.VirtualSize=		MemSize_ExportSection;
	ExportSectionHeader.VirtualAddress=			MemPos_ExportSection;	//JnAhX
	ExportSectionHeader.SizeOfRawData=			FileSize_ExportSection;	//TCY
	ExportSectionHeader.PointerToRawData=		FilePos_ExportSection;	//t@C̊JnAhX
	ExportSectionHeader.PointerToRelocations=	0;
	ExportSectionHeader.PointerToLinenumbers=	0;
	ExportSectionHeader.NumberOfRelocations=	0;
	ExportSectionHeader.NumberOfLinenumbers=	0;
	ExportSectionHeader.Characteristics=		IMAGE_SCN_CNT_INITIALIZED_DATA|
												IMAGE_SCN_MEM_READ;

	//C|[gZNVwb_
	IMAGE_SECTION_HEADER ImportSectionHeader;
	memset((char *)ImportSectionHeader.Name,0,IMAGE_SIZEOF_SHORT_NAME);
	lstrcpy((char *)ImportSectionHeader.Name,".idata");
	ImportSectionHeader.Misc.VirtualSize=
		LookupSize+			//C|[gAhXe[u
		LookupSize+			//bNAbve[u
		(ImportDllNum+1)*sizeof(IMAGE_IMPORT_DESCRIPTOR)+
		16*ImportDllNum+	//DLL
		HintSize;			//qgi֐je[u
	ImportSectionHeader.VirtualAddress=			MemPos_ImportSection;	//JnAhX
	ImportSectionHeader.SizeOfRawData=			FileSize_ImportSection;	//TCY
	ImportSectionHeader.PointerToRawData=		FilePos_ImportSection;	//t@C̊JnAhX
	ImportSectionHeader.PointerToRelocations=	0;
	ImportSectionHeader.PointerToLinenumbers=	0;
	ImportSectionHeader.NumberOfRelocations=	0;
	ImportSectionHeader.NumberOfLinenumbers=	0;
	ImportSectionHeader.Characteristics=		IMAGE_SCN_CNT_INITIALIZED_DATA|
												IMAGE_SCN_MEM_READ;

	//f[^ZNVwb_
	IMAGE_SECTION_HEADER DataSectionHeader;
	memset((char *)DataSectionHeader.Name,0,IMAGE_SIZEOF_SHORT_NAME);
	lstrcpy((char *)DataSectionHeader.Name,".sdata");
	DataSectionHeader.Misc.VirtualSize=			MemSize_DataSection;
	DataSectionHeader.VirtualAddress=			MemPos_DataSection;
	DataSectionHeader.SizeOfRawData=			FileSize_DataSection;
	DataSectionHeader.PointerToRawData=			FilePos_DataSection;
	DataSectionHeader.PointerToRelocations=		0;
	DataSectionHeader.PointerToLinenumbers=		0;
	DataSectionHeader.NumberOfRelocations=		0;
	DataSectionHeader.NumberOfLinenumbers=		0;
	DataSectionHeader.Characteristics=			IMAGE_SCN_CNT_INITIALIZED_DATA|
												IMAGE_SCN_MEM_READ|
												IMAGE_SCN_MEM_WRITE;

	//C^uZNVwb_
	IMAGE_SECTION_HEADER RWSectionHeader;
	memset((char *)RWSectionHeader.Name,0,IMAGE_SIZEOF_SHORT_NAME);
	lstrcpy((char *)RWSectionHeader.Name,".data");
	RWSectionHeader.Misc.VirtualSize=			compiler.GetObjectModule().meta.GetGlobalVars().initAreaBuffer.GetSize()
												+ compiler.GetObjectModule().meta.GetGlobalVars().GetAllSize();
	RWSectionHeader.VirtualAddress=				MemPos_RWSection;
	RWSectionHeader.SizeOfRawData=				FileSize_RWSection;
	RWSectionHeader.PointerToRawData=			FilePos_RWSection;
	RWSectionHeader.PointerToRelocations=		0;
	RWSectionHeader.PointerToLinenumbers=		0;
	RWSectionHeader.NumberOfRelocations=		0;
	RWSectionHeader.NumberOfLinenumbers=		0;
	RWSectionHeader.Characteristics=			IMAGE_SCN_CNT_INITIALIZED_DATA|
												IMAGE_SCN_MEM_READ|
												IMAGE_SCN_MEM_WRITE;

	//\[XZNVwb_
	IMAGE_SECTION_HEADER RSrcSectionHeader;
	memset((char *)RSrcSectionHeader.Name,0,IMAGE_SIZEOF_SHORT_NAME);
	lstrcpy((char *)RSrcSectionHeader.Name,".rsrc");
	RSrcSectionHeader.Misc.VirtualSize=			RSrcSectionSize;
	RSrcSectionHeader.VirtualAddress=			MemPos_RSrcSection;
	RSrcSectionHeader.SizeOfRawData=			FileSize_RSrcSection;
	RSrcSectionHeader.PointerToRawData=			FilePos_RSrcSection;
	RSrcSectionHeader.PointerToRelocations=		0;
	RSrcSectionHeader.PointerToLinenumbers=		0;
	RSrcSectionHeader.NumberOfRelocations=		0;
	RSrcSectionHeader.NumberOfLinenumbers=		0;
	RSrcSectionHeader.Characteristics=			IMAGE_SCN_CNT_INITIALIZED_DATA|
												IMAGE_SCN_MEM_READ;

	//P[VZNVwb_
	IMAGE_SECTION_HEADER RelocSectionHeader;
	memset((char *)RelocSectionHeader.Name,0,IMAGE_SIZEOF_SHORT_NAME);
	lstrcpy((char *)RelocSectionHeader.Name,".reloc");
	RelocSectionHeader.Misc.VirtualSize=		pobj_Reloc->length;
	RelocSectionHeader.VirtualAddress=			MemPos_RelocSection;	//JnAhX
	RelocSectionHeader.SizeOfRawData=			FileSize_RelocSection;	//TCY
	RelocSectionHeader.PointerToRawData=		FilePos_RelocSection;	//t@C̊JnAhX
	RelocSectionHeader.PointerToRelocations=	0;
	RelocSectionHeader.PointerToLinenumbers=	0;
	RelocSectionHeader.NumberOfRelocations=		0;
	RelocSectionHeader.NumberOfLinenumbers=		0;
	RelocSectionHeader.Characteristics=			IMAGE_SCN_CNT_INITIALIZED_DATA|
												IMAGE_SCN_MEM_DISCARDABLE|
												IMAGE_SCN_MEM_READ;

	//fobOZNVwb_
	IMAGE_SECTION_HEADER DebugSectionHeader;
	memset((char *)DebugSectionHeader.Name,0,IMAGE_SIZEOF_SHORT_NAME);
	lstrcpy((char *)DebugSectionHeader.Name,".debug");
	DebugSectionHeader.Misc.VirtualSize=		pobj_DebugSection->length;
	DebugSectionHeader.VirtualAddress=			MemPos_DebugSection;	//JnAhX
	DebugSectionHeader.SizeOfRawData=			FileSize_DebugSection;	//TCY
	DebugSectionHeader.PointerToRawData=		FilePos_DebugSection;	//t@C̊JnAhX
	DebugSectionHeader.PointerToRelocations=	0;
	DebugSectionHeader.PointerToLinenumbers=	0;
	DebugSectionHeader.NumberOfRelocations=		0;
	DebugSectionHeader.NumberOfLinenumbers=		0;
	DebugSectionHeader.Characteristics=			IMAGE_SCN_MEM_DISCARDABLE|
												IMAGE_SCN_MEM_READ;


	hFile=CreateFile(OutputFileName,GENERIC_WRITE,0,NULL,CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL,NULL);
	if(hFile==INVALID_HANDLE_VALUE){
		SetError(53,OutputFileName,-1);
		goto EndWriteOpcode;
	}

	//wb_
	WriteFile(hFile,(void *)&ImageDosHeader,sizeof(IMAGE_DOS_HEADER),(DWORD *)&i2,NULL);
	i=i2;

	//DosX^u
	WriteFile(hFile,DosStubBuffer,DosStubSize,(DWORD *)&i2,NULL);
	i+=i2;

	//0x0100܂NULLׂ
	temp2=(char *)HeapAlloc(hHeap,HEAP_ZERO_MEMORY,0x0100-i);
	WriteFile(hFile,temp2,0x0100-i,(DWORD *)&i2,NULL);
	HeapDefaultFree(temp2);
	i+=i2;

	//PEwb_
	WriteFile(hFile,&ImagePeHdr,sizeof(IMAGE_NT_HEADERS64),(DWORD *)&i2,NULL);
	i+=i2;

	//R[h ZNV wb_
	WriteFile(hFile,&CodeSectionHeader,sizeof(IMAGE_SECTION_HEADER),(DWORD *)&i2,NULL);
	i+=i2;

	if(bUse_ExportSection){
		//GNX|[g ZNV wb_
		WriteFile(hFile,&ExportSectionHeader,sizeof(IMAGE_SECTION_HEADER),(DWORD *)&i2,NULL);
		i+=i2;
	}
	if(bUse_ImportSection){
		//C|[g ZNV wb_
		WriteFile(hFile,&ImportSectionHeader,sizeof(IMAGE_SECTION_HEADER),(DWORD *)&i2,NULL);
		i+=i2;
	}
	if(bUse_DataSection){
		//f[^ ZNV wb_
		WriteFile(hFile,&DataSectionHeader,sizeof(IMAGE_SECTION_HEADER),(DWORD *)&i2,NULL);
		i+=i2;
	}
	if(bUse_RWSection){
		//C^uZNVwb_
		WriteFile(hFile,&RWSectionHeader,sizeof(IMAGE_SECTION_HEADER),(DWORD *)&i2,NULL);
		i+=i2;
	}
	if(bUse_RSrcSection){
		//\[XZNVwb_
		WriteFile(hFile,&RSrcSectionHeader,sizeof(IMAGE_SECTION_HEADER),(DWORD *)&i2,NULL);
		i+=i2;
	}
	if(bUse_RelocSection){
		//P[VZNVwb_
		WriteFile(hFile,&RelocSectionHeader,sizeof(IMAGE_SECTION_HEADER),(DWORD *)&i2,NULL);
		i+=i2;
	}
	if(bUse_DebugSection){
		//fobOZNVwb_
		WriteFile(hFile,&DebugSectionHeader,sizeof(IMAGE_SECTION_HEADER),(DWORD *)&i2,NULL);
		i+=i2;
	}

	//EXE_HEADER_SIZE܂NULLׂ
	temp2=(char *)HeapAlloc(hHeap,HEAP_ZERO_MEMORY,EXE_HEADER_SIZE-i);
	WriteFile(hFile,temp2,EXE_HEADER_SIZE-i,(DWORD *)&i2,NULL);
	HeapDefaultFree(temp2);
	i+=i2;

	//R[h
	WriteFile(
		hFile,
		compiler.linker.GetNativeCode().GetBuffer(),
		compiler.linker.GetNativeCode().GetSize(),
		(DWORD *)&i2,
		NULL
	);
	i+=i2;

	//FilePos_ExportSection܂NULLׂ
	temp2=(char *)HeapAlloc(hHeap,HEAP_ZERO_MEMORY,FilePos_ExportSection-i);
	WriteFile(hFile,temp2,FilePos_ExportSection-i,(DWORD *)&i2,NULL);
	HeapDefaultFree(temp2);
	i+=i2;

	if(bUse_ExportSection){
		//GNX|[g fBNg e[u
		WriteFile(hFile,&ImageExportDirectory,sizeof(IMAGE_EXPORT_DIRECTORY),(DWORD *)&i2,NULL);
		i+=i2;

		//GNX|[g AhX e[u
		WriteFile(hFile,lpdwExportAddressTable,ExportNum*sizeof(DWORD),(DWORD *)&i2,NULL);
		i+=i2;

		//GNX|[g|C^ e[u
		WriteFile(hFile,lpdwExportNamePointerTable,ExportNum*sizeof(DWORD),(DWORD *)&i2,NULL);
		i+=i2;

		//GNX|[ge[u
		WriteFile(hFile,lpwExportOrdinalTable,ExportNum*sizeof(WORD),(DWORD *)&i2,NULL);
		i+=i2;

		//V{
		WriteFile(hFile,lpExportNames,ExportNamesLength,(DWORD *)&i2,NULL);
		i+=i2;
	}

	//FilePos_ImportSection܂NULLׂ
	temp2=(char *)HeapAlloc(hHeap,HEAP_ZERO_MEMORY,FilePos_ImportSection-i);
	WriteFile(hFile,temp2,FilePos_ImportSection-i,(DWORD *)&i2,NULL);
	HeapDefaultFree(temp2);
	i+=i2;

	if(bUse_ImportSection){
		//C|[g AhX e[u
		WriteFile(hFile,pLookupTable,LookupSize,(DWORD *)&i2,NULL);
		i+=i2;

		//bNAbv e[u
		WriteFile(hFile,pLookupTable,LookupSize,(DWORD *)&i2,NULL);
		i+=i2;

		//C|[g fBNg e[uiNullfBNg e[u܂ށj
		for(i3=0;i3<(ImportDllNum+1);i3++){
			WriteFile(hFile,&pImportDescriptor[i3],sizeof(IMAGE_IMPORT_DESCRIPTOR),(DWORD *)&i2,NULL);
			i+=i2;
		}

		//DLL
		for(i3=0;i3<ImportDllNum;i3++){
			WriteFile(hFile,ppDllNames[i3],16,(DWORD *)&i2,NULL);
			i+=i2;
		}

		//qg e[u
		WriteFile(hFile,pHintTable,HintSize,(DWORD *)&i2,NULL);
		i+=i2;
	}

	//FilePos_DataSection܂NULLׂ
	temp2=(char *)HeapAlloc(hHeap,HEAP_ZERO_MEMORY,FilePos_DataSection-i);
	WriteFile(hFile,temp2,FilePos_DataSection-i,(DWORD *)&i2,NULL);
	HeapDefaultFree(temp2);
	i+=i2;

	if(bUse_DataSection){
		//f[^ e[u
		WriteFile(
			hFile,
			compiler.linker.GetDataTable().GetPtr(),
			compiler.linker.GetDataTable().GetSize(),
			(DWORD *)&i2,
			NULL
		);
		i+=i2;
	}

	//FilePos_RWSection܂NULLׂ
	temp2=(char *)HeapAlloc(hHeap,HEAP_ZERO_MEMORY,FilePos_RWSection-i);
	WriteFile(hFile,temp2,FilePos_RWSection-i,(DWORD *)&i2,NULL);
	HeapDefaultFree(temp2);
	i+=i2;

	if(bUse_RWSection){
		//C^u f[^ e[uiO[oϐ̏obt@j
		char *temp = (char *)calloc( FileSize_RWSection, 1 );
		memcpy(
			temp,
			compiler.GetObjectModule().meta.GetGlobalVars().initAreaBuffer.GetBuffer(),
			compiler.GetObjectModule().meta.GetGlobalVars().initAreaBuffer.GetSize()
		);

		WriteFile(hFile,temp,FileSize_RWSection,(DWORD *)&i2,NULL);
		i+=i2;

		free( temp );
	}

	//FilePos_RSrcSection܂NULLׂ
	temp2=(char *)HeapAlloc(hHeap,HEAP_ZERO_MEMORY,FilePos_RSrcSection-i);
	WriteFile(hFile,temp2,FilePos_RSrcSection-i,(DWORD *)&i2,NULL);
	HeapDefaultFree(temp2);
	i+=i2;

	if(bUse_RSrcSection){
		//\[Xobt@
		WriteFile(hFile,RSrcSectionBuffer,RSrcSectionSize,(DWORD *)&i2,NULL);
		i+=i2;
	}

	//FilePos_RelocSection܂NULLׂ
	temp2=(char *)HeapAlloc(hHeap,HEAP_ZERO_MEMORY,FilePos_RelocSection-i);
	WriteFile(hFile,temp2,FilePos_RelocSection-i,(DWORD *)&i2,NULL);
	HeapDefaultFree(temp2);
	i+=i2;

	if(bUse_RelocSection){
		//P[V
		WriteFile(hFile,pobj_Reloc->buffer,pobj_Reloc->length,(DWORD *)&i2,NULL);
		i+=i2;
	}

	//t@CACgl
	if(i%FILE_ALIGNMENT){
		temp2=(char *)HeapAlloc(hHeap,HEAP_ZERO_MEMORY,FILE_ALIGNMENT-i%FILE_ALIGNMENT);
		WriteFile(hFile,temp2,FILE_ALIGNMENT-i%FILE_ALIGNMENT,(DWORD *)&i2,NULL);
		HeapDefaultFree(temp2);
		i+=i2;
	}

	if(bUse_DebugSection){
		//fobOZNV
		WriteFile(hFile,pobj_DebugSection->buffer,pobj_DebugSection->length,(DWORD *)&i2,NULL);
		i+=i2;
	}

	//t@CACgl
	if(i%FILE_ALIGNMENT){
		temp2=(char *)HeapAlloc(hHeap,HEAP_ZERO_MEMORY,FILE_ALIGNMENT-i%FILE_ALIGNMENT);
		WriteFile(hFile,temp2,FILE_ALIGNMENT-i%FILE_ALIGNMENT,(DWORD *)&i2,NULL);
		HeapDefaultFree(temp2);
		i+=i2;
	}

	//ݏI
	CloseHandle(hFile);


EndWriteOpcode:

	//DosX^up̃
	HeapDefaultFree(DosStubBuffer);

	//GNX|[g e[u
	HeapDefaultFree(lpdwExportAddressTable);
	HeapDefaultFree(lpdwExportNamePointerTable);
	HeapDefaultFree(lpwExportOrdinalTable);

	//C|[gDLL
	HeapDefaultFree(pImportDescriptor);
	for(i=0;i<ImportDllNum;i++)
		HeapDefaultFree(ppDllNames[i]);
	HeapDefaultFree(ppDllNames);

	//bNAbve[uɊւ
	HeapDefaultFree(pLookupTable);

	//qge[uɊւ
	HeapDefaultFree(pHintTable);

	//\[XZNVobt@
	HeapDefaultFree(RSrcSectionBuffer);

	//fobOZNVJ
	delete pobj_DebugSection;

	//P[V
	delete pobj_Reloc;

	//񋓑̂Ɋւ̔j
	CEnumParent::DestroyEnum();

	//NXɊւ郁
	compiler.GetObjectModule().meta.GetClasses().Clear();
}
