#pragma once

class Linker
{
	NativeCode nativeCode;
	DataTable dataTable;
	DWORD imageBase;

public:

	Linker()
	{
	}

	const NativeCode &GetNativeCode() const
	{
		return nativeCode;
	}

	const DataTable &GetDataTable() const
	{
		return dataTable;
	}

	void SetImageBase( DWORD imageBase )
	{
		this->imageBase = imageBase;
	}

	// f[^e[uXPW[
	void ResolveDataTableSchedules( long dataSectionBaseOffset );

	// DLL֐XPW[
	void ResolveDllProcSchedules( long codeSectionBaseOffset, long importSectionBaseOffset, long lookupSize, long hintSize );

	// [U`֐XPW[
	void ResolveUserProcSchedules( long codeSectionBaseOffset );

	// O[oϐXPW[
	void ResolveGlobalVarSchedules( long rwSectionBaseOffset );

	// vtblXPW[
	void ResolveVtblSchedule( long dataSectionBaseOffset );

	// TypeInfoXPW[
	void ResolveTypeInfoSchedule( long dataSectionBaseOffset );

	// N
	void Link( ObjectModule &masterObjectModule );

	// f[^e[uZbg
	void SetDataTable( DataTable &dataTable );
};
