#include "stdafx.h"

#include <jenga/include/smoothie/Smoothie.h>
#include <jenga/include/smoothie/SmoothieException.h>
#include <jenga/include/smoothie/LexicalAnalysis.h>

#include <Compiler.h>
#include <Procedure.h>
#include <NamespaceSupporter.h>

#include "../common.h"
#ifdef _AMD64_
#include "../../BasicCompiler64/opcode.h"
#else
#include "../../BasicCompiler32/opcode.h"
#endif


std::string UserProc::GetFullName() const
{
	if( HasParentClass() ){
		return GetParentClass().GetName() + "." + GetName();
	}

	return GetName();
}
bool UserProc::IsCastOperator() const
{
	if( GetName()[0] == 1 && GetName()[1] == ESC_OPERATOR && GetName()[2] == CALC_AS )
	{
		return true;
	}
	return false;
}
const NamespaceScopes &UserProc::GetNamespaceScopes() const
{
	if( HasParentClass() ){
		return GetParentClassPtr()->GetNamespaceScopes();
	}
	return Symbol::GetNamespaceScopes();
}
const NamespaceScopesCollection &UserProc::GetImportedNamespaces() const
{
	if( pParentClass )
	{
		return pParentClass->GetImportedNamespaces();
	}
	return importedNamespaces;
}
bool UserProc::IsVirtual() const
{
	if( pMethod == NULL ){
		return false;
	}
	return ( pMethod->IsVirtual() != 0 );
}
const CMethod &UserProc::GetMethod() const
{
	if( !HasParentClass() )
	{
		Jenga::Throw( "O[o֐ɑ΂UserProc::GetMethod\bhĂ΂ꂽ" );
	}
	return *pMethod;
}

bool UserProc::SetParamsAndReturnType( const char *sourceOfParams, int nowLine, bool isStatic ){
	int i = 0;
	int i2,i3,sw;
	char temporary[8192],temp2[VN_SIZE];

	//\[XR[ḧʒu
	this->codePos = nowLine;

	//p[^
	if(sourceOfParams[i]!='('){
		SmoothieException::Throw(1,NULL,nowLine);
		return 0;
	}
	i++;
	if(sourceOfParams[i]!=')'&& this->pParentClass ){
		//NX̃o֐̏ꍇ̂݁AfXgN^Ƀp[^ꍇɃG[
		if(this->GetName()[0]=='~'){
			SmoothieException::Throw(114,NULL,nowLine);
			i=JumpStringInPare(sourceOfParams,i);
		}
	}
	while(1){
		if(sourceOfParams[i]==')') break;

		//ByRef
		bool isRef;
		if(sourceOfParams[i]==1&&sourceOfParams[i+1]==ESC_BYVAL){
			isRef = false;
			i+=2;
		}
		else if(sourceOfParams[i]==1&&sourceOfParams[i+1]==ESC_BYREF){
			isRef = true;
			i+=2;
		}
		else isRef = false;

		//p[^
		bool isArray = false;
		Subscripts subscripts;
		char name[VN_SIZE];
		sw=0;
		for(i2=0;;i++,i2++){
			if(sourceOfParams[i]=='('){
				if(!sw) sw=1;

				i3=GetStringInPare(name+i2,sourceOfParams+i);
				i2+=i3-1;
				i+=i3-1;
				continue;
			}
			if(sourceOfParams[i]=='['){
				if(!sw) sw=1;

				i3=GetStringInBracket(name+i2,sourceOfParams+i);
				i2+=i3-1;
				i+=i3-1;
				continue;
			}
			if(!IsVariableChar(sourceOfParams[i])){
				name[i2]=0;
				break;
			}
			name[i2]=sourceOfParams[i];
		}
		if(sw){
			//zp[^
			if( isRef == false ) SmoothieException::Throw(29,NULL,nowLine);
			isArray = true;

			if((name[i2-2]=='('&&name[i2-1]==')')||
				(name[i2-2]=='['&&name[i2-1]==']'))
			{
				subscripts.push_back( LONG_MAX );

				name[i2-2]=0;
			}
			else{
				GetArrange(name,temp2,subscripts);
				lstrcpy(name,temp2);
			}

			i2=lstrlen(name);
		}

		Type type( DEF_NON );
		char initValue[8192] = "";
		if( sourceOfParams[i] == '=' ){
			i++;
			i = GetOneParameter( sourceOfParams, i, initValue );

			// TODO: G[p fix me!!!
			//cp = nowLine;

			NumOpe_GetType( initValue, GetStringTypeInfo(), type );
			
			if( IS_LITERAL(type.GetIndex()) )
			{
				type.SetIndex( -1 );
			}
		}
		else if(sourceOfParams[i]==1&&sourceOfParams[i+1]==ESC_AS){
			// Asw
			i+=2;

			i2=0;
			while(sourceOfParams[i]=='*'){
				temporary[i2]=sourceOfParams[i];
				i++;
				i2++;
			}
			for(;;i++,i2++){
				if(!IsVariableChar(sourceOfParams[i])){
					if(sourceOfParams[i]==1&&(sourceOfParams[i+1]==ESC_FUNCTION||sourceOfParams[i+1]==ESC_SUB)){
						temporary[i2++]=sourceOfParams[i++];
						temporary[i2]=sourceOfParams[i];
						continue;
					}
					temporary[i2]=0;
					break;
				}
				temporary[i2]=sourceOfParams[i];
			}

			compiler.StringToType( temporary, type );

			if( type.IsNull() ){
				SmoothieException::Throw(3,temporary,nowLine);
				type.SetBasicType( DEF_PTR_VOID );
			}

			if( type.IsObject() ){
				if( type.GetClass().IsBlittableType() ){
					// Blittable^̂Ƃ͊{^ƂĈ
					type = type.GetClass().GetBlittableType();
				}
			}
		}
		else{
			type.SetBasicType( Type::GetBasicTypeFromSimpleName(temporary) );
			SmoothieException::Throw(-103,temporary,nowLine);
		}

		Parameter *pParam = new Parameter( name, type, isRef, initValue );
		if( isArray ){
			pParam->SetArray( subscripts );
		}

		//p[^ǉ
		this->params.push_back( pParam );

		if(sourceOfParams[i]==','){
			i++;
			continue;
		}
		else if(sourceOfParams[i]==')') continue;
		else{
			SmoothieException::Throw(1,NULL,nowLine);
			break;
		}
	}
	this->secondParmNum = (int)this->params.size();
	i++;
	if(sourceOfParams[i]=='('){
		i++;
		while(1){
			if(sourceOfParams[i]==')') break;

			//ByRef
			bool isRef;
			if(sourceOfParams[i]==1&&sourceOfParams[i+1]==ESC_BYVAL){
				isRef = false;
				i+=2;
			}
			else if(sourceOfParams[i]==1&&sourceOfParams[i+1]==ESC_BYREF){
				isRef = true;
				i+=2;
			}
			else isRef = false;

			//p[^
			bool isArray = false;
			Subscripts subscripts;
			char name[VN_SIZE];
			sw=0;
			for(i2=0;;i++,i2++){
				if(sourceOfParams[i]=='('){
					if(!sw) sw=1;

					i3=GetStringInPare(name+i2,sourceOfParams+i);
					i2+=i3-1;
					i+=i3-1;
					continue;
				}
				if(sourceOfParams[i]=='['){
					if(!sw) sw=1;

					i3=GetStringInBracket(name+i2,sourceOfParams+i);
					i2+=i3-1;
					i+=i3-1;
					continue;
				}
				if(!IsVariableChar(sourceOfParams[i])){
					name[i2]=0;
					break;
				}
				name[i2]=sourceOfParams[i];
			}
			if(sw){
				//zp[^
				if( isRef == false ) SmoothieException::Throw(29,NULL,nowLine);
				isArray = true;

				if((name[i2-2]=='('&&name[i2-1]==')')||
					(name[i2-2]=='['&&name[i2-1]==']'))
				{
					subscripts.push_back( LONG_MAX );

					name[i2-2]=0;
				}
				else{
					GetArrange(name,temp2,subscripts);
					lstrcpy(name,temp2);
				}

				i2=lstrlen(name);
			}

			//^
			Type type( DEF_NON );
			if(sourceOfParams[i]==1&&sourceOfParams[i+1]==ESC_AS){
				i+=2;

				i2=0;
				while(sourceOfParams[i]=='*'){
					temporary[i2]=sourceOfParams[i];
					i++;
					i2++;
				}
				for(;;i++,i2++){
					if(!IsVariableChar(sourceOfParams[i])){
						if(sourceOfParams[i]==1&&(sourceOfParams[i+1]==ESC_FUNCTION||sourceOfParams[i+1]==ESC_SUB)){
							temporary[i2++]=sourceOfParams[i++];
							temporary[i2]=sourceOfParams[i];
							continue;
						}
						temporary[i2]=0;
						break;
					}
					temporary[i2]=sourceOfParams[i];
				}

				compiler.StringToType( temporary, type );

				if( type.IsNull() ){
					SmoothieException::Throw(3,temporary,nowLine);
					type.SetBasicType( DEF_PTR_VOID );
				}
			}
			else{
				type.SetBasicType( Type::GetBasicTypeFromSimpleName(temporary) );
				SmoothieException::Throw(-103,temporary,nowLine);
			}

			Parameter *pParam = new Parameter( name, type, isRef );
			if( isArray ){
				pParam->SetArray( subscripts );
			}

			//p[^ǉ
			this->params.push_back( pParam );

			if(sourceOfParams[i]==','){
				i++;
				continue;
			}
			else if(sourceOfParams[i]==')') continue;
			else{
				SmoothieException::Throw(1,NULL,nowLine);
				break;
			}
		}
		i++;
	}

	if(sourceOfParams[i]){
		///////////////////
		// ߂l擾
		///////////////////

		if( !this->IsFunction() ){
			// Sub/Macrȍꍇ
			SmoothieException::Throw(38,this->GetName(),nowLine);
		}

		if( this->pParentClass ){
			if( this->GetName() == this->pParentClass->GetName() ||
				this->GetName()[0]=='~'){
				//NX̃RXgN^AfXgN^Function`̏ꍇ̓G[
				SmoothieException::Throw(115,NULL,nowLine);
			}
		}


		i2=lstrlen(sourceOfParams)-2;

		int sw_as=0;
		for(;i2>0;i2--){
			if(sourceOfParams[i2]==')') break;

			if(sourceOfParams[i2]==1&&sourceOfParams[i2+1]==ESC_AS){
				i2+=2;
				i3=0;
				while(sourceOfParams[i2]=='*') temporary[i3++]=sourceOfParams[i2++];
				for(;;i2++,i3++){
					if( IsCommandDelimitation( sourceOfParams[i2] ) )
					{
						temporary[i3]=0;
						break;
					}
					temporary[i3]=sourceOfParams[i2];
				}
				compiler.StringToType( temporary, this->returnType );
				if( this->returnType.IsNull() ) SmoothieException::Throw(3,temporary,nowLine);

				sw_as=1;
				break;
			}
		}

		if(!sw_as){
			SmoothieException::Throw(-104,this->GetName().c_str(),nowLine);

			this->returnType.SetBasicType( DEF_DOUBLE );
		}
	}
	else{
		//߂lȂSub`
		this->returnType.SetNull();
	}

	//Ap[^̈擾i_System_LocalThisl2mۂꍇj

	if( this->pParentClass && isStatic == false ){
		//IuWFNgȍꍇ́Ap[^_System_LocalThisnpƂėp
		string name = "_System_LocalThis";
		Type type( DEF_PTR_VOID );
		this->realParams.push_back( new Parameter( name, type ) );
	}

	if( this->returnType.IsStruct() ){
		//\̂߂lƂĎꍇ
		//p[^iThis|C^̏ꍇ͑p[^j߂lp̎QƐ錾ɂ

		string name = this->GetName();
		if(name[0]==1&&name[1]==ESC_OPERATOR){
			name="_System_ReturnValue";
		}
		Type type( DEF_STRUCT, this->returnType.GetIndex() );
		this->realParams.push_back( new Parameter( name, type, true ) );
	}

	//p[^Rs[
	BOOST_FOREACH( Parameter *pParam, params ){
		this->realParams.push_back( new Parameter( *pParam ) );
	}

	return true;
}

const UserProc *UserProc::pCompilingUserProc = NULL;


bool UserProcs::Insert( UserProc *pUserProc, int nowLine )
{
	/////////////////////////////////
	// nbVf[^ɒǉ
	/////////////////////////////////

	if( !Put( pUserProc ) )
	{
		// dĂ邽߁As
		SetError(15,pUserProc->GetName().c_str(),nowLine);
		return false;
	}

	return true;
}
UserProc *UserProcs::Add( const NamespaceScopes &namespaceScopes, const NamespaceScopesCollection &importedNamespaces, char *buffer,int nowLine,bool isVirtual,CClass *pobj_c, bool isStatic)
{
	int i2,i3;
	char temporary[8192];

	int i=1;

	Procedure::Kind kind = Procedure::Sub;
	bool isMacro = false;
	if(buffer[i]==ESC_FUNCTION) kind = Procedure::Function;
	if(buffer[i]==ESC_MACRO){
		isMacro = true;
	}

	i++;

	bool isCdecl = false;
	bool isExport = false;
	while(1){
		if(buffer[i]==1&&buffer[i+1]==ESC_CDECL&& isCdecl == false ){
			isCdecl = true;

			i+=2;
		}
		else if(buffer[i]==1&&buffer[i+1]==ESC_EXPORT&& isExport == false ){
			isExport = true;

			i+=2;
		}
		else break;
	}

	i2=0;
	if(buffer[i]==1&&buffer[i+1]==ESC_OPERATOR){
		if(!pobj_c){
			SetError(126,NULL,nowLine);
			return 0;
		}

		//Iy[^̏ꍇ
		temporary[i2++]=buffer[i++];
		temporary[i2++]=buffer[i++];

		int iCalcId;
		if(buffer[i]=='='&&buffer[i+1]=='='){
			iCalcId=CALC_EQUAL;
			i3=2;
		}
		else if(buffer[i]=='='){
			iCalcId=CALC_SUBSITUATION;
			i3=1;
		}
		else if(buffer[i]=='('){
			iCalcId=CALC_AS;
			i3=0;
		}
		else if(buffer[i]=='['&&buffer[i+1]==']'&&buffer[i+2]=='='){
			iCalcId=CALC_ARRAY_SET;
			i3=3;
		}
		else if(buffer[i]=='['&&buffer[i+1]==']'){
			iCalcId=CALC_ARRAY_GET;
			i3=2;
		}
		else{
			iCalcId=GetCalcId(buffer+i,&i3);
			i3++;
		}
		if(!iCalcId){
			SetError(1,NULL,nowLine);
			return 0;
		}
		temporary[i2++]=iCalcId;
		temporary[i2]=0;

		i+=i3;
	}
	else{
		if(pobj_c){
			//NXȍꍇAfXgN^ɂ~tƂl
			if(buffer[i]=='~'){
				temporary[i2]='~';
				i++;
				i2++;
			}
		}

		for(;;i++,i2++){
			if(!IsVariableChar(buffer[i])){
				temporary[i2]=0;
				break;
			}
			temporary[i2]=buffer[i];
		}
	}

	if( isMacro ){
		//啶ɕϊ
		CharUpper(temporary);

		//}N֐̏ꍇ͖OXgɒǉ
		macroNames.push_back( temporary );
	}

	if(!pobj_c){
		//NXoȊȌꍇ̂
		//d`FbN

		if(GetDeclareHash(temporary)){
			SetError(15,temporary,nowLine);
			return 0;
		}
	}

	// ID
	static int id_base=0;

	UserProc *pUserProc = new UserProc( namespaceScopes, importedNamespaces, temporary, kind, isMacro, isCdecl, isExport, (id_base++) );
	pUserProc->SetParentClass( pobj_c );
	if( Smoothie::isFullCompile ){
		// ׂĂ̊֐E\bhRpC
		pUserProc->Using();
	}

	if(isExport){
		pUserProc->Using();
	}

	// p[^
	// 1p[^ɂɎw肷f[^̗F"( s As String ) As String"
	pUserProc->SetParamsAndReturnType( buffer + i, nowLine, isStatic );

	pUserProc->_paramStr = buffer + i;

	// nbVɒǉ
	if( !Insert( pUserProc, nowLine ) )
	{
		return NULL;
	}

	return pUserProc;
}
void UserProcs::EnumGlobalProcs( const char *simpleName, const char *localName, std::vector<const UserProc *> &subs )
{
	///////////////////////////
	// O[o֐
	///////////////////////////

	// nbVl擾
	UserProc *pUserProc = GetHashArrayElement( simpleName );
	while(pUserProc){
		if( pUserProc->IsGlobalProcedure() ){
			if( pUserProc->IsEqualSymbol( localName ) ){
				subs.push_back( pUserProc );
			}
		}

		pUserProc=pUserProc->GetChainNext();
	}
}

bool DllProc::SetParamsAndReturnType( const char *sourceOfParams, int nowLine ){
	int i = 0;
	int i2,i3,sw;
	char temporary[8192],temp2[VN_SIZE];

	//\[XR[ḧʒu
	this->codePos = nowLine;

	//p[^
	if(sourceOfParams[i]!='('){
		SmoothieException::Throw(1,NULL,nowLine);
		return 0;
	}
	i++;

	while(1){
		if(sourceOfParams[i]==')') break;

		//ByRef
		bool isRef;
		if(sourceOfParams[i]==1&&sourceOfParams[i+1]==ESC_BYVAL){
			isRef = false;
			i+=2;
		}
		else if(sourceOfParams[i]==1&&sourceOfParams[i+1]==ESC_BYREF){
			isRef = true;
			i+=2;
		}
		else isRef = false;

		//p[^
		bool isArray = false;
		Subscripts subscripts;
		char name[VN_SIZE];
		sw=0;
		for(i2=0;;i++,i2++){
			if(sourceOfParams[i]=='('){
				if(!sw) sw=1;

				i3=GetStringInPare(name+i2,sourceOfParams+i);
				i2+=i3-1;
				i+=i3-1;
				continue;
			}
			if(sourceOfParams[i]=='['){
				if(!sw) sw=1;

				i3=GetStringInBracket(name+i2,sourceOfParams+i);
				i2+=i3-1;
				i+=i3-1;
				continue;
			}
			if(!IsVariableChar(sourceOfParams[i])){
				name[i2]=0;
				break;
			}
			name[i2]=sourceOfParams[i];
		}
		if(sw){
			//zp[^
			if( isRef == false ) SmoothieException::Throw(29,NULL,nowLine);
			isArray = true;

			if((name[i2-2]=='('&&name[i2-1]==')')||
				(name[i2-2]=='['&&name[i2-1]==']'))
			{
				subscripts.push_back( LONG_MAX );

				name[i2-2]=0;
			}
			else{
				GetArrange(name,temp2,subscripts);
				lstrcpy(name,temp2);
			}

			i2=lstrlen(name);
		}

		//^
		Type type( DEF_NON );
		if(lstrcmp(name,"...")==0) type.SetBasicType( DEF_ELLIPSE );
		else if(sourceOfParams[i]==1&&sourceOfParams[i+1]==ESC_AS){
			i+=2;

			i2=0;
			while(sourceOfParams[i]=='*'){
				temporary[i2]=sourceOfParams[i];
				i++;
				i2++;
			}
			for(;;i++,i2++){
				if(!IsVariableChar(sourceOfParams[i])){
					if(sourceOfParams[i]==1&&(sourceOfParams[i+1]==ESC_FUNCTION||sourceOfParams[i+1]==ESC_SUB)){
						temporary[i2++]=sourceOfParams[i++];
						temporary[i2]=sourceOfParams[i];
						continue;
					}
					temporary[i2]=0;
					break;
				}
				temporary[i2]=sourceOfParams[i];
			}

			compiler.StringToType( temporary, type );

			if( type.IsNull() ){
				SmoothieException::Throw(3,temporary,nowLine);
				type.SetBasicType( DEF_PTR_VOID );
			}
		}
		else{
			type.SetBasicType( Type::GetBasicTypeFromSimpleName(temporary) );
			SmoothieException::Throw(-103,temporary,nowLine);
		}

		Parameter *pParam = new Parameter( name, type, isRef );
		if( isArray ){
			pParam->SetArray( subscripts );
		}

		//p[^ǉ
		this->params.push_back( pParam );

		if(sourceOfParams[i]==','){
			i++;
			continue;
		}
		else if(sourceOfParams[i]==')') continue;
		else{
			SmoothieException::Throw(1,NULL,nowLine);
			break;
		}
	}
	i++;

	if(sourceOfParams[i]){
		///////////////////
		// ߂l擾
		///////////////////

		i2=lstrlen(sourceOfParams)-2;

		int sw_as=0;
		for(;i2>0;i2--){
			if(sourceOfParams[i2]==')') break;

			if(sourceOfParams[i2]==1&&sourceOfParams[i2+1]==ESC_AS){
				i2+=2;
				i3=0;
				while(sourceOfParams[i2]=='*') temporary[i3++]=sourceOfParams[i2++];
				for(;;i2++,i3++){
					if(!IsVariableChar(sourceOfParams[i2])){
						temporary[i3]=0;
						break;
					}
					temporary[i3]=sourceOfParams[i2];
				}
				compiler.StringToType( temporary, this->returnType );
				if( this->returnType.IsNull() ) SmoothieException::Throw(3,temporary,nowLine);

				sw_as=1;
				break;
			}
		}
	}
	else{
		//߂lȂSub`
		this->returnType.SetNull();
	}

	return true;
}

void DllProcs::Add(const NamespaceScopes &namespaceScopes, char *buffer,int nowLine){
	int i2;

	int i=0;

	//Sub/Function
	Procedure::Kind kind = Procedure::Sub;
	if(buffer[i]==ESC_SUB){
	}
	else if(buffer[i]==ESC_FUNCTION){
		kind = Procedure::Function;
	}
	else{
		SetError(1,NULL,nowLine);
		return;
	}
	i++;

	//vV[W
	char procName[VN_SIZE];
	bool isCdecl = false;
	for(i2=0;;i++,i2++){
		if(buffer[i]==1&&buffer[i+1]==ESC_CDECL){
			isCdecl = true;

			i+=2;
			procName[i2]=0;
			break;
		}
		if(buffer[i]==','){
			procName[i2]=0;
			break;
		}
		if(buffer[i]=='\0'){
			SetError(1,NULL,nowLine);
			return;
		}
		procName[i2]=buffer[i];
	}
	i++;

	//[U[`֐Ƃ̏d`FbN
	if(GetSubHash(procName)){
		SetError(15,procName,nowLine);
		return;
	}


	//Cu
	char dllFileName[MAX_PATH];
	i = GetOneParameter( buffer, i, dllFileName );
	Type resultType;
	_int64 i64data;
	if( !StaticCalculation( true, dllFileName, 0, &i64data, resultType ) ){
		return;
	}
	if( resultType.GetBasicType() != typeOfPtrChar ){
		SetError(1,NULL,nowLine);
		return;
	}
	lstrcpy( dllFileName, (char *)i64data );
	CharUpper(dllFileName);
	if(!strstr(dllFileName,".")){
		lstrcat(dllFileName,".DLL");
		if(lstrlen(dllFileName)>=16){
			SetError(7,NULL,nowLine);
			return;
		}
	}

	//GCAX
	char alias[VN_SIZE];
	i = GetOneParameter( buffer, i, alias );
	if( alias[0] ){
		if( !StaticCalculation( true, alias, 0, &i64data, resultType ) ){
			return;
		}
		if( resultType.GetBasicType() != typeOfPtrChar ){
			SetError(1,NULL,nowLine);
			return;
		}
		lstrcpy( alias, (char *)i64data );
	}
	else{
		//ȗꂽƂ͊֐
		lstrcpy( alias, procName );
	}


	// IuWFNg𐶐
	DllProc *pDllProc = new DllProc( namespaceScopes, procName, kind, isCdecl, dllFileName, alias );

	// p[^
	// 1p[^ɂɎw肷f[^̗F"( s As String ) As String"
	pDllProc->SetParamsAndReturnType( buffer + i, nowLine );

	// p[^̃G[`FbN
	BOOST_FOREACH( const Parameter *pParam, pDllProc->Params() ){
		if( pParam->IsObject() ){
			SetError(25,pParam->GetVarName(),nowLine);
		}
		if( !pParam->IsRef() ){
			if( pParam->IsStruct() ){
				SetError(28,pParam->GetVarName(),nowLine);
			}
		}
	}

	//߂l̃G[`FbN
	if( pDllProc->IsFunction() ){
		// Function`

		if( pDllProc->ReturnType().IsObject() ){
			// DLL֐ł̓IuWFNg߂lɂłȂ
			SetError(40,pDllProc->GetName(),nowLine);
		}
	}

	// nbV}bvɒǉ
	this->Put( pDllProc );
}

bool ProcPointer::SetParamsAndReturnType( const char *sourceOfParams, int nowLine ){
	int i = 0;
	int i2,i3,sw;
	char temporary[8192],temp2[VN_SIZE];

	//\[XR[ḧʒu
	this->codePos = nowLine;

	//p[^
	if(sourceOfParams[i]!='('){
		SmoothieException::Throw(1,NULL,nowLine);
		return 0;
	}
	i++;
	while(1){
		if(sourceOfParams[i]==')') break;

		//ByRef
		bool isRef;
		if(sourceOfParams[i]==1&&sourceOfParams[i+1]==ESC_BYVAL){
			isRef = false;
			i+=2;
		}
		else if(sourceOfParams[i]==1&&sourceOfParams[i+1]==ESC_BYREF){
			isRef = true;
			i+=2;
		}
		else isRef = false;

		//p[^
		bool isArray = false;
		Subscripts subscripts;
		char name[VN_SIZE];
		sw=0;
		for(i2=0;;i++,i2++){
			if(sourceOfParams[i]=='('){
				if(!sw) sw=1;

				i3=GetStringInPare(name+i2,sourceOfParams+i);
				i2+=i3-1;
				i+=i3-1;
				continue;
			}
			if(sourceOfParams[i]=='['){
				if(!sw) sw=1;

				i3=GetStringInBracket(name+i2,sourceOfParams+i);
				i2+=i3-1;
				i+=i3-1;
				continue;
			}
			if(!IsVariableChar(sourceOfParams[i])){
				name[i2]=0;
				break;
			}
			name[i2]=sourceOfParams[i];
		}
		if(sw){
			//zp[^
			if( isRef == false ) SmoothieException::Throw(29,NULL,nowLine);
			isArray = true;

			if((name[i2-2]=='('&&name[i2-1]==')')||
				(name[i2-2]=='['&&name[i2-1]==']'))
			{
				subscripts.push_back( LONG_MAX );

				name[i2-2]=0;
			}
			else{
				GetArrange(name,temp2,subscripts);
				lstrcpy(name,temp2);
			}

			i2=lstrlen(name);
		}

		//^
		Type type( DEF_NON );
		if(sourceOfParams[i]==1&&sourceOfParams[i+1]==ESC_AS){
			i+=2;

			i2=0;
			while(sourceOfParams[i]=='*'){
				temporary[i2]=sourceOfParams[i];
				i++;
				i2++;
			}
			for(;;i++,i2++){
				if(!IsVariableChar(sourceOfParams[i])){
					if(sourceOfParams[i]==1&&(sourceOfParams[i+1]==ESC_FUNCTION||sourceOfParams[i+1]==ESC_SUB)){
						temporary[i2++]=sourceOfParams[i++];
						temporary[i2]=sourceOfParams[i];
						continue;
					}
					temporary[i2]=0;
					break;
				}
				temporary[i2]=sourceOfParams[i];
			}

			compiler.StringToType( temporary, type );

			if( type.IsNull() ){
				SmoothieException::Throw(3,temporary,nowLine);
				type.SetBasicType( DEF_PTR_VOID );
			}
		}
		else{
			type.SetBasicType( Type::GetBasicTypeFromSimpleName(temporary) );
			SmoothieException::Throw(-103,temporary,nowLine);
		}

		Parameter *pParam = new Parameter( name, type, isRef );
		if( isArray ){
			pParam->SetArray( subscripts );
		}

		//p[^ǉ
		this->params.push_back( pParam );

		if(sourceOfParams[i]==','){
			i++;
			continue;
		}
		else if(sourceOfParams[i]==')') continue;
		else{
			SmoothieException::Throw(1,NULL,nowLine);
			break;
		}
	}
	i++;

	if(sourceOfParams[i]){
		///////////////////
		// ߂l擾
		///////////////////

		i2=lstrlen(sourceOfParams)-2;

		int sw_as=0;
		for(;i2>0;i2--){
			if(sourceOfParams[i2]==')') break;

			if(sourceOfParams[i2]==1&&sourceOfParams[i2+1]==ESC_AS){
				i2+=2;
				i3=0;
				while(sourceOfParams[i2]=='*') temporary[i3++]=sourceOfParams[i2++];
				for(;;i2++,i3++){
					if(!IsVariableChar(sourceOfParams[i2])){
						temporary[i3]=0;
						break;
					}
					temporary[i3]=sourceOfParams[i2];
				}
				compiler.StringToType( temporary, this->returnType );
				if( this->returnType.IsNull() ) SmoothieException::Throw(3,temporary,nowLine);

				sw_as=1;
				break;
			}
		}
	}
	else{
		//߂lȂSub`
		this->returnType.SetNull();
	}

	//߂l̃G[`FbN
	if( IsFunction() ){
		// Function`

		if( this->ReturnType().IsNull() ){
			// ߂lȂ
			SmoothieException::Throw(26,this->GetName(),nowLine);
		}
	}
	else{
		if( !this->ReturnType().IsNull() ){
			// Sub`Ȃ̂ɁA߂l
			SmoothieException::Throw(38,this->GetName(),nowLine);
		}
	}

	return true;
}

int ProcPointers::Add( const string &typeExpression )
{
	DWORD dwProcType = (DWORD)typeExpression[2];
	const string &paramStr = typeExpression.substr( 3 );

	Procedure::Kind kind = Procedure::Sub;
	if( dwProcType == ESC_FUNCTION ){
		kind = Procedure::Function;
	}

	ProcPointer *pProcPointer = new ProcPointer( kind );

	//buffer[0]'('ƂȂĂ
	extern int cp;
	pProcPointer->SetParamsAndReturnType( paramStr.c_str(), cp );

	this->push_back( pProcPointer );

	return (int)this->size()-1;
}

void ProcPointers::Clear()
{
	ProcPointers &procPointers = *this;
	BOOST_FOREACH( ProcPointer *pProcPointer, procPointers ){
		delete pProcPointer;
	}
	this->clear();
}
