#pragma once

#include <string>
#include <vector>

#include <option.h>
#include <Program.h>
#include <Class.h>
#include <Procedure.h>

#include <windows.h>

using namespace std;

class UserProc;
class CClass;
void SetError();

class CMethod : public MemberPrototype
{
	const UserProc *pUserProc;

	// XMLVACYp
private:
	friend class boost::serialization::access;
	template<class Archive> void serialize(Archive& ar, const unsigned int version)
	{
		trace_for_serialize( "serializing - CMethod" );

		ar & BOOST_SERIALIZATION_BASE_OBJECT_NVP( MemberPrototype );
		ar & boost::serialization::make_nvp("pUserProc", const_cast<UserProc *&>(pUserProc));
	}

public:
	CMethod( const UserProc *pUserProc, Prototype::Accessibility accessibility )
		: MemberPrototype( accessibility )
		, pUserProc( pUserProc )
	{
	}
	CMethod()
	{
	}

	const UserProc &GetUserProc() const
	{
		return *pUserProc;
	}
	void SetUserProcPtr( const UserProc *pUserProc )
	{
		this->pUserProc = pUserProc;
	}

	virtual bool IsAbstract() const = 0;
	virtual void Override() = 0;
	virtual bool IsVirtual() const = 0;
	virtual bool IsConst() const = 0;
	virtual bool IsDynamic() const = 0;
	virtual bool IsStatic() const = 0;
	virtual const CClass *GetInheritsClassPtr() const = 0;
	virtual void SetInheritsClassPtr( const CClass *pInheritsClass ) = 0;
};

class DynamicMethod : public CMethod
{
	bool isAbstract;
	bool isVirtual;
	bool isConst;
	const CClass *pInheritsClass;

	// XMLVACYp
private:
	friend class boost::serialization::access;
	template<class Archive> void serialize(Archive& ar, const unsigned int version)
	{
		trace_for_serialize( "serializing - DynamicMethod" );

		ar & BOOST_SERIALIZATION_BASE_OBJECT_NVP( CMethod );
		ar & BOOST_SERIALIZATION_NVP( isAbstract );
		ar & BOOST_SERIALIZATION_NVP( isVirtual );
		ar & BOOST_SERIALIZATION_NVP( isConst );
		ar & boost::serialization::make_nvp("pInheritsClass", const_cast<CClass *&>(pInheritsClass));
	}

public:
	DynamicMethod( UserProc *pUserProc, Prototype::Accessibility accessibility, bool isAbstract, bool isVirtual, bool isConst, const CClass *pInheritsClass = NULL )
		: CMethod( pUserProc, accessibility )
		, isAbstract( isAbstract )
		, isVirtual( isVirtual )
		, isConst( isConst )
		, pInheritsClass( pInheritsClass )
	{
	}
	DynamicMethod( const CMethod &method )
		: CMethod( &method.GetUserProc(), method.GetAccessibility() )
		, isAbstract( method.IsAbstract() )
		, isVirtual( method.IsVirtual() )
		, isConst( method.IsConst() )
		, pInheritsClass( method.GetInheritsClassPtr() )
	{
	}
	DynamicMethod()
	{
	}

	virtual bool IsAbstract() const
	{
		return isAbstract;
	}
	virtual void Override()
	{
		isAbstract = false;
	}
	virtual bool IsVirtual() const
	{
		return isVirtual;
	}
	virtual bool IsConst() const
	{
		return isConst;
	}
	virtual bool IsDynamic() const
	{
		return true;
	}
	virtual bool IsStatic() const
	{
		return false;
	}
	virtual const CClass *GetInheritsClassPtr() const
	{
		return pInheritsClass;
	}
	virtual void SetInheritsClassPtr( const CClass *pInheritsClass )
	{
		this->pInheritsClass = pInheritsClass;
	}
};
BOOST_CLASS_EXPORT( DynamicMethod );
class StaticMethod : public CMethod
{
	// XMLVACYp
private:
	friend class boost::serialization::access;
	template<class Archive> void serialize(Archive& ar, const unsigned int version)
	{
		trace_for_serialize( "serializing - StaticMethod" );

		ar & BOOST_SERIALIZATION_BASE_OBJECT_NVP( CMethod );
	}

public:
	StaticMethod( UserProc *pUserProc, Prototype::Accessibility accessibility )
		: CMethod( pUserProc, accessibility )
	{
	}
	StaticMethod()
	{
	}

	virtual bool IsAbstract() const{SetError();return false;}
	virtual void Override(){SetError();}
	virtual bool IsVirtual() const{
		return false;
	}
	virtual bool IsConst() const{SetError();return false;}
	virtual bool IsDynamic() const
	{
		return false;
	}
	virtual bool IsStatic() const
	{
		return true;
	}
	virtual const CClass *GetInheritsClassPtr() const{SetError();return NULL;}
	virtual void SetInheritsClassPtr( const CClass *pInheritsClass ){SetError();}
};
BOOST_CLASS_EXPORT( StaticMethod );

class Methods : public vector<CMethod *>
{
	// XMLVACYp
private:
	friend class boost::serialization::access;
	template<class Archive> void serialize(Archive& ar, const unsigned int version)
	{
		trace_for_serialize( "serializing - Methods" );

		ar & boost::serialization::make_nvp("vector_CMethod", boost::serialization::base_object<vector<CMethod *>>(*this));
	}

public:
	Methods();
	~Methods();

	//oA\bh̒ǉ
	void Add( UserProc *pUserProc, Prototype::Accessibility accessibility, bool isConst, bool isAbstract, bool isVirtual );
	void AddStatic(UserProc *pUserProc,Prototype::Accessibility accessibility);

	// I[o[Ch
	bool Override( UserProc *pUserProc, Prototype::Accessibility accessibility );

	const CMethod *GetMethodPtr( const UserProc *pUserProc ) const;
	bool IsExist( const char *name ) const;
	virtual void Enum( const char *methodName, vector<const UserProc *> &subs ) const;
	virtual void Enum( BYTE idOperatorCalc, vector<const UserProc *> &subs ) const;

	// z\bȟ擾
	int GetVtblNum() const;

	// vtbl𐶐
	void GenerateVTablePart( long &vtableDataTableOffset ) const;
};
