#include "stdafx.h"

#include <Class.h>


Methods::Methods()
{
}
Methods::~Methods()
{
	Methods &methods = *this;
	BOOST_FOREACH( CMethod *pMethod, methods ){
		delete pMethod;
	}
}

void Methods::Add( UserProc *pUserProc,Prototype::Accessibility accessibility, bool isConst, bool isAbstract, bool isVirtual ){
	CMethod *pMethod = new DynamicMethod( pUserProc, accessibility, isAbstract, isVirtual, isConst );
	this->push_back( pMethod );
	pUserProc->SetMethod( pMethod );
}
void Methods::AddStatic(UserProc *pUserProc, Prototype::Accessibility accessibility ){
	CMethod *pMethod = new StaticMethod( pUserProc, accessibility );
	this->push_back( pMethod );
	pUserProc->SetMethod( pMethod );
}

bool Methods::Override( UserProc *pUserProc, Prototype::Accessibility accessibility )
{
	//\bh̃I[o[Ch
	Methods &methods = *this;
	BOOST_FOREACH( CMethod *pMethod, methods )
	{
		if( pMethod->GetUserProc().GetName() == pUserProc->GetName() )
		{
			if( pMethod->GetUserProc().Params().Equals( pUserProc->Params() )
				&& pMethod->GetUserProc().ReturnType().Equals( pUserProc->ReturnType() ) )
			{
				//o֐㏑
				pMethod->SetUserProcPtr( pUserProc );
				pMethod->Override();

				if( !pMethod->IsVirtual() )
				{
					// I[o[Ch~X
					SetError(136,NULL,cp);
				}
				if(pMethod->GetAccessibility() != accessibility )
				{
					SetError(128,NULL,cp);
				}

				pUserProc->SetMethod( pMethod );
				return true;
			}
		}
	}
	return false;
}

const CMethod *Methods::GetMethodPtr( const UserProc *pUserProc ) const
{
	const Methods &methods = *this;
	for( int i=(int)methods.size()-1; i>=0; i-- ){
		if( pUserProc == &methods[i]->GetUserProc() ){
			return methods[i];
		}
	}
	return NULL;
}
bool Methods::IsExist( const char *name ) const
{
	const Methods &methods = *this;
	BOOST_FOREACH( const CMethod *pMethod, methods ){
		if( pMethod->GetUserProc().GetName() == name ) return true;
	}
	return false;
}
void Methods::Enum( const char *methodName, vector<const UserProc *> &subs ) const
{
	//IuWFNg̃o֐̏ꍇ
	//I[o[Chꂽ֐ɃT[`Kv邽߁AobNT[`s
	const Methods &methods = *this;
	for( int i=(int)methods.size()-1; i>=0; i-- ){
		if( methods[i]->GetUserProc().GetName() == methodName ){
			subs.push_back( &methods[i]->GetUserProc() );
		}
	}
}
void Methods::Enum( BYTE idOperatorCalc, vector<const UserProc *> &subs ) const
{
	//IuWFNg̃o֐̏ꍇ
	//I[o[Chꂽ֐ɃT[`Kv邽߁AobNT[`s
	const Methods &methods = *this;
	for( int i=(int)methods.size()-1; i>=0; i-- ){
		const UserProc &userProc = methods[i]->GetUserProc();
		const char *temp = userProc.GetName().c_str();
		if(temp[0]==1&&temp[1]==ESC_OPERATOR){
			if((BYTE)temp[2]==idOperatorCalc){
				subs.push_back( &userProc );
			}
		}
	}
}
