#include "stdafx.h"

#include <jenga/include/smoothie/Smoothie.h>
#include <jenga/include/smoothie/LexicalAnalysis.h>

#include <CodeGenerator.h>
#include <Compiler.h>
#include <Variable.h>

#include "../BasicCompiler_Common/common.h"
#include "Opcode.h"

//ϐ
// TODO: xml
int AllLocalVarSize;


void SetRelativeOffset( Type &resultType, RELATIVE_VAR *pRelativeVar,const char *lpPtrOffset){
	/////////////////////////////////////////////
	// 擪|C^r12Ɏ擾ă֑ޔ
	/////////////////////////////////////////////

	SetReg_WholeVariable(Type(DEF_INT64),pRelativeVar,REG_R11);

	//mov qword ptr[rsp+offset],r11     X^bNt[𗘗p
	pobj_sf->push(REG_R11);


	////////////////////////////////
	// YvZ
	////////////////////////////////

	int reg=REG_NON;
	Type type;
	NumOpe( &reg, lpPtrOffset, Type(), type );
	if( !type.IsWhole() ){
		SetError(46,NULL,cp);
	}
	ExtendTypeTo64(type.GetBasicType(),reg);

	if(reg==REG_R14){
		//mov r14,qword ptr[rsp+offset]     X^bNt[𗘗p
		pobj_sf->pop(REG_R14);
	}

	if( resultType.PtrLevel() ){
		resultType.PtrLevelDown();

		int typeSize = resultType.GetSize();
		if(typeSize>=2){
			//imul reg,i2
			compiler.codeGenerator.op_imul_RV(sizeof(_int64),reg,typeSize);
		}
	}
	else{
		//G[
		SetError(1,NULL,cp);
		return;
	}


	//////////////////////////////
	// 擪|C^ɓYZ
	//////////////////////////////

	//mov r11,qword ptr[rsp+offset]     X^bNt[𗘗p
	pobj_sf->pop(REG_R11);

	//add r11,reg
	compiler.codeGenerator.op_add_RR(REG_R11,reg);
}
void SetRelativeOffset( RELATIVE_VAR &relativeVar ){
	if(relativeVar.dwKind==VAR_DIRECTMEM){
		//mov r11,qword ptr[r11]
		compiler.codeGenerator.op_mov_RM(sizeof(_int64),REG_R11,REG_R11,0,MOD_BASE);
	}
	else{
		//ڎQƂɐ؂ւ
		SetVarPtrToReg(REG_R12,&relativeVar);
		relativeVar.dwKind=VAR_DIRECTMEM;

		//mov r11,qword ptr[r12]
		compiler.codeGenerator.op_mov_RM(sizeof(_int64),REG_R11,REG_R12,0,MOD_BASE);
	}
}
bool GetArrayOffset(const Subscripts &subscripts,char *array, const Type &type){
	extern HANDLE hHeap;
	int i,i2,i3,i4;
	char temporary[VN_SIZE],*pParm[MAX_PARMS];

	for(i=0,i2=0,i3=0;;i++,i2++){
		if(array[i]=='('){
			i4=GetStringInPare(temporary+i2,array+i);
			i+=i4-1;
			i2+=i4-1;
			continue;
		}
		if(array[i]=='['){
			i4=GetStringInBracket(temporary+i2,array+i);
			i+=i4-1;
			i2+=i4-1;
			continue;
		}
		if(array[i]==','||array[i]=='\0'){
			if( i3 >= (int)subscripts.size() )
			{
				for(i3--;i3>=0;i3--) HeapDefaultFree(pParm[i3]);
				return false;
			}

			temporary[i2]=0;

			pParm[i3]=(char *)HeapAlloc(hHeap,0,lstrlen(temporary)+1);
			lstrcpy(pParm[i3],temporary);

			i3++;

			if(array[i]=='\0'){
				if( i3 < (int)subscripts.size() )
				{
					for(i3--;i3>=0;i3--) HeapDefaultFree(pParm[i3]);
					return false;
				}
				break;
			}

			i2=-1;
			continue;
		}
		temporary[i2]=array[i];
	}

	//mov qword ptr[rsp+offset],r11     X^bNt[𗘗p
	pobj_sf->push(REG_R11);

	//xor r12,r12
	compiler.codeGenerator.op_zero_reg(REG_R12);

	for(i=i3-1;i>=0;i--){
		//mov qword ptr[rsp+offset],r12     X^bNt[𗘗p
		pobj_sf->push(REG_R12);

		int reg=REG_NON;
		Type type;
		BOOL bUseHeap;
		NumOpe( &reg, pParm[i], Type( DEF_LONG ), type, &bUseHeap );
		if( type.IsObject() ){
			//LXgZq̃I[o[[hɑΉ
			CallCastOperatorProc(reg,
				type,
				bUseHeap, Type(DEF_LONG) );
			type.SetBasicType( DEF_LONG );
		}

		if( !type.IsWhole() ){
			SetError(46,NULL,cp);
		}
		ExtendTypeTo64( type.GetBasicType(), reg );

		if(reg==REG_R14){
			//mov r14,qword ptr[rsp+offset]     X^bNt[𗘗p
			pobj_sf->pop(REG_R14);
		}

		//mov r12,qword ptr[rsp+offset]     X^bNt[𗘗p
		pobj_sf->pop(REG_R12);

		for(i2=i+1,i4=1;i2<i3;i2++) i4*=subscripts[i2]+1;

		//imul reg,i4
		compiler.codeGenerator.op_imul_RV(sizeof(_int64),reg,i4);

		//add r12,reg
		compiler.codeGenerator.op_add_RR(REG_R12,reg);

		HeapDefaultFree(pParm[i]);
	}

	//imul r12,TypeSize
	compiler.codeGenerator.op_imul_RV( sizeof(_int64), REG_R12, type.GetSize() );

	//mov r11,qword ptr[rsp+offset]     X^bNt[𗘗p
	pobj_sf->pop(REG_R11);

	//add r11,r12
	compiler.codeGenerator.op_add_RR( REG_R11, REG_R12 );

	return true;
}
bool _member_offset(bool isErrorEnabled, bool isWriteAccess, const Type &classType, const char *member, RELATIVE_VAR *pRelativeVar, Type &resultType, BOOL bPrivateAccess)
{
	const CClass &objClass = classType.GetClass();

	//////////////////////////////////////
	// NXAz̍\vf͂
	//////////////////////////////////////

	char VarName[VN_SIZE];		//ϐ
	char array[VN_SIZE];		//1z
	char lpPtrOffset[VN_SIZE];	//2z
	char NestMember[VN_SIZE];	//qo
	ReferenceKind refType;
	lstrcpy(VarName,member);
	if(!GetVarFormatString(VarName,array,lpPtrOffset,NestMember,refType)) return false;


	////////////////////////////
	// oItZbg擾
	////////////////////////////

	int memberIndex;
	int offset = objClass.GetMemberOffset( VarName, &memberIndex );
	if( memberIndex == objClass.GetDynamicMembers().size() ){
		if(isErrorEnabled) SetError(103,VarName,cp);
		return false;
	}

	CMember *pMember = objClass.GetDynamicMembers()[memberIndex];


	//ANZVreB`FbN
	if(&objClass==compiler.pCompilingClass){
		//NXIuWFNg̏ꍇ̓vCx[gANZXeF
		if(pMember->IsNoneAccess()){
			if(isErrorEnabled) SetError(107,VarName,cp);
			return false;
		}
	}
	else{
		if((bPrivateAccess==0&&pMember->IsPrivate())||
			pMember->IsNoneAccess()){
			if(isErrorEnabled) SetError(107,VarName,cp);
			return false;
		}
		else if(bPrivateAccess==0&&pMember->IsProtected()){
			if(isErrorEnabled) SetError(108,VarName,cp);
			return false;
		}
	}

	//Const`̏ꍇ͏݃ANZX𐧌
	//RXgN^RpC̏ꍇ͗OIɋ
	if( pMember->IsConst() &&		//萔oł
		isWriteAccess &&							//݃ANZXvĂ
		objClass.IsCompilingConstructor() == false	//RXgN^ RpC
		){
			//Const`̕ϐɏ݃ANZX悤Ƃꍇ
			SetError(61,VarName,cp);
	}

	resultType = pMember->GetType();

	// ^p[^
	ResolveFormalGenericTypeParameter( resultType, classType );

	//|C^ϐ̏ꍇ
	if( resultType.IsPointer() ){
		if( pMember->GetSubscripts().size() == 0 ){
			lstrcpy(lpPtrOffset,array);
			array[0]=0;
		}
	}
	else{
		if(lpPtrOffset[0]){
			if(isErrorEnabled) SetError(16,member,cp);
			return false;
		}
	}

	if(offset){
		//add r11,offset
		compiler.codeGenerator.op_add_RV( REG_R11, offset );
	}

	if(array[0]){
		//zItZbg
		if(!GetArrayOffset(pMember->GetSubscripts(),array,pMember->GetType())){
			if(isErrorEnabled) SetError(14,member,cp);
			return false;
		}
	}
	else if( pMember->GetSubscripts().size() > 0 ){
		resultType.SetBasicType( resultType.GetBasicType() | FLAG_PTR );
	}

	if(NestMember[0]){
		//q\̏ꍇ

		if( resultType.IsObject() || resultType.IsStruct() ){
			if( refType != RefDot ){
				if(isErrorEnabled) SetError(104,member,cp);
				return false;
			}

			if( resultType.IsObject() ){
				// QƓeւ̃|C^𒊏o
				SetRelativeOffset( *pRelativeVar );
			}
		}
		else if( resultType.IsObjectPtr() || resultType.IsStructPtr() ){
			//\̃|C^^oϐ

			if(lpPtrOffset[0]){
				//pObj[n].member
				if( ( resultType.IsObjectPtr() || resultType.IsStructPtr() )
					&& refType != RefDot ){
						if(isErrorEnabled) SetError(104,member,cp);
						return false;
				}

				//ڎQƂɐ؂ւ
				SetRelativeOffset(resultType,pRelativeVar,lpPtrOffset);
				pRelativeVar->dwKind=VAR_DIRECTMEM;

				lpPtrOffset[0]=0;
			}
			else{
				//pObj->member
				if( (resultType.IsObjectPtr() || resultType.IsStructPtr() )
					&& refType != RefPointer ){
						if(isErrorEnabled) SetError(104,member,cp);
						return false;
				}

				SetRelativeOffset( *pRelativeVar );
			}
		}
		else if( resultType.GetBasicType() == MAKE_PTR_TYPE(DEF_OBJECT,2)
			|| resultType.GetBasicType() == MAKE_PTR_TYPE(DEF_STRUCT,2)){
			//\̃|C^̃|C^^oϐ

			if(lpPtrOffset[0]){
				//ppObj[n]->member
				if( refType != RefPointer ){
					if(isErrorEnabled) SetError(104,member,cp);
					return false;
				}

				//ڎQƂɐ؂ւ
				SetRelativeOffset(resultType,pRelativeVar,lpPtrOffset);
				pRelativeVar->dwKind=VAR_DIRECTMEM;

				lpPtrOffset[0]=0;

				//mov r11,qword ptr[r11]
				compiler.codeGenerator.op_mov_RM(sizeof(_int64),REG_R11,REG_R11,0,MOD_BASE);
			}
			else{
				if(isErrorEnabled) SetError(104,member,cp);
				return false;
			}
		}

		if(!_member_offset(
			isErrorEnabled,
			isWriteAccess,
			pMember->GetType(),
			NestMember,
			pRelativeVar,
			resultType,
			0)) return false;
	}

	if(lpPtrOffset[0]){
		SetRelativeOffset(resultType,pRelativeVar,lpPtrOffset);
		pRelativeVar->dwKind=VAR_DIRECTMEM;
	}

	return true;
}

int LocalVar_ThisPtrOffset;
void SetThisPtrToReg(int reg){
	//g̃IuWFNgThis|C^regɃRs[

	RELATIVE_VAR RelativeVar;
	RelativeVar.dwKind=VAR_LOCAL;
	RelativeVar.bOffsetOffset=0;
	RelativeVar.offset=-LocalVar_ThisPtrOffset;

	SetReg_WholeVariable(Type(DEF_PTR_VOID),&RelativeVar,reg);
}
bool GetVarOffset(bool isErrorEnabled,bool isWriteAccess,const char *NameBuffer,RELATIVE_VAR *pRelativeVar,Type &resultType, Subscripts *pResultSubscripts ){
	char variable[VN_SIZE];

	if(NameBuffer[0]=='.'){
		GetWithName(variable);
		lstrcat(variable,NameBuffer);
	}
	else lstrcpy(variable,NameBuffer);

	// OԂ𕪗
	char namespaceStr[VN_SIZE]="", simpleName[VN_SIZE];
	compiler.GetObjectModule().meta.GetNamespaces().SplitNamespace( variable, namespaceStr, simpleName );

	// 擪IuWFNg܂̓NXƓqoɕ
	ReferenceKind refType;
	char member[VN_SIZE],array[VN_SIZE],lpPtrOffset[VN_SIZE];
	GetVarFormatString(simpleName,array,lpPtrOffset,member,refType);

	// OԂ𕪗Ăꍇ͌
	char VarName[VN_SIZE];
	if( namespaceStr[0] ){
		sprintf( VarName, "%s.%s", namespaceStr, simpleName );
	}
	else{
		lstrcpy( VarName, simpleName );
	}

	const Subscripts *pSubscripts;
	bool bConst = false;


	if( UserProc::IsLocalAreaCompiling() ){
		//////////////////
		// [Jϐ
		//////////////////

		const Variable *pVar = UserProc::CompilingUserProc().GetLocalVars().BackSearch( Symbol( VarName ) );
		if( pVar ){
			//|C^ϐ̏ꍇ
			if( pVar->GetType().IsPointer() ){
				if( !pVar->IsArray() ){
					lstrcpy(lpPtrOffset,array);
					array[0]=0;
				}
			}
			else{
				if(lpPtrOffset[0]){
					SetError(16,variable,cp);
					pRelativeVar->dwKind=NON_VAR;
					return false;
				}
			}

			pRelativeVar->offset=-pVar->GetOffsetAddress();
			pRelativeVar->bOffsetOffset=0;
			if( pVar->IsRef() ){
				// Qƌ^
				pRelativeVar->dwKind = VAR_REFLOCAL;
			}
			else pRelativeVar->dwKind=VAR_LOCAL;
			resultType = pVar->GetType();
			pSubscripts = &pVar->GetSubscripts();
			bConst = pVar->IsConst();

			/////////////////////////////////////////////////////////
			//  WFlNXT|[g 

			if( resultType.IsTypeParameter() )
			{
				// ^p[^Ƃ

				int ptrLevel = PTR_LEVEL( resultType.GetBasicType() );

				// TODO: x[XIuWFNgiw肳ĂȂƂObjectNXjɃZbg
				resultType.SetBasicType( DEF_OBJECT );

				for( int i=0; i<ptrLevel; i++ )
				{
					resultType.PtrLevelUp();
				}
			}

			//
			/////////////////////////////////////////////////////////

			goto ok;
		}
	}


	if(compiler.pCompilingClass){
		//////////////////////
		// NXo̎Q
		//////////////////////

		if(lstrcmpi(variable,"This")==0){
			//g̃IuWFNgThis|C^r11ɃRs[
			SetThisPtrToReg(REG_R11);

			pRelativeVar->dwKind=VAR_DIRECTMEM;

			resultType.SetType( DEF_OBJECT, compiler.pCompilingClass );
			return true;
		}

		if(memicmp(variable,"This.",5)==0){
			//ThisIuWFNg̃oQƂƂ
			SlideString(variable+5,-5);
			lstrcpy(VarName,variable);
		}
		else{
			//NXoQƂƂiʏj

			bool isFound = false;
			BOOST_FOREACH( CMember *pMember, compiler.pCompilingClass->GetDynamicMembers() ){
				if( pMember->GetName() == VarName ){
					isFound = true;
					break;
				}
			}
			if( !isFound ) goto NonClassMember;
		}

		//ConstCq̃\bhŃo݃ANZXƂ
		//iRXgN^AfXgN^j
		const CMethod *pMethod = compiler.GetObjectModule().meta.GetClasses().GetNowCompilingMethodInfo();
		if( isWriteAccess &&
			pMethod->IsConst() &&
			compiler.pCompilingClass->IsCompilingConstructor() == false &&
			compiler.pCompilingClass->IsCompilingDestructor() == false
			){
				SetError(131, NULL, cp );
		}

		//g̃IuWFNgThis|C^r11ɃRs[
		SetThisPtrToReg(REG_R11);

		pRelativeVar->dwKind=VAR_DIRECTMEM;
		if(!_member_offset(
			isErrorEnabled,
			isWriteAccess,
			Type( DEF_OBJECT, *compiler.pCompilingClass ),
			variable,
			pRelativeVar,
			resultType,1)) return false;
		return true;
	}

NonClassMember:

	{
		const Variable *pVar;

		//////////////////////////
		// ÓI[Jϐ
		// "Static.Object.Method.Variable"
		//////////////////////////

		char temporary[VN_SIZE];
		if( UserProc::IsLocalAreaCompiling() ){
			GetNowStaticVarFullName(VarName,temporary);

			pVar = compiler.GetObjectModule().meta.GetGlobalVars().Find( Symbol( temporary ) );
			if( pVar ){
				goto GlobalOk;
			}
		}


		//////////////////////////
		// NX̐ÓIo
		//////////////////////////

		if(member[0]){
			lstrcpy(temporary,member);

			// TODO: OԂlR[hɂȂĂȂ

			char tempMember[VN_SIZE];
			char tempArray[VN_SIZE];
			{
				ReferenceKind refType;
				GetVarFormatString(temporary,tempArray,lpPtrOffset,tempMember, refType );
			}

			int typeDefIndex = compiler.GetObjectModule().meta.GetTypeDefs().GetIndex( VarName );
			if( typeDefIndex != -1 ){
				// TypeDef̌^Ƃ
				lstrcpy( VarName, compiler.GetObjectModule().meta.GetTypeDefs()[typeDefIndex].GetBaseName().c_str() );
			}

			char temp2[VN_SIZE];
			sprintf(temp2,"%s.%s",VarName,temporary);
			pVar = compiler.GetObjectModule().meta.GetGlobalVars().Find( Symbol( temp2 ) );
			if( pVar ){
				lstrcpy(member,tempMember);
				lstrcpy(array,tempArray);
				goto GlobalOk;
			}
		}

		if(compiler.pCompilingClass){
			//g̃NXÓIoQƂꍇ
			char temp2[VN_SIZE];
			sprintf(temp2,"%s.%s",compiler.pCompilingClass->GetName().c_str(),VarName);
			pVar = compiler.GetObjectModule().meta.GetGlobalVars().Find( Symbol( temp2 ) );
			if( pVar ){
				goto GlobalOk;
			}
		}

		/////////////////////
		// O[oϐ
		/////////////////////

		pVar = compiler.GetObjectModule().meta.GetGlobalVars().BackSearch( Symbol( VarName ) );
		if( pVar ){
			goto GlobalOk;
		}

		if(isErrorEnabled) SetError(3,variable,cp);
		pRelativeVar->dwKind=NON_VAR;
		return false;



GlobalOk:
		//|C^ϐ̏ꍇ
		if( pVar->GetType().IsPointer() ){
			if( !pVar->IsArray() ){
				lstrcpy(lpPtrOffset,array);
				array[0]=0;
			}
		}
		else{
			if(lpPtrOffset[0]){
				SetError(16,variable,cp);
				pRelativeVar->dwKind=NON_VAR;
				return false;
			}
		}

		pRelativeVar->offset=pVar->GetOffsetAddress();
		pRelativeVar->bOffsetOffset=0;
		if( pVar->IsRef() ){
			// Qƌ^
			pRelativeVar->dwKind = VAR_REFGLOBAL;
		}
		else pRelativeVar->dwKind=VAR_GLOBAL;
		resultType = pVar->GetType();
		pSubscripts=&pVar->GetSubscripts();
		bConst = pVar->IsConst();
	}



ok:

	if( bConst && isWriteAccess ){
		//Const`̕ϐɏ݃ANZX悤Ƃꍇ
		if( resultType.IsObject() ){
			//IuWFNg萔
			SetError(130, VarName, cp );
		}
		else{
			//ʂConstϐ
			SetError(61,VarName,cp);
		}
	}

	if( array[0] == 0 && pSubscripts->size() > 0 ){
		//z̐擪|C^ꍇ
		resultType.SetBasicType( resultType.GetBasicType() | FLAG_PTR );

		if( pResultSubscripts )
		{
			(*pResultSubscripts) = *pSubscripts;
		}
		return true;
	}

	if( array[0] || member[0] ){
		//xor r11,r11ir110ɏj
		//r11͕ϐx[XAhX̑΃ItZbg
		compiler.codeGenerator.op_zero_reg(REG_R11);

		pRelativeVar->bOffsetOffset=1;
	}
	if(array[0]){
		if(!GetArrayOffset(*pSubscripts,array,resultType)){
			SetError(14,variable,cp);
			pRelativeVar->dwKind=NON_VAR;
			return false;
		}
	}
	if(member[0]){
		if( resultType.IsObject() || resultType.IsStruct() ){
			//ԃIuWFNg̃oQƁiobj.memberj
			if( refType != RefDot ){
				SetError(104,VarName,cp);
				pRelativeVar->dwKind=NON_VAR;
				return false;
			}

			if( resultType.IsObject() ){
				// QƓeւ̃|C^𒊏o
				SetRelativeOffset( *pRelativeVar );
			}
		}
		else if( resultType.IsObjectPtr() || resultType.IsStructPtr() ){
			//|C^IuWFNgoQ
			if(lpPtrOffset[0]){
				//pObj[n].member
				if( refType != RefDot ){
					SetError(104,VarName,cp);
					pRelativeVar->dwKind=NON_VAR;
					return false;
				}
				SetRelativeOffset(resultType,pRelativeVar,lpPtrOffset);
				pRelativeVar->dwKind=VAR_DIRECTMEM;
			}
			else{
				//pObj->member
				if( refType != RefPointer ){
					SetError(104,VarName,cp);
					pRelativeVar->dwKind=NON_VAR;
					return false;
				}

				SetVarPtrToReg(REG_R12,pRelativeVar);
				pRelativeVar->dwKind=VAR_DIRECTMEM;

				//mov r11,qword ptr[r12]
				compiler.codeGenerator.op_mov_RM(sizeof(_int64),REG_R11,REG_R12,0,MOD_BASE);
			}
		}
		else if( resultType.GetBasicType()==MAKE_PTR_TYPE(DEF_OBJECT,2) || resultType.GetBasicType()==MAKE_PTR_TYPE(DEF_STRUCT,2)){
			//|C^IuWFNgoQ
			if(lpPtrOffset[0]){
				//ppObj[n]->member
				if( refType != RefPointer ){
					SetError(104,VarName,cp);
					pRelativeVar->dwKind=NON_VAR;
					return false;
				}

				SetRelativeOffset(resultType,pRelativeVar,lpPtrOffset);
				pRelativeVar->dwKind=VAR_DIRECTMEM;


				SetVarPtrToReg(REG_R12,pRelativeVar);

				//mov r11,qword ptr[r12]
				compiler.codeGenerator.op_mov_RM(sizeof(_int64),REG_R11,REG_R12,0,MOD_BASE);
			}
			else{
				SetError(104,VarName,cp);
				pRelativeVar->dwKind=NON_VAR;
				return false;
			}
		}
		else{
			SetError(102,VarName,cp);
			pRelativeVar->dwKind=NON_VAR;
			return false;
		}

		if(!_member_offset(
			isErrorEnabled,
			isWriteAccess,
			resultType,
			member,pRelativeVar,resultType,0)) return false;

		return true;
	}

	if(lpPtrOffset[0]){
		SetRelativeOffset(resultType,pRelativeVar,lpPtrOffset);
		pRelativeVar->dwKind=VAR_DIRECTMEM;
	}

	return true;
}

bool SetInitGlobalData(int offset,const Type &type,const Subscripts &subscripts,const char *lpszInitBuf){
	int i2,i3;
	char temporary[VN_SIZE];
	char InitBuf[VN_SIZE];
	lstrcpy( InitBuf, lpszInitBuf );

	if(InitBuf[0]=='['){
		SlideString(InitBuf+1,-1);
		InitBuf[lstrlen(InitBuf)-1]=0;

		int typeSize = type.GetSize();

		if( subscripts.size() > 0 ){
			Subscripts nestSubscripts;
			for( int i=1; i<(int)subscripts.size(); i++ )
			{
				nestSubscripts.push_back( subscripts[i] );
			}

			typeSize*=JumpSubScripts( nestSubscripts );
			{
				int i=0;
				i2=0;
				while(1){
					if( subscripts[0] < i2 ){
						SetError(41,0,cp);
						return 0;
					}
					i=GetOneParameter(InitBuf,i,temporary);
					if(!SetInitGlobalData(
						offset+i2*typeSize,
						type,
						nestSubscripts,
						temporary)) return false;
					i2++;
					if(InitBuf[i]=='\0') break;
				}
			}
			return true;
		}

		if(type.IsStruct()){
			const CClass &objClass = type.GetClass();

			int i = 0;
			BOOST_FOREACH( CMember *pMember, objClass.GetDynamicMembers() ){
				if(InitBuf[i]=='\0'){
					SetError(41,0,cp);
					return false;
				}

				i=GetOneParameter(InitBuf,i,temporary);

				i3=objClass.GetMemberOffset( pMember->GetName().c_str(), NULL );

				if(!SetInitGlobalData(offset+i3,
					pMember->GetType(),
					pMember->GetSubscripts(),
					temporary)) return false;
			}
			return true;
		}

		SetError(41,0,cp);
		return false;
	}


	///////////////////////////////////////
	// Pi[]ň͂܂ĂȂj
	///////////////////////////////////////

	if( type.IsObject() || type.IsStruct() ){
		//IuWFNg܂͍\̂̏ꍇ͂肦Ȃ
		SetError(300,NULL,cp);
		return false;
	}

	if( subscripts.size() > 0 ){
		SetError(41,0,cp);
		return false;
	}

	double dbl;
	_int64 i64data;
	Type calcType;

	if( !StaticCalculation(false, InitBuf,type.GetBasicType(),&i64data,calcType) ){
		//If[^ꍇ
		return false;
	}
	if( calcType.IsReal() ){
		memcpy(&dbl,&i64data,sizeof(double));
		i64data=(_int64)dbl;
	}
	else dbl=(double)i64data;

	//^`FbN
	CheckDifferentType(
		type,
		calcType,
		0,0);

	if( type.IsDouble() ){
		compiler.GetObjectModule().meta.GetGlobalVars().initAreaBuffer.Overwrite(
			offset,
			(const char *)&dbl,
			sizeof(double)
		);
	}
	else if( type.IsSingle() ){
		float flt = (float)dbl;
		compiler.GetObjectModule().meta.GetGlobalVars().initAreaBuffer.Overwrite(
			offset,
			(const char *)&flt,
			sizeof(float)
		);
	}
	else if( type.Is64() || type.IsPointer() ){
		if(type.GetBasicType()==typeOfPtrChar){
			//萔̂Ƃ

			char *temp;
			temp=(char *)i64data;
			i2=compiler.GetObjectModule().dataTable.AddString( temp );
			HeapDefaultFree(temp);

			//mov rax,DataPos
			compiler.codeGenerator.op_mov_RV(sizeof(_int64),REG_RAX,i2, Schedule::DataTable );

			//mov qword ptr[offset],rax
			compiler.codeGenerator.op_mov_MR(sizeof(_int64),REG_RAX,0,offset,MOD_DISP32, Schedule::GlobalVar );
		}
		else{
			compiler.GetObjectModule().meta.GetGlobalVars().initAreaBuffer.Overwrite(
				offset,
				(const char *)&i64data,
				sizeof(_int64)
			);
		}
	}
	else if( type.IsDWord() || type.IsLong() ){
		long l = (long)i64data;
		compiler.GetObjectModule().meta.GetGlobalVars().initAreaBuffer.Overwrite(
			offset,
			(const char *)&l,
			sizeof(long)
		);
	}
	else if( type.IsWord() || type.IsInteger() ){
		short s = (short)i64data;
		compiler.GetObjectModule().meta.GetGlobalVars().initAreaBuffer.Overwrite(
			offset,
			(const char *)&s,
			sizeof(short)
		);
	}
	else if( type.IsSByte() || type.IsByte() || type.IsBoolean() ){
		char c = (char)i64data;
		compiler.GetObjectModule().meta.GetGlobalVars().initAreaBuffer.Overwrite(
			offset,
			(const char *)&c,
			sizeof(char)
		);
	}

	return true;
}
bool InitLocalVar(int offset,const Type &type,const Subscripts &subscripts,const char *lpszInitBuf){
	int i2,i3;
	char temporary[VN_SIZE];
	char InitBuf[VN_SIZE];
	lstrcpy( InitBuf, lpszInitBuf );

	if(InitBuf[0]=='['){
		SlideString(InitBuf+1,-1);
		InitBuf[lstrlen(InitBuf)-1]=0;

		int typeSize = type.GetSize();

		if( subscripts.size() > 0 ){
			Subscripts nestSubscripts;
			for( int i=1; i<(int)subscripts.size(); i++ )
			{
				nestSubscripts.push_back( subscripts[i] );
			}

			typeSize*=JumpSubScripts( nestSubscripts );
			{
				int i=0;
				i2=0;
				while(1){
					if( subscripts[0] < i2 ){
						SetError(41,0,cp);
						return 0;
					}
					i=GetOneParameter(InitBuf,i,temporary);
					if(!InitLocalVar(
						offset+i2*typeSize,
						type,
						nestSubscripts,
						temporary)) return false;
					i2++;
					if(InitBuf[i]=='\0') break;
				}
			}
			return true;
		}

		if(type.IsStruct()){
			const CClass &objClass = type.GetClass();

			int i = 0;
			BOOST_FOREACH( CMember *pMember, objClass.GetDynamicMembers() ){
				if(InitBuf[i]=='\0'){
					SetError(41,0,cp);
					return false;
				}

				i=GetOneParameter(InitBuf,i,temporary);

				i3=objClass.GetMemberOffset( pMember->GetName().c_str(), NULL );

				if(!InitLocalVar(offset+i3,
					pMember->GetType(),
					pMember->GetSubscripts(),
					temporary)) return false;

				if(InitBuf[i]=='\0') break;
			}
			return true;
		}

		SetError(41,0,cp);
		return false;
	}


	///////////////////////////////////////
	// Pi[]ň͂܂ĂȂj
	///////////////////////////////////////

	if( subscripts.size() > 0 ){
		SetError(41,0,cp);
		return false;
	}

	double dbl;
	_int64 i64data;
	Type calcType;

	if( !StaticCalculation(false, InitBuf,type.GetBasicType(),&i64data,calcType) ){
		//If[^ꍇ
		return false;
	}
	if( calcType.IsReal() ){
		memcpy(&dbl,&i64data,sizeof(double));
		i64data=(_int64)dbl;
	}
	else dbl=(double)i64data;

	//^`FbN
	CheckDifferentType(
		type,
		calcType,
		0,0);

	if( type.IsDouble() ){
		memcpy(&i64data,&dbl,sizeof(double));

		//mov rax,i64data
		compiler.codeGenerator.op_mov_RV64(REG_RAX,i64data);

		//mov qword ptr[rsp+offset],rax
		compiler.codeGenerator.localVarPertialSchedules.push_back(
			compiler.codeGenerator.op_mov_MR(sizeof(_int64),REG_RAX,REG_RSP,offset,MOD_BASE_DISP32, Schedule::None, true )
		);
	}
	else if( type.IsSingle() ){
		float flt;
		flt=(float)dbl;

		//mov dword ptr[rsp+offset],value
		compiler.codeGenerator.localVarPertialSchedules.push_back(
			compiler.codeGenerator.op_mov_MV(sizeof(long),REG_RSP,offset, Schedule::None, true, USE_OFFSET,*(int *)&flt)
		);
	}
	else if( type.Is64() || type.IsPointer() ){
		if(type.GetBasicType()==typeOfPtrChar ){
			//萔̂Ƃ

			char *temp;
			temp=(char *)i64data;
			i2=compiler.GetObjectModule().dataTable.AddString( temp );
			HeapDefaultFree(temp);

			//mov rax,i2
			compiler.codeGenerator.op_mov_RV(sizeof(_int64),REG_RAX,i2, Schedule::DataTable );

			//mov qword ptr[rsp+offset],rax
			compiler.codeGenerator.localVarPertialSchedules.push_back(
				compiler.codeGenerator.op_mov_MR(sizeof(_int64),REG_RAX,REG_RSP,offset,MOD_BASE_DISP32, Schedule::None, true )
			);
		}
		else{
			if(i64data&0xFFFFFFFF00000000){
				//mov rax,i64data
				compiler.codeGenerator.op_mov_RV64(REG_RAX,i64data);

				//mov qword ptr[rsp+offset],rax
				compiler.codeGenerator.localVarPertialSchedules.push_back(
					compiler.codeGenerator.op_mov_MR(sizeof(_int64),REG_RAX,REG_RSP,offset,MOD_BASE_DISP32, Schedule::None, true )
				);
			}
			else{
				//mov qword ptr[rsp+offset],value
				compiler.codeGenerator.localVarPertialSchedules.push_back(
					compiler.codeGenerator.op_mov_MV(sizeof(_int64),REG_RSP,offset, Schedule::None, true, USE_OFFSET,(int)i64data)
				);
			}
		}
	}
	else if( type.IsDWord() || type.IsLong() ){
		//mov dword ptr[rsp+offset],value
		compiler.codeGenerator.localVarPertialSchedules.push_back(
			compiler.codeGenerator.op_mov_MV(sizeof(long),REG_RSP,offset, Schedule::None, true, USE_OFFSET,(int)i64data)
		);
	}
	else if( type.IsWord() || type.IsInteger() ){
		//mov word ptr[rsp+offset],value
		compiler.codeGenerator.localVarPertialSchedules.push_back(
			compiler.codeGenerator.op_mov_MV(sizeof(short),REG_RSP,offset, Schedule::None, true, USE_OFFSET,(int)i64data)
		);
	}
	else if( type.IsSByte() || type.IsByte() || type.IsBoolean() ){
		//mov byte ptr[rsp+offset],value
		compiler.codeGenerator.localVarPertialSchedules.push_back(
			compiler.codeGenerator.op_mov_MV(sizeof(char),REG_RSP,offset, Schedule::None, true, USE_OFFSET,(int)i64data)
		);
	}
	return true;
}

void dim( char *VarName, const Subscripts &subscripts, const Type &type,const char *InitBuf,const char *ConstractParameter,DWORD dwFlags)
{
	if( UserProc::IsGlobalAreaCompiling() ){
		/////////////////////////
		// O[oϐ
		/////////////////////////

		AddGlobalVariable(VarName,subscripts,type,InitBuf,ConstractParameter,dwFlags);
	}
	else{
		/////////////////
		// [Jϐ
		/////////////////

		if( UserProc::CompilingUserProc().GetLocalVars().DuplicateCheck( VarName ) ){
			//Qd`̃G[
			SetError(15,VarName,cp);
			return;
		}

		bool isConst = ( dwFlags & DIMFLAG_CONST ) ? true:false;

		Variable *pVar = new Variable( VarName, type, isConst, false, ConstractParameter, false );

		if( subscripts.size() > 0 ){
			//z񂠂
			pVar->SetArray( subscripts );
		}

		//LVJXR[v
		pVar->SetScopeLevel( compiler.codeGenerator.lexicalScopes.GetNowLevel() );
		pVar->SetScopeStartAddress( compiler.codeGenerator.lexicalScopes.GetStartAddress() );
		pVar->bLiving=TRUE;

		//G[p
		pVar->source_code_address=cp;

		// ϐǉ
		UserProc::CompilingUserProc().GetLocalVars().push_back( pVar );

		//ACgl
		if( pVar->GetType().IsStruct() ){
			int alignment = pVar->GetType().GetClass().GetFixedAlignment();

			if( alignment ){
				if( AllLocalVarSize % alignment ){
					AllLocalVarSize += alignment - (AllLocalVarSize % alignment);
				}
			}

			if( alignment == PTR_SIZE*2 ){
				// |C^ɗvTCY傫ȃACgw肳ĂƂ
				// i:CONTEXT\̂Ȃǁj
				// ĂяõItZbgYl

				if( 0 == ( UserProc::CompilingUserProc().RealParams().GetMemorySize() + PTR_SIZE/*ret*/ ) % alignment ){
					AllLocalVarSize += PTR_SIZE;
				}
			}
		}

		AllLocalVarSize += pVar->GetMemorySize();
		pVar->SetOffsetAddress( AllLocalVarSize );

		//LVJXR[v
		pVar->SetScopeLevel( compiler.codeGenerator.lexicalScopes.GetNowLevel() );
		pVar->SetScopeStartAddress( compiler.codeGenerator.lexicalScopes.GetStartAddress() );
		pVar->bLiving=TRUE;

		if(InitBuf[0]){
			//̂݁A݃ANZX
			if( isConst ){
				pVar->ConstOff();
			}

			int result = 0;
			if( !pVar->GetType().IsObject() ){
				result = InitLocalVar(-pVar->GetOffsetAddress(),
					pVar->GetType(),
					pVar->GetSubscripts(),
					InitBuf);
			}

			if(!result){
				//IȎꍇ͑Zs
				char temporary[8192];
				sprintf(temporary,"%s=%s",VarName,InitBuf);
				OpcodeCalc(temporary);
			}

			if( isConst ){
				pVar->ConstOn();
			}
		}
		else{
			//0

			//mov r8, 0
			compiler.codeGenerator.op_zero_reg( REG_R8 );

			//mov rdx, VarSize
			compiler.codeGenerator.op_mov_RV( sizeof(_int64), REG_RDX, pVar->GetMemorySize() );

			//mov rcx, rsp
			compiler.codeGenerator.op_mov_RR( REG_RCX, REG_RSP );

			//add rcx, offset
			compiler.codeGenerator.localVarPertialSchedules.push_back(
				compiler.codeGenerator.op_add_RV( REG_RCX, -pVar->GetOffsetAddress(), Schedule::None, true )
			);

			//call FillMemory
			DllProc *pDllProc;
			pDllProc=GetDeclareHash("FillMemory");
			compiler.codeGenerator.op_call( pDllProc );
		}
	}

	//RXgN^Ăяo
	if( type.IsObject() &&(dwFlags&DIMFLAG_NONCALL_CONSTRACTOR)==0&&InitBuf[0]=='\0'){
		char objectSize[255];
		if( subscripts.size() == 0 ){
			objectSize[0] = 0;
		}
		else{
			if( subscripts.size() > 1 ){
				SetError(300,NULL,cp);
			}
			sprintf( objectSize, "%d", subscripts[0] );
		}
		Operator_New( type.GetClass(), objectSize, ConstractParameter, type );

		Type tempType;
		RELATIVE_VAR RelativeVar;
		GetVarOffset( true, false, VarName, &RelativeVar, tempType );
		if( RelativeVar.dwKind == VAR_DIRECTMEM ){
			SetError();
		}
		SetVariableFromRax( Type( DEF_OBJECT, *compiler.GetObjectModule().meta.GetClasses().GetObjectClassPtr() ), DEF_OBJECT, &RelativeVar );
	}
}
void SetVarPtrToReg(int reg,RELATIVE_VAR *pRelativeVar){
	if(!IsGeneralReg(reg)) SetError(300,NULL,cp);

	if(pRelativeVar->dwKind==VAR_GLOBAL){
		if(pRelativeVar->bOffsetOffset){
			//add r11,offset
			compiler.codeGenerator.op_add_RV( REG_R11, (long)pRelativeVar->offset, Schedule::GlobalVar );

			//mov reg,r11
			compiler.codeGenerator.op_mov_RR(reg,REG_R11);
		}
		else{
			//mov reg,offset
			compiler.codeGenerator.op_mov_RV( sizeof(_int64), reg, (long)pRelativeVar->offset, Schedule::GlobalVar );
		}
	}
	else if( pRelativeVar->dwKind == VAR_REFGLOBAL ){
		if(pRelativeVar->bOffsetOffset){
			//add r11,qword ptr[offset]
			compiler.codeGenerator.op_add_RM( sizeof(_int64), REG_R11, REG_NON, (int)pRelativeVar->offset, MOD_DISP32, Schedule::GlobalVar );
		}
		else{
			//mov r11,qword ptr[offset]
			compiler.codeGenerator.op_mov_RM(sizeof(_int64),REG_R11,REG_NON,(int)pRelativeVar->offset,MOD_DISP32, Schedule::GlobalVar );
		}

		goto directmem;
	}
	else if(pRelativeVar->dwKind==VAR_LOCAL){
		if(pRelativeVar->bOffsetOffset){
			//add r11,offset
			compiler.codeGenerator.localVarPertialSchedules.push_back(
				compiler.codeGenerator.op_add_RV( REG_R11, (long)pRelativeVar->offset, Schedule::None, true )
			);

			//add r11,rsp
			compiler.codeGenerator.op_add_RR(REG_R11,REG_RSP);

			//mov reg,r11
			compiler.codeGenerator.op_mov_RR(reg,REG_R11);
		}
		else{
			//mov reg,rsp
			compiler.codeGenerator.op_mov_RR(reg,REG_RSP);

			//add reg,offset
			compiler.codeGenerator.localVarPertialSchedules.push_back(
				compiler.codeGenerator.op_add_RV(reg,(long)pRelativeVar->offset, Schedule::None, true )
			);
		}
	}
	else if( pRelativeVar->dwKind == VAR_REFLOCAL ){
		if(pRelativeVar->bOffsetOffset){
			//add r11,qword ptr[rsp+offset]
			compiler.codeGenerator.localVarPertialSchedules.push_back(
				compiler.codeGenerator.op_add_RM( sizeof(_int64), REG_R11, REG_RSP, (long)pRelativeVar->offset, MOD_BASE_DISP32, Schedule::None, true )
			);
		}
		else{
			//mov r11,qword ptr[rsp+offset]
			compiler.codeGenerator.localVarPertialSchedules.push_back(
				compiler.codeGenerator.op_mov_RM(sizeof(_int64),REG_R11,REG_RSP,(int)pRelativeVar->offset,MOD_BASE_DISP32, Schedule::None, true )
			);
		}

		goto directmem;
	}
	else if(pRelativeVar->dwKind==VAR_DIRECTMEM){
directmem:
		//mov reg,r11
		compiler.codeGenerator.op_mov_RR(reg,REG_R11);
	}
}

bool Compile_AddGlobalRootsForGc(){
	const UserProc *pUserProc_AddGlobalRootPtr = GetClassMethod( "_System_CGarbageCollection", "AddGlobalRootPtr" );
	if( !pUserProc_AddGlobalRootPtr ){
		SetError(3, "_System_CGarbageCollection.AddGlobalRootPtr", -1 );
		return false;
	}

	BOOST_FOREACH( const Variable *pVar, compiler.GetObjectModule().meta.GetGlobalVars() ){
		if( pVar->GetType().IsObject() || pVar->GetType().IsPointer() || pVar->GetType().IsStruct() ){
			// IuWFNg܂̓|C^Ƃ
			// \̂܂ށibΉj

			// ϐ̈ɗvLONG_PTRPʂ̌n
			//mov r8,count
			compiler.codeGenerator.op_mov_RV(sizeof(_int64), REG_R8,pVar->GetMemorySize()/PTR_SIZE);

			// [g|C^n
			//mov rdx,offset
			compiler.codeGenerator.op_mov_RV(sizeof(_int64), REG_RDX,(int)pVar->GetOffsetAddress(), Schedule::GlobalVar );

			// This|C^n
			SetThisPtrToReg(REG_RCX);

			// call AddGlobalRootPtr
			compiler.codeGenerator.op_call( pUserProc_AddGlobalRootPtr );
		}
	}

	return true;
}
