#include "stdafx.h"

#include <jenga/include/smoothie/Smoothie.h>
#include <jenga/include/smoothie/SmoothieException.h>

#include <Class.h>

using namespace std;

const int Type::basicTypeList[] = {
	DEF_BYTE,
	DEF_SBYTE,
	DEF_WORD,
	DEF_INTEGER,
	DEF_DWORD,
	DEF_LONG,
	DEF_QWORD,
	DEF_INT64,

	DEF_SINGLE,
	DEF_DOUBLE,

	DEF_BOOLEAN,

	DEF_PTR_VOID,

	DEF_ANY,

	DEF_NON
};

const string Type::basicTypeNameList[] = {
	"Byte",
	"SByte",
	"Word",
	"Integer",
	"DWord",
	"Long",
	"QWord",
	"Int64",

	"Single",
	"Double",

	"Boolean",

	"VoidPtr",

	"Any",

	""
};

Type::~Type()
{
}

bool Type::StringToBasicType( const string &typeName, int &basicType ){
	for( int i=0; ; i++ ){
		if( basicTypeList[i] == DEF_NON ){
			break;
		}
		if( basicTypeNameList[i] == typeName ){
			basicType = basicTypeList[i];
			return true;
		}
	}
	return false;
}
const char *Type::BasicTypeToCharPtr( const Type &type )
{
	for( int i=0; ; i++ ){
		if( basicTypeList[i] == DEF_NON ){
			break;
		}
		if( basicTypeList[i] == type.GetBasicType() ){
			return basicTypeNameList[i].c_str();
		}
	}
	return NULL;
}

int Type::GetBasicSize( int basicType )
{

	// {^
	switch( basicType ){
		case DEF_SBYTE:
		case DEF_BYTE:
		case DEF_BOOLEAN:
			return sizeof(BYTE);

		case DEF_INTEGER:
		case DEF_WORD:
			return sizeof(WORD);

		case DEF_LONG:
		case DEF_DWORD:
			return sizeof(DWORD);

		case DEF_INT64:
		case DEF_QWORD:
			return sizeof(_int64);

		case DEF_DOUBLE:
			return sizeof(double);
		case DEF_SINGLE:
			return sizeof(float);
	}

	// |C^
	if(IsPointer( basicType )){
		return PTR_SIZE;
	}

	// IuWFNg
	if(basicType==DEF_OBJECT){
		return PTR_SIZE;
	}

	SmoothieException::Throw();

	return 0;
}

const CClass &Type::GetClass() const
{
	if( !HasMember() )
	{
		Jenga::Throw( "NX܂͍\̂łȂ^ɑ΂GetClassĂяo" );
	}

	return *pClass;
}

bool Type::Equals( const Type &type ) const
{
	if( basicType == type.basicType ){
		if( NATURAL_TYPE( basicType ) == DEF_OBJECT
			|| NATURAL_TYPE( basicType ) == DEF_STRUCT ){

				if( index == type.index ){
					return true;
				}

		}
		else{
			return true;
		}
	}
	return false;
}

int Type::GetBasicSize() const
{
	return GetBasicSize( basicType );
}
int Type::GetSize() const
{

	// {^
	switch( basicType ){
		case DEF_LONG:
			if(index==LITERAL_NULL||index==LITERAL_M128_0||index==LITERAL_0_255){
				return sizeof(BYTE);
			}
			else if(index==LITERAL_M32768_0||index==LITERAL_0_65535){
				return sizeof(WORD);
			}
			return sizeof(DWORD);

		case DEF_SBYTE:
		case DEF_BYTE:
		case DEF_BOOLEAN:
			return sizeof(BYTE);

		case DEF_INTEGER:
		case DEF_WORD:
			return sizeof(WORD);

		case DEF_DWORD:
			return sizeof(DWORD);

		case DEF_INT64:
		case DEF_QWORD:
			return sizeof(_int64);

		case DEF_DOUBLE:
			return sizeof(double);
		case DEF_SINGLE:
			return sizeof(float);
	}

	// |C^
	if(IsPointer()){
		return PTR_SIZE;
	}

	// \
	if( IsStruct() )
	{
		if( !pClass ){
			SmoothieException::Throw();
			return 0;
		}

		return pClass->GetSize();
	}

	// IuWFNg
	if( IsObject() )
	{
		if( GetClass().IsInterface() ){
			// vtblOffset̃TCY܂߂
			return PTR_SIZE*2;
		}
		return PTR_SIZE;
	}

	SmoothieException::Throw();
	return 0;
}

bool Type::IsNull() const{
  if( basicType == DEF_NON ){
	  return true;
  }
  return false;
}

bool Type::IsByte() const{
  if( basicType == DEF_BYTE ){
	  return true;
  }
  return false;
}
bool Type::IsSByte() const{
  if( basicType == DEF_SBYTE ){
	  return true;
  }
  return false;
}
bool Type::IsWord() const{
  if( basicType == DEF_WORD ){
	  return true;
  }
  return false;
}
bool Type::IsInteger() const{
  if( basicType == DEF_INTEGER ){
	  return true;
  }
  return false;
}
bool Type::IsDWord() const{
  if( basicType == DEF_DWORD ){
	  return true;
  }
  return false;
}
bool Type::IsLong() const{
  if( basicType == DEF_LONG ){
	  return true;
  }
  return false;
}
bool Type::IsQWord() const{
  if( basicType == DEF_QWORD ){
	  return true;
  }
  return false;
}
bool Type::IsInt64() const{
  if( basicType == DEF_INT64 ){
	  return true;
  }
  return false;
}
bool Type::IsSingle() const{
  if( basicType == DEF_SINGLE ){
	  return true;
  }
  return false;
}
bool Type::IsDouble() const{
  if( basicType == DEF_DOUBLE ){
	  return true;
  }
  return false;
}
bool Type::IsBoolean() const{
  if( basicType == DEF_BOOLEAN ){
	  return true;
  }
  return false;
}

bool Type::IsPointer( int basicType )
{
	if(PTR_LEVEL( basicType )|| basicType == DEF_PTR_VOID || basicType == DEF_PTR_PROC
		|| ( basicType & FLAG_PTR ) ){
			return true;
	}

	return false;
}
bool Type::IsPointer() const
{
	return IsPointer( basicType );
}
bool Type::IsSigned() const
{
	switch( basicType ){
		case DEF_SBYTE:
		case DEF_INTEGER:
		case DEF_LONG:
		case DEF_INT64:
		case DEF_SINGLE:
		case DEF_DOUBLE:
			return true;
		default:
			break;
	}
	return false;
}
bool Type::IsNaturalWhole() const
{
	switch( basicType ){
		case DEF_SBYTE:
		case DEF_BYTE:
		case DEF_INTEGER:
		case DEF_WORD:
		case DEF_LONG:
		case DEF_DWORD:
		case DEF_INT64:
		case DEF_QWORD:
			return true;
		default:
			break;
	}
	return false;
}
bool Type::IsWhole() const
{
	return (
		IsNaturalWhole()
		|| IsPointer( basicType )
		|| basicType == DEF_BOOLEAN
		);
}
bool Type::IsReal() const
{
	switch( basicType ){
		case DEF_SINGLE:
		case DEF_DOUBLE:
			return true;
		default:
			break;
	}
	return false;
}
bool Type::Is64() const
{
	switch( basicType ){
		case DEF_QWORD:
		case DEF_INT64:
			return true;
		default:
			break;
	}
	return false;
}
bool Type::IsProcPtr() const
{
	if( basicType == DEF_PTR_PROC ){
		return true;
	}
	return false;
}
bool Type::IsStruct() const
{
	if( basicType == DEF_STRUCT ){
		return true;
	}
	return false;
}
bool Type::IsStructPtr() const
{
	if( basicType == DEF_PTR_STRUCT ){
		return true;
	}
	return false;
}
bool Type::IsObject() const
{
	return (
		basicType == DEF_OBJECT
		|| basicType == DEF_TYPE_PARAMETER
	);
}
bool Type::IsObjectPtr() const
{
	if( basicType == DEF_PTR_OBJECT ){
		return true;
	}
	return false;
}
bool Type::IsTypeParameter() const
{
	return ( NATURAL_TYPE(basicType) == DEF_TYPE_PARAMETER );
}
bool Type::IsObjectClass() const
{
	if( basicType == DEF_OBJECT ){
		if( pClass->GetName() == "Object" ){
			return true;
		}
	}
	return false;
}
bool Type::IsStringClass() const
{
	if( basicType == DEF_OBJECT ){
		if( pClass->GetName() == "String" ){
			return true;
		}
	}
	return false;
}
bool Type::IsVoidPtr() const
{
	if( basicType == DEF_PTR_VOID ){
		return true;
	}
	return false;
}

bool Type::IsAny() const
{
	if( basicType == DEF_ANY ){
		return true;
	}
	return false;
}

bool Type::IsDelegate() const
{
	return ( IsObject() && GetClass().IsDelegate() );
}

bool Type::HasMember() const
{
	if( NATURAL_TYPE( basicType ) == DEF_OBJECT
		|| NATURAL_TYPE( basicType ) == DEF_STRUCT
		|| NATURAL_TYPE( basicType ) == DEF_TYPE_PARAMETER
	){
		return true;
	}
	return false;
}

const Type &Type::GetActualGenericType( int index ) const
{
	return actualGenericTypes[index].GetType();
}
bool Type::HasActualGenericType() const
{
	return ( actualGenericTypes.size() > 0 );
}

int Type::GetBasicTypeFromSimpleName( const char *variable ){
	extern char DefIntVari[26],DefSngVari[26],DefStrVari[26],divNum,dsvNum,dStrvNum;
	int i;
	char name[VN_SIZE];

	//\̃ȍꍇl
	for(i=lstrlen(variable);i>0;i--){
		if(variable[i]=='.'){
			i++;
			break;
		}
	}

	for(;;i++){
		if(variable[i]=='('||variable[i]=='\0'){
			name[i]=0;
			break;
		}
		name[i]=variable[i];
	}
	//ϐI
	i--;
	if(name[i]=='#') return DEF_DOUBLE;
	if(name[i]=='!') return DEF_SINGLE;
	if(name[i]=='%') return DEF_INTEGER;
	return DEF_DOUBLE;
}


void ResolveFormalGenericTypeParameter( Type &typeParameter, const Type &classType, const UserProc *pUserProc )
{
	/////////////////////////////////////////////////////////
	//  WFlNXT|[g 

	if( typeParameter.IsTypeParameter() )
	{
		// ^p[^Ƃ

		// |C^x𒊏o
		int ptrLevel = PTR_LEVEL( typeParameter.GetBasicType() );

		if( pUserProc )
		{
			if( classType.IsObject() )
			{
				// NXł̎ȉ
				const CClass *pClass = &classType.GetClass();
				while( pClass->HasSuperClass() )
				{
					if( pUserProc->GetParentClassPtr() == &pClass->GetSuperClass() )
					{
						if( pClass->GetSuperClassActualTypeParameters().size() )
						{
							// TODO: K؂Ȍ`ɎibIɃgbv̌^ĂĂj
							typeParameter = pClass->GetSuperClassActualTypeParameters()[0];
						}
					}
					pClass = &pClass->GetSuperClass();
				}
			}
		}

		if( typeParameter.IsTypeParameter() )
		{
			if( classType.HasActualGenericType() )
			{
				typeParameter = classType.GetActualGenericType( typeParameter.GetFormalTypeIndex() );
			}
			else
			{
				// TODO: x[XIuWFNgiw肳ĂȂƂObjectNXjɃZbg
				typeParameter.SetBasicType( DEF_OBJECT );
			}
		}

		for( int i=0; i<ptrLevel; i++ )
		{
			typeParameter.PtrLevelUp();
		}
	}

	//
	/////////////////////////////////////////////////////////
}


const string BlittableType::GetCreateStaticMethodFullName() const
{
	return pClass->GetNamespaceScopes().ToString() + "." + pClass->GetName() + "._Create";
}
