#include "stdafx.h"

#include <jenga/include/smoothie/Smoothie.h>
#include <jenga/include/smoothie/LexicalAnalysis.h>

#include <Compiler.h>
#include <../Enum.h>

#include "common.h"

CEnumParent **ppobj_EnumParent;
int iEnumParentNum;

CEnumMember::CEnumMember(char *name,int value){
	m_name=(char *)HeapAlloc(hHeap,0,lstrlen(name)+1);
	lstrcpy(m_name,name);

	m_value=value;
}
CEnumMember::~CEnumMember(){
	if(m_name) HeapDefaultFree(m_name);
}


CEnumParent::CEnumParent( const NamespaceScopes &namespaceScopes, const char *buffer,int nowLine)
	: namespaceScopes( namespaceScopes )
{
	ppobj_EnumMember=(CEnumMember **)HeapAlloc(hHeap,0,1);
	iEnumMemberNum=0;

	int i=0,i2;

	if(!(buffer[i]==1&&buffer[i+1]==ESC_ENUM)) return;
	i+=2;

	//񋓑̖̂O擾
	char temporary[VN_SIZE];
	for(i2=0;;i++,i2++){
		if(IsCommandDelimitation(buffer[i])){
			temporary[i2]=0;
			break;
		}
		if(!IsVariableChar(buffer[i])){
			SetError(1,NULL,i);
			break;
		}
		temporary[i2]=buffer[i];
	}

	name = temporary;

	if(buffer[i]=='\0'){
		SetError(22,"Enum",nowLine);
		return;
	}

	int NextValue=0;
	while(1){
		i++;

		if(buffer[i]==1&&buffer[i+1]==ESC_ENDENUM) break;

		for(i2=0;;i2++,i++){
			if(IsCommandDelimitation(buffer[i])){
				temporary[i2]=0;
				break;
			}
			if(buffer[i]=='='){
				temporary[i2]=0;
				break;
			}
			temporary[i2]=buffer[i];
		}
		if(temporary[0]=='\0'){
			if(buffer[i]=='\0'){
				SetError(22,"Enum",nowLine);
				break;
			}
			continue;
		}

		if(buffer[i]!='='){
			NextValue++;
		}
		else{
			char temp2[VN_SIZE];
			for(i++,i2=0;;i2++,i++){
				if(IsCommandDelimitation(buffer[i])){
					temp2[i2]=0;
					break;
				}
				temp2[i2]=buffer[i];
			}
			NextValue=atoi(temp2);
		}

		//oǉ
		ppobj_EnumMember=(CEnumMember **)HeapReAlloc(hHeap,0,ppobj_EnumMember,(iEnumMemberNum+1)*sizeof(CEnumMember *));
		ppobj_EnumMember[iEnumMemberNum]=new CEnumMember(temporary,NextValue);
		iEnumMemberNum++;
	}
}
CEnumParent::~CEnumParent(){
	int i;
	for(i=0;i<iEnumMemberNum;i++){
		delete ppobj_EnumMember[i];
	}
	HeapDefaultFree(ppobj_EnumMember);
}



void CEnumParent::InitEnum(void){
	ppobj_EnumParent=(CEnumParent **)HeapAlloc(hHeap,0,1);
	iEnumParentNum=0;

	const char *source = compiler.GetObjectModule().GetCurrentSource().GetBuffer();

	// OԊǗ
	NamespaceScopes &namespaceScopes = compiler.GetNamespaceSupporter().GetLivingNamespaceScopes();
	namespaceScopes.clear();

	int i2;
	char temporary[VN_SIZE];
	for(int i=0;;i++){
		if(source[i]=='\0') break;

		if( source[i] == 1 && source[i+1] == ESC_NAMESPACE ){
			for(i+=2,i2=0;;i2++,i++){
				if( IsCommandDelimitation( source[i] ) ){
					temporary[i2]=0;
					break;
				}
				temporary[i2]=source[i];
			}
			namespaceScopes.push_back( temporary );

			continue;
		}
		else if( source[i] == 1 && source[i+1] == ESC_ENDNAMESPACE ){
			if( namespaceScopes.size() <= 0 ){
				SetError(12, "End Namespace", i );
			}
			else{
				namespaceScopes.pop_back();
			}

			i += 2;
			continue;
		}

		if(source[i]==1&&source[i+1]==ESC_ENUM){
			if(i>=2){
				if(source[i-2]==1&&source[i-1]==ESC_CONST) continue;
			}
			ppobj_EnumParent=(CEnumParent **)HeapReAlloc(hHeap,0,ppobj_EnumParent,(iEnumParentNum+1)*sizeof(CEnumParent *));
			ppobj_EnumParent[iEnumParentNum]=new CEnumParent( namespaceScopes, source+i,i);
			iEnumParentNum++;
		}
	}
}
void CEnumParent::DestroyEnum(void){
	int i;
	for(i=0;i<iEnumParentNum;i++){
		delete ppobj_EnumParent[i];
	}
	HeapDefaultFree(ppobj_EnumParent);
}

char *CEnumParent::GenerateSourceCode(void){
	char *buffer;
	int MaxSize,length;
	MaxSize=65535;
	buffer=(char *)HeapAlloc(hHeap,0,MaxSize+65535);
	length=0;

	buffer[0]=0;

	for(int i=0;i<iEnumParentNum;i++){
		CEnumParent *parent;
		parent=ppobj_EnumParent[i];

		BOOST_FOREACH( const string &namespaceStr, parent->GetNamespaceScopes() ){
			sprintf(buffer+length,"Namespace %s\n",namespaceStr.c_str());
			length+=lstrlen(buffer+length);
		}

		sprintf(buffer+length,"Class Enum %s\n",parent->GetName().c_str());
		length+=lstrlen(buffer+length);
		lstrcpy(buffer+length,"\tInherits EnumBase\n");
		length+=lstrlen(buffer+length);
		sprintf(buffer+length,"\tSub %s(value As Long,lpszName As LPSTR)\n",parent->GetName().c_str());
		length+=lstrlen(buffer+length);
		lstrcpy(buffer+length,"\t\tEnumBase(value,lpszName)\n");
		length+=lstrlen(buffer+length);
		lstrcpy(buffer+length,"\tEnd Sub\n");
		length+=lstrlen(buffer+length);
		lstrcpy(buffer+length,"Public\n");
		length+=lstrlen(buffer+length);
		sprintf(buffer+length,"\tSub %s()\n",parent->GetName().c_str());
		length+=lstrlen(buffer+length);
		if(parent->iEnumMemberNum){
			sprintf(buffer+length,"\t\tEnumBase(%d,\"%s\")\n",
				parent->ppobj_EnumMember[0]->m_value,
				parent->ppobj_EnumMember[0]->m_name);
			length+=lstrlen(buffer+length);
		}
		lstrcpy(buffer+length,"\tEnd Sub\n");
		length+=lstrlen(buffer+length);
		sprintf(buffer+length,"\tSub ~%s()\n",parent->GetName().c_str());
		length+=lstrlen(buffer+length);
		lstrcpy(buffer+length,"\tEnd Sub\n");
		length+=lstrlen(buffer+length);

		for(int i2=0;i2<parent->iEnumMemberNum;i2++){
			CEnumMember *member;
			member=parent->ppobj_EnumMember[i2];

			sprintf(buffer+length,"\tStatic %s As %s(%d,\"%s\")\n",
				member->m_name,
				parent->GetName().c_str(),
				member->m_value,
				member->m_name);
			length+=lstrlen(buffer+length);
		}

		sprintf(buffer+length,"\tFunction Operator or (enumBase As %s) As %s\n",parent->GetName().c_str(),parent->GetName().c_str());
		length+=lstrlen(buffer+length);
		sprintf(buffer+length,"\t\tReturn New %s(This.value or enumBase.value, \"custom\")\n",parent->GetName().c_str());
		length+=lstrlen(buffer+length);
		lstrcpy(buffer+length,"\tEnd Function\n");
		length+=lstrlen(buffer+length);

		sprintf(buffer+length,"\tFunction Operator and (enumBase As %s) As %s\n",parent->GetName().c_str(),parent->GetName().c_str());
		length+=lstrlen(buffer+length);
		sprintf(buffer+length,"\t\tReturn New %s(This.value and enumBase.value, \"custom\")\n",parent->GetName().c_str());
		length+=lstrlen(buffer+length);
		lstrcpy(buffer+length,"\tEnd Function\n");
		length+=lstrlen(buffer+length);

		/*
		sprintf(buffer+length,"\tOverride Function ToString() As String\n",parent->TypeName);
		length+=lstrlen(buffer+length);
		lstrcpy(buffer+length,"\t\tSelect Case value\n");
		length+=lstrlen(buffer+length);
		for(i2=0;i2<parent->iEnumMemberNum;i2++){
			CEnumMember *member;
			member=parent->ppobj_EnumMember[i2];

			sprintf(buffer+length,"\t\t\tCase %d\n",member->m_value);
			length+=lstrlen(buffer+length);
			sprintf(buffer+length,"\t\t\t\tReturn \"%s\"\n",member->m_name);
			length+=lstrlen(buffer+length);
		}
		lstrcpy(buffer+length,"\t\tEnd Select\n");
		length+=lstrlen(buffer+length);
		lstrcpy(buffer+length,"\tEnd Function\n");
		length+=lstrlen(buffer+length);

		
		sprintf(buffer+length,"\tSub Operator= (ByRef value As %s)\n",parent->TypeName);
		length+=lstrlen(buffer+length);
		lstrcpy(buffer+length,"\t\tThis.Copy(ByVal VarPtr(value))\n");
		length+=lstrlen(buffer+length);
		lstrcpy(buffer+length,"\tEnd Sub\n");
		length+=lstrlen(buffer+length);

		sprintf(buffer+length,"\tSub Operator= (ByRef value As String)\n",parent->TypeName);
		length+=lstrlen(buffer+length);
		lstrcpy(buffer+length,"\t\tSelect Case value\n");
		length+=lstrlen(buffer+length);
		for(i2=0;i2<parent->iEnumMemberNum;i2++){
			CEnumMember *member;
			member=parent->ppobj_EnumMember[i2];

			sprintf(buffer+length,"\t\t\tCase \"%s\"\n",member->m_name);
			length+=lstrlen(buffer+length);
			sprintf(buffer+length,"\t\t\t\tThis=%s.%s\n",parent->TypeName,member->m_name);
			length+=lstrlen(buffer+length);
		}
		lstrcpy(buffer+length,"\t\tEnd Select\n");
		length+=lstrlen(buffer+length);
		lstrcpy(buffer+length,"\tEnd Sub\n");
		length+=lstrlen(buffer+length);

		sprintf(buffer+length,"\tSub Operator= (value As Long)\n",parent->TypeName);
		length+=lstrlen(buffer+length);
		lstrcpy(buffer+length,"\t\tm_Value=value\n");
		length+=lstrlen(buffer+length);
		lstrcpy(buffer+length,"\tEnd Sub\n");
		length+=lstrlen(buffer+length);*/

		lstrcpy(buffer+length,"End Class\n");
		length+=lstrlen(buffer+length);

		BOOST_FOREACH( const string &namespaceStr, parent->GetNamespaceScopes() ){
			lstrcpy( buffer+length, "End Namespace\n" );
			length+=lstrlen(buffer+length);
		}


		//obt@̈悪ȂȂꍇ̓obt@𑝗ʂ
		if(length>MaxSize){
			MaxSize+=65535;
			buffer=(char *)HeapReAlloc(hHeap,0,buffer,MaxSize+65535);
		}
	}

#ifdef _DEBUG
	// O𐶐
	Jenga::Common::Logger logger( Jenga::Common::Environment::GetAppDir() + "\\enum_generated.log", false );
	logger << buffer << endl;
#endif

	return buffer;
}
