#include "stdafx.h"

#include <jenga/include/smoothie/Smoothie.h>
#include <jenga/include/smoothie/LexicalAnalysis.h>

#include <Program.h>
#include <Compiler.h>
#include <Class.h>

#include "../BasicCompiler_Common/common.h"
#include "Opcode.h"

void SystemProc( const UserProc &userProc ){
	if( userProc.GetName() == "_System_GetEip" ){
		//mov rax,qword ptr[rsp]
		compiler.codeGenerator.op_mov_RM(sizeof(_int64),REG_RAX,REG_RSP,0,MOD_BASE);

		//ret
		compiler.codeGenerator.op_ret();
	}
	else if( userProc.GetName() == "_System_InitDllGlobalVariables" ){
		////////////////////////////////////////
		// DLL̃O[öRpC
		////////////////////////////////////////
		if(!compiler.IsDll()){
			//ret
			compiler.codeGenerator.op_ret();

			return;
		}

		const UserProc *pBackUserProc = &UserProc::CompilingUserProc();
		UserProc::CompileStartForGlobalArea();

		int BackCp;
		BackCp=cp;
		cp=-1;

		//sub rsp,X^bNt[TCY
		const PertialSchedule *pStackFramePertialSchedule = compiler.codeGenerator.op_sub_rsp( 0, true );

		extern BOOL bDebugCompile;
		if(bDebugCompile){
			//fobOp̕ϐ`
			DebugVariable();
		}

		//GCp̕ϐ`
		InitGCVariables();

		//_System_StartupProgram̌Ăяo
		extern const UserProc *pSub_System_StartupProgram;
		compiler.codeGenerator.op_call(pSub_System_StartupProgram);

		//NXɑÓIo`
		compiler.GetObjectModule().meta.GetClasses().InitStaticMember();

		GetGlobalDataForDll();

		//add rsp,X^bNt[TCY
		compiler.codeGenerator.op_add_RV(REG_RSP,pobj_sf->GetFrameSize(0));

		//X^bNt[XPW[isubR}hɓnlj
		compiler.codeGenerator.opfix( pStackFramePertialSchedule, pobj_sf->GetFrameSize(0) );

		UserProc::CompileStartForUserProc( pBackUserProc );
		cp=BackCp;

		//ret
		compiler.codeGenerator.op_ret();
	}
	else if( userProc.GetName() == "_System_InitStaticLocalVariables" ){
		//ÓI[JIuWFNg̃RXgN^Ăяo

		//sub rsp,X^bNt[TCY
		const PertialSchedule *pStackFramePertialSchedule = compiler.codeGenerator.op_sub_rsp( 0, true );

		BOOST_FOREACH( Variable *pVar, compiler.GetObjectModule().meta.GetGlobalVars() ){
			if(memicmp(pVar->GetName().c_str(),"Static%",7)==0){
				//RXgN^Ăяo
				if( pVar->GetType().IsObject() ){

					//G[p
					cp=pVar->source_code_address;

					CallConstructor(
						pVar->GetName().c_str(),
						pVar->GetSubscripts(),
						pVar->GetType(),
						pVar->GetParamStrForConstructor().c_str());
				}
			}
		}

		//add rsp,X^bNt[TCY
		compiler.codeGenerator.op_add_RV(REG_RSP,pobj_sf->GetFrameSize(0));

		//X^bNt[XPW[isubR}hɓnlj
		compiler.codeGenerator.opfix( pStackFramePertialSchedule, pobj_sf->GetFrameSize(0) );

		//ret
		compiler.codeGenerator.op_ret();
	}
	else if( userProc.GetName() == "_System_Call_Destructor_of_GlobalObject" ){
		//sub rsp,8iRSP16oCgEɂ킹邽߁j
		compiler.codeGenerator.op_sub_rsp(0x8);


		const UserProc *pBackUserProc = &UserProc::CompilingUserProc();
		UserProc::CompileStartForGlobalArea();

		compiler.codeGenerator.lexicalScopes.CallDestructorsOfScopeEnd();

		UserProc::CompileStartForUserProc( pBackUserProc );


		//add rsp,8
		compiler.codeGenerator.op_add_RV(REG_RSP,0x8);

		//ret
		compiler.codeGenerator.op_ret();
	}
	else if( userProc.GetName() == "_System_GetSp" ){
		//mov rax,rsp
		compiler.codeGenerator.op_mov_RR(REG_RAX,REG_RSP);

		//add rax,PTR_SIZE
		compiler.codeGenerator.op_add_RV(REG_RAX,PTR_SIZE);

		//ret
		compiler.codeGenerator.op_ret();
	}
	else{
		SetError();
	}
}
void AutoGeneration(const UserProc &userProc){
	if( userProc.GetName() == "InitializeUserTypes"
		&& userProc.HasParentClass()
		&& userProc.GetParentClass().GetName() == "_System_TypeBase" ){
			compiler.GetObjectModule().meta.GetClasses().Compile_System_InitializeUserTypes();
	}
	else if( userProc.GetName() == "RegisterGlobalRoots"
		&& userProc.HasParentClass()
		&& userProc.GetParentClass().GetName() == "_System_CGarbageCollection" ){

			Compile_AddGlobalRootsForGc();
	}
	else if( userProc.GetName() == compiler.globalAreaProcName ){
		////////////////////////////////////////
		// O[öRpC
		////////////////////////////////////////

		const UserProc *pBackUserProc = &UserProc::CompilingUserProc();
		UserProc::CompileStartForGlobalArea();

		int BackCp = cp;
		cp=-1;

		//NXɑÓIo`
		compiler.GetObjectModule().meta.GetClasses().InitStaticMember();

		//O[os̈RpCJn
		CompileBuffer(0,0);

		//GotomxXPW[݂G[ɂ
		BOOST_FOREACH( const GotoLabelSchedule *pGotoLabelSchedule, compiler.codeGenerator.gotoLabelSchedules )
		{
			if(pGotoLabelSchedule->GetName().size()>0){
				SetError(6,pGotoLabelSchedule->GetName(),pGotoLabelSchedule->GetSourceCodePos());
			}
			else{
				char temporary[255];
				sprintf(temporary,"%d",pGotoLabelSchedule->GetLineNum());
				SetError(6,temporary,pGotoLabelSchedule->GetSourceCodePos());
			}
		}

		UserProc::CompileStartForUserProc( pBackUserProc );
		cp=BackCp;
	}
	else{
		SetError();
	}
}
void _compile_proc(const UserProc *pUserProc){
	extern char *basbuf;
	extern HANDLE hHeap;
	extern BOOL bDebugCompile;
	int i3,i4;
	char temporary[VN_SIZE];

	if( pUserProc->GetLocalVars().size() ){
		SetError();
		return;
	}

	trace_for_sourcecodestep( " " << pUserProc->GetFullName() << "̃RpCJn" );

	pUserProc->CompleteCompile();

	extern BOOL bSystemProc;
	if(memcmp(pUserProc->GetName().c_str(),"_System_",8)==0) bSystemProc=1;
	else bSystemProc=0;

	extern BOOL bDebugSupportProc;
	if(memcmp(pUserProc->GetName().c_str(),"_DebugSys_",10)==0){
		if(!bDebugCompile){
			return;
		}
		bDebugSupportProc=1;
	}
	else bDebugSupportProc=0;

	//RpC̊֐NX
	compiler.pCompilingClass=pUserProc->GetParentClassPtr();

	//RpCX^[gNXǗNXɒǉ
	compiler.GetObjectModule().meta.GetClasses().StartCompile( pUserProc );

	//RpC̊֐
	UserProc::CompileStartForUserProc( pUserProc );

	// RpC̊֐閼O
	compiler.GetNamespaceSupporter().SetLivingNamespaceScopes( pUserProc->GetNamespaceScopes() );

	// RpC̊֐ImportsĂ閼O
	compiler.GetNamespaceSupporter().SetImportedNamespaces( pUserProc->GetImportedNamespaces() );

	// R[hΏۂI
	compiler.codeGenerator.Select( (const_cast<UserProc *>(pUserProc))->GetNativeCode() );

	if(pUserProc->IsSystem()){
		////////////////////
		// ֐
		////////////////////

		extern int AllLocalVarSize;
		AllLocalVarSize=0;

		//X^bNt[ǗpIuWFNg
		extern StackFrame *pobj_sf;
		pobj_sf=new StackFrame();

		SystemProc(*pUserProc);

		//X^bNt[ǗpIuWFNgj
		delete pobj_sf;
		pobj_sf=0;

		return;
	}

	cp=pUserProc->GetCodePos();
	for(;;cp++){
		if(IsCommandDelimitation(basbuf[cp])) break;
	}
	cp--;

	//vV[WoXPW[iExit Sub/Functionj
	compiler.codeGenerator.exitSubCodePositions.clear();

	//xp̃m
	compiler.codeGenerator.gotoLabels.clear();

	//GotoxXPW[
	compiler.codeGenerator.gotoLabelSchedules.clear();

	//With̃m
	extern WITHINFO WithInfo;
	WithInfo.ppName=(char **)HeapAlloc(hHeap,0,1);
	WithInfo.pWithCp=(int *)HeapAlloc(hHeap,0,1);
	WithInfo.num=0;

	//dG[Ǘ̃m
	extern char **SynonymErrorWords;
	extern int SynonymErrorNum;
	SynonymErrorNum=0;
	SynonymErrorWords=(char **)HeapAlloc(hHeap,0,1);

	//ContinueAhX
	compiler.codeGenerator.ClearContinueArea();

	//[JϐɊւ
	extern int AllLocalVarSize;
	AllLocalVarSize=0;

	//LVJXR[v
	compiler.codeGenerator.lexicalScopes.Init( compiler.codeGenerator.GetNativeCodeSize() );


	/////////////////////////////////////
	// p[^p̕ϐf[^l
	/////////////////////////////////////

	//p[^p̕ϐf[^l
	for(i3=(int)pUserProc->RealParams().size()-1;i3>=0;i3--){
		Parameter &param = *pUserProc->RealParams()[i3];

		Variable *pVar = new Variable( param.GetVarName(), param, false, param.IsRef(), "", false );

		if( param.IsArray() ){
			pVar->SetArray( param.GetSubscripts() );
		}

		int varSize;
		if( param.IsRef() == false && param.IsStruct() ){
			//\̂ByValp[^
			pVar->ThisIsParameter();
			varSize=PTR_SIZE;
		}
		else{
			if( param.IsArray() == false ){
				varSize = pVar->GetMemorySize();
			}
			else{
				varSize=PTR_SIZE;
			}
		}
		AllLocalVarSize+=varSize;
		pVar->SetOffsetAddress( AllLocalVarSize );

		//LVJXR[v
		pVar->SetScopeLevel( compiler.codeGenerator.lexicalScopes.GetNowLevel() );
		pVar->SetScopeStartAddress( compiler.codeGenerator.lexicalScopes.GetStartAddress() );
		pVar->bLiving=TRUE;

		pUserProc->GetLocalVars().push_back( pVar );
	}

	//This|C^[JItZbglZbg
	extern int LocalVar_ThisPtrOffset;
	LocalVar_ThisPtrOffset=AllLocalVarSize;

	//X^bNt[ǗpNX
	extern StackFrame *pobj_sf;
	pobj_sf=new StackFrame();


	///////////////////////
	// R[h

	for(i3=(int)pUserProc->RealParams().size()-1;i3>=0;i3--){
		Parameter &param = *pUserProc->RealParams()[i3];
		if(i3==3){
			if(param.IsReal()&&param.IsRef() == false){
				//movsd qword ptr[rsp+0x20],xmm3
				compiler.codeGenerator.op_movsd_MR(REG_XMM3,REG_RSP,0x20,MOD_BASE_DISP32);
			}
			else{
				//mov qword ptr[rsp+0x20],r9
				compiler.codeGenerator.op_mov_MR(sizeof(_int64),REG_R9,REG_RSP,0x20,MOD_BASE_DISP32);
			}
		}
		if(i3==2){
			if(param.IsReal()&&param.IsRef() == false){
				//movsd qword ptr[rsp+0x18],xmm2
				compiler.codeGenerator.op_movsd_MR(REG_XMM2,REG_RSP,0x18,MOD_BASE_DISP32);
			}
			else{
				//mov qword ptr[rsp+0x18],r8
				compiler.codeGenerator.op_mov_MR(sizeof(_int64),REG_R8,REG_RSP,0x18,MOD_BASE_DISP32);
			}
		}
		if(i3==1){
			if(param.IsReal()&&param.IsRef() == false){
				//movsd qword ptr[rsp+0x10],xmm1
				compiler.codeGenerator.op_movsd_MR(REG_XMM1,REG_RSP,0x10,MOD_BASE_DISP32);
			}
			else{
				//mov qword ptr[rsp+0x10],rdx
				compiler.codeGenerator.op_mov_MR(sizeof(_int64),REG_RDX,REG_RSP,0x10,MOD_BASE_DISP32);
			}
		}
		if(i3==0){
			if(param.IsReal()&&param.IsRef() == false){
				//movsd qword ptr[rsp+0x8],xmm0
				compiler.codeGenerator.op_movsd_MR(REG_XMM0,REG_RSP,0x8,MOD_BASE_DISP32);
			}
			else{
				//mov qword ptr[rsp+0x8],rcx
				compiler.codeGenerator.op_mov_MR(sizeof(_int64),REG_RCX,REG_RSP,0x8,MOD_BASE_DISP32);
			}
		}
	}

	//retp̃AhXl
	AllLocalVarSize+=sizeof(_int64);

	//sub rsp,X^bNt[TCY
	const PertialSchedule *pStackFramePertialSchedule = compiler.codeGenerator.op_sub_rsp( 0, true );

	//mov qword ptr[rsp+offset],reg     X^bNt[𗘗p
	pobj_sf->push(REG_RBX);
	pobj_sf->push(REG_RSI);
	pobj_sf->push(REG_RDI);
	pobj_sf->push(REG_R12);
	pobj_sf->push(REG_R13);
	pobj_sf->push(REG_R14);
	pobj_sf->push(REG_R15);

	//[Jϐ̃x[Xl
	int BaseLocalVar;
	BaseLocalVar=AllLocalVarSize;

	if( !pUserProc->ReturnType().IsNull() ){
		//߂l݂Ƃ

		const char *temp = pUserProc->GetName().c_str();
		if( temp[0]==1&&temp[1]==ESC_OPERATOR ){
			temp = "_System_ReturnValue";
		}

		if( pUserProc->ReturnType().IsStruct() ){
			//߂lp̍\́il^j̓p[^ňn
		}
		else{
			if( pUserProc->ReturnType().IsObject() ){
				sprintf(temporary,"%s=Nothing%c%c%s",temp,1,ESC_AS, compiler.TypeToString( pUserProc->ReturnType() ).c_str() );
			}
			else{
				//߂lp̕ϐ̒`
				sprintf(temporary,"%s%c%c%s",temp,1,ESC_AS, compiler.TypeToString( pUserProc->ReturnType() ).c_str() );
			}

			OpcodeDim(temporary,0);
		}
	}

	const PertialSchedule *pRspOffsetPertialSchedule1 = NULL;
	const PertialSchedule *pRspOffsetPertialSchedule2 = NULL;
	if(bDebugCompile&&bDebugSupportProc==0){
		//mov rdx, qword ptr[rsp+X^bNt[TCY]
		pRspOffsetPertialSchedule1 = compiler.codeGenerator.op_mov_RM(sizeof(_int64),REG_RDX,REG_RSP,0,MOD_BASE_DISP32, Schedule::None, true );

		//mov rcx,rsp
		compiler.codeGenerator.op_mov_RR(REG_RCX,REG_RSP);

		//add rcx,X^bNt[TCY+sizeof(_int64) retp̃TCYl
		pRspOffsetPertialSchedule2 = compiler.codeGenerator.op_add_RV(REG_RCX,0, Schedule::None, true );

		//call _DebugSys_StartProc
		extern const UserProc *pSub_DebugSys_StartProc;
		compiler.codeGenerator.op_call(pSub_DebugSys_StartProc);
	}

	if(compiler.pCompilingClass){
		if( pUserProc->GetName() == compiler.pCompilingClass->GetName() ){
			////////////////////////////////////
			// RXgN^RpCƂ
			////////////////////////////////////

			//RXgN^̃RpCJnʒm
			compiler.pCompilingClass->NotifyStartConstructorCompile();

			//NXǂ̎
			//ipC^[tFCX̏ꍇNXƌȂj
			BOOL bThisIsSuperClass;
			if( !compiler.pCompilingClass->HasSuperClass() ) bThisIsSuperClass=1;
			else if( compiler.pCompilingClass->GetSuperClass().GetConstructorMethod() == NULL ){
				//C^[tFCXpƂ̓RXgN^Ȃ
				bThisIsSuperClass=1;
			}
			else bThisIsSuperClass=0;

			if(!bThisIsSuperClass){
				/* TuNXRXgN^RpCĂƂ́A
					NX̃RXgN^Ăяo */

				i3=cp+1;
				while(IsCommandDelimitation(basbuf[i3])) i3++;
				for(i4=0;;i3++,i4++){
					if(!IsVariableChar(basbuf[i3])){
						temporary[i4]=0;
						break;
					}
					temporary[i4]=basbuf[i3];
				}
				if( compiler.pCompilingClass->GetSuperClass().GetName() == temporary ){
					//NX̃RXgN^Ăяo
					cp=i3;
					for(i4=0;;cp++,i4++){
						if(IsCommandDelimitation(basbuf[cp])){
							temporary[i4]=0;
							break;
						}
						temporary[i4]=basbuf[cp];
					}
					if(!(temporary[0]=='('&&temporary[lstrlen(temporary)-1]==')')){
						SetError(1,NULL,cp);
					}
					RemoveStringPare(temporary);

					Type dummyType;
					CallProc( PROC_DEFAULT
						, &compiler.pCompilingClass->GetSuperClass().GetConstructorMethod()->GetUserProc()
						, compiler.pCompilingClass->GetSuperClass().GetConstructorMethod()->GetUserProc().GetName().c_str()
						, temporary
						, dummyType );
				}
				else{
					//NX̃RXgN^ÖٓIɌĂяo
					Opcode_CallProc("",
						&compiler.pCompilingClass->GetSuperClass().GetConstructorMethod()->GetUserProc(),
						0,
						"");
				}
			}

			//z֐e[u
			if( compiler.pCompilingClass->IsExistVirtualFunctions()
				&& !compiler.pCompilingClass->IsAbstract() ){
					//֐e[uɒlZbg
					int offset = (int)compiler.pCompilingClass->GetVtblGlobalOffset();

					//mov rax,offset
					compiler.codeGenerator.op_mov_RV(sizeof(_int64),REG_RAX,offset, Schedule::DataTable );

					//This|C^rcxɃRs[
					SetThisPtrToReg(REG_RCX);

					//mov qword ptr[rcx],rax
					compiler.codeGenerator.op_mov_MR(sizeof(_int64),REG_RAX,REG_RCX,0,MOD_BASE);
			}
		}
		else if( pUserProc->IsDestructor() ){
			//fXgN^RpCƂ

			//fXgN^̃RpCJnʒm
			compiler.pCompilingClass->NotifyStartDestructorCompile();
		}
	}

	//////////////////////////////////////////
	//////////////////////////////////////////
	////// vV[WRpC ////////
	if( pUserProc->IsAutoGeneration() ){
		AutoGeneration( *pUserProc );
	}
	else{
		if(pUserProc->IsMacro()){
			CompileBuffer(ESC_ENDMACRO,0);
		}
		else{
			if(pUserProc->IsSub()){
				CompileBuffer(ESC_ENDSUB,0);
			}
			else if(pUserProc->IsFunction()){
				CompileBuffer(ESC_ENDFUNCTION,0);
			}
		}
	}
	//////////////////////////////////////////
	//////////////////////////////////////////

	if( compiler.pCompilingClass ){

		if( compiler.pCompilingClass->IsCompilingConstructor() ){
			// RXgN^RpCĂƂ

			// RXgN^̃RpCƂʒm
			compiler.pCompilingClass->NotifyFinishConstructorCompile();
		}
		else if( pUserProc->IsDestructor() ){
			////////////////////////////////////
			//fXgN^RpCƂ
			////////////////////////////////////

			// fXgN^̃RpCƂʒm
			compiler.pCompilingClass->NotifyFinishDestructorCompile();

			if( compiler.pCompilingClass->HasSuperClass() ){
				/* TuNX̃fXgN^RpCĂƂ́A
					NX̃fXgN^Ăяo */

				const CMethod *method = compiler.pCompilingClass->GetSuperClass().GetDestructorMethod();
				if( method ){
					Opcode_CallProc("",
						&method->GetUserProc(),
						0,
						"");
				}
			}
		}
	}

	//With̃
	for(i3=0;i3<WithInfo.num;i3++){
		SetError(22,"With",WithInfo.pWithCp[i3]);
		HeapDefaultFree(WithInfo.ppName[i3]);
	}
	HeapDefaultFree(WithInfo.ppName);
	HeapDefaultFree(WithInfo.pWithCp);

	//[JIuWFNgiLVJXR[vx=0j̉
	compiler.codeGenerator.lexicalScopes.CallDestructorsOfScopeEnd();

	//vV[WoXPW[iExit Sub/Functionj
	compiler.codeGenerator.ResolveExitSubSchedule();

	if(bDebugCompile&&bDebugSupportProc==0){
		//call _DebugSys_EndProc
		extern const UserProc *pSub_DebugSys_EndProc;
		compiler.codeGenerator.op_call(pSub_DebugSys_EndProc);
	}

	if( !pUserProc->ReturnType().IsNull() ){
		//////////////////////////////////
		// ߂lrax܂xmm0ɐݒ
		//////////////////////////////////

		RELATIVE_VAR RelativeVar;

		const char *temp = pUserProc->GetName().c_str();
		if( temp[0]==1 && temp[1]==ESC_OPERATOR ){
			temp="_System_ReturnValue";
		}
		GetVarOffsetReadWrite(temp,&RelativeVar,Type());

		const Type &returnType = pUserProc->ReturnType();
		if( returnType.IsObject() || returnType.IsStruct() )
		{
			SetVarPtrToReg(REG_RAX,&RelativeVar);
			if( returnType.IsObject() )
			{
				//mov rax,qword ptr[rax]
				compiler.codeGenerator.op_mov_RM( sizeof(_int64), REG_RAX, REG_RAX, 0, MOD_BASE );
			}
		}
		else if( returnType.IsDouble() )
		{
			//64rbg^
			SetXmmReg_DoubleVariable(&RelativeVar,REG_XMM0);
		}
		else if( returnType.IsSingle() )
		{
			//32rbg^
			SetXmmReg_SingleVariable(&RelativeVar,REG_XMM0);
		}
		else if( returnType.IsWhole() )
		{
			//^
			SetReg_WholeVariable(returnType.GetSize(),&RelativeVar,REG_RAX);
		}
		else SetError(300,NULL,cp);
	}

	//[Jϐ̈̃TCYX^bNt[ɒʒm
	int localParmSize = AllLocalVarSize - BaseLocalVar;
	int stackFrameSize = pobj_sf->GetFrameSize( localParmSize );

	//[JϐAhXXPW[
	BOOST_FOREACH( const PertialSchedule *pPertialSchedule, compiler.codeGenerator.localVarPertialSchedules )
	{
		compiler.codeGenerator.opfix_offset( pPertialSchedule, AllLocalVarSize + stackFrameSize );
	}
	compiler.codeGenerator.localVarPertialSchedules.clear();
	BOOST_FOREACH( Variable *pVar, pUserProc->GetLocalVars() ){
		//ɃfobOŗp
		pVar->SetOffsetAddress(
			AllLocalVarSize + stackFrameSize - pVar->GetOffsetAddress()
		);
	}

	//mov reg,qword ptr[rsp+offset]     X^bNt[𗘗p
	pobj_sf->pop(REG_R15);
	pobj_sf->pop(REG_R14);
	pobj_sf->pop(REG_R13);
	pobj_sf->pop(REG_R12);
	pobj_sf->pop(REG_RDI);
	pobj_sf->pop(REG_RSI);
	pobj_sf->pop(REG_RBX);

	int stackFrameAndLocalParamSize = localParmSize + stackFrameSize;

	//add rsp,X^bNt[TCY
	compiler.codeGenerator.op_add_rsp(stackFrameAndLocalParamSize);

	//ret
	compiler.codeGenerator.op_ret();


	//fobOp
	if( pRspOffsetPertialSchedule1 ){
		compiler.codeGenerator.opfix( pRspOffsetPertialSchedule1, stackFrameAndLocalParamSize );
		compiler.codeGenerator.opfix( pRspOffsetPertialSchedule2, stackFrameAndLocalParamSize + sizeof(_int64) );
	}


	//X^bNt[XPW[isubR}hj
	compiler.codeGenerator.opfix( pStackFramePertialSchedule, stackFrameAndLocalParamSize );

	//X^bNt[XPW[s
	pobj_sf->RunningSchedule( stackFrameSize );
	delete pobj_sf;
	pobj_sf=0;


	//dG[Ǘ̃
	for(i3=0;i3<SynonymErrorNum;i3++) HeapDefaultFree(SynonymErrorWords[i3]);
	HeapDefaultFree(SynonymErrorWords);
}
