#include "../BasicCompiler_Common/common.h"

#ifdef _AMD64_
#include "../BasicCompiler64/opcode.h"
#else
#include "../BasicCompiler32/opcode.h"
#endif

int hash_default(char *name){
	int key;

	for(key=0;*name!='\0';name++){
		key=((key<<8)+ *name )%MAX_HASH;
	}

	return key;
}

CONSTINFO *GetConstHash(char *name){
	//nbVl擾
	int key;
	key=hash_default(name);

	//i[ʒu擾
	extern CONSTINFO **ppConstHash;
	CONSTINFO *pci;
	pci=ppConstHash[key];
	while(pci){
		if(lstrcmp(pci->name,name)==0) break;

		pci=pci->pNextData;
	}

	return pci;
}

DECLAREINFO *GetDeclareHash(char *name){
	//nbVl擾
	int key;
	key=hash_default(name);

	//i[ʒu擾
	extern DECLAREINFO **ppDeclareHash;
	DECLAREINFO *pdi;
	pdi=ppDeclareHash[key];
	while(pdi){
		if(lstrcmp(pdi->name,name)==0) break;

		pdi=pdi->pNextData;
	}

	return pdi;
}

SUBINFO **GetOverloadObjectSubHash(char *name,CClass *pobj_c, int *pNum){
	int i;


	//i[̂߂̍\̔zp
	extern HANDLE hHeap;
	SUBINFO **ppArray_si;
	int num=0;
	ppArray_si=(SUBINFO **)HeapAlloc(hHeap,0,sizeof(SUBINFO *)*1024);


	//IuWFNg̃o֐̏ꍇ
	//I[o[Chꂽ֐ɃT[`Kv邽߁AobNT[`s
	for(i=pobj_c->iMethodNum-1;i>=0;i--){
		if(lstrcmp(name,pobj_c->ppobj_Method[i]->psi->name)==0){
			ppArray_si[num]=pobj_c->ppobj_Method[i]->psi;
			num++;
		}
	}

	*pNum=num;
	return ppArray_si;
}

SUBINFO **GetOverloadSubHash(char *lpszName,int *pNum){
	extern SUBINFO *pSubInfo;
	extern int SubInfoNum;
	extern int cp;
	int i;

	char name[VN_SIZE];

	if(lpszName[0]=='.'){
		GetWithName(name);
		lstrcat(name,lpszName);
	}
	else lstrcpy(name,lpszName);


	//i[̂߂̍\̔zp
	extern HANDLE hHeap;
	SUBINFO **ppArray_si;
	int num=0;
	ppArray_si=(SUBINFO **)HeapAlloc(hHeap,0,sizeof(SUBINFO *)*1024);


	char ObjName[VN_SIZE];		//IuWFNgϐ
	char NestMember[VN_SIZE];	//qo
	bool isObjectMember = SplitMemberName( name, ObjName, NestMember );
	if( !isObjectMember ) lstrcpy(ObjName,name);

	if(isObjectMember){
		//IuWFNg̃o֐̏ꍇ

		bool isStatic = false;
		CClass *pobj_c;
		if(lstrcmpi(ObjName,"Super")==0){
			//NXo֐NX̌Ăяo
			pobj_c=pobj_CompilingClass;
		}
		else{
			pobj_c=pobj_DBClass->check(ObjName);
			if( pobj_c ){
				isStatic = true;
			}
			else{
				//"->"ɂăIuWFNgw肷ʏ̃o֐Ăяo
				int type = GetVarType(ObjName,(LONG_PTR *)&pobj_c,0);
				if(!(NATURAL_TYPE(type)==DEF_OBJECT)) goto finish;
			}
		}

		if( isStatic ){
			// ÓI\bh擾
			for(i=0;i<pobj_c->iStaticMethodNum;i++){
				if(lstrcmp(NestMember,pobj_c->ppobj_StaticMethod[i]->psi->name)==0){
					ppArray_si[num]=pobj_c->ppobj_StaticMethod[i]->psi;
					num++;
				}
			}
		}
		else{
			//I\bh擾

			//I[o[Chꂽ֐ɃT[`Kv邽߁AobNT[`s
			for(i=pobj_c->iMethodNum-1;i>=0;i--){
				if(lstrcmp(NestMember,pobj_c->ppobj_Method[i]->psi->name)==0){
					ppArray_si[num]=pobj_c->ppobj_Method[i]->psi;
					num++;
				}
			}
		}
	}
	else{
		//IuWFNgIɎw肳ĂȂƂ

		if(pobj_CompilingClass){
			//g̃IuWFNg̃o֐


			//////////////////////////////////////////////
			// ÓI\bh
			//////////////////////////////////////////////

			CClass *pobj_c = pobj_CompilingClass;

			for(i=0;i<pobj_c->iStaticMethodNum;i++){
				if(lstrcmp(name,pobj_c->ppobj_StaticMethod[i]->psi->name)==0){
					ppArray_si[num]=pobj_c->ppobj_StaticMethod[i]->psi;
					num++;
				}
			}


			///////////////////////
			// I\bhiʁj
			///////////////////////
			for(i=0;i<pobj_CompilingClass->iMethodNum;i++){
				//I[o[Chꂽ֐щz
				if(pobj_CompilingClass->ppobj_Method[i]->pobj_InheritsClass==0) break;
			}
			for(;i<pobj_CompilingClass->iMethodNum;i++){
				if(lstrcmp(name,pobj_CompilingClass->ppobj_Method[i]->psi->name)==0){
					ppArray_si[num]=pobj_CompilingClass->ppobj_Method[i]->psi;
					num++;
				}
			}

			//I[o[Chꂽo֐
			for(i=0;i<pobj_CompilingClass->iMethodNum;i++){
				//I[o[Chꂽ֐щz
				if(pobj_CompilingClass->ppobj_Method[i]->pobj_InheritsClass){
					if(lstrcmp(name,pobj_CompilingClass->ppobj_Method[i]->psi->name)==0){
						ppArray_si[num]=pobj_CompilingClass->ppobj_Method[i]->psi;
						num++;
					}
				}
			}
		}


		///////////////////////////
		// O[o֐
		///////////////////////////

		//nbVl擾
		int key;
		key=hash_default(name);

		//i[ʒu擾
		extern SUBINFO **ppSubHash;
		SUBINFO *psi;
		psi=ppSubHash[key];
		while(psi){
			if(!psi->pobj_ParentClass){
				if(lstrcmp(psi->name,name)==0){
					ppArray_si[num]=psi;
					num++;
				}
			}

			psi=psi->pNextData;
		}

	}
finish:

	*pNum=num;
	return ppArray_si;
}

//I[o[[hĂȂ֐擾î̃RpC\[XR[hƂ̌݊ێj
SUBINFO *GetSubHash(char *lpszName,BOOL bError){
	int num;
	SUBINFO **ppsi,*psi;
	ppsi = GetOverloadSubHash(lpszName,&num);

	//֐݂ȂƂ
	if(num == 0){
		HeapDefaultFree(ppsi);
		return 0;
	}

	//ȏ̊֐݂Ƃ͓G[ifobOpj
	if(num > 1){
		if(bError) SetError(300,NULL,cp);
	}

	psi = ppsi[0];

	HeapDefaultFree(ppsi);

	return psi;
}
SUBINFO *GetMethodHash(char *ObjectName,char *MethodName,char *Parameter,BOOL bError){
	char temporary[VN_SIZE];
	sprintf(temporary,"%s.%s",ObjectName,MethodName);

	int num;
	SUBINFO **ppsi,*psi;
	ppsi = GetOverloadSubHash(temporary,&num);

	//֐݂ȂƂ
	if(num == 0){
		HeapDefaultFree(ppsi);
		return 0;
	}

	//I[o[[h
	psi=OverloadSolutionWithStrParam(temporary,ppsi,num,Parameter,ObjectName,NULL);
	HeapDefaultFree(ppsi);

	return psi;
}
