#include "../BasicCompiler_Common/common.h"

#ifdef _AMD64_
#include "../BasicCompiler64/opcode.h"
#else
#include "../BasicCompiler32/opcode.h"
#endif

SUBINFO *OverloadSolutionWithStrParam(char *name,SUBINFO **ppsi,int num,char *Parameter,char *ObjectName,TYPEINFO *pReturnTypeInfo){
	// I[o[[h̉

	//I[o[[hĂȂƂ
	if(num==1) return ppsi[0];


	////////////////////////
	// p[^Zbg
	////////////////////////

	CParameter *pobj_parameter=0;

	char MethodName[VN_SIZE];
	if( !SplitMemberName( name, NULL, MethodName ) ) lstrcpy( MethodName, name );

	//\bh̏ꍇ͐ÓIǂ𒲂ׂ
	bool isStatic = false;
	CClass *pClass = ppsi[0]->pobj_ParentClass;
	if( pClass ){
		isStatic = pClass->IsExistStaticMethod( MethodName );
	}

	//p[^IuWFNg𐶐
	pobj_parameter=new CParameter(Parameter);
	if(pReturnTypeInfo) pobj_parameter->SetReturnType(pReturnTypeInfo);


	SUBINFO *psi;
	psi=pobj_parameter->OverloadSolution(name,ppsi,num);


	//p[^IuWFNgj
	delete pobj_parameter;
	pobj_parameter=0;

	return psi;
}

BOOL OverloadCheck(PARAMETER_INFO *ppi1,int ParmNum1,PARAMETER_INFO *ppi2,int ParmNum2){
	//p[^̌sv̏ꍇ
	if(ParmNum1!=ParmNum2) return 0;

	int i;
	for(i=0;i<ParmNum1;i++){
		if(ppi1[i].type!=ppi2[i].type) return 0;
		else{
			if(NATURAL_TYPE(ppi1[i].type)==DEF_OBJECT){
				if(ppi1[i].u.index!=ppi2[i].u.index) return 0;
			}
		}
	}

	return 1;
}
BOOL OverloadCheckLevel2(PARAMETER_INFO *ppi1,int ParmNum1,PARAMETER_INFO *ppi2,int ParmNum2){
	//p[^̌sv̏ꍇ
	if(ParmNum1!=ParmNum2) return 0;

	int i;
	for(i=0;i<ParmNum1;i++){
		if(ppi1[i].type!=ppi2[i].type){
			if(!(
				IsNaturalWholeNumberType(ppi1[i].type)&&IsNaturalWholeNumberType(ppi2[i].type)||
				IsRealNumberType(ppi1[i].type)&&IsRealNumberType(ppi2[i].type)
				)) return 0;
		}
		else{
			if(NATURAL_TYPE(ppi1[i].type)==DEF_OBJECT){
				if(ppi1[i].u.index!=ppi2[i].u.index) return 0;
			}
		}
	}

	return 1;
}
SUBINFO *OverloadSolution(char *name,SUBINFO **ppsi,int num,PARAMETER_INFO *ppi,int ParmNum,TYPEINFO *pReturnTypeInfo){
	// I[o[[h̉

	//I[o[[hĂȂƂ
	if(num==1) return ppsi[0];


	CParameter *pobj_Parameter=new CParameter(ppi,ParmNum);
	if(pReturnTypeInfo) pobj_Parameter->SetReturnType(pReturnTypeInfo);

	SUBINFO *psi;
	psi=pobj_Parameter->OverloadSolution(name,ppsi,num);

	delete pobj_Parameter;

	return psi;
}
