#include "common.h"


int MakeWholeType(int size,int bSigned){
	switch(size){
		case 1:
			if(bSigned) return DEF_CHAR;
			else return DEF_BYTE;
			break;
		case 2:
			if(bSigned) return DEF_INTEGER;
			else return DEF_WORD;
			break;
		case 4:
			if(bSigned) return DEF_LONG;
			else return DEF_DWORD;
			break;
		case 8:
			if(bSigned) return DEF_INT64;
			else return DEF_QWORD;
			break;
	}
	return 0;
}

int AutoBigCast(int BaseType,int CalcType){
	int type;
	type=CalcType;

	if(!BaseType){
		//x[X^Cv̂Ƃ
		return type;
	}

	if(!IsWholeNumberType(type)){
		//^ł͂ȂƂ͈Öق̕ϊ͕KvȂ
		return type;
	}

	if(BaseType==DEF_OBJECT){
		//x[X^CvIuWFNĝƂ͈Öق̕ϊ͕KvȂ
		return type;
	}

	int BaseTypeSize;
	BaseTypeSize=GetTypeSize(BaseType,-1);

	if(IsRealNumberType(BaseType)){
		if(GetTypeSize(CalcType,-1)<4)
			type=MakeWholeType(4,IsSignedType(CalcType));
	}
	else if(BaseTypeSize>GetTypeSize(CalcType,-1)){
		//v^̂قTCY傫Ƃ
		type=MakeWholeType(BaseTypeSize,IsSignedType(CalcType));
	}

	if(!type){
		extern int cp;
		SetError(300,NULL,cp);
	}

	return type;
}

BOOL CheckCalcType(int idCalc,int *type,int sp){
	//Zq̉EӁAӂ̌^`FbN
	extern int cp;

	//Zq擾
	char temporary[255];
	GetCalcName(idCalc,temporary);

	switch(idCalc){

		/////////////////////////////////////
		// ɑ΂_Z̓G[
		/////////////////////////////////////

		case CALC_XOR:
		case CALC_OR:
		case CALC_AND:
			if(IsRealNumberType(type[sp-2])||IsRealNumberType(type[sp-1])){
				//ꂩ̍̂Ƃ
				SetError(45,temporary,cp);
				return 0;
			}

			//AsȊỎZqɌ^w肳ĂȂ`FbN
			if((type[sp-2]&FLAG_CAST)||(type[sp-1]&FLAG_CAST)){
				SetError(48,temporary,cp);
				return 0;
			}
			break;

		case CALC_NOT:
			if(IsRealNumberType(type[sp-1])){
				//̂Ƃ
				SetError(45,temporary,cp);
				return 0;
			}

			//AsȊỎZqɌ^w肳ĂȂ`FbN
			if(type[sp-1]&FLAG_CAST){
				SetError(48,temporary,cp);
				return 0;
			}
			break;



		/////////////////////////////////////
		// rZ̓`FbNڂȂ
		/////////////////////////////////////

		case CALC_PE:
		case CALC_QE:
		case CALC_NOTEQUAL:
		case CALC_EQUAL:
		case CALC_P:
		case CALC_Q:
			//AsȊỎZqɌ^w肳ĂȂ`FbN
			if((type[sp-2]&FLAG_CAST)||(type[sp-1]&FLAG_CAST)){
				SetError(48,temporary,cp);
				return 0;
			}
			break;



		/////////////////////////////////////
		// ZpZ`FbN
		/////////////////////////////////////

		case CALC_ADDITION:
		case CALC_SUBTRACTION:
		case CALC_PRODUCT:
		case CALC_QUOTIENT:
		case CALC_POWER:
			//AsȊỎZqɌ^w肳ĂȂ`FbN
			if((type[sp-2]&FLAG_CAST)||(type[sp-1]&FLAG_CAST)){
				SetError(48,temporary,cp);
				return 0;
			}
			break;

		case CALC_SHL:
		case CALC_SHR:
		case CALC_MOD:
		case CALC_INTQUOTIENT:
			if(IsRealNumberType(type[sp-2])||IsRealNumberType(type[sp-1])){
				//ꂩ̍̂Ƃ
				SetError(45,temporary,cp);
				return 0;
			}

			//AsȊỎZqɌ^w肳ĂȂ`FbN
			if((type[sp-2]&FLAG_CAST)||(type[sp-1]&FLAG_CAST)){
				SetError(48,temporary,cp);
				return 0;
			}
			break;

		case CALC_AS:
			if((type[sp-1]&FLAG_CAST)==0){
				//^w肳ĂȂƂ̓G[
				SetError(47,NULL,cp);
				return 0;
			}
			break;

		case CALC_MINUSMARK:
			//AsȊỎZqɌ^w肳ĂȂ`FbN
			if(type[sp-1]&FLAG_CAST){
				SetError(48,temporary,cp);
				return 0;
			}
			break;
	}
	return 1;
}

int GetReturnType_OperatorProc(int idCalc,TYPEINFO *pBaseTypeInfo,int *type,LONG_PTR *index_stack,int &sp){
	//I[o[[hꂽIy[^֐̖߂l擾
	CClass *pobj_c;
	pobj_c=(CClass *)index_stack[sp-2];

	SUBINFO **ppsi;
	int num;
	ppsi=pobj_c->GetOperatorSubInfo(idCalc,num);
	if(num==0){
		HeapDefaultFree(ppsi);

		return 0;
	}


	//̐
	BOOL bTwoTerm=1;
	if(idCalc==CALC_AS) bTwoTerm=0;



	/////////////////////////////////////////////
	// I[o[[hp̃p[^ݒ
	/////////////////////////////////////////////


	//_System_LocalThis
	PARAMETER_INFO *ppi = (PARAMETER_INFO *)HeapAlloc(hHeap,0,sizeof(PARAMETER_INFO)*3);
	int iParmNum=0;

	if(bTwoTerm){
		ppi[iParmNum].bArray=0;
		ppi[iParmNum].bByVal=0;
		ppi[iParmNum].name=0;
		ppi[iParmNum].type=type[sp-1];
		ppi[iParmNum].u.index=index_stack[sp-1];
		ppi[iParmNum].SubScripts[0]=-1;
		iParmNum++;
	}


	//I[o[[h
	char temporary[255];
	if(idCalc==CALC_EQUAL) lstrcpy(temporary,"==");
	else GetCalcName(idCalc,temporary);
	SUBINFO *psi;
	psi=OverloadSolution(temporary,ppsi,num,ppi,iParmNum,pBaseTypeInfo);
	HeapDefaultFree(ppsi);

	if(!psi){
		HeapDefaultFree(ppi);
		return 0;
	}
	else{
		//I[o[[hĂȂAp[^vȂƂ
		if(iParmNum!=psi->ParmNum){
			HeapDefaultFree(ppi);
			return 0;
		}
	}

	HeapDefaultFree(ppi);

	sp--;
	type[sp-1]=psi->ReturnType;
	index_stack[sp-1]=psi->u.ReturnIndex;

	return 1;
}

int NumOpe_GetType(char *Command,TYPEINFO *pBaseType,LONG_PTR *plpIndex){
	extern int cp;
	int i,i2,i3,i4;
	char temporary[1024],temp2[1024],temp3[1024];

	if(Command[0]=='\0'){
		SetError(1,NULL,cp);
		return 0;
	}

	if(Command[0]==1&&Command[1]==ESC_NEW){
		//NewZqiIuWFNgj
		return DEF_PTR_OBJECT;
	}


	/////////////////////////////////
	// vft|[hŎ擾
	/////////////////////////////////

	char *values[255];
	long calc[255];
	long stack[255];
	int pnum;
	if(!GetNumOpeElements(Command,&pnum,values,calc,stack)){
		for(i=0;i<pnum;i++){
			if(values[i]) HeapDefaultFree(values[i]);
		}
		return 0;
	}



	////////////////////////////////
	// Z̃R[hJn
	////////////////////////////////

	BOOL bError;
	bError=0;

	//el݂̂̌vZǂ𔻕ʂ邽߂̃tO
	BOOL bLiteralCalculation=1;

	int sp;
	int type[255];
	LONG_PTR index_stack[255];
	_int64 i64data;
	int idCalc;
	for(i=0,sp=0;i<pnum;i++){
		idCalc=calc[i]%100;

		if(idCalc){
			if(type[sp-2]==DEF_OBJECT){
				//I[o[[hꂽIy[^Ăяo
				if(!GetReturnType_OperatorProc(idCalc,pBaseType,type,index_stack,sp)){
					goto error;
				}

				continue;
			}

			if(!CheckCalcType(idCalc,type,sp)) goto error;
		}

		switch(idCalc){
			//l
			case 0:
				index_stack[sp]=-1;

				if(values[i][0]=='\"'){
StrLiteral:

					if(pBaseType){
						if(pBaseType->type==DEF_OBJECT){
							if(IsStringSubsituation(pBaseType->u.pobj_Class)){
								//v^CvIuWFNgłAString̎󂯓ꂪ\ȏꍇ
								extern CClass *pobj_StringClass;
								type[sp]=DEF_OBJECT;
								index_stack[sp]=(LONG_PTR)pobj_StringClass;
								bLiteralCalculation=0;

								sp++;
								break;
							}
						}
					}

					type[sp]=DEF_PTR_BYTE;
					bLiteralCalculation=0;
				}
				else if((values[i][0]=='e'||values[i][0]=='E')&&
					(values[i][1]=='x'||values[i][1]=='X')&&
					values[i][2]=='\"'){
					//gŃeiGXP[vV[PX\j
					goto StrLiteral;
				}
				else if(IsVariableTopChar(values[i][0])||
					values[i][0]=='*'||
					(values[i][0]=='.'&&IsVariableTopChar(values[i][1]))){
					//////////////////
					// 炩̎ʎq

					//////////////////////////////////////
					// ֐iDLLA[U[`Agݍ݁j
					//////////////////////////////////////

					i2=GetCallProcName(values[i],temporary);
					if(values[i][i2]=='('){
						i4=GetStringInPare_RemovePare(temp2,values[i]+i2+1);

						int idProc;
						void *pInfo;
						idProc=GetProc(temporary,&pInfo);

						if(idProc){
							//JbR")"ɑNULLłȂƂ̓G[ɂ
							if(values[i][i2+1+i4+1]!='\0') SetError(42,NULL,cp);


							////////////////
							// Ăяo
							////////////////

							i2=GetReturnTypeOfProc(idProc,pInfo,temporary,temp2,&index_stack[sp]);
							if(i2==-1){
								//߂l݂ȂƂ
								goto error;
							}

							type[sp]=i2;
							bLiteralCalculation=0;

							sp++;
							break;
						}
						else if(GetConstCalcBuffer(temporary,temp2,temp3)){
							/////////////////////////
							// }N֐
							/////////////////////////

							//JbR")"ɑNULLłȂƂ̓G[ɂ
							if(values[i][i2+1+i4+1]!='\0') SetError(42,NULL,cp);

							//}N֐̏ꍇ
							i2=NumOpe_GetType(temp3,NULL,&index_stack[sp]);

							if(!IS_LITERAL(index_stack[sp])){
								//elł͂ȂƂ
								bLiteralCalculation=0;
							}

							type[sp]=i2;

							sp++;
							break;
						}
					}

					i2=GetVarType(values[i],&index_stack[sp],0);
					if(i2!=-1){
						//////////
						// ϐ
						//////////

						type[sp]=i2;
						bLiteralCalculation=0;
						sp++;
						break;
					}


					//////////////
					// 萔̏ꍇ
					//////////////

					i3 = CDBConst::obj.GetType(values[i]);
					if(i3){
						type[sp]=i3;
						if(IsRealNumberType(i3)){
							//
							goto Literal;
						}
						else if(IsWholeNumberType(i3)){
							//
							goto Literal;
						}
						else if(Is64Type(i3)){
							//64rbgl
							goto Literal;
						}
						else if(i3==DEF_STRING){
							//e
							goto StrLiteral;
						}
						else{
							SetError(1,NULL,0);
							goto error;
						}
					}


					//////////////
					// ^̏ꍇ
					//////////////

					LONG_PTR lp;
					i3=GetTypeFixed(values[i],&lp);
					if(i3!=-1){
						type[sp]=i3|FLAG_CAST;
						index_stack[sp]=lp;
						sp++;
						break;
					}



					/////////////////////////////////
					// vpeBp̃\bh
					/////////////////////////////////

					//zvfr
					char VarName[VN_SIZE],ArrayElements[VN_SIZE];
					GetArrayElement(values[i],VarName,ArrayElements);

					if(GetSubHash(VarName,0)){
						TYPEINFO RetTypeInfo;
						GetReturnTypeOfPropertyMethod(values[i],NULL,&RetTypeInfo);

						//傫Ȍ^ւ̈Öق̕ϊ
						type[sp]=RetTypeInfo.type;

						index_stack[sp]=RetTypeInfo.u.lpIndex;
						bLiteralCalculation=0;

						sp++;
						break;
					}



					//Y鎯ʎqȂƂ̓G[ɂ
					bError=1;
					SetError(3,values[i],cp);
					type[sp]=DEF_DOUBLE;
				}
				else{
					//el
					int base_type;
					base_type=0;
					if(pBaseType) base_type=pBaseType->type;
					type[sp]=GetLiteralValue(values[i],&i64data,base_type);
Literal:
					if((long)i64data==0&&index_stack[sp]==-1) index_stack[sp]=LITERAL_NULL;
				}

				sp++;
				break;

			//_Zq
			case CALC_XOR:
			case CALC_OR:
			case CALC_AND:
				sp--;
				type[sp-1]=NeutralizationType(type[sp-1],index_stack[sp-1],type[sp],index_stack[sp]);
				break;
			case CALC_NOT:
				//values[sp-1]=Not values[sp-1]
				//NOTZq
				break;

			//rZq
			case CALC_PE:		//values[sp-2] <= values[sp-1]
			case CALC_QE:		//values[sp-2] >= values[sp-1]
			case CALC_P:		//values[sp-2] <  values[sp-1]
			case CALC_Q:		//values[sp-2] >  values[sp-1]
			case CALC_NOTEQUAL:	//values[sp-2] <> values[sp-1]
			case CALC_EQUAL:	//values[sp-2] =  values[sp-1]	
				sp--;
				type[sp-1]=DEF_LONG;
				break;

			//rbgVtg
			case CALC_SHL:	//values[sp-2] << values[sp-1]
			case CALC_SHR:	//values[sp-2] >> values[sp-1]
				sp--;
				break;

			//ZpZ
			case CALC_ADDITION:
			case CALC_SUBTRACTION:
			case CALC_PRODUCT:
				sp--;
				type[sp-1]=NeutralizationType(type[sp-1],index_stack[sp-1],type[sp],index_stack[sp]);
				break;
			case CALC_MOD:
				//values[sp-2]%=values[sp-1]
				//]Z
				sp--;
				type[sp-1]=NeutralizationType(type[sp-1],index_stack[sp-1],type[sp],index_stack[sp]);
				break;
			case CALC_QUOTIENT:
				//values[sp-2]/=values[sp-1];
				//Z
				sp--;
				type[sp-1]=NeutralizationType(type[sp-1],index_stack[sp-1],type[sp],index_stack[sp]);
				break;
			case CALC_INTQUOTIENT:
				//values[sp-2]/=values[sp-1]
				//Z
				sp--;
				type[sp-1]=NeutralizationType(type[sp-1],index_stack[sp-1],type[sp],index_stack[sp]);
				break;
			case CALC_MINUSMARK:
				//values[sp-1]=-values[sp-1]
				//]
				break;
			case CALC_POWER:
				//ׂ扉Zi_Ẑ݁j
				sp--;
				//
				break;
			case CALC_AS:
				//LXg
				type[sp-2]=type[sp-1]&(~FLAG_CAST);
				index_stack[sp-2]=index_stack[sp-1];

				sp--;
				break;
		}
	}

	if(bError) goto error;

	if(sp!=1){
		SetError(1,NULL,cp);
		goto error;
	}

	if(bLiteralCalculation){
		//EӒll̒萔̏ꍇ
		LONG_PTR lpCalcIndex;
		int base_type=0;
		if(pBaseType) base_type=pBaseType->type;
		i2=StaticCalculation(true, Command,base_type,&i64data,&lpCalcIndex);

		type[0]=i2;
		index_stack[0]=lpCalcIndex;
	}
	else{
		//EӒll̒萔ł͂ȂƂ
		if(IS_LITERAL(index_stack[0])) index_stack[0]=-1;
	}

	if(plpIndex) *plpIndex=index_stack[0];

	int RetType;
	RetType=type[0];
	goto finish;


	//////////////////
	// G[
	//////////////////

error:
	RetType=-1;
	goto finish;


finish:
	for(i=0;i<pnum;i++){
		if(values[i]) HeapDefaultFree(values[i]);
	}
	return RetType;
}
