#pragma once

#include <CodeGenerator.h>
#include <NamespaceSupporter.h>
#include <Meta.h>
#include <DataTable.h>
#include <CodeGenerator.h>
#include <ObjectModule.h>
#include <Linker.h>

class Compiler
{
	// W[
	std::string moduleName;

	// OԃT|[g
	NamespaceSupporter namespaceSupporter;

	// IuWFNgW[
	ObjectModule *pObjectModule;
	ObjectModule *pNowObjectModule;

public:

	Compiler()
		: pObjectModule( new ObjectModule )
		, pNowObjectModule( pObjectModule )
		, targetModuleType( Exe )
		, isCore( false )
	{
	}
	~Compiler()
	{
		delete pObjectModule;
		Clear();
	}
	void Clear()
	{
		BOOST_FOREACH( ObjectModule *pStaticLibrary, staticLibraries )
		{
			delete pStaticLibrary;
		}
		staticLibraries.clear();
	}

	void StaticLink( ObjectModules &staticLibraries );

	// W[
	void SetModuleName( const std::string &moduleName )
	{
		this->moduleName = moduleName;
	}
	const std::string &GetModuleName() const
	{
		return moduleName;
	}

	// OԃT|[g
	NamespaceSupporter &GetNamespaceSupporter()
	{
		return namespaceSupporter;
	}

	// R[h@\
	CodeGenerator codeGenerator;

	// J
	Linker linker;

	// ÓINIuWFNgt@C
	std::vector<std::string> staticLibraryFilePaths;

	// ÓINIuWFNgW[
	ObjectModules staticLibraries;

	// IuWFNgW[
	ObjectModule &GetObjectModule()
	{
		return *pNowObjectModule;
	}
	void SelectObjectModule( ObjectModule &objectModule )
	{
		pNowObjectModule = &objectModule;
	}


	// ^[Qbg
	enum TargetModuleType
	{
		Exe,
		Dll,
		StaticLibrary,
	};

	TargetModuleType targetModuleType;

	bool IsExe() const
	{
		if( targetModuleType == Exe )
		{
			return true;
		}
		return false;
	}
	bool IsDll() const
	{
		if( targetModuleType == Dll )
		{
			return true;
		}
		return false;
	}
	bool IsStaticLibrary() const
	{
		if( targetModuleType == StaticLibrary )
		{
			return true;
		}
		return false;
	}
	void SetTargetModuleType( TargetModuleType targetModuleType )
	{
		this->targetModuleType = targetModuleType;
	}


	// RAW[ǂ
	bool isCore;
	void SetCoreMark( bool isCore )
	{
		this->isCore = isCore;
	}
	bool IsCore() const
	{
		return isCore;
	}

	// O[oGAu֐
	std::string globalAreaProcName;


	bool StringToType( const std::string &typeName, Type &type );
	const std::string TypeToString( const Type &type );

	// RpC̃NX
	const CClass *pCompilingClass;
};

extern Compiler compiler;
