#include "stdafx.h"

#include <jenga/include/smoothie/Smoothie.h>

#include <Compiler.h>

#include "../BasicCompiler_Common/common.h"
#include "Opcode.h"

void Call_DebugSys_SaveContext(){
	//call _System_GetEip
	extern const UserProc *pSub_System_GetEip;
	compiler.codeGenerator.op_call(pSub_System_GetEip);

	//push eax
	compiler.codeGenerator.op_push(REG_EAX);

	//push ebp
	compiler.codeGenerator.op_push(REG_EBP);

	//call _DebugSys_SaveContext
	extern const UserProc *pSub_DebugSys_SaveContext;
	compiler.codeGenerator.op_call(pSub_DebugSys_SaveContext);
}

bool Opcode_CallProcPtr( const char *variable, const char *lpszParms,ProcPointer *pProcPointer){

	extern BOOL bDebugCompile;
	extern BOOL bDebugSupportProc;
	if(bDebugCompile&&bDebugSupportProc==0)
		Call_DebugSys_SaveContext();


	////////////////////////
	// p[^̃Zbg
	////////////////////////

	//p[^IuWFNg𐶐
	ParamImpl *pobj_parameter=0;
	pobj_parameter=new ParamImpl(lpszParms);

	// ftHgKp
	pobj_parameter->ApplyDefaultParameters( pProcPointer->Params() );

	//G[`FbN
	if( !pobj_parameter->ErrorCheck(variable,pProcPointer->Params() ) ){
		//p[^ɃG[Ƃ͏I
		return false;
	}

	//ꎞIuWFNg𐶐
	pobj_parameter->NewTempParameters( variable,pProcPointer->Params() );

	//WX^AX^bNt[ɃZbg
	pobj_parameter->SetParameter(variable,pProcPointer->Params() );



	////////////////////////
	// call
	////////////////////////
	RELATIVE_VAR RelativeVar;
	GetVarOffsetReadOnly(variable,&RelativeVar,Type());
	SetVarPtrToEax(&RelativeVar);

	//mov eax,dword ptr[eax]
	compiler.codeGenerator.op_mov_RM( sizeof(long), REG_EAX, REG_EAX, 0, MOD_BASE );

	//call eax
	compiler.codeGenerator.op_call_R( REG_EAX );



	//ꎞIuWFNgj
	pobj_parameter->DeleteTempParameters();

	//p[^IuWFNgj
	delete pobj_parameter;

	return true;
}

bool Opcode_CallProc(const char *Parameter,const UserProc *pUserProc,DWORD dwFlags,const char *ObjectName ){
	int i2;

	if( pUserProc->IsMacro() ){
		if( lstrcmpi( pUserProc->GetName().c_str(), "Print" ) == 0 ){
			Opcode_Print(Parameter,0);
			return true;
		}
		if( lstrcmpi( pUserProc->GetName().c_str(), "Input" ) == 0 ){
			Opcode_Input(Parameter);
			return true;
		}
		if( lstrcmpi( pUserProc->GetName().c_str(), "Write" ) == 0 ){
			Opcode_Print(Parameter,1);
			return true;
		}
	}

	pUserProc->Using();

	bool isStatic = false;
	const CClass *pobj_c = NULL;
	const CMethod *pMethod = NULL;
	Type leftType;
	bool isFixedClass = false;
	if( pUserProc->GetParentClassPtr() ){
		//NX̃o֐Ăяoꍇ̓ANZX`FbNs
		if(ObjectName[0] && (dwFlags&PROCFLAG_NEW)==0)
		{
			if(lstrcmpi(ObjectName,"Super")==0)
			{
				//NXo֐NX̌Ăяo
				pobj_c=&compiler.pCompilingClass->GetSuperClass();

				isFixedClass = true;
			}
			else
			{
				//"->"ɂăIuWFNgw肷ʏ̃o֐Ăяo
				Type varType;
				GetVarType( ObjectName, varType, false );
				if( NATURAL_TYPE( varType.GetBasicType() ) == DEF_OBJECT )
				{
					pobj_c = &varType.GetClass();
					leftType = varType;
				}
				else
				{
					pobj_c=compiler.GetObjectModule().meta.GetClasses().Find(ObjectName);
					if( pobj_c ){
						isStatic = true;
					}
					else{
						SetError(300,NULL,cp);
					}
				}
			}
		}
		else{
			if(dwFlags&PROCFLAG_NEW){
				GetVarType( ObjectName, leftType, false );

				//NewZqɂRXgN^Ăяo
				pobj_c=pUserProc->GetParentClassPtr();
			}
			else{
				//NXo֐瓯NX̃o֐̌Ăяo
				pobj_c=compiler.pCompilingClass;
			}
		}


		/////////////////////////////////
		// \bh擾
		/////////////////////////////////
		pMethod = NULL;
		if( ! isStatic ) pMethod = pobj_c->GetMethods().GetMethodPtr( pUserProc );
		if( ! pMethod ){
			//I\bh擾łȂƂ͐ÓI\bh𓖂
			pMethod = pobj_c->GetStaticMethods().GetMethodPtr( pUserProc );
			if( !pMethod ){
				SetError(300,NULL,cp);
				return false;
			}

			//ÓIo
			isStatic = true;
		}


		//////////////////////////////
		// ANZXG[`FbN
		//////////////////////////////

		if(ObjectName[0]){
			//ǑĂяo
			if(pobj_c==compiler.pCompilingClass){
				//NXIuWFNg̏ꍇ̓vCx[gANZXeF
				if( pMethod->IsNoneAccess() ){
					SetError(109,pUserProc->GetName(),cp);
					return false;
				}
			}
			else{
				if( pMethod->IsPrivate()
					|| pMethod->IsNoneAccess() ){
					SetError(109,pUserProc->GetName(),cp);
					return false;
				}
				if( !pMethod->GetUserProc().GetParentClass().IsEqualsOrSubClass( pobj_c ) && pMethod->IsProtected() ){
					SetError(110,pUserProc->GetName(),cp);
					return false;
				}
			}
		}
		else{
			//NX̌ĂяoipɂACCESS_NON݂̂G[Ƃj
			if( pMethod->IsNoneAccess() ){
				SetError(109,pUserProc->GetName(),cp);
				return false;
			}
		}
	}


	///////////////////////////////////////////////////////////////
	// _System_LocalThis̃_~[Zbg
	///////////////////////////////////////////////////////////////

	char temporary[VN_SIZE]={0};
	if( pUserProc->GetParentClassPtr() && isStatic == false ){
		//_System_LocalThisip[^j̃_~[쐬
		lstrcpy(temporary,"0,");
	}

	if(Parameter[0]=='\0'&&temporary[0])
		temporary[lstrlen(temporary)-1]=0;
	else lstrcat(temporary,Parameter);


	////////////////////////
	// p[^Zbg
	////////////////////////

	//p[^IuWFNg𐶐
	ParamImpl *pobj_parameter=0;
	pobj_parameter=new ParamImpl(temporary);

	// ftHgKp
	pobj_parameter->ApplyDefaultParameters( pUserProc->RealParams() );

	// ^p[^Kp
	pobj_parameter->SetLeftType( leftType );

	//G[`FbN
	if( !pobj_parameter->ErrorCheck(pUserProc->GetName(),pUserProc->RealParams(),pUserProc->GetSecondParmNum() ) ){
		//p[^ɃG[Ƃ͏I
		return false;
	}

	if(pUserProc->IsMacro()){
		//}N֐̏ꍇ́Ap[^ȗl
		pobj_parameter->MacroParameterSupport( pUserProc->RealParams() );
	}

	//ꎞIuWFNg𐶐
	int tempSize = pobj_parameter->NewTempParameters( pUserProc->GetName(),pUserProc->RealParams(),pUserProc->GetRealSecondParmNum() );

	//WX^AX^bNt[ɃZbg
	int ParmSize = pobj_parameter->SetParameter(pUserProc->GetName(),pUserProc->RealParams(),pUserProc->GetRealSecondParmNum(), pUserProc );

	if(pUserProc->ReturnType().IsStruct() ){
		//////////////////////////////////////////////////////
		// ߂lɍ\̃CX^Xꍇ
		// ByRef _System_ReturnValue p[^Zbg
		//////////////////////////////////////////////////////

		int object_size = pUserProc->ReturnType().GetClass().GetSize();

		//push object_size
		compiler.codeGenerator.op_push_V(object_size);

		//call calloc
		extern const UserProc *pSub_calloc;
		compiler.codeGenerator.op_call(pSub_calloc);

		//push eax
		compiler.codeGenerator.op_push(REG_EAX);

		ParmSize += PTR_SIZE;
	}


	if( pUserProc->GetParentClassPtr() && isStatic == false ){
		//////////////////////////////////////////////////////
		// o֐̏ꍇ
		// _System_LocalThis p[^Zbg
		//////////////////////////////////////////////////////

		if(ObjectName[0] && (dwFlags&PROCFLAG_NEW)==0){
			if(lstrcmpi(ObjectName,"Super")==0) goto InClassMember;
			else{
				RELATIVE_VAR RelativeVar;
				if( pMethod->IsConst() ){
					//ConstANZX\ȃ\bh̏ꍇ
					if( !GetVarOffsetReadOnly( ObjectName, &RelativeVar, Type() ) ){
						return false;
					}
				}
				else{
					//ConstANZXs\ȃ\bh̏ꍇ
					if( !GetVarOffsetReadWrite( ObjectName, &RelativeVar, Type() ) ){
						return false;
					}
				}

				SetVarPtrToEax(&RelativeVar);

				// QƂ̃|C^ɂ
				compiler.codeGenerator.op_mov_RM( sizeof(long), REG_ECX, REG_EAX, 0, MOD_BASE );
			}
		}
		else{
InClassMember:
			if(dwFlags&PROCFLAG_NEW){
				//NewZqɂRXgN^Ăяȍꍇ

				//mov ecx,dword ptr[esp+ParmSize]
				compiler.codeGenerator.op_mov_RM( sizeof(long), REG_ECX, REG_ESP, ParmSize + tempSize, MOD_BASE_DISP32 );
			}
			else{
				//This|C^ecxɃRs[
				SetThisPtrToReg(REG_ECX);
			}
		}

		//push ecx
		compiler.codeGenerator.op_push(REG_ECX);
	}

	if( pUserProc->IsVirtual() && !isFixedClass ){
		//z֐iIuWFNg\bhjĂяo
		//pObj->func_table->func1
		//                ->func2
		//                ->func3

		//mov edx,dword ptr[ecx]
		compiler.codeGenerator.op_mov_RM( sizeof(long), REG_EDX, REG_ECX, 0, MOD_BASE );

		i2 = pobj_c->GetFuncNumInVtbl( pUserProc );

		//call dword ptr[edx+func_index]
		if(i2*PTR_SIZE<=0x7F){
			compiler.codeGenerator.PutOld(
				(char)0xFF,
				(char)0x52,
				(char)(i2*PTR_SIZE)
			);
		}
		else{
			compiler.codeGenerator.PutOld(
				(char)0xFF,
				(char)0x92
			);
			compiler.codeGenerator.PutOld( (long)(i2*PTR_SIZE), Schedule::None );
		}
	}
	else{
		//ʏĂяo

		//call ProcAddr
		compiler.codeGenerator.op_call(pUserProc);
	}

	if(pUserProc->IsCdecl()){
		//add esp,ParmSize
		compiler.codeGenerator.op_add_esp(ParmSize);
	}

	//ꎞIuWFNgj
	pobj_parameter->DeleteTempParameters();

	//p[^IuWFNgj
	delete pobj_parameter;

	return true;
}

bool Opcode_CallDllProc( const char *lpszParms, const DllProc *pDllProc ){

	extern BOOL bDebugCompile;
	extern BOOL bDebugSupportProc;
	if(bDebugCompile&&bDebugSupportProc==0&& pDllProc->IsEqualSymbol( "DebugBreak" ) ){
		Call_DebugSys_SaveContext();
	}


	////////////////////////
	// p[^̃Zbg
	////////////////////////

	//p[^IuWFNg𐶐
	ParamImpl *pobj_parameter=0;
	pobj_parameter=new ParamImpl(lpszParms);

	// ftHgKp
	pobj_parameter->ApplyDefaultParameters( pDllProc->Params() );

	//G[`FbN
	if( !pobj_parameter->ErrorCheck( pDllProc->GetName(), pDllProc->Params() ) ){
		//p[^ɃG[Ƃ͏I
		return false;
	}

	//ꎞIuWFNg𐶐
	pobj_parameter->NewTempParameters( pDllProc->GetName(), pDllProc->Params() );

	//WX^AX^bNt[ɃZbg
	int ParmSize = pobj_parameter->SetParameter(pDllProc->GetName(), pDllProc->Params() );


	//INꂽvV[W̌Ăяo

	//call dword ptr[LookupTable]
	compiler.codeGenerator.op_call( pDllProc );

	if(pDllProc->IsCdecl()){
		//add esp,ParmSize
		compiler.codeGenerator.op_add_esp(ParmSize);
	}

	//ꎞIuWFNgj
	pobj_parameter->DeleteTempParameters();

	//p[^IuWFNgj
	delete pobj_parameter;

	return true;
}
