#include "Common.h"

#if defined(JPN)
//{
#include "rad_msg_jpn.h"
#else
//p
#include "rad_msg_eng.h"
#endif

void ShowControlAdvice(int Control){
	if(Control==IDC_TOOL_MOUSE) SetStatusText("");

#if defined(JPN)
	//{
	else if(Control==IDC_TOOL_BUTTON) SetStatusText("[{^] NbN邱Ƃł{^łB");
	else if(Control==IDC_TOOL_CHECKBOX) SetStatusText("[`FbN {bNX] ON/OFF̐ݒ肪ł{^łB");
	else if(Control==IDC_TOOL_COMBOBOX) SetStatusText("[R{ {bNX] hbv_E Xg̒獀ڂI邱Ƃł܂B");
	else if(Control==IDC_TOOL_EDIT) SetStatusText("[GfBbg {bNX] [U[̕ҏWsƂł܂B");
	else if(Control==IDC_TOOL_GROUPBOX) SetStatusText("[O[v {bNX] ̃Rg[͂ނƂł܂B");
	else if(Control==IDC_TOOL_HSCROLLBAR) SetStatusText("[XN[o[] ݈ʒu\Aݒ肵܂B");
	else if(Control==IDC_TOOL_IMAGEBOX) SetStatusText("[C[W {bNX] lp`rbg}bvAACR\܂B");
	else if(Control==IDC_TOOL_LISTBOX) SetStatusText("[Xg {bNX] ̍ڂ\AIł郊XgłB");
	else if(Control==IDC_TOOL_LISTVIEW) SetStatusText("[Xg r[] Xg {bNXɃACReLXgׂĕ\r[łB");
	else if(Control==IDC_TOOL_PROGRESSBAR) SetStatusText("[vOX o[] is󋵂\o[B");
	else if(Control==IDC_TOOL_RADIOBUTTON) SetStatusText("[WI {^] ̍ڂPI{^łB");
	else if(Control==IDC_TOOL_STATIC) SetStatusText("[X^eBbN eLXg] eLXg\܂B");
	else if(Control==IDC_TOOL_TRACKBAR) SetStatusText("[gbN o[] ڐtړo[B");
	else if(Control==IDC_TOOL_TREEVIEW) SetStatusText("[c[ r[] XgKw\ŕ\܂B");
	else if(Control==IDC_TOOL_UPDOWN) SetStatusText("[Abv _E Rg[] ㉺̃{^Őlݒ肵܂B");
	else if(Control==IDC_TOOL_VSCROLLBAR) SetStatusText("[XN[o[] ݈ʒu\Aݒ肵܂B");
#else
	//p
	else if(Control==IDC_TOOL_BUTTON) SetStatusText("[Button] The button which can be clicked");
	else if(Control==IDC_TOOL_CHECKBOX) SetStatusText("[CheckBox] The button which can switch on/off");
	else if(Control==IDC_TOOL_COMBOBOX) SetStatusText("[ComboBox] Choose an item from drop down lists");
	else if(Control==IDC_TOOL_EDIT) SetStatusText("[EditBox] A user can edit a character sequence");
	else if(Control==IDC_TOOL_GROUPBOX) SetStatusText("[GroupBox] Two or more control can be packed");
	else if(Control==IDC_TOOL_HSCROLLBAR) SetStatusText("[Horizontal Scrollbar] The present position is displayed and setup");
	else if(Control==IDC_TOOL_IMAGEBOX) SetStatusText("[ImageBox] A rectangle, a bitmap, and an icon are displayed.");
	else if(Control==IDC_TOOL_LISTBOX) SetStatusText("[ListBox] The list which can display and choose two or more items");
	else if(Control==IDC_TOOL_LISTVIEW) SetStatusText("[ListView] The view which displays an icon and a text in a list box");
	else if(Control==IDC_TOOL_PROGRESSBAR) SetStatusText("[Progressbar] The bar which displays an advance situation");
	else if(Control==IDC_TOOL_RADIOBUTTON) SetStatusText("[RadioButton] The button which chooses one from two or more items");
	else if(Control==IDC_TOOL_STATIC) SetStatusText("[StaticText] Display the text messages");
	else if(Control==IDC_TOOL_TRACKBAR) SetStatusText("[Trackbar] The bar to which the scale was attached");
	else if(Control==IDC_TOOL_TREEVIEW) SetStatusText("[TreeView] Lists are displayed by the layered structure");
	else if(Control==IDC_TOOL_UPDOWN) SetStatusText("[Up/Down Control] A numerical value is set up with a up/down button");
	else if(Control==IDC_TOOL_VSCROLLBAR) SetStatusText("[Vertical Scrollbar] The present position is displayed and setup");
#endif
}

char *GetControlName(DWORD id){
	char *pTemp;
	pTemp="";

#if defined(JPN)
	//{
	if(id==IDC_TOOL_MOUSE) pTemp="I";
	else if(id==IDC_TOOL_STATIC) pTemp="X^eBbN eLXg";
	else if(id==IDC_TOOL_EDIT) pTemp="GfBbg {bNX";
	else if(id==IDC_TOOL_GROUPBOX) pTemp="O[v {bNX";
	else if(id==IDC_TOOL_COMBOBOX) pTemp="R{ {bNX";
	else if(id==IDC_TOOL_LISTBOX) pTemp="Xg {bNX";
	else if(id==IDC_TOOL_BUTTON) pTemp="{^";
	else if(id==IDC_TOOL_CHECKBOX) pTemp="`FbN {bNX";
	else if(id==IDC_TOOL_RADIOBUTTON) pTemp="WI {^";
	else if(id==IDC_TOOL_LISTVIEW) pTemp="Xg r[";
	else if(id==IDC_TOOL_TREEVIEW) pTemp="c[ r[";
	else if(id==IDC_TOOL_HSCROLLBAR) pTemp="XN[ o[";
	else if(id==IDC_TOOL_VSCROLLBAR) pTemp="XN[ o[";
	else if(id==IDC_TOOL_UPDOWN) pTemp="Abv _E Rg[";
	else if(id==IDC_TOOL_IMAGEBOX) pTemp="C[W {bNX";
	else if(id==IDC_TOOL_TRACKBAR) pTemp="gbN o[";
	else if(id==IDC_TOOL_PROGRESSBAR) pTemp="vOX o[";
#else
	//p
	if(id==IDC_TOOL_MOUSE) pTemp="Tool";
	else if(id==IDC_TOOL_STATIC) pTemp="StaticText";
	else if(id==IDC_TOOL_EDIT) pTemp="EditBox";
	else if(id==IDC_TOOL_GROUPBOX) pTemp="GroupBox";
	else if(id==IDC_TOOL_COMBOBOX) pTemp="ComboBox";
	else if(id==IDC_TOOL_LISTBOX) pTemp="ListBox";
	else if(id==IDC_TOOL_BUTTON) pTemp="Button";
	else if(id==IDC_TOOL_CHECKBOX) pTemp="CheckBox";
	else if(id==IDC_TOOL_RADIOBUTTON) pTemp="RadioButton";
	else if(id==IDC_TOOL_LISTVIEW) pTemp="ListView";
	else if(id==IDC_TOOL_TREEVIEW) pTemp="TreeView";
	else if(id==IDC_TOOL_HSCROLLBAR) pTemp="Horizontal Scrollbar";
	else if(id==IDC_TOOL_VSCROLLBAR) pTemp="Vertical Scrollbar";
	else if(id==IDC_TOOL_UPDOWN) pTemp="Up/Down Control";
	else if(id==IDC_TOOL_IMAGEBOX) pTemp="ImageBox";
	else if(id==IDC_TOOL_TRACKBAR) pTemp="Trackbar";
	else if(id==IDC_TOOL_PROGRESSBAR) pTemp="Progressbar";
#endif

	return pTemp;
}
BOOL CALLBACK RadToolButtonsProc(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam){
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	extern PROJECTINFO ProjectInfo;
	int i,i2,WndNum;
	HWND hParent;
	HWND hToolBar;
	RECT rect;
	TBBUTTON CtrlToolBar[]={
		{0,IDC_TOOL_MOUSE,TBSTATE_ENABLED|TBSTATE_WRAP|TBSTATE_CHECKED,TBSTYLE_CHECKGROUP,0,0},
		{1,IDC_TOOL_STATIC,TBSTATE_ENABLED,TBSTYLE_CHECKGROUP,0,0},
		{2,IDC_TOOL_EDIT,TBSTATE_ENABLED,TBSTYLE_CHECKGROUP,0,0},
		{3,IDC_TOOL_GROUPBOX,TBSTATE_ENABLED,TBSTYLE_CHECKGROUP,0,0},
		{BMPNUM_RADTOOLBAR-1,0,TBSTATE_INDETERMINATE,TBSTYLE_CHECKGROUP,0,0},
		{4,IDC_TOOL_COMBOBOX,TBSTATE_ENABLED,TBSTYLE_CHECKGROUP,0,0},
		{5,IDC_TOOL_LISTBOX,TBSTATE_ENABLED|TBSTATE_WRAP,TBSTYLE_CHECKGROUP,0,0},
		{6,IDC_TOOL_BUTTON,TBSTATE_ENABLED,TBSTYLE_CHECKGROUP,0,0},
		{7,IDC_TOOL_CHECKBOX,TBSTATE_ENABLED,TBSTYLE_CHECKGROUP,0,0},
		{8,IDC_TOOL_RADIOBUTTON,TBSTATE_ENABLED,TBSTYLE_CHECKGROUP,0,0},
		{BMPNUM_RADTOOLBAR-1,0,TBSTATE_INDETERMINATE,TBSTYLE_CHECKGROUP,0,0},
		{9,IDC_TOOL_LISTVIEW,TBSTATE_ENABLED,TBSTYLE_CHECKGROUP,0,0},
		{10,IDC_TOOL_TREEVIEW,TBSTATE_ENABLED|TBSTATE_WRAP,TBSTYLE_CHECKGROUP,0,0},
		{11,IDC_TOOL_HSCROLLBAR,TBSTATE_ENABLED,TBSTYLE_CHECKGROUP,0,0},
		{12,IDC_TOOL_VSCROLLBAR,TBSTATE_ENABLED,TBSTYLE_CHECKGROUP,0,0},
		{13,IDC_TOOL_UPDOWN,TBSTATE_ENABLED,TBSTYLE_CHECKGROUP,0,0},
		{BMPNUM_RADTOOLBAR-1,0,TBSTATE_INDETERMINATE,TBSTYLE_CHECKGROUP,0,0},
		{14,IDC_TOOL_IMAGEBOX,TBSTATE_ENABLED|TBSTATE_WRAP,TBSTYLE_CHECKGROUP,0,0},
		{15,IDC_TOOL_TRACKBAR,TBSTATE_ENABLED,TBSTYLE_CHECKGROUP,0,0},
		{16,IDC_TOOL_PROGRESSBAR,TBSTATE_ENABLED,TBSTYLE_CHECKGROUP,0,0},
	};
	TOOLTIPTEXT *pTipText;

	switch(message){
		case WM_INITDIALOG:
			hToolBar=CreateToolbarEx(hwnd,WS_CHILD|WS_VISIBLE|CCS_NODIVIDER|TBSTYLE_FLAT|TBSTYLE_TOOLTIPS,
				NULL,
				BMPNUM_RADTOOLBAR,	/*rbg}bv̌*/
				hResInst,(unsigned int)MAKEINTRESOURCE(IDR_CONTROL),CtrlToolBar,
				(BMPNUM_RADTOOLBAR-1)+SEPNUM_RADTOOLBAR,	/*ACě*/
				0,0,16,15,sizeof(TBBUTTON));

			//Windows9xnOSł̕sh
			PostMessage(hwnd,WM_USER+120,0,0);

			break;
		case WM_USER+120:
			GetClientRect(hwnd,&rect);
			MoveWindow(hwnd,5,22,rect.right,rect.bottom,1);
			MoveWindow(GetWindow(hwnd,GW_CHILD),0,0,rect.right,rect.bottom,1);
			return 1;
		case WM_COMMAND:
			switch(LOWORD(wParam)){
				case IDC_TOOL_MOUSE:
					ShowControlAdvice(LOWORD(wParam));
					hParent=GetParent(GetParent(hwnd));
					BringWindowToTop(hParent);
					i=GetWndNum(hParent);
					i2=GetWndInfoNum(MdiInfo[i].path);
					MdiInfo[i].MdiRadInfo->ButtonSelect=IDC_TOOL_MOUSE;
					DrawSelectingRect(MdiInfo[i].MdiRadInfo->hRad,i,i2,IDC_TOOL_MOUSE);
					SetFocus(MdiInfo[i].MdiRadInfo->hRad);
					return 1;
				case IDC_TOOL_BUTTON:
				case IDC_TOOL_CHECKBOX:
				case IDC_TOOL_COMBOBOX:
				case IDC_TOOL_EDIT:
				case IDC_TOOL_GROUPBOX:
				case IDC_TOOL_HSCROLLBAR:
				case IDC_TOOL_IMAGEBOX:
				case IDC_TOOL_LISTBOX:
				case IDC_TOOL_LISTVIEW:
				case IDC_TOOL_PROGRESSBAR:
				case IDC_TOOL_RADIOBUTTON:
				case IDC_TOOL_STATIC:
				case IDC_TOOL_TRACKBAR:
				case IDC_TOOL_TREEVIEW:
				case IDC_TOOL_UPDOWN:
				case IDC_TOOL_VSCROLLBAR:
					ShowControlAdvice(LOWORD(wParam));
					hParent=GetParent(GetParent(hwnd));
					BringWindowToTop(hParent);
					WndNum=GetWndNum(hParent);
					MdiInfo[WndNum].MdiRadInfo->ButtonSelect=LOWORD(wParam);
					InvalidateRect(MdiInfo[WndNum].MdiRadInfo->hRad,NULL,0);
					return 1;
			}
			break;
		case WM_NOTIFY:
			pTipText=(TOOLTIPTEXT *)lParam;
			if(pTipText->hdr.code==TTN_NEEDTEXT){
				//Xe[^Xo[ɐ\
				ShowControlAdvice(pTipText->hdr.idFrom);

				//Rg[擾Ac[qgƂĕ\
				pTipText->lpszText=GetControlName(pTipText->hdr.idFrom);
			}
			break;
	}
	return 0;
}
LRESULT CALLBACK RadToolsWindow(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam){
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	extern PROJECTINFO ProjectInfo;
	extern HFONT hStatusFont;
	int i;
	RECT rect;
	SCROLLINFO ScrollInfo;
	HDC hdc;
	PAINTSTRUCT ps;
	HFONT hOldFont;
	POINT pos;

	switch(message){
		case WM_CREATE:
			CreateDialog(hResInst,MAKEINTRESOURCE(IDD_RAD_CTRLBUTTONS),hwnd,(DLGPROC)RadToolButtonsProc);
			return 0;
		case WM_VSCROLL:
			ScrollInfo.cbSize=sizeof(SCROLLINFO);
			ScrollInfo.fMask=SIF_POS|SIF_PAGE|SIF_RANGE;
			GetScrollInfo(hwnd,SB_VERT,&ScrollInfo);
			if(LOWORD(wParam)==SB_LINEUP) i=-20;
			else if(LOWORD(wParam)==SB_LINEDOWN) i=20;
			else if(LOWORD(wParam)==SB_PAGEUP) i=-(signed int)ScrollInfo.nPage;
			else if(LOWORD(wParam)==SB_PAGEDOWN) i=ScrollInfo.nPage;
			else if(LOWORD(wParam)==SB_THUMBTRACK) i=HIWORD(wParam)-ScrollInfo.nPos;
			else i=0;
			GetClientRect(hwnd,&rect);
			i=max(-ScrollInfo.nPos,min(i,ScrollInfo.nMax-rect.bottom-ScrollInfo.nPos));
			if(i!=0){
				ScrollInfo.nPos+=i;
				SetScrollInfo(hwnd,SB_VERT,&ScrollInfo,1);
				ScrollWindow(hwnd,0,-i,NULL,NULL);
				UpdateWindow(hwnd);
			}
			return 0;
		case WM_SIZE:
			GetClientRect(GetWindow(hwnd,GW_CHILD),&rect);
			ScrollInfo.cbSize=sizeof(SCROLLINFO);
			ScrollInfo.fMask=SIF_PAGE|SIF_RANGE|SIF_POS;

			//XN[o[̐ݒ
			GetScrollInfo(hwnd,SB_VERT,&ScrollInfo);
			ScrollInfo.nMin=0;
			ScrollInfo.nMax=rect.bottom;
			ScrollInfo.nPage=HIWORD(lParam);
			SetScrollInfo(hwnd,SB_VERT,&ScrollInfo,1);

			i=ScrollInfo.nPos;
			ScrollInfo.fMask=SIF_POS;
			GetScrollInfo(hwnd,SB_VERT,&ScrollInfo);
			if(i>ScrollInfo.nPos){
				ScrollWindow(hwnd,0,i-ScrollInfo.nPos,NULL,NULL);
				UpdateWindow(hwnd);
			}
			return 0;
		case WM_PAINT:
			hdc=BeginPaint(hwnd,&ps);
			hOldFont=(HFONT)SelectObject(hdc,hStatusFont);
			SetBkMode(hdc,TRANSPARENT);
			pos.x=30;
			pos.y=3;
			CursorPos_GlobalToLocal(hwnd,&pos.x,&pos.y);
#if defined(JPN)
			//{
			TextOut(hdc,pos.x,pos.y,"- Rg[ -",lstrlen("- Rg[ -"));
#else
			//p
			TextOut(hdc,pos.x,pos.y,"-   Control   -",lstrlen("-   Control   -"));
#endif
			SelectObject(hdc,hOldFont);
			EndPaint(hwnd,&ps);
			return 0;
	}
	return DefWindowProc(hwnd,message,wParam,lParam);
}


/////////////////////////
//EBhE vpeB

void RadProperty_Window_Caption_StylingOrder(HWND hwnd,DWORD *style){
	if((*style&WS_CAPTION)==WS_CAPTION){
		EnableWindow(GetDlgItem(hwnd,IDC_STYLE_SYSMENU),1);
		if(!(*style&WS_CHILD)){
			EnableWindow(GetDlgItem(hwnd,IDC_STYLE_MINIMIZEBOX),1);
			EnableWindow(GetDlgItem(hwnd,IDC_STYLE_MAXIMIZEBOX),1);
		}
		if(SendDlgItemMessage(hwnd,IDC_BORDERSTYLE,CB_GETCURSEL,0,0)==0){
			if(*style&WS_THICKFRAME) SendDlgItemMessage(hwnd,IDC_BORDERSTYLE,CB_SETCURSEL,2,0);
			else SendDlgItemMessage(hwnd,IDC_BORDERSTYLE,CB_SETCURSEL,1,0);
		}
	}
	else{
		*style&=~(WS_SYSMENU|WS_MINIMIZEBOX|WS_MAXIMIZEBOX);
		SendDlgItemMessage(hwnd,IDC_STYLE_SYSMENU,BM_SETCHECK,BST_UNCHECKED,0);
		SendDlgItemMessage(hwnd,IDC_STYLE_MINIMIZEBOX,BM_SETCHECK,BST_UNCHECKED,0);
		SendDlgItemMessage(hwnd,IDC_STYLE_MAXIMIZEBOX,BM_SETCHECK,BST_UNCHECKED,0);
		EnableWindow(GetDlgItem(hwnd,IDC_STYLE_SYSMENU),0);
		EnableWindow(GetDlgItem(hwnd,IDC_STYLE_MINIMIZEBOX),0);
		EnableWindow(GetDlgItem(hwnd,IDC_STYLE_MAXIMIZEBOX),0);
	}
}
void RadProperty_Window_Border_StylingOrder(HWND hwnd,DWORD *style){
	if(*style&(WS_BORDER|WS_THICKFRAME)){
		if(*style&(WS_POPUP|WS_CHILD)) EnableWindow(GetDlgItem(hwnd,IDC_STYLE_CAPTION),1);
		else{
			*style|=WS_CAPTION;
			SendDlgItemMessage(hwnd,IDC_STYLE_CAPTION,BM_SETCHECK,BST_CHECKED,0);
			EnableWindow(GetDlgItem(hwnd,IDC_STYLE_CAPTION),0);
		}
	}
	else{
		*style&=~WS_CAPTION;
		SendDlgItemMessage(hwnd,IDC_STYLE_CAPTION,BM_SETCHECK,BST_UNCHECKED,0);
		EnableWindow(GetDlgItem(hwnd,IDC_STYLE_CAPTION),0);
	}
	RadProperty_Window_Caption_StylingOrder(hwnd,style);
}
void RadProperty_Window_Window_StylingOrder(HWND hwnd,DWORD *style){
	if(*style&WS_POPUP){
		EnableWindow(GetDlgItem(hwnd,IDC_STYLE_CAPTION),1);
		EnableWindow(GetDlgItem(hwnd,IDC_STYLE_MINIMIZEBOX),1);
		EnableWindow(GetDlgItem(hwnd,IDC_STYLE_MAXIMIZEBOX),1);
		EnableWindow(GetDlgItem(hwnd,IDC_STYLE_MINIMIZE),1);
		EnableWindow(GetDlgItem(hwnd,IDC_STYLE_MAXIMIZE),1);
	}
	else if(*style&WS_CHILD){
		EnableWindow(GetDlgItem(hwnd,IDC_STYLE_CAPTION),1);

		*style&=~(WS_MINIMIZEBOX|WS_MAXIMIZEBOX|WS_MINIMIZE|WS_MAXIMIZE);
		SendDlgItemMessage(hwnd,IDC_STYLE_MINIMIZEBOX,BM_SETCHECK,BST_UNCHECKED,0);
		SendDlgItemMessage(hwnd,IDC_STYLE_MAXIMIZEBOX,BM_SETCHECK,BST_UNCHECKED,0);
		SendDlgItemMessage(hwnd,IDC_STYLE_MINIMIZE,BM_SETCHECK,BST_UNCHECKED,0);
		SendDlgItemMessage(hwnd,IDC_STYLE_MAXIMIZE,BM_SETCHECK,BST_UNCHECKED,0);
		EnableWindow(GetDlgItem(hwnd,IDC_STYLE_MINIMIZEBOX),0);
		EnableWindow(GetDlgItem(hwnd,IDC_STYLE_MAXIMIZEBOX),0);
		EnableWindow(GetDlgItem(hwnd,IDC_STYLE_MINIMIZE),0);
		EnableWindow(GetDlgItem(hwnd,IDC_STYLE_MAXIMIZE),0);
	}
	else{
		if(*style&WS_BORDER){
			*style|=WS_CAPTION;
			SendDlgItemMessage(hwnd,IDC_STYLE_CAPTION,BM_SETCHECK,BST_CHECKED,0);
			EnableWindow(GetDlgItem(hwnd,IDC_STYLE_CAPTION),0);

			EnableWindow(GetDlgItem(hwnd,IDC_STYLE_MINIMIZEBOX),1);
			EnableWindow(GetDlgItem(hwnd,IDC_STYLE_MAXIMIZEBOX),1);
			EnableWindow(GetDlgItem(hwnd,IDC_STYLE_MINIMIZE),1);
			EnableWindow(GetDlgItem(hwnd,IDC_STYLE_MAXIMIZE),1);
		}
	}
	RadProperty_Window_Border_StylingOrder(hwnd,style);
}
BOOL CALLBACK DlgRadProperty_Window_Rename(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam){
	extern HANDLE hHeap;
	extern HWND hClient,hOwner;
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	extern PROJECTINFO ProjectInfo;
	int i,i2,i3;
	char temporary[MAX_PATH],temp2[MAX_PATH];
	switch(message){
		case WM_INITDIALOG:
			SetPosCenter(hwnd);
			i=GetWndNum(GetWindow(hClient,GW_CHILD));
			i2=GetWndInfoNum(MdiInfo[i].path);
			sprintf(temporary,"h%s",ProjectInfo.pWindowInfo[i2].name);
			sprintf(temp2,"%sProc",ProjectInfo.pWindowInfo[i2].name);
			if(lstrcmp(temporary,ProjectInfo.pWindowInfo[i2].HandleName)==0&&
				lstrcmp(temp2,ProjectInfo.pWindowInfo[i2].CallBackName)==0){
				SendDlgItemMessage(hwnd,IDC_AUTOSET,BM_SETCHECK,BST_CHECKED,0);
				SendMessage(hwnd,WM_COMMAND,IDC_AUTOSET,0);
			}
			SetDlgItemText(hwnd,IDC_WINDOWNAME,ProjectInfo.pWindowInfo[i2].name);
			SetDlgItemText(hwnd,IDC_WINDOWHANDLE,ProjectInfo.pWindowInfo[i2].HandleName);
			SetDlgItemText(hwnd,IDC_WINDOWPROC,ProjectInfo.pWindowInfo[i2].CallBackName);
			break;
		case WM_COMMAND:
			switch(LOWORD(wParam)){
				case IDOK:
					if(GetWindowTextLength(GetDlgItem(hwnd,IDC_WINDOWNAME))==0){
						//MsgBox "EBhEʖ͂ĉB"
						MessageBox(hOwner,STRING_WINDOW_RENAME_MUST_WINDOWNAME,APPLICATION_NAME,MB_OK|MB_ICONEXCLAMATION);
						break;
					}
					if(GetWindowTextLength(GetDlgItem(hwnd,IDC_WINDOWHANDLE))==0){
						//MsgBox "nh͂ĉB"
						MessageBox(hOwner,STRING_WINDOW_RENAME_MUST_HANDLENAME,APPLICATION_NAME,MB_OK|MB_ICONEXCLAMATION);
						break;
					}
					if(GetWindowTextLength(GetDlgItem(hwnd,IDC_WINDOWPROC))==0){
						//MsgBox "vV[W͂ĉB"
						MessageBox(hOwner,STRING_WINDOW_RENAME_MUST_PROCEDURENAME,APPLICATION_NAME,MB_OK|MB_ICONEXCLAMATION);
						break;
					}

					i=GetWndNum(GetWindow(hClient,GW_CHILD));
					i2=GetWndInfoNum(MdiInfo[i].path);

					RAD_UNDOSTATE_NAME names,NoticeNames;
					i3=GetWindowTextLength(GetDlgItem(hwnd,IDC_WINDOWNAME))+1;
					names.name=(char *)HeapAlloc(hHeap,0,i3);
					GetDlgItemText(hwnd,IDC_WINDOWNAME,names.name,i3);

					i3=GetWindowTextLength(GetDlgItem(hwnd,IDC_WINDOWHANDLE))+1;
					names.HandleName=(char *)HeapAlloc(hHeap,0,i3);
					GetDlgItemText(hwnd,IDC_WINDOWHANDLE,names.HandleName,i3);

					i3=GetWindowTextLength(GetDlgItem(hwnd,IDC_WINDOWPROC))+1;
					names.CallBackName=(char *)HeapAlloc(hHeap,0,i3);
					GetDlgItemText(hwnd,IDC_WINDOWPROC,names.CallBackName,i3);

					if(lstrcmp(names.name,ProjectInfo.pWindowInfo[i2].name)==0&&
						lstrcmp(names.HandleName,ProjectInfo.pWindowInfo[i2].HandleName)==0&&
						lstrcmp(names.CallBackName,ProjectInfo.pWindowInfo[i2].CallBackName)==0){
						HeapDefaultFree(names.name);
						HeapDefaultFree(names.HandleName);
						HeapDefaultFree(names.CallBackName);
						SendMessage(hwnd,WM_COMMAND,IDCANCEL,0);
						return 1;
					}

					//MsgBox "̃EBhEʖύXƁA\[XR[h̎ʎq͎蓮ŕϊKv܂BύX܂H"
					if(IDCANCEL==MessageBox(hwnd,STRING_WINDOW_RENAME_CHECK,APPLICATION_NAME,MB_OKCANCEL|MB_ICONEXCLAMATION)) return 1;

					//ύXXV
					NoticeNames.name=ProjectInfo.pWindowInfo[i2].name;
					NoticeNames.HandleName=ProjectInfo.pWindowInfo[i2].HandleName;
					NoticeNames.CallBackName=ProjectInfo.pWindowInfo[i2].CallBackName;
					Rad_NoticeChanging(i,RAD_UNDO_NAME,SELECT_WINDOW,(DWORD)&NoticeNames);

					HeapDefaultFree(ProjectInfo.pWindowInfo[i2].name);
					ProjectInfo.pWindowInfo[i2].name=names.name;
					GlobalFree(MdiInfo[i].path);
					MdiInfo[i].path=(char *)GlobalAlloc(GMEM_FIXED,lstrlen(names.name));
					lstrcpy(MdiInfo[i].path,names.name);

					HeapDefaultFree(ProjectInfo.pWindowInfo[i2].HandleName);
					ProjectInfo.pWindowInfo[i2].HandleName=names.HandleName;

					HeapDefaultFree(ProjectInfo.pWindowInfo[i2].CallBackName);
					ProjectInfo.pWindowInfo[i2].CallBackName=names.CallBackName;

					EndDialog(hwnd,1);
					return 1;
				case IDCANCEL:
					EndDialog(hwnd,0);
					return 1;
				case IDC_WINDOWNAME:
					if(HIWORD(wParam)==EN_CHANGE) SendMessage(hwnd,WM_COMMAND,IDC_AUTOSET,0);
					return 1;
				case IDC_AUTOSET:
					if(SendDlgItemMessage(hwnd,IDC_AUTOSET,BM_GETCHECK,0,0)){
						SendDlgItemMessage(hwnd,IDC_WINDOWHANDLE,EM_SETREADONLY,1,0);
						SendDlgItemMessage(hwnd,IDC_WINDOWPROC,EM_SETREADONLY,1,0);
						GetDlgItemText(hwnd,IDC_WINDOWNAME,temporary,MAX_PATH);
						if(temporary[0]){
							sprintf(temp2,"h%s",temporary);
							SetDlgItemText(hwnd,IDC_WINDOWHANDLE,temp2);
							sprintf(temp2,"%sProc",temporary);
							SetDlgItemText(hwnd,IDC_WINDOWPROC,temp2);
						}
						else{
							SetDlgItemText(hwnd,IDC_WINDOWHANDLE,"");
							SetDlgItemText(hwnd,IDC_WINDOWPROC,"");
						}
					}
					else{
						SendDlgItemMessage(hwnd,IDC_WINDOWHANDLE,EM_SETREADONLY,0,0);
						SendDlgItemMessage(hwnd,IDC_WINDOWPROC,EM_SETREADONLY,0,0);
					}
					return 1;
			}
			break;
	}
	return 0;
}
BOOL CALLBACK DlgRadProperty_Window_ExStyle(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam){
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	extern PROJECTINFO ProjectInfo;
	int i,i2;

	switch(message){
		case WM_INITDIALOG:
			SetPosCenter(hwnd);
			i=GetWndNum(GetWindow(hClient,GW_CHILD));
			i2=GetWndInfoNum(MdiInfo[i].path);
			if(ProjectInfo.pWindowInfo[i2].ExStyle&WS_EX_TOPMOST) SendDlgItemMessage(hwnd,IDC_EXSTYLE_TOPMOST,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].ExStyle&WS_EX_ACCEPTFILES) SendDlgItemMessage(hwnd,IDC_EXSTYLE_ACCEPTFILES,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].ExStyle&WS_EX_TRANSPARENT) SendDlgItemMessage(hwnd,IDC_EXSTYLE_TRANSPARENT,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].ExStyle&WS_EX_TOOLWINDOW) SendDlgItemMessage(hwnd,IDC_EXSTYLE_TOOLWINDOW,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].ExStyle&WS_EX_CLIENTEDGE) SendDlgItemMessage(hwnd,IDC_EXSTYLE_CLIENTEDGE,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].ExStyle&WS_EX_STATICEDGE) SendDlgItemMessage(hwnd,IDC_EXSTYLE_STATICEDGE,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].ExStyle&WS_EX_NOPARENTNOTIFY) SendDlgItemMessage(hwnd,IDC_EXSTYLE_NOPARENTNOTIFY,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].ExStyle&WS_EX_CONTEXTHELP) SendDlgItemMessage(hwnd,IDC_EXSTYLE_CONTEXTHELP,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].ExStyle&WS_EX_CONTROLPARENT) SendDlgItemMessage(hwnd,IDC_EXSTYLE_CONTROLPARENT,BM_SETCHECK,BST_CHECKED,0);
			break;
		case WM_COMMAND:
			switch(LOWORD(wParam)){
				case IDOK:
					i=GetWndNum(GetWindow(hClient,GW_CHILD));
					i2=GetWndInfoNum(MdiInfo[i].path);

					DWORD style;
					style=0;
					if(SendDlgItemMessage(hwnd,IDC_EXSTYLE_TOPMOST,BM_GETCHECK,0,0))
						style|=WS_EX_TOPMOST;
					if(SendDlgItemMessage(hwnd,IDC_EXSTYLE_ACCEPTFILES,BM_GETCHECK,0,0))
						style|=WS_EX_ACCEPTFILES;
					if(SendDlgItemMessage(hwnd,IDC_EXSTYLE_TRANSPARENT,BM_GETCHECK,0,0))
						style|=WS_EX_TRANSPARENT;
					if(SendDlgItemMessage(hwnd,IDC_EXSTYLE_TOOLWINDOW,BM_GETCHECK,0,0))
						style|=WS_EX_TOOLWINDOW;
					if(SendDlgItemMessage(hwnd,IDC_EXSTYLE_CLIENTEDGE,BM_GETCHECK,0,0))
						style|=WS_EX_CLIENTEDGE;
					if(SendDlgItemMessage(hwnd,IDC_EXSTYLE_STATICEDGE,BM_GETCHECK,0,0))
						style|=WS_EX_STATICEDGE;
					if(SendDlgItemMessage(hwnd,IDC_EXSTYLE_NOPARENTNOTIFY,BM_GETCHECK,0,0))
						style|=WS_EX_NOPARENTNOTIFY;
					if(SendDlgItemMessage(hwnd,IDC_EXSTYLE_CONTEXTHELP,BM_GETCHECK,0,0))
						style|=WS_EX_CONTEXTHELP;
					if(SendDlgItemMessage(hwnd,IDC_EXSTYLE_CONTROLPARENT,BM_GETCHECK,0,0))
						style|=WS_EX_CONTROLPARENT;

					if(style==ProjectInfo.pWindowInfo[i2].ExStyle){
						SendMessage(hwnd,WM_COMMAND,IDCANCEL,0);
						return 1;
					}

					//ύX
					Rad_NoticeChanging(i,RAD_UNDO_EXSTYLE,SELECT_WINDOW,ProjectInfo.pWindowInfo[i2].ExStyle);

					ProjectInfo.pWindowInfo[i2].ExStyle=style;
					EndDialog(hwnd,1);
					return 1;
				case IDCANCEL:
					EndDialog(hwnd,0);
					return 1;
			}
			break;
	}
	return 0;
}
BOOL CALLBACK RadProperty_WindowProc(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam){
	extern HANDLE hHeap;
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	extern PROJECTINFO ProjectInfo;
	int i,i2,i3,i4;
	static BOOL bInitial;

	switch(message){
		case WM_INITDIALOG:
			bInitial=1;
			i=GetWndNum(GetParent(GetParent(hwnd)));
			i2=GetWndInfoNum(MdiInfo[i].path);

			SetDlgItemText(hwnd,IDC_WINDOWNAME,ProjectInfo.pWindowInfo[i2].name);
			SetDlgItemText(hwnd,IDC_HANDLE,ProjectInfo.pWindowInfo[i2].HandleName);
			SetDlgItemText(hwnd,IDC_CAPTION,ProjectInfo.pWindowInfo[i2].caption);

			//"3D FACEiWj"
			SendDlgItemMessage(hwnd,IDC_BGCOLOR,CB_ADDSTRING,0,(long)STRING_WINDOWPROP_BGCOLOR1);
			//"Fw"
			SendDlgItemMessage(hwnd,IDC_BGCOLOR,CB_ADDSTRING,0,(long)STRING_WINDOWPROP_BGCOLOR2);

			for(i3=0;i3<ProjectInfo.res.NumberOfBitmapRes;i3++)
				SendDlgItemMessage(hwnd,IDC_BGCOLOR,CB_ADDSTRING,0,(long)ProjectInfo.res.pBitmapResInfo[i3].IdName);
			if(ProjectInfo.pWindowInfo[i2].type==WNDTYPE_MODALDLG||
				ProjectInfo.pWindowInfo[i2].type==WNDTYPE_MODELESSDLG){
				SendDlgItemMessage(hwnd,IDC_BGCOLOR,CB_SETCURSEL,0,0);
				EnableWindow(GetDlgItem(hwnd,IDC_BGCOLOR),0);
			}
			else{
				if(ProjectInfo.pWindowInfo[i2].bgColor==COLOR_3DFACE){
					//3DFACE
					SendDlgItemMessage(hwnd,IDC_BGCOLOR,CB_SETCURSEL,0,0);
				}
				else if(ProjectInfo.pWindowInfo[i2].bgColor<=0){
					//Fw
					SendDlgItemMessage(hwnd,IDC_BGCOLOR,CB_SETCURSEL,1,0);
				}
				else if(ProjectInfo.pWindowInfo[i2].bgColor>=0x1000){
					//rbg}bvw
					SendDlgItemMessage(hwnd,IDC_BGCOLOR,CB_SETCURSEL,2+ProjectInfo.pWindowInfo[i2].bgColor-0x1000,0);
				}
			}


			////////////
			// j[
			////////////

			//"Ȃ"
			SendDlgItemMessage(hwnd,IDC_WINDOWMENU,CB_ADDSTRING,0,(long)STRING_NONE_);

			for(i3=0,i4=0;i3<ProjectInfo.NumberOfMenu;i3++){
				if(ProjectInfo.pWindowInfo[i2].MenuID){
					if(lstrcmpi(ProjectInfo.pMenuInfo[i3].IdName,ProjectInfo.pWindowInfo[i2].MenuID)==0)
						i4=i3+1;
				}
				SendDlgItemMessage(hwnd,IDC_WINDOWMENU,CB_ADDSTRING,0,(long)ProjectInfo.pMenuInfo[i3].IdName);
			}
			if(i4==0&&ProjectInfo.pWindowInfo[i2].MenuID){
				//j[݂ȂꍇAɂ
				HeapDefaultFree(ProjectInfo.pWindowInfo[i2].MenuID);
				ProjectInfo.pWindowInfo[i2].MenuID=0;
				DrawRadWindow(i,&ProjectInfo.pWindowInfo[i2]);
			}
			SendDlgItemMessage(hwnd,IDC_WINDOWMENU,CB_SETCURSEL,i4,0);


			////////////
			// ACR
			////////////

			//"WindowsSiWj"
			SendDlgItemMessage(hwnd,IDC_ICONRES,CB_ADDSTRING,0,(long)STRING_WINDOWPROP_ICONDEFAULT);

			for(i3=0,i4=0;i3<ProjectInfo.res.NumberOfIconRes;i3++){
				SendDlgItemMessage(hwnd,IDC_ICONRES,CB_ADDSTRING,0,(long)ProjectInfo.res.pIconResInfo[i3].IdName);

				if(lstrcmp(ProjectInfo.pWindowInfo[i2].IconResName,ProjectInfo.res.pIconResInfo[i3].IdName)==0)
					i4=i3+1;
			}
			if(i4==0&&ProjectInfo.pWindowInfo[i2].IconResName){
				//ACR݂ȂꍇAɂ
				HeapDefaultFree(ProjectInfo.pWindowInfo[i2].IconResName);
				ProjectInfo.pWindowInfo[i2].IconResName=0;
				DrawRadWindow(i,&ProjectInfo.pWindowInfo[i2]);
			}
			SendDlgItemMessage(hwnd,IDC_ICONRES,CB_SETCURSEL,i4,0);


			////////////
			// X^C
			////////////

			//"I[o[bv"
			SendDlgItemMessage(hwnd,IDC_WINDOWSTYLE,CB_ADDSTRING,0,(long)STRING_WINDOWPROP_STYLE_OVERLAPPED);
			//"|bvAbv"
			SendDlgItemMessage(hwnd,IDC_WINDOWSTYLE,CB_ADDSTRING,0,(long)STRING_WINDOWPROP_STYLE_POPUP);
			//"`Ch"
			SendDlgItemMessage(hwnd,IDC_WINDOWSTYLE,CB_ADDSTRING,0,(long)STRING_WINDOWPROP_STYLE_CHILD);

			if(ProjectInfo.pWindowInfo[i2].style&WS_POPUP) SendDlgItemMessage(hwnd,IDC_WINDOWSTYLE,CB_SETCURSEL,1,0);
			else if(ProjectInfo.pWindowInfo[i2].style&WS_CHILD) SendDlgItemMessage(hwnd,IDC_WINDOWSTYLE,CB_SETCURSEL,2,0);
			else SendDlgItemMessage(hwnd,IDC_WINDOWSTYLE,CB_SETCURSEL,0,0);

			//"gȂ"
			SendDlgItemMessage(hwnd,IDC_BORDERSTYLE,CB_ADDSTRING,0,(long)STRING_WINDOWPROP_STYLE_FRAME_NONE);
			//"טg"
			SendDlgItemMessage(hwnd,IDC_BORDERSTYLE,CB_ADDSTRING,0,(long)STRING_WINDOWPROP_STYLE_FRAME_THICK);
			//"TCYύXg"
			SendDlgItemMessage(hwnd,IDC_BORDERSTYLE,CB_ADDSTRING,0,(long)STRING_WINDOWPROP_STYLE_FRAME_BORDER);

			//WS_CAPTIONiWS_BORDER܂ށjlWS_THICKFRAMEŏɔr
			if(ProjectInfo.pWindowInfo[i2].style&WS_THICKFRAME) SendDlgItemMessage(hwnd,IDC_BORDERSTYLE,CB_SETCURSEL,2,0);
			else if(ProjectInfo.pWindowInfo[i2].style&WS_BORDER) SendDlgItemMessage(hwnd,IDC_BORDERSTYLE,CB_SETCURSEL,1,0);
			else SendDlgItemMessage(hwnd,IDC_BORDERSTYLE,CB_SETCURSEL,0,0);

			if(ProjectInfo.pWindowInfo[i2].style&WS_CAPTION) SendDlgItemMessage(hwnd,IDC_STYLE_CAPTION,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].style&WS_SYSMENU) SendDlgItemMessage(hwnd,IDC_STYLE_SYSMENU,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].style&WS_MINIMIZEBOX) SendDlgItemMessage(hwnd,IDC_STYLE_MINIMIZEBOX,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].style&WS_MAXIMIZEBOX) SendDlgItemMessage(hwnd,IDC_STYLE_MAXIMIZEBOX,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].style&WS_MINIMIZE) SendDlgItemMessage(hwnd,IDC_STYLE_MINIMIZE,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].style&WS_MAXIMIZE) SendDlgItemMessage(hwnd,IDC_STYLE_MAXIMIZE,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].style&WS_HSCROLL) SendDlgItemMessage(hwnd,IDC_STYLE_HSCROLLBAR,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].style&WS_VSCROLL) SendDlgItemMessage(hwnd,IDC_STYLE_VSCROLLBAR,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].style&WS_DISABLED) SendDlgItemMessage(hwnd,IDC_STYLE_DISABLED,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].style&WS_CLIPSIBLINGS) SendDlgItemMessage(hwnd,IDC_STYLE_CLIPSIBLINGS,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].style&WS_CLIPCHILDREN) SendDlgItemMessage(hwnd,IDC_STYLE_CLIPCHILDREN,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].style&WS_VISIBLE) SendDlgItemMessage(hwnd,IDC_STYLE_VISIBLE,BM_SETCHECK,BST_CHECKED,0);

			SetDlgItemText(hwnd,IDC_SETFONT,ProjectInfo.pWindowInfo[i2].LogFont.lfFaceName);

			RadProperty_Window_Window_StylingOrder(hwnd,&ProjectInfo.pWindowInfo[i2].style);


			//////////
			//^Cv
			switch(ProjectInfo.pWindowInfo[i2].type){
				case WNDTYPE_DEFAULT:
					SendDlgItemMessage(hwnd,IDC_DEFWINDOW,BM_SETCHECK,BST_CHECKED,0);
					break;
				case WNDTYPE_MODALDLG:
					SendDlgItemMessage(hwnd,IDC_MODALDLG,BM_SETCHECK,BST_CHECKED,0);
					break;
				case WNDTYPE_MODELESSDLG:
					SendDlgItemMessage(hwnd,IDC_MODELESSDLG,BM_SETCHECK,BST_CHECKED,0);
					break;
			}


			bInitial=0;
			break;
		case WM_COMMAND:
			switch(LOWORD(wParam)){
				case IDC_RENAMEWINDOW:
					if(!DialogBox(hResInst,MAKEINTRESOURCE(IDD_RAD_PROP_WINDOW_RENAME),hwnd,(DLGPROC)DlgRadProperty_Window_Rename)) return 1;
					i=GetWndNum(GetParent(GetParent(hwnd)));
					i2=GetWndInfoNum(MdiInfo[i].path);
					SetDlgItemText(hwnd,IDC_WINDOWNAME,ProjectInfo.pWindowInfo[i2].name);
					SetDlgItemText(hwnd,IDC_HANDLE,ProjectInfo.pWindowInfo[i2].HandleName);
					return 1;
				case IDC_RENAMECAPTION:
					if(!DialogBox(hResInst,MAKEINTRESOURCE(IDD_RAD_PROP_ITEM_RENAMECAPTION),hwnd,(DLGPROC)DlgRadProperty_Item_RenameCaption)) return 1;
					i=GetWndNum(GetParent(GetParent(hwnd)));
					i2=GetWndInfoNum(MdiInfo[i].path);
					SetDlgItemText(hwnd,IDC_CAPTION,ProjectInfo.pWindowInfo[i2].caption);
					return 1;
				case IDC_SETFONT:
					i=GetWndNum(GetParent(GetParent(hwnd)));
					i2=GetWndInfoNum(MdiInfo[i].path);
					LOGFONT lf;
					lf=ProjectInfo.pWindowInfo[i2].LogFont;
					if(!SetFontDialog(hwnd,&ProjectInfo.pWindowInfo[i2].LogFont,0)) return 1;

					//ύX
					Rad_NoticeChanging(i,RAD_UNDO_FONT,SELECT_WINDOW,(DWORD)&lf);

					SetDlgItemText(hwnd,IDC_SETFONT,ProjectInfo.pWindowInfo[i2].LogFont.lfFaceName);
					DrawRadWindow(i,&ProjectInfo.pWindowInfo[i2]);
					return 1;
				case IDC_BGCOLOR:
					if(HIWORD(wParam)==CBN_SELCHANGE){
						i=GetWndNum(GetParent(GetParent(hwnd)));
						i2=GetWndInfoNum(MdiInfo[i].path);

						i3=SendDlgItemMessage(hwnd,IDC_BGCOLOR,CB_GETCURSEL,0,0);
						if(i3==0){
							//3DFACE

							//ύX
							Rad_NoticeChanging(i,RAD_UNDO_BGCOLOR,SELECT_WINDOW,ProjectInfo.pWindowInfo[i2].bgColor);

							ProjectInfo.pWindowInfo[i2].bgColor=COLOR_3DFACE;
						}
						else if(i3==1){
							//Fw
							CHOOSECOLOR cc;
							COLORREF CusColors[16]={
								RGB(255,255,255),
								RGB(0,0,0),
								RGB(128,128,128),
								RGB(192,192,192),
								RGB(128,0,0),
								RGB(255,0,0),
								RGB(128,128,0),
								RGB(255,255,0),
								RGB(0,128,0),
								RGB(0,255,0),
								RGB(0,128,128),
								RGB(0,255,255),
								RGB(0,0,128),
								RGB(0,0,255),
								RGB(128,0,128),
								RGB(255,0,255)};
							cc.lStructSize=sizeof(CHOOSECOLOR);
							cc.hwndOwner=hwnd;
							if(ProjectInfo.pWindowInfo[i2].bgColor<=0)
								cc.rgbResult=-ProjectInfo.pWindowInfo[i2].bgColor;
							else cc.rgbResult=RGB(255,255,255);
							cc.lpCustColors=CusColors;
							cc.Flags=CC_RGBINIT|CC_FULLOPEN;
							if(!ChooseColor(&cc)){
								//LZ
								if(ProjectInfo.pWindowInfo[i2].bgColor==COLOR_3DFACE){
									//3DFACE
									SendDlgItemMessage(hwnd,IDC_BGCOLOR,CB_SETCURSEL,0,0);
								}
								else if(ProjectInfo.pWindowInfo[i2].bgColor<=0){
									//Fw
									SendDlgItemMessage(hwnd,IDC_BGCOLOR,CB_SETCURSEL,1,0);
								}
								else if(ProjectInfo.pWindowInfo[i2].bgColor>=0x1000){
									//rbg}bvw
									SendDlgItemMessage(hwnd,IDC_BGCOLOR,CB_SETCURSEL,2+ProjectInfo.pWindowInfo[i2].bgColor-0x1000,0);
								}
								return 1;
							}

							//ύX
							Rad_NoticeChanging(i,RAD_UNDO_BGCOLOR,SELECT_WINDOW,ProjectInfo.pWindowInfo[i2].bgColor);

							ProjectInfo.pWindowInfo[i2].bgColor=-(int)cc.rgbResult;
						}
						else{
							//rbg}bv
							i3-=2;

							//ύX
							Rad_NoticeChanging(i,RAD_UNDO_BGCOLOR,SELECT_WINDOW,ProjectInfo.pWindowInfo[i2].bgColor);

							ProjectInfo.pWindowInfo[i2].bgColor=0x1000+i3;
						}
						DrawRadWindow(i,&ProjectInfo.pWindowInfo[i2]);
						return 1;
					}
					break;
				case IDC_WINDOWMENU:
					if(HIWORD(wParam)==CBN_SELCHANGE){
						i=GetWndNum(GetParent(GetParent(hwnd)));
						i2=GetWndInfoNum(MdiInfo[i].path);

						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_WINDOWMENU,SELECT_WINDOW,(long)ProjectInfo.pWindowInfo[i2].MenuID);

						i3=SendDlgItemMessage(hwnd,IDC_WINDOWMENU,CB_GETCURSEL,0,0);
						if(ProjectInfo.pWindowInfo[i2].MenuID)
							HeapDefaultFree(ProjectInfo.pWindowInfo[i2].MenuID);
						if(i3==0) ProjectInfo.pWindowInfo[i2].MenuID=0;
						else{
							ProjectInfo.pWindowInfo[i2].MenuID=(char *)HeapAlloc(hHeap,0,SendDlgItemMessage(hwnd,IDC_WINDOWMENU,CB_GETLBTEXTLEN,i3,0)+1);
							SendDlgItemMessage(hwnd,IDC_WINDOWMENU,CB_GETLBTEXT,i3,(long)ProjectInfo.pWindowInfo[i2].MenuID);
						}
						DrawRadWindow(i,&ProjectInfo.pWindowInfo[i2]);
						return 1;
					}
					break;
				case IDC_ICONRES:
					if(HIWORD(wParam)==CBN_SELCHANGE){
						i=GetWndNum(GetParent(GetParent(hwnd)));
						i2=GetWndInfoNum(MdiInfo[i].path);

						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_ICONRES,SELECT_WINDOW,(long)ProjectInfo.pWindowInfo[i2].IconResName);

						i3=SendDlgItemMessage(hwnd,IDC_ICONRES,CB_GETCURSEL,0,0);
						if(ProjectInfo.pWindowInfo[i2].IconResName)
							HeapDefaultFree(ProjectInfo.pWindowInfo[i2].IconResName);
						if(i3==0) ProjectInfo.pWindowInfo[i2].IconResName=0;
						else{
							ProjectInfo.pWindowInfo[i2].IconResName=(char *)HeapAlloc(hHeap,0,SendDlgItemMessage(hwnd,IDC_ICONRES,CB_GETLBTEXTLEN,i3,0)+1);
							SendDlgItemMessage(hwnd,IDC_ICONRES,CB_GETLBTEXT,i3,(long)ProjectInfo.pWindowInfo[i2].IconResName);
						}
						DrawRadWindow(i,&ProjectInfo.pWindowInfo[i2]);
						return 1;
					}
					break;

				case IDC_WINDOWSTYLE:
					if(HIWORD(wParam)==CBN_SELCHANGE){
						i=GetWndNum(GetParent(GetParent(hwnd)));
						i2=GetWndInfoNum(MdiInfo[i].path);

						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,SELECT_WINDOW,ProjectInfo.pWindowInfo[i2].style);

						i3=SendDlgItemMessage(hwnd,IDC_WINDOWSTYLE,CB_GETCURSEL,0,0);
						ProjectInfo.pWindowInfo[i2].style&=0x3FFFFFFF;
						if(i3==1) ProjectInfo.pWindowInfo[i2].style|=WS_POPUP;
						else if(i3==2) ProjectInfo.pWindowInfo[i2].style|=WS_CHILD;
						RadProperty_Window_Window_StylingOrder(hwnd,&ProjectInfo.pWindowInfo[i2].style);
						DrawRadWindow(i,&ProjectInfo.pWindowInfo[i2]);
						return 1;
					}
					break;
				case IDC_BORDERSTYLE:
					if(HIWORD(wParam)==CBN_SELCHANGE){
						i=GetWndNum(GetParent(GetParent(hwnd)));
						i2=GetWndInfoNum(MdiInfo[i].path);

						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,SELECT_WINDOW,ProjectInfo.pWindowInfo[i2].style);

						i3=SendDlgItemMessage(hwnd,IDC_BORDERSTYLE,CB_GETCURSEL,0,0);
						ProjectInfo.pWindowInfo[i2].style&=~(WS_BORDER|WS_THICKFRAME);
						if(i3==1) ProjectInfo.pWindowInfo[i2].style|=WS_BORDER;
						else if(i3==2){
							ProjectInfo.pWindowInfo[i2].style|=WS_BORDER;
							ProjectInfo.pWindowInfo[i2].style|=WS_THICKFRAME;
						}
						RadProperty_Window_Border_StylingOrder(hwnd,&ProjectInfo.pWindowInfo[i2].style);
						DrawRadWindow(i,&ProjectInfo.pWindowInfo[i2]);
						return 1;
					}
					break;

				case IDC_STYLE_CAPTION:
					if(HIWORD(wParam)==BN_CLICKED){
						i=GetWndNum(GetParent(GetParent(hwnd)));
						i2=GetWndInfoNum(MdiInfo[i].path);

						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,SELECT_WINDOW,ProjectInfo.pWindowInfo[i2].style);

						if(SendDlgItemMessage(hwnd,IDC_STYLE_CAPTION,BM_GETCHECK,0,0))
							ProjectInfo.pWindowInfo[i2].style|=WS_CAPTION;
						else
							ProjectInfo.pWindowInfo[i2].style&=~WS_CAPTION;
						RadProperty_Window_Caption_StylingOrder(hwnd,&ProjectInfo.pWindowInfo[i2].style);
						DrawRadWindow(i,&ProjectInfo.pWindowInfo[i2]);
						return 1;
					}
					break;
				case IDC_STYLE_SYSMENU:
					if(HIWORD(wParam)==BN_CLICKED){
						i=GetWndNum(GetParent(GetParent(hwnd)));
						i2=GetWndInfoNum(MdiInfo[i].path);

						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,SELECT_WINDOW,ProjectInfo.pWindowInfo[i2].style);

						if(SendDlgItemMessage(hwnd,IDC_STYLE_SYSMENU,BM_GETCHECK,0,0))
							ProjectInfo.pWindowInfo[i2].style|=WS_SYSMENU;
						else
							ProjectInfo.pWindowInfo[i2].style&=~WS_SYSMENU;
						DrawRadWindow(i,&ProjectInfo.pWindowInfo[i2]);
						return 1;
					}
					break;
				case IDC_STYLE_MINIMIZEBOX:
					if(HIWORD(wParam)==BN_CLICKED){
						i=GetWndNum(GetParent(GetParent(hwnd)));
						i2=GetWndInfoNum(MdiInfo[i].path);

						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,SELECT_WINDOW,ProjectInfo.pWindowInfo[i2].style);

						if(SendDlgItemMessage(hwnd,IDC_STYLE_MINIMIZEBOX,BM_GETCHECK,0,0))
							ProjectInfo.pWindowInfo[i2].style|=WS_MINIMIZEBOX;
						else
							ProjectInfo.pWindowInfo[i2].style&=~WS_MINIMIZEBOX;
						DrawRadWindow(i,&ProjectInfo.pWindowInfo[i2]);
						return 1;
					}
					break;
				case IDC_STYLE_MAXIMIZEBOX:
					if(HIWORD(wParam)==BN_CLICKED){
						i=GetWndNum(GetParent(GetParent(hwnd)));
						i2=GetWndInfoNum(MdiInfo[i].path);

						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,SELECT_WINDOW,ProjectInfo.pWindowInfo[i2].style);

						if(SendDlgItemMessage(hwnd,IDC_STYLE_MAXIMIZEBOX,BM_GETCHECK,0,0))
							ProjectInfo.pWindowInfo[i2].style|=WS_MAXIMIZEBOX;
						else
							ProjectInfo.pWindowInfo[i2].style&=~WS_MAXIMIZEBOX;
						DrawRadWindow(i,&ProjectInfo.pWindowInfo[i2]);
						return 1;
					}
					break;
				case IDC_STYLE_MINIMIZE:
					if(HIWORD(wParam)==BN_CLICKED){
						i=GetWndNum(GetParent(GetParent(hwnd)));
						i2=GetWndInfoNum(MdiInfo[i].path);

						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,SELECT_WINDOW,ProjectInfo.pWindowInfo[i2].style);

						if(SendDlgItemMessage(hwnd,IDC_STYLE_MINIMIZE,BM_GETCHECK,0,0))
							ProjectInfo.pWindowInfo[i2].style|=WS_MINIMIZE;
						else
							ProjectInfo.pWindowInfo[i2].style&=~WS_MINIMIZE;
						DrawRadWindow(i,&ProjectInfo.pWindowInfo[i2]);
						return 1;
					}
					break;
				case IDC_STYLE_MAXIMIZE:
					if(HIWORD(wParam)==BN_CLICKED){
						i=GetWndNum(GetParent(GetParent(hwnd)));
						i2=GetWndInfoNum(MdiInfo[i].path);

						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,SELECT_WINDOW,ProjectInfo.pWindowInfo[i2].style);

						if(SendDlgItemMessage(hwnd,IDC_STYLE_MAXIMIZE,BM_GETCHECK,0,0))
							ProjectInfo.pWindowInfo[i2].style|=WS_MAXIMIZE;
						else
							ProjectInfo.pWindowInfo[i2].style&=~WS_MAXIMIZE;
						DrawRadWindow(i,&ProjectInfo.pWindowInfo[i2]);
						return 1;
					}
				case IDC_STYLE_HSCROLLBAR:
					if(HIWORD(wParam)==BN_CLICKED){
						i=GetWndNum(GetParent(GetParent(hwnd)));
						i2=GetWndInfoNum(MdiInfo[i].path);

						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,SELECT_WINDOW,ProjectInfo.pWindowInfo[i2].style);

						if(SendDlgItemMessage(hwnd,IDC_STYLE_HSCROLLBAR,BM_GETCHECK,0,0))
							ProjectInfo.pWindowInfo[i2].style|=WS_HSCROLL;
						else
							ProjectInfo.pWindowInfo[i2].style&=~WS_HSCROLL;
						DrawRadWindow(i,&ProjectInfo.pWindowInfo[i2]);
						return 1;
					}
				case IDC_STYLE_VSCROLLBAR:
					if(HIWORD(wParam)==BN_CLICKED){
						i=GetWndNum(GetParent(GetParent(hwnd)));
						i2=GetWndInfoNum(MdiInfo[i].path);

						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,SELECT_WINDOW,ProjectInfo.pWindowInfo[i2].style);

						if(SendDlgItemMessage(hwnd,IDC_STYLE_VSCROLLBAR,BM_GETCHECK,0,0))
							ProjectInfo.pWindowInfo[i2].style|=WS_VSCROLL;
						else
							ProjectInfo.pWindowInfo[i2].style&=~WS_VSCROLL;
						DrawRadWindow(i,&ProjectInfo.pWindowInfo[i2]);
						return 1;
					}
					break;
				case IDC_STYLE_DISABLED:
					if(HIWORD(wParam)==BN_CLICKED){
						i=GetWndNum(GetParent(GetParent(hwnd)));
						i2=GetWndInfoNum(MdiInfo[i].path);

						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,SELECT_WINDOW,ProjectInfo.pWindowInfo[i2].style);

						if(SendDlgItemMessage(hwnd,IDC_STYLE_DISABLED,BM_GETCHECK,0,0))
							ProjectInfo.pWindowInfo[i2].style|=WS_DISABLED;
						else
							ProjectInfo.pWindowInfo[i2].style&=~WS_DISABLED;
						DrawRadWindow(i,&ProjectInfo.pWindowInfo[i2]);
						return 1;
					}
					break;
				case IDC_STYLE_CLIPSIBLINGS:
					if(HIWORD(wParam)==BN_CLICKED){
						i=GetWndNum(GetParent(GetParent(hwnd)));
						i2=GetWndInfoNum(MdiInfo[i].path);

						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,SELECT_WINDOW,ProjectInfo.pWindowInfo[i2].style);

						if(SendDlgItemMessage(hwnd,IDC_STYLE_CLIPSIBLINGS,BM_GETCHECK,0,0))
							ProjectInfo.pWindowInfo[i2].style|=WS_CLIPSIBLINGS;
						else
							ProjectInfo.pWindowInfo[i2].style&=~WS_CLIPSIBLINGS;
						DrawRadWindow(i,&ProjectInfo.pWindowInfo[i2]);
						return 1;
					}
					break;
				case IDC_STYLE_CLIPCHILDREN:
					if(HIWORD(wParam)==BN_CLICKED){
						i=GetWndNum(GetParent(GetParent(hwnd)));
						i2=GetWndInfoNum(MdiInfo[i].path);

						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,SELECT_WINDOW,ProjectInfo.pWindowInfo[i2].style);

						if(SendDlgItemMessage(hwnd,IDC_STYLE_CLIPCHILDREN,BM_GETCHECK,0,0))
							ProjectInfo.pWindowInfo[i2].style|=WS_CLIPCHILDREN;
						else
							ProjectInfo.pWindowInfo[i2].style&=~WS_CLIPCHILDREN;
						DrawRadWindow(i,&ProjectInfo.pWindowInfo[i2]);
						return 1;
					}
					break;
				case IDC_STYLE_VISIBLE:
					if(HIWORD(wParam)==BN_CLICKED){
						i=GetWndNum(GetParent(GetParent(hwnd)));
						i2=GetWndInfoNum(MdiInfo[i].path);

						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,SELECT_WINDOW,ProjectInfo.pWindowInfo[i2].style);

						if(SendDlgItemMessage(hwnd,IDC_STYLE_VISIBLE,BM_GETCHECK,0,0))
							ProjectInfo.pWindowInfo[i2].style|=WS_VISIBLE;
						else
							ProjectInfo.pWindowInfo[i2].style&=~WS_VISIBLE;
						DrawRadWindow(i,&ProjectInfo.pWindowInfo[i2]);
						return 1;
					}
					break;

				case IDC_EXSTYLE:
					if(!DialogBox(hResInst,MAKEINTRESOURCE(IDD_RAD_PROP_WINDOW_EXSTYLE),hwnd,(DLGPROC)DlgRadProperty_Window_ExStyle)) return 1;
					i=GetWndNum(GetParent(GetParent(hwnd)));
					i2=GetWndInfoNum(MdiInfo[i].path);
					DrawRadWindow(i,&ProjectInfo.pWindowInfo[i2]);
					return 1;

				case IDC_DEFWINDOW:
				case IDC_MODALDLG:
				case IDC_MODELESSDLG:
					if(HIWORD(wParam)==BN_CLICKED){
						i=GetWndNum(GetParent(GetParent(hwnd)));
						i2=GetWndInfoNum(MdiInfo[i].path);

						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_TYPE,SELECT_WINDOW,ProjectInfo.pWindowInfo[i2].type);

						if(SendDlgItemMessage(hwnd,IDC_DEFWINDOW,BM_GETCHECK,0,0))
							ProjectInfo.pWindowInfo[i2].type=WNDTYPE_DEFAULT;
						else if(SendDlgItemMessage(hwnd,IDC_MODALDLG,BM_GETCHECK,0,0))
							ProjectInfo.pWindowInfo[i2].type=WNDTYPE_MODALDLG;
						else if(SendDlgItemMessage(hwnd,IDC_MODELESSDLG,BM_GETCHECK,0,0))
							ProjectInfo.pWindowInfo[i2].type=WNDTYPE_MODELESSDLG;
						return 1;
					}
					break;
			}
			break;
	}
	return 0;
}

BOOL CALLBACK DlgRadProperty_Item_RenameCaption(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam){
	extern HANDLE hHeap;
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	extern PROJECTINFO ProjectInfo;
	int i,i2,i3;
	char *temporary;
	POINTANDSIZE PointAndSize;

	switch(message){
		case WM_INITDIALOG:
			SetPosCenter(hwnd);
			i=GetWndNum(GetWindow(hClient,GW_CHILD));
			i2=GetWndInfoNum(MdiInfo[i].path);
			if(MdiInfo[i].MdiRadInfo->SelectingItem[0]==SELECT_WINDOW)
				SetDlgItemText(hwnd,IDC_CAPTION,ProjectInfo.pWindowInfo[i2].caption);
			else
				SetDlgItemText(hwnd,IDC_CAPTION,ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].caption);
			break;
		case WM_COMMAND:
			switch(LOWORD(wParam)){
				case IDOK:
					i=GetWndNum(GetWindow(hClient,GW_CHILD));
					i2=GetWndInfoNum(MdiInfo[i].path);

					i3=GetWindowTextLength(GetDlgItem(hwnd,IDC_CAPTION))+1;
					temporary=(char *)HeapAlloc(hHeap,0,i3);
					GetDlgItemText(hwnd,IDC_CAPTION,temporary,i3);
					if(MdiInfo[i].MdiRadInfo->SelectingItem[0]==SELECT_WINDOW){
						if(lstrcmp(temporary,ProjectInfo.pWindowInfo[i2].caption)==0){
							HeapDefaultFree(temporary);
							SendMessage(hwnd,WM_COMMAND,IDCANCEL,0);
							return 1;
						}

						//ύXXV
						Rad_NoticeChanging(i,RAD_UNDO_CAPTION,MdiInfo[i].MdiRadInfo->SelectingItem[0],(DWORD)ProjectInfo.pWindowInfo[i2].caption);

						HeapDefaultFree(ProjectInfo.pWindowInfo[i2].caption);
						ProjectInfo.pWindowInfo[i2].caption=temporary;
					}
					else{
						if(lstrcmp(temporary,ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].caption)==0){
							HeapDefaultFree(temporary);
							SendMessage(hwnd,WM_COMMAND,IDCANCEL,0);
							return 1;
						}

						//ύXXV
						Rad_NoticeChanging(i,RAD_UNDO_CAPTION,MdiInfo[i].MdiRadInfo->SelectingItem[0],(DWORD)ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].caption);

						HeapDefaultFree(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].caption);
						ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].caption=temporary;

						if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].Control==CT_STATIC){
							//X^eBbN eLXg
							//eLXg\ł悤ɃTCYg傷

							PointAndSize.pos=ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].pos;
							PointAndSize.size=ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].size;
							Rad_NoticeChanging(i,RAD_UNDO_POSITION,MdiInfo[i].MdiRadInfo->SelectingItem[0],(DWORD)&PointAndSize);

							HFONT hFont,hOldFont;
							hFont=CreateFontIndirect(&ProjectInfo.pWindowInfo[i2].LogFont);
							hOldFont=(HFONT)SelectObject(MdiInfo[i].MdiRadInfo->hMemDC,hFont);
							GetTextExtentPoint32(MdiInfo[i].MdiRadInfo->hMemDC,temporary,lstrlen(temporary),&PointAndSize.size);
							SelectObject(MdiInfo[i].MdiRadInfo->hMemDC,hOldFont);
							DeleteObject(hFont);

							//eLXg̏I[ɗ]T
							PointAndSize.size.cx+=5;

							if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].size.cx<PointAndSize.size.cx)
								ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].size.cx=PointAndSize.size.cx;
						}
						if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].Control==CT_CHECKBOX){
							//`FbN {bNX
							//eLXg\ł悤ɃTCYg傷

							PointAndSize.pos=ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].pos;
							PointAndSize.size=ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].size;
							Rad_NoticeChanging(i,RAD_UNDO_POSITION,MdiInfo[i].MdiRadInfo->SelectingItem[0],(DWORD)&PointAndSize);

							HFONT hFont,hOldFont;
							hFont=CreateFontIndirect(&ProjectInfo.pWindowInfo[i2].LogFont);
							hOldFont=(HFONT)SelectObject(MdiInfo[i].MdiRadInfo->hMemDC,hFont);
							GetTextExtentPoint32(MdiInfo[i].MdiRadInfo->hMemDC,temporary,lstrlen(temporary),&PointAndSize.size);
							SelectObject(MdiInfo[i].MdiRadInfo->hMemDC,hOldFont);
							DeleteObject(hFont);

							//eLXg̏I[ɗ]T
							PointAndSize.size.cx+=21;

							if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].size.cx<PointAndSize.size.cx)
								ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].size.cx=PointAndSize.size.cx;
						}
						if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].Control==CT_RADIOBUTTON){
							//WI {bNX
							//eLXg\ł悤ɃTCYg傷

							PointAndSize.pos=ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].pos;
							PointAndSize.size=ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].size;
							Rad_NoticeChanging(i,RAD_UNDO_POSITION,MdiInfo[i].MdiRadInfo->SelectingItem[0],(DWORD)&PointAndSize);

							HFONT hFont,hOldFont;
							hFont=CreateFontIndirect(&ProjectInfo.pWindowInfo[i2].LogFont);
							hOldFont=(HFONT)SelectObject(MdiInfo[i].MdiRadInfo->hMemDC,hFont);
							GetTextExtentPoint32(MdiInfo[i].MdiRadInfo->hMemDC,temporary,lstrlen(temporary),&PointAndSize.size);
							SelectObject(MdiInfo[i].MdiRadInfo->hMemDC,hOldFont);
							DeleteObject(hFont);

							//eLXg̏I[ɗ]T
							PointAndSize.size.cx+=20;

							if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].size.cx<PointAndSize.size.cx)
								ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].size.cx=PointAndSize.size.cx;
						}
					}
					DrawRadWindow(i,&ProjectInfo.pWindowInfo[i2]);
					EndDialog(hwnd,1);
					return 1;
				case IDCANCEL:
					EndDialog(hwnd,0);
					return 1;
			}
			break;
	}
	return 0;
}
BOOL CALLBACK DlgRadProperty_Item_RenameID(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam){
	extern HANDLE hHeap;
	extern HWND hClient,hOwner;
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	extern PROJECTINFO ProjectInfo;
	int i,i2,i3;
	char *temporary;

	switch(message){
		case WM_INITDIALOG:
			SetPosCenter(hwnd);
			i=GetWndNum(GetWindow(hClient,GW_CHILD));
			i2=GetWndInfoNum(MdiInfo[i].path);
			SetDlgItemText(hwnd,IDC_IDNAME,ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].IdName);
			break;
		case WM_COMMAND:
			switch(LOWORD(wParam)){
				case IDOK:
					i=GetWndNum(GetWindow(hClient,GW_CHILD));
					i2=GetWndInfoNum(MdiInfo[i].path);

					i3=GetWindowTextLength(GetDlgItem(hwnd,IDC_IDNAME))+1;
					if(i3==1){
						//MsgBox "ID͂ĉB"
						MessageBox(hOwner,STRING_ITEM_RENAME_MUST_ID,APPLICATION_NAME,MB_OK|MB_ICONEXCLAMATION);
						break;
					}
					temporary=(char *)HeapAlloc(hHeap,0,i3);
					GetDlgItemText(hwnd,IDC_IDNAME,temporary,i3);
					if(lstrcmp(temporary,ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].IdName)==0){
						HeapDefaultFree(temporary);
						SendMessage(hwnd,WM_COMMAND,IDCANCEL,0);
						return 1;
					}

					//MsgBox "ACeIDύXƁA\[XR[hID͎蓮ŕϊKv܂BύX܂H"
					if(IDCANCEL==MessageBox(hwnd,STRING_ITEM_RENAME_CHECK,APPLICATION_NAME,MB_OKCANCEL|MB_ICONEXCLAMATION)) return 1;

					//ύXXV
					Rad_NoticeChanging(i,RAD_UNDO_NAME,MdiInfo[i].MdiRadInfo->SelectingItem[0],(DWORD)ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].IdName);

					HeapDefaultFree(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].IdName);
					ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].IdName=temporary;

					EndDialog(hwnd,1);
					return 1;
				case IDCANCEL:
					EndDialog(hwnd,0);
					return 1;
			}
			break;
	}
	return 0;
}
BOOL DefaultItemStyles(HWND hwnd,int WndNum,int WndInfoNum,WPARAM wParam){
	extern HANDLE hHeap;
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	extern PROJECTINFO ProjectInfo;

	switch(LOWORD(wParam)){
		case IDC_RENAMEID:
			if(!DialogBox(hResInst,MAKEINTRESOURCE(IDD_RAD_PROP_ITEM_RENAMEID),hwnd,(DLGPROC)DlgRadProperty_Item_RenameID)) return 1;
			SetDlgItemText(hwnd,IDC_IDNAME,ProjectInfo.pWindowInfo[WndInfoNum].pChildInfo[MdiInfo[WndNum].MdiRadInfo->SelectingItem[0]].IdName);
			return 1;
		case IDC_RENAMECAPTION:
			if(!DialogBox(hResInst,MAKEINTRESOURCE(IDD_RAD_PROP_ITEM_RENAMECAPTION),hwnd,(DLGPROC)DlgRadProperty_Item_RenameCaption)) return 1;
			SetDlgItemText(hwnd,IDC_CAPTION,ProjectInfo.pWindowInfo[WndInfoNum].pChildInfo[MdiInfo[WndNum].MdiRadInfo->SelectingItem[0]].caption);
			return 1;
		case IDC_STYLE_DISABLED:
			if(HIWORD(wParam)==BN_CLICKED){
				//ύX
				Rad_NoticeChanging(WndNum,RAD_UNDO_STYLE,MdiInfo[WndNum].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[WndInfoNum].pChildInfo[MdiInfo[WndNum].MdiRadInfo->SelectingItem[0]].style);

				if(SendDlgItemMessage(hwnd,IDC_STYLE_DISABLED,BM_GETCHECK,0,0))
					ProjectInfo.pWindowInfo[WndInfoNum].pChildInfo[MdiInfo[WndNum].MdiRadInfo->SelectingItem[0]].style|=WS_DISABLED;
				else
					ProjectInfo.pWindowInfo[WndInfoNum].pChildInfo[MdiInfo[WndNum].MdiRadInfo->SelectingItem[0]].style&=~WS_DISABLED;
				DrawRadWindow(WndNum,&ProjectInfo.pWindowInfo[WndInfoNum]);
				return 1;
			}
			break;
		case IDC_STYLE_VISIBLE:
			if(HIWORD(wParam)==BN_CLICKED){
				//ύX
				Rad_NoticeChanging(WndNum,RAD_UNDO_STYLE,MdiInfo[WndNum].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[WndInfoNum].pChildInfo[MdiInfo[WndNum].MdiRadInfo->SelectingItem[0]].style);

				if(SendDlgItemMessage(hwnd,IDC_STYLE_VISIBLE,BM_GETCHECK,0,0))
					ProjectInfo.pWindowInfo[WndInfoNum].pChildInfo[MdiInfo[WndNum].MdiRadInfo->SelectingItem[0]].style|=WS_VISIBLE;
				else
					ProjectInfo.pWindowInfo[WndInfoNum].pChildInfo[MdiInfo[WndNum].MdiRadInfo->SelectingItem[0]].style&=~WS_VISIBLE;
				return 1;
			}
			break;
		case IDC_STYLE_GROUP:
			if(HIWORD(wParam)==BN_CLICKED){
				//ύX
				Rad_NoticeChanging(WndNum,RAD_UNDO_STYLE,MdiInfo[WndNum].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[WndInfoNum].pChildInfo[MdiInfo[WndNum].MdiRadInfo->SelectingItem[0]].style);

				if(SendDlgItemMessage(hwnd,IDC_STYLE_GROUP,BM_GETCHECK,0,0))
					ProjectInfo.pWindowInfo[WndInfoNum].pChildInfo[MdiInfo[WndNum].MdiRadInfo->SelectingItem[0]].style|=WS_GROUP;
				else
					ProjectInfo.pWindowInfo[WndInfoNum].pChildInfo[MdiInfo[WndNum].MdiRadInfo->SelectingItem[0]].style&=~WS_GROUP;
				return 1;
			}
			break;
		case IDC_STYLE_TABSTOP:
			if(HIWORD(wParam)==BN_CLICKED){
				//ύX
				Rad_NoticeChanging(WndNum,RAD_UNDO_STYLE,MdiInfo[WndNum].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[WndInfoNum].pChildInfo[MdiInfo[WndNum].MdiRadInfo->SelectingItem[0]].style);

				if(SendDlgItemMessage(hwnd,IDC_STYLE_TABSTOP,BM_GETCHECK,0,0))
					ProjectInfo.pWindowInfo[WndInfoNum].pChildInfo[MdiInfo[WndNum].MdiRadInfo->SelectingItem[0]].style|=WS_TABSTOP;
				else
					ProjectInfo.pWindowInfo[WndInfoNum].pChildInfo[MdiInfo[WndNum].MdiRadInfo->SelectingItem[0]].style&=~WS_TABSTOP;
				return 1;
			}
			break;
	}
	return 0;
}
BOOL CALLBACK DlgRadProperty_Item_ExStyle(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam){
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	extern PROJECTINFO ProjectInfo;
	int i,i2;

	switch(message){
		case WM_INITDIALOG:
			SetPosCenter(hwnd);
			i=GetWndNum(GetWindow(hClient,GW_CHILD));
			i2=GetWndInfoNum(MdiInfo[i].path);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].ExStyle&WS_EX_ACCEPTFILES) SendDlgItemMessage(hwnd,IDC_EXSTYLE_ACCEPTFILES,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].ExStyle&WS_EX_TRANSPARENT) SendDlgItemMessage(hwnd,IDC_EXSTYLE_TRANSPARENT,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].ExStyle&WS_EX_DLGMODALFRAME) SendDlgItemMessage(hwnd,IDC_EXSTYLE_DLGMODALFRAME,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].ExStyle&WS_EX_CLIENTEDGE) SendDlgItemMessage(hwnd,IDC_EXSTYLE_CLIENTEDGE,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].ExStyle&WS_EX_STATICEDGE) SendDlgItemMessage(hwnd,IDC_EXSTYLE_STATICEDGE,BM_SETCHECK,BST_CHECKED,0);
			break;
		case WM_COMMAND:
			switch(LOWORD(wParam)){
				case IDOK:
					i=GetWndNum(GetWindow(hClient,GW_CHILD));
					i2=GetWndInfoNum(MdiInfo[i].path);

					DWORD style;
					style=0;
					if(SendDlgItemMessage(hwnd,IDC_EXSTYLE_ACCEPTFILES,BM_GETCHECK,0,0))
						style|=WS_EX_ACCEPTFILES;
					if(SendDlgItemMessage(hwnd,IDC_EXSTYLE_TRANSPARENT,BM_GETCHECK,0,0))
						style|=WS_EX_TRANSPARENT;
					if(SendDlgItemMessage(hwnd,IDC_EXSTYLE_DLGMODALFRAME,BM_GETCHECK,0,0))
						style|=WS_EX_DLGMODALFRAME;
					if(SendDlgItemMessage(hwnd,IDC_EXSTYLE_CLIENTEDGE,BM_GETCHECK,0,0))
						style|=WS_EX_CLIENTEDGE;
					if(SendDlgItemMessage(hwnd,IDC_EXSTYLE_STATICEDGE,BM_GETCHECK,0,0))
						style|=WS_EX_STATICEDGE;

					if(style==ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].ExStyle){
						SendMessage(hwnd,WM_COMMAND,IDCANCEL,0);
						return 1;
					}

					//ύX
					Rad_NoticeChanging(i,RAD_UNDO_EXSTYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].ExStyle);

					ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].ExStyle=style;
					EndDialog(hwnd,1);
					return 1;
				case IDCANCEL:
					EndDialog(hwnd,0);
					return 1;
			}
			break;
	}
	return 0;
}


/////////////////////
// BUTTON vpeB

BOOL CALLBACK RadProperty_ButtonProc(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam){
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	extern PROJECTINFO ProjectInfo;
	int i,i2,i3;
	static BOOL bInitial;

	switch(message){
		case WM_INITDIALOG:
			bInitial=1;
			i=GetWndNum(GetParent(GetParent(hwnd)));
			i2=GetWndInfoNum(MdiInfo[i].path);

			SetDlgItemText(hwnd,IDC_IDNAME,ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].IdName);
			SetDlgItemText(hwnd,IDC_CAPTION,ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].caption);


			////////////
			//X^C

			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&WS_DISABLED) SendDlgItemMessage(hwnd,IDC_STYLE_DISABLED,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&WS_VISIBLE) SendDlgItemMessage(hwnd,IDC_STYLE_VISIBLE,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&WS_GROUP) SendDlgItemMessage(hwnd,IDC_STYLE_GROUP,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&WS_TABSTOP) SendDlgItemMessage(hwnd,IDC_STYLE_TABSTOP,BM_SETCHECK,BST_CHECKED,0);

			if((ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&BS_OWNERDRAW)==BS_OWNERDRAW) SendDlgItemMessage(hwnd,IDC_BS_OWNERDRAW,BM_SETCHECK,BST_CHECKED,0);
			else if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&BS_DEFPUSHBUTTON) SendDlgItemMessage(hwnd,IDC_BS_DEFPUSHBUTTON,BM_SETCHECK,BST_CHECKED,0);

			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&BS_ICON) SendDlgItemMessage(hwnd,IDC_BS_ICON,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&BS_BITMAP) SendDlgItemMessage(hwnd,IDC_BS_BITMAP,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&BS_MULTILINE) SendDlgItemMessage(hwnd,IDC_BS_MULTILINE,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&BS_NOTIFY) SendDlgItemMessage(hwnd,IDC_BS_NOTIFY,BM_SETCHECK,BST_CHECKED,0);


			//////////////////
			// ̔zu
			//////////////////

			//"ftHg"
			SendDlgItemMessage(hwnd,IDC_BS_HPOS,CB_ADDSTRING,0,(long)STRING_DEFAULT);
			//"["
			SendDlgItemMessage(hwnd,IDC_BS_HPOS,CB_ADDSTRING,0,(long)STRING_LEFT);
			//"E["
			SendDlgItemMessage(hwnd,IDC_BS_HPOS,CB_ADDSTRING,0,(long)STRING_RIGHT);
			//""
			SendDlgItemMessage(hwnd,IDC_BS_HPOS,CB_ADDSTRING,0,(long)STRING_CENTER);

			//rbglBS_CENTERŏɔr
			if((ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&BS_CENTER)==BS_CENTER) SendDlgItemMessage(hwnd,IDC_BS_HPOS,CB_SETCURSEL,3,0);
			else if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&BS_LEFT) SendDlgItemMessage(hwnd,IDC_BS_HPOS,CB_SETCURSEL,1,0);
			else if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&BS_RIGHT) SendDlgItemMessage(hwnd,IDC_BS_HPOS,CB_SETCURSEL,2,0);
			else SendDlgItemMessage(hwnd,IDC_BS_HPOS,CB_SETCURSEL,0,0);


			//////////////////
			// ̔zu
			//////////////////

			//"ftHg"
			SendDlgItemMessage(hwnd,IDC_BS_VPOS,CB_ADDSTRING,0,(long)STRING_DEFAULT);
			//"["
			SendDlgItemMessage(hwnd,IDC_BS_VPOS,CB_ADDSTRING,0,(long)STRING_TOP);
			//"["
			SendDlgItemMessage(hwnd,IDC_BS_VPOS,CB_ADDSTRING,0,(long)STRING_BOTTOM);
			//""
			SendDlgItemMessage(hwnd,IDC_BS_VPOS,CB_ADDSTRING,0,(long)STRING_CENTER);

			//rbglBS_VCENTERŏɔr
			if((ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&BS_VCENTER)==BS_VCENTER) SendDlgItemMessage(hwnd,IDC_BS_VPOS,CB_SETCURSEL,3,0);
			else if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&BS_TOP) SendDlgItemMessage(hwnd,IDC_BS_VPOS,CB_SETCURSEL,1,0);
			else if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&BS_BOTTOM) SendDlgItemMessage(hwnd,IDC_BS_VPOS,CB_SETCURSEL,2,0);
			else SendDlgItemMessage(hwnd,IDC_BS_VPOS,CB_SETCURSEL,0,0);


			bInitial=0;
			break;
		case WM_COMMAND:

			i=GetWndNum(GetParent(GetParent(hwnd)));
			if(i==-1) return 1;
			i2=GetWndInfoNum(MdiInfo[i].path);

			//ʃX^C
			if(bInitial==0){
				if(DefaultItemStyles(hwnd,i,i2,wParam)) return 1;
			}

			switch(LOWORD(wParam)){
				case IDC_BS_DEFPUSHBUTTON:
					if(HIWORD(wParam)==BN_CLICKED){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						if(SendDlgItemMessage(hwnd,IDC_BS_DEFPUSHBUTTON,BM_GETCHECK,0,0)){
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~BS_OWNERDRAW;
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=BS_DEFPUSHBUTTON;
							SendDlgItemMessage(hwnd,IDC_BS_OWNERDRAW,BM_SETCHECK,BST_UNCHECKED,0);
						}
						else
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~BS_DEFPUSHBUTTON;
						DrawRadWindow(i,&ProjectInfo.pWindowInfo[i2]);
						return 1;
					}
					break;
				case IDC_BS_OWNERDRAW:
					if(HIWORD(wParam)==BN_CLICKED){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						if(SendDlgItemMessage(hwnd,IDC_BS_OWNERDRAW,BM_GETCHECK,0,0)){
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~BS_DEFPUSHBUTTON;
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=BS_OWNERDRAW;
							SendDlgItemMessage(hwnd,IDC_BS_DEFPUSHBUTTON,BM_SETCHECK,BST_UNCHECKED,0);
						}
						else
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~BS_OWNERDRAW;
						DrawRadWindow(i,&ProjectInfo.pWindowInfo[i2]);
						return 1;
					}
					break;
				case IDC_BS_ICON:
					if(HIWORD(wParam)==BN_CLICKED){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						if(SendDlgItemMessage(hwnd,IDC_BS_ICON,BM_GETCHECK,0,0)){
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=BS_ICON;
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~BS_BITMAP;
							SendDlgItemMessage(hwnd,IDC_BS_BITMAP,BM_SETCHECK,BST_UNCHECKED,0);
						}
						else
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~BS_ICON;
						DrawRadWindow(i,&ProjectInfo.pWindowInfo[i2]);
						return 1;
					}
					break;
				case IDC_BS_BITMAP:
					if(HIWORD(wParam)==BN_CLICKED){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						if(SendDlgItemMessage(hwnd,IDC_BS_BITMAP,BM_GETCHECK,0,0)){
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=BS_BITMAP;
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~BS_ICON;
							SendDlgItemMessage(hwnd,IDC_BS_ICON,BM_SETCHECK,BST_UNCHECKED,0);
						}
						else
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~BS_BITMAP;
						DrawRadWindow(i,&ProjectInfo.pWindowInfo[i2]);
						return 1;
					}
					break;
				case IDC_BS_MULTILINE:
					if(HIWORD(wParam)==BN_CLICKED){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						if(SendDlgItemMessage(hwnd,IDC_BS_MULTILINE,BM_GETCHECK,0,0))
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=BS_MULTILINE;
						else
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~BS_MULTILINE;
						DrawRadWindow(i,&ProjectInfo.pWindowInfo[i2]);
						return 1;
					}
					break;
				case IDC_BS_NOTIFY:
					if(HIWORD(wParam)==BN_CLICKED){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						if(SendDlgItemMessage(hwnd,IDC_BS_NOTIFY,BM_GETCHECK,0,0))
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=BS_NOTIFY;
						else
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~BS_NOTIFY;
						return 1;
					}
					break;

				case IDC_BS_HPOS:
					if(HIWORD(wParam)==CBN_SELCHANGE){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						i3=SendDlgItemMessage(hwnd,IDC_BS_HPOS,CB_GETCURSEL,0,0);
						ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~(BS_LEFT|BS_RIGHT|BS_CENTER);
						if(i3==1) ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=BS_LEFT;
						else if(i3==2) ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=BS_RIGHT;
						else if(i3==3) ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=BS_CENTER;
						DrawRadWindow(i,&ProjectInfo.pWindowInfo[i2]);
						return 1;
					}
					break;
				case IDC_BS_VPOS:
					if(HIWORD(wParam)==CBN_SELCHANGE){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						i3=SendDlgItemMessage(hwnd,IDC_BS_VPOS,CB_GETCURSEL,0,0);
						ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~(BS_TOP|BS_BOTTOM|BS_VCENTER);
						if(i3==1) ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=BS_TOP;
						else if(i3==2) ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=BS_BOTTOM;
						else if(i3==3) ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=BS_VCENTER;
						DrawRadWindow(i,&ProjectInfo.pWindowInfo[i2]);
						return 1;
					}
					break;

				case IDC_EXSTYLE:
					if(!DialogBox(hResInst,MAKEINTRESOURCE(IDD_RAD_PROP_ITEM_EXSTYLE),hwnd,(DLGPROC)DlgRadProperty_Item_ExStyle)) return 1;
					DrawRadWindow(i,&ProjectInfo.pWindowInfo[i2]);
					return 1;
			}
			break;
	}
	return 0;
}


////////////////////////
// CHECKBOX vpeB
BOOL CALLBACK RadProperty_CheckBoxProc(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam){
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	extern PROJECTINFO ProjectInfo;
	int i,i2,i3;
	static BOOL bInitial;

	switch(message){
		case WM_INITDIALOG:
			bInitial=1;
			i=GetWndNum(GetParent(GetParent(hwnd)));
			i2=GetWndInfoNum(MdiInfo[i].path);

			SetDlgItemText(hwnd,IDC_IDNAME,ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].IdName);
			SetDlgItemText(hwnd,IDC_CAPTION,ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].caption);


			////////////
			//X^C

			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&WS_DISABLED) SendDlgItemMessage(hwnd,IDC_STYLE_DISABLED,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&WS_VISIBLE) SendDlgItemMessage(hwnd,IDC_STYLE_VISIBLE,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&WS_GROUP) SendDlgItemMessage(hwnd,IDC_STYLE_GROUP,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&WS_TABSTOP) SendDlgItemMessage(hwnd,IDC_STYLE_TABSTOP,BM_SETCHECK,BST_CHECKED,0);

			if((ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&BS_AUTOCHECKBOX)==BS_AUTOCHECKBOX) SendDlgItemMessage(hwnd,IDC_BS_AUTO,BM_SETCHECK,BST_CHECKED,0);
			if((ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&BS_AUTO3STATE)==BS_AUTO3STATE){
				SendDlgItemMessage(hwnd,IDC_BS_AUTO,BM_SETCHECK,BST_CHECKED,0);
				SendDlgItemMessage(hwnd,IDC_BS_3STATE,BM_SETCHECK,BST_CHECKED,0);
			}
			if((ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&BS_3STATE)==BS_3STATE) SendDlgItemMessage(hwnd,IDC_BS_3STATE,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&BS_PUSHLIKE) SendDlgItemMessage(hwnd,IDC_BS_PUSHLIKE,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&BS_LEFTTEXT) SendDlgItemMessage(hwnd,IDC_BS_LEFTTEXT,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&BS_ICON) SendDlgItemMessage(hwnd,IDC_BS_ICON,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&BS_BITMAP) SendDlgItemMessage(hwnd,IDC_BS_BITMAP,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&BS_MULTILINE) SendDlgItemMessage(hwnd,IDC_BS_MULTILINE,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&BS_NOTIFY) SendDlgItemMessage(hwnd,IDC_BS_NOTIFY,BM_SETCHECK,BST_CHECKED,0);


			//////////////////
			// ̔zu
			//////////////////

			//"ftHg"
			SendDlgItemMessage(hwnd,IDC_BS_HPOS,CB_ADDSTRING,0,(long)STRING_DEFAULT);
			//"["
			SendDlgItemMessage(hwnd,IDC_BS_HPOS,CB_ADDSTRING,0,(long)STRING_LEFT);
			//"E["
			SendDlgItemMessage(hwnd,IDC_BS_HPOS,CB_ADDSTRING,0,(long)STRING_RIGHT);
			//""
			SendDlgItemMessage(hwnd,IDC_BS_HPOS,CB_ADDSTRING,0,(long)STRING_CENTER);

			//rbglBS_CENTERŏɔr
			if((ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&BS_CENTER)==BS_CENTER) SendDlgItemMessage(hwnd,IDC_BS_HPOS,CB_SETCURSEL,3,0);
			else if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&BS_LEFT) SendDlgItemMessage(hwnd,IDC_BS_HPOS,CB_SETCURSEL,1,0);
			else if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&BS_RIGHT) SendDlgItemMessage(hwnd,IDC_BS_HPOS,CB_SETCURSEL,2,0);
			else SendDlgItemMessage(hwnd,IDC_BS_HPOS,CB_SETCURSEL,0,0);


			//////////////////
			// ̔zu
			//////////////////

			//"ftHg"
			SendDlgItemMessage(hwnd,IDC_BS_VPOS,CB_ADDSTRING,0,(long)STRING_DEFAULT);
			//"["
			SendDlgItemMessage(hwnd,IDC_BS_VPOS,CB_ADDSTRING,0,(long)STRING_TOP);
			//"["
			SendDlgItemMessage(hwnd,IDC_BS_VPOS,CB_ADDSTRING,0,(long)STRING_BOTTOM);
			//""
			SendDlgItemMessage(hwnd,IDC_BS_VPOS,CB_ADDSTRING,0,(long)STRING_CENTER);

			//rbglBS_VCENTERŏɔr
			if((ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&BS_VCENTER)==BS_VCENTER) SendDlgItemMessage(hwnd,IDC_BS_VPOS,CB_SETCURSEL,3,0);
			else if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&BS_TOP) SendDlgItemMessage(hwnd,IDC_BS_VPOS,CB_SETCURSEL,1,0);
			else if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&BS_BOTTOM) SendDlgItemMessage(hwnd,IDC_BS_VPOS,CB_SETCURSEL,2,0);
			else SendDlgItemMessage(hwnd,IDC_BS_VPOS,CB_SETCURSEL,0,0);


			bInitial=0;
			break;
		case WM_COMMAND:

			i=GetWndNum(GetParent(GetParent(hwnd)));
			if(i==-1) return 1;
			i2=GetWndInfoNum(MdiInfo[i].path);

			//ʃX^C
			if(bInitial==0){
				if(DefaultItemStyles(hwnd,i,i2,wParam)) return 1;
			}

			switch(LOWORD(wParam)){
				case IDC_BS_AUTO:
					if(HIWORD(wParam)==BN_CLICKED){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						if(SendDlgItemMessage(hwnd,IDC_BS_AUTO,BM_GETCHECK,0,0)){
							if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&0x04){
								//3state
								ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=0xFFFFFFF0;
								ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=BS_AUTO3STATE;
							}
							else{
								//2state
								ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=0xFFFFFFF0;
								ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=BS_AUTOCHECKBOX;
							}
						}
						else{
							if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&0x04){
								//3state
								ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=0xFFFFFFF0;
								ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=BS_3STATE;
							}
							else{
								//2state
								ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=0xFFFFFFF0;
								ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=BS_CHECKBOX;
							}
						}
						return 1;
					}
					break;
				case IDC_BS_3STATE:
					if(HIWORD(wParam)==BN_CLICKED){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						if(SendDlgItemMessage(hwnd,IDC_BS_3STATE,BM_GETCHECK,0,0)){
							if((ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&0x0F)==BS_CHECKBOX){
								ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=0xFFFFFFF0;
								ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=BS_3STATE;
							}
							else if((ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&0x0F)==BS_AUTOCHECKBOX){
								//`FbN
								ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=0xFFFFFFF0;
								ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=BS_AUTO3STATE;
							}
						}
						else{
							if((ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&0x0F)==BS_3STATE){
								ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=0xFFFFFFF0;
								ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=BS_CHECKBOX;
							}
							else if((ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&0x0F)==BS_AUTO3STATE){
								//`FbN
								ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=0xFFFFFFF0;
								ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=BS_AUTOCHECKBOX;
							}
						}
						return 1;
					}
					break;
				case IDC_BS_PUSHLIKE:
					if(HIWORD(wParam)==BN_CLICKED){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						if(SendDlgItemMessage(hwnd,IDC_BS_PUSHLIKE,BM_GETCHECK,0,0))
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=BS_PUSHLIKE;
						else
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~BS_PUSHLIKE;
						DrawRadWindow(i,&ProjectInfo.pWindowInfo[i2]);
						return 1;
					}
					break;
				case IDC_BS_LEFTTEXT:
					if(HIWORD(wParam)==BN_CLICKED){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						if(SendDlgItemMessage(hwnd,IDC_BS_LEFTTEXT,BM_GETCHECK,0,0))
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=BS_LEFTTEXT;
						else
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~BS_LEFTTEXT;
						DrawRadWindow(i,&ProjectInfo.pWindowInfo[i2]);
						return 1;
					}
					break;
				case IDC_BS_ICON:
					if(HIWORD(wParam)==BN_CLICKED){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						if(SendDlgItemMessage(hwnd,IDC_BS_ICON,BM_GETCHECK,0,0)){
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=BS_ICON;
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~BS_BITMAP;
							SendDlgItemMessage(hwnd,IDC_BS_BITMAP,BM_SETCHECK,BST_UNCHECKED,0);
						}
						else
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~BS_ICON;
						DrawRadWindow(i,&ProjectInfo.pWindowInfo[i2]);
						return 1;
					}
					break;
				case IDC_BS_BITMAP:
					if(HIWORD(wParam)==BN_CLICKED){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						if(SendDlgItemMessage(hwnd,IDC_BS_BITMAP,BM_GETCHECK,0,0)){
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=BS_BITMAP;
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~BS_ICON;
							SendDlgItemMessage(hwnd,IDC_BS_ICON,BM_SETCHECK,BST_UNCHECKED,0);
						}
						else
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~BS_BITMAP;
						DrawRadWindow(i,&ProjectInfo.pWindowInfo[i2]);
						return 1;
					}
					break;
				case IDC_BS_MULTILINE:
					if(HIWORD(wParam)==BN_CLICKED){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						if(SendDlgItemMessage(hwnd,IDC_BS_MULTILINE,BM_GETCHECK,0,0))
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=BS_MULTILINE;
						else
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~BS_MULTILINE;
						DrawRadWindow(i,&ProjectInfo.pWindowInfo[i2]);
						return 1;
					}
					break;
				case IDC_BS_NOTIFY:
					if(HIWORD(wParam)==BN_CLICKED){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						if(SendDlgItemMessage(hwnd,IDC_BS_NOTIFY,BM_GETCHECK,0,0))
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=BS_NOTIFY;
						else
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~BS_NOTIFY;
						return 1;
					}
					break;

				case IDC_BS_HPOS:
					if(HIWORD(wParam)==CBN_SELCHANGE){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						i3=SendDlgItemMessage(hwnd,IDC_BS_HPOS,CB_GETCURSEL,0,0);
						ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~(BS_LEFT|BS_RIGHT|BS_CENTER);
						if(i3==1) ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=BS_LEFT;
						else if(i3==2) ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=BS_RIGHT;
						else if(i3==3) ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=BS_CENTER;
						DrawRadWindow(i,&ProjectInfo.pWindowInfo[i2]);
						return 1;
					}
					break;
				case IDC_BS_VPOS:
					if(HIWORD(wParam)==CBN_SELCHANGE){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						i3=SendDlgItemMessage(hwnd,IDC_BS_VPOS,CB_GETCURSEL,0,0);
						ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~(BS_TOP|BS_BOTTOM|BS_VCENTER);
						if(i3==1) ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=BS_TOP;
						else if(i3==2) ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=BS_BOTTOM;
						else if(i3==3) ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=BS_VCENTER;
						DrawRadWindow(i,&ProjectInfo.pWindowInfo[i2]);
						return 1;
					}
					break;

				case IDC_EXSTYLE:
					if(!DialogBox(hResInst,MAKEINTRESOURCE(IDD_RAD_PROP_ITEM_EXSTYLE),hwnd,(DLGPROC)DlgRadProperty_Item_ExStyle)) return 1;
					DrawRadWindow(i,&ProjectInfo.pWindowInfo[i2]);
					return 1;
			}
	}
	return 0;
}


///////////////////////
// COMBOBOX vpeB

void RadProperty_ComboBox_StylingOrder(HWND hwnd,DWORD *style){
	if(!(*style&(CBS_OWNERDRAWFIXED|CBS_OWNERDRAWVARIABLE))){
		*style&=~(CBS_HASSTRINGS);
		SendDlgItemMessage(hwnd,IDC_CBS_HASSTRINGS,BM_SETCHECK,BST_UNCHECKED,0);
		EnableWindow(GetDlgItem(hwnd,IDC_CBS_HASSTRINGS),0);
	}
	else EnableWindow(GetDlgItem(hwnd,IDC_CBS_HASSTRINGS),1);
}
BOOL CALLBACK RadProperty_ComboBoxProc(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam){
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	extern PROJECTINFO ProjectInfo;
	int i,i2,i3;
	static BOOL bInitial;

	switch(message){
		case WM_INITDIALOG:
			bInitial=1;
			i=GetWndNum(GetParent(GetParent(hwnd)));
			i2=GetWndInfoNum(MdiInfo[i].path);

			SetDlgItemText(hwnd,IDC_IDNAME,ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].IdName);


			/////////////////////////////////
			// X^C
			////////////

			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&WS_DISABLED) SendDlgItemMessage(hwnd,IDC_STYLE_DISABLED,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&WS_VISIBLE) SendDlgItemMessage(hwnd,IDC_STYLE_VISIBLE,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&WS_GROUP) SendDlgItemMessage(hwnd,IDC_STYLE_GROUP,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&WS_TABSTOP) SendDlgItemMessage(hwnd,IDC_STYLE_TABSTOP,BM_SETCHECK,BST_CHECKED,0);

			////////
			// I
			////////

			//"ftHg"
			SendDlgItemMessage(hwnd,IDC_CBS_TYPE,CB_ADDSTRING,0,(long)STRING_DEFAULT);
			//"hbv _E"
			SendDlgItemMessage(hwnd,IDC_CBS_TYPE,CB_ADDSTRING,0,(long)STRING_COMBOBOXPROP_STYLE_DROPDOWN);
			//"hbv _E Xg"
			SendDlgItemMessage(hwnd,IDC_CBS_TYPE,CB_ADDSTRING,0,(long)STRING_COMBOBOXPROP_STYLE_DROPDOWNLIST);

			//rbglCBS_DROPDOWNLISTŏɔr
			if((ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&CBS_DROPDOWNLIST)==CBS_DROPDOWNLIST) SendDlgItemMessage(hwnd,IDC_CBS_TYPE,CB_SETCURSEL,2,0);
			else if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&CBS_SIMPLE) SendDlgItemMessage(hwnd,IDC_CBS_TYPE,CB_SETCURSEL,0,0);
			else if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&CBS_DROPDOWN) SendDlgItemMessage(hwnd,IDC_CBS_TYPE,CB_SETCURSEL,1,0);


			////////////////
			// I[i[`
			////////////////

			//"Ȃ"
			SendDlgItemMessage(hwnd,IDC_CBS_OWNERDRAW,CB_ADDSTRING,0,(long)STRING_NONE_);
			//"Œ"
			SendDlgItemMessage(hwnd,IDC_CBS_OWNERDRAW,CB_ADDSTRING,0,(long)STRING_OWNERDRAW_FIXED);
			//""
			SendDlgItemMessage(hwnd,IDC_CBS_OWNERDRAW,CB_ADDSTRING,0,(long)STRING_OWNERDRAW_VARIABLE);

			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&CBS_OWNERDRAWFIXED) SendDlgItemMessage(hwnd,IDC_CBS_OWNERDRAW,CB_SETCURSEL,1,0);
			else if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&CBS_OWNERDRAWVARIABLE) SendDlgItemMessage(hwnd,IDC_CBS_OWNERDRAW,CB_SETCURSEL,2,0);
			else SendDlgItemMessage(hwnd,IDC_CBS_OWNERDRAW,CB_SETCURSEL,0,0);

			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&CBS_HASSTRINGS) SendDlgItemMessage(hwnd,IDC_CBS_HASSTRINGS,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&CBS_SORT) SendDlgItemMessage(hwnd,IDC_CBS_SORT,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&CBS_NOINTEGRALHEIGHT) SendDlgItemMessage(hwnd,IDC_CBS_NOINTEGRALHEIGHT,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&CBS_OEMCONVERT) SendDlgItemMessage(hwnd,IDC_CBS_OEMCONVERT,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&WS_VSCROLL) SendDlgItemMessage(hwnd,IDC_STYLE_VSCROLL,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&CBS_AUTOHSCROLL) SendDlgItemMessage(hwnd,IDC_CBS_AUTOHSCROLL,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&CBS_DISABLENOSCROLL) SendDlgItemMessage(hwnd,IDC_CBS_DISABLENOSCROLL,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&CBS_UPPERCASE) SendDlgItemMessage(hwnd,IDC_CBS_UPPERCASE,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&CBS_LOWERCASE) SendDlgItemMessage(hwnd,IDC_CBS_LOWERCASE,BM_SETCHECK,BST_CHECKED,0);

			RadProperty_ComboBox_StylingOrder(hwnd,&ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);


			bInitial=0;
			break;
		case WM_COMMAND:

			i=GetWndNum(GetParent(GetParent(hwnd)));
			if(i==-1) return 1;
			i2=GetWndInfoNum(MdiInfo[i].path);

			//ʃX^C
			if(bInitial==0){
				if(DefaultItemStyles(hwnd,i,i2,wParam)) return 1;
			}

			switch(LOWORD(wParam)){
				case IDC_CBS_TYPE:
					if(HIWORD(wParam)==CBN_SELCHANGE){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						i3=SendDlgItemMessage(hwnd,IDC_CBS_TYPE,CB_GETCURSEL,0,0);
						//CBS_DROPDOWNLIST=CBS_SIMPLE | CBS_DROPDOWN
						ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~(CBS_DROPDOWNLIST);
						if(i3==0) ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=CBS_SIMPLE;
						else if(i3==1) ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=CBS_DROPDOWN;
						else if(i3==2) ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=CBS_DROPDOWNLIST;

						DrawRadWindow(i,&ProjectInfo.pWindowInfo[i2]);
						return 1;
					}
					break;
				case IDC_CBS_OWNERDRAW:
					if(HIWORD(wParam)==CBN_SELCHANGE){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						i3=SendDlgItemMessage(hwnd,IDC_CBS_OWNERDRAW,CB_GETCURSEL,0,0);
						ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~(CBS_OWNERDRAWFIXED|CBS_OWNERDRAWVARIABLE);
						if(i3==1) ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=CBS_OWNERDRAWFIXED;
						else if(i3==2) ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=CBS_OWNERDRAWVARIABLE;

						RadProperty_ComboBox_StylingOrder(hwnd,&ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);
						return 1;
					}
					break;

				case IDC_CBS_HASSTRINGS:
					if(HIWORD(wParam)==BN_CLICKED){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						if(SendDlgItemMessage(hwnd,IDC_CBS_HASSTRINGS,BM_GETCHECK,0,0))
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=CBS_HASSTRINGS;
						else
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~CBS_HASSTRINGS;
						return 1;
					}
					break;
				case IDC_CBS_SORT:
					if(HIWORD(wParam)==BN_CLICKED){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						if(SendDlgItemMessage(hwnd,IDC_CBS_SORT,BM_GETCHECK,0,0))
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=CBS_SORT;
						else
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~CBS_SORT;
						return 1;
					}
					break;
				case IDC_CBS_NOINTEGRALHEIGHT:
					if(HIWORD(wParam)==BN_CLICKED){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						if(SendDlgItemMessage(hwnd,IDC_CBS_NOINTEGRALHEIGHT,BM_GETCHECK,0,0))
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=CBS_NOINTEGRALHEIGHT;
						else
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~CBS_NOINTEGRALHEIGHT;
						return 1;
					}
					break;
				case IDC_CBS_OEMCONVERT:
					if(HIWORD(wParam)==BN_CLICKED){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						if(SendDlgItemMessage(hwnd,IDC_CBS_OEMCONVERT,BM_GETCHECK,0,0))
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=CBS_OEMCONVERT;
						else
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~CBS_OEMCONVERT;
						return 1;
					}
					break;
				case IDC_STYLE_VSCROLL:
					if(HIWORD(wParam)==BN_CLICKED){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						if(SendDlgItemMessage(hwnd,IDC_STYLE_VSCROLL,BM_GETCHECK,0,0))
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=WS_VSCROLL;
						else
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~WS_VSCROLL;
						DrawRadWindow(i,&ProjectInfo.pWindowInfo[i2]);
						return 1;
					}
					break;
				case IDC_CBS_AUTOHSCROLL:
					if(HIWORD(wParam)==BN_CLICKED){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						if(SendDlgItemMessage(hwnd,IDC_CBS_AUTOHSCROLL,BM_GETCHECK,0,0))
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=CBS_AUTOHSCROLL;
						else
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~CBS_AUTOHSCROLL;
						return 1;
					}
					break;
				case IDC_CBS_DISABLENOSCROLL:
					if(HIWORD(wParam)==BN_CLICKED){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						if(SendDlgItemMessage(hwnd,IDC_CBS_DISABLENOSCROLL,BM_GETCHECK,0,0))
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=CBS_DISABLENOSCROLL;
						else
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~CBS_DISABLENOSCROLL;
						DrawRadWindow(i,&ProjectInfo.pWindowInfo[i2]);
						return 1;
					}
					break;
				case IDC_CBS_UPPERCASE:
					if(HIWORD(wParam)==BN_CLICKED){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						if(SendDlgItemMessage(hwnd,IDC_CBS_UPPERCASE,BM_GETCHECK,0,0))
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=CBS_UPPERCASE;
						else
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~CBS_UPPERCASE;
						return 1;
					}
					break;
				case IDC_CBS_LOWERCASE:
					if(HIWORD(wParam)==BN_CLICKED){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						if(SendDlgItemMessage(hwnd,IDC_CBS_LOWERCASE,BM_GETCHECK,0,0))
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=CBS_LOWERCASE;
						else
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~CBS_LOWERCASE;
						return 1;
					}
					break;

				case IDC_EXSTYLE:
					if(!DialogBox(hResInst,MAKEINTRESOURCE(IDD_RAD_PROP_ITEM_EXSTYLE),hwnd,(DLGPROC)DlgRadProperty_Item_ExStyle)) return 1;
					DrawRadWindow(i,&ProjectInfo.pWindowInfo[i2]);
					return 1;
			}
			break;
	}
	return 0;
}


/////////////////////
// EDIT vpeB

void RadProperty_Edit_StylingOrder(HWND hwnd,DWORD *style){
	if(*style&ES_MULTILINE){
		EnableWindow(GetDlgItem(hwnd,IDC_STYLE_HSCROLL),1);
		EnableWindow(GetDlgItem(hwnd,IDC_STYLE_VSCROLL),1);
		EnableWindow(GetDlgItem(hwnd,IDC_ES_AUTOVSCROLL),1);

		*style&=~(ES_PASSWORD);
		SendDlgItemMessage(hwnd,IDC_ES_PASSWORD,BM_SETCHECK,BST_UNCHECKED,0);
		EnableWindow(GetDlgItem(hwnd,IDC_ES_PASSWORD),0);
	}
	else{
		EnableWindow(GetDlgItem(hwnd,IDC_ES_PASSWORD),1);

		*style&=~(WS_HSCROLL|WS_VSCROLL|ES_AUTOVSCROLL);
		SendDlgItemMessage(hwnd,IDC_STYLE_HSCROLL,BM_SETCHECK,BST_UNCHECKED,0);
		SendDlgItemMessage(hwnd,IDC_STYLE_VSCROLL,BM_SETCHECK,BST_UNCHECKED,0);
		SendDlgItemMessage(hwnd,IDC_ES_AUTOVSCROLL,BM_SETCHECK,BST_UNCHECKED,0);
		EnableWindow(GetDlgItem(hwnd,IDC_STYLE_HSCROLL),0);
		EnableWindow(GetDlgItem(hwnd,IDC_STYLE_VSCROLL),0);
		EnableWindow(GetDlgItem(hwnd,IDC_ES_AUTOVSCROLL),0);
	}
}
BOOL CALLBACK RadProperty_EditProc(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam){
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	extern PROJECTINFO ProjectInfo;
	int i,i2,i3;
	static BOOL bInitial;

	switch(message){
		case WM_INITDIALOG:
			bInitial=1;
			i=GetWndNum(GetParent(GetParent(hwnd)));
			i2=GetWndInfoNum(MdiInfo[i].path);

			SetDlgItemText(hwnd,IDC_IDNAME,ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].IdName);
			SetDlgItemText(hwnd,IDC_CAPTION,ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].caption);


			////////////
			// X^C
			////////////

			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&WS_DISABLED) SendDlgItemMessage(hwnd,IDC_STYLE_DISABLED,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&WS_VISIBLE) SendDlgItemMessage(hwnd,IDC_STYLE_VISIBLE,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&WS_GROUP) SendDlgItemMessage(hwnd,IDC_STYLE_GROUP,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&WS_TABSTOP) SendDlgItemMessage(hwnd,IDC_STYLE_TABSTOP,BM_SETCHECK,BST_CHECKED,0);

			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&ES_MULTILINE) SendDlgItemMessage(hwnd,IDC_ES_MULTILINE,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&ES_NUMBER) SendDlgItemMessage(hwnd,IDC_ES_NUMBER,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&WS_HSCROLL) SendDlgItemMessage(hwnd,IDC_STYLE_HSCROLL,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&ES_AUTOHSCROLL) SendDlgItemMessage(hwnd,IDC_ES_AUTOHSCROLL,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&WS_VSCROLL) SendDlgItemMessage(hwnd,IDC_STYLE_VSCROLL,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&ES_AUTOVSCROLL) SendDlgItemMessage(hwnd,IDC_ES_AUTOVSCROLL,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&ES_PASSWORD) SendDlgItemMessage(hwnd,IDC_ES_PASSWORD,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&ES_NOHIDESEL) SendDlgItemMessage(hwnd,IDC_ES_NOHIDESEL,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&ES_OEMCONVERT) SendDlgItemMessage(hwnd,IDC_ES_OEMCONVERT,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&ES_WANTRETURN) SendDlgItemMessage(hwnd,IDC_ES_WANTRETURN,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&ES_UPPERCASE) SendDlgItemMessage(hwnd,IDC_ES_UPPERCASE,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&ES_LOWERCASE) SendDlgItemMessage(hwnd,IDC_ES_LOWERCASE,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&ES_READONLY) SendDlgItemMessage(hwnd,IDC_ES_READONLY,BM_SETCHECK,BST_CHECKED,0);


			//////////////////
			// eLXg̔zu
			//////////////////

			//"["
			SendDlgItemMessage(hwnd,IDC_ES_TEXTPOS,CB_ADDSTRING,0,(long)STRING_LEFT);
			//""
			SendDlgItemMessage(hwnd,IDC_ES_TEXTPOS,CB_ADDSTRING,0,(long)STRING_CENTER);
			//"E["
			SendDlgItemMessage(hwnd,IDC_ES_TEXTPOS,CB_ADDSTRING,0,(long)STRING_RIGHT);

			//rbglES_LEFTŌɌ
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&ES_CENTER) SendDlgItemMessage(hwnd,IDC_ES_TEXTPOS,CB_SETCURSEL,1,0);
			else if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&ES_RIGHT) SendDlgItemMessage(hwnd,IDC_ES_TEXTPOS,CB_SETCURSEL,2,0);
			else SendDlgItemMessage(hwnd,IDC_ES_TEXTPOS,CB_SETCURSEL,0,0);

			RadProperty_Edit_StylingOrder(hwnd,&ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);


			bInitial=0;
			break;
		case WM_COMMAND:

			i=GetWndNum(GetParent(GetParent(hwnd)));
			if(i==-1) return 1;
			i2=GetWndInfoNum(MdiInfo[i].path);

			//ʃX^C
			if(bInitial==0){
				if(DefaultItemStyles(hwnd,i,i2,wParam)) return 1;
			}

			switch(LOWORD(wParam)){
				case IDC_ES_MULTILINE:
					if(HIWORD(wParam)==BN_CLICKED){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						if(SendDlgItemMessage(hwnd,IDC_ES_MULTILINE,BM_GETCHECK,0,0))
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=ES_MULTILINE;
						else
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~ES_MULTILINE;
						RadProperty_Edit_StylingOrder(hwnd,&ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);
						DrawRadWindow(i,&ProjectInfo.pWindowInfo[i2]);
						return 1;
					}
					break;
				case IDC_ES_NUMBER:
					if(HIWORD(wParam)==BN_CLICKED){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						if(SendDlgItemMessage(hwnd,IDC_ES_NUMBER,BM_GETCHECK,0,0))
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=ES_NUMBER;
						else
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~ES_NUMBER;
						return 1;
					}
					break;
				case IDC_STYLE_HSCROLL:
					if(HIWORD(wParam)==BN_CLICKED){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						if(SendDlgItemMessage(hwnd,IDC_STYLE_HSCROLL,BM_GETCHECK,0,0))
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=WS_HSCROLL;
						else
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~WS_HSCROLL;
						DrawRadWindow(i,&ProjectInfo.pWindowInfo[i2]);
						return 1;
					}
					break;
				case IDC_ES_AUTOHSCROLL:
					if(HIWORD(wParam)==BN_CLICKED){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						if(SendDlgItemMessage(hwnd,IDC_ES_AUTOHSCROLL,BM_GETCHECK,0,0))
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=ES_AUTOHSCROLL;
						else
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~ES_AUTOHSCROLL;
						DrawRadWindow(i,&ProjectInfo.pWindowInfo[i2]);
						return 1;
					}
					break;
				case IDC_STYLE_VSCROLL:
					if(HIWORD(wParam)==BN_CLICKED){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						if(SendDlgItemMessage(hwnd,IDC_STYLE_VSCROLL,BM_GETCHECK,0,0))
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=WS_VSCROLL;
						else
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~WS_VSCROLL;
						DrawRadWindow(i,&ProjectInfo.pWindowInfo[i2]);
						return 1;
					}
					break;
				case IDC_ES_AUTOVSCROLL:
					if(HIWORD(wParam)==BN_CLICKED){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						if(SendDlgItemMessage(hwnd,IDC_ES_AUTOVSCROLL,BM_GETCHECK,0,0))
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=ES_AUTOVSCROLL;
						else
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~ES_AUTOVSCROLL;
						DrawRadWindow(i,&ProjectInfo.pWindowInfo[i2]);
						return 1;
					}
					break;
				case IDC_ES_PASSWORD:
					if(HIWORD(wParam)==BN_CLICKED){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						if(SendDlgItemMessage(hwnd,IDC_ES_PASSWORD,BM_GETCHECK,0,0))
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=ES_PASSWORD;
						else
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~ES_PASSWORD;
						DrawRadWindow(i,&ProjectInfo.pWindowInfo[i2]);
						return 1;
					}
					break;
				case IDC_ES_NOHIDESEL:
					if(HIWORD(wParam)==BN_CLICKED){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						if(SendDlgItemMessage(hwnd,IDC_ES_NOHIDESEL,BM_GETCHECK,0,0))
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=ES_NOHIDESEL;
						else
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~ES_NOHIDESEL;
						DrawRadWindow(i,&ProjectInfo.pWindowInfo[i2]);
						return 1;
					}
					break;
				case IDC_ES_OEMCONVERT:
					if(HIWORD(wParam)==BN_CLICKED){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						if(SendDlgItemMessage(hwnd,IDC_ES_OEMCONVERT,BM_GETCHECK,0,0))
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=ES_OEMCONVERT;
						else
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~ES_OEMCONVERT;
						DrawRadWindow(i,&ProjectInfo.pWindowInfo[i2]);
						return 1;
					}
					break;
				case IDC_ES_WANTRETURN:
					if(HIWORD(wParam)==BN_CLICKED){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						if(SendDlgItemMessage(hwnd,IDC_ES_WANTRETURN,BM_GETCHECK,0,0))
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=ES_WANTRETURN;
						else
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~ES_WANTRETURN;
						DrawRadWindow(i,&ProjectInfo.pWindowInfo[i2]);
						return 1;
					}
					break;
				case IDC_ES_UPPERCASE:
					if(HIWORD(wParam)==BN_CLICKED){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						if(SendDlgItemMessage(hwnd,IDC_ES_UPPERCASE,BM_GETCHECK,0,0)){
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~ES_LOWERCASE;
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=ES_UPPERCASE;
							SendDlgItemMessage(hwnd,IDC_ES_LOWERCASE,BM_SETCHECK,BST_UNCHECKED,0);
						}
						else
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~ES_UPPERCASE;
						DrawRadWindow(i,&ProjectInfo.pWindowInfo[i2]);
						return 1;
					}
					break;
				case IDC_ES_LOWERCASE:
					if(HIWORD(wParam)==BN_CLICKED){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						if(SendDlgItemMessage(hwnd,IDC_ES_LOWERCASE,BM_GETCHECK,0,0)){
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~ES_UPPERCASE;
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=ES_LOWERCASE;
							SendDlgItemMessage(hwnd,IDC_ES_UPPERCASE,BM_SETCHECK,BST_UNCHECKED,0);
						}
						else
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~ES_LOWERCASE;
						DrawRadWindow(i,&ProjectInfo.pWindowInfo[i2]);
						return 1;
					}
					break;
				case IDC_ES_READONLY:
					if(HIWORD(wParam)==BN_CLICKED){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						if(SendDlgItemMessage(hwnd,IDC_ES_READONLY,BM_GETCHECK,0,0))
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=ES_READONLY;
						else
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~ES_READONLY;
						DrawRadWindow(i,&ProjectInfo.pWindowInfo[i2]);
						return 1;
					}
					break;

				case IDC_ES_TEXTPOS:
					if(HIWORD(wParam)==CBN_SELCHANGE){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						i3=SendDlgItemMessage(hwnd,IDC_ES_TEXTPOS,CB_GETCURSEL,0,0);
						//ES_LEFT=0
						ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~(ES_CENTER|ES_RIGHT);
						if(i3==1) ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=ES_CENTER;
						else if(i3==2) ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=ES_RIGHT;
						DrawRadWindow(i,&ProjectInfo.pWindowInfo[i2]);
						return 1;
					}
					break;

				case IDC_EXSTYLE:
					if(!DialogBox(hResInst,MAKEINTRESOURCE(IDD_RAD_PROP_ITEM_EXSTYLE),hwnd,(DLGPROC)DlgRadProperty_Item_ExStyle)) return 1;
					DrawRadWindow(i,&ProjectInfo.pWindowInfo[i2]);
					return 1;
			}
			break;
	}
	return 0;
}


////////////////////////
// GROUPBOX vpeB

BOOL CALLBACK RadProperty_GroupBoxProc(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam){
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	extern PROJECTINFO ProjectInfo;
	int i,i2,i3;
	static BOOL bInitial;

	switch(message){
		case WM_INITDIALOG:
			bInitial=1;
			i=GetWndNum(GetParent(GetParent(hwnd)));
			i2=GetWndInfoNum(MdiInfo[i].path);

			SetDlgItemText(hwnd,IDC_IDNAME,ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].IdName);
			SetDlgItemText(hwnd,IDC_CAPTION,ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].caption);


			/////////////////////////////
			// X^C
			////////////

			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&WS_DISABLED) SendDlgItemMessage(hwnd,IDC_STYLE_DISABLED,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&WS_VISIBLE) SendDlgItemMessage(hwnd,IDC_STYLE_VISIBLE,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&WS_GROUP) SendDlgItemMessage(hwnd,IDC_STYLE_GROUP,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&WS_TABSTOP) SendDlgItemMessage(hwnd,IDC_STYLE_TABSTOP,BM_SETCHECK,BST_CHECKED,0);


			//////////////////
			// ̔zu
			//////////////////

			//"ftHg"
			SendDlgItemMessage(hwnd,IDC_BS_POSITION,CB_ADDSTRING,0,(long)STRING_DEFAULT);
			//"["
			SendDlgItemMessage(hwnd,IDC_BS_POSITION,CB_ADDSTRING,0,(long)STRING_LEFT);
			//"E["
			SendDlgItemMessage(hwnd,IDC_BS_POSITION,CB_ADDSTRING,0,(long)STRING_RIGHT);
			//""
			SendDlgItemMessage(hwnd,IDC_BS_POSITION,CB_ADDSTRING,0,(long)STRING_CENTER);

			//rbglBS_CENTERŏɌ
			if((ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&BS_CENTER)==BS_CENTER) SendDlgItemMessage(hwnd,IDC_BS_POSITION,CB_SETCURSEL,3,0);
			else if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&BS_LEFT) SendDlgItemMessage(hwnd,IDC_BS_POSITION,CB_SETCURSEL,1,0);
			else if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&BS_RIGHT) SendDlgItemMessage(hwnd,IDC_BS_POSITION,CB_SETCURSEL,2,0);
			else SendDlgItemMessage(hwnd,IDC_BS_POSITION,CB_SETCURSEL,0,0);

			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&BS_ICON) SendDlgItemMessage(hwnd,IDC_BS_ICON,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&BS_BITMAP) SendDlgItemMessage(hwnd,IDC_BS_BITMAP,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&BS_NOTIFY) SendDlgItemMessage(hwnd,IDC_BS_NOTIFY,BM_SETCHECK,BST_CHECKED,0);


			bInitial=0;
			break;
		case WM_COMMAND:

			i=GetWndNum(GetParent(GetParent(hwnd)));
			if(i==-1) return 1;
			i2=GetWndInfoNum(MdiInfo[i].path);

			//ʃX^C
			if(bInitial==0){
				if(DefaultItemStyles(hwnd,i,i2,wParam)) return 1;
			}

			switch(LOWORD(wParam)){
				case IDC_BS_POSITION:
					if(HIWORD(wParam)==CBN_SELCHANGE){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						i3=SendDlgItemMessage(hwnd,IDC_BS_POSITION,CB_GETCURSEL,0,0);
						//BS_CENTER=BS_LEFT | BS_RIGHT
						ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~(BS_CENTER);
						if(i3==1) ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=BS_LEFT;
						else if(i3==2) ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=BS_RIGHT;
						else if(i3==3) ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=BS_CENTER;
						DrawRadWindow(i,&ProjectInfo.pWindowInfo[i2]);
						return 1;
					}
					break;

				case IDC_BS_ICON:
					if(HIWORD(wParam)==BN_CLICKED){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						if(SendDlgItemMessage(hwnd,IDC_BS_ICON,BM_GETCHECK,0,0))
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=BS_ICON;
						else
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~BS_ICON;
						DrawRadWindow(i,&ProjectInfo.pWindowInfo[i2]);
						return 1;
					}
					break;
				case IDC_BS_BITMAP:
					if(HIWORD(wParam)==BN_CLICKED){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						if(SendDlgItemMessage(hwnd,IDC_BS_BITMAP,BM_GETCHECK,0,0))
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=BS_BITMAP;
						else
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~BS_BITMAP;
						DrawRadWindow(i,&ProjectInfo.pWindowInfo[i2]);
						return 1;
					}
					break;
				case IDC_BS_NOTIFY:
					if(HIWORD(wParam)==BN_CLICKED){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						if(SendDlgItemMessage(hwnd,IDC_BS_NOTIFY,BM_GETCHECK,0,0))
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=BS_NOTIFY;
						else
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~BS_NOTIFY;
						return 1;
					}
					break;

				case IDC_EXSTYLE:
					if(!DialogBox(hResInst,MAKEINTRESOURCE(IDD_RAD_PROP_ITEM_EXSTYLE),hwnd,(DLGPROC)DlgRadProperty_Item_ExStyle)) return 1;
					DrawRadWindow(i,&ProjectInfo.pWindowInfo[i2]);
					return 1;
			}
			break;
	}
	return 0;
}


////////////////////////
// IMAGEBOX vpeB

void RadProperty_ImageBox_StylingOrder(HWND hwnd,DWORD *style){
	if((*style&0x000F)==SS_ICON||
		(*style&0x000F)==SS_BITMAP){
		EnableWindow(GetDlgItem(hwnd,IDC_PATH),1);
		EnableWindow(GetDlgItem(hwnd,IDC_CHANGEPATH),1);
		EnableWindow(GetDlgItem(hwnd,IDC_SS_CENTERIMAGE),1);
		EnableWindow(GetDlgItem(hwnd,IDC_SS_RIGHTJUST),1);
	}
	else{
		EnableWindow(GetDlgItem(hwnd,IDC_PATH),0);
		EnableWindow(GetDlgItem(hwnd,IDC_CHANGEPATH),0);
		EnableWindow(GetDlgItem(hwnd,IDC_SS_CENTERIMAGE),0);
		EnableWindow(GetDlgItem(hwnd,IDC_SS_RIGHTJUST),0);
	}
}
BOOL CALLBACK RadProperty_ImageBoxProc(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam){
	extern HANDLE hHeap;
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	extern PROJECTINFO ProjectInfo;
	int i,i2,i3;
	char temporary[MAX_PATH];
	static BOOL bInitial;

	switch(message){
		case WM_INITDIALOG:
			bInitial=1;
			i=GetWndNum(GetParent(GetParent(hwnd)));
			i2=GetWndInfoNum(MdiInfo[i].path);

			SetDlgItemText(hwnd,IDC_IDNAME,ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].IdName);


			/////////////////////////////
			// X^C
			////////////

			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&WS_DISABLED) SendDlgItemMessage(hwnd,IDC_STYLE_DISABLED,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&WS_VISIBLE) SendDlgItemMessage(hwnd,IDC_STYLE_VISIBLE,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&WS_GROUP) SendDlgItemMessage(hwnd,IDC_STYLE_GROUP,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&WS_TABSTOP) SendDlgItemMessage(hwnd,IDC_STYLE_TABSTOP,BM_SETCHECK,BST_CHECKED,0);

			//////////
			// ^Cv
			//////////

			//"t[ij"
			SendDlgItemMessage(hwnd,IDC_IMAGE_TYPE,CB_ADDSTRING,0,(long)STRING_IMAGEBOXPROP_STYLE_FRAME_BLACK);
			//"t[iDFj"
			SendDlgItemMessage(hwnd,IDC_IMAGE_TYPE,CB_ADDSTRING,0,(long)STRING_IMAGEBOXPROP_STYLE_FRAME_GRAY);
			//"t[ij"
			SendDlgItemMessage(hwnd,IDC_IMAGE_TYPE,CB_ADDSTRING,0,(long)STRING_IMAGEBOXPROP_STYLE_FRAME_WHITE);
			//"t[ij"
			SendDlgItemMessage(hwnd,IDC_IMAGE_TYPE,CB_ADDSTRING,0,(long)STRING_IMAGEBOXPROP_STYLE_FRAME_ETCHED);
			//"lp`ij"
			SendDlgItemMessage(hwnd,IDC_IMAGE_TYPE,CB_ADDSTRING,0,(long)STRING_IMAGEBOXPROP_STYLE_RECT_BLACK);
			//"lp`iDFj"
			SendDlgItemMessage(hwnd,IDC_IMAGE_TYPE,CB_ADDSTRING,0,(long)STRING_IMAGEBOXPROP_STYLE_RECT_GRAY);
			//"lp`ij"
			SendDlgItemMessage(hwnd,IDC_IMAGE_TYPE,CB_ADDSTRING,0,(long)STRING_IMAGEBOXPROP_STYLE_RECT_WHITE);
			//"ACR"
			SendDlgItemMessage(hwnd,IDC_IMAGE_TYPE,CB_ADDSTRING,0,(long)STRING_IMAGEBOXPROP_STYLE_ICON);
			//"rbg}bv"
			SendDlgItemMessage(hwnd,IDC_IMAGE_TYPE,CB_ADDSTRING,0,(long)STRING_IMAGEBOXPROP_STYLE_BITMAP);

			if((ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&0x0000000F)==SS_BLACKFRAME) SendDlgItemMessage(hwnd,IDC_IMAGE_TYPE,CB_SETCURSEL,0,0);
			else if((ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&0x0000000F)==SS_GRAYFRAME) SendDlgItemMessage(hwnd,IDC_IMAGE_TYPE,CB_SETCURSEL,1,0);
			else if((ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&0x0000000F)==SS_WHITEFRAME) SendDlgItemMessage(hwnd,IDC_IMAGE_TYPE,CB_SETCURSEL,2,0);
			else if((ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&0x0000001F)==SS_ETCHEDFRAME) SendDlgItemMessage(hwnd,IDC_IMAGE_TYPE,CB_SETCURSEL,3,0);
			else if((ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&0x0000000F)==SS_BLACKRECT) SendDlgItemMessage(hwnd,IDC_IMAGE_TYPE,CB_SETCURSEL,4,0);
			else if((ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&0x0000000F)==SS_GRAYRECT) SendDlgItemMessage(hwnd,IDC_IMAGE_TYPE,CB_SETCURSEL,5,0);
			else if((ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&0x0000000F)==SS_WHITERECT) SendDlgItemMessage(hwnd,IDC_IMAGE_TYPE,CB_SETCURSEL,6,0);
			if((ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&0x0000000F)==SS_ICON||
				(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&0x0000000F)==SS_BITMAP){
				if((ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&0x0000000F)==SS_ICON) SendDlgItemMessage(hwnd,IDC_IMAGE_TYPE,CB_SETCURSEL,7,0);
				else if((ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&0x0000000F)==SS_BITMAP) SendDlgItemMessage(hwnd,IDC_IMAGE_TYPE,CB_SETCURSEL,8,0);

				//\[X^t@C XCb``FbN\
				ShowWindow(GetDlgItem(hwnd,IDC_FILE),SW_SHOW);
				ShowWindow(GetDlgItem(hwnd,IDC_RESOURCE),SW_SHOW);
				
				//C[WԃeLXg\
				ShowWindow(GetDlgItem(hwnd,IDC_IMAGE_SITUATION),SW_SHOW);

				if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].ImageCtrlInfo.type==IMGTYPE_FILE){
					//t@Cw\
					ShowWindow(GetDlgItem(hwnd,IDC_PATH),SW_SHOW);
					ShowWindow(GetDlgItem(hwnd,IDC_CHANGEPATH),SW_SHOW);
					SetDlgItemText(hwnd,IDC_PATH,ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].ImageCtrlInfo.path);

					//C[WԃeLXg
					//"t@Cw:"
					SetDlgItemText(hwnd,IDC_IMAGE_SITUATION,STRING_IMAGEBOXPROP_STYLE_FROMFILE);

					SendDlgItemMessage(hwnd,IDC_FILE,BM_SETCHECK,BST_CHECKED,0);
				}
				else if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].ImageCtrlInfo.type==IMGTYPE_RES){
					//\[Xw\
					ShowWindow(GetDlgItem(hwnd,IDC_RESCOMBO),SW_SHOW);

					//C[WԃeLXg
					//"\[Xw:"
					SetDlgItemText(hwnd,IDC_IMAGE_SITUATION,STRING_IMAGEBOXPROP_STYLE_FROMRESOURCE);

					SendDlgItemMessage(hwnd,IDC_RESOURCE,BM_SETCHECK,BST_CHECKED,0);

					SendDlgItemMessage(hwnd,IDC_RESCOMBO,CB_RESETCONTENT,0,0);

					if((ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&0x0000000F)==SS_ICON){
						//ACR\[XR{{bNXɑ}
						for(i3=0;i3<ProjectInfo.res.NumberOfIconRes;i3++)
							SendDlgItemMessage(hwnd,IDC_RESCOMBO,CB_ADDSTRING,0,(long)ProjectInfo.res.pIconResInfo[i3].IdName);
					}
					else if((ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&0x0000000F)==SS_BITMAP){
						//rbg}bv\[XR{{bNXɑ}
						for(i3=0;i3<ProjectInfo.res.NumberOfBitmapRes;i3++)
							SendDlgItemMessage(hwnd,IDC_RESCOMBO,CB_ADDSTRING,0,(long)ProjectInfo.res.pBitmapResInfo[i3].IdName);
					}

					//XgI
					i3=SendDlgItemMessage(hwnd,IDC_RESCOMBO,CB_FINDSTRING,0,(long)ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].ImageCtrlInfo.path);
					SendDlgItemMessage(hwnd,IDC_RESCOMBO,CB_SETCURSEL,i3,0);
				}
			}

			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&SS_NOTIFY) SendDlgItemMessage(hwnd,IDC_SS_NOTIFY,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&SS_CENTERIMAGE) SendDlgItemMessage(hwnd,IDC_SS_CENTERIMAGE,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&SS_RIGHTJUST) SendDlgItemMessage(hwnd,IDC_SS_RIGHTJUST,BM_SETCHECK,BST_CHECKED,0);

			RadProperty_ImageBox_StylingOrder(hwnd,&ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

			bInitial=0;
			break;
		case WM_COMMAND:

			i=GetWndNum(GetParent(GetParent(hwnd)));
			if(i==-1) return 1;
			i2=GetWndInfoNum(MdiInfo[i].path);

			//ʃX^C
			if(bInitial==0){
				if(DefaultItemStyles(hwnd,i,i2,wParam)) return 1;
			}

			switch(LOWORD(wParam)){
				case IDC_IMAGE_TYPE:
					if(HIWORD(wParam)==CBN_SELCHANGE){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						i3=SendDlgItemMessage(hwnd,IDC_IMAGE_TYPE,CB_GETCURSEL,0,0);
						ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~(0x0000001F);
						if(i3==0) ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=SS_BLACKFRAME;
						else if(i3==1) ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=SS_GRAYFRAME;
						else if(i3==2) ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=SS_WHITEFRAME;
						else if(i3==3) ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=SS_ETCHEDFRAME;
						else if(i3==4) ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=SS_BLACKRECT;
						else if(i3==5) ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=SS_GRAYRECT;
						else if(i3==6) ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=SS_WHITERECT;
						else if(i3==7) ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=SS_ICON;
						else if(i3==8) ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=SS_BITMAP;

						if((ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&0x0000000F)==SS_ICON||
							(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&0x0000000F)==SS_BITMAP){
							//\[X^t@C XCb``FbN\
							ShowWindow(GetDlgItem(hwnd,IDC_FILE),SW_SHOW);
							ShowWindow(GetDlgItem(hwnd,IDC_RESOURCE),SW_SHOW);

							//C[WԃeLXg\
							ShowWindow(GetDlgItem(hwnd,IDC_IMAGE_SITUATION),SW_SHOW);

							if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].ImageCtrlInfo.type==IMGTYPE_FILE){
								//t@Cw\
								ShowWindow(GetDlgItem(hwnd,IDC_PATH),SW_SHOW);
								ShowWindow(GetDlgItem(hwnd,IDC_CHANGEPATH),SW_SHOW);
								SetDlgItemText(hwnd,IDC_PATH,ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].ImageCtrlInfo.path);

								//C[WԃeLXg
								//"t@Cw:"
								SetDlgItemText(hwnd,IDC_IMAGE_SITUATION,STRING_IMAGEBOXPROP_STYLE_FROMFILE);

								SendDlgItemMessage(hwnd,IDC_FILE,BM_SETCHECK,BST_CHECKED,0);
							}
							else if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].ImageCtrlInfo.type==IMGTYPE_RES){
								//\[Xw\
								ShowWindow(GetDlgItem(hwnd,IDC_RESCOMBO),SW_SHOW);

								//C[WԃeLXg
								//"\[Xw:"
								SetDlgItemText(hwnd,IDC_IMAGE_SITUATION,STRING_IMAGEBOXPROP_STYLE_FROMRESOURCE);

								SendDlgItemMessage(hwnd,IDC_RESOURCE,BM_SETCHECK,BST_CHECKED,0);

								SendDlgItemMessage(hwnd,IDC_RESCOMBO,CB_RESETCONTENT,0,0);

								if((ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&0x0000000F)==SS_ICON){
									//ACR\[XR{{bNXɑ}
									for(i3=0;i3<ProjectInfo.res.NumberOfIconRes;i3++){
										SendDlgItemMessage(hwnd,IDC_RESCOMBO,CB_ADDSTRING,0,(long)ProjectInfo.res.pIconResInfo[i3].IdName);

										if(lstrcmp(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].ImageCtrlInfo.path,ProjectInfo.res.pIconResInfo[i3].IdName)==0)
											SendDlgItemMessage(hwnd,IDC_RESCOMBO,CB_SETCURSEL,i3,0);
									}
								}
								else if((ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&0x0000000F)==SS_BITMAP){
									//rbg}bv\[XR{{bNXɑ}
									for(i3=0;i3<ProjectInfo.res.NumberOfBitmapRes;i3++){
										SendDlgItemMessage(hwnd,IDC_RESCOMBO,CB_ADDSTRING,0,(long)ProjectInfo.res.pBitmapResInfo[i3].IdName);

										if(lstrcmp(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].ImageCtrlInfo.path,ProjectInfo.res.pBitmapResInfo[i3].IdName)==0)
											SendDlgItemMessage(hwnd,IDC_RESCOMBO,CB_SETCURSEL,i3,0);
									}
								}
							}
						}
						else{
							//\[X^t@C XCb``FbN\
							ShowWindow(GetDlgItem(hwnd,IDC_FILE),SW_HIDE);
							ShowWindow(GetDlgItem(hwnd,IDC_RESOURCE),SW_HIDE);

							//C[WԃeLXg\
							ShowWindow(GetDlgItem(hwnd,IDC_IMAGE_SITUATION),SW_HIDE);

							//t@Cw\
							ShowWindow(GetDlgItem(hwnd,IDC_PATH),SW_HIDE);
							ShowWindow(GetDlgItem(hwnd,IDC_CHANGEPATH),SW_HIDE);

							//\[Xw\
							ShowWindow(GetDlgItem(hwnd,IDC_RESCOMBO),SW_HIDE);
						}

						RadProperty_ImageBox_StylingOrder(hwnd,&ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);
						DrawRadWindow(i,&ProjectInfo.pWindowInfo[i2]);
						return 1;
					}
					break;

				case IDC_FILE:
					if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].ImageCtrlInfo.type==IMGTYPE_FILE){
						//ύX
						break;
					}

					//ύX
					Rad_NoticeChanging(i,RAD_UNDO_IMAGESTATE,MdiInfo[i].MdiRadInfo->SelectingItem[0],(DWORD)&ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].ImageCtrlInfo);

					ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].ImageCtrlInfo.type=IMGTYPE_FILE;

					//t@Cw\
					ShowWindow(GetDlgItem(hwnd,IDC_PATH),SW_SHOW);
					ShowWindow(GetDlgItem(hwnd,IDC_CHANGEPATH),SW_SHOW);
					SetDlgItemText(hwnd,IDC_PATH,ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].ImageCtrlInfo.path);

					//\[Xw\
					ShowWindow(GetDlgItem(hwnd,IDC_RESCOMBO),SW_HIDE);

					//C[WԃeLXg
					//"t@Cw:"
					SetDlgItemText(hwnd,IDC_IMAGE_SITUATION,STRING_IMAGEBOXPROP_STYLE_FROMFILE);

					SendDlgItemMessage(hwnd,IDC_FILE,BM_SETCHECK,BST_CHECKED,0);
					break;

				case IDC_RESOURCE:
					if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].ImageCtrlInfo.type==IMGTYPE_RES){
						//ύX
						break;
					}

					//ύX
					Rad_NoticeChanging(i,RAD_UNDO_IMAGESTATE,MdiInfo[i].MdiRadInfo->SelectingItem[0],(DWORD)&ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].ImageCtrlInfo);

					ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].ImageCtrlInfo.type=IMGTYPE_RES;

					//t@Cw\
					ShowWindow(GetDlgItem(hwnd,IDC_PATH),SW_HIDE);
					ShowWindow(GetDlgItem(hwnd,IDC_CHANGEPATH),SW_HIDE);

					//\[Xw\
					ShowWindow(GetDlgItem(hwnd,IDC_RESCOMBO),SW_SHOW);

					//C[WԃeLXg
					//"\[Xw:"
					SetDlgItemText(hwnd,IDC_IMAGE_SITUATION,STRING_IMAGEBOXPROP_STYLE_FROMRESOURCE);

					SendDlgItemMessage(hwnd,IDC_RESOURCE,BM_SETCHECK,BST_CHECKED,0);

					SendDlgItemMessage(hwnd,IDC_RESCOMBO,CB_RESETCONTENT,0,0);

					if((ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&0x0000000F)==SS_ICON){
						//ACR\[XR{{bNXɑ}
						for(i3=0;i3<ProjectInfo.res.NumberOfIconRes;i3++)
							SendDlgItemMessage(hwnd,IDC_RESCOMBO,CB_ADDSTRING,0,(long)ProjectInfo.res.pIconResInfo[i3].IdName);
					}
					else if((ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&0x0000000F)==SS_BITMAP){
						//rbg}bv\[XR{{bNXɑ}
						for(i3=0;i3<ProjectInfo.res.NumberOfBitmapRes;i3++)
							SendDlgItemMessage(hwnd,IDC_RESCOMBO,CB_ADDSTRING,0,(long)ProjectInfo.res.pBitmapResInfo[i3].IdName);
					}
					break;

				case IDC_RESCOMBO:
					if(HIWORD(wParam)==CBN_SELCHANGE){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_IMAGESTATE,MdiInfo[i].MdiRadInfo->SelectingItem[0],(DWORD)&ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].ImageCtrlInfo);

						i3=SendDlgItemMessage(hwnd,IDC_RESCOMBO,CB_GETCURSEL,0,0);
						SendDlgItemMessage(hwnd,IDC_RESCOMBO,CB_GETLBTEXT,i3,(long)temporary);

						HeapDefaultFree(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].ImageCtrlInfo.path);
						ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].ImageCtrlInfo.path=(char *)HeapAlloc(hHeap,0,lstrlen(temporary)+1);
						lstrcpy(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].ImageCtrlInfo.path,temporary);

						DrawRadWindow(i,&ProjectInfo.pWindowInfo[i2]);
					}
					break;

				case IDC_CHANGEPATH:
					if(HIWORD(wParam)==BN_CLICKED){
						if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].ImageCtrlInfo.type==IMGTYPE_FILE){
							if((ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&0x000F)==SS_ICON){
								extern LPSTR IconFileFilter;
								//"ACR t@Cw肵ĉ"
								if(!GetFilePathDialog(hwnd,temporary,IconFileFilter,STRING_IMAGEBOXPROP_GETPATH_ICON,1)) return 1;
							}
							else if((ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&0x000F)==SS_BITMAP){
								extern LPSTR BitmapFileFilter;
								//"rbg}bv t@Cw肵ĉ"
								if(!GetFilePathDialog(hwnd,temporary,BitmapFileFilter,STRING_IMAGEBOXPROP_GETPATH_BITMAP,1)) return 1;
							}

							//ύX
							Rad_NoticeChanging(i,RAD_UNDO_IMAGESTATE,MdiInfo[i].MdiRadInfo->SelectingItem[0],(DWORD)&ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].ImageCtrlInfo);

							GetRelationalPath(temporary,ProjectInfo.dir);
							HeapDefaultFree(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].ImageCtrlInfo.path);
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].ImageCtrlInfo.path=(char *)HeapAlloc(hHeap,0,lstrlen(temporary)+1);
							lstrcpy(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].ImageCtrlInfo.path,temporary);

							SetDlgItemText(hwnd,IDC_PATH,temporary);
							DrawRadWindow(i,&ProjectInfo.pWindowInfo[i2]);
						}
						return 1;
					}
					break;

				case IDC_SS_NOTIFY:
					if(HIWORD(wParam)==BN_CLICKED){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						if(SendDlgItemMessage(hwnd,IDC_SS_NOTIFY,BM_GETCHECK,0,0))
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=SS_NOTIFY;
						else
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~SS_NOTIFY;
						return 1;
					}
					break;
				case IDC_SS_CENTERIMAGE:
					if(HIWORD(wParam)==BN_CLICKED){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						if(SendDlgItemMessage(hwnd,IDC_SS_CENTERIMAGE,BM_GETCHECK,0,0))
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=SS_CENTERIMAGE;
						else
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~SS_CENTERIMAGE;
						return 1;
					}
					break;
				case IDC_SS_RIGHTJUST:
					if(HIWORD(wParam)==BN_CLICKED){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						if(SendDlgItemMessage(hwnd,IDC_SS_RIGHTJUST,BM_GETCHECK,0,0))
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=SS_RIGHTJUST;
						else
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~SS_RIGHTJUST;
						return 1;
					}
					break;

				case IDC_EXSTYLE:
					if(!DialogBox(hResInst,MAKEINTRESOURCE(IDD_RAD_PROP_ITEM_EXSTYLE),hwnd,(DLGPROC)DlgRadProperty_Item_ExStyle)) return 1;
					DrawRadWindow(i,&ProjectInfo.pWindowInfo[i2]);
					return 1;
			}
			break;
	}
	return 0;
}


////////////////////////
// LISTVIEW vpeB
BOOL CALLBACK RadProperty_ListViewProc(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam){
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	extern PROJECTINFO ProjectInfo;
	int i,i2,i3;
	static BOOL bInitial;

	switch(message){
		case WM_INITDIALOG:
			bInitial=1;
			i=GetWndNum(GetParent(GetParent(hwnd)));
			i2=GetWndInfoNum(MdiInfo[i].path);

			SetDlgItemText(hwnd,IDC_IDNAME,ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].IdName);


			/////////////////////////
			// X^C
			////////////

			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&WS_DISABLED) SendDlgItemMessage(hwnd,IDC_STYLE_DISABLED,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&WS_VISIBLE) SendDlgItemMessage(hwnd,IDC_STYLE_VISIBLE,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&WS_GROUP) SendDlgItemMessage(hwnd,IDC_STYLE_GROUP,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&WS_TABSTOP) SendDlgItemMessage(hwnd,IDC_STYLE_TABSTOP,BM_SETCHECK,BST_CHECKED,0);

			////////
			// \
			////////

			//"ACR"
			SendDlgItemMessage(hwnd,IDC_LVS_VIEW,CB_ADDSTRING,0,(long)STRING_LISTVIEWPROP_STYLE_ICON);
			//"ACR"
			SendDlgItemMessage(hwnd,IDC_LVS_VIEW,CB_ADDSTRING,0,(long)STRING_LISTVIEWPROP_STYLE_SMALLICON);
			//"Xg"
			SendDlgItemMessage(hwnd,IDC_LVS_VIEW,CB_ADDSTRING,0,(long)STRING_LISTVIEWPROP_STYLE_LIST);
			//"|[g"
			SendDlgItemMessage(hwnd,IDC_LVS_VIEW,CB_ADDSTRING,0,(long)STRING_LISTVIEWPROP_STYLE_REPORT);

			//rbglLVS_LISTŏɔr
			if((ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&LVS_LIST)==LVS_LIST) SendDlgItemMessage(hwnd,IDC_LVS_VIEW,CB_SETCURSEL,2,0);
			else if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&LVS_SMALLICON) SendDlgItemMessage(hwnd,IDC_LVS_VIEW,CB_SETCURSEL,1,0);
			else if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&LVS_REPORT) SendDlgItemMessage(hwnd,IDC_LVS_VIEW,CB_SETCURSEL,3,0);
			else SendDlgItemMessage(hwnd,IDC_LVS_VIEW,CB_SETCURSEL,0,0);


			////////
			// zu
			////////

			//"["
			SendDlgItemMessage(hwnd,IDC_LVS_POSITION,CB_ADDSTRING,0,(long)STRING_TOP);
			//"["
			SendDlgItemMessage(hwnd,IDC_LVS_POSITION,CB_ADDSTRING,0,(long)STRING_LEFT);

			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&LVS_ALIGNLEFT) SendDlgItemMessage(hwnd,IDC_LVS_POSITION,CB_SETCURSEL,1,0);
			else SendDlgItemMessage(hwnd,IDC_LVS_POSITION,CB_SETCURSEL,0,0);


			//////////
			// \[g
			//////////

			//"Ȃ"
			SendDlgItemMessage(hwnd,IDC_LVS_SORT,CB_ADDSTRING,0,(long)STRING_NONE_);
			//""
			SendDlgItemMessage(hwnd,IDC_LVS_SORT,CB_ADDSTRING,0,(long)STRING_SORT_ASCENDING);
			//"~"
			SendDlgItemMessage(hwnd,IDC_LVS_SORT,CB_ADDSTRING,0,(long)STRING_SORT_DESCENDING);

			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&LVS_SORTASCENDING) SendDlgItemMessage(hwnd,IDC_LVS_SORT,CB_SETCURSEL,1,0);
			else if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&LVS_SORTDESCENDING) SendDlgItemMessage(hwnd,IDC_LVS_SORT,CB_SETCURSEL,2,0);
			else SendDlgItemMessage(hwnd,IDC_LVS_SORT,CB_SETCURSEL,0,0);

			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&LVS_SINGLESEL) SendDlgItemMessage(hwnd,IDC_LVS_SINGLESEL,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&LVS_AUTOARRANGE) SendDlgItemMessage(hwnd,IDC_LVS_AUTOARRANGE,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&LVS_NOLABELWRAP) SendDlgItemMessage(hwnd,IDC_LVS_NOLABELWRAP,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&LVS_EDITLABELS) SendDlgItemMessage(hwnd,IDC_LVS_EDITLABELS,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&LVS_NOSCROLL) SendDlgItemMessage(hwnd,IDC_LVS_NOSCROLL,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&LVS_NOCOLUMNHEADER) SendDlgItemMessage(hwnd,IDC_LVS_NOCOLUMNHEADER,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&LVS_NOSORTHEADER) SendDlgItemMessage(hwnd,IDC_LVS_NOSORTHEADER,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&LVS_SHOWSELALWAYS) SendDlgItemMessage(hwnd,IDC_LVS_SHOWSELALWAYS,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&LVS_OWNERDRAWFIXED) SendDlgItemMessage(hwnd,IDC_LVS_OWNERDRAWFIXED,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&LVS_SHAREIMAGELISTS) SendDlgItemMessage(hwnd,IDC_LVS_SHAREIMAGELISTS,BM_SETCHECK,BST_CHECKED,0);


			bInitial=0;
			break;
		case WM_COMMAND:

			i=GetWndNum(GetParent(GetParent(hwnd)));
			if(i==-1) return 1;
			i2=GetWndInfoNum(MdiInfo[i].path);

			//ʃX^C
			if(bInitial==0){
				if(DefaultItemStyles(hwnd,i,i2,wParam)) return 1;
			}

			switch(LOWORD(wParam)){
				case IDC_LVS_VIEW:
					if(HIWORD(wParam)==CBN_SELCHANGE){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						i3=SendDlgItemMessage(hwnd,IDC_LVS_VIEW,CB_GETCURSEL,0,0);
						ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~(LVS_SMALLICON|LVS_LIST|LVS_REPORT);
						if(i3==1) ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=LVS_SMALLICON;
						else if(i3==2) ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=LVS_LIST;
						else if(i3==3) ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=LVS_REPORT;
						DrawRadWindow(i,&ProjectInfo.pWindowInfo[i2]);
						return 1;
					}
					break;
				case IDC_LVS_POSITION:
					if(HIWORD(wParam)==CBN_SELCHANGE){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						i3=SendDlgItemMessage(hwnd,IDC_LVS_POSITION,CB_GETCURSEL,0,0);
						ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~(LVS_ALIGNLEFT);
						if(i3==1) ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=LVS_ALIGNLEFT;
						return 1;
					}
					break;
				case IDC_LVS_SORT:
					if(HIWORD(wParam)==CBN_SELCHANGE){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						i3=SendDlgItemMessage(hwnd,IDC_LVS_SORT,CB_GETCURSEL,0,0);
						ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~(LVS_SORTASCENDING|LVS_SORTDESCENDING);
						if(i3==1) ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=LVS_SORTASCENDING;
						else if(i3==2) ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=LVS_SORTDESCENDING;
						return 1;
					}
					break;

				case IDC_LVS_SINGLESEL:
					if(HIWORD(wParam)==BN_CLICKED){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						if(SendDlgItemMessage(hwnd,IDC_LVS_SINGLESEL,BM_GETCHECK,0,0))
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=LVS_SINGLESEL;
						else
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~LVS_SINGLESEL;
						return 1;
					}
					break;
				case IDC_LVS_AUTOARRANGE:
					if(HIWORD(wParam)==BN_CLICKED){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						if(SendDlgItemMessage(hwnd,IDC_LVS_AUTOARRANGE,BM_GETCHECK,0,0))
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=LVS_AUTOARRANGE;
						else
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~LVS_AUTOARRANGE;
						return 1;
					}
					break;
				case IDC_LVS_NOLABELWRAP:
					if(HIWORD(wParam)==BN_CLICKED){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						if(SendDlgItemMessage(hwnd,IDC_LVS_NOLABELWRAP,BM_GETCHECK,0,0))
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=LVS_NOLABELWRAP;
						else
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~LVS_NOLABELWRAP;
						return 1;
					}
					break;
				case IDC_LVS_EDITLABELS:
					if(HIWORD(wParam)==BN_CLICKED){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						if(SendDlgItemMessage(hwnd,IDC_LVS_EDITLABELS,BM_GETCHECK,0,0))
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=LVS_EDITLABELS;
						else
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~LVS_EDITLABELS;
						return 1;
					}
					break;
				case IDC_LVS_NOSCROLL:
					if(HIWORD(wParam)==BN_CLICKED){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						if(SendDlgItemMessage(hwnd,IDC_LVS_NOSCROLL,BM_GETCHECK,0,0))
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=LVS_NOSCROLL;
						else
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~LVS_NOSCROLL;
						DrawRadWindow(i,&ProjectInfo.pWindowInfo[i2]);
						return 1;
					}
					break;
				case IDC_LVS_NOCOLUMNHEADER:
					if(HIWORD(wParam)==BN_CLICKED){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						if(SendDlgItemMessage(hwnd,IDC_LVS_NOCOLUMNHEADER,BM_GETCHECK,0,0))
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=LVS_NOCOLUMNHEADER;
						else
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~LVS_NOCOLUMNHEADER;
						return 1;
					}
					break;
				case IDC_LVS_NOSORTHEADER:
					if(HIWORD(wParam)==BN_CLICKED){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						if(SendDlgItemMessage(hwnd,IDC_LVS_NOSORTHEADER,BM_GETCHECK,0,0))
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=LVS_NOSORTHEADER;
						else
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~LVS_NOSORTHEADER;
						return 1;
					}
					break;
				case IDC_LVS_SHOWSELALWAYS:
					if(HIWORD(wParam)==BN_CLICKED){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						if(SendDlgItemMessage(hwnd,IDC_LVS_SHOWSELALWAYS,BM_GETCHECK,0,0))
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=LVS_SHOWSELALWAYS;
						else
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~LVS_SHOWSELALWAYS;
						return 1;
					}
					break;
				case IDC_LVS_OWNERDRAWFIXED:
					if(HIWORD(wParam)==BN_CLICKED){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						if(SendDlgItemMessage(hwnd,IDC_LVS_OWNERDRAWFIXED,BM_GETCHECK,0,0))
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=LVS_OWNERDRAWFIXED;
						else
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~LVS_OWNERDRAWFIXED;
						return 1;
					}
					break;
				case IDC_LVS_SHAREIMAGELISTS:
					if(HIWORD(wParam)==BN_CLICKED){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						if(SendDlgItemMessage(hwnd,IDC_LVS_SHAREIMAGELISTS,BM_GETCHECK,0,0))
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=LVS_SHAREIMAGELISTS;
						else
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~LVS_SHAREIMAGELISTS;
						return 1;
					}
					break;

				case IDC_EXSTYLE:
					if(!DialogBox(hResInst,MAKEINTRESOURCE(IDD_RAD_PROP_ITEM_EXSTYLE),hwnd,(DLGPROC)DlgRadProperty_Item_ExStyle)) return 1;
					DrawRadWindow(i,&ProjectInfo.pWindowInfo[i2]);
					return 1;
			}
			break;
	}
	return 0;
}


///////////////////////
// LISTBOX vpeB

void RadProperty_ListBox_StylingOrder(HWND hwnd,DWORD *style){
	if(*style&LBS_OWNERDRAWVARIABLE){
		*style&=~(LBS_MULTICOLUMN);
		SendDlgItemMessage(hwnd,IDC_LBS_MULTICOLUMN,BM_SETCHECK,BST_UNCHECKED,0);
		EnableWindow(GetDlgItem(hwnd,IDC_LBS_MULTICOLUMN),0);
	}
	else
		EnableWindow(GetDlgItem(hwnd,IDC_LBS_MULTICOLUMN),1);

	if(!(*style&(LBS_OWNERDRAWFIXED|LBS_OWNERDRAWVARIABLE))){
		*style&=~(LBS_HASSTRINGS);
		SendDlgItemMessage(hwnd,IDC_LBS_HASSTRINGS,BM_SETCHECK,BST_UNCHECKED,0);
		EnableWindow(GetDlgItem(hwnd,IDC_LBS_HASSTRINGS),0);
	}
	else
		EnableWindow(GetDlgItem(hwnd,IDC_LBS_HASSTRINGS),1);
}
BOOL CALLBACK RadProperty_ListBoxProc(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam){
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	extern PROJECTINFO ProjectInfo;
	int i,i2,i3;
	static BOOL bInitial;

	switch(message){
		case WM_INITDIALOG:
			bInitial=1;
			i=GetWndNum(GetParent(GetParent(hwnd)));
			i2=GetWndInfoNum(MdiInfo[i].path);

			SetDlgItemText(hwnd,IDC_IDNAME,ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].IdName);


			////////////////////////
			// X^C
			////////////

			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&WS_DISABLED) SendDlgItemMessage(hwnd,IDC_STYLE_DISABLED,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&WS_VISIBLE) SendDlgItemMessage(hwnd,IDC_STYLE_VISIBLE,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&WS_GROUP) SendDlgItemMessage(hwnd,IDC_STYLE_GROUP,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&WS_TABSTOP) SendDlgItemMessage(hwnd,IDC_STYLE_TABSTOP,BM_SETCHECK,BST_CHECKED,0);

			////////
			// I
			////////

			//"VO"
			SendDlgItemMessage(hwnd,IDC_LBS_SELECT,CB_ADDSTRING,0,(long)STRING_LISTBOXPROP_STYLE_SEL_SINGLE);
			//"}`"
			SendDlgItemMessage(hwnd,IDC_LBS_SELECT,CB_ADDSTRING,0,(long)STRING_LISTBOXPROP_STYLE_SEL_MULTI);
			//"g"
			SendDlgItemMessage(hwnd,IDC_LBS_SELECT,CB_ADDSTRING,0,(long)STRING_LISTBOXPROP_STYLE_SEL_EXTENDED);
			//"Ȃ"
			SendDlgItemMessage(hwnd,IDC_LBS_SELECT,CB_ADDSTRING,0,(long)STRING_NONE_);

			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&LBS_MULTIPLESEL) SendDlgItemMessage(hwnd,IDC_LBS_SELECT,CB_SETCURSEL,1,0);
			else if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&LBS_EXTENDEDSEL) SendDlgItemMessage(hwnd,IDC_LBS_SELECT,CB_SETCURSEL,2,0);
			else if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&LBS_NOSEL) SendDlgItemMessage(hwnd,IDC_LBS_SELECT,CB_SETCURSEL,3,0);
			else SendDlgItemMessage(hwnd,IDC_LBS_SELECT,CB_SETCURSEL,0,0);


			////////////////
			// I[i[`
			////////////////

			//"Ȃ"
			SendDlgItemMessage(hwnd,IDC_LBS_OWNERDRAW,CB_ADDSTRING,0,(long)STRING_NONE_);
			//"Œ"
			SendDlgItemMessage(hwnd,IDC_LBS_OWNERDRAW,CB_ADDSTRING,0,(long)STRING_OWNERDRAW_FIXED);
			//""
			SendDlgItemMessage(hwnd,IDC_LBS_OWNERDRAW,CB_ADDSTRING,0,(long)STRING_OWNERDRAW_VARIABLE);

			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&LBS_OWNERDRAWFIXED) SendDlgItemMessage(hwnd,IDC_LBS_OWNERDRAW,CB_SETCURSEL,1,0);
			else if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&LBS_OWNERDRAWVARIABLE) SendDlgItemMessage(hwnd,IDC_LBS_OWNERDRAW,CB_SETCURSEL,2,0);
			else SendDlgItemMessage(hwnd,IDC_LBS_OWNERDRAW,CB_SETCURSEL,0,0);

			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&LBS_HASSTRINGS) SendDlgItemMessage(hwnd,IDC_LBS_HASSTRINGS,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&LBS_SORT) SendDlgItemMessage(hwnd,IDC_LBS_SORT,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&LBS_NOTIFY) SendDlgItemMessage(hwnd,IDC_LBS_NOTIFY,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&LBS_MULTICOLUMN) SendDlgItemMessage(hwnd,IDC_LBS_MULTICOLUMN,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&WS_HSCROLL) SendDlgItemMessage(hwnd,IDC_STYLE_HSCROLL,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&WS_VSCROLL) SendDlgItemMessage(hwnd,IDC_STYLE_VSCROLL,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&LBS_DISABLENOSCROLL) SendDlgItemMessage(hwnd,IDC_LBS_DISABLENOSCROLL,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&LBS_NOREDRAW) SendDlgItemMessage(hwnd,IDC_LBS_NOREDRAW,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&LBS_USETABSTOPS) SendDlgItemMessage(hwnd,IDC_LBS_USETABSTOPS,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&LBS_WANTKEYBOARDINPUT) SendDlgItemMessage(hwnd,IDC_LBS_WANTKEYBOARDINPUT,BM_SETCHECK,BST_CHECKED,0);

			RadProperty_ListBox_StylingOrder(hwnd,&ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);


			bInitial=0;
			break;
		case WM_COMMAND:

			i=GetWndNum(GetParent(GetParent(hwnd)));
			if(i==-1) return 1;
			i2=GetWndInfoNum(MdiInfo[i].path);

			//ʃX^C
			if(bInitial==0){
				if(DefaultItemStyles(hwnd,i,i2,wParam)) return 1;
			}

			switch(LOWORD(wParam)){
				case IDC_LBS_SELECT:
					if(HIWORD(wParam)==CBN_SELCHANGE){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						i3=SendDlgItemMessage(hwnd,IDC_LBS_SELECT,CB_GETCURSEL,0,0);
						ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~(LBS_MULTIPLESEL|LBS_EXTENDEDSEL|LBS_NOSEL);
						if(i3==1) ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=LBS_MULTIPLESEL;
						else if(i3==2) ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=LBS_EXTENDEDSEL;
						else if(i3==3) ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=LBS_NOSEL;
						return 1;
					}
					break;
				case IDC_LBS_OWNERDRAW:
					if(HIWORD(wParam)==CBN_SELCHANGE){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						i3=SendDlgItemMessage(hwnd,IDC_LBS_OWNERDRAW,CB_GETCURSEL,0,0);
						ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~(LBS_OWNERDRAWFIXED|LBS_OWNERDRAWVARIABLE);
						if(i3==1) ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=LBS_OWNERDRAWFIXED;
						else if(i3==2) ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=LBS_OWNERDRAWVARIABLE;

						RadProperty_ListBox_StylingOrder(hwnd,&ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);
						return 1;
					}
					break;

				case IDC_LBS_HASSTRINGS:
					if(HIWORD(wParam)==BN_CLICKED){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						if(SendDlgItemMessage(hwnd,IDC_LBS_HASSTRINGS,BM_GETCHECK,0,0))
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=LBS_HASSTRINGS;
						else
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~LBS_HASSTRINGS;
						return 1;
					}
					break;
				case IDC_LBS_SORT:
					if(HIWORD(wParam)==BN_CLICKED){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						if(SendDlgItemMessage(hwnd,IDC_LBS_SORT,BM_GETCHECK,0,0))
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=LBS_SORT;
						else
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~LBS_SORT;
						return 1;
					}
					break;
				case IDC_LBS_NOTIFY:
					if(HIWORD(wParam)==BN_CLICKED){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						if(SendDlgItemMessage(hwnd,IDC_LBS_NOTIFY,BM_GETCHECK,0,0))
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=LBS_NOTIFY;
						else
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~LBS_NOTIFY;
						return 1;
					}
					break;
				case IDC_LBS_MULTICOLUMN:
					if(HIWORD(wParam)==BN_CLICKED){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						if(SendDlgItemMessage(hwnd,IDC_LBS_MULTICOLUMN,BM_GETCHECK,0,0))
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=LBS_MULTICOLUMN;
						else
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~LBS_MULTICOLUMN;
						return 1;
					}
					break;
				case IDC_STYLE_HSCROLL:
					if(HIWORD(wParam)==BN_CLICKED){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						if(SendDlgItemMessage(hwnd,IDC_STYLE_HSCROLL,BM_GETCHECK,0,0))
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=WS_HSCROLL;
						else
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~WS_HSCROLL;
						DrawRadWindow(i,&ProjectInfo.pWindowInfo[i2]);
						return 1;
					}
					break;
				case IDC_STYLE_VSCROLL:
					if(HIWORD(wParam)==BN_CLICKED){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						if(SendDlgItemMessage(hwnd,IDC_STYLE_VSCROLL,BM_GETCHECK,0,0))
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=WS_VSCROLL;
						else
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~WS_VSCROLL;
						DrawRadWindow(i,&ProjectInfo.pWindowInfo[i2]);
						return 1;
					}
					break;
				case IDC_LBS_DISABLENOSCROLL:
					if(HIWORD(wParam)==BN_CLICKED){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						if(SendDlgItemMessage(hwnd,IDC_LBS_DISABLENOSCROLL,BM_GETCHECK,0,0))
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=LBS_DISABLENOSCROLL;
						else
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~LBS_DISABLENOSCROLL;
						DrawRadWindow(i,&ProjectInfo.pWindowInfo[i2]);
						return 1;
					}
					break;
				case IDC_LBS_NOREDRAW:
					if(HIWORD(wParam)==BN_CLICKED){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						if(SendDlgItemMessage(hwnd,IDC_LBS_NOREDRAW,BM_GETCHECK,0,0))
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=LBS_NOREDRAW;
						else
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~LBS_NOREDRAW;
						return 1;
					}
					break;
				case IDC_LBS_USETABSTOPS:
					if(HIWORD(wParam)==BN_CLICKED){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						if(SendDlgItemMessage(hwnd,IDC_LBS_USETABSTOPS,BM_GETCHECK,0,0))
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=LBS_USETABSTOPS;
						else
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~LBS_USETABSTOPS;
						return 1;
					}
					break;
				case IDC_LBS_WANTKEYBOARDINPUT:
					if(HIWORD(wParam)==BN_CLICKED){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						if(SendDlgItemMessage(hwnd,IDC_LBS_WANTKEYBOARDINPUT,BM_GETCHECK,0,0))
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=LBS_WANTKEYBOARDINPUT;
						else
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~LBS_WANTKEYBOARDINPUT;
						return 1;
					}
					break;

				case IDC_EXSTYLE:
					if(!DialogBox(hResInst,MAKEINTRESOURCE(IDD_RAD_PROP_ITEM_EXSTYLE),hwnd,(DLGPROC)DlgRadProperty_Item_ExStyle)) return 1;
					DrawRadWindow(i,&ProjectInfo.pWindowInfo[i2]);
					return 1;
			}
			break;
	}
	return 0;
}


///////////////////////////
// PROGRESSBAR vpeB
BOOL CALLBACK RadProperty_ProgressBarProc(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam){
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	extern PROJECTINFO ProjectInfo;
	int i,i2;
	static BOOL bInitial;

	switch(message){
		case WM_INITDIALOG:
			bInitial=1;
			i=GetWndNum(GetParent(GetParent(hwnd)));
			i2=GetWndInfoNum(MdiInfo[i].path);

			SetDlgItemText(hwnd,IDC_IDNAME,ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].IdName);
			SetDlgItemText(hwnd,IDC_CAPTION,ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].caption);


			////////////
			//X^C

			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&WS_DISABLED) SendDlgItemMessage(hwnd,IDC_STYLE_DISABLED,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&WS_VISIBLE) SendDlgItemMessage(hwnd,IDC_STYLE_VISIBLE,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&WS_GROUP) SendDlgItemMessage(hwnd,IDC_STYLE_GROUP,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&WS_TABSTOP) SendDlgItemMessage(hwnd,IDC_STYLE_TABSTOP,BM_SETCHECK,BST_CHECKED,0);

			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&PBS_VERTICAL) SendDlgItemMessage(hwnd,IDC_PBS_VERTICAL,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&PBS_SMOOTH) SendDlgItemMessage(hwnd,IDC_PBS_SMOOTH,BM_SETCHECK,BST_CHECKED,0);


			bInitial=0;
			break;
		case WM_COMMAND:

			i=GetWndNum(GetParent(GetParent(hwnd)));
			if(i==-1) return 1;
			i2=GetWndInfoNum(MdiInfo[i].path);

			//ʃX^C
			if(bInitial==0){
				if(DefaultItemStyles(hwnd,i,i2,wParam)) return 1;
			}

			switch(LOWORD(wParam)){
				case IDC_PBS_VERTICAL:
					if(HIWORD(wParam)==BN_CLICKED){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						if(SendDlgItemMessage(hwnd,IDC_PBS_VERTICAL,BM_GETCHECK,0,0))
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=PBS_VERTICAL;
						else
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~PBS_VERTICAL;
						DrawRadWindow(i,&ProjectInfo.pWindowInfo[i2]);
						return 1;
					}
					break;
				case IDC_PBS_SMOOTH:
					if(HIWORD(wParam)==BN_CLICKED){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						if(SendDlgItemMessage(hwnd,IDC_PBS_SMOOTH,BM_GETCHECK,0,0))
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=PBS_SMOOTH;
						else
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~PBS_SMOOTH;
						DrawRadWindow(i,&ProjectInfo.pWindowInfo[i2]);
						return 1;
					}
					break;

				case IDC_EXSTYLE:
					if(!DialogBox(hResInst,MAKEINTRESOURCE(IDD_RAD_PROP_ITEM_EXSTYLE),hwnd,(DLGPROC)DlgRadProperty_Item_ExStyle)) return 1;
					DrawRadWindow(i,&ProjectInfo.pWindowInfo[i2]);
					return 1;
			}
	}
	return 0;
}


///////////////////////////
// RADIOBUTTON vpeB

BOOL CALLBACK RadProperty_RadioButtonProc(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam){
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	extern PROJECTINFO ProjectInfo;
	int i,i2,i3;
	static BOOL bInitial;

	switch(message){
		case WM_INITDIALOG:
			bInitial=1;
			i=GetWndNum(GetParent(GetParent(hwnd)));
			i2=GetWndInfoNum(MdiInfo[i].path);

			SetDlgItemText(hwnd,IDC_IDNAME,ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].IdName);
			SetDlgItemText(hwnd,IDC_CAPTION,ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].caption);


			/////////////////////////
			// X^C
			////////////

			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&WS_DISABLED) SendDlgItemMessage(hwnd,IDC_STYLE_DISABLED,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&WS_VISIBLE) SendDlgItemMessage(hwnd,IDC_STYLE_VISIBLE,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&WS_GROUP) SendDlgItemMessage(hwnd,IDC_STYLE_GROUP,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&WS_TABSTOP) SendDlgItemMessage(hwnd,IDC_STYLE_TABSTOP,BM_SETCHECK,BST_CHECKED,0);

			if((ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&BS_AUTORADIOBUTTON)==BS_AUTORADIOBUTTON) SendDlgItemMessage(hwnd,IDC_BS_AUTO,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&BS_PUSHLIKE) SendDlgItemMessage(hwnd,IDC_BS_PUSHLIKE,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&BS_LEFTTEXT) SendDlgItemMessage(hwnd,IDC_BS_LEFTTEXT,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&BS_ICON) SendDlgItemMessage(hwnd,IDC_BS_ICON,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&BS_BITMAP) SendDlgItemMessage(hwnd,IDC_BS_BITMAP,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&BS_MULTILINE) SendDlgItemMessage(hwnd,IDC_BS_MULTILINE,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&BS_NOTIFY) SendDlgItemMessage(hwnd,IDC_BS_NOTIFY,BM_SETCHECK,BST_CHECKED,0);


			//////////////////
			// ̔zu
			//////////////////

			//"ftHg"
			SendDlgItemMessage(hwnd,IDC_BS_HPOS,CB_ADDSTRING,0,(long)STRING_DEFAULT);
			//"["
			SendDlgItemMessage(hwnd,IDC_BS_HPOS,CB_ADDSTRING,0,(long)STRING_LEFT);
			//"E["
			SendDlgItemMessage(hwnd,IDC_BS_HPOS,CB_ADDSTRING,0,(long)STRING_RIGHT);
			//""
			SendDlgItemMessage(hwnd,IDC_BS_HPOS,CB_ADDSTRING,0,(long)STRING_CENTER);

			//rbglBS_CENTERŏɔr
			if((ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&BS_CENTER)==BS_CENTER) SendDlgItemMessage(hwnd,IDC_BS_HPOS,CB_SETCURSEL,3,0);
			else if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&BS_LEFT) SendDlgItemMessage(hwnd,IDC_BS_HPOS,CB_SETCURSEL,1,0);
			else if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&BS_RIGHT) SendDlgItemMessage(hwnd,IDC_BS_HPOS,CB_SETCURSEL,2,0);
			else SendDlgItemMessage(hwnd,IDC_BS_HPOS,CB_SETCURSEL,0,0);


			//////////////////
			// ̔zu
			//////////////////

			//"ftHg"
			SendDlgItemMessage(hwnd,IDC_BS_VPOS,CB_ADDSTRING,0,(long)STRING_DEFAULT);
			//"["
			SendDlgItemMessage(hwnd,IDC_BS_VPOS,CB_ADDSTRING,0,(long)STRING_TOP);
			//"["
			SendDlgItemMessage(hwnd,IDC_BS_VPOS,CB_ADDSTRING,0,(long)STRING_BOTTOM);
			//""
			SendDlgItemMessage(hwnd,IDC_BS_VPOS,CB_ADDSTRING,0,(long)STRING_CENTER);

			//rbglBS_VCENTERŏɔr
			if((ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&BS_VCENTER)==BS_VCENTER) SendDlgItemMessage(hwnd,IDC_BS_VPOS,CB_SETCURSEL,3,0);
			else if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&BS_TOP) SendDlgItemMessage(hwnd,IDC_BS_VPOS,CB_SETCURSEL,1,0);
			else if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&BS_BOTTOM) SendDlgItemMessage(hwnd,IDC_BS_VPOS,CB_SETCURSEL,2,0);
			else SendDlgItemMessage(hwnd,IDC_BS_VPOS,CB_SETCURSEL,0,0);


			bInitial=0;
			break;
		case WM_COMMAND:

			i=GetWndNum(GetParent(GetParent(hwnd)));
			if(i==-1) return 1;
			i2=GetWndInfoNum(MdiInfo[i].path);

			//ʃX^C
			if(bInitial==0){
				if(DefaultItemStyles(hwnd,i,i2,wParam)) return 1;
			}

			switch(LOWORD(wParam)){
				case IDC_BS_AUTO:
					if(HIWORD(wParam)==BN_CLICKED){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						if(SendDlgItemMessage(hwnd,IDC_BS_AUTO,BM_GETCHECK,0,0)){
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=0xFFFFFFF0;
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=BS_AUTORADIOBUTTON;
						}
						else{
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=0xFFFFFFF0;
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=BS_RADIOBUTTON;
						}
						return 1;
					}
					break;
				case IDC_BS_PUSHLIKE:
					if(HIWORD(wParam)==BN_CLICKED){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						if(SendDlgItemMessage(hwnd,IDC_BS_PUSHLIKE,BM_GETCHECK,0,0))
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=BS_PUSHLIKE;
						else
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~BS_PUSHLIKE;
						DrawRadWindow(i,&ProjectInfo.pWindowInfo[i2]);
						return 1;
					}
					break;
				case IDC_BS_LEFTTEXT:
					if(HIWORD(wParam)==BN_CLICKED){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						if(SendDlgItemMessage(hwnd,IDC_BS_LEFTTEXT,BM_GETCHECK,0,0))
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=BS_LEFTTEXT;
						else
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~BS_LEFTTEXT;
						DrawRadWindow(i,&ProjectInfo.pWindowInfo[i2]);
						return 1;
					}
					break;
				case IDC_BS_ICON:
					if(HIWORD(wParam)==BN_CLICKED){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						if(SendDlgItemMessage(hwnd,IDC_BS_ICON,BM_GETCHECK,0,0)){
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=BS_ICON;
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~BS_BITMAP;
							SendDlgItemMessage(hwnd,IDC_BS_BITMAP,BM_SETCHECK,BST_UNCHECKED,0);
						}
						else
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~BS_ICON;
						DrawRadWindow(i,&ProjectInfo.pWindowInfo[i2]);
						return 1;
					}
					break;
				case IDC_BS_BITMAP:
					if(HIWORD(wParam)==BN_CLICKED){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						if(SendDlgItemMessage(hwnd,IDC_BS_BITMAP,BM_GETCHECK,0,0)){
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=BS_BITMAP;
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~BS_ICON;
							SendDlgItemMessage(hwnd,IDC_BS_ICON,BM_SETCHECK,BST_UNCHECKED,0);
						}
						else
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~BS_BITMAP;
						DrawRadWindow(i,&ProjectInfo.pWindowInfo[i2]);
						return 1;
					}
					break;
				case IDC_BS_MULTILINE:
					if(HIWORD(wParam)==BN_CLICKED){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						if(SendDlgItemMessage(hwnd,IDC_BS_MULTILINE,BM_GETCHECK,0,0))
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=BS_MULTILINE;
						else
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~BS_MULTILINE;
						DrawRadWindow(i,&ProjectInfo.pWindowInfo[i2]);
						return 1;
					}
					break;
				case IDC_BS_NOTIFY:
					if(HIWORD(wParam)==BN_CLICKED){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						if(SendDlgItemMessage(hwnd,IDC_BS_NOTIFY,BM_GETCHECK,0,0))
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=BS_NOTIFY;
						else
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~BS_NOTIFY;
						return 1;
					}
					break;

				case IDC_BS_HPOS:
					if(HIWORD(wParam)==CBN_SELCHANGE){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						i3=SendDlgItemMessage(hwnd,IDC_BS_HPOS,CB_GETCURSEL,0,0);
						ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~(BS_LEFT|BS_RIGHT|BS_CENTER);
						if(i3==1) ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=BS_LEFT;
						else if(i3==2) ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=BS_RIGHT;
						else if(i3==3) ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=BS_CENTER;
						DrawRadWindow(i,&ProjectInfo.pWindowInfo[i2]);
						return 1;
					}
					break;
				case IDC_BS_VPOS:
					if(HIWORD(wParam)==CBN_SELCHANGE){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						i3=SendDlgItemMessage(hwnd,IDC_BS_VPOS,CB_GETCURSEL,0,0);
						ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~(BS_TOP|BS_BOTTOM|BS_VCENTER);
						if(i3==1) ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=BS_TOP;
						else if(i3==2) ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=BS_BOTTOM;
						else if(i3==3) ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=BS_VCENTER;
						DrawRadWindow(i,&ProjectInfo.pWindowInfo[i2]);
						return 1;
					}
					break;

				case IDC_EXSTYLE:
					if(!DialogBox(hResInst,MAKEINTRESOURCE(IDD_RAD_PROP_ITEM_EXSTYLE),hwnd,(DLGPROC)DlgRadProperty_Item_ExStyle)) return 1;
					DrawRadWindow(i,&ProjectInfo.pWindowInfo[i2]);
					return 1;
			}
			break;
	}
	return 0;
}


/////////////////////////
// SCROLLBAR vpeB

BOOL CALLBACK RadProperty_ScrollBarProc(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam){
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	extern PROJECTINFO ProjectInfo;
	int i,i2,i3;
	static BOOL bInitial;

	switch(message){
		case WM_INITDIALOG:
			bInitial=1;
			i=GetWndNum(GetParent(GetParent(hwnd)));
			i2=GetWndInfoNum(MdiInfo[i].path);

			SetDlgItemText(hwnd,IDC_IDNAME,ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].IdName);


			////////////////////////
			// X^C
			////////////

			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&WS_DISABLED) SendDlgItemMessage(hwnd,IDC_STYLE_DISABLED,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&WS_VISIBLE) SendDlgItemMessage(hwnd,IDC_STYLE_VISIBLE,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&WS_GROUP) SendDlgItemMessage(hwnd,IDC_STYLE_GROUP,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&WS_TABSTOP) SendDlgItemMessage(hwnd,IDC_STYLE_TABSTOP,BM_SETCHECK,BST_CHECKED,0);


			////////
			// zu
			////////

			//"w薳"
			SendDlgItemMessage(hwnd,IDC_SBS_POSITION,CB_ADDSTRING,0,(long)STRING_SCROLLBARPROP_STYLE_FREE);
			//"/"
			SendDlgItemMessage(hwnd,IDC_SBS_POSITION,CB_ADDSTRING,0,(long)STRING_SCROLLBARPROP_STYLE_TOPORLEFT);
			//"/E"
			SendDlgItemMessage(hwnd,IDC_SBS_POSITION,CB_ADDSTRING,0,(long)STRING_SCROLLBARPROP_STYLE_BOTTOMORRIGHT);

			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&SBS_TOPALIGN) SendDlgItemMessage(hwnd,IDC_SBS_POSITION,CB_SETCURSEL,1,0);
			else if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&SBS_BOTTOMALIGN) SendDlgItemMessage(hwnd,IDC_SBS_POSITION,CB_SETCURSEL,2,0);
			else SendDlgItemMessage(hwnd,IDC_SBS_POSITION,CB_SETCURSEL,0,0);


			bInitial=0;
			break;
		case WM_COMMAND:

			i=GetWndNum(GetParent(GetParent(hwnd)));
			if(i==-1) return 1;
			i2=GetWndInfoNum(MdiInfo[i].path);

			//ʃX^C
			if(bInitial==0){
				if(DefaultItemStyles(hwnd,i,i2,wParam)) return 1;
			}

			switch(LOWORD(wParam)){
				case IDC_SBS_POSITION:
					if(HIWORD(wParam)==CBN_SELCHANGE){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						i3=SendDlgItemMessage(hwnd,IDC_SBS_POSITION,CB_GETCURSEL,0,0);
						ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~(SBS_TOPALIGN|SBS_BOTTOMALIGN);
						if(i3==1) ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=SBS_TOPALIGN;
						else if(i3==2) ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=SBS_BOTTOMALIGN;
						return 1;
					}
					break;

				case IDC_EXSTYLE:
					if(!DialogBox(hResInst,MAKEINTRESOURCE(IDD_RAD_PROP_ITEM_EXSTYLE),hwnd,(DLGPROC)DlgRadProperty_Item_ExStyle)) return 1;
					DrawRadWindow(i,&ProjectInfo.pWindowInfo[i2]);
					return 1;
			}
			break;
	}
	return 0;
}


//////////////////////
// STATIC vpeB

BOOL CALLBACK RadProperty_StaticProc(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam){
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	extern PROJECTINFO ProjectInfo;
	int i,i2,i3;
	static BOOL bInitial;

	switch(message){
		case WM_INITDIALOG:
			bInitial=1;
			i=GetWndNum(GetParent(GetParent(hwnd)));
			i2=GetWndInfoNum(MdiInfo[i].path);

			SetDlgItemText(hwnd,IDC_IDNAME,ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].IdName);
			SetDlgItemText(hwnd,IDC_CAPTION,ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].caption);


			////////////////////////
			// X^C
			////////////

			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&WS_DISABLED) SendDlgItemMessage(hwnd,IDC_STYLE_DISABLED,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&WS_VISIBLE) SendDlgItemMessage(hwnd,IDC_STYLE_VISIBLE,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&WS_GROUP) SendDlgItemMessage(hwnd,IDC_STYLE_GROUP,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&WS_TABSTOP) SendDlgItemMessage(hwnd,IDC_STYLE_TABSTOP,BM_SETCHECK,BST_CHECKED,0);

			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&SS_NOPREFIX) SendDlgItemMessage(hwnd,IDC_SS_NOPREFIX,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&SS_LEFTNOWORDWRAP) SendDlgItemMessage(hwnd,IDC_SS_LEFTNOWORDWRAP,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&SS_NOTIFY) SendDlgItemMessage(hwnd,IDC_SS_NOTIFY,BM_SETCHECK,BST_CHECKED,0);


			//////////////////
			// eLXg̔zu
			//////////////////

			//"["
			SendDlgItemMessage(hwnd,IDC_SS_TEXTPOS,CB_ADDSTRING,0,(long)STRING_LEFT);
			//""
			SendDlgItemMessage(hwnd,IDC_SS_TEXTPOS,CB_ADDSTRING,0,(long)STRING_CENTER);
			//"E["
			SendDlgItemMessage(hwnd,IDC_SS_TEXTPOS,CB_ADDSTRING,0,(long)STRING_RIGHT);

			//rbglSS_LEFTŌɌ
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&SS_CENTER) SendDlgItemMessage(hwnd,IDC_SS_TEXTPOS,CB_SETCURSEL,1,0);
			else if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&SS_RIGHT) SendDlgItemMessage(hwnd,IDC_SS_TEXTPOS,CB_SETCURSEL,2,0);
			else SendDlgItemMessage(hwnd,IDC_SS_TEXTPOS,CB_SETCURSEL,0,0);


			bInitial=0;
			break;
		case WM_COMMAND:

			i=GetWndNum(GetParent(GetParent(hwnd)));
			if(i==-1) return 1;
			i2=GetWndInfoNum(MdiInfo[i].path);

			//ʃX^C
			if(bInitial==0){
				if(DefaultItemStyles(hwnd,i,i2,wParam)) return 1;
			}

			switch(LOWORD(wParam)){
				case IDC_SS_NOPREFIX:
					if(HIWORD(wParam)==BN_CLICKED){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						if(SendDlgItemMessage(hwnd,IDC_SS_NOPREFIX,BM_GETCHECK,0,0))
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=SS_NOPREFIX;
						else
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~SS_NOPREFIX;
						return 1;
					}
					break;
				case IDC_SS_LEFTNOWORDWRAP:
					if(HIWORD(wParam)==BN_CLICKED){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						if(SendDlgItemMessage(hwnd,IDC_SS_LEFTNOWORDWRAP,BM_GETCHECK,0,0))
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=SS_LEFTNOWORDWRAP;
						else
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~SS_LEFTNOWORDWRAP;

						DrawRadWindow(i,&ProjectInfo.pWindowInfo[i2]);
						return 1;
					}
					break;
				case IDC_SS_NOTIFY:
					if(HIWORD(wParam)==BN_CLICKED){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						if(SendDlgItemMessage(hwnd,IDC_SS_NOTIFY,BM_GETCHECK,0,0))
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=SS_NOTIFY;
						else
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~SS_NOTIFY;
						return 1;
					}
					break;

				case IDC_SS_TEXTPOS:
					if(HIWORD(wParam)==CBN_SELCHANGE){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						i3=SendDlgItemMessage(hwnd,IDC_SS_TEXTPOS,CB_GETCURSEL,0,0);
						//SS_LEFT=0
						ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~(SS_CENTER|SS_RIGHT);
						if(i3==1) ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=SS_CENTER;
						else if(i3==2) ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=SS_RIGHT;
						DrawRadWindow(i,&ProjectInfo.pWindowInfo[i2]);
						return 1;
					}
					break;

				case IDC_EXSTYLE:
					if(!DialogBox(hResInst,MAKEINTRESOURCE(IDD_RAD_PROP_ITEM_EXSTYLE),hwnd,(DLGPROC)DlgRadProperty_Item_ExStyle)) return 1;
					DrawRadWindow(i,&ProjectInfo.pWindowInfo[i2]);
					return 1;
			}
			break;
	}
	return 0;
}


////////////////////////
// TRACKBAR vpeB
BOOL CALLBACK RadProperty_TrackBarProc(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam){
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	extern PROJECTINFO ProjectInfo;
	int i,i2,i3;
	static BOOL bInitial;

	switch(message){
		case WM_INITDIALOG:
			bInitial=1;
			i=GetWndNum(GetParent(GetParent(hwnd)));
			i2=GetWndInfoNum(MdiInfo[i].path);

			SetDlgItemText(hwnd,IDC_IDNAME,ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].IdName);


			///////////////////////////
			// X^C
			////////////

			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&WS_DISABLED) SendDlgItemMessage(hwnd,IDC_STYLE_DISABLED,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&WS_VISIBLE) SendDlgItemMessage(hwnd,IDC_STYLE_VISIBLE,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&WS_GROUP) SendDlgItemMessage(hwnd,IDC_STYLE_GROUP,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&WS_TABSTOP) SendDlgItemMessage(hwnd,IDC_STYLE_TABSTOP,BM_SETCHECK,BST_CHECKED,0);


			////////
			// \
			////////

			//""
			SendDlgItemMessage(hwnd,IDC_TBS_SITUATION,CB_ADDSTRING,0,(long)STRING_DIRECTION_HORIZONTAL);
			//""
			SendDlgItemMessage(hwnd,IDC_TBS_SITUATION,CB_ADDSTRING,0,(long)STRING_DIRECTION_VERTICAL);

			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&TBS_VERT) SendDlgItemMessage(hwnd,IDC_TBS_SITUATION,CB_SETCURSEL,1,0);
			else SendDlgItemMessage(hwnd,IDC_TBS_SITUATION,CB_SETCURSEL,0,0);


			////////////
			// |Cg
			////////////

			//""
			SendDlgItemMessage(hwnd,IDC_TBS_POINT,CB_ADDSTRING,0,(long)STRING_TRACKBARPROP_STYLE_POSITION_BOTH);
			//"/"
			SendDlgItemMessage(hwnd,IDC_TBS_POINT,CB_ADDSTRING,0,(long)STRING_TRACKBARPROP_STYLE_POSITION_TOPORLEFT);
			//"/E"
			SendDlgItemMessage(hwnd,IDC_TBS_POINT,CB_ADDSTRING,0,(long)STRING_TRACKBARPROP_STYLE_POSITION_BOTTOMORRIGHT);

			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&TBS_BOTH) SendDlgItemMessage(hwnd,IDC_TBS_POINT,CB_SETCURSEL,0,0);
			else if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&TBS_TOP) SendDlgItemMessage(hwnd,IDC_TBS_POINT,CB_SETCURSEL,1,0);
			else SendDlgItemMessage(hwnd,IDC_TBS_POINT,CB_SETCURSEL,2,0);

			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&TBS_NOTICKS) SendDlgItemMessage(hwnd,IDC_TBS_NOTICKS,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&TBS_AUTOTICKS) SendDlgItemMessage(hwnd,IDC_TBS_AUTOTICKS,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&TBS_ENABLESELRANGE) SendDlgItemMessage(hwnd,IDC_TBS_ENABLESELRANGE,BM_SETCHECK,BST_CHECKED,0);


			bInitial=0;
			break;
		case WM_COMMAND:

			i=GetWndNum(GetParent(GetParent(hwnd)));
			if(i==-1) return 1;
			i2=GetWndInfoNum(MdiInfo[i].path);

			//ʃX^C
			if(bInitial==0){
				if(DefaultItemStyles(hwnd,i,i2,wParam)) return 1;
			}

			switch(LOWORD(wParam)){
				case IDC_TBS_SITUATION:
					if(HIWORD(wParam)==CBN_SELCHANGE){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						i3=SendDlgItemMessage(hwnd,IDC_TBS_SITUATION,CB_GETCURSEL,0,0);
						ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~TBS_VERT;
						if(i3==1) ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=TBS_VERT;
						DrawRadWindow(i,&ProjectInfo.pWindowInfo[i2]);
						return 1;
					}
					break;
				case IDC_TBS_POINT:
					if(HIWORD(wParam)==CBN_SELCHANGE){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						i3=SendDlgItemMessage(hwnd,IDC_TBS_POINT,CB_GETCURSEL,0,0);
						ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~(TBS_BOTH|TBS_TOP);
						if(i3==0) ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=TBS_BOTH;
						else if(i3==1) ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=TBS_TOP;
						DrawRadWindow(i,&ProjectInfo.pWindowInfo[i2]);
						return 1;
					}
					break;

				case IDC_TBS_NOTICKS:
					if(HIWORD(wParam)==BN_CLICKED){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						if(SendDlgItemMessage(hwnd,IDC_TBS_NOTICKS,BM_GETCHECK,0,0))
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=TBS_NOTICKS;
						else
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~TBS_NOTICKS;
						DrawRadWindow(i,&ProjectInfo.pWindowInfo[i2]);
						return 1;
					}
					break;
				case IDC_TBS_AUTOTICKS:
					if(HIWORD(wParam)==BN_CLICKED){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						if(SendDlgItemMessage(hwnd,IDC_TBS_AUTOTICKS,BM_GETCHECK,0,0))
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=TBS_AUTOTICKS;
						else
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~TBS_AUTOTICKS;
						return 1;
					}
					break;
				case IDC_TBS_ENABLESELRANGE:
					if(HIWORD(wParam)==BN_CLICKED){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						if(SendDlgItemMessage(hwnd,IDC_TBS_ENABLESELRANGE,BM_GETCHECK,0,0))
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=TBS_ENABLESELRANGE;
						else
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~TBS_ENABLESELRANGE;
						DrawRadWindow(i,&ProjectInfo.pWindowInfo[i2]);
						return 1;
					}
					break;

				case IDC_EXSTYLE:
					if(!DialogBox(hResInst,MAKEINTRESOURCE(IDD_RAD_PROP_ITEM_EXSTYLE),hwnd,(DLGPROC)DlgRadProperty_Item_ExStyle)) return 1;
					DrawRadWindow(i,&ProjectInfo.pWindowInfo[i2]);
					return 1;
			}
			break;
	}
	return 0;
}


//////////////////////////
// TREEVIEW vpeB
BOOL CALLBACK RadProperty_TreeViewProc(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam){
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	extern PROJECTINFO ProjectInfo;
	int i,i2;
	static BOOL bInitial;

	switch(message){
		case WM_INITDIALOG:
			bInitial=1;
			i=GetWndNum(GetParent(GetParent(hwnd)));
			i2=GetWndInfoNum(MdiInfo[i].path);

			SetDlgItemText(hwnd,IDC_IDNAME,ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].IdName);


			////////////
			//X^C

			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&WS_DISABLED) SendDlgItemMessage(hwnd,IDC_STYLE_DISABLED,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&WS_VISIBLE) SendDlgItemMessage(hwnd,IDC_STYLE_VISIBLE,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&WS_GROUP) SendDlgItemMessage(hwnd,IDC_STYLE_GROUP,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&WS_TABSTOP) SendDlgItemMessage(hwnd,IDC_STYLE_TABSTOP,BM_SETCHECK,BST_CHECKED,0);

			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&TVS_HASBUTTONS) SendDlgItemMessage(hwnd,IDC_TVS_HASBUTTONS,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&TVS_HASLINES) SendDlgItemMessage(hwnd,IDC_TVS_HASLINES,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&TVS_LINESATROOT) SendDlgItemMessage(hwnd,IDC_TVS_LINESATROOT,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&TVS_EDITLABELS) SendDlgItemMessage(hwnd,IDC_TVS_EDITLABELS,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&TVS_DISABLEDRAGDROP) SendDlgItemMessage(hwnd,IDC_TVS_DISABLEDRAGDROP,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&TVS_SHOWSELALWAYS) SendDlgItemMessage(hwnd,IDC_TVS_SHOWSELALWAYS,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&TVS_NOSCROLL) SendDlgItemMessage(hwnd,IDC_TVS_NOSCROLL,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&TVS_NOTOOLTIPS) SendDlgItemMessage(hwnd,IDC_TVS_NOTOOLTIPS,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&TVS_CHECKBOXES) SendDlgItemMessage(hwnd,IDC_TVS_CHECKBOXES,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&TVS_FULLROWSELECT) SendDlgItemMessage(hwnd,IDC_TVS_FULLROWSELECT,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&TVS_TRACKSELECT) SendDlgItemMessage(hwnd,IDC_TVS_TRACKSELECT,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&TVS_SINGLEEXPAND) SendDlgItemMessage(hwnd,IDC_TVS_SINGLEEXPAND,BM_SETCHECK,BST_CHECKED,0);


			bInitial=0;
			break;
		case WM_COMMAND:

			i=GetWndNum(GetParent(GetParent(hwnd)));
			if(i==-1) return 1;
			i2=GetWndInfoNum(MdiInfo[i].path);

			//ʃX^C
			if(bInitial==0){
				if(DefaultItemStyles(hwnd,i,i2,wParam)) return 1;
			}

			switch(LOWORD(wParam)){
				case IDC_TVS_HASBUTTONS:
					if(HIWORD(wParam)==BN_CLICKED){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						if(SendDlgItemMessage(hwnd,IDC_TVS_HASBUTTONS,BM_GETCHECK,0,0))
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=TVS_HASBUTTONS;
						else
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~TVS_HASBUTTONS;
						return 1;
					}
					break;
				case IDC_TVS_HASLINES:
					if(HIWORD(wParam)==BN_CLICKED){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						if(SendDlgItemMessage(hwnd,IDC_TVS_HASLINES,BM_GETCHECK,0,0))
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=TVS_HASLINES;
						else
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~TVS_HASLINES;
						return 1;
					}
					break;
				case IDC_TVS_LINESATROOT:
					if(HIWORD(wParam)==BN_CLICKED){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						if(SendDlgItemMessage(hwnd,IDC_TVS_LINESATROOT,BM_GETCHECK,0,0))
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=TVS_LINESATROOT;
						else
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~TVS_LINESATROOT;
						return 1;
					}
					break;
				case IDC_TVS_EDITLABELS:
					if(HIWORD(wParam)==BN_CLICKED){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						if(SendDlgItemMessage(hwnd,IDC_TVS_EDITLABELS,BM_GETCHECK,0,0))
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=TVS_EDITLABELS;
						else
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~TVS_EDITLABELS;
						return 1;
					}
					break;
				case IDC_TVS_DISABLEDRAGDROP:
					if(HIWORD(wParam)==BN_CLICKED){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						if(SendDlgItemMessage(hwnd,IDC_TVS_DISABLEDRAGDROP,BM_GETCHECK,0,0))
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=TVS_DISABLEDRAGDROP;
						else
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~TVS_DISABLEDRAGDROP;
						return 1;
					}
					break;
				case IDC_TVS_SHOWSELALWAYS:
					if(HIWORD(wParam)==BN_CLICKED){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						if(SendDlgItemMessage(hwnd,IDC_TVS_SHOWSELALWAYS,BM_GETCHECK,0,0))
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=TVS_SHOWSELALWAYS;
						else
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~TVS_SHOWSELALWAYS;
						return 1;
					}
					break;
				case IDC_TVS_NOSCROLL:
					if(HIWORD(wParam)==BN_CLICKED){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						if(SendDlgItemMessage(hwnd,IDC_TVS_NOSCROLL,BM_GETCHECK,0,0))
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=TVS_NOSCROLL;
						else
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~TVS_NOSCROLL;
						return 1;
					}
					break;
				case IDC_TVS_NOTOOLTIPS:
					if(HIWORD(wParam)==BN_CLICKED){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						if(SendDlgItemMessage(hwnd,IDC_TVS_NOTOOLTIPS,BM_GETCHECK,0,0))
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=TVS_NOTOOLTIPS;
						else
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~TVS_NOTOOLTIPS;
						return 1;
					}
					break;
				case IDC_TVS_CHECKBOXES:
					if(HIWORD(wParam)==BN_CLICKED){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						if(SendDlgItemMessage(hwnd,IDC_TVS_CHECKBOXES,BM_GETCHECK,0,0))
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=TVS_CHECKBOXES;
						else
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~TVS_CHECKBOXES;
						return 1;
					}
					break;
				case IDC_TVS_FULLROWSELECT:
					if(HIWORD(wParam)==BN_CLICKED){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						if(SendDlgItemMessage(hwnd,IDC_TVS_FULLROWSELECT,BM_GETCHECK,0,0))
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=TVS_FULLROWSELECT;
						else
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~TVS_FULLROWSELECT;
						return 1;
					}
					break;
				case IDC_TVS_TRACKSELECT:
					if(HIWORD(wParam)==BN_CLICKED){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						if(SendDlgItemMessage(hwnd,IDC_TVS_TRACKSELECT,BM_GETCHECK,0,0))
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=TVS_TRACKSELECT;
						else
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~TVS_TRACKSELECT;
						return 1;
					}
					break;
				case IDC_TVS_SINGLEEXPAND:
					if(HIWORD(wParam)==BN_CLICKED){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						if(SendDlgItemMessage(hwnd,IDC_TVS_SINGLEEXPAND,BM_GETCHECK,0,0))
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=TVS_SINGLEEXPAND;
						else
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~TVS_SINGLEEXPAND;
						return 1;
					}
					break;

				case IDC_EXSTYLE:
					if(!DialogBox(hResInst,MAKEINTRESOURCE(IDD_RAD_PROP_ITEM_EXSTYLE),hwnd,(DLGPROC)DlgRadProperty_Item_ExStyle)) return 1;
					DrawRadWindow(i,&ProjectInfo.pWindowInfo[i2]);
					return 1;
			}
			break;
	}
	return 0;
}


//////////////////////
// UPDOWN vpeB
BOOL CALLBACK RadProperty_UpDownProc(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam){
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	extern PROJECTINFO ProjectInfo;
	int i,i2,i3;
	static BOOL bInitial;

	switch(message){
		case WM_INITDIALOG:
			bInitial=1;
			i=GetWndNum(GetParent(GetParent(hwnd)));
			i2=GetWndInfoNum(MdiInfo[i].path);

			SetDlgItemText(hwnd,IDC_IDNAME,ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].IdName);
			SetDlgItemText(hwnd,IDC_CAPTION,ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].caption);


			//////////////////
			// X^C
			////////////

			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&WS_DISABLED) SendDlgItemMessage(hwnd,IDC_STYLE_DISABLED,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&WS_VISIBLE) SendDlgItemMessage(hwnd,IDC_STYLE_VISIBLE,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&WS_GROUP) SendDlgItemMessage(hwnd,IDC_STYLE_GROUP,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&WS_TABSTOP) SendDlgItemMessage(hwnd,IDC_STYLE_TABSTOP,BM_SETCHECK,BST_CHECKED,0);


			////////
			// 
			////////

			//""
			SendDlgItemMessage(hwnd,IDC_UDS_SITUATION,CB_ADDSTRING,0,(long)STRING_DIRECTION_HORIZONTAL);
			//""
			SendDlgItemMessage(hwnd,IDC_UDS_SITUATION,CB_ADDSTRING,0,(long)STRING_DIRECTION_VERTICAL);

			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&UDS_HORZ) SendDlgItemMessage(hwnd,IDC_UDS_SITUATION,CB_SETCURSEL,0,0);
			else SendDlgItemMessage(hwnd,IDC_UDS_SITUATION,CB_SETCURSEL,1,0);

			////////////
			// A^b`
			////////////

			//"Ȃ"
			SendDlgItemMessage(hwnd,IDC_UDS_ATTACH,CB_ADDSTRING,0,(long)STRING_NONE_);
			//"["
			SendDlgItemMessage(hwnd,IDC_UDS_ATTACH,CB_ADDSTRING,0,(long)STRING_LEFT);
			//"E["
			SendDlgItemMessage(hwnd,IDC_UDS_ATTACH,CB_ADDSTRING,0,(long)STRING_RIGHT);

			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&UDS_ALIGNLEFT) SendDlgItemMessage(hwnd,IDC_UDS_ATTACH,CB_SETCURSEL,1,0);
			else if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&UDS_ALIGNRIGHT) SendDlgItemMessage(hwnd,IDC_UDS_ATTACH,CB_SETCURSEL,2,0);
			else SendDlgItemMessage(hwnd,IDC_UDS_ATTACH,CB_SETCURSEL,0,0);

			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&UDS_AUTOBUDDY) SendDlgItemMessage(hwnd,IDC_UDS_AUTOBUDDY,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&UDS_SETBUDDYINT) SendDlgItemMessage(hwnd,IDC_UDS_SETBUDDYINT,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&UDS_NOTHOUSANDS) SendDlgItemMessage(hwnd,IDC_UDS_NOTHOUSANDS,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&UDS_WRAP) SendDlgItemMessage(hwnd,IDC_UDS_WRAP,BM_SETCHECK,BST_CHECKED,0);
			if(ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&UDS_ARROWKEYS) SendDlgItemMessage(hwnd,IDC_UDS_ARROWKEYS,BM_SETCHECK,BST_CHECKED,0);


			bInitial=0;
			break;
		case WM_COMMAND:

			i=GetWndNum(GetParent(GetParent(hwnd)));
			if(i==-1) return 1;
			i2=GetWndInfoNum(MdiInfo[i].path);

			//ʃX^C
			if(bInitial==0){
				if(DefaultItemStyles(hwnd,i,i2,wParam)) return 1;
			}

			switch(LOWORD(wParam)){
				case IDC_UDS_SITUATION:
					if(HIWORD(wParam)==CBN_SELCHANGE){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						i3=SendDlgItemMessage(hwnd,IDC_UDS_SITUATION,CB_GETCURSEL,0,0);
						ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~UDS_HORZ;
						if(i3==0) ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=UDS_HORZ;
						DrawRadWindow(i,&ProjectInfo.pWindowInfo[i2]);
						return 1;
					}
					break;
				case IDC_UDS_ATTACH:
					if(HIWORD(wParam)==CBN_SELCHANGE){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						i3=SendDlgItemMessage(hwnd,IDC_UDS_ATTACH,CB_GETCURSEL,0,0);
						ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~(UDS_ALIGNLEFT|UDS_ALIGNRIGHT);
						if(i3==1) ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=UDS_ALIGNLEFT;
						else if(i3==2) ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=UDS_ALIGNRIGHT;
						return 1;
					}
					break;

				case IDC_UDS_AUTOBUDDY:
					if(HIWORD(wParam)==BN_CLICKED){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						if(SendDlgItemMessage(hwnd,IDC_UDS_AUTOBUDDY,BM_GETCHECK,0,0))
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=UDS_AUTOBUDDY;
						else
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~UDS_AUTOBUDDY;
						return 1;
					}
					break;
				case IDC_UDS_SETBUDDYINT:
					if(HIWORD(wParam)==BN_CLICKED){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						if(SendDlgItemMessage(hwnd,IDC_UDS_SETBUDDYINT,BM_GETCHECK,0,0))
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=UDS_SETBUDDYINT;
						else
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~UDS_SETBUDDYINT;
						return 1;
					}
					break;
				case IDC_UDS_NOTHOUSANDS:
					if(HIWORD(wParam)==BN_CLICKED){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						if(SendDlgItemMessage(hwnd,IDC_UDS_NOTHOUSANDS,BM_GETCHECK,0,0))
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=UDS_NOTHOUSANDS;
						else
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~UDS_NOTHOUSANDS;
						return 1;
					}
					break;
				case IDC_UDS_WRAP:
					if(HIWORD(wParam)==BN_CLICKED){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						if(SendDlgItemMessage(hwnd,IDC_UDS_WRAP,BM_GETCHECK,0,0))
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=UDS_WRAP;
						else
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~UDS_WRAP;
						return 1;
					}
					break;
				case IDC_UDS_ARROWKEYS:
					if(HIWORD(wParam)==BN_CLICKED){
						//ύX
						Rad_NoticeChanging(i,RAD_UNDO_STYLE,MdiInfo[i].MdiRadInfo->SelectingItem[0],ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style);

						if(SendDlgItemMessage(hwnd,IDC_UDS_ARROWKEYS,BM_GETCHECK,0,0))
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style|=UDS_ARROWKEYS;
						else
							ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[i].MdiRadInfo->SelectingItem[0]].style&=~UDS_ARROWKEYS;
						return 1;
					}
					break;

				case IDC_EXSTYLE:
					if(!DialogBox(hResInst,MAKEINTRESOURCE(IDD_RAD_PROP_ITEM_EXSTYLE),hwnd,(DLGPROC)DlgRadProperty_Item_ExStyle)) return 1;
					DrawRadWindow(i,&ProjectInfo.pWindowInfo[i2]);
					return 1;
			}
	}
	return 0;
}


LRESULT CALLBACK RadPropertyWindow(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam){
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	extern PROJECTINFO ProjectInfo;
	int i;
	RECT rect;
	SCROLLINFO ScrollInfo;

	switch(message){
		case WM_MOUSEACTIVATE:
			BringWindowToTop(GetParent(hwnd));
			return 0;
		case WM_VSCROLL:
			ScrollInfo.cbSize=sizeof(SCROLLINFO);
			ScrollInfo.fMask=SIF_POS|SIF_PAGE|SIF_RANGE;
			GetScrollInfo(hwnd,SB_VERT,&ScrollInfo);
			if(LOWORD(wParam)==SB_LINEUP) i=-20;
			else if(LOWORD(wParam)==SB_LINEDOWN) i=20;
			else if(LOWORD(wParam)==SB_PAGEUP) i=-(signed int)ScrollInfo.nPage;
			else if(LOWORD(wParam)==SB_PAGEDOWN) i=ScrollInfo.nPage;
			else if(LOWORD(wParam)==SB_THUMBTRACK) i=HIWORD(wParam)-ScrollInfo.nPos;
			else i=0;
			GetClientRect(hwnd,&rect);
			i=max(-ScrollInfo.nPos,min(i,ScrollInfo.nMax-rect.bottom-ScrollInfo.nPos));
			if(i!=0){
				ScrollInfo.nPos+=i;
				SetScrollInfo(hwnd,SB_VERT,&ScrollInfo,1);
				ScrollWindow(hwnd,0,-i,NULL,NULL);
				UpdateWindow(hwnd);
			}
			return 0;
		case WM_SIZE:
			i=GetWndNum(GetParent(hwnd));
			if(i==-1) return 0;	//EBhEԂ̏ꍇ
			ScrollInfo.cbSize=sizeof(SCROLLINFO);
			ScrollInfo.fMask=SIF_PAGE|SIF_RANGE|SIF_POS;
			GetScrollInfo(hwnd,SB_VERT,&ScrollInfo);
			GetClientRect(MdiInfo[i].MdiRadInfo->hProp_Dlg,&rect);
			ScrollInfo.nMin=0;
			ScrollInfo.nMax=rect.bottom;
			ScrollInfo.nPage=HIWORD(lParam);
			SetScrollInfo(hwnd,SB_VERT,&ScrollInfo,1);

			i=ScrollInfo.nPos;
			ScrollInfo.fMask=SIF_POS;
			GetScrollInfo(hwnd,SB_VERT,&ScrollInfo);
			if(i>ScrollInfo.nPos){
				ScrollWindow(hwnd,0,i-ScrollInfo.nPos,NULL,NULL);
				UpdateWindow(hwnd);
			}
			return 0;
	}
	return DefWindowProc(hwnd,message,wParam,lParam);
}
