#include "common.h"

#if defined(JPN)
//{
#include "pj_msg_jpn.h"
#else
//p
#include "pj_msg_eng.h"
#endif

void GetResourceData(void){
	extern HANDLE hHeap;
	extern PROJECTINFO ProjectInfo;
	int i2,i3;
	char *buffer,temporary[MAX_PATH],temp2[MAX_PATH],temp3[MAX_PATH];
	HANDLE hFile;

	lstrcpy(temporary,ProjectInfo.ResourceFileName);
	GetFullPath(temporary,ProjectInfo.dir);

	hFile=CreateFile(temporary,GENERIC_READ,0,NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
	if(hFile==INVALID_HANDLE_VALUE) return;
	i2=GetFileSize(hFile,NULL);
	buffer=(char *)HeapAlloc(hHeap,0,i2+i2+1);
	ReadFile(hFile,buffer,i2,(DWORD *)&i3,NULL);
	CloseHandle(hFile);
	buffer[i3]=0;
	ChangeReturnCode(buffer);

	i2=0;
	while(1){
		//ID
		while(buffer[i2]==' '||buffer[i2]=='\t') i2++;
		for(i3=0;;i2++,i3++){
			if(!IsVariableChar(buffer[i2])){
				temp3[i3]=0;
				break;
			}
			temp3[i3]=buffer[i2];
		}
		if(temp3[0]=='\0') break;

		//Type
		while(buffer[i2]==' '||buffer[i2]=='\t') i2++;
		for(i3=0;;i2++,i3++){
			if(!IsVariableChar(buffer[i2])){
				temporary[i3]=0;
				break;
			}
			temporary[i3]=buffer[i2];
		}

		//FileName
		while(buffer[i2]==' '||buffer[i2]=='\t') i2++;
		if(buffer[i2]!='\"'){
			//G[
			return;
		}
		for(i2++,i3=0;;i2++,i3++){
			if(buffer[i2]=='\"'){
				temp2[i3]=0;
				break;
			}
			temp2[i3]=buffer[i2];
		}

		if(lstrcmpi(temporary,"CURSOR")==0){
			ProjectInfo.res.pCursorResInfo=(RESITEMINFO *)HeapReAlloc(hHeap,0,ProjectInfo.res.pCursorResInfo,(ProjectInfo.res.NumberOfCursorRes+1)*sizeof(RESITEMINFO));

			ProjectInfo.res.pCursorResInfo[ProjectInfo.res.NumberOfCursorRes].IdName=
				(char *)HeapAlloc(hHeap,0,lstrlen(temp3)+1);
			lstrcpy(ProjectInfo.res.pCursorResInfo[ProjectInfo.res.NumberOfCursorRes].IdName,temp3);

			ProjectInfo.res.pCursorResInfo[ProjectInfo.res.NumberOfCursorRes].path=
				(char *)HeapAlloc(hHeap,0,lstrlen(temp2)+1);
			lstrcpy(ProjectInfo.res.pCursorResInfo[ProjectInfo.res.NumberOfCursorRes].path,temp2);

			ProjectInfo.res.NumberOfCursorRes++;
		}
		else if(lstrcmpi(temporary,"BITMAP")==0){
			ProjectInfo.res.pBitmapResInfo=(RESITEMINFO *)HeapReAlloc(hHeap,0,ProjectInfo.res.pBitmapResInfo,(ProjectInfo.res.NumberOfBitmapRes+1)*sizeof(RESITEMINFO));

			ProjectInfo.res.pBitmapResInfo[ProjectInfo.res.NumberOfBitmapRes].IdName=
				(char *)HeapAlloc(hHeap,0,lstrlen(temp3)+1);
			lstrcpy(ProjectInfo.res.pBitmapResInfo[ProjectInfo.res.NumberOfBitmapRes].IdName,temp3);

			ProjectInfo.res.pBitmapResInfo[ProjectInfo.res.NumberOfBitmapRes].path=
				(char *)HeapAlloc(hHeap,0,lstrlen(temp2)+1);
			lstrcpy(ProjectInfo.res.pBitmapResInfo[ProjectInfo.res.NumberOfBitmapRes].path,temp2);

			ProjectInfo.res.NumberOfBitmapRes++;
		}
		else if(lstrcmpi(temporary,"ICON")==0){
			ProjectInfo.res.pIconResInfo=(RESITEMINFO *)HeapReAlloc(hHeap,0,ProjectInfo.res.pIconResInfo,(ProjectInfo.res.NumberOfIconRes+1)*sizeof(RESITEMINFO));

			ProjectInfo.res.pIconResInfo[ProjectInfo.res.NumberOfIconRes].IdName=
				(char *)HeapAlloc(hHeap,0,lstrlen(temp3)+1);
			lstrcpy(ProjectInfo.res.pIconResInfo[ProjectInfo.res.NumberOfIconRes].IdName,temp3);

			ProjectInfo.res.pIconResInfo[ProjectInfo.res.NumberOfIconRes].path=
				(char *)HeapAlloc(hHeap,0,lstrlen(temp2)+1);
			lstrcpy(ProjectInfo.res.pIconResInfo[ProjectInfo.res.NumberOfIconRes].path,temp2);

			ProjectInfo.res.NumberOfIconRes++;
		}
		else if(lstrcmpi(temporary,"RT_MANIFEST")==0){
			//
		}
		else{
			//G[
			return;
		}

		i2++;
		while(buffer[i2]==' '||buffer[i2]=='\t') i2++;
		if(buffer[i2]=='\0') break;
		else if(buffer[i2]!='\n'){
			//G[
			return;
		}
		i2++;
	}

	//\[X̏ꍇ
	if(ProjectInfo.res.NumberOfCursorRes==0&&
		ProjectInfo.res.NumberOfBitmapRes==0&&
		ProjectInfo.res.NumberOfIconRes==0)
		ProjectInfo.ResourceFileName[0]=0;

	HeapDefaultFree(buffer);
}

void Project_CursorResInsert(void){
	extern HANDLE hHeap;
	extern LPSTR CursorFileFilter;
	extern PROJECTINFO ProjectInfo;
	int i2,i3;
	char temporary[MAX_PATH];

	if(!ProjectInfo.ResourceFileName[0])
		sprintf(ProjectInfo.ResourceFileName,"%s.rc",ProjectInfo.name);

	//"J[\ t@Cw肵Ă"
	if(!GetFilePathDialog(hOwner,temporary,CursorFileFilter,STRING_FILEOPENTITLE_CURSOR,TRUE)) return;

	GetRelationalPath(temporary,ProjectInfo.dir);

	ProjectInfo.res.pCursorResInfo=(RESITEMINFO *)HeapReAlloc(hHeap,0,ProjectInfo.res.pCursorResInfo,(ProjectInfo.res.NumberOfCursorRes+1)*sizeof(RESITEMINFO));

	ProjectInfo.res.pCursorResInfo[ProjectInfo.res.NumberOfCursorRes].path=
		(char *)HeapAlloc(hHeap,0,lstrlen(temporary)+1);
	lstrcpy(ProjectInfo.res.pCursorResInfo[ProjectInfo.res.NumberOfCursorRes].path,temporary);

	for(i3=1;;i3++){
		sprintf(temporary,"IDC_CURSOR%d",i3);
		for(i2=0;i2<ProjectInfo.res.NumberOfCursorRes;i2++){
			if(lstrcmp(temporary,ProjectInfo.res.pCursorResInfo[i2].IdName)==0) break;
		}
		if(i2==ProjectInfo.res.NumberOfCursorRes) break;
	}

	ProjectInfo.res.pCursorResInfo[ProjectInfo.res.NumberOfCursorRes].IdName=
		(char *)HeapAlloc(hHeap,0,lstrlen(temporary)+1);
	lstrcpy(ProjectInfo.res.pCursorResInfo[ProjectInfo.res.NumberOfCursorRes].IdName,temporary);

	//c[r[ɒǉ
	extern HWND hMaterialTreeView;
	TV_INSERTSTRUCT tv;
	tv.hInsertAfter=TVI_SORT;
	tv.item.mask=TVIF_TEXT|TVIF_IMAGE|TVIF_SELECTEDIMAGE;
	tv.item.iImage=6;
	tv.item.iSelectedImage=6;
	tv.hParent=ProjectInfo.res.hCursorTreeItem;
	tv.item.pszText=temporary;

	ProjectInfo.res.pCursorResInfo[ProjectInfo.res.NumberOfCursorRes].hTreeItem=
		TreeView_InsertItem(hMaterialTreeView,&tv);

	TreeView_SelectItem(hMaterialTreeView,ProjectInfo.res.pCursorResInfo[ProjectInfo.res.NumberOfCursorRes].hTreeItem);

	ProjectInfo.res.NumberOfCursorRes++;
	ProjectInfo.ModifuOfResource=1;
}
void Project_Cursor_Delete(int CursorInfoNum){
	extern PROJECTINFO ProjectInfo;
	int i;

	//c[r[폜
	extern HWND hMaterialTreeView;
	TreeView_DeleteItem(hMaterialTreeView,ProjectInfo.res.pCursorResInfo[CursorInfoNum].hTreeItem);

	//ProjectInfo.pCursorInfo\̂폜
	HeapDefaultFree(ProjectInfo.res.pCursorResInfo[CursorInfoNum].IdName);
	HeapDefaultFree(ProjectInfo.res.pCursorResInfo[CursorInfoNum].path);
	ProjectInfo.res.NumberOfCursorRes--;
	for(i=CursorInfoNum;i<ProjectInfo.res.NumberOfCursorRes;i++)
		ProjectInfo.res.pCursorResInfo[i]=ProjectInfo.res.pCursorResInfo[i+1];

	ProjectInfo.ModifuOfResource=1;
}
void Project_Cursor_RenameID(int CursorInfoNum){
	extern HANDLE hHeap;
	extern PROJECTINFO ProjectInfo;
	extern char NewIdName[MAX_PATH];
	extern HWND hMaterialTreeView;
	int i2;
	char temporary[MAX_PATH];
	TVITEM tvItem;

	if(!DialogBoxParam(hResInst,MAKEINTRESOURCE(IDD_INPUTID),hOwner,DlgProject_ResourceID_Input,(long)ProjectInfo.res.pCursorResInfo[CursorInfoNum].IdName)) return;

	//d`FbN
	for(i2=0;i2<ProjectInfo.res.NumberOfCursorRes;i2++){
		if(i2==CursorInfoNum) continue;
		if(lstrcmp(NewIdName,ProjectInfo.res.pCursorResInfo[i2].IdName)==0){
			//"ID \"%s\" ͊ɃvWFNgɑ݂܂B"
			sprintf(temporary,STRING_DUPLICATIONERROR_ID_IN_PROJECT,NewIdName);
			MessageBox(hOwner,temporary,STRING_ERROR,MB_OK|MB_ICONEXCLAMATION);
			return;
		}
	}

	HeapDefaultFree(ProjectInfo.res.pCursorResInfo[CursorInfoNum].IdName);
	ProjectInfo.res.pCursorResInfo[CursorInfoNum].IdName=(char *)HeapAlloc(hHeap,0,lstrlen(NewIdName)+1);
	lstrcpy(ProjectInfo.res.pCursorResInfo[CursorInfoNum].IdName,NewIdName);

	tvItem.hItem=ProjectInfo.res.pCursorResInfo[CursorInfoNum].hTreeItem;
	tvItem.mask=TVIF_TEXT;
	tvItem.pszText=ProjectInfo.res.pCursorResInfo[CursorInfoNum].IdName;
	tvItem.cchTextMax=lstrlen(ProjectInfo.res.pCursorResInfo[CursorInfoNum].IdName)+1;
	TreeView_SetItem(hMaterialTreeView,&tvItem);

	ProjectInfo.ModifuOfResource=1;

	TreeView_SortChildren(hMaterialTreeView,
		TreeView_GetParent(hMaterialTreeView,ProjectInfo.res.pCursorResInfo[CursorInfoNum].hTreeItem),
		0);
}

void Project_BitmapResInsert(void){
	extern HANDLE hHeap;
	extern LPSTR BitmapFileFilter;
	extern PROJECTINFO ProjectInfo;
	int i2,i3;
	char temporary[MAX_PATH];

	if(!ProjectInfo.ResourceFileName[0])
		sprintf(ProjectInfo.ResourceFileName,"%s.rc",ProjectInfo.name);

	//"rbg}bv t@Cw肵Ă"
	if(!GetFilePathDialog(hOwner,temporary,BitmapFileFilter,STRING_FILEOPENTITLE_BITMAP,TRUE)) return;

	GetRelationalPath(temporary,ProjectInfo.dir);

	ProjectInfo.res.pBitmapResInfo=(RESITEMINFO *)HeapReAlloc(hHeap,0,ProjectInfo.res.pBitmapResInfo,(ProjectInfo.res.NumberOfBitmapRes+1)*sizeof(RESITEMINFO));

	ProjectInfo.res.pBitmapResInfo[ProjectInfo.res.NumberOfBitmapRes].path=
		(char *)HeapAlloc(hHeap,0,lstrlen(temporary)+1);
	lstrcpy(ProjectInfo.res.pBitmapResInfo[ProjectInfo.res.NumberOfBitmapRes].path,temporary);

	for(i3=1;;i3++){
		sprintf(temporary,"IDB_BITMAP%d",i3);
		for(i2=0;i2<ProjectInfo.res.NumberOfBitmapRes;i2++){
			if(lstrcmp(temporary,ProjectInfo.res.pBitmapResInfo[i2].IdName)==0) break;
		}
		if(i2==ProjectInfo.res.NumberOfBitmapRes) break;
	}

	ProjectInfo.res.pBitmapResInfo[ProjectInfo.res.NumberOfBitmapRes].IdName=
		(char *)HeapAlloc(hHeap,0,lstrlen(temporary)+1);
	lstrcpy(ProjectInfo.res.pBitmapResInfo[ProjectInfo.res.NumberOfBitmapRes].IdName,temporary);

	//c[r[ɒǉ
	extern HWND hMaterialTreeView;
	TV_INSERTSTRUCT tv;
	tv.hInsertAfter=TVI_SORT;
	tv.item.mask=TVIF_TEXT|TVIF_IMAGE|TVIF_SELECTEDIMAGE;
	tv.item.iImage=5;
	tv.item.iSelectedImage=5;
	tv.hParent=ProjectInfo.res.hBitmapTreeItem;
	tv.item.pszText=temporary;

	ProjectInfo.res.pBitmapResInfo[ProjectInfo.res.NumberOfBitmapRes].hTreeItem=
		TreeView_InsertItem(hMaterialTreeView,&tv);

	TreeView_SelectItem(hMaterialTreeView,ProjectInfo.res.pBitmapResInfo[ProjectInfo.res.NumberOfBitmapRes].hTreeItem);

	ProjectInfo.res.NumberOfBitmapRes++;
	ProjectInfo.ModifuOfResource=1;


	////////////////////////////////
	// EBhE vpeBXV
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	for(i2=0;i2<MAX_WNDNUM;i2++){
		if(MdiInfo[i2].hwnd&&MdiInfo[i2].DocType==WNDTYPE_RAD){
			if(MdiInfo[i2].MdiRadInfo->SelectingItem[0]==SELECT_WINDOW)
				ChangePropertyWindow(i2,GetWndInfoNum(MdiInfo[i2].path));
		}
	}
}
void Project_Bitmap_Delete(int BitmapInfoNum){
	extern PROJECTINFO ProjectInfo;
	int i;

	//c[r[폜
	extern HWND hMaterialTreeView;
	TreeView_DeleteItem(hMaterialTreeView,ProjectInfo.res.pBitmapResInfo[BitmapInfoNum].hTreeItem);

	//ProjectInfo.pBitmapInfo\̂폜
	HeapDefaultFree(ProjectInfo.res.pBitmapResInfo[BitmapInfoNum].IdName);
	HeapDefaultFree(ProjectInfo.res.pBitmapResInfo[BitmapInfoNum].path);
	ProjectInfo.res.NumberOfBitmapRes--;
	for(i=BitmapInfoNum;i<ProjectInfo.res.NumberOfBitmapRes;i++)
		ProjectInfo.res.pBitmapResInfo[i]=ProjectInfo.res.pBitmapResInfo[i+1];

	ProjectInfo.ModifuOfResource=1;
}
void Project_Bitmap_RenameID(int BitmapInfoNum){
	extern HANDLE hHeap;
	extern PROJECTINFO ProjectInfo;
	extern char NewIdName[MAX_PATH];
	extern HWND hMaterialTreeView;
	int i2;
	char temporary[MAX_PATH];
	TVITEM tvItem;

	if(!DialogBoxParam(hResInst,MAKEINTRESOURCE(IDD_INPUTID),hOwner,DlgProject_ResourceID_Input,(long)ProjectInfo.res.pBitmapResInfo[BitmapInfoNum].IdName)) return;

	//d`FbN
	for(i2=0;i2<ProjectInfo.res.NumberOfBitmapRes;i2++){
		if(i2==BitmapInfoNum) continue;
		if(lstrcmp(NewIdName,ProjectInfo.res.pBitmapResInfo[i2].IdName)==0){
			//"ID \"%s\" ͊ɃvWFNgɑ݂܂B"
			sprintf(temporary,STRING_DUPLICATIONERROR_ID_IN_PROJECT,NewIdName);
			MessageBox(hOwner,temporary,STRING_ERROR,MB_OK|MB_ICONEXCLAMATION);
			return;
		}
	}

	HeapDefaultFree(ProjectInfo.res.pBitmapResInfo[BitmapInfoNum].IdName);
	ProjectInfo.res.pBitmapResInfo[BitmapInfoNum].IdName=(char *)HeapAlloc(hHeap,0,lstrlen(NewIdName)+1);
	lstrcpy(ProjectInfo.res.pBitmapResInfo[BitmapInfoNum].IdName,NewIdName);

	tvItem.hItem=ProjectInfo.res.pBitmapResInfo[BitmapInfoNum].hTreeItem;
	tvItem.mask=TVIF_TEXT;
	tvItem.pszText=ProjectInfo.res.pBitmapResInfo[BitmapInfoNum].IdName;
	tvItem.cchTextMax=lstrlen(ProjectInfo.res.pBitmapResInfo[BitmapInfoNum].IdName)+1;
	TreeView_SetItem(hMaterialTreeView,&tvItem);

	ProjectInfo.ModifuOfResource=1;

	TreeView_SortChildren(hMaterialTreeView,
		TreeView_GetParent(hMaterialTreeView,ProjectInfo.res.pBitmapResInfo[BitmapInfoNum].hTreeItem),
		0);
}
void Project_IconResInsert(void){
	extern HANDLE hHeap;
	extern LPSTR IconFileFilter;
	extern PROJECTINFO ProjectInfo;
	int i2,i3;
	char temporary[MAX_PATH];

	if(!ProjectInfo.ResourceFileName[0])
		sprintf(ProjectInfo.ResourceFileName,"%s.rc",ProjectInfo.name);

	//"ACR t@Cw肵Ă"
	if(!GetFilePathDialog(hOwner,temporary,IconFileFilter,STRING_FILEOPENTITLE_ICON,TRUE)) return;

	GetRelationalPath(temporary,ProjectInfo.dir);

	ProjectInfo.res.pIconResInfo=(RESITEMINFO *)HeapReAlloc(hHeap,0,ProjectInfo.res.pIconResInfo,(ProjectInfo.res.NumberOfIconRes+1)*sizeof(RESITEMINFO));

	ProjectInfo.res.pIconResInfo[ProjectInfo.res.NumberOfIconRes].path=
		(char *)HeapAlloc(hHeap,0,lstrlen(temporary)+1);
	lstrcpy(ProjectInfo.res.pIconResInfo[ProjectInfo.res.NumberOfIconRes].path,temporary);

	for(i3=1;;i3++){
		sprintf(temporary,"IDI_ICON%d",i3);
		for(i2=0;i2<ProjectInfo.res.NumberOfIconRes;i2++){
			if(lstrcmp(temporary,ProjectInfo.res.pIconResInfo[i2].IdName)==0) break;
		}
		if(i2==ProjectInfo.res.NumberOfIconRes) break;
	}

	ProjectInfo.res.pIconResInfo[ProjectInfo.res.NumberOfIconRes].IdName=
		(char *)HeapAlloc(hHeap,0,lstrlen(temporary)+1);
	lstrcpy(ProjectInfo.res.pIconResInfo[ProjectInfo.res.NumberOfIconRes].IdName,temporary);

	//c[r[ɒǉ
	extern HWND hMaterialTreeView;
	TV_INSERTSTRUCT tv;
	tv.hInsertAfter=TVI_SORT;
	tv.item.mask=TVIF_TEXT|TVIF_IMAGE|TVIF_SELECTEDIMAGE;
	tv.item.iImage=4;
	tv.item.iSelectedImage=4;
	tv.hParent=ProjectInfo.res.hIconTreeItem;
	if(ProjectInfo.res.NumberOfIconRes==0) lstrcat(temporary," (Main)");
	tv.item.pszText=temporary;

	ProjectInfo.res.pIconResInfo[ProjectInfo.res.NumberOfIconRes].hTreeItem=
		TreeView_InsertItem(hMaterialTreeView,&tv);

	TreeView_SelectItem(hMaterialTreeView,ProjectInfo.res.pIconResInfo[ProjectInfo.res.NumberOfIconRes].hTreeItem);

	ProjectInfo.res.NumberOfIconRes++;
	ProjectInfo.ModifuOfResource=1;

	////////////////////////////////
	// EBhE vpeBXV
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	for(i2=0;i2<MAX_WNDNUM;i2++){
		if(MdiInfo[i2].hwnd&&MdiInfo[i2].DocType==WNDTYPE_RAD){
			if(MdiInfo[i2].MdiRadInfo->SelectingItem[0]==SELECT_WINDOW)
				ChangePropertyWindow(i2,GetWndInfoNum(MdiInfo[i2].path));
		}
	}
}
void Project_Icon_Delete(int IconInfoNum){
	extern HANDLE hHeap;
	extern PROJECTINFO ProjectInfo;
	int i2;
	char temporary[MAX_PATH];
	TVITEM tv;

	//c[r[폜
	extern HWND hMaterialTreeView;
	TreeView_DeleteItem(hMaterialTreeView,ProjectInfo.res.pIconResInfo[IconInfoNum].hTreeItem);

	//ProjectInfo.pIconInfo\̂폜
	HeapDefaultFree(ProjectInfo.res.pIconResInfo[IconInfoNum].IdName);
	HeapDefaultFree(ProjectInfo.res.pIconResInfo[IconInfoNum].path);
	ProjectInfo.res.NumberOfIconRes--;
	for(i2=IconInfoNum;i2<ProjectInfo.res.NumberOfIconRes;i2++) ProjectInfo.res.pIconResInfo[i2]=ProjectInfo.res.pIconResInfo[i2+1];

	if(IconInfoNum==0&&ProjectInfo.res.NumberOfIconRes){
		tv.mask=TVIF_TEXT|TVIF_HANDLE;
		tv.pszText=temporary;
		tv.cchTextMax=MAX_PATH;
		tv.hItem=ProjectInfo.res.pIconResInfo[0].hTreeItem;
		TreeView_GetItem(hMaterialTreeView,&tv);
		lstrcat(tv.pszText," (Main)");
		TreeView_SetItem(hMaterialTreeView,&tv);
	}

	ProjectInfo.ModifuOfResource=1;

	////////////////////////////////
	// EBhE vpeBXV
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	for(i2=0;i2<MAX_WNDNUM;i2++){
		if(MdiInfo[i2].hwnd&&MdiInfo[i2].DocType==WNDTYPE_RAD){
			if(MdiInfo[i2].MdiRadInfo->SelectingItem[0]==SELECT_WINDOW)
				ChangePropertyWindow(i2,GetWndInfoNum(MdiInfo[i2].path));
		}
	}
}
void Project_Icon_RenameID(int IconInfoNum){
	extern HANDLE hHeap;
	extern PROJECTINFO ProjectInfo;
	extern char NewIdName[MAX_PATH];
	extern HWND hMaterialTreeView;
	int i2;
	char temporary[MAX_PATH];
	TVITEM tvItem;

	if(!DialogBoxParam(hResInst,MAKEINTRESOURCE(IDD_INPUTID),hOwner,DlgProject_ResourceID_Input,(long)ProjectInfo.res.pIconResInfo[IconInfoNum].IdName)) return;

	//d`FbN
	for(i2=0;i2<ProjectInfo.res.NumberOfIconRes;i2++){
		if(i2==IconInfoNum) continue;
		if(lstrcmp(NewIdName,ProjectInfo.res.pIconResInfo[i2].IdName)==0){
			//"ID \"%s\" ͊ɃvWFNgɑ݂܂B"
			sprintf(temporary,STRING_DUPLICATIONERROR_ID_IN_PROJECT,NewIdName);
			MessageBox(hOwner,temporary,STRING_ERROR,MB_OK|MB_ICONEXCLAMATION);
			return;
		}
	}

	HeapDefaultFree(ProjectInfo.res.pIconResInfo[IconInfoNum].IdName);
	ProjectInfo.res.pIconResInfo[IconInfoNum].IdName=(char *)HeapAlloc(hHeap,0,lstrlen(NewIdName)+1);
	lstrcpy(ProjectInfo.res.pIconResInfo[IconInfoNum].IdName,NewIdName);

	tvItem.hItem=ProjectInfo.res.pIconResInfo[IconInfoNum].hTreeItem;
	tvItem.mask=TVIF_TEXT;
	if(IconInfoNum==0){
		sprintf(temporary,"%s (Main)",ProjectInfo.res.pIconResInfo[IconInfoNum].IdName);
		tvItem.pszText=temporary;
	}
	else tvItem.pszText=ProjectInfo.res.pIconResInfo[IconInfoNum].IdName;
	tvItem.cchTextMax=lstrlen(ProjectInfo.res.pIconResInfo[IconInfoNum].IdName)+1;
	TreeView_SetItem(hMaterialTreeView,&tvItem);

	ProjectInfo.ModifuOfResource=1;

	TreeView_SortChildren(hMaterialTreeView,
		TreeView_GetParent(hMaterialTreeView,ProjectInfo.res.pIconResInfo[IconInfoNum].hTreeItem),
		0);
}

BOOL CALLBACK DlgProject_ResourceID_Input(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam){
	extern char NewIdName[MAX_PATH];
	switch(message){
		case WM_INITDIALOG:
			//"ID̕ύX"
			SetWindowText(hwnd,STRING_RENAME_ID);

			SetDlgItemText(hwnd,IDC_IDNAME,(char *)lParam);
			SetPosCenter(hwnd);
			break;
		case WM_COMMAND:
			switch(LOWORD(wParam)){
				case IDOK:
					GetDlgItemText(hwnd,IDC_IDNAME,NewIdName,MAX_PATH);
					if(!NewIdName[0]){
						//"ID͂ĉB"
						MessageBox(hwnd,STRING_ERROR_MUST_IDNAME,APPLICATION_NAME,MB_OK);
						return 1;
					}
					EndDialog(hwnd,1);
					return 1;
				case IDCANCEL:
					EndDialog(hwnd,0);
					return 1;
			}
			break;
	}
	return 0;
}
