#include "ProjectEditor.h"


#if defined HeapAlloc
#define MEM_MAX 65536
LPVOID pCheckMem[MEM_MAX];
int now;
#undef HeapAlloc
#undef HeapReAlloc
LPVOID CheckHeapAlloc(HANDLE hf,DWORD dwFlags,DWORD dwBytes){
	LPVOID ret;
	ret=HeapAlloc(hf,dwFlags,dwBytes);
	pCheckMem[now]=ret;

	//̕now̃`FbN}


	now++;
	if(now>=MEM_MAX){
		MessageBox(0,"pCheckMem̍ől𒴂܂","Check",0);
	}
	return ret;
}
LPVOID CheckHeapReAlloc(HANDLE hf,DWORD dwFlags,LPVOID lpMem,DWORD dwBytes){
	int i;
	LPVOID ret;
	for(i=0;;i++){
		if(lpMem==pCheckMem[i]) break;
		if(i>=MEM_MAX){
			MessageBox(0,"G[","CheckHeapReAlloc",0);
			break;
		}
	}
	ret=HeapReAlloc(hf,dwFlags,lpMem,dwBytes);
	pCheckMem[i]=ret;
	return ret;
}
void HeapDefaultFree(LPVOID lpMem){
	int i;
	for(i=0;;i++){
		if(lpMem==pCheckMem[i]) break;
		if(i>=MEM_MAX){
			MessageBox(0,"G[","HeapDefaultFree",0);
			break;
		}
	}
	pCheckMem[i]=0;
	HeapFree(hHeap,0,lpMem);
}
void CheckHeapCheck(){
	int i,i2;
	char temp[100];
	temp[0]=0;
	for(i=0,i2=0;i<MEM_MAX;i++){
		if(pCheckMem[i]){
			sprintf(temp+lstrlen(temp),"%d\r\n",i);
			i2++;
			if(i2==10){
				lstrcat(temp,"ȏ̖mFĂ܂");
				break;
			}
		}
	}
	if(temp[0]) MessageBox(0,temp,"Check - BasicCompiler.exe",0);
}
#define HeapAlloc CheckHeapAlloc
#define HeapReAlloc CheckHeapReAlloc
#else
void HeapDefaultFree(LPVOID lpMem){
	HeapFree(hHeap,0,lpMem);
}
#endif

#ifdef DeleteObject
#undef DeleteObject
BOOL CheckDeleteObject(HGDIOBJ hObject){
	BOOL bRet;
	bRet=DeleteObject(hObject);

	if(bRet==0){
		MessageBox(0,"DeleteObject Error","Check",0);
	}
	return bRet;
}
#define DeleteObject CheckDeleteObject
#endif


void ToBigChar(char str[]){
	int i;
	for(i=0;TRUE;i++){
		str[i]=(char)toupper((int)str[i]);
		if(str[i]=='\0') break;
	}
}
int GetWndNum(HWND hChild){
	int i;
	if(!IsWindow(hChild)) return -1;
	for(i=0;i<MAX_WNDNUM;i++){
		if(hChild==MdiInfo[i].hwnd) break;
	}
	if(i==MAX_WNDNUM) i=-1;
	return i;
}
int GetNowWndNum(void){
	return GetWndNum(GetWindow(hClient,GW_CHILD));
}
int GetFileNum(int WndNum){
	int i;
	char temporary[MAX_PATH];
	for(i=0;i<ProjectInfo.pobj_DBFileInfo->iNum;i++){

		ProjectInfo.pobj_DBFileInfo->ppobj_FileInfo[i]->GetFullPath(temporary);

		if(lstrcmpi(MdiInfo[WndNum].path,temporary)==0) return i;
	}
	return -1;
}

void SendTextEditResizeEvent(HWND hwnd){
	RECT rect;
	GetClientRect(hwnd,&rect);
	ResizeTextEditWnd(hwnd,rect.right,rect.bottom);
}

void RedrawAllWindow(void){
	HWND hChild;
	hChild=GetWindow(hClient,GW_CHILD);
	if(hChild) ResetTextEditFont(GetWindow(hChild,GW_CHILD));
	while(hChild){
		int WndNum;
		WndNum=GetWndNum(hChild);
		if(WndNum==-1) break;

		if(IS_DOCUMENT_TEXT(MdiInfo[WndNum].DocType)){
			//Rg[^uXy[X̕ƍsԍ̕XV
			MdiInfo[WndNum].pmti->iWidth_ControlTabSpace=
				GetControlTabSpace(WndNum,&MdiInfo[WndNum].pmti->iLineNumberTextCount);

			InvalidateRect(MdiInfo[WndNum].pmti->hEdit,NULL,0);
			InvalidateRect(MdiInfo[WndNum].pmti->pobj_Ruler->hRulerWnd,NULL,0);

			SendTextEditResizeEvent(MdiInfo[WndNum].hwnd);
		}
		else{
			HWND hEdit;
			hEdit=GetWindow(hChild,GW_CHILD);
			InvalidateRect(hEdit,NULL,0);
		}

		hChild=GetWindow(hChild,GW_HWNDNEXT);
	}
}

int DocumentModifyCheck(HWND hChild){	//IۑmF
	int BoxID,WndNum,sw;
	char str[MAX_PATH],temporary[MAX_PATH];

	WndNum=GetWndNum(hChild);
	sw=0;
	if(IS_DOCUMENT_TEXT(MdiInfo[WndNum].DocType)){
		if(MdiInfo[WndNum].pmti->bModify) sw=1;
	}
	else if(MdiInfo[WndNum].DocType==WNDTYPE_ICONEDIT){
		if(MdiInfo[WndNum].MdiIconEditInfo->bModify) sw=1;
	}

	if(sw){
		GetWindowText(hChild,temporary,MAX_PATH);

		//"\"%s\" t@C͕ύXĂ܂Bۑ܂H"
		sprintf(str,STRING_MODIFYCHECK_FILE,temporary);
		BoxID=MessageBox(hOwner,str,APPLICATION_NAME,MB_YESNOCANCEL|MB_ICONINFORMATION);

		if(BoxID==IDYES){
			if(!SaveDocument(hChild,NULL)) return 0;
		}
		else if(BoxID==IDCANCEL) return 0;
	}
	return 1;
}
void SetStatusText(char *MenuText){
	//////////////////////////
	// Xe[^Xo[̍XV
	//////////////////////////

	int WndNum;
	double BufSize;
	char temporary[255];
	HWND hChild;

	if(MenuText){
		SendMessage(hStatusBar,SB_SETTEXT,0,(long)MenuText);
		if((char *)MenuText!=(char *)CmdMsg) CmdMsg[0]=0;
	}

	hChild=GetWindow(hClient,GW_CHILD);
	WndNum=GetWndNum(hChild);
	if(WndNum==-1) return;
	hChild=GetWindow(hChild,GW_CHILD);
	if(IS_DOCUMENT_TEXT(MdiInfo[WndNum].DocType)){
		//////////////////////
		// eLXgGfB^
		//////////////////////

		//TCY
		BufSize=(double)lstrlen(MdiInfo[WndNum].pmti->buffer);
		if(IsWindow(hChild)){
			if(BufSize<1024) sprintf(temporary,"%s: %.0fByte",STRING_SIZE,BufSize);
			else if(BufSize<1024*1024){
				BufSize/=1024;
				sprintf(temporary,"%s: %.2fKB",STRING_SIZE,BufSize);
			}
			else{
				BufSize/=1024*1024;
				sprintf(temporary,"%s: %.2fMB",STRING_SIZE,BufSize);
			}
		}
		else temporary[0]=0;
		SendMessage(hStatusBar,SB_SETTEXT,1,(LPARAM)temporary);

		//sƌ
		if(IsWindow(hChild)){
#if defined(JPN)
			//{
			sprintf(temporary,"%d sA%d ",
				MdiInfo[WndNum].pmti->StartCaretPos.y+1,
				MdiInfo[WndNum].pmti->StartCaretPos.x+1);
#else
			//p
			sprintf(temporary,"%d : %d",
				MdiInfo[WndNum].pmti->StartCaretPos.y+1,
				MdiInfo[WndNum].pmti->StartCaretPos.x+1);
#endif
		}
		else temporary[0]=0;
		SendMessage(hStatusBar,SB_SETTEXT,2,(LPARAM)temporary);

		//R[h
		nkf.GetCharCodeName(MdiInfo[WndNum].pmti->iCharCode,temporary);
		SendMessage(hStatusBar,SB_SETTEXT,3,(LPARAM)temporary);

		//R[h
		nkf.GetLfCodeName(MdiInfo[WndNum].pmti->iLfCode,temporary);
		SendMessage(hStatusBar,SB_SETTEXT,4,(LPARAM)temporary);
	}
	else if(MdiInfo[WndNum].DocType==WNDTYPE_RAD){
		////////////////
		// RADc[
		////////////////

		int WndInfoNum;
		WndInfoNum=GetWndInfoNum(MdiInfo[WndNum].path);
		if(RadInfo.NowDragging>=FRAME_CHANGEPOS_START&&RadInfo.NowDragging<=FRAME_CHANGEPOS_END){
			sprintf(temporary,"pos %d, %d",
				RadInfo.DraggingRect[0].left-MdiInfo[WndNum].MdiRadInfo->ClientPos.x,
				RadInfo.DraggingRect[0].top-MdiInfo[WndNum].MdiRadInfo->ClientPos.y);
			SendMessage(hStatusBar,SB_SETTEXT,1,(LPARAM)temporary);
			sprintf(temporary,"size %d * %d",
				RadInfo.DraggingRect[0].right-RadInfo.DraggingRect[0].left,
				RadInfo.DraggingRect[0].bottom-RadInfo.DraggingRect[0].top);
			SendMessage(hStatusBar,SB_SETTEXT,2,(LPARAM)temporary);
		}
		else if(MdiInfo[WndNum].MdiRadInfo->SelectingItem[0]==SELECT_WINDOW){
			SendMessage(hStatusBar,SB_SETTEXT,1,(LPARAM)"pos 0, 0");
			sprintf(temporary,"size %d * %d",ProjectInfo.pWindowInfo[WndInfoNum].size.cx,ProjectInfo.pWindowInfo[WndInfoNum].size.cy);
			SendMessage(hStatusBar,SB_SETTEXT,2,(LPARAM)temporary);
		}
		else{
			sprintf(temporary,"pos %d, %d",
				ProjectInfo.pWindowInfo[WndInfoNum].pChildInfo[MdiInfo[WndNum].MdiRadInfo->SelectingItem[0]].pos.x,
				ProjectInfo.pWindowInfo[WndInfoNum].pChildInfo[MdiInfo[WndNum].MdiRadInfo->SelectingItem[0]].pos.y);
			SendMessage(hStatusBar,SB_SETTEXT,1,(LPARAM)temporary);
			sprintf(temporary,"size %d * %d",
				ProjectInfo.pWindowInfo[WndInfoNum].pChildInfo[MdiInfo[WndNum].MdiRadInfo->SelectingItem[0]].size.cx,
				ProjectInfo.pWindowInfo[WndInfoNum].pChildInfo[MdiInfo[WndNum].MdiRadInfo->SelectingItem[0]].size.cy);
			SendMessage(hStatusBar,SB_SETTEXT,2,(LPARAM)temporary);
		}
	}
	else if(MdiInfo[WndNum].DocType==WNDTYPE_MENU){
		//////////////////
		// MENU GfB^
		//////////////////

		SendMessage(hStatusBar,SB_SETTEXT,1,(LPARAM)"");
		SendMessage(hStatusBar,SB_SETTEXT,2,(LPARAM)"");
	}
	else if(MdiInfo[WndNum].DocType==WNDTYPE_ICONEDIT){
		//////////////////
		// ICON GfB^
		//////////////////

		SendMessage(hStatusBar,SB_SETTEXT,1,(LPARAM)"");
		SendMessage(hStatusBar,SB_SETTEXT,2,(LPARAM)"");
	}
}
void ResetState_UndoMenu(void){				//uɖ߂A蒼ṽj[\
	int i,i2;
	HWND hChild;

	hChild=GetWindow(hClient,GW_CHILD);
	i=GetWndNum(hChild);
	if(i==-1){
		pobj_MainMenu->EnableItem(IDM_UNDO,MF_BYCOMMAND|MF_GRAYED);
		EnableMenuItem(hEditMenu,IDM_UNDO,MF_BYCOMMAND|MF_GRAYED);
		pobj_StandardToolbar->EnableItem(IDM_UNDO,0);
		pobj_MainMenu->EnableItem(IDM_REDO,MF_BYCOMMAND|MF_GRAYED);
		EnableMenuItem(hEditMenu,IDM_REDO,MF_BYCOMMAND|MF_GRAYED);
		pobj_StandardToolbar->EnableItem(IDM_REDO,0);
	}
	else if(IS_DOCUMENT_TEXT(MdiInfo[i].DocType)){
		i2=MdiInfo[i].edit_undo->NowPos-1;
		if(i2==-1) i2=MAX_UNDONUM-1;
		if(!MdiInfo[i].edit_undo->Command[i2]){
			pobj_MainMenu->EnableItem(IDM_UNDO,MF_BYCOMMAND|MF_GRAYED);
			EnableMenuItem(hEditMenu,IDM_UNDO,MF_BYCOMMAND|MF_GRAYED);
			pobj_StandardToolbar->EnableItem(IDM_UNDO,0);
		}
		else{
			pobj_MainMenu->EnableItem(IDM_UNDO,MF_BYCOMMAND|MF_ENABLED);
			EnableMenuItem(hEditMenu,IDM_UNDO,MF_BYCOMMAND|MF_ENABLED);
			pobj_StandardToolbar->EnableItem(IDM_UNDO,1);
		}
		if(!MdiInfo[i].edit_undo->Command[MdiInfo[i].edit_undo->NowPos]){
			pobj_MainMenu->EnableItem(IDM_REDO,MF_BYCOMMAND|MF_GRAYED);
			EnableMenuItem(hEditMenu,IDM_REDO,MF_BYCOMMAND|MF_GRAYED);
			pobj_StandardToolbar->EnableItem(IDM_REDO,0);
		}
		else{
			pobj_MainMenu->EnableItem(IDM_REDO,MF_BYCOMMAND|MF_ENABLED);
			EnableMenuItem(hEditMenu,IDM_REDO,MF_BYCOMMAND|MF_ENABLED);
			pobj_StandardToolbar->EnableItem(IDM_REDO,1);
		}
	}
	else if(MdiInfo[i].DocType==WNDTYPE_RAD){
		i2=MdiInfo[i].MdiRadInfo->undo.NowPos-1;
		if(i2==-1) i2=MAX_UNDONUM-1;
		if(!MdiInfo[i].MdiRadInfo->undo.Command[i2]){
			pobj_MainMenu->EnableItem(IDM_UNDO,MF_BYCOMMAND|MF_GRAYED);
			EnableMenuItem(hEditMenu,IDM_UNDO,MF_BYCOMMAND|MF_GRAYED);
			pobj_StandardToolbar->EnableItem(IDM_UNDO,0);
		}
		else{
			pobj_MainMenu->EnableItem(IDM_UNDO,MF_BYCOMMAND|MF_ENABLED);
			EnableMenuItem(hEditMenu,IDM_UNDO,MF_BYCOMMAND|MF_ENABLED);
			pobj_StandardToolbar->EnableItem(IDM_UNDO,1);
		}
		if(!MdiInfo[i].MdiRadInfo->undo.Command[MdiInfo[i].MdiRadInfo->undo.NowPos]){
			pobj_MainMenu->EnableItem(IDM_REDO,MF_BYCOMMAND|MF_GRAYED);
			EnableMenuItem(hEditMenu,IDM_REDO,MF_BYCOMMAND|MF_GRAYED);
			pobj_StandardToolbar->EnableItem(IDM_REDO,0);
		}
		else{
			pobj_MainMenu->EnableItem(IDM_REDO,MF_BYCOMMAND|MF_ENABLED);
			EnableMenuItem(hEditMenu,IDM_REDO,MF_BYCOMMAND|MF_ENABLED);
			pobj_StandardToolbar->EnableItem(IDM_REDO,1);
		}
	}
	else if(MdiInfo[i].DocType==WNDTYPE_MENU){
		pobj_MainMenu->EnableItem(IDM_UNDO,MF_BYCOMMAND|MF_GRAYED);
		EnableMenuItem(hEditMenu,IDM_UNDO,MF_BYCOMMAND|MF_GRAYED);
		pobj_StandardToolbar->EnableItem(IDM_UNDO,0);

		pobj_MainMenu->EnableItem(IDM_REDO,MF_BYCOMMAND|MF_GRAYED);
		EnableMenuItem(hEditMenu,IDM_REDO,MF_BYCOMMAND|MF_GRAYED);
		pobj_StandardToolbar->EnableItem(IDM_REDO,0);
	}
	else if(MdiInfo[i].DocType==WNDTYPE_ICONEDIT){
		i2=MdiInfo[i].MdiIconEditInfo->undo[MdiInfo[i].MdiIconEditInfo->SelectIconNum].NowPos-1;
		if(i2==-1) i2=MAX_ICONEDIT_UNDONUM-1;
		if(!MdiInfo[i].MdiIconEditInfo->undo[MdiInfo[i].MdiIconEditInfo->SelectIconNum].lpData[i2]){
			pobj_MainMenu->EnableItem(IDM_UNDO,MF_BYCOMMAND|MF_GRAYED);
			EnableMenuItem(hEditMenu,IDM_UNDO,MF_BYCOMMAND|MF_GRAYED);
			pobj_StandardToolbar->EnableItem(IDM_UNDO,0);
		}
		else{
			pobj_MainMenu->EnableItem(IDM_UNDO,MF_BYCOMMAND|MF_ENABLED);
			EnableMenuItem(hEditMenu,IDM_UNDO,MF_BYCOMMAND|MF_ENABLED);
			pobj_StandardToolbar->EnableItem(IDM_UNDO,1);
		}
		if(!MdiInfo[i].MdiIconEditInfo->undo[MdiInfo[i].MdiIconEditInfo->SelectIconNum].lpData[MdiInfo[i].MdiIconEditInfo->undo[MdiInfo[i].MdiIconEditInfo->SelectIconNum].NowPos]){
			pobj_MainMenu->EnableItem(IDM_REDO,MF_BYCOMMAND|MF_GRAYED);
			EnableMenuItem(hEditMenu,IDM_REDO,MF_BYCOMMAND|MF_GRAYED);
			pobj_StandardToolbar->EnableItem(IDM_REDO,0);
		}
		else{
			pobj_MainMenu->EnableItem(IDM_REDO,MF_BYCOMMAND|MF_ENABLED);
			EnableMenuItem(hEditMenu,IDM_REDO,MF_BYCOMMAND|MF_ENABLED);
			pobj_StandardToolbar->EnableItem(IDM_REDO,1);
		}
	}
}
void ResetState_ConvMenu(BOOL bEnable){
	int MenuMsg;
	if(bEnable)
		MenuMsg=MF_BYCOMMAND|MF_ENABLED;
	else MenuMsg=MF_BYCOMMAND|MF_GRAYED;

	pobj_MainMenu->EnableItem(IDM_CONV_ALPHA_SMALL,MenuMsg);
	pobj_MainMenu->EnableItem(IDM_CONV_ALPHA_BIG,MenuMsg);
	pobj_MainMenu->EnableItem(IDM_CONV_HALF,MenuMsg);
	pobj_MainMenu->EnableItem(IDM_CONV_MULTI,MenuMsg);
	pobj_MainMenu->EnableItem(IDM_CONV_KATAKANA,MenuMsg);
	pobj_MainMenu->EnableItem(IDM_CONV_HIRAGANA,MenuMsg);
	pobj_MainMenu->EnableItem(IDM_CONV_SPACE,MenuMsg);
	pobj_MainMenu->EnableItem(IDM_CONV_TAB,MenuMsg);
#ifdef THETEXT
	pobj_MainMenu->EnableItem(IDM_CONV_HASRETURN,MenuMsg);
	pobj_MainMenu->EnableItem(IDM_CONV_QUOTE,MenuMsg);
#else
	pobj_MainMenu->EnableItem(IDM_CODEFORMAT,MenuMsg);
#endif
}
void ResetState_PrintMenu(void);
void ResetState_EditMenu(void){				//ҏWj[̕\
	HWND hChild;
	int WndNum;
	long MenuMsg,ToolbarMsg;

	//j[̏Ԃݒ
	ResetState_PrintMenu();

	hChild=GetWindow(hClient,GW_CHILD);
	if(!IsWindow(hChild)){
		pobj_MainMenu->EnableItem(IDM_FIND,MF_BYCOMMAND|MF_GRAYED);
		pobj_MainMenu->EnableItem(IDM_PERMUTATION,MF_BYCOMMAND|MF_GRAYED);
#ifdef THETEXT
		pobj_MainMenu->EnableItem(IDM_STRING_COUNT,MF_BYCOMMAND|MF_GRAYED);
#endif
		pobj_StandardToolbar->EnableItem(IDM_FIND,0);

		pobj_MainMenu->EnableItem(IDM_CUT,MF_BYCOMMAND|MF_GRAYED);
		pobj_MainMenu->EnableItem(IDM_COPY,MF_BYCOMMAND|MF_GRAYED);
		pobj_MainMenu->EnableItem(IDM_DELETE,MF_BYCOMMAND|MF_GRAYED);
		EnableMenuItem(hEditMenu,IDM_CUT,MF_BYCOMMAND|MF_GRAYED);
		EnableMenuItem(hEditMenu,IDM_COPY,MF_BYCOMMAND|MF_GRAYED);
		EnableMenuItem(hEditMenu,IDM_DELETE,MF_BYCOMMAND|MF_GRAYED);
		pobj_MainMenu->EnableItem(IDM_PASTE,MF_BYCOMMAND|MF_GRAYED);
		pobj_MainMenu->EnableItem(IDM_ALLSELECT,MF_BYCOMMAND|MF_GRAYED);
		pobj_StandardToolbar->EnableItem(IDM_CUT,0);
		pobj_StandardToolbar->EnableItem(IDM_COPY,0);
		pobj_StandardToolbar->EnableItem(IDM_PASTE,0);

		ResetState_ConvMenu(0);

		ResetState_UndoMenu();
		return;
	}
	WndNum=GetWndNum(hChild);
	if(WndNum==-1) return;
	if(IS_DOCUMENT_TEXT(MdiInfo[WndNum].DocType)){
		pobj_MainMenu->EnableItem(IDM_ALLSELECT,MF_BYCOMMAND|MF_ENABLED);
		pobj_MainMenu->EnableItem(IDM_FIND,MF_BYCOMMAND|MF_ENABLED);
		pobj_MainMenu->EnableItem(IDM_PERMUTATION,MF_BYCOMMAND|MF_ENABLED);
#ifdef THETEXT
		pobj_MainMenu->EnableItem(IDM_STRING_COUNT,MF_BYCOMMAND|MF_ENABLED);
#endif
		pobj_StandardToolbar->EnableItem(IDM_FIND,1);

		BOOL bConvEnable;
		hChild=GetWindow(hChild,GW_CHILD);
		if(!(
			MdiInfo[WndNum].pmti->StartCaretPos.x==MdiInfo[WndNum].pmti->EndCaretPos.x&&
			MdiInfo[WndNum].pmti->StartCaretPos.y==MdiInfo[WndNum].pmti->EndCaretPos.y
			)){
			MenuMsg=MF_BYCOMMAND|MF_ENABLED;
			ToolbarMsg=1;

			bConvEnable=1;
		}
		else{
			MenuMsg=MF_BYCOMMAND|MF_GRAYED;
			ToolbarMsg=0;

			bConvEnable=0;
		}
		pobj_MainMenu->EnableItem(IDM_CUT,MenuMsg);
		pobj_MainMenu->EnableItem(IDM_COPY,MenuMsg);
		pobj_MainMenu->EnableItem(IDM_DELETE,MenuMsg);
		EnableMenuItem(hEditMenu,IDM_CUT,MenuMsg);
		EnableMenuItem(hEditMenu,IDM_COPY,MenuMsg);
		EnableMenuItem(hEditMenu,IDM_DELETE,MenuMsg);
		pobj_StandardToolbar->EnableItem(IDM_CUT,ToolbarMsg);
		pobj_StandardToolbar->EnableItem(IDM_COPY,ToolbarMsg);

		if(IsClipboardFormatAvailable(CF_TEXT)){
			pobj_MainMenu->EnableItem(IDM_PASTE,MF_BYCOMMAND|MF_ENABLED);
			pobj_StandardToolbar->EnableItem(IDM_PASTE,1);
		}
		else{
			pobj_MainMenu->EnableItem(IDM_PASTE,MF_BYCOMMAND|MF_GRAYED);
			pobj_StandardToolbar->EnableItem(IDM_PASTE,0);
		}


		//ϊR}h
		ResetState_ConvMenu(bConvEnable);
	}
	else if(MdiInfo[WndNum].DocType==WNDTYPE_RAD){
		//AuAJEg𖳌
		pobj_MainMenu->EnableItem(IDM_FIND,MF_BYCOMMAND|MF_GRAYED);
		pobj_MainMenu->EnableItem(IDM_PERMUTATION,MF_BYCOMMAND|MF_GRAYED);
#ifdef THETEXT
		pobj_MainMenu->EnableItem(IDM_STRING_COUNT,MF_BYCOMMAND|MF_GRAYED);
#endif
		pobj_StandardToolbar->EnableItem(IDM_FIND,0);

		if(MdiInfo[WndNum].MdiRadInfo->SelectingItem[0]==SELECT_WINDOW){
			//؂ARs[A폜L
			pobj_MainMenu->EnableItem(IDM_CUT,MF_BYCOMMAND|MF_GRAYED);
			pobj_MainMenu->EnableItem(IDM_COPY,MF_BYCOMMAND|MF_GRAYED);
			pobj_MainMenu->EnableItem(IDM_DELETE,MF_BYCOMMAND|MF_GRAYED);
			EnableMenuItem(hEditMenu,IDM_CUT,MF_BYCOMMAND|MF_GRAYED);
			EnableMenuItem(hEditMenu,IDM_COPY,MF_BYCOMMAND|MF_GRAYED);
			EnableMenuItem(hEditMenu,IDM_DELETE,MF_BYCOMMAND|MF_GRAYED);
			pobj_StandardToolbar->EnableItem(IDM_CUT,0);
			pobj_StandardToolbar->EnableItem(IDM_COPY,0);
		}
		else{
			//؂ARs[A폜𖳌
			pobj_MainMenu->EnableItem(IDM_CUT,MF_BYCOMMAND|MF_ENABLED);
			pobj_MainMenu->EnableItem(IDM_COPY,MF_BYCOMMAND|MF_ENABLED);
			pobj_MainMenu->EnableItem(IDM_DELETE,MF_BYCOMMAND|MF_ENABLED);
			EnableMenuItem(hEditMenu,IDM_CUT,MF_BYCOMMAND|MF_ENABLED);
			EnableMenuItem(hEditMenu,IDM_COPY,MF_BYCOMMAND|MF_ENABLED);
			EnableMenuItem(hEditMenu,IDM_DELETE,MF_BYCOMMAND|MF_ENABLED);
			pobj_StandardToolbar->EnableItem(IDM_CUT,1);
			pobj_StandardToolbar->EnableItem(IDM_COPY,1);
		}

		//ׂđIL
		pobj_MainMenu->EnableItem(IDM_ALLSELECT,MF_BYCOMMAND|MF_ENABLED);

		if(IsClipboardFormatAvailable(dwRadClipboardID)){
			pobj_MainMenu->EnableItem(IDM_PASTE,MF_BYCOMMAND|MF_ENABLED);
			pobj_StandardToolbar->EnableItem(IDM_PASTE,1);
		}
		else{
			pobj_MainMenu->EnableItem(IDM_PASTE,MF_BYCOMMAND|MF_GRAYED);
			pobj_StandardToolbar->EnableItem(IDM_PASTE,0);
		}

		ResetState_ConvMenu(0);
	}
	else if(MdiInfo[WndNum].DocType==WNDTYPE_MENU){
		//AuAJEg𖳌
		pobj_MainMenu->EnableItem(IDM_FIND,MF_BYCOMMAND|MF_GRAYED);
		pobj_MainMenu->EnableItem(IDM_PERMUTATION,MF_BYCOMMAND|MF_GRAYED);
#ifdef THETEXT
		pobj_MainMenu->EnableItem(IDM_STRING_COUNT,MF_BYCOMMAND|MF_GRAYED);
#endif
		pobj_StandardToolbar->EnableItem(IDM_FIND,0);

		pobj_MainMenu->EnableItem(IDM_CUT,MF_BYCOMMAND|MF_GRAYED);
		pobj_MainMenu->EnableItem(IDM_COPY,MF_BYCOMMAND|MF_GRAYED);
		pobj_MainMenu->EnableItem(IDM_DELETE,MF_BYCOMMAND|MF_GRAYED);
		EnableMenuItem(hEditMenu,IDM_CUT,MF_BYCOMMAND|MF_GRAYED);
		EnableMenuItem(hEditMenu,IDM_COPY,MF_BYCOMMAND|MF_GRAYED);
		EnableMenuItem(hEditMenu,IDM_DELETE,MF_BYCOMMAND|MF_GRAYED);
		pobj_MainMenu->EnableItem(IDM_PASTE,MF_BYCOMMAND|MF_GRAYED);
		pobj_MainMenu->EnableItem(IDM_ALLSELECT,MF_BYCOMMAND|MF_GRAYED);
		pobj_StandardToolbar->EnableItem(IDM_CUT,0);
		pobj_StandardToolbar->EnableItem(IDM_COPY,0);
		pobj_StandardToolbar->EnableItem(IDM_PASTE,0);

		ResetState_ConvMenu(0);
	}
	else if(MdiInfo[WndNum].DocType==WNDTYPE_ICONEDIT){
		//AuAJEg𖳌
		pobj_MainMenu->EnableItem(IDM_FIND,MF_BYCOMMAND|MF_GRAYED);
		pobj_MainMenu->EnableItem(IDM_PERMUTATION,MF_BYCOMMAND|MF_GRAYED);
#ifdef THETEXT
		pobj_MainMenu->EnableItem(IDM_STRING_COUNT,MF_BYCOMMAND|MF_GRAYED);
#endif
		pobj_StandardToolbar->EnableItem(IDM_FIND,0);

		if(MdiInfo[WndNum].MdiIconEditInfo->SelectLevel==0){
			//؂ARs[A폜𖳌
			pobj_MainMenu->EnableItem(IDM_CUT,MF_BYCOMMAND|MF_GRAYED);
			pobj_MainMenu->EnableItem(IDM_COPY,MF_BYCOMMAND|MF_GRAYED);
			pobj_MainMenu->EnableItem(IDM_DELETE,MF_BYCOMMAND|MF_GRAYED);
			EnableMenuItem(hEditMenu,IDM_CUT,MF_BYCOMMAND|MF_GRAYED);
			EnableMenuItem(hEditMenu,IDM_COPY,MF_BYCOMMAND|MF_GRAYED);
			EnableMenuItem(hEditMenu,IDM_DELETE,MF_BYCOMMAND|MF_GRAYED);
			pobj_StandardToolbar->EnableItem(IDM_CUT,0);
			pobj_StandardToolbar->EnableItem(IDM_COPY,0);
		}
		else{
			//؂ARs[A폜L
			pobj_MainMenu->EnableItem(IDM_CUT,MF_BYCOMMAND|MF_ENABLED);
			pobj_MainMenu->EnableItem(IDM_COPY,MF_BYCOMMAND|MF_ENABLED);
			pobj_MainMenu->EnableItem(IDM_DELETE,MF_BYCOMMAND|MF_ENABLED);
			EnableMenuItem(hEditMenu,IDM_CUT,MF_BYCOMMAND|MF_ENABLED);
			EnableMenuItem(hEditMenu,IDM_COPY,MF_BYCOMMAND|MF_ENABLED);
			EnableMenuItem(hEditMenu,IDM_DELETE,MF_BYCOMMAND|MF_ENABLED);
			pobj_StandardToolbar->EnableItem(IDM_CUT,1);
			pobj_StandardToolbar->EnableItem(IDM_COPY,1);
		}

		//ׂđIL
		pobj_MainMenu->EnableItem(IDM_ALLSELECT,MF_BYCOMMAND|MF_ENABLED);

		if(IsClipboardFormatAvailable(CF_BITMAP)){
			//\tL
			pobj_MainMenu->EnableItem(IDM_PASTE,MF_BYCOMMAND|MF_ENABLED);
			pobj_StandardToolbar->EnableItem(IDM_PASTE,1);
		}
		else{
			//\t𖳌
			pobj_MainMenu->EnableItem(IDM_PASTE,MF_BYCOMMAND|MF_GRAYED);
			pobj_StandardToolbar->EnableItem(IDM_PASTE,0);
		}

		ResetState_ConvMenu(0);
	}

	ResetState_UndoMenu();
}
void ResetState_ViewMenu(void){
	// \ j[̏Ԃݒ


#ifdef THETEXT
	pobj_MainMenu->CheckMenu(IDM_RIGHT_TURN,pobj_nv->bRightTurn);
#endif
}
void ResetState_PrintMenu(void){				//ҏWj[̕\
	HWND hChild;
	int WndNum;
	hChild=GetWindow(hClient,GW_CHILD);
	if(!IsWindow(hChild)){
		pobj_MainMenu->EnableItem(IDM_PAGESET,MF_BYCOMMAND|MF_GRAYED);

		if(bProfessional){
			pobj_MainMenu->EnableItem(IDM_PREVIEW,MF_BYCOMMAND|MF_GRAYED);
		}

		pobj_MainMenu->EnableItem(IDM_PRINTOUT,MF_BYCOMMAND|MF_GRAYED);
		return;
	}
	WndNum=GetWndNum(hChild);
	if(IS_DOCUMENT_TEXT(MdiInfo[WndNum].DocType)){
		pobj_MainMenu->EnableItem(IDM_PAGESET,MF_BYCOMMAND|MF_ENABLED);

		if(bProfessional){
			pobj_MainMenu->EnableItem(IDM_PREVIEW,MF_BYCOMMAND|MF_ENABLED);
		}

		pobj_MainMenu->EnableItem(IDM_PRINTOUT,MF_BYCOMMAND|MF_ENABLED);
	}
	else{
		pobj_MainMenu->EnableItem(IDM_PAGESET,MF_BYCOMMAND|MF_GRAYED);

		if(bProfessional){
			pobj_MainMenu->EnableItem(IDM_PREVIEW,MF_BYCOMMAND|MF_GRAYED);
		}

		pobj_MainMenu->EnableItem(IDM_PRINTOUT,MF_BYCOMMAND|MF_GRAYED);
	}
}
void ResetState_DocMenu(void){
	long MenuMsg,ToolbarMsg;
	HWND hChild;

	hChild=GetWindow(hClient,GW_CHILD);


	/////////////////////////////////////////
	// ʃhLg j[̏Ԃݒ
	/////////////////////////////////////////

	if(!IsWindow(hChild)){
		MenuMsg=MF_GRAYED;
		ToolbarMsg=0;
	}
	else{
		MenuMsg=MF_ENABLED;
		ToolbarMsg=1;
	}
	pobj_MainMenu->EnableItem(IDM_CLOSE,MenuMsg);
	pobj_MainMenu->EnableItem(IDM_SAVE,MenuMsg);
	pobj_MainMenu->EnableItem(IDM_NEWSAVE,MenuMsg);
	pobj_MainMenu->EnableItem(IDM_CODE_SAVE,MenuMsg);
	pobj_MainMenu->EnableItem(IDM_ALLSAVE,MenuMsg);

	pobj_StandardToolbar->EnableItem(IDM_CLOSE,ToolbarMsg);
	pobj_StandardToolbar->EnableItem(IDM_SAVE,ToolbarMsg);
	pobj_StandardToolbar->EnableItem(IDM_ALLSAVE,ToolbarMsg);


#ifndef THETEXT
	/////////////////////////////////////////////////
	// vWFNghLg j[̏Ԃݒ
	/////////////////////////////////////////////////

	if(ProjectInfo.name[0]){
		pobj_MainMenu->EnableItem(IDM_ALLSAVE,MF_ENABLED);
		pobj_StandardToolbar->EnableItem(IDM_ALLSAVE,1);

		MenuMsg=MF_ENABLED;
		ToolbarMsg=TBSTATE_ENABLED;
	}
	else{
		MenuMsg=MF_GRAYED;
		ToolbarMsg=TBSTATE_INDETERMINATE;
	}
	pobj_MainMenu->EnableItem(IDM_PROJECT_SAVE,MenuMsg);
	pobj_MainMenu->EnableItem(IDM_PROJECT_CLOSE,MenuMsg);
	pobj_MainMenu->EnableItem(IDM_PROJECT_FOLDER_OPEN,MenuMsg);
	pobj_MainMenu->EnableItem(IDM_PROJECT_OPTION,MenuMsg);

	//fobK j[̏Ԃݒ
	pobj_Debugger->ResetCommandEnabled();
#endif


	//ҏWj[̏Ԃݒ
	ResetState_EditMenu();

	//\j[̏Ԃݒ
	ResetState_ViewMenu();
}
void DuplicateTitleCheck(char *lpszTitle){
	int i;
	for(i=0;i<MAX_WNDNUM;i++){
		if(MdiInfo[i].hwnd){
			if(lstrcmpi(MdiInfo[i].title,lpszTitle)==0){
				lstrcat(lpszTitle,"_");
				DuplicateTitleCheck(lpszTitle);
				return;
			}
		}
	}
}
HWND NewTextEditWindow(char *filepath,_int8 DocumentType,COLORREF TabColor){
	int i;
	char str[MAX_PATH],str2[32],*buffer;
	HWND hChild,hEdit;
	RECT rect;
	int iCharCode=NKF_SHIFT_JIS;
	int iLfCode=LFCODE_CRLF;

	if(filepath){

		//łɎw肳ꂽt@CJĂꍇ
		hChild=GetWindow(hClient,GW_CHILD);
		while(hChild){
			i=GetWndNum(hChild);
			if(IS_DOCUMENT_TEXT(MdiInfo[i].DocType)){
				if(lstrcmpi(MdiInfo[i].path,filepath)==0) break;
			}
			hChild=GetNextWindow(hChild,GW_HWNDNEXT);
		}
		if(hChild){
			//Oʂɕ\ďI
			BringWindowToTop(hChild);
			return hChild;
		}


		//////////////////////////////////////////////////////
		//t@Cǂݍ݁iɓǂݍ߂邩̊mF܂ށj
		//////////////////////////////////////////////////////

		HANDLE hFile;
		hFile=CreateFile(filepath,GENERIC_READ,FILE_SHARE_READ|FILE_SHARE_WRITE,NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
		if(hFile==INVALID_HANDLE_VALUE){
			sprintf(str,STRING_ERROR_CANT_FILEOPEN,filepath);
			MessageBox(hOwner,str,STRING_ERROR,MB_OK|MB_ICONEXCLAMATION);
			return 0;
		}
		int length;
		length=GetFileSize(hFile,NULL);

		char *temp;
		temp=(char *)HeapAlloc(hHeap,0,length+1);
		DWORD dw;
		ReadFile(hFile,temp,length,&dw,NULL);
		CloseHandle(hFile);
		for(i=0;i<length;i++){
			if(temp[i]=='\0') temp[i]=' ';
		}
		temp[length]=0;


		///////////////////////
		// sR[h𔻕
		///////////////////////

		char *temp2;
		for(i=0;i<length;i++){
			if(temp[i]=='\r'){
				if(temp[i+1]=='\n')
					iLfCode=LFCODE_CRLF;
				else
					iLfCode=LFCODE_CR;
				break;
			}
			if(temp[i]=='\n'){
				iLfCode=LFCODE_LF;
				break;
			}
		}

		//sR[hϊ
		if(iLfCode==LFCODE_CR||iLfCode==LFCODE_LF){
			temp2=nkf.ToCRLF(iLfCode,temp);
			HeapDefaultFree(temp);
			temp=temp2;

			length=lstrlen(temp);
		}


		/////////////////////
		// Shift-JISɕϊ
		/////////////////////

		buffer=(char *)HeapAlloc(hHeap,0,length*2+1);
		nkf.pSetNkfOption("-sx");	//Shift-JISɕϊix͔pJ^JiSpɕϊȂIvVj
		nkf.pNkfConvert(buffer,temp);
		buffer=(char *)HeapReAlloc(hHeap,0,buffer,lstrlen(buffer)+1);
		HeapDefaultFree(temp);

		//ϊO̕R[h𔻕
		iCharCode=nkf.pNkfGetKanjiCode();
		if(iCharCode<NKF_CODE_MIN||NKF_CODE_MAX<iCharCode){
			//ʕs\ȏꍇ́AShift-JISɂ
			iCharCode=NKF_SHIFT_JIS;
		}
		else if(iCharCode==NKF_EUC||iCharCode==NKF_ISO_2022_JP){
			//EUCAJIS̏ꍇŁAʕs\ȏꍇ́AShift-JISD
			for(i=0;;i++){
				if(buffer[i]=='\0'){
					//pR[ĥ
					iCharCode=NKF_SHIFT_JIS;
					break;
				}
				if(IsDBCSLeadByte(buffer[i])) break;
			}
		}


		//////////////////////////
		// t@CpXZbg
		//////////////////////////

		_splitpath(filepath,NULL,NULL,str,str2);
		lstrcat(str,str2);
	}
	else{
		buffer=(char *)HeapAlloc(hHeap,HEAP_ZERO_MEMORY,1);
		DocumentCounter++;
		sprintf(str,"Document[%d]",DocumentCounter);
	}

	MDICREATESTRUCT mdic;
	mdic.szClass="MDIClientWindow_TextEdit";
	mdic.hOwner=hInst;
	mdic.x=CW_USEDEFAULT;
	mdic.y=CW_USEDEFAULT;
	mdic.cx=CW_USEDEFAULT;
	mdic.cy=CW_USEDEFAULT;
	mdic.szTitle=str;

	hChild=GetWindow(hClient,GW_CHILD);
	if(IsWindow(hChild)){
		if(IsZoomed(hChild)) mdic.style=WS_MAXIMIZE;
		else mdic.style=0;
	}
	else{
		if(pobj_nv->bMDIZoomed) mdic.style=WS_MAXIMIZE;
		else mdic.style=0;
	}

	//t@CACRZbg
	SHFILEINFO shfi;
	if(filepath)
		SHGetFileInfo(filepath, FILE_ATTRIBUTE_ARCHIVE, &shfi, sizeof(SHFILEINFO), SHGFI_ICON | SHGFI_SMALLICON );
	else shfi.hIcon=(HICON)LoadImage(hResInst,MAKEINTRESOURCE(IDI_TEXTDOCUMENT),IMAGE_ICON,16,16,LR_DEFAULTCOLOR);;
	mdic.lParam=(LPARAM)shfi.hIcon;

	mdic.style|=WS_CLIPCHILDREN;
	hChild=(HWND)SendMessage(hClient,WM_MDICREATE,0,(long)&mdic);	//EBhE쐬

	//TextEditorRg[ݒu
	GetClientRect(hChild,&rect);
	hEdit=CreateWindow("TextEditor",NULL,
		WS_CHILD|WS_HSCROLL|WS_VSCROLL|WS_VISIBLE,
		0,0,0,0,
		hChild,NULL,hInst,NULL);

	//EBhEIDo^
	for(i=0;i<MAX_WNDNUM;i++){
		if(MdiInfo[i].hwnd==0){
			MdiInfo[i].hwnd=hChild;
			MdiInfo[i].DocType=DocumentType;
			DuplicateTitleCheck(str);
			MdiInfo[i].title=(char *)GlobalAlloc(GMEM_FIXED,lstrlen(str)+1);
			lstrcpy(MdiInfo[i].title,str);
			if(filepath){
				MdiInfo[i].path=(char *)GlobalAlloc(GMEM_FIXED,lstrlen(filepath)+1);
				lstrcpy(MdiInfo[i].path,filepath);
			}
			else{
				MdiInfo[i].path=(char *)GlobalAlloc(GPTR,1);
			}

			MdiInfo[i].pmti=(MDITEXTEDITINFO *)HeapAlloc(hHeap,0,sizeof(MDITEXTEDITINFO));

			MdiInfo[i].pmti->hEdit=hEdit;
			MdiInfo[i].pmti->pobj_WebResult=new CWebResult(hChild);
			MdiInfo[i].pmti->pobj_Ruler=new CRuler(hChild,i);
			MdiInfo[i].pmti->hIcon=shfi.hIcon;
			MdiInfo[i].pmti->buffer=buffer;
			MdiInfo[i].pmti->pColorRef=(COLORREF *)HeapAlloc(hHeap,HEAP_ZERO_MEMORY,sizeof(COLORREF)*lstrlen(buffer));
			MdiInfo[i].pmti->iUnderStart=-1;
			MdiInfo[i].pmti->iUnderEnd=-1;
			MdiInfo[i].pmti->StartCaretPos.x=0;
			MdiInfo[i].pmti->StartCaretPos.y=0;
			MdiInfo[i].pmti->EndCaretPos.x=0;
			MdiInfo[i].pmti->EndCaretPos.y=0;
			MdiInfo[i].pmti->Temp_UpDown_CaretXPos=-1;
			MdiInfo[i].pmti->bAutoScroll=0;
			MdiInfo[i].pmti->iWidth_ControlTabSpace=
				GetControlTabSpace(i,&MdiInfo[i].pmti->iLineNumberTextCount);
			MdiInfo[i].pmti->iCharCode=iCharCode;
			MdiInfo[i].pmti->iLfCode=iLfCode;
			MdiInfo[i].pmti->bModify=0;

			MdiInfo[i].IndentStr=0;

			MdiInfo[i].edit_undo=(TEXTEDIT_UNDOSTATE *)GlobalAlloc(GPTR,sizeof(TEXTEDIT_UNDOSTATE));
			MdiInfo[i].edit_undo->NowPos=0;

			int flag;
			if(mdic.style&WS_MAXIMIZE) flag=SIZE_MAXIMIZED;
			else flag=0;
			SendTextEditResizeEvent(hChild);
			break;
		}
	}

	//[hJ[Zbg
	if(IS_DOCUMENT_TEXT(DocumentType)) SetTextEditWordColor(i);

	//DocR{{bNXɒǉ
	extern HWND hDocCombo;
	i=SendMessage(hDocCombo,CB_ADDSTRING,0,(long)str);
	SendMessage(hDocCombo,CB_SETCURSEL,i,0);

	//^uɒǉ
	pobj_MainTab->insert(str,1,TabColor);

	SetFocus(hEdit);
	SetStatusText(NULL);

	//j[Ԃݒ
	ResetState_DocMenu();

	return hChild;
}
void CreateNewFile(void){

#ifdef THETEXT
	NewTextEditWindow(NULL,WNDTYPE_TEXT);
	return;
#else
	int FileType;
	BOOL bAddToProject;
	char temporary[MAX_PATH];

	FileType=DialogBox(hResInst,MAKEINTRESOURCE(IDD_NEWFILE),hOwner,DlgNewFile);
	if(FileType==-1) return;

	if(FileType&0x00008000){
		bAddToProject=1;
		FileType&=0x0FFF;
		lstrcpy(temporary,NewFileName);
		if(!strstr(temporary,".")) lstrcat(temporary,".ab");
		GetFullPath(temporary,ProjectInfo.dir);
	}
	else bAddToProject=0;

	switch(FileType){
		case FT_BASICPROGRAM:		//BasicvO
		case FT_SUBPROGRAM:
			if(bAddToProject){
				WriteBuffer(temporary,0,0);
				NewTextEditWindow(temporary,WNDTYPE_BASIC);
				Project_File_Insert(temporary);
			}
			else NewTextEditWindow(NULL,WNDTYPE_BASIC);
			break;

		case FT_PROJECT:
			DlgNewProjectWizard(hOwner);
			break;

		case FT_TEXT:
			NewTextEditWindow(NULL,WNDTYPE_TEXT);
			break;

		case FT_HTML:
			NewTextEditWindow(NULL,WNDTYPE_HTML);
			break;

		case FT_ICON:
			NewIconEditWindow(NULL);
			break;
	}
#endif
}
void CloseDocWindow(int WndNum){
	int i2,i3;

	MdiInfo[WndNum].hwnd=0;

	//hLgR{{bNX當
	extern HWND hDocCombo;
	i2=SendMessage(hDocCombo,CB_FINDSTRINGEXACT,0,(long)MdiInfo[WndNum].title);
	SendMessage(hDocCombo,CB_DELETESTRING,i2,0);
	InvalidateRect(hDocCombo,NULL,1);

	//^uRg[ACe
	if(pobj_MainTab) pobj_MainTab->delete_item(MdiInfo[WndNum].title,1);


	GlobalFree(MdiInfo[WndNum].title);
	GlobalFree(MdiInfo[WndNum].path);

	if(IS_DOCUMENT_TEXT(MdiInfo[WndNum].DocType)){
		////////////////////////////
		// eLXgGfB^
		////////////////////////////

		extern COMPLEMENT_WINDOW_INFO ComplementWndInfo;
		if(ComplementWndInfo.hWnd){
			//R[h⊮Xgj
			DestroyWindow(ComplementWndInfo.hWnd);
			ComplementWndInfo.hWnd=0;
		}

		for(i2=0;i2<MAX_UNDONUM;i2++){
			if(MdiInfo[WndNum].edit_undo->Command[i2])
				TextEdit_DeleteUndoData(WndNum,i2);
		}
		GlobalFree(MdiInfo[WndNum].edit_undo);

		HeapDefaultFree(MdiInfo[WndNum].pmti->buffer);
		HeapDefaultFree(MdiInfo[WndNum].pmti->pColorRef);

		if(MdiInfo[WndNum].IndentStr) HeapDefaultFree(MdiInfo[WndNum].IndentStr);

		//GfBbgRg[j
		DestroyWindow(MdiInfo[WndNum].pmti->hEdit);

		//WebEBhEj
		delete MdiInfo[WndNum].pmti->pobj_WebResult;
		MdiInfo[WndNum].pmti->pobj_WebResult=0;

		//[[EBhEj
		delete MdiInfo[WndNum].pmti->pobj_Ruler;
		MdiInfo[WndNum].pmti->pobj_Ruler=0;

		//ACRj
		if(MdiInfo[WndNum].pmti->hIcon) DestroyIcon(MdiInfo[WndNum].pmti->hIcon);

		HeapDefaultFree(MdiInfo[WndNum].pmti);
		MdiInfo[WndNum].pmti=0;
	}
	else if(MdiInfo[WndNum].DocType==WNDTYPE_RAD){
		/////////////////////
		// RADc[
		/////////////////////

		for(i2=0;i2<MAX_UNDONUM;i2++){
			if(MdiInfo[WndNum].MdiRadInfo->undo.Command[i2])
				Rad_DeleteUndoData(WndNum,i2);
		}
		DestroyWindow(MdiInfo[WndNum].MdiRadInfo->hTools);
		DestroyWindow(MdiInfo[WndNum].MdiRadInfo->hRad);
		SelectObject(MdiInfo[WndNum].MdiRadInfo->hMemDC,MdiInfo[WndNum].MdiRadInfo->hOldBitmap);
		DeleteDC(MdiInfo[WndNum].MdiRadInfo->hMemDC);
		DeleteObject(MdiInfo[WndNum].MdiRadInfo->hBitmap);
		GlobalFree(MdiInfo[WndNum].MdiRadInfo);
	}
	else if(MdiInfo[WndNum].DocType==WNDTYPE_MENU){
		////////////////////////////
		// j[GfB^
		////////////////////////////

		DestroyWindow(MdiInfo[WndNum].MdiMenuInfo->hList);
		GlobalFree(MdiInfo[WndNum].MdiMenuInfo);
	}
	else if(MdiInfo[WndNum].DocType==WNDTYPE_ICONEDIT){
		////////////////////////////
		// ACRGfB^
		////////////////////////////

		for(i2=0;i2<MdiInfo[WndNum].MdiIconEditInfo->num;i2++){
			for(i3=0;i3<MAX_ICONEDIT_UNDONUM;i3++){
				if(MdiInfo[WndNum].MdiIconEditInfo->undo[i2].lpData[i3])
					HeapDefaultFree(MdiInfo[WndNum].MdiIconEditInfo->undo[i2].lpData[i3]);
			}
		}

		DeleteDC(MdiInfo[WndNum].MdiIconEditInfo->memdc);
		DeleteObject(MdiInfo[WndNum].MdiIconEditInfo->hMemBmp);
		DestroyWindow(MdiInfo[WndNum].MdiIconEditInfo->hMain);
		for(i2=0;i2<MdiInfo[WndNum].MdiIconEditInfo->num;i2++){
			HeapDefaultFree(MdiInfo[WndNum].MdiIconEditInfo->pIconImage[i2]);
		}
		HeapDefaultFree(MdiInfo[WndNum].MdiIconEditInfo);
	}
}
void ResizeTextEditWnd(HWND hwnd,int cx,int cy){
	int WndNum;
	WndNum=GetWndNum(hwnd);
	if(WndNum==-1) return;

	int WebResultWndHeight;
	WebResultWndHeight=LINK_ITEM_HEIGHT;
	//
	WebResultWndHeight=0;

	int iHeightRuler;
	if(pobj_nv->bEditor_Ruler){
		//[[
		MdiInfo[WndNum].pmti->pobj_Ruler->resize(
			0,
			0,
			cx,
			HEIGHT_RULER);

		iHeightRuler=HEIGHT_RULER;

		ShowWindow(MdiInfo[WndNum].pmti->pobj_Ruler->hRulerWnd,SW_SHOW);
	}
	else{
		iHeightRuler=0;

		ShowWindow(MdiInfo[WndNum].pmti->pobj_Ruler->hRulerWnd,SW_HIDE);
	}

	//GfBbgEBhE
	MoveWindow(MdiInfo[WndNum].pmti->hEdit,
		0,
		iHeightRuler,
		cx,
		cy-WebResultWndHeight-iHeightRuler,
		1);

	//WebEBhE
	MdiInfo[WndNum].pmti->pobj_WebResult->resize(
		0,
		cy-WebResultWndHeight,
		cx,
		WebResultWndHeight);
}
LRESULT CALLBACK MDIClientWindow_TextEdit(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam){
	int i,i2;
	HWND hEdit;

	switch(message){
		case WM_CREATE:
			CREATESTRUCT *lpcs;
			lpcs=(CREATESTRUCT *)lParam;
			MDICREATESTRUCT *lpmcs;
			lpmcs=(MDICREATESTRUCT *)lpcs->lpCreateParams;
			SendMessage(hwnd,WM_SETICON,ICON_SMALL,(LPARAM)lpmcs->lParam);
			break;
		case WM_MDIACTIVATE:
			//ȑOMDIEBhẼp[^ qgj
			if(MethodCheckInfo.hWnd){
				DestroyWindow(MethodCheckInfo.hWnd);
				MethodCheckInfo.hWnd=0;
			}

			//ȑÕR[h⊮Xgj
			if(ComplementWndInfo.hWnd){
				DestroyWindow(ComplementWndInfo.hWnd);
				ComplementWndInfo.hWnd=0;
			}

			if(!lParam) return 0;
			i=GetWndNum((HWND)lParam);
			if(i==-1) return 0;	//EBhEԂ̏ꍇ

#ifndef THETEXT
			//fobK j[̏Ԃݒ
			pobj_Debugger->ResetCommandEnabled();
#endif

			//hLg ZNg R{{bNX
			extern HWND hDocCombo;
			i2=SendMessage(hDocCombo,CB_FINDSTRINGEXACT,0,(long)MdiInfo[i].title);
			SendMessage(hDocCombo,CB_SETCURSEL,i2,0);

			//^uRg[
			pobj_MainTab->MdiActiveEvent(MdiInfo[i].title);

			return 0;
		case WM_SETFOCUS:
			hEdit=GetWindow(hwnd,GW_CHILD);
			SetFocus(hEdit);
			SetStatusText(CmdMsg);
			ResetState_EditMenu();
			ResetState_ViewMenu();
			break;
		case WM_SIZE:
			ResizeTextEditWnd(hwnd,LOWORD(lParam),HIWORD(lParam));
			break;
		case WM_CLOSE:
			if(!DocumentModifyCheck(hwnd)) return 0;
			CloseDocWindow(GetWndNum(hwnd));
			pobj_nv->bMDIZoomed=IsZoomed(hwnd);
			i=DefMDIChildProc(hwnd,message,wParam,lParam);

			//j[Ԃݒ
			ResetState_DocMenu();

			return i;
	}
	return DefMDIChildProc(hwnd,message,wParam,lParam);
}
void ResizeOwnerWnd(void){
	int width_owner,height_owner;
	int height_Rebar;
	int height_MdiClient;
	RECT rect,StatusRect,RebarRect;

	GetClientRect(hOwner,&rect);
	width_owner=rect.right;
	height_owner=rect.bottom;

	//Rebar
	SendMessage(pobj_Rebar->hRebar,WM_SIZE,0,MAKELONG(width_owner,height_owner));
	UpdateWindow(pobj_Rebar->hRebar);

	//Status bar
#define STATUSBAR_PARTS_NUM 5
	int sb_size[STATUSBAR_PARTS_NUM];
	sb_size[0]=width_owner-340;
	sb_size[1]=width_owner-220;
	sb_size[2]=width_owner-120;
	sb_size[3]=width_owner-50;
	sb_size[4]=width_owner;
	SendMessage(hStatusBar,SB_SETPARTS,STATUSBAR_PARTS_NUM,(LPARAM)sb_size);
	SendMessage(hStatusBar,WM_SIZE,0,MAKELONG(width_owner,height_owner));
	UpdateWindow(hStatusBar);

	//Status bar
	int height_Statusbar;
	SendMessage(hStatusBar,SB_GETRECT,0,(long)&StatusRect);
	height_Statusbar=StatusRect.bottom;

	GetWindowRect(pobj_Rebar->hRebar,&RebarRect);
	height_Rebar=RebarRect.bottom-RebarRect.top+2;

	int height_dv;	//Width of Debugger View
	int height_cv;	//Width of Compiler View
	height_dv=0;
	height_cv=0;
#ifndef THETEXT
	if(bClipCompileView){
		if(pobj_Debugger->IsDebuggerView()){
			//fobKr[\ĂƂ
			height_dv=pobj_nv->height_ClipDebuggerView+LEVER_THICK;
		}
		if(hCompileView){
			//RpCr[\ĂƂ
			height_cv=pobj_nv->height_ClipCompileView+LEVER_THICK;
		}
	}
#endif

	int width_pjv=0;	//Width of Project View
	if(pobj_nv->bClipProjectView){
		if(IsWindowVisible(hProjectView)){
			//vWFNgr[\ĂƂ
			width_pjv=pobj_nv->width_ClipProjectView+LEVER_THICK;
		}
	}

	int width_SideWeb=0;
	if(pobj_SideWeb->bShow){
		width_SideWeb=pobj_nv->width_WebSearchView+LEVER_THICK;
	}

	//MDINCAg̍
	height_MdiClient=height_owner-(
		height_Rebar+
		height_dv+
		height_cv+
		height_Statusbar
		);

	//^uRg[
	int tab_height;
	if(TabCtrl_GetItemCount(pobj_MainTab->hTab)==0) tab_height=0;
	else{
		RECT rc;
		TabCtrl_GetItemRect(pobj_MainTab->hTab,0,&rc);
		tab_height=rc.bottom-rc.top;
	}
	MoveWindow(pobj_MainTab->hTab,
		width_pjv,
		height_Rebar,
		width_owner-width_pjv-width_SideWeb,
		tab_height,
		1);

	//MDINCAg
	MoveWindow(hClient,
		width_pjv,
		height_Rebar+tab_height,
		width_owner-width_pjv-width_SideWeb,
		height_MdiClient-tab_height,
		1);

	if(pobj_SideWeb->bShow){
		//SideWeb
		pobj_SideWeb->resize(
			width_owner - pobj_nv->width_WebSearchView,
			height_Rebar,
			pobj_nv->width_WebSearchView,
			height_MdiClient);
	}
	else pobj_SideWeb->resize(0,0,0,0);

	if(width_pjv){
		//vWFNgr[
		MoveWindow(hProjectView,
			0,
			height_Rebar,
			pobj_nv->width_ClipProjectView,
			height_MdiClient,
			1);
		InvalidateRect(hProjectView,NULL,0);
	}

	if(height_dv){
#ifndef THETEXT
		//fobKr[
		pobj_Debugger->resize(
			0,
			height_Rebar+height_MdiClient+LEVER_THICK,
			width_owner,
			pobj_nv->height_ClipDebuggerView);
#endif
	}
	if(height_cv){
		//RpCr[
		MoveWindow(hCompileView,
			0,
			height_Rebar+height_MdiClient+height_dv+LEVER_THICK,
			width_owner,
			pobj_nv->height_ClipCompileView,
			1);
	}
}
LRESULT CALLBACK WindowFunc(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam){
	int i,i2,i3,WndNum;
	char str[MAX_PATH],temporary[1024],temp2[MAX_PATH],temp3[MAX_PATH],*pTemp;
	HWND hChild,hEdit;
	RECT rect;
	POINT pos;
	LPTOOLTIPTEXT TipText;
	LPNMHDR lpnmhdr;
	NMPGCALCSIZE *lpCalcSize;
	NMPGSCROLL *lpScroll;
	HDROP hDrop;
	HGLOBAL hGlobal;
	CHARRANGE CharRange;
	HANDLE hFile;
	BOOL bChecked;

	static COLORREF colorUser=RGB(255,255,255);

	if(message==WM_COMMAND&&IS_FILEHISTORY_COMMAND(LOWORD(wParam))){
		//uŋߎgt@Cvj[R}h
		lstrcpy(str,pobj_nv->pobj_History->lpszPath[LOWORD(wParam)-100]);
		OpenFileWithExtension(str);
		return 0;
	}

	if(message==WM_COMMAND&&200<=LOWORD(wParam)&&LOWORD(wParam)<=299){
		//uŋߎgvWFNgvj[R}h
		lstrcpy(str,pobj_nv->pobj_ProjectHistory->lpszPath[LOWORD(wParam)-200]);
		OpenFileWithExtension(str);
		return 0;
	}

	switch(message){
		case WM_CREATE:
			SetupWindow(hwnd);

			//eLXgGfB^tHgݒ
			ResetTextEditFont(hwnd);

			if(bProfessional){
				//Proł͎obNAbvyѕ@\Lɂ

				//obNAbvp^C}[ݒi10bɈj
				SetTimer(hwnd,ID_TIMER_BACKUP,10000,NULL);
			}

			return 0;


		case WM_TIMER:
			if(wParam==ID_TIMER_BACKUP){
				if(bProfessional){
					//Proł͎obNAbvyѕ@\Lɂ
					_beginthread(backup,0,0);
				}
			}

#ifndef THETEXT
			if(wParam==ID_DEBUGSAFTY){
				//BasicCompiler.exeIĂ邩ǂ
				pobj_Debugger->SaftyCheck();
			}
#endif

			return 0;


		case WM_DRAWCLIPBOARD:
			ResetState_EditMenu();
			return 0;

		case WM_MENUSELECT:
			MenuAdvice(wParam);
			return 0;
		case WM_INITMENU:
			pobj_nv->pobj_History->ResetFileMenu(pobj_FileHistoryMenu,1);
#ifndef THETEXT
			pobj_nv->pobj_ProjectHistory->ResetFileMenu(pobj_ProjectHistoryMenu,0);
#endif
			return 0;
		case WM_MEASUREITEM:
			LPMEASUREITEMSTRUCT lpMI;
			lpMI = (LPMEASUREITEMSTRUCT)lParam;
			if(lpMI->CtlType==ODT_MENU){
				SIZE size;
				CMenuItemData *pobj_MenuItemData;
				pobj_MenuItemData=(CMenuItemData *)lpMI->itemData;
				if(pobj_MenuItemData->pobj_ThisMenu->hMenu==pobj_MainMenu->hMenu){
					//Cj[̐eACe
					pobj_MainMenu->GetItemSize(pobj_MenuItemData->item_index,&size);
					lpMI->itemWidth = size.cx;
					lpMI->itemHeight = size.cy;
				}
				else{
					//Cj[ɂԂ炳Tuj[
					pobj_MenuItemData->pobj_ThisMenu->GetItemSize(pobj_MenuItemData->item_index,&size);
					lpMI->itemWidth = size.cx;
					lpMI->itemHeight = size.cy;
				}
			}
			return 0;

		case WM_DRAWITEM:
			DRAWITEMSTRUCT *pdis;
			pdis=(DRAWITEMSTRUCT *)lParam;

			if(pdis->CtlType==ODT_MENU){
				if(!pobj_MainMenu) return 0;

				CMenuItemData *pobj_MenuItemData;
				pobj_MenuItemData=(CMenuItemData *)pdis->itemData;
				if(pobj_MainMenu->hMenu==pobj_MenuItemData->pobj_ThisMenu->hMenu){
					//Cj[̐eACe
					pobj_MainMenu->OwnerDrawMenu(pdis->hDC,
						&pdis->rcItem,
						(pdis->itemState&ODS_SELECTED)!=0,
						pobj_MenuItemData->item_index);
				}
				else{
					//Cj[ɂԂ炳Tuj[
					pobj_MainMenu->OwnerDrawSubMenu(pobj_MenuItemData->pobj_ThisMenu->hMenu,
						pdis->hDC,
						&pdis->rcItem,
						(pdis->itemState&ODS_SELECTED)!=0,
						pobj_MenuItemData->item_index);
				}
			}
			return 0;

		case WM_NOTIFY:
			if(!lParam) return 0;
			TipText=(LPTOOLTIPTEXT)lParam;
			if(TipText->hdr.code==TTN_NEEDTEXT) ShowToolTipText(TipText);
			lpnmhdr=(LPNMHDR)lParam;

			extern HWND hStandardToolbarPager;
			extern HWND hDebuggerToolbarPager;
			if(pobj_Rebar){
				//o[IuWFNg݂Ƃ
				if(lpnmhdr->hwndFrom==pobj_Rebar->hRebar&&lpnmhdr->code==RBN_HEIGHTCHANGE){
					ResizeOwnerWnd();
					return 0;
				}
			}
			if(lpnmhdr->hwndFrom==hStandardToolbarPager){
				if(lpnmhdr->code==PGN_CALCSIZE){
					lpCalcSize=(LPNMPGCALCSIZE)lParam;
					if(lpCalcSize->dwFlag==PGF_CALCWIDTH)
						lpCalcSize->iWidth=BMPNUM_STANDARDTOOLBAR*23+SEPNUM_STANDARDTOOLBAR*8;
				}
				else if(lpnmhdr->code==PGN_SCROLL){
					lpScroll=(LPNMPGSCROLL)lParam;
					lpScroll->iScroll=20;
				}
			}
			else if(lpnmhdr->hwndFrom==hDebuggerToolbarPager){
				if(lpnmhdr->code==PGN_CALCSIZE){
					lpCalcSize=(LPNMPGCALCSIZE)lParam;
					if(lpCalcSize->dwFlag==PGF_CALCWIDTH)
						lpCalcSize->iWidth=BMPNUM_DEBUGGERTOOLBAR*23+SEPNUM_DEBUGGERTOOLBAR*8;
				}
				else if(lpnmhdr->code==PGN_SCROLL){
					lpScroll=(LPNMPGSCROLL)lParam;
					lpScroll->iScroll=20;
				}
			}

			NMHDR *hdr;
			hdr=(NMHDR *)lParam;
			if(pobj_MainTab){
				if(hdr->hwndFrom==pobj_MainTab->hTab){
					if(hdr->code==TCN_SELCHANGE)
						pobj_MainTab->SelChangeEvent();

					if(hdr->code==NM_RCLICK){

						if(!bProfessional){
							//t[ł̏ꍇ̓^ủENbNj[r
							return 0;
						}


						TCHITTESTINFO tcHitTest;
						GetCursorPos(&tcHitTest.pt);
						ScreenToClient(pobj_MainTab->hTab,&tcHitTest.pt);
						i=TabCtrl_HitTest(pobj_MainTab->hTab,&tcHitTest);
						if(i==-1) return 0;

						TabCtrl_SetCurSel(pobj_MainTab->hTab,i);

						pobj_MainTab->SelChangeEvent();


						/////////////////////
						// j[\
						/////////////////////

						hChild=GetWindow(hClient,GW_CHILD);
						WndNum=GetWndNum(hChild);

						//ۑR}h̕Zbg
						MENUITEMINFO mii;
						mii.cbSize=sizeof(MENUITEMINFO);
						mii.fMask=MIIM_TYPE;
						mii.dwTypeData=temporary;
						mii.fType=MFT_STRING;
						if(MdiInfo[WndNum].path[0]){
							_splitpath(MdiInfo[WndNum].path,NULL,NULL,temporary,temp2);
							lstrcat(temporary,temp2);
							lstrcat(temporary," ۑ(&S)");
						}
						else{
							lstrcpy(temporary,"ۑ(&S)");
						}
						SetMenuItemInfo(hTabMenu,IDM_SAVE,FALSE,&mii);

						/*u΃pXRs[vutH_Jvut@C폜v
														R}hꍇɂĖɂ */
						if(MdiInfo[WndNum].path[0]){
							EnableMenuItem(hTabMenu,IDM_PATH_COPY,MF_BYCOMMAND|MF_ENABLED);
							EnableMenuItem(hTabMenu,IDM_FOLDER_OPEN,MF_BYCOMMAND|MF_ENABLED);
							EnableMenuItem(hTabMenu,IDM_DELETE_FILE,MF_BYCOMMAND|MF_ENABLED);
						}
						else{
							EnableMenuItem(hTabMenu,IDM_PATH_COPY,MF_BYCOMMAND|MF_GRAYED);
							EnableMenuItem(hTabMenu,IDM_FOLDER_OPEN,MF_BYCOMMAND|MF_GRAYED);
							EnableMenuItem(hTabMenu,IDM_DELETE_FILE,MF_BYCOMMAND|MF_GRAYED);
						}

						POINT MousePos;
						GetCursorPos(&MousePos);
						TrackPopupMenu(hTabMenu,TPM_LEFTALIGN|TPM_RIGHTBUTTON,MousePos.x,MousePos.y,0,hOwner,NULL);
					}
				}
			}
			if(pobj_SideWeb){
				if(hdr->hwndFrom==pobj_SideWeb->hTab&&hdr->code==TCN_SELCHANGE){
					pobj_SideWeb->SelChangeEvent();
				}
			}

			return 0;
		case WM_COMMAND:
			switch(LOWORD(wParam)){
				case IDM_NEW:
					CreateNewFile();
					return 0;
				case IDM_OPEN:
					//"t@Cw肵Ă"
					if(!GetFilePathDialog(hwnd,str,DefFileFilter,STRING_FILEOPENTITLE_DEFAULT,TRUE)) return 0;

					OpenFileWithExtension(str);
					return 0;
				case IDM_CLOSE:
					hChild=GetWindow(hClient,GW_CHILD);
					if(IsWindow(hChild)) SendMessage(hChild,WM_CLOSE,0,0);
					return 0;
#ifndef THETEXT
				case IDM_PROJECT_OPEN:
					//"vWFNg t@Cw肵ĉ"
					if(!GetFilePathDialog(hwnd,str,ProjectFileFilter,STRING_FILEOPENTITLE_PROJECT,TRUE)) return 0;

					OpenProject(str);
					return 0;
				case IDM_PROJECT_SAVE:
					SaveProject();
					return 0;
				case IDM_PROJECT_CLOSE:
					CloseProject();
					return 0;
				case IDM_PROJECT_FOLDER_OPEN:
					ShellExecute(hwnd,"explore",ProjectInfo.dir,NULL,NULL,SW_SHOWNORMAL);
					return 0;
#endif
				case IDM_SAVE:
					SaveDocument(GetWindow(hClient,GW_CHILD),NULL);
					return 0;
				case IDM_NEWSAVE:
					//"ۑ̃t@Cw肵Ă"
					if(!GetFilePathDialog(hwnd,str,DefFileFilter,STRING_FILESAVETITLE_DEFAULT,FALSE)) return 0;

					SaveDocument(GetWindow(hClient,GW_CHILD),str);
					return 0;
				case IDM_CODE_SAVE:
					//R[hw肵ĕۑ
					DialogBox(hResInst,MAKEINTRESOURCE(IDD_CODE_SAVE),hOwner,nkfDlgCodeSave);
					return 0;
				case IDM_ALLSAVE:
					for(i=0;i<MAX_WNDNUM;i++){
						if(MdiInfo[i].hwnd) SaveDocument(MdiInfo[i].hwnd,NULL);
					}
					if(ProjectInfo.name[0]) SaveProject();
					return 0;

				case IDM_PAGESET:
					//y[Wݒ
					obj_Page.SetupDlg();
					return 0;

				case IDM_PREVIEW:
					//vr[iProł̂݁j
					Preview();
					return 0;

				case IDM_PRINTOUT:
					//
					Printout();
					return 0;

				case IDM_EXIT:
					SendMessage(hwnd,WM_CLOSE,0,0);
					return 0;
				case IDM_UNDO:
				case (WORD)IDM_ACCEL_UNDO:
					hChild=GetWindow(hClient,GW_CHILD);
					if(!hChild) return 0;
					WndNum=GetWndNum(hChild);
					if(IS_DOCUMENT_TEXT(MdiInfo[WndNum].DocType))
						TextEdit_UndoCommand(WndNum);
					else if(MdiInfo[WndNum].DocType==WNDTYPE_RAD)
						Rad_UndoCommand(WndNum);
					else if(MdiInfo[WndNum].DocType==WNDTYPE_ICONEDIT)
						IconEdit_UndoCommand(WndNum);
					return 0;
				case IDM_REDO:
				case (WORD)IDM_ACCEL_REDO:
					hChild=GetWindow(hClient,GW_CHILD);
					if(!hChild) return 0;
					WndNum=GetWndNum(hChild);
					if(IS_DOCUMENT_TEXT(MdiInfo[WndNum].DocType))
						TextEdit_RedoCommand(WndNum);
					else if(MdiInfo[WndNum].DocType==WNDTYPE_RAD)
						Rad_RedoCommand(WndNum);
					else if(MdiInfo[WndNum].DocType==WNDTYPE_ICONEDIT)
						IconEdit_RedoCommand(WndNum);
					return 0;
				case IDM_CUT:
					hChild=GetWindow(hClient,GW_CHILD);
					WndNum=GetWndNum(hChild);
					if(IS_DOCUMENT_TEXT(MdiInfo[WndNum].DocType)){
						hEdit=GetWindow(hChild,GW_CHILD);

						TextEdit_GetSel(WndNum,&CharRange);

						hGlobal=(char *)GlobalAlloc(GMEM_MOVEABLE,CharRange.cpMax-CharRange.cpMin+1);
						pTemp=(char *)GlobalLock(hGlobal);
						memcpy(pTemp,MdiInfo[WndNum].pmti->buffer+CharRange.cpMin,CharRange.cpMax-CharRange.cpMin);
						pTemp[CharRange.cpMax-CharRange.cpMin]=0;
						GlobalUnlock(hGlobal);

						//Nbv{[hɕۑ
						OpenClipboard(hwnd);
						EmptyClipboard();
						SetClipboardData(CF_TEXT,hGlobal);
						CloseClipboard();

						//I𕶎
						SendMessage(hEdit,WM_KEYDOWN,VK_DELETE,0);
					}
					else if(MdiInfo[WndNum].DocType==WNDTYPE_RAD){
						i2=GetWndInfoNum(MdiInfo[WndNum].path);

						//Nbv{[hɊi[邽߂̃f[^pӂ
						ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[WndNum].MdiRadInfo->SelectingItem[0]].pos.x-=17;
						ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[WndNum].MdiRadInfo->SelectingItem[0]].pos.y-=10;
						hGlobal=Rad_GetChildInfoClipboardData(WndNum,i2);
						ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[WndNum].MdiRadInfo->SelectingItem[0]].pos.x+=17;
						ProjectInfo.pWindowInfo[i2].pChildInfo[MdiInfo[WndNum].MdiRadInfo->SelectingItem[0]].pos.y+=10;

						OpenClipboard(hwnd);
						EmptyClipboard();
						SetClipboardData(dwRadClipboardID,hGlobal);
						CloseClipboard();

						SendMessage(MdiInfo[WndNum].MdiRadInfo->hRad,WM_COMMAND,IDM_RAD_ITEM_DELETE,0);
					}
					else if(MdiInfo[WndNum].DocType==WNDTYPE_ICONEDIT){
						//Nbv{[hɊi[邽߂̃f[^pӂ
						hGlobal=IconEdit_GetChildInfoClipboardData(WndNum);
						if(hGlobal==0) return 0;

						OpenClipboard(hwnd);
						EmptyClipboard();
						SetClipboardData(CF_BITMAP,hGlobal);
						CloseClipboard();

						DeleteObject(MdiInfo[WndNum].MdiIconEditInfo->hSelectingBmp);
						MdiInfo[WndNum].MdiIconEditInfo->SelectLevel=0;

						IconEdit_EraseRect(WndNum,&MdiInfo[WndNum].MdiIconEditInfo->DraggingRect);
					}
					return 0;
				case IDM_COPY:
					hChild=GetWindow(hClient,GW_CHILD);
					WndNum=GetWndNum(hChild);
					if(IS_DOCUMENT_TEXT(MdiInfo[WndNum].DocType)){
						hEdit=GetWindow(hChild,GW_CHILD);

						TextEdit_GetSel(WndNum,&CharRange);

						hGlobal=(char *)GlobalAlloc(GMEM_MOVEABLE,CharRange.cpMax-CharRange.cpMin+1);
						pTemp=(char *)GlobalLock(hGlobal);
						memcpy(pTemp,MdiInfo[WndNum].pmti->buffer+CharRange.cpMin,CharRange.cpMax-CharRange.cpMin);
						pTemp[CharRange.cpMax-CharRange.cpMin]=0;
						GlobalUnlock(hGlobal);

						//Nbv{[hɕۑ
						OpenClipboard(hwnd);
						EmptyClipboard();
						SetClipboardData(CF_TEXT,hGlobal);
						CloseClipboard();
					}
					else if(MdiInfo[WndNum].DocType==WNDTYPE_RAD){
						i2=GetWndInfoNum(MdiInfo[WndNum].path);

						//Nbv{[hɊi[邽߂̃f[^pӂ
						hGlobal=Rad_GetChildInfoClipboardData(WndNum,i2);

						OpenClipboard(hwnd);
						EmptyClipboard();
						SetClipboardData(dwRadClipboardID,hGlobal);
						CloseClipboard();
					}
					else if(MdiInfo[WndNum].DocType==WNDTYPE_ICONEDIT){
						//Nbv{[hɊi[邽߂̃f[^pӂ
						hGlobal=IconEdit_GetChildInfoClipboardData(WndNum);

						OpenClipboard(hwnd);
						EmptyClipboard();
						SetClipboardData(CF_BITMAP,hGlobal);
						CloseClipboard();
					}
					return 0;
				case IDM_PASTE:
					hChild=GetWindow(hClient,GW_CHILD);
					WndNum=GetWndNum(hChild);
					if(IS_DOCUMENT_TEXT(MdiInfo[WndNum].DocType)){
						hEdit=GetWindow(hChild,GW_CHILD);

						//Nbv{[hJ
						OpenClipboard(hwnd);
						hGlobal=GetClipboardData(CF_TEXT);
						if(!hGlobal){
							CloseClipboard();
							return 0;
						}


						if(pobj_nv->bPasteIndent){
							//Cfg`
							pTemp=CodeFormatter((char *)GlobalLock(hGlobal));
							GlobalUnlock(hGlobal);
						}
						else pTemp=(char *)GlobalLock(hGlobal);


						//eLXgGfB^̕vCX
						TextEdit_ReplaceUpdateUndoData(WndNum,
							pTemp,
							1,
							1);

						if(pobj_nv->bPasteIndent)
							HeapDefaultFree(pTemp);
						else
							GlobalUnlock(hGlobal);

						//Nbv{[h
						CloseClipboard();


						//Lbgʒu܂ŃXN[
						TextEdit_ScrollCaret(WndNum,0);
						ResetCaretPos(WndNum);
					}
					else if(MdiInfo[WndNum].DocType==WNDTYPE_RAD){
						OpenClipboard(hwnd);
						hGlobal=GetClipboardData(dwRadClipboardID);
						if(!hGlobal){
							CloseClipboard();
							return 0;
						}
						Rad_PasteChildInfoClipboardData(WndNum,hGlobal);
						CloseClipboard();
					}
					else if(MdiInfo[WndNum].DocType==WNDTYPE_ICONEDIT){
						OpenClipboard(hwnd);
						hGlobal=GetClipboardData(CF_BITMAP);
						if(!hGlobal){
							CloseClipboard();
							return 0;
						}
						IconEdit_PasteChildInfoClipboardData(WndNum,(HBITMAP)hGlobal);
						CloseClipboard();
					}
					return 0;
				case IDM_DELETE:
					hChild=GetWindow(hClient,GW_CHILD);
					WndNum=GetWndNum(hChild);
					if(IS_DOCUMENT_TEXT(MdiInfo[WndNum].DocType)){
						hEdit=GetWindow(hChild,GW_CHILD);
						TextEdit_ReplaceUpdateUndoData(WndNum,"",0,1);
					}
					else if(MdiInfo[WndNum].DocType==WNDTYPE_RAD)
						SendMessage(MdiInfo[WndNum].MdiRadInfo->hRad,WM_COMMAND,IDM_RAD_ITEM_DELETE,0);
					return 0;
				case IDM_ALLSELECT:
					hChild=GetWindow(hClient,GW_CHILD);
					WndNum=GetWndNum(hChild);
					if(IS_DOCUMENT_TEXT(MdiInfo[WndNum].DocType)){
						hEdit=GetWindow(hChild,GW_CHILD);

						MdiInfo[WndNum].pmti->StartCaretPos.x=0;
						MdiInfo[WndNum].pmti->StartCaretPos.y=0;

						GetCaretPosFromBufferIndex(
							MdiInfo[WndNum].pmti->buffer,
							lstrlen(MdiInfo[WndNum].pmti->buffer),
							&MdiInfo[WndNum].pmti->EndCaretPos);

						InvalidateRect(hEdit,NULL,0);

						ResetState_EditMenu();
					}
					else if(MdiInfo[WndNum].DocType==WNDTYPE_RAD){
						i2=GetWndInfoNum(MdiInfo[WndNum].path);
						for(i3=0;i3<ProjectInfo.pWindowInfo[i2].NumberOfChildWindows;i3++){
							MdiInfo[WndNum].MdiRadInfo->SelectingItem[i3]=i3;
						}
						DrawRadWindow(WndNum,&ProjectInfo.pWindowInfo[i2]);
					}
					return 0;
				case IDM_FIND:
					DialogBox(hResInst,MAKEINTRESOURCE(IDD_FIND),hOwner,DlgFind);
					return 0;
				case IDM_PERMUTATION:
					DialogBox(hResInst,MAKEINTRESOURCE(IDD_PERMUTATION),hOwner,DlgPermutation);
					return 0;


				///////////////////////
				// ϊj[
				///////////////////////
				case IDM_CONV_ALPHA_SMALL:
				case IDM_CONV_ALPHA_BIG:
				case IDM_CONV_HALF:
				case IDM_CONV_MULTI:
				case IDM_CONV_KATAKANA:
				case IDM_CONV_HIRAGANA:
				case IDM_CONV_SPACE:
				case IDM_CONV_TAB:
#ifdef THETEXT
				case IDM_CONV_HASRETURN:
				case IDM_CONV_QUOTE:
#else
				case IDM_CODEFORMAT:
#endif
					TextEdit_Convert(LOWORD(wParam));
					return 0;

#ifdef THETEXT
				///////////////////////
				// c[j[
				///////////////////////
				case IDM_STRING_COUNT:
					DialogBoxParam(hResInst,MAKEINTRESOURCE(IDD_STRING_COUNT),hOwner,DlgStringCount,0);
					return 0;
				case IDM_SEL_STRING_COUNT:
					DialogBoxParam(hResInst,MAKEINTRESOURCE(IDD_STRING_COUNT),hOwner,DlgStringCount,1);
					return 0;
#endif //THETEXT

				case IDM_PROJECTVIEW:
					if(pobj_nv->bClipProjectView){
						if(IsWindowVisible(hProjectView)){
							ShowWindow(hProjectView,SW_HIDE);
							bChecked=0;
						}
						else{
							ShowWindow(hProjectView,SW_SHOW);
							bChecked=1;
						}
					}
					else{
						if(IsWindowVisible(hProjectView_ToolWindow)){
							ShowWindow(hProjectView_ToolWindow,SW_HIDE);
							bChecked=0;
						}
						else{
							ShowWindow(hProjectView_ToolWindow,SW_SHOW);
							ShowWindow(hProjectView,SW_SHOW);
							bChecked=1;
						}
					}
					pobj_MainMenu->CheckMenu(IDM_PROJECTVIEW,bChecked);

					//Ĕzu
					ResizeOwnerWnd();

					ShowWindow(hClient,SW_SHOW);
					return 0;
				case IDM_PROJECT_OPTION:
					DlgProjectOptionSetting(hwnd);
					return 0;
				case IDM_TOPMOST:
					if(pobj_MainMenu->IsCheck(IDM_TOPMOST)){
						SetWindowPos(hwnd,HWND_NOTOPMOST,0,0,0,0,SWP_NOMOVE|SWP_NOSIZE);
						pobj_MainMenu->CheckMenu(IDM_TOPMOST,0);
					}
					else{
						SetWindowPos(hwnd,HWND_TOPMOST,0,0,0,0,SWP_NOMOVE|SWP_NOSIZE);
						pobj_MainMenu->CheckMenu(IDM_TOPMOST,1);
					}
					return 0;

#ifdef THETEXT
				case IDM_RIGHT_TURN:
					pobj_nv->bRightTurn^=1;
					ResetState_ViewMenu();

					//gbṽEBhEĕ`
					RedrawAllWindow();

					return 0;
#endif

				case IDM_SET:
					DlgOptionSetting(hwnd);
					return 0;

#ifndef THETEXT
				case IDM_DEBUG:
					if(pobj_Debugger->IsDebugging()){
						pobj_Debugger->DebugContinue();
						return 0;
					}

					hChild=GetWindow(hClient,GW_CHILD);
					if(ProjectInfo.name[0]){
						//vWFNgJĂꍇ
						if(!SetProjectToRun()) return 0;

						//fobOp̃R}hCyюs\t@CiDLL̂݁j
						sprintf(temporary,"%s\r\n%s",ProjectInfo.szExePath,ProjectInfo.szCmdLine);
						sprintf(temp2,"%spgm.tmp",pj_editor_Dir);
						hFile=CreateFile(temp2,GENERIC_WRITE,0,NULL,CREATE_ALWAYS,FILE_ATTRIBUTE_ARCHIVE|FILE_ATTRIBUTE_HIDDEN|FILE_ATTRIBUTE_TEMPORARY,NULL);
						DWORD dwAccessBytes;
						WriteFile(hFile,temporary,lstrlen(temporary),&dwAccessBytes,NULL);
						CloseHandle(hFile);

						//\[Xt@Ctemp2
						ProjectInfo.pobj_DBFileInfo->ppobj_FileInfo[0]->GetFullPath(temp2);

						//o̓t@Ctemp3
						lstrcpy(temp3,ProjectInfo.lpszOutput_Debug);
						GetFullPath(temp3,ProjectInfo.dir);

						if(IsNeedCompileForProject(1))
							sprintf(temporary,"\"%s\" \"%s\" /debug /run /wnd:%08x",temp2,temp3,hwnd);
						else
							sprintf(temporary,"\"%s\" \"%s\" /run /wnd:%08x",temp2,temp3,hwnd);

						//DLLIvV
						if(ProjectInfo.dwModuleType==MT_DLL) lstrcat(temporary," /dll");

						//u[N|CgZ[u
						ProjectInfo.pobj_DBBreakPoint->SaveToTempFile();
					}
					else{
						//Pƃ\[XR[h
						if(!SetRunning(hChild)) return 0;
						if(IsNeedCompile(MdiInfo[GetWndNum(hChild)].path,1))
							sprintf(temporary,"\"%s\" /debug /run /wnd:%08x",MdiInfo[GetWndNum(hChild)].path,hwnd);
						else
							sprintf(temporary,"\"%s\" /run /wnd:%08x",MdiInfo[GetWndNum(hChild)].path,hwnd);

						//u[N|CgZ[u
						pobj_DBBreakPoint->SaveToTempFile();
					}

					//RpCr[Nbv邩ǂ
					if(bClipCompileView){
						lstrcat(temporary," /clip_compile_view");

						//RpCr[
						if(hCompileView==(HWND)-1) return 0;
						if(hCompileView){
							hChild=hCompileView;
							hCompileView=(HWND)-1;
							SendMessage(hChild,WM_COMMAND,IDCANCEL,0);
						}

						//dNh~̂
						hCompileView=(HWND)-1;
					}

					sprintf(str,"%s%s",pj_editor_Dir,lpszCompilerName);
					ShellExecute(hwnd,"open",str,temporary,NULL,SW_SHOWNORMAL);
					return 0;
				case IDM_DEBUGCOMPILE:
					hChild=GetWindow(hClient,GW_CHILD);
					if(ProjectInfo.name[0]){
						//vWFNgJĂꍇ
						if(!SetProjectToRun()) return 0;

						//\[Xt@Ctemp2
						ProjectInfo.pobj_DBFileInfo->ppobj_FileInfo[0]->GetFullPath(temp2);

						//o̓t@Ctemp3
						lstrcpy(temp3,ProjectInfo.lpszOutput_Debug);
						GetFullPath(temp3,ProjectInfo.dir);

						sprintf(temporary,"\"%s\" \"%s\" /debug /wnd:%08x",temp2,temp3,hwnd);

						//DLLIvV
						if(ProjectInfo.dwModuleType==MT_DLL) lstrcat(temporary," /dll");
					}
					else{
						//Pƃ\[XR[h
						if(!SetRunning(hChild)) return 0;
						sprintf(temporary,"\"%s\" /debug /wnd:%08x",MdiInfo[GetWndNum(hChild)].path,hwnd);
					}

					//RpCr[Nbv邩ǂ
					if(bClipCompileView){
						lstrcat(temporary," /clip_compile_view");

						//RpCr[
						if(hCompileView==(HWND)-1) return 0;
						if(hCompileView){
							hChild=hCompileView;
							hCompileView=(HWND)-1;
							SendMessage(hChild,WM_COMMAND,IDCANCEL,0);
						}

						//dNh~̂
						hCompileView=(HWND)-1;	
					}

					//CN[hfBNg
					sprintf(temp2," /include_dir:\"%s\"",pobj_nv->szIncludeDir);
					lstrcat(temporary,temp2);

					sprintf(str,"%s%s",pj_editor_Dir,lpszCompilerName);
					ShellExecute(hwnd,"open",str,temporary,NULL,SW_SHOWNORMAL);

					return 0;
				case IDM_ATTACH:
					int idProcess;
					DWORD dwPlatform;
					idProcess=DialogBoxParam(hResInst,MAKEINTRESOURCE(IDD_ATTACH),hwnd,DlgAttach,(LPARAM)&dwPlatform);
					if(idProcess==0) return 0;

					sprintf(temporary,"/attach:%08x /wnd:%08x",idProcess,hwnd);

					//RpCr[Nbv邩ǂ
					if(bClipCompileView){
						lstrcat(temporary," /clip_compile_view");

						//RpCr[
						if(hCompileView==(HWND)-1) return 0;
						if(hCompileView){
							hChild=hCompileView;
							hCompileView=(HWND)-1;
							SendMessage(hChild,WM_COMMAND,IDCANCEL,0);
						}

						//dNh~̂
						hCompileView=(HWND)-1;
					}

					//CN[hfBNg
					sprintf(temp2," /include_dir:\"%s\"",pobj_nv->szIncludeDir);
					lstrcat(temporary,temp2);

					if(dwPlatform==IMAGE_FILE_MACHINE_I386)
						sprintf(str,"%s%s",pj_editor_Dir,WIN32_COMPILER_NAME);
					else if(dwPlatform==IMAGE_FILE_MACHINE_AMD64)
						sprintf(str,"%s%s",pj_editor_Dir,WIN64_COMPILER_NAME);

					ShellExecute(hwnd,"open",str,temporary,NULL,SW_SHOWNORMAL);
					return 0;
				case IDM_RELEASECOMPILE:
					hChild=GetWindow(hClient,GW_CHILD);
					if(ProjectInfo.name[0]){
						//vWFNgJĂꍇ
						if(!SetProjectToRun()) return 0;

						//\[Xt@Ctemp2
						ProjectInfo.pobj_DBFileInfo->ppobj_FileInfo[0]->GetFullPath(temp2);

						//o̓t@Ctemp3
						lstrcpy(temp3,ProjectInfo.lpszOutput_Release);
						GetFullPath(temp3,ProjectInfo.dir);

						sprintf(temporary,"\"%s\" \"%s\" /wnd:%08x",temp2,temp3,hwnd);

						//DLLIvV
						if(ProjectInfo.dwModuleType==MT_DLL) lstrcat(temporary," /dll");
					}
					else{
						//Pƃ\[XR[h
						if(!SetRunning(hChild)) return 0;
						sprintf(temporary,"\"%s\" /wnd:%08x",MdiInfo[GetWndNum(hChild)].path,hwnd);
					}

					//RpCr[Nbv邩ǂ
					if(bClipCompileView){
						lstrcat(temporary," /clip_compile_view");

						//RpCr[
						if(hCompileView==(HWND)-1) return 0;
						if(hCompileView){
							hChild=hCompileView;
							hCompileView=(HWND)-1;
							SendMessage(hChild,WM_COMMAND,IDCANCEL,0);
						}

						//dNh~̂
						hCompileView=(HWND)-1;
					}

					//CN[hfBNg
					sprintf(temp2," /include_dir:\"%s\"",pobj_nv->szIncludeDir);
					lstrcat(temporary,temp2);

					sprintf(str,"%s%s",pj_editor_Dir,lpszCompilerName);
					ShellExecute(hwnd,"open",str,temporary,NULL,SW_SHOWNORMAL);
					return 0;
				case IDM_RELEASERUN:
					hChild=GetWindow(hClient,GW_CHILD);
					if(ProjectInfo.name[0]){
/*						//vWFNgJĂꍇ
						if(!SetProjectToRun()) return 0;

						//Kvł΃[XRpC
						if(IsNeedCompileForProject(0))
							SendMessage(hwnd,WM_COMMAND,IDM_RELEASECOMPILE,0);*/

						if(ProjectInfo.dwModuleType==MT_DLL){
							lstrcpy(temporary,ProjectInfo.szExePath);
						}
						else{
							lstrcpy(temporary,ProjectInfo.lpszOutput_Debug);
							GetFullPath(temporary,ProjectInfo.dir);
						}
					}
					else{
/*						//Kvł΃[XRpC
						if(!SetRunning(hChild)) return 0;

						if(IsNeedCompile(MdiInfo[GetWndNum(hChild)].path,0))
							SendMessage(hwnd,WM_COMMAND,IDM_RELEASECOMPILE,0);*/

						//Pƃ\[XR[h
						_splitpath(MdiInfo[GetWndNum(hChild)].path,temporary,temp2,temp3,NULL);
						lstrcat(temporary,temp2);
						lstrcat(temporary,temp3);
						lstrcat(temporary,".exe");
					}

					//CN[hfBNg
					sprintf(temp2," /include_dir:\"%s\"",pobj_nv->szIncludeDir);
					lstrcat(temporary,temp2);

					ShellExecute(hwnd,"open",temporary,NULL,NULL,SW_SHOWNORMAL);
					return 0;


				////////////////////////
				// fobO R}h
				////////////////////////

				case IDM_STEP_IN:
					pobj_Debugger->StepIn();
					break;
				case IDM_STEP_OVER:
					pobj_Debugger->StepOver();
					break;
				case IDM_STEP_CURSOR:
					pobj_Debugger->StepToCursor();
					break;
				case IDM_BREAKPOINT:
					if(ProjectInfo.name[0]){
						ProjectInfo.pobj_DBBreakPoint->Event_BreakPoint();
					}
					else{
						pobj_DBBreakPoint->Event_BreakPoint();
					}
					break;
				case IDM_DEBUG_STOP:
					pobj_Debugger->DebugStop();
					break;
				case IDM_DEBUG_PAUSE:
					pobj_Debugger->DebugPause();
					break;


				case IDM_COMMUNITY:
					ShellExecute(hwnd,"open","iexplore.exe",
						"http://www.activebasic.com/forum/",
						NULL,SW_SHOWNORMAL);
					return 0;
				case IDM_COMMU_SEARCH:
					ShellExecute(hwnd,"open","iexplore.exe",
						"http://www.activebasic.com/forum/search.php",
						NULL,SW_SHOWNORMAL);
					return 0;
				case IDM_COMMU_PM:
					ShellExecute(hwnd,"open","iexplore.exe",
						"http://www.activebasic.com/forum/privmsg.php?folder=inbox",
						NULL,SW_SHOWNORMAL);
					return 0;
				case ID_COMMU_FORUM1:
					ShellExecute(hwnd,"open","iexplore.exe",
						"http://www.activebasic.com/forum/viewforum.php?f=1",
						NULL,SW_SHOWNORMAL);
					return 0;
				case ID_COMMU_FORUM2:
					ShellExecute(hwnd,"open","iexplore.exe",
						"http://www.activebasic.com/forum/viewforum.php?f=2",
						NULL,SW_SHOWNORMAL);
					return 0;
				case ID_COMMU_FORUM3:
					ShellExecute(hwnd,"open","iexplore.exe",
						"http://www.activebasic.com/forum/viewforum.php?f=5",
						NULL,SW_SHOWNORMAL);
					return 0;
				case ID_COMMU_FORUM4:
					ShellExecute(hwnd,"open","iexplore.exe",
						"http://www.activebasic.com/forum/viewforum.php?f=3",
						NULL,SW_SHOWNORMAL);
					return 0;
				case ID_COMMU_FORUM5:
					ShellExecute(hwnd,"open","iexplore.exe",
						"http://www.activebasic.com/forum/viewforum.php?f=6",
						NULL,SW_SHOWNORMAL);
					return 0;
				case ID_COMMU_FORUM6:
					ShellExecute(hwnd,"open","iexplore.exe",
						"http://www.activebasic.com/forum/viewforum.php?f=8",
						NULL,SW_SHOWNORMAL);
					return 0;
				case ID_COMMU_FORUM7:
					ShellExecute(hwnd,"open","iexplore.exe",
						"http://www.activebasic.com/forum/viewforum.php?f=4",
						NULL,SW_SHOWNORMAL);
					return 0;
				case ID_COMMU_FORUM8:
					ShellExecute(hwnd,"open","iexplore.exe",
						"http://www.activebasic.com/forum/viewforum.php?f=7",
						NULL,SW_SHOWNORMAL);
					return 0;
#endif //THETEXT


				case IDM_TOPIC:
#ifdef THETEXT
					sprintf(str,"%sTopics\\index.html",pj_editor_Dir);
					ShellExecute(hwnd,"open",str,NULL,NULL,SW_SHOWNORMAL);
#else
					sprintf(str,"%sBasicHelp.chm",pj_editor_Dir);
					HtmlHelp(NULL,str,HH_DISPLAY_TOPIC,0);
#endif
					return 0;

#ifdef THETEXT
				case IDM_DSHOMEPAGE:
					ShellExecute(hwnd,"open","http://www.discoversoft.net/",NULL,NULL,SW_SHOWNORMAL);
					return 0;
#else
				case IDM_AB_WEBSITE:
					ShellExecute(hwnd,"open","http://www.activebasic.com/",NULL,NULL,SW_SHOWNORMAL);
					return 0;
				case IDM_ACTBDL:
					ShellExecute(hwnd,"open","http://www.activebasic.com/activebasic5/download.htm",NULL,NULL,SW_SHOWNORMAL);
					return 0;
#endif

				case IDM_ABOUT:
					DialogBox(hResInst,MAKEINTRESOURCE(IDD_ABOUT),hwnd,DialogAbout);
					return 0;

				case IDM_WEB_SEARCH:
					hChild=GetWindow(hClient,GW_CHILD);
					WndNum=GetWndNum(hChild);
					if(IS_DOCUMENT_TEXT(MdiInfo[WndNum].DocType)){
						extern HWND hWebSearchCombo;
						SendMessage(GetWindow(hWebSearchCombo,GW_CHILD),WM_CHAR,VK_RETURN,0);
					}
					return 0;



				//////////////////////////////////////////////////////
				// o[Rg[̃Tuj[R}hio[ǉj
				//////////////////////////////////////////////////////

				case IDM_DOCSELECTBAND:
					pobj_Rebar->ChangeRebarBand(ID_DOCCOMBO);
					return 0;
				case IDM_STANDARDBAND:
					pobj_Rebar->ChangeRebarBand(ID_STANDARDTOOLBAR);
					return 0;
#ifndef THETEXT
				case IDM_RELEASEBAND:
					pobj_Rebar->ChangeRebarBand(ID_RELEASETOOLBAR);
					return 0;
				case IDM_DEBUGBAND:
					pobj_Rebar->ChangeRebarBand(ID_DEBUGGERTOOLBAR);
					return 0;
				case IDM_SELECTCOMPILERBAND:
					pobj_Rebar->ChangeRebarBand(ID_SELECTCOMPILERCOMBO);
					return 0;
#endif
				case IDM_BANDMENU_WEB_SEARCH:
					pobj_Rebar->ChangeRebarBand(ID_WEB_SEARCH);
					return 0;
				case IDM_NOGRIPPER:
					if(pobj_nv->bNoGripper) pobj_nv->bNoGripper=0;
					else pobj_nv->bNoGripper=1;

					//o[Rg[Đ
					pobj_Rebar->ResetRebar();

					//j[Ԃݒ
					ResetState_DocMenu();
					return 0;
				case IDM_RESET_REBAR:
					//"c[o[̔zuׂďԂɖ߂܂B\n낵łH"
					if(IDCANCEL==MessageBox(hwnd,STRING_TOOLBAR_RESET,APPLICATION_NAME,MB_OKCANCEL|MB_ICONEXCLAMATION)) break;

					//o[Rg[Đ
					pobj_Rebar->ResetInitRebar();

					//j[Ԃݒ
					ResetState_DocMenu();
					return 0;



				////////////////////////////////////////////////////
				// C ^u Rg[̃Tuj[R}h
				////////////////////////////////////////////////////

				case IDM_ALLCLOSE_OMIT_MYSELF:
					//̃EBhEȊOׂĕ(&A)
					hChild=GetWindow(hClient,GW_CHILD);
					WndNum=GetWndNum(hChild);
					for(i=0;i<MAX_WNDNUM;i++){
						if(i==WndNum) continue;
						if(MdiInfo[i].hwnd) SendMessage(MdiInfo[i].hwnd,WM_CLOSE,0,0);
					}
					return 0;

				case IDM_PATH_COPY:
					hChild=GetWindow(hClient,GW_CHILD);
					WndNum=GetWndNum(hChild);

					//΃pXRs[
					hGlobal=(char *)GlobalAlloc(GMEM_MOVEABLE,lstrlen(MdiInfo[WndNum].path)+1);
					pTemp=(char *)GlobalLock(hGlobal);
					lstrcpy(pTemp,MdiInfo[WndNum].path);
					GlobalUnlock(hGlobal);

					//Nbv{[hɕۑ
					OpenClipboard(hwnd);
					EmptyClipboard();
					SetClipboardData(CF_TEXT,hGlobal);
					CloseClipboard();
					return 0;

				case IDM_FOLDER_OPEN:
					hChild=GetWindow(hClient,GW_CHILD);
					WndNum=GetWndNum(hChild);

					_splitpath(MdiInfo[WndNum].path,temporary,temp2,NULL,NULL);
					lstrcat(temporary,temp2);

					ShellExecute(hwnd,"explore",temporary,NULL,NULL,SW_SHOWNORMAL);
					return 0;

				case IDM_DELETE_FILE:
					hChild=GetWindow(hClient,GW_CHILD);
					WndNum=GetWndNum(hChild);

					_splitpath(MdiInfo[WndNum].path,NULL,NULL,temporary,temp2);
					lstrcat(temporary,temp2);

					lstrcat(temporary," ݔɈړĕ܂B낵łH");
					if(MessageBox(hwnd,temporary,APPLICATION_NAME,MB_OKCANCEL|MB_ICONQUESTION)==IDCANCEL) return 0;

					//S~
					SHFILEOPSTRUCT fo;
					fo.hwnd=hwnd;
					fo.wFunc=FO_DELETE;
					fo.pFrom =MdiInfo[WndNum].path;
					fo.pTo="\0";
					fo.fFlags =FOF_ALLOWUNDO|FOF_NOCONFIRMATION;
					SHFileOperation(&fo);

					//
					MdiInfo[WndNum].pmti->bModify=0;
					SendMessage(MdiInfo[WndNum].hwnd,WM_CLOSE,0,0);

					return 0;

				case IDM_USER_COLOR:
					{
						CHOOSECOLOR cc;
						COLORREF CusColors[16]={
							RGB(255,255,255),
							RGB(0,0,0),
							RGB(128,128,128),
							RGB(192,192,192),
							RGB(128,0,0),
							RGB(255,0,0),
							RGB(128,128,0),
							RGB(255,255,0),
							RGB(0,128,0),
							RGB(0,255,0),
							RGB(0,128,128),
							RGB(0,255,255),
							RGB(0,0,128),
							RGB(0,0,255),
							RGB(128,0,128),
							RGB(255,0,255)};
						cc.lStructSize=sizeof(CHOOSECOLOR);
						cc.hwndOwner=hwnd;
						cc.rgbResult=colorUser;
						cc.lpCustColors=CusColors;
						cc.Flags=CC_RGBINIT|CC_FULLOPEN;
						if(!ChooseColor(&cc)){
							return 0;
						}
						colorUser=cc.rgbResult;
					}
				case IDM_GRAY:
				case IDM_WHITE:
				case IDM_RED:
				case IDM_GREEN:
				case IDM_BLUE:
				case IDM_YELLOW:
					hChild=GetWindow(hClient,GW_CHILD);
					WndNum=GetWndNum(hChild);

					TC_ITEM tcItem;
					tcItem.mask=TCIF_PARAM;
					if(LOWORD(wParam)==IDM_GRAY)	tcItem.lParam=TABCOLOR_GRAY;
					if(LOWORD(wParam)==IDM_WHITE)	tcItem.lParam=TABCOLOR_WHITE;
					if(LOWORD(wParam)==IDM_RED)		tcItem.lParam=TABCOLOR_RED;
					if(LOWORD(wParam)==IDM_GREEN)	tcItem.lParam=TABCOLOR_GREEN;
					if(LOWORD(wParam)==IDM_BLUE)	tcItem.lParam=TABCOLOR_BLUE;
					if(LOWORD(wParam)==IDM_YELLOW)	tcItem.lParam=TABCOLOR_YELLOW;
					if(LOWORD(wParam)==IDM_USER_COLOR) tcItem.lParam=colorUser;
					TabCtrl_SetItem(pobj_MainTab->hTab,
						TabCtrl_GetCurSel(pobj_MainTab->hTab),
						&tcItem);
					InvalidateRect(pobj_MainTab->hTab,NULL,0);
					return 0;



				//////////////////////////////////
				// SideWeb
				//////////////////////////////////

				case IDC_CLIP:
					pobj_SideWeb->bShow=0;
					ResizeOwnerWnd();
					return 0;
			}
			break;
		case WM_DROPFILES:
			hDrop=(HDROP)wParam;

			i2=DragQueryFile(hDrop,-1,0,0);
			for(i=0;i<i2;i++){
				DragQueryFile(hDrop,i,str,MAX_PATH);
				OpenFileWithExtension(str);
			}
			DragFinish(hDrop);
			return 0;
		case WM_SHOWERROR:
			//G[𔽓]\
			DWORD AccBytes;
			HANDLE fh;
			sprintf(temporary,"%spgm.tmp",pj_editor_Dir);
			fh=CreateFile(temporary,GENERIC_READ,FILE_SHARE_READ|FILE_SHARE_WRITE,NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
			ReadFile(fh,temporary,MAX_PATH,&AccBytes,NULL);
			CloseHandle(fh);
			temporary[AccBytes]=0;
			hChild=GetWindow(hClient,GW_CHILD);
			while(hChild){
				WndNum=GetWndNum(hChild);
				if(IS_DOCUMENT_TEXT(MdiInfo[WndNum].DocType)){
					if(lstrcmpi(MdiInfo[WndNum].path,temporary)==0) break;
				}
				hChild=GetNextWindow(hChild,GW_HWNDNEXT);
			}
			if(!hChild){
				hChild=OpenFileWithExtension(temporary);
				WndNum=GetWndNum(hChild);
			}

			if(WndNum==-1) return 0;

			//EBhEőOʂɕ\
			BringWindowToTop(hChild);
			UpdateWindow(hChild);

			pTemp=MdiInfo[WndNum].pmti->buffer;

			//s̐擪CfbNX擾i擾s̔ԍwParamœnj
			for(i=0,i2=0;;i++){
				if(i2>=(int)wParam) break;
				if(pTemp[i]=='\0') break;
				if(pTemp[i]=='\r'&&pTemp[i+1]=='\n'){
					i++;
					i2++;
				}
			}
			pos.x=i;

			//s̏I[CfbNX擾
			for(;;i++){
				if(pTemp[i]=='\0') break;
				if(pTemp[i]=='\r'&&pTemp[i+1]=='\n') break;
			}
			pos.y=i;

			//sI
			TextEdit_SetSel(WndNum,pos.x,pos.y,TRUE);

			return 0;

#ifndef THETEXT
		case WM_SETCOMPILEVIEW:
			//RpCEBhEiߍ݌^j\ꂽƂ
			hCompileView=(HWND)lParam;
			ResizeOwnerWnd();
			return 0;
		case WM_DESTROYCOMPILEVIEW:
			//RpCEBhEiߍ݌^jjꂽƂ
			if((int)hCompileView==-1){
				//Ɏ̃RpCEBhENƂ
				hCompileView=0;
			}
			else{
				//SɃRpCEBhEƂ̓TCY
				hCompileView=0;
				
				ResizeOwnerWnd();
			}
			return 0;

		case WM_SETDEBUGGERBASE:
			//fobKx[XEBhEiߍ݌^j\ꂽƂ
			pobj_Debugger->begin();

			//BasicCompiler.exe̋Il
			SetTimer(hOwner,ID_DEBUGSAFTY,1000,NULL);

			return 0;
		case WM_DESTROYDEBUGGERBASE:
			//BasicCompiler.exe̋Il
			KillTimer(hOwner,ID_DEBUGSAFTY);

			//fobKx[XEBhEiߍ݌^jjꂽƂ
			pobj_Debugger->end();

			return 0;

		case WM_SETDEBUGGERVIEW:
			//fobKEBhEiߍ݌^j\ꂽƂ
			pobj_Debugger->watch_start((HWND)lParam);
			ResizeOwnerWnd();
			return 0;
		case WM_DESTROYDEBUGGERVIEW:
			//fobKEBhEiߍ݌^jjꂽƂ
			pobj_Debugger->watch_quit();
			ResizeOwnerWnd();
			return 0;
#endif

		case WM_SIZE:
			ResizeOwnerWnd();
			return 0;


		case WM_MOUSEMOVE:
			static DWORD dwDragLever;
			static POINT PrevMousePos;
			static int start;

			pos.x=(long)(short)LOWORD(lParam);
			pos.y=(long)(short)HIWORD(lParam);
			ClientToScreen(hwnd,&pos);

			if(dwDragLever){
				GetClientRect(hwnd,&rect);

				if(dwDragLever==1){
					//vWFNgr[TCY
					pobj_nv->width_ClipProjectView=start+pos.x-PrevMousePos.x;
					if(pobj_nv->width_ClipProjectView<100) pobj_nv->width_ClipProjectView=100;
					if(rect.right-100<pobj_nv->width_ClipProjectView) pobj_nv->width_ClipProjectView=rect.right-100;
				}
				else if(dwDragLever==2){
					//fobKr[TCY
					pobj_nv->height_ClipDebuggerView=start+PrevMousePos.y-pos.y;
					if(pobj_nv->height_ClipDebuggerView<60) pobj_nv->height_ClipDebuggerView=60;
					if(rect.bottom-100<pobj_nv->height_ClipCompileView+pobj_nv->height_ClipDebuggerView)
						pobj_nv->height_ClipDebuggerView=rect.bottom-100-pobj_nv->height_ClipCompileView;
				}
				else if(dwDragLever==3){
					//RpCr[TCY
					pobj_nv->height_ClipCompileView=start+PrevMousePos.y-pos.y;
					if(pobj_nv->height_ClipCompileView<60) pobj_nv->height_ClipCompileView=60;
					if(rect.bottom-100<pobj_nv->height_ClipCompileView)
						pobj_nv->height_ClipCompileView=rect.bottom-100;
				}
				else if(dwDragLever==4){
					//SideWebTCY
					pobj_nv->width_WebSearchView=start+PrevMousePos.x-pos.x;
					if(pobj_nv->width_WebSearchView<100) pobj_nv->width_WebSearchView=100;
					if(rect.right-100<pobj_nv->width_WebSearchView) pobj_nv->width_WebSearchView=rect.right-100;
				}

				ResizeOwnerWnd();
				UpdateWindow(hwnd);
			}
			if(pobj_nv->bClipProjectView&&IsWindowVisible(hProjectView)){
				//vWFNgr[MDINCAg̋ڂ̃TCYύXC
				GetWindowRect(hProjectView,&rect);
				if(rect.top<=pos.y&&pos.y<=rect.bottom&&
					rect.right<=pos.x&&pos.x<=rect.right+LEVER_THICK){
					SetCursor(LoadCursor(0,IDC_SIZEWE));
				}
			}
#ifndef THETEXT
			if(bClipCompileView&&pobj_Debugger->IsDebuggerView()){
				//fobKr[MDINCAg̋ڂ̃TCYύXC
				GetWindowRect(pobj_Debugger->hwnd,&rect);
				if(rect.left<=pos.x&&pos.x<=rect.right&&
					rect.top-LEVER_THICK<=pos.y&&pos.y<=rect.top){
					SetCursor(LoadCursor(0,IDC_SIZENS));
				}
			}
			if(bClipCompileView&&IsWindowVisible(hCompileView)){
				//RpCr[MDINCAg̋ڂ̃TCYύXC
				GetWindowRect(hCompileView,&rect);
				if(rect.left<=pos.x&&pos.x<=rect.right&&
					rect.top-LEVER_THICK<=pos.y&&pos.y<=rect.top){
					SetCursor(LoadCursor(0,IDC_SIZENS));
				}
			}
#endif
			if(pobj_SideWeb->bShow){
				//SideWebMDINCAg̋ڂ̃TCYύXC
				pobj_SideWeb->GetRect(&rect);
				ClientToScreen(hwnd,&rect);
				if(rect.top<=pos.y&&pos.y<=rect.bottom&&
					rect.left-LEVER_THICK<=pos.x&&pos.x<=rect.left){
					SetCursor(LoadCursor(0,IDC_SIZEWE));
				}
			}
			return 0;
		case WM_LBUTTONDOWN:
			pos.x=LOWORD(lParam);
			pos.y=HIWORD(lParam);
			ClientToScreen(hwnd,&pos);

			if(pobj_nv->bClipProjectView&&IsWindowVisible(hProjectView)){
				//vWFNgr[MDINCAg̋ڂ̃TCYύXC
				GetWindowRect(hProjectView,&rect);
				if(rect.top<=pos.y&&pos.y<=rect.bottom&&
					rect.right<=pos.x&&pos.x<=rect.right+LEVER_THICK){
					SetCursor(LoadCursor(0,IDC_SIZEWE));

					dwDragLever=1;
					SetCapture(hwnd);

					PrevMousePos=pos;
					start=pobj_nv->width_ClipProjectView;
				}
			}
#ifndef THETEXT
			if(bClipCompileView&&pobj_Debugger->IsDebuggerView()){
				//fobKr[MDINCAg̋ڂ̃TCYύXC
				GetWindowRect(pobj_Debugger->hwnd,&rect);
				if(rect.left<=pos.x&&pos.x<=rect.right&&
					rect.top-LEVER_THICK<=pos.y&&pos.y<=rect.top){
					SetCursor(LoadCursor(0,IDC_SIZENS));

					dwDragLever=2;
					SetCapture(hwnd);

					PrevMousePos=pos;
					start=pobj_nv->height_ClipDebuggerView;
				}
			}
			if(bClipCompileView&&IsWindowVisible(hCompileView)){
				//RpCr[MDINCAg̋ڂ̃TCYύXC
				GetWindowRect(hCompileView,&rect);
				if(rect.left<=pos.x&&pos.x<=rect.right&&
					rect.top-LEVER_THICK<=pos.y&&pos.y<=rect.top){
					SetCursor(LoadCursor(0,IDC_SIZENS));

					dwDragLever=3;
					SetCapture(hwnd);

					PrevMousePos=pos;
					start=pobj_nv->height_ClipCompileView;
				}
			}
#endif
			if(pobj_SideWeb->bShow){
				//SideWebMDINCAg̋ڂ̃TCYύXC
				pobj_SideWeb->GetRect(&rect);
				ClientToScreen(hwnd,&rect);
				if(rect.top<=pos.y&&pos.y<=rect.bottom&&
					rect.left-LEVER_THICK<=pos.x&&pos.x<=rect.left){
					SetCursor(LoadCursor(0,IDC_SIZENS));

					dwDragLever=4;
					SetCapture(hwnd);

					PrevMousePos=pos;
					start=pobj_nv->width_WebSearchView;
				}
			}
			return 0;
		case WM_LBUTTONUP:
			if(dwDragLever){
				dwDragLever=0;
				ReleaseCapture();
			}
			return 0;


		case WM_SYSCOMMAND:
			//EBhE̍ŏOɃEBhEʒuۑ
			if(wParam==SC_MINIMIZE){
				if(IsZoomed(hwnd)) pobj_nv->bWindowMax=1;
				else if(!IsIconic(hwnd)){
					pobj_nv->bWindowMax=0;
					GetWindowRect(hwnd,&pobj_nv->StartupWindowRect);
				}
			}
			break;	//DefFrameProc
		case WM_QUERYENDSESSION:
		case WM_CLOSE:
			extern BOOL bSearchingClasses;
			if(bSearchingClasses){
				pobj_ClassTreeView->bCloseSwitch=1;
				return 0;
			}

			//RpCr[
			if(hCompileView)
				SendMessage(hCompileView,WM_COMMAND,IDCANCEL,0);

			//NMDIEBhEő剻邩𔻒
			hChild=GetWindow(hClient,GW_CHILD);
			pobj_nv->bMDIZoomed=IsZoomed(hChild);

			//vWFNg
			if(ProjectInfo.name[0]){
				if(!CloseProject()) return 0;
			}

			//MDIEBhE̕ۑmF
			hChild=GetWindow(hClient,GW_CHILD);
			while(hChild){
				i=GetWndNum(hChild);
				if(!DocumentModifyCheck(hChild)) return 0;
				hChild=GetNextWindow(hChild,GW_HWNDNEXT);
			}


			if(bProfessional){
				//Proł͎obNAbvyѕ@\Lɂ
				KillTimer(hwnd,ID_TIMER_BACKUP);
			}


			//ProjectVieẅʒuۑAProjectViewj
			GetWindowRect(hProjectView_ToolWindow,&pobj_nv->rectProjectView);
			DestroyWindow(hProjectView);
			DestroyWindow(hProjectView_ToolWindow);

			//Rebar̈ʒuۑARebarj
			delete pobj_Rebar;
			pobj_Rebar=0;

			//^uRg[j
			delete pobj_MainTab;
			pobj_MainTab=0;

			//SideWebj
			delete pobj_SideWeb;
			pobj_SideWeb=0;

			//CEBhE̍ő剻LAWۑ
			if(IsZoomed(hwnd)) pobj_nv->bWindowMax=1;
			else if(!IsIconic(hwnd)){
				pobj_nv->bWindowMax=0;
				GetWindowRect(hwnd,&pobj_nv->StartupWindowRect);
			}

			hChild=GetWindow(hClient,GW_CHILD);
			while(hChild){
				CloseDocWindow(GetWndNum(hChild));
				DestroyWindow(hChild);
				hChild=GetWindow(hClient,GW_CHILD);
			}

			EndProjectEditor();		//ProjectEditoȑۑ

			//GfB^ptHgj
			extern HFONT hFont_TextEdit,hFont_HyperLink_TextEdit;
			if(hFont_TextEdit) DeleteObject(hFont_TextEdit);
			if(hFont_HyperLink_TextEdit) DeleteObject(hFont_HyperLink_TextEdit);

			DestroyWindow(hwnd);
			return 0;

		case WM_DESTROY:
			PostQuitMessage(0);
			return 0;
	}
	return DefFrameProc(hwnd,hClient,message,wParam,lParam);
}

int RegWndClass(WNDPROC WndProc,char *lpClassName,HBRUSH hBackBrush,DWORD dwFlag){
	WNDCLASSEX wcl;

	wcl.cbSize=sizeof(WNDCLASSEX);
	wcl.hInstance=hInst;
	wcl.lpszClassName=lpClassName;
	wcl.lpfnWndProc=WndProc;

	if(dwFlag&FLAG_DBLCLK) wcl.style=CS_DBLCLKS;
	else wcl.style=0;

	wcl.hIcon=LoadIcon(NULL,IDI_APPLICATION);
	wcl.hIconSm=LoadIcon(NULL,IDI_WINLOGO);

	if(dwFlag&FLAG_BEAMCURSOR) wcl.hCursor=LoadCursor(NULL,IDC_IBEAM);
	else wcl.hCursor=LoadCursor(NULL,IDC_ARROW);

	wcl.lpszMenuName=NULL;
	wcl.cbClsExtra=0;
	wcl.cbWndExtra=0;
	wcl.hbrBackground=hBackBrush;

	return RegisterClassEx(&wcl);
}
int PASCAL WinMain(HINSTANCE hThisInst,HINSTANCE hPrevInst,LPSTR lpCmdLine,int ShowCmd){
	int i,i2,IsStr;
	char str[MAX_PATH],str2[MAX_PATH],dummy[1024];
	MSG msg;
	HACCEL hAccel;

	hInst=hThisInst;
	if(!SetupProjectEditor()) return 0;

	HBRUSH hGrayBrush_LineNumber;
	hGrayBrush_LineNumber=CreateSolidBrush(RGB(220,220,220));

	if(!RegWndClass(WindowFunc,"ProjectEditor",(HBRUSH)COLOR_APPWORKSPACE+1,FLAG_DBLCLK)) return 0;
	if(!RegWndClass(MDIClientWindow_TextEdit,"MDIClientWindow_TextEdit",(HBRUSH)GetStockObject(WHITE_BRUSH),FLAG_DBLCLK)) return 0;
	if(!RegWndClass(MethodCheckWindow,"MethodCheckWindow",(HBRUSH)GetStockObject(WHITE_BRUSH),FLAG_DBLCLK)) return 0;
	if(!RegWndClass(MDIClientWindow_Rad,"MDIClientWindow_Rad",(HBRUSH)GetStockObject(WHITE_BRUSH),FLAG_DBLCLK)) return 0;
	if(!RegWndClass(RadToolsWindow,"RadToolsWindow",h3DFaceBackBrush,FLAG_DBLCLK)) return 0;
	if(!RegWndClass(RadPropertyWindow,"RadPropertyWindow",h3DFaceBackBrush,FLAG_DBLCLK)) return 0;
	if(!RegWndClass(RadWindow,"RadWindow",(HBRUSH)GetStockObject(NULL_BRUSH),FLAG_DBLCLK)) return 0;
	if(!RegWndClass(TestWindowProc,"TestWindow",h3DFaceBackBrush,FLAG_DBLCLK)) return 0;
	if(!RegWndClass(MDIClientWindow_Menu,"MDIClientWindow_Menu",(HBRUSH)GetStockObject(WHITE_BRUSH),FLAG_DBLCLK)) return 0;
	if(!RegWndClass(MenuEditWindow,"MenuEditWindow",h3DFaceBackBrush,FLAG_DBLCLK)) return 0;
	if(!RegWndClass(MDIClientWindow_IconEdit,"MDIClientWindow_IconEdit",h3DFaceBackBrush,FLAG_DBLCLK)) return 0;
	if(!RegWndClass(IconEditWindowProc,"IconEditWindowProc",(HBRUSH)GetStockObject(WHITE_BRUSH),0)) return 0;
	if(!RegWndClass(ProjectViewProc,"ProjectView",h3DFaceBackBrush,FLAG_DBLCLK)) return 0;
	if(!RegWndClass(ProjectView_ToolWindowProc,"ProjectView_ToolWindow",h3DFaceBackBrush,FLAG_DBLCLK)) return 0;
	if(!RegWndClass(TextEditProc,"TextEditor",(HBRUSH)GetStockObject(NULL_BRUSH),FLAG_DBLCLK|FLAG_BEAMCURSOR)) return 0;
	if(!RegWndClass(ComplementWindow,"ComplementWindow",(HBRUSH)GetStockObject(BLACK_BRUSH),FLAG_DBLCLK)) return 0;
	if(!RegWndClass(PreviewWndProc,"PreviewWindow",(HBRUSH)GetStockObject(GRAY_BRUSH),FLAG_DBLCLK)) return 0;

	//Webp̃EBhENX
	if(!RegWndClass(WebResultWndProc,"WebResult",(HBRUSH)COLOR_APPWORKSPACE+1,FLAG_DBLCLK)) return 0;
	if(!RegWndClass(OneTabProc,"OneTab",(HBRUSH)COLOR_APPWORKSPACE+1,FLAG_DBLCLK)) return 0;
	if(!RegWndClass(ResultListProc,"ResultList",(HBRUSH)COLOR_APPWORKSPACE+1,FLAG_DBLCLK)) return 0;

	//[[̃EBhENX
	if(!RegWndClass(RulerProc,"Ruler",(HBRUSH)COLOR_APPWORKSPACE+1,FLAG_DBLCLK)) return 0;

	//SideWeb̃EBhENX
	if(!RegWndClass(SideWebProc,"SideWeb",(HBRUSH)COLOR_APPWORKSPACE+1,FLAG_DBLCLK)) return 0;



	hAccel=LoadAccelerators(hResInst,MAKEINTRESOURCE(IDR_ACCELERATOR1));

	//CEBhE
	RECT *prc;
	prc=&pobj_nv->StartupWindowRect;
	hOwner=CreateWindowEx(WS_EX_ACCEPTFILES,"ProjectEditor",APPLICATION_NAME,
		WS_OVERLAPPEDWINDOW|WS_CLIPCHILDREN,
		prc->left, prc->top,
		prc->right-prc->left, prc->bottom-prc->top,
		HWND_DESKTOP,pobj_MainMenu->hMenu,hInst,NULL);

	SendMessage(hOwner,WM_SETICON,ICON_SMALL,(long)hOwnerIcon);
	SetClipboardViewer(hOwner);

	if(pobj_nv->bWindowMax) ShowWindow(hOwner,SW_MAXIMIZE);
	else ShowWindow(hOwner,ShowCmd);
	UpdateWindow(hOwner);

	int open_sw=0;
	if(lstrlen(lpCmdLine)>0){
		lstrcpy(dummy,lpCmdLine);
		for(i=0,i2=0,IsStr=0;;i++,i2++){
			if(dummy[i]=='\"'){
				if(IsStr==0) IsStr=1;
				else IsStr=0;
				i++;
			}
			if((dummy[i]==' '&&IsStr==0)||dummy[i]=='\0'){
				str[i2]=0;
				if(!(strstr(str,":")||strstr(str,"\\\\"))){
					lstrcpy(str2,str);
					GetCurrentDirectory(MAX_PATH,str);
					lstrcat(str,"\\");
					lstrcat(str,str2);
				}
				ShortPathToLongPath(str,str2);
				OpenFileWithExtension(str2);
				open_sw=1;
				if(dummy[i]=='\0') break;
				i2=-1;
				continue;
			}
			str[i2]=dummy[i];
		}
	}

	BOOL bRestore=0;


	if(bProfessional){
		//Proł͎obNAbvyѕ@\Lɂ

		//KvłΕ
		bRestore=restore();
	}


#ifdef THETEXT
	if(open_sw==0&&bRestore==0){
		//t@CJȂƂ
		NewTextEditWindow(NULL,WNDTYPE_TEXT);
	}
#endif


	while(GetMessage(&msg,NULL,0,0)){

		if(!TranslateAccelerator(hOwner,hAccel,&msg)){
			if(ProjectInfo.name[0]){
				for(i=0,i2=0;i<MAX_WNDNUM;i++){
					if(MdiInfo[i].hwnd&&MdiInfo[i].DocType==WNDTYPE_RAD){
						if(IsDialogMessage(MdiInfo[i].MdiRadInfo->hProp_Dlg,&msg)) i2=1;
					}
				}
				if(i2==0){
					if(!TranslateMDISysAccel(hClient,&msg)){
						TranslateMessage(&msg);
						DispatchMessage(&msg);
					}
				}
			}
			else{
				if(!TranslateMDISysAccel(hClient,&msg)){
					TranslateMessage(&msg);
					DispatchMessage(&msg);
				}
			}
		}
	}

	DeleteObject(hGrayBrush_LineNumber);

#if defined HeapAlloc
	CheckHeapCheck();
#endif

	return msg.wParam;
}
