#include "Common.h"

#define ZOOMED_XPOS 100
#define PIXEL_WIDTH	10

RGBQUAD TransparentRgbq={230,230,255};	//blue,green,rediFj
COLORREF TransparentClrRef=RGB(255,230,230);	//red,green,blueiFj

void IconEdit_SelectImage(int WndNum);

void LimitRectFormat(int WndNum,RECT *pRect){
	//͂ݏoꍇ͔͈͓ɂ߂
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	if(pRect->left<0) pRect->left=0;
	if(pRect->top<0) pRect->top=0;
	if(pRect->left>=MdiInfo[WndNum].MdiIconEditInfo->pBmpHdr[MdiInfo[WndNum].MdiIconEditInfo->SelectIconNum]->biWidth)
		pRect->left=MdiInfo[WndNum].MdiIconEditInfo->pBmpHdr[MdiInfo[WndNum].MdiIconEditInfo->SelectIconNum]->biWidth-1;
	if(pRect->top>=MdiInfo[WndNum].MdiIconEditInfo->pBmpHdr[MdiInfo[WndNum].MdiIconEditInfo->SelectIconNum]->biHeight/2)
		pRect->top=MdiInfo[WndNum].MdiIconEditInfo->pBmpHdr[MdiInfo[WndNum].MdiIconEditInfo->SelectIconNum]->biHeight/2-1;

	if(pRect->right<0) pRect->right=0;
	if(pRect->bottom<0) pRect->bottom=0;
	if(pRect->right>=MdiInfo[WndNum].MdiIconEditInfo->pBmpHdr[MdiInfo[WndNum].MdiIconEditInfo->SelectIconNum]->biWidth)
		pRect->right=MdiInfo[WndNum].MdiIconEditInfo->pBmpHdr[MdiInfo[WndNum].MdiIconEditInfo->SelectIconNum]->biWidth-1;
	if(pRect->bottom>=MdiInfo[WndNum].MdiIconEditInfo->pBmpHdr[MdiInfo[WndNum].MdiIconEditInfo->SelectIconNum]->biHeight/2)
		pRect->bottom=MdiInfo[WndNum].MdiIconEditInfo->pBmpHdr[MdiInfo[WndNum].MdiIconEditInfo->SelectIconNum]->biHeight/2-1;
}
void GetZoomedPos(POINT *pPos){
	pPos->x=pPos->x*PIXEL_WIDTH+ZOOMED_XPOS;
	pPos->y*=PIXEL_WIDTH;
}
void SetZoomedPixel(HDC hdc,int WndNum,int x,int y){
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	POINT pos;

	if(x<0||y<0||
		x>=MdiInfo[WndNum].MdiIconEditInfo->pBmpHdr[MdiInfo[WndNum].MdiIconEditInfo->SelectIconNum]->biWidth||
		y>=MdiInfo[WndNum].MdiIconEditInfo->pBmpHdr[MdiInfo[WndNum].MdiIconEditInfo->SelectIconNum]->biHeight/2)
		return;

	pos.x=x;
	pos.y=y;
	GetZoomedPos(&pos);
	Rectangle(hdc,pos.x,pos.y,pos.x+11,pos.y+11);
}
DWORD GetColorCode(int WndNum,COLORREF ColorRef){
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	int i,i2;
	RGBQUAD *pRgbq;

	//F̏ꍇ
	if(ColorRef==TransparentClrRef) return -1;

	//J[e[u擾
	pRgbq=(RGBQUAD *)(MdiInfo[WndNum].MdiIconEditInfo->pIconImage[MdiInfo[WndNum].MdiIconEditInfo->SelectIconNum]+sizeof(BITMAPINFOHEADER));

	i2=(int)pow((double)2,(double)MdiInfo[WndNum].MdiIconEditInfo->pBmpHdr[MdiInfo[WndNum].MdiIconEditInfo->SelectIconNum]->biBitCount);
	for(i=0;i<i2;i++){
		if(ColorRef==RGB(pRgbq[i].rgbRed,pRgbq[i].rgbGreen,pRgbq[i].rgbBlue)) break;
	}
	if(i==i2) i=0;

	return i;
}
HGLOBAL IconEdit_GetChildInfoClipboardData(int WndNum){
	//////////////////////////////////////////////
	// I𒆂̃C[WNbv{[h֕ۑ
	//////////////////////////////////////////////

	extern MDIINFO MdiInfo[MAX_WNDNUM];
	HDC hDC;
	HBITMAP hBmp;
	SIZE size;
	int sw;

	//IĂȂꍇ0Ԃ
	sw=0;
	if(MdiInfo[WndNum].MdiIconEditInfo->SelectLevel==0) return 0;
	if(MdiInfo[WndNum].MdiIconEditInfo->SelectLevel==1){
		IconEdit_SelectImage(WndNum);
		sw=1;
	}

	size.cx=MdiInfo[WndNum].MdiIconEditInfo->DraggingRect.right-MdiInfo[WndNum].MdiIconEditInfo->DraggingRect.left+1;
	size.cy=MdiInfo[WndNum].MdiIconEditInfo->DraggingRect.bottom-MdiInfo[WndNum].MdiIconEditInfo->DraggingRect.top+1;

	hDC=CreateCompatibleDC(MdiInfo[WndNum].MdiIconEditInfo->memdc);
	hBmp=CreateCompatibleBitmap(
		MdiInfo[WndNum].MdiIconEditInfo->memdc,
		size.cx,
		size.cy);
	SelectObject(hDC,hBmp);

	BitBlt(hDC,0,0,size.cx,size.cy,
		MdiInfo[WndNum].MdiIconEditInfo->memdc,
		MdiInfo[WndNum].MdiIconEditInfo->DraggingRect.left,
		MdiInfo[WndNum].MdiIconEditInfo->DraggingRect.top,
		SRCCOPY);

	DeleteDC(hDC);

	if(sw){
		DeleteObject(MdiInfo[WndNum].MdiIconEditInfo->hSelectingBmp);
		MdiInfo[WndNum].MdiIconEditInfo->SelectLevel=1;
	}

	return hBmp;
}
void IconEdit_PasteChildInfoClipboardData(int WndNum,HBITMAP hBmp){
	////////////////////////////////////
	// Nbv{[h̓e\t
	////////////////////////////////////

	extern MDIINFO MdiInfo[MAX_WNDNUM];
	HDC hDC,hDC2;
	BITMAP Bitmap;

	if(MdiInfo[WndNum].MdiIconEditInfo->SelectLevel==2)
		IconEdit_PasteImage(WndNum);

	GetObject(hBmp,sizeof(Bitmap),&Bitmap);

	hDC=CreateCompatibleDC(MdiInfo[WndNum].MdiIconEditInfo->memdc);
	MdiInfo[WndNum].MdiIconEditInfo->hSelectingBmp=
		CreateCompatibleBitmap(MdiInfo[WndNum].MdiIconEditInfo->memdc,Bitmap.bmWidth,Bitmap.bmHeight);
	SelectObject(hDC,MdiInfo[WndNum].MdiIconEditInfo->hSelectingBmp);
	hDC2=CreateCompatibleDC(MdiInfo[WndNum].MdiIconEditInfo->memdc);
	SelectObject(hDC2,hBmp);

	BitBlt(hDC,0,0,Bitmap.bmWidth,Bitmap.bmHeight,
		hDC2,0,0,SRCCOPY);

	DeleteDC(hDC);
	DeleteDC(hDC2);

	MdiInfo[WndNum].MdiIconEditInfo->DraggingRect.left=0;
	MdiInfo[WndNum].MdiIconEditInfo->DraggingRect.top=0;
	MdiInfo[WndNum].MdiIconEditInfo->DraggingRect.right=Bitmap.bmWidth-1;
	MdiInfo[WndNum].MdiIconEditInfo->DraggingRect.bottom=Bitmap.bmHeight-1;

	InvalidateRect(MdiInfo[WndNum].MdiIconEditInfo->hMain,NULL,0);

	MdiInfo[WndNum].MdiIconEditInfo->SelectLevel=2;
}

void IconEdit_SelectImage(int WndNum){
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	SIZE size;
	HDC hDC;

	size.cx=MdiInfo[WndNum].MdiIconEditInfo->DraggingRect.right-MdiInfo[WndNum].MdiIconEditInfo->DraggingRect.left+1;
	size.cy=MdiInfo[WndNum].MdiIconEditInfo->DraggingRect.bottom-MdiInfo[WndNum].MdiIconEditInfo->DraggingRect.top+1;

	hDC=CreateCompatibleDC(MdiInfo[WndNum].MdiIconEditInfo->memdc);
	MdiInfo[WndNum].MdiIconEditInfo->hSelectingBmp=
		CreateCompatibleBitmap(MdiInfo[WndNum].MdiIconEditInfo->memdc,size.cx,size.cy);
	SelectObject(hDC,MdiInfo[WndNum].MdiIconEditInfo->hSelectingBmp);
	BitBlt(hDC,0,0,size.cx,size.cy,
		MdiInfo[WndNum].MdiIconEditInfo->memdc,
		MdiInfo[WndNum].MdiIconEditInfo->DraggingRect.left,
		MdiInfo[WndNum].MdiIconEditInfo->DraggingRect.top,
		SRCCOPY);
	DeleteDC(hDC);

	MdiInfo[WndNum].MdiIconEditInfo->SelectLevel=2;
}
void IconEdit_PasteImage(int WndNum){
	extern HANDLE hHeap;
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	int i,i2,i3,x,y,y2,selecting_x,selecting_y;
	DWORD dwRgbq;

	//Rs[
	RGBQUAD *pRgbq;
	BYTE *pBuffer,*pMaskBuf;
	BITMAPINFOHEADER *pBmpInfoHdr;

	//Rs[
	BITMAP Bitmap;
	BITMAPINFO SelectingBitmapInfo;
	COLORREF *pSelectingBuffer;

	//ύX
	IconEdit_NoticeChanging(WndNum);

	GetObject(MdiInfo[WndNum].MdiIconEditInfo->hSelectingBmp,sizeof(BITMAP),&Bitmap);
	pSelectingBuffer=(COLORREF *)HeapAlloc(hHeap,0,Bitmap.bmWidth*Bitmap.bmHeight*sizeof(COLORREF));
	SelectingBitmapInfo.bmiHeader.biSize=sizeof(BITMAPINFOHEADER);
	SelectingBitmapInfo.bmiHeader.biWidth=Bitmap.bmWidth;
	SelectingBitmapInfo.bmiHeader.biHeight=Bitmap.bmHeight;
	SelectingBitmapInfo.bmiHeader.biPlanes=1;
	SelectingBitmapInfo.bmiHeader.biBitCount=32;
	SelectingBitmapInfo.bmiHeader.biCompression=BI_RGB;
	GetDIBits(MdiInfo[WndNum].MdiIconEditInfo->memdc,
		MdiInfo[WndNum].MdiIconEditInfo->hSelectingBmp,
		0,Bitmap.bmHeight,
		pSelectingBuffer,&SelectingBitmapInfo,DIB_RGB_COLORS);

	pBmpInfoHdr=(BITMAPINFOHEADER *)MdiInfo[WndNum].MdiIconEditInfo->pIconImage[MdiInfo[WndNum].MdiIconEditInfo->SelectIconNum];

	//J[e[u擾
	pRgbq=(RGBQUAD *)(MdiInfo[WndNum].MdiIconEditInfo->pIconImage[MdiInfo[WndNum].MdiIconEditInfo->SelectIconNum]+sizeof(BITMAPINFOHEADER));

	//rbgobt@擾
	pBuffer=MdiInfo[WndNum].MdiIconEditInfo->pIconImage[MdiInfo[WndNum].MdiIconEditInfo->SelectIconNum]+
		sizeof(BITMAPINFOHEADER);
	if(pBmpInfoHdr->biBitCount<=8)
		pBuffer+=sizeof(DWORD)*(int)pow((double)2,(double)pBmpInfoHdr->biBitCount);

	//}XNobt@擾
	pMaskBuf=pBuffer+pBmpInfoHdr->biBitCount*pBmpInfoHdr->biWidth*(pBmpInfoHdr->biHeight/2)/8;

	for(y=MdiInfo[WndNum].MdiIconEditInfo->DraggingRect.bottom;y>=MdiInfo[WndNum].MdiIconEditInfo->DraggingRect.top;y--){
		for(x=MdiInfo[WndNum].MdiIconEditInfo->DraggingRect.left;x<=MdiInfo[WndNum].MdiIconEditInfo->DraggingRect.right;x++){
			if(x<0||y<0||
				x>=MdiInfo[WndNum].MdiIconEditInfo->pBmpHdr[MdiInfo[WndNum].MdiIconEditInfo->SelectIconNum]->biWidth||
				y>=MdiInfo[WndNum].MdiIconEditInfo->pBmpHdr[MdiInfo[WndNum].MdiIconEditInfo->SelectIconNum]->biHeight/2){
				//͈͊Ȍꍇ
				continue;
			}

			selecting_x=x-MdiInfo[WndNum].MdiIconEditInfo->DraggingRect.left;
			selecting_y=y-MdiInfo[WndNum].MdiIconEditInfo->DraggingRect.top;
			dwRgbq=pSelectingBuffer[(Bitmap.bmHeight-1-selecting_y)*Bitmap.bmWidth+selecting_x];

			if(pBmpInfoHdr->biBitCount==4||pBmpInfoHdr->biBitCount==8){
				i=(pBmpInfoHdr->biHeight/2-1-y)*pBmpInfoHdr->biWidth+x;
				if(dwRgbq==*(DWORD *)&TransparentRgbq){
					//////////////////
					// FɃZbg
					if(pBmpInfoHdr->biWidth==16){
						//s4oCgEl
						y2=(pBmpInfoHdr->biHeight/2-1)-y;
						pMaskBuf[(i+pBmpInfoHdr->biWidth*y2)/8]|=0x01<<(8-(i%8+1));
					}
					else pMaskBuf[i/8]|=0x01<<(8-(i%8+1));

					/////////////////
					// F0ɃZbg
					i3=(int)pow((double)2,(double)pBmpInfoHdr->biBitCount);
					for(i2=0;i2<i3;i2++){
						if(dwRgbq==((DWORD *)pRgbq)[i2]) break;
					}
					switch(pBmpInfoHdr->biBitCount){
						case 4:		//16F
							if(i%2==0) *(pBuffer+i/2)&=0x0F;
							else *(pBuffer+i/2)&=0xF0;
							break;
						case 8:		//256F
							pBuffer[i]=0;
							break;
					}
				}
				else{
					////////////////////
					// FɃZbg
					if(pBmpInfoHdr->biWidth==16){
						//s4oCgEl
						y2=(pBmpInfoHdr->biHeight/2-1)-y;
						pMaskBuf[(i+pBmpInfoHdr->biWidth*y2)/8]&=~(0x01<<(8-(i%8+1)));
					}
					else pMaskBuf[i/8]&=~(0x01<<(8-(i%8+1)));

					//////////////
					// FZbg
					i3=(int)pow((double)2,(double)pBmpInfoHdr->biBitCount);
					for(i2=0;i2<i3;i2++){
						if(dwRgbq==((DWORD *)pRgbq)[i2]) break;
					}
					switch(pBmpInfoHdr->biBitCount){
						case 4:		//16F
							if(i%2==0){
								*(pBuffer+i/2)&=0x0F;
								*(pBuffer+i/2)|=i2<<4;
							}
							else{
								*(pBuffer+i/2)&=0xF0;
								*(pBuffer+i/2)|=i2;
							}
							break;
						case 8:		//256F
							pBuffer[i]=i2;
							break;
					}
				}
			}
		}
	}
	HeapDefaultFree(pSelectingBuffer);

	DeleteObject(MdiInfo[WndNum].MdiIconEditInfo->hSelectingBmp);
	MdiInfo[WndNum].MdiIconEditInfo->SelectLevel=0;

	DrawIconToMemBmp(WndNum,0);
	InvalidateRect(MdiInfo[WndNum].MdiIconEditInfo->hMain,NULL,0);
}

void DrawIconToMemBmp(int WndNum,RECT *pRect){
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	HPEN hPen,hOldPen;
	HBRUSH hBrush,hOldBrush;
	int i,i2,i3,x,y,y2;
	POINT pos;
	RGBQUAD *pRgbq;
	COLORREF ColorRef;
	BYTE *pBuffer,*pMaskBuf;
	BITMAPINFOHEADER *pBmpInfoHdr;

	pBmpInfoHdr=(BITMAPINFOHEADER *)MdiInfo[WndNum].MdiIconEditInfo->pIconImage[MdiInfo[WndNum].MdiIconEditInfo->SelectIconNum];

	hPen=CreatePen(PS_SOLID,0,RGB(200,200,200));
	hOldPen=(HPEN)SelectObject(MdiInfo[WndNum].MdiIconEditInfo->memdc,hPen);

	//J[e[u擾
	pRgbq=(RGBQUAD *)(MdiInfo[WndNum].MdiIconEditInfo->pIconImage[MdiInfo[WndNum].MdiIconEditInfo->SelectIconNum]+sizeof(BITMAPINFOHEADER));

	//rbgobt@擾
	pBuffer=MdiInfo[WndNum].MdiIconEditInfo->pIconImage[MdiInfo[WndNum].MdiIconEditInfo->SelectIconNum]+
		sizeof(BITMAPINFOHEADER);
	if(pBmpInfoHdr->biBitCount<=8)
		pBuffer+=sizeof(DWORD)*(int)pow((double)2,(double)pBmpInfoHdr->biBitCount);

	//}XNobt@擾
	pMaskBuf=pBuffer+pBmpInfoHdr->biBitCount*pBmpInfoHdr->biWidth*(pBmpInfoHdr->biHeight/2)/8;

	i=0;	//WsNZ̃oCgJE^
	i3=0;	//sNZ̃oCgJE^
	for(y=pBmpInfoHdr->biHeight/2-1;y>=0;y--){
		for(x=0;x<pBmpInfoHdr->biWidth;x++,i++,i3++){
			if(pRect){
				//ւ̍ĕ`悪KvȂꍇ؁isx̂߁j
				if(!(pRect->left<=x&&x<=pRect->right&&
					pRect->top<=y&&y<=pRect->bottom)) continue;
			}

			//////////////////////
			// }XNrbg̊mF
			if(pBmpInfoHdr->biWidth==16){
				//s4oCgEl
				y2=(pBmpInfoHdr->biHeight/2-1)-y;
				i2=(pMaskBuf[(i+pBmpInfoHdr->biWidth*y2)/8]>>(8-(i%8+1)))&0x01;
			}
			else i2=(pMaskBuf[i/8]>>(8-(i%8+1)))&0x01;
			if(i2){
				hBrush=CreateSolidBrush(TransparentClrRef);
				hOldBrush=(HBRUSH)SelectObject(MdiInfo[WndNum].MdiIconEditInfo->memdc,hBrush);
				pos.x=x;
				pos.y=y;
				GetZoomedPos(&pos);
				Rectangle(MdiInfo[WndNum].MdiIconEditInfo->memdc,
					pos.x,
					pos.y,
					pos.x+11,
					pos.y+11);
				SelectObject(MdiInfo[WndNum].MdiIconEditInfo->memdc,hOldBrush);
				DeleteObject(hBrush);

				SetPixel(MdiInfo[WndNum].MdiIconEditInfo->memdc,x,y,TransparentClrRef);
				continue;
			}

			////////////////
			// ʏsNZ
			switch(pBmpInfoHdr->biBitCount){
				case 4:		//16F
					i2=*(pBuffer+i/2);
					if(i%2==0) i2>>=4;
					i2&=0x0F;
					ColorRef=RGB(pRgbq[i2].rgbRed,pRgbq[i2].rgbGreen,pRgbq[i2].rgbBlue);
					break;
				case 8:		//256F
					i2=pBuffer[i];
					ColorRef=RGB(pRgbq[i2].rgbRed,pRgbq[i2].rgbGreen,pRgbq[i2].rgbBlue);
					break;
			}
			hBrush=CreateSolidBrush(ColorRef);
			hOldBrush=(HBRUSH)SelectObject(MdiInfo[WndNum].MdiIconEditInfo->memdc,hBrush);
			pos.x=x;
			pos.y=y;
			GetZoomedPos(&pos);
			Rectangle(MdiInfo[WndNum].MdiIconEditInfo->memdc,
				pos.x,
				pos.y,
				pos.x+11,
				pos.y+11);
			SelectObject(MdiInfo[WndNum].MdiIconEditInfo->memdc,hOldBrush);
			DeleteObject(hBrush);

			SetPixel(MdiInfo[WndNum].MdiIconEditInfo->memdc,x,y,ColorRef);
		}
	}

	SelectObject(MdiInfo[WndNum].MdiIconEditInfo->memdc,hOldPen);
	DeleteObject(hPen);
}

void PixelChange(int WndNum,int x,int y,DWORD ColorCode){
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	int i;
	int y2;
	BYTE *pBuffer,*pMaskBuf;
	BITMAPINFOHEADER *pBmpInfoHdr;

	if(x<0||y<0) return;
	if(x>=MdiInfo[WndNum].MdiIconEditInfo->pBmpHdr[MdiInfo[WndNum].MdiIconEditInfo->SelectIconNum]->biWidth||
		y>=MdiInfo[WndNum].MdiIconEditInfo->pBmpHdr[MdiInfo[WndNum].MdiIconEditInfo->SelectIconNum]->biHeight/2)
		return;

	pBmpInfoHdr=(BITMAPINFOHEADER *)MdiInfo[WndNum].MdiIconEditInfo->pIconImage[MdiInfo[WndNum].MdiIconEditInfo->SelectIconNum];

	pBuffer=MdiInfo[WndNum].MdiIconEditInfo->pIconImage[MdiInfo[WndNum].MdiIconEditInfo->SelectIconNum]+
		sizeof(BITMAPINFOHEADER);
	pBuffer+=sizeof(DWORD)*(int)pow((double)2,(double)pBmpInfoHdr->biBitCount);

	pMaskBuf=pBuffer+pBmpInfoHdr->biBitCount*pBmpInfoHdr->biWidth*(pBmpInfoHdr->biHeight/2)/8;

	if(x>=pBmpInfoHdr->biWidth||y>=pBmpInfoHdr->biHeight/2) return;
	y2=(pBmpInfoHdr->biHeight/2-1)-y;
	i=pBmpInfoHdr->biWidth*y2+x;

	//////////////////
	// }XNsNZ
	if(ColorCode==-1){
		//FɎw
		if(pBmpInfoHdr->biWidth==16){
			//s4oCgEl
			pMaskBuf[(i+pBmpInfoHdr->biWidth*y2)/8]|=0x01<<(8-(i%8+1));
		}
		else pMaskBuf[i/8]|=0x01<<(8-(i%8+1));

		ColorCode=0;
	}
	else{
		//FɎw
		if(pBmpInfoHdr->biWidth==16){
			//s4oCgEl
			pMaskBuf[(i+pBmpInfoHdr->biWidth*y2)/8]&=~(0x01<<(8-(i%8+1)));
		}
		else pMaskBuf[i/8]&=~(0x01<<(8-(i%8+1)));
	}

	////////////////
	// ʏsNZ
	switch(pBmpInfoHdr->biBitCount){
		case 4:
			////////
			// 16F
			if(i%2) *(pBuffer+i/2)=(*(pBuffer+i/2)&0xF0)|(BYTE)ColorCode;
			else *(pBuffer+i/2)=(*(pBuffer+i/2)&0x0F)|(BYTE)ColorCode<<4;
			break;
		case 8:
			/////////
			// 256F
			pBuffer[i]=(BYTE)ColorCode;
			break;
	}
}
COLORREF IconEdit_GetPixel(int WndNum,int x,int y){
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	int i,i2;
	int y2;
	BYTE *pBuffer,*pMaskBuf;
	BITMAPINFOHEADER *pBmpInfoHdr;
	RGBQUAD *pRgbq;
	COLORREF ColorRef;

	if(x<0||y<0) return 0;
	if(x>=MdiInfo[WndNum].MdiIconEditInfo->pBmpHdr[MdiInfo[WndNum].MdiIconEditInfo->SelectIconNum]->biWidth||
		y>=MdiInfo[WndNum].MdiIconEditInfo->pBmpHdr[MdiInfo[WndNum].MdiIconEditInfo->SelectIconNum]->biHeight/2)
		return 0;

	pBmpInfoHdr=(BITMAPINFOHEADER *)MdiInfo[WndNum].MdiIconEditInfo->pIconImage[MdiInfo[WndNum].MdiIconEditInfo->SelectIconNum];

	//J[e[u擾
	pRgbq=(RGBQUAD *)(MdiInfo[WndNum].MdiIconEditInfo->pIconImage[MdiInfo[WndNum].MdiIconEditInfo->SelectIconNum]+sizeof(BITMAPINFOHEADER));

	//ʏobt@擾
	pBuffer=MdiInfo[WndNum].MdiIconEditInfo->pIconImage[MdiInfo[WndNum].MdiIconEditInfo->SelectIconNum]+
		sizeof(BITMAPINFOHEADER)+
		sizeof(DWORD)*(int)pow((double)2,(double)pBmpInfoHdr->biBitCount);

	//}XNobt@擾
	pMaskBuf=pBuffer+pBmpInfoHdr->biBitCount*pBmpInfoHdr->biWidth*(pBmpInfoHdr->biHeight/2)/8;

	if(x>=pBmpInfoHdr->biWidth||y>=pBmpInfoHdr->biHeight/2) return 0;
	y2=(pBmpInfoHdr->biHeight/2-1)-y;
	i=pBmpInfoHdr->biWidth*y2+x;

	//////////////////
	// }XNsNZ
	if(pBmpInfoHdr->biWidth==16){
		//s4oCgEl
		if((pMaskBuf[(i+pBmpInfoHdr->biWidth*y2)/8]>>(8-(i%8+1)))&0x01)
			return TransparentClrRef;
	}
	else{
		if((pMaskBuf[i/8]>>(8-(i%8+1)))&0x01)
			return TransparentClrRef;
	}

	////////////////
	// ʏsNZ
	switch(pBmpInfoHdr->biBitCount){
		case 4:		//16F
			if(i%2) i2=*(pBuffer+i/2)&0x0F;
			else i2=(*(pBuffer+i/2)>>4)&0x0F;
			ColorRef=RGB(pRgbq[i2].rgbRed,pRgbq[i2].rgbGreen,pRgbq[i2].rgbBlue);
			break;
		case 8:		//256F
			i2=pBuffer[i];
			ColorRef=RGB(pRgbq[i2].rgbRed,pRgbq[i2].rgbGreen,pRgbq[i2].rgbBlue);
			break;
	}
	return ColorRef;
}
void IconEdit_DrawLine(int WndNum,int x1,int y1,int x2,int y2,DWORD ColorCode){
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	int dx,dy,s,step;

	dx=abs(x2-x1);
	dy=abs(y2-y1);
	if(dx>dy){
		if(x1>x2){
			step=(y1>y2)?1:-1;
			s=x1;
			x1=x2;
			x2=s;
			y1=y2;
		}
		else step=(y1<y2)?1:-1;

		PixelChange(WndNum,x1,y1,ColorCode);

		s=dx>>1;
		while(++x1<=x2){
			if((s-=dy)<0){
				s+=dx;
				y1+=step;
			}

			PixelChange(WndNum,x1,y1,ColorCode);
		}
	}
	else{
		if(y1>y2){
			step=(x1>x2)?1:-1;
			s=y1;
			y1=y2;
			y2=s;
			x1=x2;
		}
		else step=(x1<x2)?1:-1;

		PixelChange(WndNum,x1,y1,ColorCode);

		s=dy>>1;
		while(++y1<=y2){
			if((s-=dx)<0){
				s+=dy;
				x1+=step;
			}

			PixelChange(WndNum,x1,y1,ColorCode);
		}
	}
}
void IconEdit_FloodFill(int WndNum,int x,int y,COLORREF FilledColor,DWORD ColorCode){
	extern MDIINFO MdiInfo[MAX_WNDNUM];

	if(x<0||y<0) return;
	if(x>=MdiInfo[WndNum].MdiIconEditInfo->pBmpHdr[MdiInfo[WndNum].MdiIconEditInfo->SelectIconNum]->biWidth||
		y>=MdiInfo[WndNum].MdiIconEditInfo->pBmpHdr[MdiInfo[WndNum].MdiIconEditInfo->SelectIconNum]->biHeight/2)
		return;

	PixelChange(WndNum,x,y,ColorCode);

	if(IconEdit_GetPixel(WndNum,x,y+1)==FilledColor)
		IconEdit_FloodFill(WndNum,x,y+1,FilledColor,ColorCode);
	if(IconEdit_GetPixel(WndNum,x+1,y)==FilledColor)
		IconEdit_FloodFill(WndNum,x+1,y,FilledColor,ColorCode);
	if(IconEdit_GetPixel(WndNum,x,y-1)==FilledColor)
		IconEdit_FloodFill(WndNum,x,y-1,FilledColor,ColorCode);
	if(IconEdit_GetPixel(WndNum,x-1,y)==FilledColor)
		IconEdit_FloodFill(WndNum,x-1,y,FilledColor,ColorCode);
}
void IconEdit_DrawRectangle(int WndNum,int x1,int y1,int x2,int y2,DWORD ColorCode,DWORD FillClrCode,BOOL bFill){
	RectNaturalFormat(&x1,&y1,&x2,&y2);

	IconEdit_DrawLine(WndNum,x1,y1,x1,y2,ColorCode);
	IconEdit_DrawLine(WndNum,x2,y1,x2,y2,ColorCode);
	IconEdit_DrawLine(WndNum,x1+1,y1,x2-1,y1,ColorCode);
	IconEdit_DrawLine(WndNum,x1+1,y2,x2-1,y2,ColorCode);

	if(bFill){
		int x,y;
		for(x=x1+1;x<x2;x++){
			for(y=y1+1;y<y2;y++) PixelChange(WndNum,x,y,FillClrCode);
		}
	}
}
void IconEdit_DrawEllipse(int WndNum,int x1,int y1,int x2,int y2,DWORD ColorCode){
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	RECT rect,rc2;

	rect.left=x1;
	rect.top=y1;
	rect.right=x2;
	rect.bottom=y2;
	RectNaturalFormat(&rect,&rc2);

	int xc,yc,rx,ry;
	int x,y,r;

	rx=(rc2.right-rc2.left)/2;
	ry=(rc2.bottom-rc2.top)/2;
	xc=rc2.left+rx;
	yc=rc2.top+ry;
	if(rx==0&&ry==0){
		if(rc2.bottom-rc2.top==1&&rc2.bottom-rc2.top==1)
			IconEdit_DrawRectangle(WndNum,x1,y1,x2,y2,ColorCode,0,0);
		else IconEdit_DrawLine(WndNum,x1,y1,x2,y2,ColorCode);
		return;
	}

	int bX,bY;
	if((rc2.right-rc2.left)%2) bX=1;
	else bX=0;
	if((rc2.bottom-rc2.top)%2) bY=1;
	else bY=0;

	if(rx>ry){
		x=r=rx;
		y=0;
		while(x>=y){
			x1=x*ry/rx;
			y1=y*ry/rx;

			PixelChange(WndNum,xc+x+bX,yc+y1+bY,ColorCode);
			PixelChange(WndNum,xc+x+bX,yc-y1,ColorCode);
			PixelChange(WndNum,xc-x,yc+y1+bY,ColorCode);
			PixelChange(WndNum,xc-x,yc-y1,ColorCode);
			PixelChange(WndNum,xc+y+bX,yc+x1+bY,ColorCode);
			PixelChange(WndNum,xc+y+bX,yc-x1,ColorCode);
			PixelChange(WndNum,xc-y,yc+x1+bY,ColorCode);
			PixelChange(WndNum,xc-y,yc-x1,ColorCode);

			if((r-=(y++<<1)+1)<=0) r+=(x-- -1)<<1;
		}
	}
	else{
		x=r=ry;
		y=0;
		while(x>=y){
			x1=x*rx/ry;
			y1=y*rx/ry;

			PixelChange(WndNum,xc+x1+bX,yc+y+bY,ColorCode);
			PixelChange(WndNum,xc+x1+bX,yc-y,ColorCode);
			PixelChange(WndNum,xc-x1,yc+y+bY,ColorCode);
			PixelChange(WndNum,xc-x1,yc-y,ColorCode);
			PixelChange(WndNum,xc+y1+bX,yc+x+bY,ColorCode);
			PixelChange(WndNum,xc+y1+bX,yc-x,ColorCode);
			PixelChange(WndNum,xc-y1,yc+x+bY,ColorCode);
			PixelChange(WndNum,xc-y1,yc-x,ColorCode);

			if((r-=(y++<<1)+1)<=0) r+=(x-- -1)<<1;
		}
	}
}

void IconEdit_EraseRect(int WndNum,RECT *pRect){
	extern MDIINFO MdiInfo[MAX_WNDNUM];

	//ύX
	IconEdit_NoticeChanging(WndNum);

	IconEdit_DrawRectangle(WndNum,
		pRect->left,
		pRect->top,
		pRect->right,
		pRect->bottom,
		GetColorCode(WndNum,MdiInfo[WndNum].MdiIconEditInfo->SubColor),
		GetColorCode(WndNum,MdiInfo[WndNum].MdiIconEditInfo->SubColor),1);

	DrawIconToMemBmp(WndNum,0);
	InvalidateRect(MdiInfo[WndNum].MdiIconEditInfo->hMain,NULL,0);
}

void IconEdit_DrawFrame(HWND hwnd,int WndNum,RECT *pRect){
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	HDC hdc;
	HPEN hPen,hOldPen;
	HBRUSH hOldBrush;
	RECT rect;
	POINT pos;

	//////////////////////
	// It[̕`

	hdc=GetDC(hwnd);

	//ȑȎIt[
	BITMAPINFOHEADER *pBmpInfoHdr;
	pBmpInfoHdr=(BITMAPINFOHEADER *)MdiInfo[WndNum].MdiIconEditInfo->pIconImage[MdiInfo[WndNum].MdiIconEditInfo->SelectIconNum];
	pos.x=pBmpInfoHdr->biWidth;
	pos.y=pBmpInfoHdr->biHeight/2;
	GetZoomedPos(&pos);
	BitBlt(hdc,0,0,pos.x,pos.y,MdiInfo[WndNum].MdiIconEditInfo->memdc,0,0,SRCCOPY);


	hPen=CreatePen(PS_DOT,0,RGB(0,0,0));
	SetBkMode(hdc,TRANSPARENT);
	hOldPen=(HPEN)SelectObject(hdc,hPen);
	hOldBrush=(HBRUSH)SelectObject(hdc,GetStockObject(NULL_BRUSH));

	pos.x=pRect->left;
	pos.y=pRect->top;
	GetZoomedPos(&pos);
	rect.left=pos.x;
	rect.top=pos.y;

	pos.x=pRect->right+1;
	pos.y=pRect->bottom+1;
	GetZoomedPos(&pos);
	rect.right=pos.x+1;
	rect.bottom=pos.y+1;

	Rectangle(hdc,rect.left,rect.top,rect.right,rect.bottom);
	SelectObject(hdc,hOldBrush);
	SelectObject(hdc,hOldPen);
	DeleteObject(hPen);

	ReleaseDC(hwnd,hdc);
}
void IconEdit_DrawSelectingRect(HDC hdc,int WndNum){
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	int i2,i3;
	HPEN hPen,hOldPen;
	HBRUSH hOldBrush;
	COLORREF rgb;
	RECT rect;

	rect.left=MdiInfo[WndNum].MdiIconEditInfo->DraggingRect.left*PIXEL_WIDTH+ZOOMED_XPOS;
	rect.top=MdiInfo[WndNum].MdiIconEditInfo->DraggingRect.top*PIXEL_WIDTH;
	rect.right=(MdiInfo[WndNum].MdiIconEditInfo->DraggingRect.right+1)*PIXEL_WIDTH+ZOOMED_XPOS+1;
	rect.bottom=(MdiInfo[WndNum].MdiIconEditInfo->DraggingRect.bottom+1)*PIXEL_WIDTH+1;

	SetBkMode(hdc,TRANSPARENT);

	//
	hOldBrush=(HBRUSH)SelectObject(hdc,GetStockObject(NULL_BRUSH));
	hPen=CreatePen(PS_SOLID,0,RGB(0,0,0));
	hOldPen=(HPEN)SelectObject(hdc,hPen);
	Rectangle(hdc,
		rect.left+2, rect.top+2,
		rect.right-2, rect.bottom-2);
	SelectObject(hdc,hOldPen);
	DeleteObject(hPen);
	hPen=CreatePen(PS_SOLID,0,RGB(255,255,255));
	hOldPen=(HPEN)SelectObject(hdc,hPen);
	Rectangle(hdc,
		rect.left+1, rect.top+1,
		rect.right-1, rect.bottom-1);
	SelectObject(hdc,hOldPen);
	DeleteObject(hPen);
	SelectObject(hdc,hOldBrush);

	rgb=RGB(255,60,30);
	hPen=CreatePen(PS_SOLID,0,rgb);
	hOldPen=(HPEN)SelectObject(hdc,hPen);

	hOldBrush=(HBRUSH)SelectObject(hdc,GetStockObject(WHITE_BRUSH));

	Rectangle(hdc,
		rect.left,rect.top,
		rect.left+5,rect.top+5);
	Rectangle(hdc,
		rect.left,rect.bottom-5,
		rect.left+5,rect.bottom);
	Rectangle(hdc,
		rect.right-5,rect.top,
		rect.right,rect.top+5);
	Rectangle(hdc,
		rect.right-5,rect.bottom-5,
		rect.right,rect.bottom);

	i2=(rect.right-rect.left)/2;
	i3=(rect.bottom-rect.top)/2;
	Rectangle(hdc,
		rect.left+i2-2,rect.top,
		rect.left+i2+3,rect.top+5);
	Rectangle(hdc,
		rect.left+i2-2,rect.bottom-5,
		rect.left+i2+3,rect.bottom);
	Rectangle(hdc,
		rect.left,rect.top+i3-2,
		rect.left+5,rect.top+i3+3);
	Rectangle(hdc,
		rect.right-5,rect.top+i3-2,
		rect.right,rect.top+i3+3);

	SelectObject(hdc,hOldBrush);

	SelectObject(hdc,hOldPen);
	DeleteObject(hPen);
}
void DrawZoomedBitmap(HDC hdc,int WndNum,POINT *pPos){
	extern HANDLE hHeap;
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	int x,y;
	RGBQUAD rgbq;
	HPEN hPen,hOldPen;
	POINT pos;

	BITMAP Bitmap;
	BITMAPINFO SelectingBitmapInfo;
	COLORREF *pSelectingBuffer;

	GetObject(MdiInfo[WndNum].MdiIconEditInfo->hSelectingBmp,sizeof(BITMAP),&Bitmap);
	pSelectingBuffer=(COLORREF *)HeapAlloc(hHeap,0,Bitmap.bmWidth*Bitmap.bmHeight*sizeof(COLORREF));
	SelectingBitmapInfo.bmiHeader.biSize=sizeof(BITMAPINFOHEADER);
	SelectingBitmapInfo.bmiHeader.biWidth=Bitmap.bmWidth;
	SelectingBitmapInfo.bmiHeader.biHeight=Bitmap.bmHeight;
	SelectingBitmapInfo.bmiHeader.biPlanes=1;
	SelectingBitmapInfo.bmiHeader.biBitCount=32;
	SelectingBitmapInfo.bmiHeader.biCompression=BI_RGB;
	GetDIBits(MdiInfo[WndNum].MdiIconEditInfo->memdc,
		MdiInfo[WndNum].MdiIconEditInfo->hSelectingBmp,
		0,Bitmap.bmHeight,
		pSelectingBuffer,&SelectingBitmapInfo,DIB_RGB_COLORS);

	hPen=CreatePen(PS_SOLID,0,RGB(200,200,200));
	hOldPen=(HPEN)SelectObject(hdc,hPen);

	for(y=Bitmap.bmHeight-1;y>=0;y--){
		for(x=0;x<Bitmap.bmWidth;x++){
			memcpy(&rgbq,
				&pSelectingBuffer[(Bitmap.bmHeight-y-1)*Bitmap.bmWidth+x],
				sizeof(RGBQUAD));

			HBRUSH hBrush,hOldBrush;
			hBrush=CreateSolidBrush(RGB(rgbq.rgbRed,rgbq.rgbGreen,rgbq.rgbBlue));
			hOldBrush=(HBRUSH)SelectObject(hdc,hBrush);

			pos.x=pPos->x+x;
			pos.y=pPos->y+y;
			GetZoomedPos(&pos);
			Rectangle(hdc,pos.x,pos.y,pos.x+11,pos.y+11);

			SelectObject(hdc,hOldBrush);
			DeleteObject(hBrush);
		}
	}

	SelectObject(hdc,hOldPen);
	DeleteObject(hPen);

	HeapDefaultFree(pSelectingBuffer);
}
int IconEdit_GetStateOfDraggingFrame(int WndNum,int x,int y){
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	POINT pos;
	RECT rect;

	pos.x=MdiInfo[WndNum].MdiIconEditInfo->DraggingRect.left;
	pos.y=MdiInfo[WndNum].MdiIconEditInfo->DraggingRect.top;
	GetZoomedPos(&pos);
	rect.left=pos.x;
	rect.top=pos.y;
	pos.x=MdiInfo[WndNum].MdiIconEditInfo->DraggingRect.right+1;
	pos.y=MdiInfo[WndNum].MdiIconEditInfo->DraggingRect.bottom+1;
	GetZoomedPos(&pos);
	rect.right=pos.x;
	rect.bottom=pos.y;

	if(rect.left<x&&x<rect.right&&
		rect.top<y&&y<rect.bottom) return FRAME_INSIDE;
	return 0;
}
void DrawSelectingImage(HDC hdc,int WndNum){
	/////////////////////////////////
	// IĂC[W\

	extern MDIINFO MdiInfo[MAX_WNDNUM];
	HDC hDC2;
	SIZE size;
	POINT pos;

	size.cx=MdiInfo[WndNum].MdiIconEditInfo->DraggingRect.right-MdiInfo[WndNum].MdiIconEditInfo->DraggingRect.left;
	size.cy=MdiInfo[WndNum].MdiIconEditInfo->DraggingRect.bottom-MdiInfo[WndNum].MdiIconEditInfo->DraggingRect.top;
	hDC2=CreateCompatibleDC(MdiInfo[WndNum].MdiIconEditInfo->memdc);
	SelectObject(hDC2,MdiInfo[WndNum].MdiIconEditInfo->hSelectingBmp);
	BitBlt(hdc,
		MdiInfo[WndNum].MdiIconEditInfo->DraggingRect.left,
		MdiInfo[WndNum].MdiIconEditInfo->DraggingRect.top,
		size.cx,size.cy,
		hDC2,0,0,SRCCOPY);
	DeleteDC(hDC2);

	//gIC[W\
	pos.x=MdiInfo[WndNum].MdiIconEditInfo->DraggingRect.left;
	pos.y=MdiInfo[WndNum].MdiIconEditInfo->DraggingRect.top;
	DrawZoomedBitmap(hdc,WndNum,&pos);
}
void TempLine(HDC hdc,int WndNum,int x1,int y1,int x2,int y2,COLORREF ColorRef){
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	int dx,dy,s,step;
	HPEN hPen,hOldPen;
	HBRUSH hBrush,hOldBrush;

	hPen=CreatePen(PS_SOLID,0,RGB(200,200,200));
	hOldPen=(HPEN)SelectObject(hdc,hPen);
	hBrush=CreateSolidBrush(ColorRef);
	hOldBrush=(HBRUSH)SelectObject(hdc,hBrush);

	dx=abs(x2-x1);
	dy=abs(y2-y1);
	if(dx>dy){
		if(x1>x2){
			step=(y1>y2)?1:-1;
			s=x1;
			x1=x2;
			x2=s;
			y1=y2;
		}
		else step=(y1<y2)?1:-1;

		SetZoomedPixel(hdc,WndNum,x1,y1);

		s=dx>>1;
		while(++x1<=x2){
			if((s-=dy)<0){
				s+=dx;
				y1+=step;
			}

			SetZoomedPixel(hdc,WndNum,x1,y1);
		}
	}
	else{
		if(y1>y2){
			step=(x1>x2)?1:-1;
			s=y1;
			y1=y2;
			y2=s;
			x1=x2;
		}
		else step=(x1<x2)?1:-1;

		SetZoomedPixel(hdc,WndNum,x1,y1);

		s=dy>>1;
		while(++y1<=y2){
			if((s-=dx)<0){
				s+=dy;
				x1+=step;
			}

			SetZoomedPixel(hdc,WndNum,x1,y1);
		}
	}

	SelectObject(hdc,hOldBrush);
	SelectObject(hdc,hOldPen);
	DeleteObject(hPen);
	DeleteObject(hBrush);
}
void TempRectangle(HDC hdc,int WndNum,int x1,int y1,int x2,int y2,COLORREF ColorRef,COLORREF FillClrRef,BOOL bFill){
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	int x,y;
	HPEN hPen,hOldPen;
	HBRUSH hBrush,hOldBrush;
	RECT rect,rc2;

	hPen=CreatePen(PS_SOLID,0,ColorRef);
	hOldPen=(HPEN)SelectObject(hdc,hPen);
	if(!bFill) hBrush=(HBRUSH)GetStockObject(NULL_BRUSH);
	else hBrush=CreateSolidBrush(FillClrRef);
	hOldBrush=(HBRUSH)SelectObject(hdc,hBrush);
	Rectangle(hdc,x1,y1,x2,y2);
	SelectObject(hdc,hOldBrush);
	SelectObject(hdc,hOldPen);
	DeleteObject(hPen);
	if(bFill) DeleteObject(hBrush);

	rect.left=x1;
	rect.top=y1;
	rect.right=x2;
	rect.bottom=y2;
	RectNaturalFormat(&rect,&rc2);

	hPen=CreatePen(PS_SOLID,0,RGB(200,200,200));
	hOldPen=(HPEN)SelectObject(hdc,hPen);
	hBrush=CreateSolidBrush(ColorRef);
	hOldBrush=(HBRUSH)SelectObject(hdc,hBrush);

	x=rc2.left;
	for(y=rc2.top;y<=rc2.bottom;y++)
		SetZoomedPixel(hdc,WndNum,x,y);

	x=rc2.right;
	for(y=rc2.top;y<=rc2.bottom;y++)
		SetZoomedPixel(hdc,WndNum,x,y);

	y=rc2.top;
	for(x=rc2.left+1;x<rc2.right;x++)
		SetZoomedPixel(hdc,WndNum,x,y);

	y=rc2.bottom;
	for(x=rc2.left+1;x<rc2.right;x++)
		SetZoomedPixel(hdc,WndNum,x,y);

	SelectObject(hdc,hOldBrush);
	DeleteObject(hBrush);

	if(bFill){
		hBrush=CreateSolidBrush(FillClrRef);
		hOldBrush=(HBRUSH)SelectObject(hdc,hBrush);
		for(x=rc2.left+1;x<rc2.right;x++){
			for(y=rc2.top+1;y<rc2.bottom;y++) SetZoomedPixel(hdc,WndNum,x,y);
		}
		SelectObject(hdc,hOldBrush);
		DeleteObject(hBrush);
	}

	SelectObject(hdc,hOldPen);
	DeleteObject(hPen);
}
void TempEllipse(HDC hdc,int WndNum,int x1,int y1,int x2,int y2,COLORREF ColorRef){
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	HPEN hPen,hOldPen;
	HBRUSH hBrush,hOldBrush;
	RECT rect,rc2;

	rect.left=x1;
	rect.top=y1;
	rect.right=x2;
	rect.bottom=y2;
	RectNaturalFormat(&rect,&rc2);

	int xc,yc,rx,ry;
	int x,y,r;

	rx=(rc2.right-rc2.left)/2;
	ry=(rc2.bottom-rc2.top)/2;
	xc=rc2.left+rx;
	yc=rc2.top+ry;
	if(rx==0&&ry==0){
		if(rc2.bottom-rc2.top==1&&rc2.bottom-rc2.top==1)
			TempRectangle(hdc,WndNum,x1,y1,x2,y2,ColorRef,0,0);
		else TempLine(hdc,WndNum,x1,y1,x2,y2,ColorRef);
		return;
	}

	int bX,bY;
	if((rc2.right-rc2.left)%2) bX=1;
	else bX=0;
	if((rc2.bottom-rc2.top)%2) bY=1;
	else bY=0;

	hPen=CreatePen(PS_SOLID,0,RGB(200,200,200));
	hOldPen=(HPEN)SelectObject(hdc,hPen);
	hBrush=CreateSolidBrush(ColorRef);
	hOldBrush=(HBRUSH)SelectObject(hdc,hBrush);

	if(rx>ry){
		x=r=rx;
		y=0;
		while(x>=y){
			x1=x*ry/rx;
			y1=y*ry/rx;

			SetZoomedPixel(hdc,WndNum,xc+x+bX,yc+y1+bY);
			SetZoomedPixel(hdc,WndNum,xc+x+bX,yc-y1);
			SetZoomedPixel(hdc,WndNum,xc-x,yc+y1+bY);
			SetZoomedPixel(hdc,WndNum,xc-x,yc-y1);
			SetZoomedPixel(hdc,WndNum,xc+y+bX,yc+x1+bY);
			SetZoomedPixel(hdc,WndNum,xc+y+bX,yc-x1);
			SetZoomedPixel(hdc,WndNum,xc-y,yc+x1+bY);
			SetZoomedPixel(hdc,WndNum,xc-y,yc-x1);

			SetPixel(hdc,xc+x+bX,yc+y1+bY,ColorRef);
			SetPixel(hdc,xc+x+bX,yc-y1,ColorRef);
			SetPixel(hdc,xc-x,yc+y1+bY,ColorRef);
			SetPixel(hdc,xc-x,yc-y1,ColorRef);
			SetPixel(hdc,xc+y+bX,yc+x1+bY,ColorRef);
			SetPixel(hdc,xc+y+bX,yc-x1,ColorRef);
			SetPixel(hdc,xc-y,yc+x1+bY,ColorRef);
			SetPixel(hdc,xc-y,yc-x1,ColorRef);

			if((r-=(y++<<1)+1)<=0) r+=(x-- -1)<<1;
		}
	}
	else{
		x=r=ry;
		y=0;
		while(x>=y){
			x1=x*rx/ry;
			y1=y*rx/ry;

			SetZoomedPixel(hdc,WndNum,xc+x1+bX,yc+y+bY);
			SetZoomedPixel(hdc,WndNum,xc+x1+bX,yc-y);
			SetZoomedPixel(hdc,WndNum,xc-x1,yc+y+bY);
			SetZoomedPixel(hdc,WndNum,xc-x1,yc-y);
			SetZoomedPixel(hdc,WndNum,xc+y1+bX,yc+x+bY);
			SetZoomedPixel(hdc,WndNum,xc+y1+bX,yc-x);
			SetZoomedPixel(hdc,WndNum,xc-y1,yc+x+bY);
			SetZoomedPixel(hdc,WndNum,xc-y1,yc-x);

			SetPixel(hdc,xc+x1+bX,yc+y+bY,ColorRef);
			SetPixel(hdc,xc+x1+bX,yc-y,ColorRef);
			SetPixel(hdc,xc-x1,yc+y+bY,ColorRef);
			SetPixel(hdc,xc-x1,yc-y,ColorRef);
			SetPixel(hdc,xc+y1+bX,yc+x+bY,ColorRef);
			SetPixel(hdc,xc+y1+bX,yc-x,ColorRef);
			SetPixel(hdc,xc-y1,yc+x+bY,ColorRef);
			SetPixel(hdc,xc-y1,yc-x,ColorRef);

			if((r-=(y++<<1)+1)<=0) r+=(x-- -1)<<1;
		}
	}

	SelectObject(hdc,hOldBrush);
	SelectObject(hdc,hOldPen);
	DeleteObject(hPen);
	DeleteObject(hBrush);
}
LRESULT CALLBACK IconEditWindowProc(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam){
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	int WndNum,dx,dy;
	BOOL bRedrawMemBmp;
	HDC hdc;
	POINT pos,p2;
	RECT rect,rc2;
	COLORREF ColorRef,MainClrRef,SubClrRef;
	static DWORD dwDrag;		//NbN1AENbN2AȊO0
	static int NowDragging;
	static POINT LastPos;
	static RECT OldRect;

	switch(message){
		case WM_LBUTTONDOWN:
		case WM_RBUTTONDOWN:
			if(dwDrag) return 0;

			pos.x=(short)(LOWORD(lParam)-ZOOMED_XPOS)/PIXEL_WIDTH;
			pos.y=(short)HIWORD(lParam)/PIXEL_WIDTH;

			SetFocus(hwnd);
			WndNum=GetWndNum(GetParent(hwnd));

			SetCapture(hwnd);
			if(message==WM_LBUTTONDOWN){
				dwDrag=1;
				MainClrRef=MdiInfo[WndNum].MdiIconEditInfo->MainColor;
				SubClrRef=MdiInfo[WndNum].MdiIconEditInfo->SubColor;
			}
			else{
				dwDrag=2;
				MainClrRef=MdiInfo[WndNum].MdiIconEditInfo->SubColor;
				SubClrRef=MdiInfo[WndNum].MdiIconEditInfo->MainColor;
			}

			if(MdiInfo[WndNum].MdiIconEditInfo->NowTool==IDC_TOOL_SELECT){
				if(dwDrag==2){
					dwDrag=0;
					ReleaseCapture();
					break;
				}

				if(MdiInfo[WndNum].MdiIconEditInfo->SelectLevel){
					NowDragging=IconEdit_GetStateOfDraggingFrame(WndNum,LOWORD(lParam),HIWORD(lParam));
					if(NowDragging==0){
						if(MdiInfo[WndNum].MdiIconEditInfo->SelectLevel==1){
							MdiInfo[WndNum].MdiIconEditInfo->SelectLevel=0;
							InvalidateRect(hwnd,NULL,0);
						}
						else if(MdiInfo[WndNum].MdiIconEditInfo->SelectLevel==2)
							IconEdit_PasteImage(WndNum);

						NowDragging=SELECTING_FRAME;
					}
					else if(NowDragging==FRAME_INSIDE){
						if(MdiInfo[WndNum].MdiIconEditInfo->SelectLevel==1){
							IconEdit_SelectImage(WndNum);
							IconEdit_EraseRect(WndNum,&MdiInfo[WndNum].MdiIconEditInfo->DraggingRect);
						}

						OldRect=MdiInfo[WndNum].MdiIconEditInfo->DraggingRect;
					}
				}
				else{
					NowDragging=SELECTING_FRAME;
					SetCursor(LoadCursor(NULL,IDC_CROSS));
				}

				LastPos=pos;
				InvalidateRect(hwnd,NULL,0);
			}
			else if(MdiInfo[WndNum].MdiIconEditInfo->NowTool==IDC_TOOL_PEN){
				//ύX
				IconEdit_NoticeChanging(WndNum);

				PixelChange(WndNum,pos.x,pos.y,GetColorCode(WndNum,MainClrRef));
				LastPos=pos;

				rect.left=pos.x;
				rect.top=pos.y;
				rect.right=pos.x;
				rect.bottom=pos.y;
				DrawIconToMemBmp(WndNum,&rect);
				InvalidateRect(hwnd,NULL,0);

				SetCursor(LoadCursor(hResInst,MAKEINTRESOURCE(IDC_CURSOR_PEN)));
			}
			else if(MdiInfo[WndNum].MdiIconEditInfo->NowTool==IDC_TOOL_FILL){
				//ύX
				IconEdit_NoticeChanging(WndNum);

				hdc=GetDC(hwnd);
				ColorRef=GetPixel(hdc,pos.x,pos.y);
				ReleaseDC(hwnd,hdc);
				if(ColorRef!=MainClrRef){
					IconEdit_FloodFill(WndNum,pos.x,pos.y,ColorRef,GetColorCode(WndNum,MainClrRef));

					DrawIconToMemBmp(WndNum,0);
					InvalidateRect(hwnd,NULL,0);
				}
				SetCursor(LoadCursor(hResInst,MAKEINTRESOURCE(IDC_CURSOR_FILL)));
			}
			else if(MdiInfo[WndNum].MdiIconEditInfo->NowTool==IDC_TOOL_LINE||
				MdiInfo[WndNum].MdiIconEditInfo->NowTool==IDC_TOOL_RECTANGLE||
				MdiInfo[WndNum].MdiIconEditInfo->NowTool==IDC_TOOL_FILLRECT||
				MdiInfo[WndNum].MdiIconEditInfo->NowTool==IDC_TOOL_FILLRECT2||
				MdiInfo[WndNum].MdiIconEditInfo->NowTool==IDC_TOOL_ELLIPSE){
				hdc=GetDC(hwnd);
				TempLine(hdc,WndNum,pos.x,pos.y,pos.x,pos.y,MainClrRef);
				ReleaseDC(hwnd,hdc);

				LastPos=pos;

				SetCursor(LoadCursor(NULL,IDC_CROSS));
			}
			return 0;
		case WM_LBUTTONUP:
		case WM_RBUTTONUP:
			if(dwDrag==0) return 0;
			if(dwDrag==1&&message==WM_RBUTTONUP||
				dwDrag==2&&message==WM_LBUTTONUP) return 0;

			WndNum=GetWndNum(GetParent(hwnd));

			pos.x=(short)(LOWORD(lParam)-ZOOMED_XPOS)/PIXEL_WIDTH;
			pos.y=(short)HIWORD(lParam)/PIXEL_WIDTH;

			if(dwDrag==1){
				MainClrRef=MdiInfo[WndNum].MdiIconEditInfo->MainColor;
				SubClrRef=MdiInfo[WndNum].MdiIconEditInfo->SubColor;
			}
			else{
				MainClrRef=MdiInfo[WndNum].MdiIconEditInfo->SubColor;
				SubClrRef=MdiInfo[WndNum].MdiIconEditInfo->MainColor;
			}

			ReleaseCapture();
			dwDrag=0;

			bRedrawMemBmp=0;
			if(MdiInfo[WndNum].MdiIconEditInfo->NowTool==IDC_TOOL_SELECT){
				if(NowDragging==SELECTING_FRAME){
					if(LastPos.x==pos.x&&LastPos.y==pos.y){
						ResetState_EditMenu();
						return 0;
					}
					rect.left=LastPos.x;
					rect.top=LastPos.y;
					rect.right=pos.x;
					rect.bottom=pos.y;

					RectNaturalFormat(&rect,&MdiInfo[WndNum].MdiIconEditInfo->DraggingRect);
					LimitRectFormat(WndNum,&MdiInfo[WndNum].MdiIconEditInfo->DraggingRect);
					MdiInfo[WndNum].MdiIconEditInfo->SelectLevel=1;
					InvalidateRect(hwnd,NULL,0);
				}
				else if(NowDragging==FRAME_INSIDE)
					InvalidateRect(hwnd,NULL,0);
			}
			else if(MdiInfo[WndNum].MdiIconEditInfo->NowTool==IDC_TOOL_LINE){
				//ύX
				IconEdit_NoticeChanging(WndNum);

				IconEdit_DrawLine(WndNum,LastPos.x,LastPos.y,pos.x,pos.y,GetColorCode(WndNum,MainClrRef));

				bRedrawMemBmp=1;
			}
			else if(MdiInfo[WndNum].MdiIconEditInfo->NowTool==IDC_TOOL_RECTANGLE){
				//ύX
				IconEdit_NoticeChanging(WndNum);

				IconEdit_DrawRectangle(WndNum,LastPos.x,LastPos.y,pos.x,pos.y,GetColorCode(WndNum,MainClrRef),0,0);

				bRedrawMemBmp=1;
			}
			else if(MdiInfo[WndNum].MdiIconEditInfo->NowTool==IDC_TOOL_FILLRECT){
				//ύX
				IconEdit_NoticeChanging(WndNum);

				IconEdit_DrawRectangle(WndNum,LastPos.x,LastPos.y,pos.x,pos.y,
					GetColorCode(WndNum,MainClrRef),
					GetColorCode(WndNum,SubClrRef),1);

				bRedrawMemBmp=1;
			}
			else if(MdiInfo[WndNum].MdiIconEditInfo->NowTool==IDC_TOOL_FILLRECT2){
				//ύX
				IconEdit_NoticeChanging(WndNum);

				IconEdit_DrawRectangle(WndNum,LastPos.x,LastPos.y,pos.x,pos.y,
					GetColorCode(WndNum,MainClrRef),
					GetColorCode(WndNum,MainClrRef),1);

				bRedrawMemBmp=1;
			}
			else if(MdiInfo[WndNum].MdiIconEditInfo->NowTool==IDC_TOOL_ELLIPSE){
				//ύX
				IconEdit_NoticeChanging(WndNum);

				IconEdit_DrawEllipse(WndNum,LastPos.x,LastPos.y,pos.x,pos.y,GetColorCode(WndNum,MainClrRef));

				bRedrawMemBmp=1;
			}

			if(bRedrawMemBmp){
				rect.left=LastPos.x;
				rect.top=LastPos.y;
				rect.right=pos.x;
				rect.bottom=pos.y;
				RectNaturalFormat(&rect,&rc2);
				DrawIconToMemBmp(WndNum,&rc2);
				InvalidateRect(hwnd,NULL,0);
			}

			ResetState_EditMenu();
			return 0;
		case WM_MOUSEMOVE:
			WndNum=GetWndNum(GetParent(hwnd));

			pos.x=(short)(LOWORD(lParam)-ZOOMED_XPOS)/PIXEL_WIDTH;
			pos.y=(short)HIWORD(lParam)/PIXEL_WIDTH;

			if(dwDrag==1){
				MainClrRef=MdiInfo[WndNum].MdiIconEditInfo->MainColor;
				SubClrRef=MdiInfo[WndNum].MdiIconEditInfo->SubColor;
			}
			else{
				MainClrRef=MdiInfo[WndNum].MdiIconEditInfo->SubColor;
				SubClrRef=MdiInfo[WndNum].MdiIconEditInfo->MainColor;
			}

			if(dwDrag){
				if(MdiInfo[WndNum].MdiIconEditInfo->NowTool==IDC_TOOL_SELECT){
					if(NowDragging==SELECTING_FRAME){
						//͈͑I
						rect.left=LastPos.x;
						rect.top=LastPos.y;
						rect.right=pos.x;
						rect.bottom=pos.y;
						RectNaturalFormat(&rect,&rc2);
						LimitRectFormat(WndNum,&rc2);
						IconEdit_DrawFrame(hwnd,WndNum,&rc2);
					}
					else if(NowDragging==FRAME_INSIDE){
						//ړ
						dx=pos.x-LastPos.x;
						dy=pos.y-LastPos.y;
						MdiInfo[WndNum].MdiIconEditInfo->DraggingRect.left+=dx;
						MdiInfo[WndNum].MdiIconEditInfo->DraggingRect.right+=dx;
						MdiInfo[WndNum].MdiIconEditInfo->DraggingRect.top+=dy;
						MdiInfo[WndNum].MdiIconEditInfo->DraggingRect.bottom+=dy;
						LastPos=pos;


						////////////////////////
						// ÂI͈͂ĕ`
						HRGN hRgn,hRgn2;

						OldRect.right++;
						OldRect.bottom++;

						hRgn=CreateRectRgnIndirect(&OldRect);
						hRgn2=CreateRectRgnIndirect(&MdiInfo[WndNum].MdiIconEditInfo->DraggingRect);
						CombineRgn(hRgn,hRgn,hRgn2,RGN_XOR);
						DeleteObject(hRgn2);

						p2.x=OldRect.left;
						p2.y=OldRect.top;
						GetZoomedPos(&p2);
						rect.left=p2.x;
						rect.top=p2.y;
						p2.x=OldRect.right;
						p2.y=OldRect.bottom;
						GetZoomedPos(&p2);
						rect.right=p2.x+1;
						rect.bottom=p2.y+1;
						hRgn2=CreateRectRgnIndirect(&rect);
						CombineRgn(hRgn,hRgn,hRgn2,RGN_OR);
						DeleteObject(hRgn2);

						p2.x=MdiInfo[WndNum].MdiIconEditInfo->DraggingRect.left;
						p2.y=MdiInfo[WndNum].MdiIconEditInfo->DraggingRect.top;
						GetZoomedPos(&p2);
						rect.left=p2.x;
						rect.top=p2.y;
						p2.x=MdiInfo[WndNum].MdiIconEditInfo->DraggingRect.right;
						p2.y=MdiInfo[WndNum].MdiIconEditInfo->DraggingRect.bottom;
						GetZoomedPos(&p2);
						rect.right=p2.x+1;
						rect.bottom=p2.y+1;
						hRgn2=CreateRectRgnIndirect(&rect);
						CombineRgn(hRgn,hRgn,hRgn2,RGN_XOR);
						DeleteObject(hRgn2);

						InvalidateRgn(hwnd,hRgn,0);
						DeleteObject(hRgn);
						UpdateWindow(hwnd);
						hdc=GetDC(hwnd);
						DrawSelectingImage(hdc,WndNum);
						ReleaseDC(hwnd,hdc);

						OldRect=MdiInfo[WndNum].MdiIconEditInfo->DraggingRect;
					}
				}
				else if(MdiInfo[WndNum].MdiIconEditInfo->NowTool==IDC_TOOL_PEN){
					if(abs(pos.x-LastPos.x)>1||abs(pos.y-LastPos.y)>1){
						IconEdit_DrawLine(WndNum,LastPos.x,LastPos.y,pos.x,pos.y,GetColorCode(WndNum,MainClrRef));

						rect.left=LastPos.x;
						rect.top=LastPos.y;
						rect.right=pos.x;
						rect.bottom=pos.y;
						RectNaturalFormat(&rect,&rc2);
						DrawIconToMemBmp(WndNum,&rc2);
						InvalidateRect(hwnd,NULL,0);
					}
					else{
						PixelChange(WndNum,pos.x,pos.y,GetColorCode(WndNum,MainClrRef));

						rect.left=pos.x;
						rect.top=pos.y;
						rect.right=pos.x;
						rect.bottom=pos.y;
						DrawIconToMemBmp(WndNum,&rect);
						InvalidateRect(hwnd,NULL,0);
					}
					LastPos=pos;
				}
				else if(MdiInfo[WndNum].MdiIconEditInfo->NowTool==IDC_TOOL_LINE){
					InvalidateRect(hwnd,NULL,0);
					UpdateWindow(hwnd);

					hdc=GetDC(hwnd);
					TempLine(hdc,WndNum,LastPos.x,LastPos.y,pos.x,pos.y,MainClrRef);
					ReleaseDC(hwnd,hdc);
				}
				else if(MdiInfo[WndNum].MdiIconEditInfo->NowTool==IDC_TOOL_RECTANGLE){
					InvalidateRect(hwnd,NULL,0);
					UpdateWindow(hwnd);

					hdc=GetDC(hwnd);
					TempRectangle(hdc,WndNum,LastPos.x,LastPos.y,pos.x,pos.y,MainClrRef,0,0);
					ReleaseDC(hwnd,hdc);
				}
				else if(MdiInfo[WndNum].MdiIconEditInfo->NowTool==IDC_TOOL_FILLRECT){
					InvalidateRect(hwnd,NULL,0);
					UpdateWindow(hwnd);

					hdc=GetDC(hwnd);
					TempRectangle(hdc,WndNum,LastPos.x,LastPos.y,pos.x,pos.y,
						MainClrRef,
						SubClrRef,1);
					ReleaseDC(hwnd,hdc);
				}
				else if(MdiInfo[WndNum].MdiIconEditInfo->NowTool==IDC_TOOL_FILLRECT2){
					InvalidateRect(hwnd,NULL,0);
					UpdateWindow(hwnd);

					hdc=GetDC(hwnd);
					TempRectangle(hdc,WndNum,LastPos.x,LastPos.y,pos.x,pos.y,
						MainClrRef,
						MainClrRef,1);
					ReleaseDC(hwnd,hdc);
				}
				else if(MdiInfo[WndNum].MdiIconEditInfo->NowTool==IDC_TOOL_ELLIPSE){
					InvalidateRect(hwnd,NULL,0);
					UpdateWindow(hwnd);

					hdc=GetDC(hwnd);
					TempEllipse(hdc,WndNum,LastPos.x,LastPos.y,pos.x,pos.y,MainClrRef);
					ReleaseDC(hwnd,hdc);
				}
			}
			else{
				//hbOłȂƂ
				if(MdiInfo[WndNum].MdiIconEditInfo->NowTool==IDC_TOOL_SELECT){
					if(MdiInfo[WndNum].MdiIconEditInfo->SelectLevel)
						SetCursorByState(IconEdit_GetStateOfDraggingFrame(WndNum,LOWORD(lParam),HIWORD(lParam)));
					else
						SetCursor(LoadCursor(NULL,IDC_CROSS));
				}
				else if(MdiInfo[WndNum].MdiIconEditInfo->NowTool==IDC_TOOL_PEN)
					SetCursor(LoadCursor(hResInst,MAKEINTRESOURCE(IDC_CURSOR_PEN)));
				else if(MdiInfo[WndNum].MdiIconEditInfo->NowTool==IDC_TOOL_FILL)
					SetCursor(LoadCursor(hResInst,MAKEINTRESOURCE(IDC_CURSOR_FILL)));
				else if(MdiInfo[WndNum].MdiIconEditInfo->NowTool==IDC_TOOL_LINE||
					MdiInfo[WndNum].MdiIconEditInfo->NowTool==IDC_TOOL_RECTANGLE||
					MdiInfo[WndNum].MdiIconEditInfo->NowTool==IDC_TOOL_FILLRECT||
					MdiInfo[WndNum].MdiIconEditInfo->NowTool==IDC_TOOL_FILLRECT2||
					MdiInfo[WndNum].MdiIconEditInfo->NowTool==IDC_TOOL_ELLIPSE){
					SetCursor(LoadCursor(NULL,IDC_CROSS));
				}
			}
			return 0;
		case WM_KEYDOWN:
			switch(wParam){
				case VK_ESCAPE:
					WndNum=GetWndNum(GetParent(hwnd));
					if(MdiInfo[WndNum].MdiIconEditInfo->SelectLevel==2){
						DeleteObject(MdiInfo[WndNum].MdiIconEditInfo->hSelectingBmp);
						MdiInfo[WndNum].MdiIconEditInfo->SelectLevel=0;
					}
					InvalidateRect(hwnd,NULL,0);
					return 0;
			}
			break;
		case WM_PAINT:
			PAINTSTRUCT ps;
			SIZE size;

			WndNum=GetWndNum(GetParent(hwnd));
			BITMAPINFOHEADER *pBmpInfoHdr;
			pBmpInfoHdr=(BITMAPINFOHEADER *)MdiInfo[WndNum].MdiIconEditInfo->pIconImage[MdiInfo[WndNum].MdiIconEditInfo->SelectIconNum];

			hdc=BeginPaint(hwnd,&ps);

			size.cx=ZOOMED_XPOS+pBmpInfoHdr->biWidth*PIXEL_WIDTH+1;
			size.cy=pBmpInfoHdr->biWidth*PIXEL_WIDTH+1;

			BitBlt(hdc,
				0,0,
				size.cx,
				size.cy,
				MdiInfo[WndNum].MdiIconEditInfo->memdc,0,0,SRCCOPY);

			HBRUSH hOldBrush;
			hOldBrush=(HBRUSH)SelectObject(hdc,GetStockObject(WHITE_BRUSH));
			PatBlt(hdc,
				0,size.cy,
				ScreenX,ScreenY-size.cy,
				PATCOPY);
			PatBlt(hdc,
				size.cx,0,
				ScreenX-size.cx,size.cy,
				PATCOPY);

			if(MdiInfo[WndNum].MdiIconEditInfo->SelectLevel==1)
				IconEdit_DrawSelectingRect(hdc,WndNum);
			if(MdiInfo[WndNum].MdiIconEditInfo->SelectLevel==2){
				DrawSelectingImage(hdc,WndNum);
				if(dwDrag==0) IconEdit_DrawSelectingRect(hdc,WndNum);
			}

			EndPaint(hwnd,&ps);
			return 0;
	}
	return DefWindowProc(hwnd,message,wParam,lParam);
}
