#include "common.h"

extern HFONT hFont_TextEdit,hFont_HyperLink_TextEdit;
extern int font_width,font_height;

void TextEditEvent_IME_StartComposition(HWND hwnd){
	int WndNum;
	WndNum=GetWndNum(GetParent(hwnd));

	int iControlTabSpace;
	iControlTabSpace=MdiInfo[WndNum].pmti->iWidth_ControlTabSpace;

	HIMC hIMC;
	hIMC=ImmGetContext(hwnd);

	//R|WVZbg
	POINT pos;
	COMPOSITIONFORM CompForm;
	CompForm.dwStyle=CFS_POINT;
	pos=MdiInfo[WndNum].pmti->StartCaretPos;
	GetScrollBaseCaretPos(WndNum,(int *)&pos.x,(int *)&pos.y);
	CompForm.ptCurrentPos.x=pos.x*font_width+iControlTabSpace;
	CompForm.ptCurrentPos.y=pos.y*font_height;
	ImmSetCompositionWindow(hIMC, &CompForm);

	//tHgZbg
	ImmSetCompositionFont(hIMC,&pobj_nv->lf);

	ImmReleaseContext(hwnd,hIMC);
}

BOOL TextEditEvent_IME_Composition(HWND hwnd,LPARAM lParam){
	if(lParam&GCS_RESULTSTR){
		int WndNum;
		WndNum=GetWndNum(GetParent(hwnd));

		int iControlTabSpace;
		iControlTabSpace=MdiInfo[WndNum].pmti->iWidth_ControlTabSpace;

		////////////////////
		// m蕶擾
		////////////////////

		//ReLXg擾
		HIMC hIMC;
		hIMC=ImmGetContext(hwnd);

		int i;
		char temporary[4096];
		i=ImmGetCompositionString(hIMC, GCS_RESULTSTR, temporary,4096);
		if(i==0) return 0;
		temporary[i]=0;

		//obt@vCX
		TextEdit_ReplaceUpdateUndoData(WndNum,temporary,0,1);
		UpdateWindow(hwnd);

		//R|WVZbgiđIME͂sꍇlj
		POINT pos;
		COMPOSITIONFORM CompForm;
		CompForm.dwStyle=CFS_POINT;
		pos=MdiInfo[WndNum].pmti->StartCaretPos;
		GetScrollBaseCaretPos(WndNum,(int *)&pos.x,(int *)&pos.y);
		CompForm.ptCurrentPos.x=pos.x*font_width+iControlTabSpace;
		CompForm.ptCurrentPos.y=pos.y*font_height;
		ImmSetCompositionWindow(hIMC, &CompForm);

		//ReLXg
		ImmReleaseContext(hwnd,hIMC);
	}

	return 1;
}
