#include "common.h"

long *pFindPos;
int FindPosCounter;

char *CompareSuper(HWND hDlg,char *buffer,char *szFind,BOOL IsBigSmall,BOOL IsRegExp,int *pLength){
	char *pTemp;

	if(buffer[0]=='\0') return 0;

	if(IsRegExp){
		//K\LɂȂ猟
		pTemp=obj_RegExp.compare(hDlg,buffer,szFind,IsBigSmall,pLength);
	}
	else{
		//ʏ̌
		pTemp=ComparisonString(buffer,szFind,IsBigSmall);

		*pLength=lstrlen(szFind);
	}

	return pTemp;
}

void SetSearchData(HWND hDlg,char *str,_int8 IsBigSmall){
	extern HANDLE hHeap;
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	int i,i2,i3,i4,i5,length;
	int WndNum;
	char *buffer,*FindStr,*LineStr;
	HWND hEdit;

	WndNum=GetWndNum(GetWindow(hClient,GW_CHILD));
	if(WndNum==-1) return;
	hEdit=GetWindow(GetWindow(hClient,GW_CHILD),GW_CHILD);

	i=lstrlen(MdiInfo[WndNum].pmti->buffer)+1;

	buffer=(char *)HeapAlloc(hHeap,0,i);
	lstrcpy(buffer,MdiInfo[WndNum].pmti->buffer);

	LineStr=(char *)HeapAlloc(hHeap,0,i+64);

	pFindPos[0]=(long)hEdit;
	i=0;
	i3=1;
	while(1){
		FindStr=CompareSuper(hDlg,buffer+i,str,IsBigSmall,pobj_nv->bRegExp,&length);
		if(FindStr==(char *)-1){
			//G[
			return;
		}
		if(!FindStr) break;

		i=FindStr-buffer;
		for(i4=0,i5=1;i>i4;i4++){
			if(buffer[i4-1]=='\r'&&buffer[i4]=='\n') i5++;
		}
		for(;i>0;i--){
			if(buffer[i-2]=='\r'&&buffer[i-1]=='\n') break;
		}

		FindPosCounter+=sizeof(long);
		pFindPos=(long *)HeapReAlloc(hHeap,0,pFindPos,FindPosCounter);
		pFindPos[i3]=i;

		sprintf(LineStr,"Line:%d  ",i5);
		for(i2=lstrlen(LineStr);;i++,i2++){
			if((buffer[i]=='\r'&&buffer[i+1]=='\n')||buffer[i]=='\0'){
				LineStr[i2]=0;
				break;
			}
			LineStr[i2]=buffer[i];
		}
		SendDlgItemMessage(hDlg,IDC_FINDLIST,LB_ADDSTRING,0,(long)LineStr);
		i3++;
	}
	HeapDefaultFree(buffer);
	HeapDefaultFree(LineStr);
}
BOOL CALLBACK DlgFindAll(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam){
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	int i,WndNum;

	switch(message){
		case WM_INITDIALOG:
			SetPosCenter(hwnd);
			break;
		case WM_COMMAND:
			switch(LOWORD(wParam)){
				case IDC_SHOWITEM:
					i=SendDlgItemMessage(hwnd,IDC_FINDLIST,LB_GETCURSEL,0,0);
					if(i==LB_ERR) return 1;
					i++;

					if(!IsWindow((HWND)pFindPos[0])){
						MessageBeep(0);
						return 1;
					}

					WndNum=GetWndNum(GetParent((HWND)pFindPos[0]));
					if(WndNum==-1) return 1;

					CHARRANGE CharRange;
					CharRange.cpMin=pFindPos[i];

					char *pBuf;
					pBuf=MdiInfo[WndNum].pmti->buffer;

					//s̖[ʒu擾
					for(i=CharRange.cpMin;;i++){
						if(pBuf[i]=='\0') break;
						if(pBuf[i]=='\r'&&pBuf[i+1]=='\n') break;
					}
					CharRange.cpMax=i;

					TextEdit_SetSel(WndNum,CharRange.cpMin,CharRange.cpMax,TRUE);

					SetFocus((HWND)pFindPos[0]);
					return 1;
				case IDCANCEL:
					HeapDefaultFree(pFindPos);
					EndDialog(hwnd,0);
					return 1;
				case IDC_FINDLIST:
					if(HIWORD(wParam)==LBN_DBLCLK) SendMessage(hwnd,WM_COMMAND,IDC_SHOWITEM,0);
					return 1;
			}
			break;
		case WM_SIZE:
			RECT rect;
			GetClientRect(hwnd,&rect);
			MoveWindow(GetDlgItem(hwnd,IDC_FINDLIST),rect.left,26,rect.right,rect.bottom-26,1);
			return 1;
	}
	return 0;
}
BOOL StartSearch(HWND hDlg,char *FindString,_int8 IsBigSmall,BOOL IsShowMessage){
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	int i;
	char *pBuf,msg[255];
	CHARRANGE CharRange;

	int WndNum;
	WndNum=GetWndNum(GetWindow(hClient,GW_CHILD));
	if(WndNum==-1) return 0;

	pBuf=MdiInfo[WndNum].pmti->buffer;

	TextEdit_GetSel(WndNum,&CharRange);
	i=CharRange.cpMax;

FindStart:

	int length;

	i=(int)CompareSuper(hDlg,pBuf+i,FindString,IsBigSmall,pobj_nv->bRegExp,&length);
	if(i==-1){
		//G[
		return 0;
	}

	if(i){
		//𔽓]\
		i-=(int)pBuf;
		CharRange.cpMin=i;
		CharRange.cpMax=i+length;
		TextEdit_SetSel(WndNum,CharRange.cpMin,CharRange.cpMax,TRUE);

		return 1;
	}
	else{
		if(!IsShowMessage) return 0;

		i=(int)CompareSuper(hDlg,pBuf,FindString,IsBigSmall,pobj_nv->bRegExp,&length);
		if(i==-1){
			//G[
			return 0;
		}

		if(i){
			//"t@C̍ŏ猟܂H"
			if(MessageBox(hDlg,STRING_SEARCH_AGAIN,"ProjectEditor - Search",MB_YESNO|MB_ICONINFORMATION)==IDYES){
				i=0;
				goto FindStart;
			}
		}
		else{
			//" \"%s\" ܂"
			sprintf(msg,STRING_SEARCH_NOTFOUND,FindString);
			MessageBox(hDlg,msg,"ProjectEditor - Search",MB_OK|MB_ICONINFORMATION);
		}
	}
	return 0;
}
void AddFindData(HWND hwnd,char ppData[MAX_FINDLIST][MAX_PATH],char *str){
	int i;
	for(i=0;i<MAX_FINDLIST;i++){
		if(lstrcmp(ppData[i],str)==0) break;
	}
	if(i==MAX_FINDLIST) i--;
	for(;i>0;i--) lstrcpy(ppData[i],ppData[i-1]);
	lstrcpy(ppData[0],str);
	SendMessage(hwnd,CB_RESETCONTENT,0,0);
	for(i=0;i<MAX_FINDLIST;i++){
		if(ppData[i][0]=='\0') break;
		SendMessage(hwnd,CB_ADDSTRING,0,(long)ppData[i]);
	}
	SendMessage(hwnd,CB_SETCURSEL,0,0);
}
BOOL CALLBACK DlgFind(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam){
	extern HANDLE hHeap;
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	HWND FindAllDlg;
	int i,WndNum;
	char temporary[8192],*pTemp;
	CHARRANGE CharRange;

	switch(message){
		case WM_INITDIALOG:
			SetPosCenter(hwnd);

			//啶E
			if(pobj_nv->bFindStrBigSmall) SendDlgItemMessage(hwnd,IDC_ISBIGSMALL,BM_SETCHECK,BST_CHECKED,0);

			//K\
			if(pobj_nv->bRegExp) SendDlgItemMessage(hwnd,IDC_REGEXP,BM_SETCHECK,BST_CHECKED,0);

			//R{{bNX
			SendDlgItemMessage(hwnd,IDC_FINDSTR,CB_RESETCONTENT,0,0);
			for(i=0;i<MAX_FINDLIST;i++){
				if(pobj_nv->FindStr[i][0]=='\0') break;
				SendDlgItemMessage(hwnd,IDC_FINDSTR,CB_ADDSTRING,0,(long)pobj_nv->FindStr[i]);
			}
			SendDlgItemMessage(hwnd,IDC_FINDSTR,CB_LIMITTEXT,8192,0);

			WndNum=GetWndNum(GetWindow(hClient,GW_CHILD));

			//IĂ镶擾
			TextEdit_GetSel(WndNum,&CharRange);
			pTemp=(char *)HeapAlloc(hHeap,0,CharRange.cpMax-CharRange.cpMin+1);
			memcpy(pTemp,
				MdiInfo[WndNum].pmti->buffer+CharRange.cpMin,
				CharRange.cpMax-CharRange.cpMin);
			pTemp[CharRange.cpMax-CharRange.cpMin]=0;

			if(pTemp[0]) SetDlgItemText(hwnd,IDC_FINDSTR,pTemp);
			else SendDlgItemMessage(hwnd,IDC_FINDSTR,CB_SETCURSEL,0,0);

			HeapDefaultFree(pTemp);

			SetFocus(GetDlgItem(hwnd,IDC_FINDSTR));
			break;
		case WM_COMMAND:
			switch(LOWORD(wParam)){
				case IDOK:
					GetDlgItemText(hwnd,IDC_FINDSTR,temporary,MAX_PATH);
					if(temporary[0]==0) return 1;
					AddFindData(GetDlgItem(hwnd,IDC_FINDSTR),pobj_nv->FindStr,temporary);

					//啶E
					if(SendDlgItemMessage(hwnd,IDC_ISBIGSMALL,BM_GETCHECK,0,0)) pobj_nv->bFindStrBigSmall=1;
					else pobj_nv->bFindStrBigSmall=0;

					//K\
					if(SendDlgItemMessage(hwnd,IDC_REGEXP,BM_GETCHECK,0,0)) pobj_nv->bRegExp=1;
					else pobj_nv->bRegExp=0;

					StartSearch(hwnd,temporary,pobj_nv->bFindStrBigSmall,1);
					return 1;
				case IDC_FINDALL:
					GetDlgItemText(hwnd,IDC_FINDSTR,temporary,MAX_PATH);
					if(temporary[0]==0) return 1;
					AddFindData(GetDlgItem(hwnd,IDC_FINDSTR),pobj_nv->FindStr,temporary);

					//啶E
					if(SendDlgItemMessage(hwnd,IDC_ISBIGSMALL,BM_GETCHECK,0,0)) pobj_nv->bFindStrBigSmall=1;
					else pobj_nv->bFindStrBigSmall=0;

					//K\
					if(SendDlgItemMessage(hwnd,IDC_REGEXP,BM_GETCHECK,0,0)) pobj_nv->bRegExp=1;
					else pobj_nv->bRegExp=0;

					FindAllDlg=CreateDialog(hResInst,MAKEINTRESOURCE(IDD_FINDALL),GetWindow(hwnd,GW_OWNER),(DLGPROC)DlgFindAll);
					ShowWindow(FindAllDlg,SW_SHOW);

					FindPosCounter=sizeof(long);
					pFindPos=(long *)HeapAlloc(hHeap,0,FindPosCounter);
					SetSearchData(FindAllDlg,temporary,pobj_nv->bFindStrBigSmall);
				case IDCANCEL:
					EndDialog(hwnd,0);
					return 1;
			}
			break;
	}
	return 0;
}
BOOL CALLBACK DlgPermutation(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam){
	extern HANDLE hHeap;
	extern HINSTANCE hInst;
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	int i;
	int WndNum;
	char temporary[8192],temp2[8192],*pTemp;
	CHARRANGE CharRange;
	switch(message){
		case WM_INITDIALOG:
			SetPosCenter(hwnd);

			//啶E
			if(pobj_nv->bFindStrBigSmall) SendDlgItemMessage(hwnd,IDC_ISBIGSMALL,BM_SETCHECK,BST_CHECKED,0);

			//K\
			if(pobj_nv->bRegExp) SendDlgItemMessage(hwnd,IDC_REGEXP,BM_SETCHECK,BST_CHECKED,0);


			//R{{bNX
			SendDlgItemMessage(hwnd,IDC_FINDSTR,CB_RESETCONTENT,0,0);
			for(i=0;i<MAX_FINDLIST;i++){
				if(pobj_nv->FindStr[i][0]=='\0') break;
				SendDlgItemMessage(hwnd,IDC_FINDSTR,CB_ADDSTRING,0,(long)pobj_nv->FindStr[i]);
			}
			SendDlgItemMessage(hwnd,IDC_FINDSTR,CB_LIMITTEXT,8192,0);

			WndNum=GetWndNum(GetWindow(hClient,GW_CHILD));

			//IĂ镶擾
			TextEdit_GetSel(WndNum,&CharRange);
			pTemp=(char *)HeapAlloc(hHeap,0,CharRange.cpMax-CharRange.cpMin+1);
			memcpy(pTemp,
				MdiInfo[WndNum].pmti->buffer+CharRange.cpMin,
				CharRange.cpMax-CharRange.cpMin);
			pTemp[CharRange.cpMax-CharRange.cpMin]=0;

			if(pTemp[0]) SetDlgItemText(hwnd,IDC_FINDSTR,pTemp);
			else SendDlgItemMessage(hwnd,IDC_FINDSTR,CB_SETCURSEL,0,0);

			HeapDefaultFree(pTemp);

			//uR{{bNX
			SendDlgItemMessage(hwnd,IDC_PERMUTATIONSTR,CB_RESETCONTENT,0,0);
			for(i=0;i<MAX_FINDLIST;i++){
				if(pobj_nv->PermutationStr[i][0]=='\0') break;
				SendDlgItemMessage(hwnd,IDC_PERMUTATIONSTR,CB_ADDSTRING,0,(long)pobj_nv->PermutationStr[i]);
			}
			SendDlgItemMessage(hwnd,IDC_PERMUTATIONSTR,CB_SETCURSEL,0,0);
			SendDlgItemMessage(hwnd,IDC_PERMUTATIONSTR,CB_LIMITTEXT,8192,0);

			SetFocus(GetDlgItem(hwnd,IDC_FINDSTR));
			break;
		case WM_COMMAND:
			switch(LOWORD(wParam)){
				case IDC_FIND:
					//啶E
					if(SendDlgItemMessage(hwnd,IDC_ISBIGSMALL,BM_GETCHECK,0,0)) pobj_nv->bFindStrBigSmall=1;
					else pobj_nv->bFindStrBigSmall=0;

					//K\
					if(SendDlgItemMessage(hwnd,IDC_REGEXP,BM_GETCHECK,0,0)) pobj_nv->bRegExp=1;
					else pobj_nv->bRegExp=0;

					GetDlgItemText(hwnd,IDC_FINDSTR,temporary,MAX_PATH);
					if(temporary[0]==0) return 1;
					AddFindData(GetDlgItem(hwnd,IDC_FINDSTR),pobj_nv->FindStr,temporary);

					StartSearch(hwnd,temporary,pobj_nv->bFindStrBigSmall,1);
					return 1;
				case IDC_PERMUTATIONNEXT:
					//////////
					// u
					//////////

					//啶E
					if(SendDlgItemMessage(hwnd,IDC_ISBIGSMALL,BM_GETCHECK,0,0)) pobj_nv->bFindStrBigSmall=1;
					else pobj_nv->bFindStrBigSmall=0;

					//K\
					if(SendDlgItemMessage(hwnd,IDC_REGEXP,BM_GETCHECK,0,0)) pobj_nv->bRegExp=1;
					else pobj_nv->bRegExp=0;

					//镶擾
					GetDlgItemText(hwnd,IDC_FINDSTR,temporary,MAX_PATH);
					if(temporary[0]==0) return 1;
					AddFindData(GetDlgItem(hwnd,IDC_FINDSTR),pobj_nv->FindStr,temporary);

					//u镶擾
					GetDlgItemText(hwnd,IDC_PERMUTATIONSTR,temp2,MAX_PATH);
					AddFindData(GetDlgItem(hwnd,IDC_PERMUTATIONSTR),pobj_nv->PermutationStr,temp2);

					WndNum=GetWndNum(GetWindow(hClient,GW_CHILD));

					//IĂ镶擾
					TextEdit_GetSel(WndNum,&CharRange);
					pTemp=(char *)HeapAlloc(hHeap,0,CharRange.cpMax-CharRange.cpMin+1);
					memcpy(pTemp,
						MdiInfo[WndNum].pmti->buffer+CharRange.cpMin,
						CharRange.cpMax-CharRange.cpMin);
					pTemp[CharRange.cpMax-CharRange.cpMin]=0;

					int length;
					i=(int)CompareSuper(hwnd,pTemp,temporary,pobj_nv->bFindStrBigSmall,pobj_nv->bRegExp,&length);
					if(i==-1){
						HeapDefaultFree(pTemp);
						return 1;
					}

					if(i){
						if(pobj_nv->bRegExp){
							char *pTempPermu;

							//K\̌ʕ擾iup̕擾j
							pTempPermu=obj_RegExp.GetPermuStr(hwnd,pTemp,temporary,temp2,pobj_nv->bFindStrBigSmall);
							if(pTempPermu==(char *)-1||pTempPermu==0){
								HeapDefaultFree(pTemp);
								return 1;
							}

							//u
							TextEdit_ReplaceUpdateUndoData(WndNum,pTempPermu,0,1);

							HeapDefaultFree(pTempPermu);
						}
						else{
							//u
							TextEdit_ReplaceUpdateUndoData(WndNum,temp2,0,1);
						}
					}
					HeapDefaultFree(pTemp);

					//
					SendMessage(hwnd,WM_COMMAND,IDC_FIND,0);

					return 1;
				case IDC_PERMUTATIONALL:
					//////////////
					// ׂĒu
					//////////////

					//啶E
					if(SendDlgItemMessage(hwnd,IDC_ISBIGSMALL,BM_GETCHECK,0,0)) pobj_nv->bFindStrBigSmall=1;
					else pobj_nv->bFindStrBigSmall=0;

					//K\
					if(SendDlgItemMessage(hwnd,IDC_REGEXP,BM_GETCHECK,0,0)) pobj_nv->bRegExp=1;
					else pobj_nv->bRegExp=0;

					//镶擾
					GetDlgItemText(hwnd,IDC_FINDSTR,temporary,MAX_PATH);
					if(temporary[0]==0) return 1;
					AddFindData(GetDlgItem(hwnd,IDC_FINDSTR),pobj_nv->FindStr,temporary);

					//u镶擾
					GetDlgItemText(hwnd,IDC_PERMUTATIONSTR,temp2,MAX_PATH);
					AddFindData(GetDlgItem(hwnd,IDC_PERMUTATIONSTR),pobj_nv->PermutationStr,temp2);

					//K\
					if(SendDlgItemMessage(hwnd,IDC_REGEXP,BM_GETCHECK,0,0)) pobj_nv->bRegExp=1;
					else pobj_nv->bRegExp=0;

					WndNum=GetWndNum(GetWindow(hClient,GW_CHILD));

					TextEdit_SetSel(WndNum,0,0,TRUE);

					while(StartSearch(hwnd,temporary,pobj_nv->bFindStrBigSmall,0)){
						if(pobj_nv->bRegExp){
							//IĂ镶擾
							TextEdit_GetSel(WndNum,&CharRange);
							pTemp=(char *)HeapAlloc(hHeap,0,CharRange.cpMax-CharRange.cpMin+1);
							memcpy(pTemp,
								MdiInfo[WndNum].pmti->buffer+CharRange.cpMin,
								CharRange.cpMax-CharRange.cpMin);
							pTemp[CharRange.cpMax-CharRange.cpMin]=0;

							char *pTempPermu;

							//K\̌ʕ擾iup̕擾j
							pTempPermu=obj_RegExp.GetPermuStr(hwnd,pTemp,temporary,temp2,pobj_nv->bFindStrBigSmall);
							if(pTempPermu==(char *)-1||pTempPermu==0){
								HeapDefaultFree(pTemp);
								return 1;
							}

							//u
							TextEdit_ReplaceUpdateUndoData(WndNum,pTempPermu,0,1);

							HeapDefaultFree(pTempPermu);
							HeapDefaultFree(pTemp);
						}
						else{
							//u
							TextEdit_ReplaceUpdateUndoData(WndNum,temp2,0,1);
						}
					}

					return 1;
				case IDCANCEL:
					EndDialog(hwnd,0);
					return 1;
			}
			break;
	}
	return 0;
}
