#include "../BasicCompiler_Common/common.h"
#include "Opcode.h"

void IncDec(int idCalc, char *lpszLeft, char *lpszRight){
	int VarType;
	LONG_PTR lpVarIndex;
	RELATIVE_VAR VarRelativeVar;


	///////////////////////////
	// ϐAhX擾
	///////////////////////////

	if(!GetVarOffset(
		1,
		lpszLeft,
		&VarType,
		&VarRelativeVar,
		&lpVarIndex)) return;

	//ϐItZbgꎞޔ
	if(IsUse_r11(&VarRelativeVar)){
		//mov qword ptr[rsp+offset],r11     X^bNt[𗘗p
		pobj_sf->push(REG_R11);
	}


	///////////////////////////////////
	// WX^֕ϐ̓eRs[
	///////////////////////////////////

	int reg;
	if(VarType==DEF_DOUBLE){
		reg=REG_XMM0;
		SetXmmReg_DoubleVariable(&VarRelativeVar,reg);
	}
	else if(VarType==DEF_SINGLE){
		reg=REG_XMM0;
		SetXmmReg_SingleVariable(&VarRelativeVar,reg);
	}
	else{
		reg=REG_RAX;
		SetReg_WholeVariable(VarType,&VarRelativeVar,reg);
	}


	if(IsWholeNumberType(VarType)&&lstrcmp(lpszRight,"1")==0&&
		(idCalc==CALC_ADDITION||idCalc==CALC_SUBTRACTION)){
			if(idCalc==CALC_ADDITION){
				//CNg
				op_inc(REG_RAX);
			}
			else if(idCalc==CALC_SUBTRACTION){
				//fNg
				op_dec(REG_RAX);
			}
	}
	else{
		//ʂi[Ă郌WX^ubLO
		pobj_BlockReg->lock(reg);

		//EӂvZ
		int CalcType;
		LONG_PTR lpCalcIndex;
		if(reg==REG_RAX) reg=REG_RCX;
		else reg=REG_RAX;
		CalcType=NumOpe(&reg,lpszRight,VarType,lpVarIndex,&lpCalcIndex);

		//WX^̃ubLO
		pobj_BlockReg->clear();


		if(IsPtrType(VarType)&&IsWholeNumberType(CalcType)&&(!IsPtrType(CalcType))){
			//ӂ|C^^AEӂ^̏ꍇ́AG[Ȃ悤ɂ
			CalcType=VarType;
			lpCalcIndex=lpVarIndex;
		}


		/////////////////////////////////
		// EӁAӂ̌^`FbNs
		/////////////////////////////////

		CheckDifferentType(VarType,lpVarIndex,CalcType,lpCalcIndex,0,0);


		//WX^ǗIuWFNg𐶐
		pobj_reg=new CRegister(REG_RAX);

		//ӗpWX^
		if(IsRealNumberType(VarType))
			pobj_reg->LockXmmReg();
		else
			pobj_reg->LockReg();

		//EӒlWX^
		if(VarType==DEF_DOUBLE)
			ChangeTypeToXmm_Double(CalcType,
				pobj_reg->LockXmmReg(),
				pobj_reg->GetNextReg());
		else if(VarType==DEF_SINGLE)
			ChangeTypeToXmm_Single(CalcType,
				pobj_reg->LockXmmReg(),
				pobj_reg->GetNextReg());
		else
			ChangeTypeToWhole(CalcType,VarType,
				pobj_reg->LockReg(),
				pobj_reg->GetNextXmmReg());

		int type[255],sp;
		LONG_PTR index_stack[255];
		type[0]=VarType;
		type[1]=VarType;
		index_stack[0]=lpVarIndex;
		index_stack[1]=lpVarIndex;
		sp=2;

		switch(idCalc){
			case CALC_XOR:
			case CALC_OR:
			case CALC_AND:
				CalcTwoTerm_Logical(idCalc,type,index_stack,&sp);
				break;
			case CALC_SHL:
			case CALC_SHR:
				Calc_Shift(idCalc,type,&sp);
				break;
			case CALC_ADDITION:
			case CALC_SUBTRACTION:
			case CALC_PRODUCT:
				CalcTwoTerm_Arithmetic(idCalc,type,index_stack,&sp);
				break;
			case CALC_MOD:
				Calc_Mod(type,index_stack,&sp);
				break;
			case CALC_QUOTIENT:
				Calc_Divide(type,&sp,VarType);
				break;
			case CALC_INTQUOTIENT:
				Calc_IntDivide(type,index_stack,&sp);
				break;
			case CALC_POWER:
				Calc_Power(type,&sp);
				break;
		}

		//WX^ǗIuWFNg
		delete pobj_reg;
		pobj_reg=0;
	}


	/////////////////////////////////////////////////
	// raxixmm0j̓eϐɃRs[
	/////////////////////////////////////////////////

	//ϐItZbg𕜌
	if(IsUse_r11(&VarRelativeVar)){
		//mov r11,qword ptr[rsp+offset]     X^bNt[𗘗p
		pobj_sf->pop(REG_R11);
	}

	SetVariableFromRax(VarType,VarType,&VarRelativeVar);
}
