#include "Common.h"


CMainTab *pobj_MainTab=0;
WNDPROC OldMainTabWndProc;


LRESULT CALLBACK MainTabWndProc(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam){
	static BOOL indexDrag=-1;
	TCHITTESTINFO tcHitTest;
	int iNewPos;
	char temporary[MAX_PATH];
	switch(message){
		case WM_LBUTTONDOWN:
			//NbNꂽACeCfbNX擾
			GetCursorPos(&tcHitTest.pt);
			ScreenToClient(pobj_MainTab->hTab,&tcHitTest.pt);
			indexDrag=TabCtrl_HitTest(pobj_MainTab->hTab,&tcHitTest);
			if(indexDrag==-1) break;

			SetCapture(hwnd);
			break;
		case WM_LBUTTONUP:
			indexDrag=-1;
			ReleaseCapture();
			break;
		case WM_MOUSEMOVE:
			if(indexDrag!=-1){
				GetCursorPos(&tcHitTest.pt);
				ScreenToClient(pobj_MainTab->hTab,&tcHitTest.pt);
				iNewPos=TabCtrl_HitTest(pobj_MainTab->hTab,&tcHitTest);
				if(iNewPos==-1) break;
				if(indexDrag!=iNewPos){
					LockWindowUpdate(hOwner);

					TC_ITEM tcItem;
					tcItem.mask=TCIF_TEXT|TCIF_PARAM;
					tcItem.pszText=temporary;
					tcItem.cchTextMax=MAX_PATH;
					TabCtrl_GetItem(pobj_MainTab->hTab,indexDrag,&tcItem);

					TabCtrl_DeleteItem(pobj_MainTab->hTab,indexDrag);

					TabCtrl_InsertItem(pobj_MainTab->hTab,iNewPos,&tcItem);

					int iTemp;
					iTemp=TabCtrl_HitTest(pobj_MainTab->hTab,&tcHitTest);
					if(iTemp!=iNewPos){
						TabCtrl_DeleteItem(pobj_MainTab->hTab,iNewPos);
						TabCtrl_InsertItem(pobj_MainTab->hTab,indexDrag,&tcItem);

						LockWindowUpdate(0);
						break;
					}

					indexDrag=iNewPos;

					LockWindowUpdate(0);
				}
			}
			return 0;
		case WM_PAINT:
			HDC hdc;
			PAINTSTRUCT ps;
			hdc=BeginPaint(hwnd,&ps);
			if(pobj_MainTab)
				pobj_MainTab->draw(hdc);
			EndPaint(hwnd,&ps);
			return 0;
	}
	return CallWindowProc(OldMainTabWndProc,hwnd,message,wParam,lParam);
}


int CMainTab::search(char *lpszText){
	int i2,i3;
	char temporary[MAX_PATH];

	i3=TabCtrl_GetItemCount(hTab);

	TC_ITEM tcItem;
	tcItem.mask=TCIF_TEXT;
	tcItem.pszText=temporary;
	tcItem.cchTextMax=MAX_PATH;

	for(i2=0;i2<i3;i2++){
		TabCtrl_GetItem(hTab,i2,&tcItem);
		if(lstrcmpi(lpszText,tcItem.pszText)==0) break;
	}
	if(i2==i3) return -1;

	return i2;
}


CMainTab::CMainTab(HWND hParent){
	extern HFONT hStatusFont;
	hTab=CreateWindowEx(0,WC_TABCONTROL,NULL,
		WS_CHILD|WS_CLIPCHILDREN|WS_CLIPSIBLINGS|WS_VISIBLE|TCS_OWNERDRAWFIXED,
		0,0,0,0,
		hParent,0,hInst,0);

	TabCtrl_SetPadding(hTab,5,4);

	DWORD dwStyle;
    dwStyle = TabCtrl_GetExtendedStyle(hTab);
    dwStyle &= ~TCS_EX_FLATSEPARATORS;
    TabCtrl_SetExtendedStyle(hTab, dwStyle);


	//TuNX
	OldMainTabWndProc=(WNDPROC)GetWindowLong(hTab,GWL_WNDPROC);
	SetWindowLong(hTab,GWL_WNDPROC,(LONG_PTR)MainTabWndProc);

	//{[h̃tHg𐶐
	LOGFONT lf;
	GetObject(hStatusFont,sizeof(LOGFONT),&lf);
	lf.lfWeight=FW_BOLD;
	hBoldFont=CreateFontIndirect(&lf);

	SendMessage(hTab,WM_SETFONT,(long)hBoldFont,0);
}

CMainTab::~CMainTab(){
	DeleteObject(hBoldFont);
}

void CMainTab::insert(char *lpszText,BOOL bResize,COLORREF color){
	int sw=0;
	if(TabCtrl_GetItemCount(hTab)==0) sw=1;

	if(color==-1) color=RGB(230,230,230);

	TC_ITEM tcItem;
	tcItem.mask=TCIF_TEXT|TCIF_PARAM;
	tcItem.pszText=lpszText;
	tcItem.lParam=color;
	TabCtrl_InsertItem(hTab,0,&tcItem);
	TabCtrl_SetCurSel(hTab,0);

	if(bResize){
		if(sw) ResizeOwnerWnd();
	}
}

void CMainTab::delete_item(char *lpszText,BOOL bResize){
	int i2;
	i2=search(lpszText);
	if(i2==-1) return;

	TabCtrl_DeleteItem(hTab,i2);

	if(bResize){
		if(TabCtrl_GetItemCount(hTab)==0) ResizeOwnerWnd();
	}
}

void CMainTab::reset_item(char *lpszOldText,char *lpszNewText){
	int i2;
	i2=search(lpszOldText);
	if(i2==-1) return;

	TC_ITEM tcItem;
	tcItem.mask=TCIF_TEXT;
	tcItem.pszText=lpszNewText;
	tcItem.cchTextMax=MAX_PATH;

	TabCtrl_SetItem(hTab,i2,&tcItem);
}

COLORREF CMainTab::GetItemColor(char *lpszText){
	int i2,i3;
	char temporary[MAX_PATH];

	i3=TabCtrl_GetItemCount(hTab);

	TC_ITEM tcItem;
	tcItem.mask=TCIF_TEXT|TCIF_PARAM;
	tcItem.pszText=temporary;
	tcItem.cchTextMax=MAX_PATH;

	for(i2=0;i2<i3;i2++){
		TabCtrl_GetItem(hTab,i2,&tcItem);
		if(lstrcmpi(lpszText,tcItem.pszText)==0) return tcItem.lParam;
	}
	return -1;
}

void CMainTab::SelChangeEvent(){
	extern MDIINFO MdiInfo[MAX_WNDNUM];
	char temporary[MAX_PATH];

	int i;
	i=TabCtrl_GetCurSel(hTab);

	TC_ITEM tcItem;
	tcItem.mask=TCIF_TEXT;
	tcItem.pszText=temporary;
	tcItem.cchTextMax=MAX_PATH;
	TabCtrl_GetItem(hTab,i,&tcItem);

	for(i=0;i<MAX_WNDNUM;i++){
		if(lstrcmpi(temporary,MdiInfo[i].title)==0) break;
	}
	BringWindowToTop(MdiInfo[i].hwnd);
}
void CMainTab::MdiActiveEvent(char *lpszText){
	int i2;
	i2=search(lpszText);
	if(i2==-1) return;

	TabCtrl_SetCurSel(hTab,i2);
}

void CMainTab::draw(HDC hdc){
	COLORREF colorGray;
	HBRUSH hGrayBrush;

	int nMaxPage;
	nMaxPage=TabCtrl_GetItemCount(hTab);

	//y𐶐
	HPEN hPen,hOldPen;
	COLORREF colorPen;
	colorPen=RGB(127,140,155);
	hPen=CreatePen(PS_SOLID,0,colorPen);
	hOldPen=(HPEN)SelectObject(hdc,hPen);

	//`̈hԂ
	RECT rc;
	GetClientRect(hTab,&rc);
	FillRect(hdc,&rc,GetSysColorBrush(COLOR_3DFACE));

	//[W𐶐
	HRGN hDefaultRgn;
	hDefaultRgn=CreateRectRgnIndirect(&rc);

	int i;
	char temporary[MAX_PATH];
	HFONT hOldFont;
	TCITEM item;
	memset(&item,0,sizeof(TCITEM));
	item.mask=TCIF_TEXT|TCIF_PARAM;
	item.pszText=temporary;
	item.cchTextMax=MAX_PATH;
	for(i=nMaxPage-1;i>=0;i--){
		if(i==TabCtrl_GetCurSel(hTab)){
			//tH[JX^u͍Ōɕ`悷邽߁Aщz
			continue;
		}

		TabCtrl_GetItem(hTab,i,&item);

		//W擾
		TabCtrl_GetItemRect(hTab,i,&rc);



		////////////////////////////
		// ^ug`
		////////////////////////////
		colorGray=item.lParam;

		//uV𐶐
		hGrayBrush=CreateSolidBrush(colorGray);

		SetBkColor(hdc,colorGray);

		HBRUSH hOldBrush;
		hOldBrush=(HBRUSH)SelectObject(hdc,hGrayBrush);

		HRGN hRgn1,hRgn2;
		hRgn1=CreateRectRgn(rc.left,rc.top,rc.right-20,rc.bottom);
		hRgn2=CreateRectRgn(rc.right-20,rc.top,rc.right+2,rc.bottom);

		SelectObject(hdc,hRgn1);
		RoundRect(hdc,rc.left,rc.top,rc.right+2,rc.bottom+20,20,15);
		SelectObject(hdc,hRgn2);
		RoundRect(hdc,rc.left,rc.top,rc.right+2,rc.bottom+20,3,3);
		SelectObject(hdc,hDefaultRgn);

		DeleteObject(hRgn1);
		DeleteObject(hRgn2);

		SelectObject(hdc,hOldBrush);
		DeleteObject(hGrayBrush);


		extern HFONT hStatusFont;
		hOldFont=(HFONT)SelectObject(hdc,hStatusFont);



		//`
		DrawText(hdc,item.pszText,-1,&rc,DT_CENTER|DT_VCENTER|DT_SINGLELINE);


		SelectObject(hdc,hOldFont);
	}


	/////////////////////////////////
	// tH[JX^u`
	/////////////////////////////////
	i=TabCtrl_GetCurSel(hTab);

	TabCtrl_GetItem(hTab,i,&item);

	//W擾
	TabCtrl_GetItemRect(hTab,i,&rc);

	{
		rc.top-=2;
		////////////////////////////
		// ^ug`
		////////////////////////////
		colorGray=item.lParam;

		//uV𐶐
		hGrayBrush=CreateSolidBrush(colorGray);

		SetBkColor(hdc,colorGray);

		HBRUSH hOldBrush;
		hOldBrush=(HBRUSH)SelectObject(hdc,hGrayBrush);

		HRGN hRgn1,hRgn2;
		hRgn1=CreateRectRgn(rc.left,rc.top,rc.right-20,rc.bottom);
		hRgn2=CreateRectRgn(rc.right-20,rc.top,rc.right+2,rc.bottom);

		SelectObject(hdc,hRgn1);
		RoundRect(hdc,rc.left,rc.top,rc.right+2,rc.bottom+20,20,15);
		SelectObject(hdc,hRgn2);
		RoundRect(hdc,rc.left,rc.top,rc.right+2,rc.bottom+20,3,3);
		SelectObject(hdc,hDefaultRgn);

		DeleteObject(hRgn1);
		DeleteObject(hRgn2);

		SelectObject(hdc,hOldBrush);
		DeleteObject(hGrayBrush);

		rc.top+=2;
	}

	hOldFont=(HFONT)SelectObject(hdc,hBoldFont);

	//`
	DrawText(hdc,item.pszText,-1,&rc,DT_CENTER|DT_VCENTER|DT_SINGLELINE);

	SelectObject(hdc,hOldFont);



	SelectObject(hdc,hOldPen);
	DeleteObject(hPen);

	DeleteObject(hDefaultRgn);
}
