#include "common.h"


CDBTheme *pobj_DBTheme;


CTheme::CTheme(char *path,char *name){
	bActive=0;
	lstrcpy(m_name,name);
	if(path==0) return;

	buffer=ReadBuffer(path);


	//ʏ̕F
	GetRGBValue("rgbDefault",&TextColorInfo.rgbDefault);

	//RgF
	GetRGBValue("rgbComment",&TextColorInfo.rgbComment);

	//Xe[gg
	GetRGBValue("rgbStatement",&TextColorInfo.rgbStatement);

	//F
	GetRGBValue("rgbString",&TextColorInfo.rgbString);

	//wiFiJ[\sj
	GetRGBValue("rgbCursorBack",&TextColorInfo.rgbCursorBack);

	//wiFiʁj
	GetRGBValue("rgbBackground",&TextColorInfo.rgbBackground);

	//wi摜
	if(!GetStringValue("BackgroundImagePath",szBackgroundImagePath)) szBackgroundImagePath[0]=0;

	HeapDefaultFree(buffer);
}
CTheme::CTheme(){
	CTheme(0,THEMENAME_USER);
}
CTheme::~CTheme(){
}

void CTheme::save(){
	buffer=(char *)HeapAlloc(hHeap,0,65536);
	buffer[0]=0;


	//ʏ̕F
	SetRGBValue("rgbDefault",TextColorInfo.rgbDefault);

	//RgF
	SetRGBValue("rgbComment",TextColorInfo.rgbComment);

	//Xe[gg
	SetRGBValue("rgbStatement",TextColorInfo.rgbStatement);

	//F
	SetRGBValue("rgbString",TextColorInfo.rgbString);

	//wiFiJ[\sj
	SetRGBValue("rgbCursorBack",TextColorInfo.rgbCursorBack);

	//wiFiʁj
	SetRGBValue("rgbBackground",TextColorInfo.rgbBackground);

	//wi摜
	SetStringValue("BackgroundImagePath",szBackgroundImagePath);

	char path[MAX_PATH];
	sprintf(path,"%sTheme\\%s",pj_editor_Dir,m_name);
	if(!IsFile(path)){
		CreateDirectory(path,NULL);
	}

	sprintf(path,"%sTheme\\%s\\design.ini",pj_editor_Dir,m_name);
	WriteBuffer(path,buffer,lstrlen(buffer));

	HeapDefaultFree(buffer);
}


CDBTheme::CDBTheme(){
	hBackBmp=0;

	iNum=0;
	ppobj_Theme=(CTheme **)HeapAlloc(hHeap,0,1);

	char temporary[MAX_PATH];
	sprintf(temporary,"%sTheme\\*",pj_editor_Dir);

	HANDLE hFind;
	WIN32_FIND_DATA wfd;
	hFind=FindFirstFile(temporary,&wfd);
	if(hFind!=INVALID_HANDLE_VALUE){
		do{
			if(wfd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY){
				if(!(lstrcmp(wfd.cFileName,".")==0||lstrcmp(wfd.cFileName,"..")==0)){
					//fBNĝƂ
					sprintf(temporary,"%sTheme\\%s\\design.ini",pj_editor_Dir,wfd.cFileName);
					if(IsFile(temporary)){
						add(temporary,wfd.cFileName);
					}
				}
			}
			else{
				//t@ĈƂ
				//
			}
		}while(FindNextFile(hFind,&wfd));
	}
}
CDBTheme::~CDBTheme(){
	int i;
	for(i=0;i<iNum;i++){
		delete ppobj_Theme[i];
	}
	HeapDefaultFree(ppobj_Theme);

	unlock();
}

CTheme *CDBTheme::dupli_check(char *name){
	//d`FbN
	int i;
	for(i=0;i<iNum;i++){
		if(lstrcmpi(ppobj_Theme[i]->m_name,name)==0){
			return ppobj_Theme[i];
		}
	}
	return 0;
}

CTheme *CDBTheme::add(char *path,char *name){
	ppobj_Theme=(CTheme **)HeapReAlloc(hHeap,0,ppobj_Theme,(iNum+1)*sizeof(CTheme *));
	ppobj_Theme[iNum]=new CTheme(path,name);
	iNum++;

	return ppobj_Theme[iNum-1];
}
void CDBTheme::ResetTheme_ToComboBox(HWND hCombo){
	int i;
	for(i=0;i<iNum;i++){
		SendMessage(hCombo,CB_ADDSTRING,0,(LPARAM)ppobj_Theme[i]->m_name);
	}

	//I
	for(i=0;i<iNum;i++){
		if(lstrcmp(ppobj_Theme[i]->m_name,pobj_nv->szActiveTheme)==0){
			i=SendMessage(hCombo,CB_FINDSTRINGEXACT,0,(LPARAM)ppobj_Theme[i]->m_name);
			SendMessage(hCombo,CB_SETCURSEL,i,0);
			break;
		}
	}
}
CTheme *CDBTheme::GetActiveTheme(){
	int i;
	for(i=0;i<iNum;i++){
		if(lstrcmp(ppobj_Theme[i]->m_name,pobj_nv->szActiveTheme)==0){
			return ppobj_Theme[i];
		}
	}
	return 0;
}

void CDBTheme::lock(void){
	CTheme *pobj_Theme;
	pobj_Theme=GetActiveTheme();

	if(pobj_Theme->szBackgroundImagePath[0]=='\0'){
		hBackBmp=0;
		return;
	}

	char szThemeDir[MAX_PATH];
	sprintf(szThemeDir,"%sTheme\\%s\\",pj_editor_Dir,pobj_Theme->m_name);

	char temporary[MAX_PATH];
	lstrcpy(temporary,pobj_Theme->szBackgroundImagePath);
	GetFullPath(temporary,szThemeDir);

	hBackBmp=(HBITMAP)LoadImage(0,temporary,IMAGE_BITMAP,0,0,LR_DEFAULTSIZE|LR_LOADFROMFILE);

	BITMAP Bitmap;
	GetObject(hBackBmp,sizeof(BITMAP),&Bitmap);
	sizeBackBmp.cx=Bitmap.bmWidth;
	sizeBackBmp.cy=Bitmap.bmHeight;
}
void CDBTheme::unlock(void){
	if(hBackBmp) DeleteObject(hBackBmp);
}
