#include "../BasicCompiler_Common/common.h"
#include "Opcode.h"

void ChangeTypeToDouble_ToFpuReg(int OldType){
	//݂̃X^bN̓eWX^ɕۑ
	//NumOpe̒p
	if(OldType==DEF_DOUBLE){
		//fld qword ptr[esp]
		op_fld_ptr_esp(DEF_DOUBLE);

		//add esp,8
		op_add_esp(8);
	}
	else if(OldType==DEF_SINGLE){
		//fld dword ptr[esp]
		op_fld_ptr_esp(DEF_SINGLE);

		//add esp,4
		op_add_esp(4);
	}
	else if(OldType==DEF_LONG){
		//fild dword ptr[esp]
		op_fld_ptr_esp(DEF_LONG);

		//add esp,4
		op_add_esp(4);
	}
	else if(OldType==DEF_DWORD){
		//pop eax
		op_pop(REG_EAX);

		//push 0
		op_push_value(0);

		//push eax
		op_push(REG_EAX);

		//fild qword ptr[esp]
		OpBuffer[obp++]=(char)0xDF;
		OpBuffer[obp++]=(char)0x2C;
		OpBuffer[obp++]=(char)0x24;

		//add esp,8
		op_add_esp(8);
	}
}
void ChangeTypeToDouble(int OldType){
	//݂̃X^bN̓edouble^ɕϊ
	//NumOpe̒p
	if(OldType==DEF_DOUBLE) return;
	else if(OldType==DEF_SINGLE){
		//fld dword ptr[esp]
		op_fld_ptr_esp(DEF_SINGLE);

		//sub esp,4
		op_sub_esp(4);

		//fstp qword ptr[esp]
		OpBuffer[obp++]=(char)0xDD;
		OpBuffer[obp++]=(char)0x1C;
		OpBuffer[obp++]=(char)0x24;
	}
	else if(OldType==DEF_INT64||OldType==DEF_QWORD){
		//64rbg^

		//fild qword ptr[esp]
		op_fld_ptr_esp(DEF_INT64);

		//fstp qword ptr[esp]
		OpBuffer[obp++]=(char)0xDD;
		OpBuffer[obp++]=(char)0x1C;
		OpBuffer[obp++]=(char)0x24;
	}
	else if(IsWholeNumberType(OldType)){
		//̑^

		if(IsSignedType(OldType)){
			//

			if(OldType==DEF_INTEGER){
				//pop eax
				op_pop(REG_EAX);

				//movsx eax,ax
				OpBuffer[obp++]=(char)0x0F;
				OpBuffer[obp++]=(char)0xBF;
				OpBuffer[obp++]=(char)0xC0;

				//push eax
				op_push(REG_EAX);
			}
			else if(OldType==DEF_CHAR){
				//pop eax
				op_pop(REG_EAX);

				//movsx eax,al
				OpBuffer[obp++]=(char)0x0F;
				OpBuffer[obp++]=(char)0xBE;
				OpBuffer[obp++]=(char)0xC0;

				//push eax
				op_push(REG_EAX);
			}

			//fild dword ptr[esp]
			op_fld_ptr_esp(DEF_LONG);

			//sub esp,4
			op_sub_esp(4);
		}
		else{
			//Ȃ

			//pop eax
			op_pop(REG_EAX);

			//push 0
			op_push_value(0);

			//push eax
			op_push(REG_EAX);

			//fild qword ptr[esp]
			OpBuffer[obp++]=(char)0xDF;
			OpBuffer[obp++]=(char)0x2C;
			OpBuffer[obp++]=(char)0x24;
		}

		//fstp qword ptr[esp]
		OpBuffer[obp++]=(char)0xDD;
		OpBuffer[obp++]=(char)0x1C;
		OpBuffer[obp++]=(char)0x24;
	}
	else SetError(9,NULL,cp);
}
void ChangeTypeToSingle(int OldType){
	//݂̃X^bN̓efloat^ɕϊ
	//NumOpe̒p
	if(OldType==DEF_SINGLE) return;
	else if(OldType==DEF_DOUBLE){
		//fld qword ptr[esp]
		op_fld_ptr_esp(DEF_DOUBLE);

		//add esp,4
		op_add_esp(4);

		//fstp dword ptr[esp]
		OpBuffer[obp++]=(char)0xD9;
		OpBuffer[obp++]=(char)0x1C;
		OpBuffer[obp++]=(char)0x24;
	}
	else if(OldType==DEF_INT64||OldType==DEF_QWORD){
		//64rbg^

		//fild qword ptr[esp]
		op_fld_ptr_esp(DEF_INT64);

		//add esp,4
		op_add_esp(4);

		//fstp dword ptr[esp]
		OpBuffer[obp++]=(char)0xD9;
		OpBuffer[obp++]=(char)0x1C;
		OpBuffer[obp++]=(char)0x24;
	}
	else if(IsWholeNumberType(OldType)){
		//̑^

		if(IsSignedType(OldType)){
			//

			if(OldType==DEF_INTEGER){
				//pop eax
				op_pop(REG_EAX);

				//movsx eax,ax
				OpBuffer[obp++]=(char)0x0F;
				OpBuffer[obp++]=(char)0xBF;
				OpBuffer[obp++]=(char)0xC0;

				//push eax
				op_push(REG_EAX);
			}
			else if(OldType==DEF_CHAR){
				//pop eax
				op_pop(REG_EAX);

				//movsx eax,al
				OpBuffer[obp++]=(char)0x0F;
				OpBuffer[obp++]=(char)0xBE;
				OpBuffer[obp++]=(char)0xC0;

				//push eax
				op_push(REG_EAX);
			}

			//fild dword ptr[esp]
			op_fld_ptr_esp(DEF_LONG);
		}
		else{
			//Ȃ

			//fild dword ptr[esp]
			op_fld_ptr_esp(DEF_LONG);
		}

		//fstp dword ptr[esp]
		OpBuffer[obp++]=(char)0xD9;
		OpBuffer[obp++]=(char)0x1C;
		OpBuffer[obp++]=(char)0x24;
	}
	else SetError(9,NULL,cp);
}
void ChangeTypeToInt64(int OldType){
	//݂̃X^bN̓eInt64^ɕϊ
	//NumOpe̒p
	if(Is64Type(OldType)) return;

	else if(OldType==DEF_DOUBLE){
		//fld qword ptr[esp]
		op_fld_ptr_esp(DEF_DOUBLE);

		//fistp qword ptr[esp]
		OpBuffer[obp++]=(char)0xDF;
		OpBuffer[obp++]=(char)0x3C;
		OpBuffer[obp++]=(char)0x24;
	}
	else if(OldType==DEF_SINGLE){
		//fld dword ptr[esp]
		op_fld_ptr_esp(DEF_SINGLE);

		//sub esp,4
		op_sub_esp(4);

		//fistp qword ptr[esp]
		OpBuffer[obp++]=(char)0xDF;
		OpBuffer[obp++]=(char)0x3C;
		OpBuffer[obp++]=(char)0x24;
	}
	else if(IsWholeNumberType(OldType)){
		//̑

		if(IsSignedType(OldType)){
			//

			//pop eax
			op_pop(REG_EAX);

			//cdq
			OpBuffer[obp++]=(char)0x99;

			//push edx
			op_push(REG_EDX);

			//push eax
			op_push(REG_EAX);
		}
		else{
			//Ȃ

			//pop eax
			op_pop(REG_EAX);

			//push 0
			op_push_value(0);

			//push eax
			op_push(REG_EAX);
		}
	}
	else SetError(9,NULL,cp);
}
void ChangeTypeToLong(int OldType){
	//݂̃X^bN̓eLong^ɕϊ
	//NumOpe̒p
	if(OldType==DEF_DOUBLE){
		//fld qword ptr[esp]
		op_fld_ptr_esp(DEF_DOUBLE);

		//add esp,4
		op_add_esp(4);

		//fistp dword ptr[esp]
		OpBuffer[obp++]=(char)0xDB;
		OpBuffer[obp++]=(char)0x1C;
		OpBuffer[obp++]=(char)0x24;
	}
	else if(OldType==DEF_SINGLE){
		//fld dword ptr[esp]
		op_fld_ptr_esp(DEF_SINGLE);

		//fistp dword ptr[esp]
		OpBuffer[obp++]=(char)0xDB;
		OpBuffer[obp++]=(char)0x1C;
		OpBuffer[obp++]=(char)0x24;
	}
	else if(OldType==DEF_INT64||OldType==DEF_QWORD){
		//pop eax
		op_pop(REG_EAX);

		//add esp,4
		op_add_esp(4);

		//push eax
		op_push(REG_EAX);
	}
}
void ChangeTypeToInteger(int OldType){
	//݂̃X^bN̓eInteger^ɕϊ
	if(OldType==DEF_BYTE||OldType==DEF_CHAR||
		OldType==DEF_WORD||OldType==DEF_INTEGER) return;

	ChangeTypeToLong(OldType);

	//pop eax
	op_pop(REG_EAX);

	//and eax,0000FFFFh
	OpBuffer[obp++]=(char)0x25;
	*((long *)(OpBuffer+obp))=0x0000FFFF;
	obp+=sizeof(long);

	//push eax
	op_push(REG_EAX);
}
void ChangeTypeToByte(int OldType){
	//݂̃X^bN̓ebyte^ɕϊ
	if(OldType==DEF_BYTE||OldType==DEF_CHAR) return;

	ChangeTypeToLong(OldType);

	//pop eax
	op_pop(REG_EAX);

	//and eax,000000FFh
	OpBuffer[obp++]=(char)0x25;
	*((long *)(OpBuffer+obp))=0x000000FF;
	obp+=sizeof(long);

	//push eax
	op_push(REG_EAX);
}

void SetVariableFromRax(int VarType,int CalcType,RELATIVE_VAR *pRelativeVar){
	/////////////////////////////////////////////////
	// rax̓eϐɃRs[R[h𒊏o
	/////////////////////////////////////////////////

	if(VarType==DEF_CHAR||VarType==DEF_BYTE){
		//8rbgϐalWX^̓ei[
		SetWholeVariable(sizeof(char),CalcType,pRelativeVar);
	}
	else if(VarType==DEF_INTEGER||VarType==DEF_WORD){
		//16rbgϐaxWX^̓ei[
		SetWholeVariable(sizeof(short),CalcType,pRelativeVar);
	}
	else if(VarType==DEF_LONG||VarType==DEF_DWORD){
		//32rbgϐeaxWX^̓ei[
		SetWholeVariable(sizeof(long),CalcType,pRelativeVar);
	}
	else if(VarType==DEF_INT64||VarType==DEF_QWORD||IsPtrType(VarType)){
		//64rbgϐraxWX^̓ei[
		SetWholeVariable(sizeof(_int64),CalcType,pRelativeVar);
	}
	else if(VarType==DEF_DOUBLE){
		//Double^ϐփX^bN̓ei[
		SetDoubleVariable(CalcType,pRelativeVar);
	}
	else if(VarType==DEF_SINGLE){
		//Single^ϐփX^bN̓ei[
		SetSingleVariable(CalcType,pRelativeVar);
	}
}
void OpcodeCalc(char *Command){
	int i,i2,i3;
	char variable[VN_SIZE];



	//////////////////////////////////////
	// CNgEfNg
	//////////////////////////////////////

	for(i=0;;i++){
		if(Command[i]=='\"'){
			//_uNH[g͕sȂ̂ŃG[
			variable[i]=0;
			SetError(3,variable,cp);
			return;
		}

		if(Command[i]=='('){
			i2=GetStringInPare(variable+i,Command+i);
			i+=i2-1;
			continue;
		}
		if(Command[i]=='['){
			i2=GetStringInBracket(variable+i,Command+i);
			i+=i2-1;
			continue;
		}
		if(Command[i]=='\0'){

			///////////////////////////////////
			// CNgEfNg
			///////////////////////////////////

			if(i>2){
				if(Command[i-2]=='+'&&Command[i-1]=='+'){
					//CNg
					variable[i-2]=0;
					IncDec(CALC_ADDITION,variable,"1");
					return;
				}
				else if(Command[i-2]=='-'&&Command[i-1]=='-'){
					//fNg
					variable[i-2]=0;
					IncDec(CALC_SUBTRACTION,variable,"1");
					return;
				}
			}


			//[̎ʎqG[L[[hɂ
			for(i=0;;i++){
				if(!IsVariableChar(Command[i])){
					variable[i]=0;
					break;
				}
				variable[i]=Command[i];
			}

			LONG_PTR lp;
			if(GetVarType(variable,&lp,0)!=-1){
				//ϐXgɊYƂ
				SetError(1,NULL,cp);
			}
			else{
				if(GetConstHash(variable)){
					//萔XgɊYƂ
					SetError(1,NULL,cp);
				}
				else{
					//ϐXgA萔XgɊYȂƂ
					SetError(3,variable,cp);
				}
			}
			return;
		}

		i2=GetCalcId(Command+i,&i3);
		if(i2){
			variable[i]=0;

			if(Command[i]=='=') break;

			if(Command[i+1+i3]=='='){
				IncDec(i2,variable,Command+i+1+i3+1);
				return;
			}
		}

		variable[i]=Command[i];
	}

	if(Command[i+1]=='\0'){
		SetError(1,NULL,cp);
		return;
	}



	///////////////////////////////////////////////////////////////
	// CfNTsetANZTi[]=Zq̃I[o[[hɑΉj
	///////////////////////////////////////////////////////////////

	char ObjName[VN_SIZE],array_element[VN_SIZE];
	CClass *pobj_c;
	GetArrayElement(variable,ObjName,array_element);
	if(array_element[0]){
		i2=GetVarType(ObjName,(LONG_PTR *)&pobj_c,0);
		if(i2==DEF_OBJECT){
			char temporary[VN_SIZE];
			sprintf(temporary,"%s.%c%c%c",ObjName,1,ESC_OPERATOR,CALC_ARRAY_SET);

			char temp2[VN_SIZE];
			sprintf(temp2,"%s,%s",array_element,Command+i+1);

			int idProc;
			void *pInfo;
			idProc=GetProc(temporary,&pInfo);
			if(idProc){
				CallProc(idProc,pInfo,temporary,temp2,NULL);
				return;
			}
		}
	}



	////////////////////////////////////////
	// ϐ̃^Cv^ʂāAZs
	////////////////////////////////////////

	int VarType,CalcType;
	LONG_PTR lpVarIndex,lpCalcIndex;
	BOOL bCalcUseHeap;

	//^
	VarType=GetVarType(variable,&lpVarIndex,0);
	if(VarType==-1){

		// vpeBp̃\bhĂяo
		if(!CallPropertyMethod(variable,Command+i+1,NULL)){
			//G[\
			GetVarType(variable,&lpVarIndex,1);
		}

		return;
	}

	extern LONG_PTR ProcPtr_BaseIndex;
	if(VarType==DEF_PTR_PROC) ProcPtr_BaseIndex=lpVarIndex;
	else ProcPtr_BaseIndex=-1;

	//NumOpe...iraxA܂xmm0ɓi[j
	int reg=REG_RAX;
	CalcType=NumOpe(&reg,Command+i+1,VarType,lpVarIndex,&lpCalcIndex,&bCalcUseHeap);

	//ʂi[Ă郌WX^ubLO
	pobj_BlockReg->lock(reg);

	if(VarType==-1||CalcType==-1) return;

	//ϐAhX擾
	RELATIVE_VAR VarRelativeVar;
	if(!GetVarOffset(
		1,
		variable,
		&VarType,
		&VarRelativeVar,
		&lpVarIndex)) return;

	//WX^̃ubLO
	pobj_BlockReg->clear();

	if(VarType&FLAG_PTR){
		SetError(14,variable,cp);
		return;
	}

	if(VarType==DEF_OBJECT){
		//IuWFNgCX^Xւ̑
		SetObjectVariableFromRax(lpVarIndex,CalcType,lpCalcIndex,&VarRelativeVar,bCalcUseHeap);
		return;
	}

	if(CalcType==DEF_OBJECT){
		//LXgZq̃I[o[[hɑΉ
		CallCastOperatorProc(REG_RAX,CalcType,lpCalcIndex,bCalcUseHeap,VarType,lpVarIndex);
	}


	/////////////////////////////////
	// EӁAӂ̌^`FbNs
	/////////////////////////////////

	CheckDifferentType(VarType,lpVarIndex,CalcType,lpCalcIndex,0,0);


	/////////////////////////////////////////////////
	// raxixmm0j̓eϐɃRs[
	/////////////////////////////////////////////////
	SetVariableFromRax(VarType,CalcType,&VarRelativeVar);
}
