#include "../BasicCompiler_Common/common.h"
#include "Opcode.h"

BOOL IsUse_ecx(RELATIVE_VAR *pRelativeVar){
	if(pRelativeVar->bOffsetOffset||pRelativeVar->dwKind==VAR_DIRECTMEM) return 1;
	return 0;
}

void SetObjectVariable(LONG_PTR lpVarIndex,int CalcType,LONG_PTR lpCalcIndex,BOOL bUseHeap){
	///////////////////////////////////////////////////////////////////
	// Iy[^ '=' ̃I[o[[h֐Ă
	///////////////////////////////////////////////////////////////////

	int type[10];
	LONG_PTR index_stack[10];
	BOOL array_bUseHeap[10];
	int sp=2;

	//
	type[0]=DEF_OBJECT;
	index_stack[0]=lpVarIndex;
	array_bUseHeap[0]=0;

	//E
	type[1]=CalcType;
	index_stack[1]=lpCalcIndex;
	array_bUseHeap[1]=bUseHeap;

	int iRet;
	iRet=CallOperatorProc(CALC_SUBSITUATION,NULL,type,index_stack,array_bUseHeap,sp);
	if(iRet==-1||iRet==1){
		//ƂA܂̓G[sꂽƂ
		return;
	}

	if(CalcType==DEF_OBJECT&&lpVarIndex==lpCalcIndex){
		//õIuWFNg^SɈvƂ
		//Rs[s

		int object_size;
		object_size=GetSizeOfClass((CClass *)lpVarIndex);

		//mov ecx,object_size
		op_mov_RV(REG_ECX,object_size);

		//pop esi
		op_pop(REG_ESI);

		//pop edi
		op_pop(REG_EDI);

		if(bUseHeap){
			//mov eax,esi
			op_mov_RR(REG_EAX,REG_ESI);
		}

		//rep movs byte ptr[edi],byte ptr[esi]
		op_rep_movs(sizeof(BYTE));

		if(bUseHeap){
			//push eax
			op_push(REG_EAX);

			//call free
			extern SUBINFO *pSub_free;
			op_call(pSub_free);
		}

		return;
	}
	else{
		SetError(1,NULL,cp);
	}
}

void SetDoubleVariable(int type,DWORD VarKind,DWORD offset,BOOL bOffsetOffset){
	ChangeTypeToDouble(type);

	//pop ebx
	op_pop(REG_EBX);

	//pop eax
	op_pop(REG_EAX);

	if(VarKind==VAR_GLOBAL){
		if(bOffsetOffset){
			//mov dword ptr[ecx+offset],ebx
			OpBuffer[obp++]=(char)0x89;
			OpBuffer[obp++]=(char)0x99;
			*((long *)(OpBuffer+obp))=offset;
			pobj_GlobalVarSchedule->add();
			obp+=sizeof(long);

			//mov dword ptr[ecx+offset+sizeof(long)],eax
			OpBuffer[obp++]=(char)0x89;
			OpBuffer[obp++]=(char)0x81;
			*((long *)(OpBuffer+obp))=offset+sizeof(long);
			pobj_GlobalVarSchedule->add();
			obp+=sizeof(long);
		}
		else{
			//mov dword ptr[offset],ebx
			OpBuffer[obp++]=(char)0x89;
			OpBuffer[obp++]=(char)0x1D;
			*((long *)(OpBuffer+obp))=offset;
			pobj_GlobalVarSchedule->add();
			obp+=sizeof(long);

			//mov dword ptr[offset+sizeof(long)],eax
			OpBuffer[obp++]=(char)0xA3;
			*((long *)(OpBuffer+obp))=offset+sizeof(long);
			pobj_GlobalVarSchedule->add();
			obp+=sizeof(long);
		}
	}
	else if(VarKind==VAR_LOCAL){
		if(bOffsetOffset){
			//add ecx,offset
			OpBuffer[obp++]=(char)0x81;
			OpBuffer[obp++]=(char)0xC1;
			*((long *)(OpBuffer+obp))=offset;
			AddLocalVarAddrSchedule();
			obp+=sizeof(long);

			//mov dword ptr[ebp+ecx],ebx
			OpBuffer[obp++]=(char)0x89;
			OpBuffer[obp++]=(char)0x5C;
			OpBuffer[obp++]=(char)0x0D;
			OpBuffer[obp++]=(char)0x00;

			//add ecx,sizeof(long)
			OpBuffer[obp++]=(char)0x83;
			OpBuffer[obp++]=(char)0xC1;
			OpBuffer[obp++]=(char)0x04;

			//mov dword ptr[ebp+ecx],eax
			OpBuffer[obp++]=(char)0x89;
			OpBuffer[obp++]=(char)0x44;
			OpBuffer[obp++]=(char)0x0D;
			OpBuffer[obp++]=(char)0x00;
		}
		else{
			//mov dword ptr[ebp+offset],ebx
			OpBuffer[obp++]=(char)0x89;
			OpBuffer[obp++]=(char)0x9D;
			*((long *)(OpBuffer+obp))=offset;
			AddLocalVarAddrSchedule();
			obp+=sizeof(long);

			//mov dword ptr[ebp+offset+sizeof(long)],eax
			OpBuffer[obp++]=(char)0x89;
			OpBuffer[obp++]=(char)0x85;
			*((long *)(OpBuffer+obp))=offset+sizeof(long);
			AddLocalVarAddrSchedule();
			obp+=sizeof(long);
		}
	}
	else if(VarKind==VAR_REFLOCAL){
		if(bOffsetOffset){
			//add ecx,dword ptr[ebp+offset]
			OpBuffer[obp++]=(char)0x03;
			OpBuffer[obp++]=(char)0x8D;
			*((long *)(OpBuffer+obp))=offset;
			AddLocalVarAddrSchedule();
			obp+=sizeof(long);
		}
		else{
			//mov ecx,dword ptr[ebp+offset]
			OpBuffer[obp++]=(char)0x8B;
			OpBuffer[obp++]=(char)0x8D;
			*((long *)(OpBuffer+obp))=offset;
			AddLocalVarAddrSchedule();
			obp+=sizeof(long);
		}

		//mov dword ptr[ecx],ebx
		OpBuffer[obp++]=(char)0x89;
		OpBuffer[obp++]=(char)0x19;

		//mov dword ptr[ecx+sizeof(long)],eax
		OpBuffer[obp++]=(char)0x89;
		OpBuffer[obp++]=(char)0x41;
		OpBuffer[obp++]=(char)0x04;
	}
	else if(VarKind==VAR_DIRECTMEM){
		//mov dword ptr[ecx],ebx
		OpBuffer[obp++]=(char)0x89;
		OpBuffer[obp++]=(char)0x19;

		//mov dword ptr[ecx+sizeof(long)],eax
		OpBuffer[obp++]=(char)0x89;
		OpBuffer[obp++]=(char)0x41;
		OpBuffer[obp++]=(char)0x04;
	}
}
void SetSingleVariable(int type,DWORD VarKind,DWORD offset,BOOL bOffsetOffset){
	if(type==DEF_SINGLE){
		//32rbgϐƂĂ̂܂܃Rs[
		SetDWordVariable(DEF_DWORD,VarKind,offset,bOffsetOffset);
		return;
	}

	if(type==DEF_DOUBLE){
		//fld qword ptr[esp]
		op_fld_ptr_esp(DEF_DOUBLE);

		//add esp,8
		op_add_esp(8);
	}
	else if(type==DEF_INT64||type==DEF_QWORD){
		//64rbg

		//fild qword ptr[esp]
		op_fld_ptr_esp(DEF_INT64);

		//add esp,8
		op_add_esp(8);
	}
	else if(IsSignedType(type)){
		//萮

		//fild dword ptr[esp]
		op_fld_ptr_esp(DEF_LONG);

		//add esp,4
		op_add_esp(4);
	}
	else{
		if(!IsWholeNumberType(type)){
			//sȌ^̏ꍇ
			SetError(9,NULL,cp);
			return;
		}

		//Ȃ

		//pop eax
		op_pop(REG_EAX);

		//push 0
		op_push_value(0);

		//push eax
		op_push(REG_EAX);

		//fild qword ptr[esp]
		OpBuffer[obp++]=(char)0xDF;
		OpBuffer[obp++]=(char)0x2C;
		OpBuffer[obp++]=(char)0x24;

		//add esp,8
		op_add_esp(8);
	}

	if(VarKind==VAR_GLOBAL){
		if(bOffsetOffset){
			//fstp dword ptr[ecx+offset]
			OpBuffer[obp++]=(char)0xD9;
			OpBuffer[obp++]=(char)0x99;
			*((long *)(OpBuffer+obp))=offset;
			pobj_GlobalVarSchedule->add();
			obp+=sizeof(long);
		}
		else{
			//fstp dword ptr[offset]
			OpBuffer[obp++]=(char)0xD9;
			OpBuffer[obp++]=(char)0x1D;
			*((long *)(OpBuffer+obp))=offset;
			pobj_GlobalVarSchedule->add();
			obp+=sizeof(long);
		}
	}
	else if(VarKind==VAR_LOCAL){
		if(bOffsetOffset){
			//add ecx,offset
			OpBuffer[obp++]=(char)0x81;
			OpBuffer[obp++]=(char)0xC1;
			*((long *)(OpBuffer+obp))=offset;
			AddLocalVarAddrSchedule();
			obp+=sizeof(long);

			//fstp dword ptr[ebp+ecx]
			OpBuffer[obp++]=(char)0xD9;
			OpBuffer[obp++]=(char)0x5C;
			OpBuffer[obp++]=(char)0x0D;
			OpBuffer[obp++]=(char)0x00;
		}
		else{
			//fstp dword ptr[ebp+offset]
			OpBuffer[obp++]=(char)0xD9;
			OpBuffer[obp++]=(char)0x9D;
			*((long *)(OpBuffer+obp))=offset;
			AddLocalVarAddrSchedule();
			obp+=sizeof(long);
		}
	}
	else if(VarKind==VAR_REFLOCAL){
		//mov eax,dword ptr[ebp+offset]
		OpBuffer[obp++]=(char)0x8B;
		OpBuffer[obp++]=(char)0x85;
		*((long *)(OpBuffer+obp))=offset;
		AddLocalVarAddrSchedule();
		obp+=sizeof(long);

		if(bOffsetOffset){
			//add eax,ecx
			OpBuffer[obp++]=(char)0x03;
			OpBuffer[obp++]=(char)0xC1;
		}

		//fstp dword ptr[eax]
		OpBuffer[obp++]=(char)0xD9;
		OpBuffer[obp++]=(char)0x18;
	}
	else if(VarKind==VAR_DIRECTMEM){
		//fstp dword ptr[ecx]
		OpBuffer[obp++]=(char)0xD9;
		OpBuffer[obp++]=(char)0x19;
	}
}
void SetInt64Variable(int type,RELATIVE_VAR *pRelative){
	if(type==DEF_DOUBLE){
		//fld qword ptr[esp]
		op_fld_ptr_esp(DEF_DOUBLE);

		//fistp qword ptr[esp]
		fpu_cast();
		OpBuffer[obp++]=(char)0xDF;
		OpBuffer[obp++]=(char)0x3C;
		OpBuffer[obp++]=(char)0x24;
		fpu_cast_end();

		//pop eax
		op_pop(REG_EAX);

		//pop edx
		op_pop(REG_EDX);
	}
	else if(type==DEF_SINGLE){
		//fld dword ptr[esp]
		op_fld_ptr_esp(DEF_SINGLE);

		//sub esp,4
		op_sub_esp(4);

		//fistp qword ptr[esp]
		fpu_cast();
		OpBuffer[obp++]=(char)0xDF;
		OpBuffer[obp++]=(char)0x3C;
		OpBuffer[obp++]=(char)0x24;
		fpu_cast_end();

		//pop eax
		op_pop(REG_EAX);

		//pop edx
		op_pop(REG_EDX);
	}
	else if(type==DEF_INT64||type==DEF_QWORD){
		//pop eax
		op_pop(REG_EAX);

		//pop edx
		op_pop(REG_EDX);
	}
	else if(IsSignedType(type)){
		//g
		//edx:eax  eax

		//pop eax
		op_pop(REG_EAX);

		//cdq
		op_cdq();
	}
	else{
		if(!IsWholeNumberType(type)){
			//sȌ^̏ꍇ
			SetError(9,NULL,cp);
			return;
		}

		//g
		//edx=0:eax

		//pop eax
		op_pop(REG_EAX);

		//xor edx,edx
		op_zero_reg(REG_EDX);
	}

	if(pRelative->dwKind==VAR_GLOBAL){
		if(pRelative->bOffsetOffset){
			//mov dword ptr[ecx+offset],eax
			OpBuffer[obp++]=(char)0x89;
			OpBuffer[obp++]=(char)0x81;
			*((long *)(OpBuffer+obp))=pRelative->offset;
			pobj_GlobalVarSchedule->add();
			obp+=sizeof(long);

			//mov dword ptr[ecx+offset+sizeof(long)],edx
			OpBuffer[obp++]=(char)0x89;
			OpBuffer[obp++]=(char)0x91;
			*((long *)(OpBuffer+obp))=pRelative->offset+sizeof(long);
			pobj_GlobalVarSchedule->add();
			obp+=sizeof(long);
		}
		else{
			//mov dword ptr[offset],eax
			OpBuffer[obp++]=(char)0xA3;
			*((long *)(OpBuffer+obp))=pRelative->offset;
			pobj_GlobalVarSchedule->add();
			obp+=sizeof(long);

			//mov dword ptr[offset+sizeof(long)],edx
			OpBuffer[obp++]=(char)0x89;
			OpBuffer[obp++]=(char)0x15;
			*((long *)(OpBuffer+obp))=pRelative->offset+sizeof(DWORD);
			pobj_GlobalVarSchedule->add();
			obp+=sizeof(long);
		}
	}
	else if(pRelative->dwKind==VAR_LOCAL){
		if(pRelative->bOffsetOffset){
			//add ecx,offset
			OpBuffer[obp++]=(char)0x81;
			OpBuffer[obp++]=(char)0xC1;
			*((long *)(OpBuffer+obp))=pRelative->offset;
			AddLocalVarAddrSchedule();
			obp+=sizeof(long);

			//mov dword ptr[ebp+ecx],eax
			OpBuffer[obp++]=(char)0x89;
			OpBuffer[obp++]=(char)0x44;
			OpBuffer[obp++]=(char)0x0D;
			OpBuffer[obp++]=(char)0x00;

			//add ecx,sizeof(long)
			OpBuffer[obp++]=(char)0x83;
			OpBuffer[obp++]=(char)0xC1;
			OpBuffer[obp++]=(char)0x04;

			//mov dword ptr[ebp+ecx],edx
			OpBuffer[obp++]=(char)0x89;
			OpBuffer[obp++]=(char)0x54;
			OpBuffer[obp++]=(char)0x0D;
			OpBuffer[obp++]=(char)0x00;
		}
		else{
			//mov dword ptr[ebp+offset],eax
			OpBuffer[obp++]=(char)0x89;
			OpBuffer[obp++]=(char)0x85;
			*((long *)(OpBuffer+obp))=pRelative->offset;
			AddLocalVarAddrSchedule();
			obp+=sizeof(long);

			//mov dword ptr[ebp+offset+sizeof(long)],edx
			OpBuffer[obp++]=(char)0x89;
			OpBuffer[obp++]=(char)0x95;
			*((long *)(OpBuffer+obp))=pRelative->offset+sizeof(long);
			AddLocalVarAddrSchedule();
			obp+=sizeof(long);
		}
	}
	else if(pRelative->dwKind==VAR_REFLOCAL){
		if(pRelative->bOffsetOffset){
			//add ecx,dword ptr[ebp+offset]
			OpBuffer[obp++]=(char)0x03;
			OpBuffer[obp++]=(char)0x8D;
			*((long *)(OpBuffer+obp))=pRelative->offset;
			AddLocalVarAddrSchedule();
			obp+=sizeof(long);
		}
		else{
			//mov ecx,dword ptr[ebp+offset]
			OpBuffer[obp++]=(char)0x8B;
			OpBuffer[obp++]=(char)0x8D;
			*((long *)(OpBuffer+obp))=pRelative->offset;
			AddLocalVarAddrSchedule();
			obp+=sizeof(long);
		}

		//mov dword ptr[ecx],eax
		OpBuffer[obp++]=(char)0x89;
		OpBuffer[obp++]=(char)0x01;

		//mov dword ptr[ecx+sizeof(long)],edx
		OpBuffer[obp++]=(char)0x89;
		OpBuffer[obp++]=(char)0x51;
		OpBuffer[obp++]=(char)0x04;
	}
	else if(pRelative->dwKind==VAR_DIRECTMEM){
		//mov dword ptr[ecx],eax
		OpBuffer[obp++]=(char)0x89;
		OpBuffer[obp++]=(char)0x01;

		//mov dword ptr[ecx+sizeof(long)],edx
		OpBuffer[obp++]=(char)0x89;
		OpBuffer[obp++]=(char)0x51;
		OpBuffer[obp++]=(char)0x04;
	}
}
void SetDWordVariable(int type,DWORD VarKind,DWORD offset,BOOL bOffsetOffset){
	if(type==DEF_DOUBLE||type==DEF_SINGLE){
		if(type==DEF_DOUBLE){
			//fld qword ptr[esp]
			op_fld_ptr_esp(DEF_DOUBLE);
		}
		else if(type==DEF_SINGLE){
			//fld dword ptr[esp]
			op_fld_ptr_esp(DEF_SINGLE);

			//sub esp,4
			op_sub_esp(4);
		}

		//fistp qword ptr[esp]
		fpu_cast();
		OpBuffer[obp++]=(char)0xDF;
		OpBuffer[obp++]=(char)0x3C;
		OpBuffer[obp++]=(char)0x24;
		fpu_cast_end();

		//pop eax
		op_pop(REG_EAX);

		//add esp,4
		op_add_esp(4);
	}
	else if(type==DEF_INT64||type==DEF_QWORD){
		//pop eax
		op_pop(REG_EAX);

		//add esp,4
		op_add_esp(4);
	}
	else{
		if(!IsWholeNumberType(type)){
			//sȌ^̏ꍇ
			SetError(9,NULL,cp);
			return;
		}

		ChangeTypeToWhole(type,DEF_LONG);

		//pop eax
		op_pop(REG_EAX);
	}

	if(VarKind==VAR_GLOBAL){
		if(bOffsetOffset){
			//mov dword ptr[ecx+offset],eax
			OpBuffer[obp++]=(char)0x89;
			OpBuffer[obp++]=(char)0x81;
			*((long *)(OpBuffer+obp))=offset;
			pobj_GlobalVarSchedule->add();
			obp+=sizeof(long);
		}
		else{
			//mov dword ptr[offset],eax
			OpBuffer[obp++]=(char)0xA3;
			*((long *)(OpBuffer+obp))=offset;
			pobj_GlobalVarSchedule->add();
			obp+=sizeof(long);
		}
	}
	else if(VarKind==VAR_LOCAL){
		if(bOffsetOffset){
			//add ecx,offset
			OpBuffer[obp++]=(char)0x81;
			OpBuffer[obp++]=(char)0xC1;
			*((long *)(OpBuffer+obp))=offset;
			AddLocalVarAddrSchedule();
			obp+=sizeof(long);

			//mov dword ptr[ebp+ecx],eax
			OpBuffer[obp++]=(char)0x89;
			OpBuffer[obp++]=(char)0x44;
			OpBuffer[obp++]=(char)0x0D;
			OpBuffer[obp++]=(char)0x00;
		}
		else{
			//mov dword ptr[ebp+offset],eax
			OpBuffer[obp++]=(char)0x89;
			OpBuffer[obp++]=(char)0x85;
			*((long *)(OpBuffer+obp))=offset;
			AddLocalVarAddrSchedule();
			obp+=sizeof(long);
		}
	}
	else if(VarKind==VAR_REFLOCAL){
		if(bOffsetOffset){
			//add ecx,dword ptr[ebp+offset]
			OpBuffer[obp++]=(char)0x03;
			OpBuffer[obp++]=(char)0x8D;
			*((long *)(OpBuffer+obp))=offset;
			AddLocalVarAddrSchedule();
			obp+=sizeof(long);
		}
		else{
			//mov ecx,dword ptr[ebp+offset]
			OpBuffer[obp++]=(char)0x8B;
			OpBuffer[obp++]=(char)0x8D;
			*((long *)(OpBuffer+obp))=offset;
			AddLocalVarAddrSchedule();
			obp+=sizeof(long);
		}

		//mov dword ptr[ecx],eax
		OpBuffer[obp++]=(char)0x89;
		OpBuffer[obp++]=(char)0x01;
	}
	else if(VarKind==VAR_DIRECTMEM){
		//mov dword ptr[ecx],eax
		OpBuffer[obp++]=(char)0x89;
		OpBuffer[obp++]=(char)0x01;
	}
}
void SetLongVariable(int type,DWORD VarKind,DWORD offset,BOOL bOffsetOffset){
	if(type==DEF_DOUBLE||type==DEF_SINGLE){
		if(type==DEF_DOUBLE){
			//fld qword ptr[esp]
			op_fld_ptr_esp(DEF_DOUBLE);

			//add esp,8
			op_add_esp(8);
		}
		else if(type==DEF_SINGLE){
			//fld dword ptr[esp]
			op_fld_ptr_esp(DEF_SINGLE);

			//add esp,4
			op_add_esp(4);
		}

		if(VarKind==VAR_GLOBAL){
			if(bOffsetOffset){
				//fistp dword ptr[ecx+offset]
				fpu_cast();
				OpBuffer[obp++]=(char)0xDB;
				OpBuffer[obp++]=(char)0x99;
				*((long *)(OpBuffer+obp))=offset;
				pobj_GlobalVarSchedule->add();
				obp+=sizeof(long);
				fpu_cast_end();
			}
			else{
				//fistp dword ptr[offset]
				fpu_cast();
				OpBuffer[obp++]=(char)0xDB;
				OpBuffer[obp++]=(char)0x1D;
				*((long *)(OpBuffer+obp))=offset;
				pobj_GlobalVarSchedule->add();
				obp+=sizeof(long);
				fpu_cast_end();
			}
		}
		else if(VarKind==VAR_LOCAL){
			if(bOffsetOffset){
				//add ecx,offset
				OpBuffer[obp++]=(char)0x81;
				OpBuffer[obp++]=(char)0xC1;
				*((long *)(OpBuffer+obp))=offset;
				AddLocalVarAddrSchedule();
				obp+=sizeof(long);

				//fistp dword ptr[ebp+ecx]
				fpu_cast();
				OpBuffer[obp++]=(char)0xDB;
				OpBuffer[obp++]=(char)0x5C;
				OpBuffer[obp++]=(char)0x0D;
				OpBuffer[obp++]=(char)0x00;
				fpu_cast_end();
			}
			else{
				//fistp dword ptr[ebp+offset]
				fpu_cast();
				OpBuffer[obp++]=(char)0xDB;
				OpBuffer[obp++]=(char)0x9D;
				*((long *)(OpBuffer+obp))=offset;
				AddLocalVarAddrSchedule();
				obp+=sizeof(long);
				fpu_cast_end();
			}
		}
		else if(VarKind==VAR_REFLOCAL){
			//mov eax,dword ptr[ebp+offset]
			OpBuffer[obp++]=(char)0x8B;
			OpBuffer[obp++]=(char)0x85;
			*((long *)(OpBuffer+obp))=offset;
			AddLocalVarAddrSchedule();
			obp+=sizeof(long);

			if(bOffsetOffset){
				//add eax,ecx
				OpBuffer[obp++]=(char)0x03;
				OpBuffer[obp++]=(char)0xC1;
			}

			//fistp dword ptr[eax]
			fpu_cast();
			OpBuffer[obp++]=(char)0xDB;
			OpBuffer[obp++]=(char)0x18;
			fpu_cast_end();
		}
		else if(VarKind==VAR_DIRECTMEM){
			//fistp dword ptr[ecx]
			fpu_cast();
			OpBuffer[obp++]=(char)0xDB;
			OpBuffer[obp++]=(char)0x19;
			fpu_cast_end();
		}
	}
	else{
		//ȊǑ^̑DWord̂̂Ɠl
		SetDWordVariable(type,VarKind,offset,bOffsetOffset);
	}
}
void Set16Variable(int type,DWORD VarKind,DWORD offset,BOOL bOffsetOffset){
	ChangeTypeToWhole(type,DEF_INTEGER);

	//pop eax
	op_pop(REG_EAX);

	if(VarKind==VAR_GLOBAL){
		if(bOffsetOffset){
			//mov word ptr[ecx+offset],ax
			OpBuffer[obp++]=(char)0x66;
			OpBuffer[obp++]=(char)0x89;
			OpBuffer[obp++]=(char)0x81;
			*((long *)(OpBuffer+obp))=offset;
			pobj_GlobalVarSchedule->add();
			obp+=sizeof(long);
		}
		else{
			//mov word ptr[offset],ax
			OpBuffer[obp++]=(char)0x66;
			OpBuffer[obp++]=(char)0xA3;
			*((long *)(OpBuffer+obp))=offset;
			pobj_GlobalVarSchedule->add();
			obp+=sizeof(long);
		}
	}
	else if(VarKind==VAR_LOCAL){
		if(bOffsetOffset){
			//add ecx,offset
			OpBuffer[obp++]=(char)0x81;
			OpBuffer[obp++]=(char)0xC1;
			*((long *)(OpBuffer+obp))=offset;
			AddLocalVarAddrSchedule();
			obp+=sizeof(long);

			//mov word ptr[ebp+ecx],ax
			OpBuffer[obp++]=(char)0x66;
			OpBuffer[obp++]=(char)0x89;
			OpBuffer[obp++]=(char)0x44;
			OpBuffer[obp++]=(char)0x0D;
			OpBuffer[obp++]=(char)0x00;
		}
		else{
			//mov word ptr[ebp+offset],ax
			OpBuffer[obp++]=(char)0x66;
			OpBuffer[obp++]=(char)0x89;
			OpBuffer[obp++]=(char)0x85;
			*((long *)(OpBuffer+obp))=offset;
			AddLocalVarAddrSchedule();
			obp+=sizeof(long);
		}
	}
	else if(VarKind==VAR_REFLOCAL){
		//mov ebx,dword ptr[ebp+offset]
		OpBuffer[obp++]=(char)0x8B;
		OpBuffer[obp++]=(char)0x9D;
		*((long *)(OpBuffer+obp))=offset;
		AddLocalVarAddrSchedule();
		obp+=sizeof(long);

		if(bOffsetOffset){
			//add ebx,ecx
			OpBuffer[obp++]=(char)0x03;
			OpBuffer[obp++]=(char)0xD9;
		}

		//mov word ptr[ebx],ax
		OpBuffer[obp++]=(char)0x66;
		OpBuffer[obp++]=(char)0x89;
		OpBuffer[obp++]=(char)0x03;
	}
	else if(VarKind==VAR_DIRECTMEM){
		//mov word ptr[ecx],ax
		OpBuffer[obp++]=(char)0x66;
		OpBuffer[obp++]=(char)0x89;
		OpBuffer[obp++]=(char)0x01;
	}
}
void Set8Variable(int type,DWORD VarKind,DWORD offset,BOOL bOffsetOffset){
	ChangeTypeToWhole(type,DEF_CHAR);

	//pop eax
	op_pop(REG_EAX);

	if(VarKind==VAR_GLOBAL){
		if(bOffsetOffset){
			//mov byte ptr[ecx+offset],al
			OpBuffer[obp++]=(char)0x88;
			OpBuffer[obp++]=(char)0x81;
			*((long *)(OpBuffer+obp))=offset;
			pobj_GlobalVarSchedule->add();
			obp+=sizeof(long);
		}
		else{
			//mov byte ptr[offset],al
			OpBuffer[obp++]=(char)0xA2;
			*((long *)(OpBuffer+obp))=offset;
			pobj_GlobalVarSchedule->add();
			obp+=sizeof(long);
		}
	}
	else if(VarKind==VAR_LOCAL){
		if(bOffsetOffset){
			//add ecx,offset
			OpBuffer[obp++]=(char)0x81;
			OpBuffer[obp++]=(char)0xC1;
			*((long *)(OpBuffer+obp))=offset;
			AddLocalVarAddrSchedule();
			obp+=sizeof(long);

			//mov byte ptr[ebp+ecx],al
			OpBuffer[obp++]=(char)0x88;
			OpBuffer[obp++]=(char)0x44;
			OpBuffer[obp++]=(char)0x0D;
			OpBuffer[obp++]=(char)0x00;
		}
		else{
			//mov byte ptr[ebp+offset],al
			OpBuffer[obp++]=(char)0x88;
			OpBuffer[obp++]=(char)0x85;
			*((long *)(OpBuffer+obp))=offset;
			AddLocalVarAddrSchedule();
			obp+=sizeof(long);
		}
	}
	else if(VarKind==VAR_REFLOCAL){
		//mov ebx,dword ptr[ebp+offset]
		OpBuffer[obp++]=(char)0x8B;
		OpBuffer[obp++]=(char)0x9D;
		*((long *)(OpBuffer+obp))=offset;
		AddLocalVarAddrSchedule();
		obp+=sizeof(long);

		if(bOffsetOffset){
			//add ebx,ecx
			OpBuffer[obp++]=(char)0x03;
			OpBuffer[obp++]=(char)0xD9;
		}

		//mov byte ptr[ebx],al
		OpBuffer[obp++]=(char)0x88;
		OpBuffer[obp++]=(char)0x03;
	}
	else if(VarKind==VAR_DIRECTMEM){
		//mov byte ptr[ecx],al
		OpBuffer[obp++]=(char)0x88;
		OpBuffer[obp++]=(char)0x01;
	}
}
