//BasicFixed.h


#define MAX_ARRAYDIM	16
#define PTR_SIZE		sizeof(LONG_PTR)
#define VN_SIZE			1024
#define MAX_LEN			65535


////////////////
// }V^Cv
////////////////

#define MACHINE_X86		1
#define MACHINE_AMD64	2


////////////////
// ^
////////////////

#define DEF_NON			-1

/* basic\command.sbp "_System_Type_***" 萔ƓKv */
#define FLAG_PTR		0x80000000
#define FLAG_CAST		0x40000000

//^
#define DEF_SBYTE		0x00000001
#define DEF_BYTE		0x00000002
#define DEF_INTEGER		0x00000003
#define DEF_WORD		0x00000004
#define DEF_LONG		0x00000005
#define DEF_DWORD		0x00000006
#define DEF_INT64		0x00000007
#define DEF_QWORD		0x00000008

//^
#define DEF_SINGLE		0x00000009
#define DEF_DOUBLE		0x0000000A

//^
#define DEF_CHAR		0x0000000B

//bool^
#define DEF_BOOLEAN		0x0000000C

//^
#define DEF_STRING		0x0000000D

//|C^^
#define DEF_PTR_VOID	0x0000000E
#define DEF_PTR_PROC	0x0000000F

//^
#define DEF_ANY						0x00000015
#define DEF_ELLIPSE					0x00000016
#define DEF_OBJECT					0x00000017		// NX
#define DEF_STRUCT					0x00000018		// \
#define DEF_TYPE_PARAMETER			0x00000019		// ^p[^iWFlNXT|[gj

//|C^^
#define MASK_PTR		0x0000ff00
#define MASK_NATURAL	0x000000ff

#define PTR_LEVEL(t)	(((t)&MASK_PTR)>>8)
#define NATURAL_TYPE(t)	((t)&MASK_NATURAL)
#define MAKE_PTR_TYPE(t,p)	((t)|((p)<<8))
#define PTR_LEVEL_UP(t)		t = MAKE_PTR_TYPE(NATURAL_TYPE(t),PTR_LEVEL(t)+1)
#define PTR_LEVEL_DOWN(t)	t = MAKE_PTR_TYPE(NATURAL_TYPE(t),PTR_LEVEL(t)-1)

#define DEF_PTR_OBJECT	MAKE_PTR_TYPE(DEF_OBJECT,1)
#define DEF_PTR_STRUCT	MAKE_PTR_TYPE(DEF_STRUCT,1)



//NumOpe֐̌ʂel̏ꍇA̒l̕⏕indexɊi[
#define LITERAL_NULL		-2
#define LITERAL_M128_0		-3
#define LITERAL_0_255		-4
#define LITERAL_M32768_0	-5
#define LITERAL_0_65535		-6
#define LITERAL_OTHER_MINUS	-7
#define LITERAL_OTHER_PLUS	-8

#define LITERAL_STRING		-9

#define IS_LITERAL(x) (x<=LITERAL_NULL&&x!=LITERAL_STRING)
#define IS_MINUS_LITERAL(x) (x==LITERAL_M128_0||x==LITERAL_M32768_0||x==LITERAL_OTHER_MINUS)
#define IS_POSITIVE_LITERAL(x) (x==LITERAL_NULL||x==LITERAL_0_255||x==LITERAL_0_65535||x==LITERAL_OTHER_PLUS)

//////////////////////////////////////
/* ZqiD揇ʂ֌WĂj */
//////////////////////////////////////

//_Zq
#define CALC_XOR			3	// Xor
#define CALC_OR				6	// Or
#define CALC_AND			9	// And
#define CALC_NOT			12	// Not

//rZq
#define CALC_PE				21	// <=
#define CALC_QE				22	// >=
#define CALC_NOTEQUAL		23	// <>
#define CALC_EQUAL			24	// =
#define CALC_P				25	// <
#define CALC_Q				26	// >

//ZpZq
#define CALC_SHL			31	//<<
#define CALC_SHR			32	//>>
#define CALC_ADDITION		41	// +
#define CALC_SUBTRACTION	42	// -
#define CALC_STRPLUS		43	// &
#define CALC_MOD			51	// Mod
#define CALC_PRODUCT		61	// *
#define CALC_QUOTIENT		62	// /
#define CALC_INTQUOTIENT	63	//Z
#define CALC_AS				71	// As
#define CALC_BYVAL			72	// ByVal
#define CALC_MINUSMARK		81	// -x
#define CALC_POWER			91	// ^

//Zq
#define CALC_SUBSITUATION	200

//YZq
#define CALC_ARRAY_GET		201
#define CALC_ARRAY_SET		202


//////////////////////////////////////////////////////////////////////
// GXP[vV[PXp̃oCgR[h0xA0`0xCF͈̔͂pł
//////////////////////////////////////////////////////////////////////

//ȉpGXP[vV[PX
#define ESC_MOD				'1'		// MOD Zq
#define ESC_AND				'&'		// AND Zq
#define ESC_OR				'3'		// OR Zq
#define ESC_XOR				'4'		// XOR Zq
#define ESC_NOT				'5'		// NOT Zq
#define ESC_AS				'6'		// ASi؂蕶j
#define ESC_THEN			2		// Then
#define ESC_ELSE			3		// Else
#define ESC_IF				'A'		// If
#define ESC_ELSEIF			'B'		// ElseIf
#define ESC_ENDIF			'C'		// End If
#define ESC_DEF				'D'		// Def
#define ESC_DECLARE			'E'		// Declare
#define ESC_SUB				'F'		// Sub
#define ESC_ENDSUB			'G'		// End Sub
#define ESC_EXITSUB			'H'		// Exit Sub
#define ESC_FUNCTION		'I'		// Function
#define ESC_ENDFUNCTION		'J'		// End Function
#define ESC_EXITFUNCTION	'K'		// Exit Function
#define ESC_BYVAL			'L'		// ByVal
#define ESC_BYREF			'M'		// ByRef
#define ESC_TYPE			'N'		// Type
#define ESC_ENDTYPE			'O'		// End Type
#define ESC_EXITFOR			'P'		// Exit For
#define ESC_EXITWHILE		'Q'		// Exit Wend
#define ESC_EXITDO			'R'		// Exit Do
#define ESC_SELECTCASE		'S'		// Select Case
#define ESC_CASE			'T'		// Case
#define ESC_CASEELSE		'U'		// Case Else
#define ESC_ENDSELECT		'V'		// End Select
#define ESC_CONST			'W'		// Const
#define ESC_WITH			'X'		// With
#define ESC_ENDWITH			'Y'		// End With
#define ESC_CDECL			'Z'		// cdeclK
#define ESC_MACRO			'a'		// Macro
#define ESC_ENDMACRO		'b'		// End Macro
#define ESC_EXITMACRO		'c'		// Exit Macro
#define ESC_EXPORT			'd'		// Export
#define ESC_CONTINUE		'e'		// Continue
#define ESC_PSMEM			'f'		// "->" Member of Pointer Structi\̃|C^̃oQƁj
#define ESC_STATIC			'g'		// Static
#define ESC_TYPEDEF			'h'		// TypeDef
#define ESC_TRY				'i'		// Try
#define ESC_CATCH			'j'		// Catch
#define ESC_FINALLY			'k'		// Finally
#define ESC_THROW			'l'		// Throw
#define ESC_ENDTRY			'm'		// End Try
#define ESC_NAMESPACE		'o'		// Namespace
#define ESC_ENDNAMESPACE	'p'		// End Namespace
#define ESC_IMPORTS			'q'		// Imports
#define ESC_CLEARNAMESPACEIMPORTED 'r'	// _ClearNamespaceImported
#define ESC_OPERATOR		's'
//EXEt@CpGXP[vV[PX
#define ESC_USING			't'		// PrintߌUsing
#define ESC_FOR				'u'		// OpenߌFor
#define ESC_LINENUM			'v'		// sԍ

//IuWFNgwGXP[vV[PX
#define ESC_CLASS			(char)0xA0
#define ESC_ENDCLASS		(char)0xA1
#define ESC_ABSTRACT		(char)0xA2
#define ESC_VIRTUAL			(char)0xA3
#define ESC_OVERRIDE		(char)0xA4
#define ESC_INHERITS		(char)0xA5
#define ESC_ENUM			(char)0xA6
#define ESC_ENDENUM			(char)0xA7
#define ESC_NEW				(char)0xA8
#define ESC_INTERFACE		(char)0xA9
#define ESC_ENDINTERFACE	(char)0xAA
