

class CClass;
struct SUBINFO;

//f[^^
struct TYPEINFO{
	int type;
	union{
		LONG_PTR lpIndex;
		CClass *pobj_Class;
	}u;
};

#define ACCESS_NON			0
#define ACCESS_PRIVATE		1
#define ACCESS_PUBLIC		2
#define ACCESS_PROTECTED	3

class CMember{
	bool isConst;
public:
	char *name;
	int SubScripts[MAX_ARRAYDIM];
	TYPEINFO TypeInfo;

	DWORD dwAccess;

	char *InitBuf;
	char *ConstractParameter;

	int source_code_address;


	CMember( CClass *pobj_c, DWORD access, bool idConst, char *buffer, int NowLine=-1 );
	CMember( CMember *pobj );
	CMember();
	~CMember();

	bool IsConst();


	static void InitStaticMember(void);
};
class CMethod{
public:
	SUBINFO *psi;
	DWORD dwAccess;
	BOOL bAbstract;
	BOOL bVirtual;
	bool isConst;

	CClass *pobj_InheritsClass;

	CMethod(CMethod *pobj);
	CMethod();
	~CMethod();
};
class CClass{
public:
	//NX
	char *name;

	//pNXւ̃|C^
	CClass *pobj_InheritsClass;

	//o
	CMember **ppobj_Member;
	int iMemberNum;

	//\bh
	CMethod **ppobj_Method;
	int iMethodNum;
	int ConstructorMemberSubIndex;
	int DestructorMemberSubIndex;
	int CopyConstructorMemberSubIndex;

	//ÓIo
	CMember **ppobj_StaticMember;
	int iStaticMemberNum;

	//ÓI\bh
	CMethod **ppobj_StaticMethod;
	int iStaticMethodNum;

	//z֐̐
	int vtbl_num;

	//ACgl
	int iAlign;


public:
	CClass(char *name);
	~CClass();

	//p
	void Inherits( CClass *pInheritsClass );

	void AddMember( DWORD dwAccess, bool idConst, char *buffer );
	void AddStaticMember( DWORD dwAccess, bool isConst, char *buffer, int NowLine );
	void AddMethod( SUBINFO *psi,DWORD dwAccess, bool isConst, BOOL bAbstract, BOOL bVirtual );
	void AddStaticMethod(SUBINFO *psi,DWORD dwAccess);

	BOOL DupliCheckAll(char *name);
	BOOL DupliCheckMember(char *name);

	//\bh擾
	CMethod *GetMethodInfo( SUBINFO *psi );
	CMethod *GetStaticMethodInfo( SUBINFO *psi );

	//\bh݂̑mF
	bool IsExistMethod( char *name );
	bool IsExistStaticMethod( char *name );


	//vtbl
private:
	long vtbl_offset;
	LONG_PTR AddVtblDataTable(SUBINFO **ppsi,int length);
public:
	LONG_PTR GetVtblGlobalOffset(void); 
	void ActionVtblSchedule(LONG_PTR ImageBase, LONG_PTR MemPos_CodeSection);
	bool IsAbstract();


	//Iy[^֐̎擾
	SUBINFO **GetOperatorSubInfo(BYTE idCalc,int &num);


	//RXgN^RpCĂ邩ǂ̃`FbNtO
private:
	bool isCompilingConstructor;
public:
	void NotifyStartConstructorCompile();
	void NotifyFinishConstructorCompile();
	bool IsCompilingConstructor();

	//fXgN^RpCĂ邩ǂ̃`FbNtO
private:
	bool isCompilingDestructor;
public:
	void NotifyStartDestructorCompile();
	void NotifyFinishDestructorCompile();
	bool IsCompilingDestructor();


	//gƓNXǂmF
	bool IsEquals( CClass *pClass );

	//g̔hNXǂmF
	bool IsSubClass( CClass *pClass );


	//`Xgp
	CClass *pobj_NextClass;
};

#define MAX_CLASS_HASH 65535
class CDBClass{
	int hash(char *name);
	void DestroyClass(CClass *pobj_c);
public:
	CClass *pobj_ClassHash[MAX_CLASS_HASH];

	CDBClass();
	~CDBClass();

	CClass *check(char *name);

	CClass *AddClass(char *name,int NowLine);

	void ActionVtblSchedule(LONG_PTR ImageBase, LONG_PTR MemPos_CodeSection);

private:
	void AddMethod(CClass *pobj_c, DWORD dwAccess, BOOL bStatic, bool isConst, BOOL bAbstract,
		BOOL bVirtual, BOOL bOverride, char *buffer, int NowLine);
	BOOL MemberVar_LoopRefCheck(CClass *pobj_c);
public:
	void InitNames(void);
	void GetClass_recur(char *lpszInheritsClass);
	void GetObjectClassInfo(void);


	/////////////////////////////
	// ݃RpC̏
	/////////////////////////////
private:
	CClass *pCompilingClass;
	CMethod *pCompilingMethod;
public:
	//RpCJn̒ʒm󂯎郁\bh
	void StartCompile( SUBINFO *psi );

	//݃RpC̃\bh擾
	CClass *GetNowCompilingClass();
	CMethod *GetNowCompilingMethodInfo();


	/////////////////////
	// Ce[^
	/////////////////////
private:
	CClass **ppobj_IteClass;
	int iIteMaxNum;
	int iIteNextNum;
public:
	void Iterator_Reset(void);
	BOOL Iterator_HasNext(void);
	CClass *Iterator_GetNext(void);
	int Iterator_GetMaxCount(void);
};


extern CDBClass *pobj_DBClass;
extern CClass *pobj_CompilingClass;
