#include "stdafx.h"

#include <jenga/include/smoothie/Smoothie.h>

#include <Compiler.h>
#include <Variable.h>

/*
TODO: 
bool Variable::IsEqualSymbol( const Symbol &symbol, bool isSupportStaticMember ) const
{
	if( GetName() == symbol.GetName()
		&& compiler.GetNamespaceSupporter().IsSameAreaNamespace( this->GetNamespaceScopes(), symbol.GetNamespaceScopes() ) )
	{
		return true;
	}

	if( isSupportStaticMember && symbol.GetNamespaceScopes().size() >= 1 )
	{
		// ÓIol
		NamespaceScopes namespaceScopes( symbol.GetNamespaceScopes() );
		string name = namespaceScopes[namespaceScopes.size()-1] + "." + symbol.GetName();
		namespaceScopes.pop_back();

		return IsEqualSymbol( Symbol( namespaceScopes, name ), false );
	}
	return false;
}*/


bool Variables::DuplicateCheck( const Symbol &symbol ) const
{
	//LVJXR[vlďd
	for( int i=(int)this->size()-1; i>=0 ; i-- ){
		const Variable *pVar = (*this)[i];
		if( pVar->bLiving											//݂̃XR[vŗLȂ
			&& pVar->GetScopeLevel() == compiler.codeGenerator.lexicalScopes.GetNowLevel()	//݂̃XR[vƓꃌx
			)
		{
			if( pVar->IsEqualSymbol( symbol ) ){
				return true;
			}
		}
	}
	return false;
}

const Variable *Variables::BackSearch( const Symbol &symbol ) const
{
	//LVJXR[vlăobNT[`
	for( int i=(int)this->size()-1; i>=0 ; i-- ){
		const Variable *pVar = (*this)[i];
		if( pVar->bLiving											//݂̃XR[vŗLȂ
			&& pVar->GetScopeLevel() <= compiler.codeGenerator.lexicalScopes.GetNowLevel()	//݂̃XR[vx𒴂Ȃ́iReturnɂlj
			){
				if( pVar->IsEqualSymbol( symbol ) ){
					return pVar;
				}
		}
	}
	return NULL;
}

const Variable *Variables::Find( const Symbol &symbol )const
{
	int max = (int)this->size();
	for( int i=0; i<max; i++ ){
		Variable *pVar = (*this)[i];
		if( pVar->IsEqualSymbol( symbol ) ){
			return pVar;
		}
	}
	return NULL;
}

void GlobalVars::Add( Variable *pVar, bool isResetOffsetAddress )
{
	int alignment = 0;
	if( pVar->GetType().IsStruct() ){
		alignment = pVar->GetType().GetClass().GetFixedAlignment();
	}

	if( pVar->HasInitData() ){
		//obt@Ƃ

		if( isResetOffsetAddress )
		{
			if( alignment ){
				if( initAreaBuffer.GetSize() % alignment ){
					initAreaBuffer.Resize( initAreaBuffer.GetSize() + ( alignment - (initAreaBuffer.GetSize() % alignment) ) );
				}
			}

			pVar->SetOffsetAddress( initAreaBuffer.GetSize() );

			initAreaBuffer.Resize( initAreaBuffer.GetSize() + pVar->GetMemorySize() );
		}
	}
	else{
		//obt@ȂƂ

		if( alignment ){
			if( allSize % alignment ){
				allSize += alignment - (allSize % alignment);
			}
		}

		pVar->SetOffsetAddress( allSize | 0x80000000 );
		allSize += pVar->GetMemorySize();
	}

	push_back( pVar );
}
