#include "stdafx.h"

#include <Compiler.h>


// f[^e[uXPW[
void Linker::ResolveDataTableSchedules( long dataSectionBaseOffset )
{
	BOOST_FOREACH( const Schedule &schedule, nativeCode.GetSchedules() )
	{
		if( schedule.GetType() == Schedule::DataTable )
		{
			nativeCode.Overwrite(
				schedule.GetOffset(),
				static_cast<long>( nativeCode.GetLong( schedule.GetOffset() ) + imageBase + dataSectionBaseOffset )
			);
		}
	}
}

// DLL֐XPW[
void Linker::ResolveDllProcSchedules( long codeSectionBaseOffset, long importSectionBaseOffset, long lookupSize, long hintSize )
{
	BOOST_FOREACH( const Schedule &schedule, nativeCode.GetSchedules() )
	{
		if( schedule.GetType() == Schedule::DllProc )
		{
#ifdef _AMD64_
			nativeCode.Overwrite(
				schedule.GetOffset(),
				static_cast<long>( importSectionBaseOffset + schedule.GetDllProc().GetLookupAddress()
					- ( codeSectionBaseOffset + schedule.GetOffset() + sizeof(long) ) )
			);
#else
			nativeCode.Overwrite(
				schedule.GetOffset(),
				static_cast<long>( imageBase + importSectionBaseOffset + lookupSize + hintSize
					+ schedule.GetDllProc().GetLookupAddress() )
			);
#endif
		}
	}
}

// [U`֐XPW[
void Linker::ResolveUserProcSchedules( long codeSectionBaseOffset )
{
	BOOST_FOREACH( const Schedule &schedule, nativeCode.GetSchedules() )
	{
		if( schedule.GetType() == Schedule::UserProc
			|| schedule.GetType() == Schedule::AddressOf )
		{
			if( schedule.GetUserProc().GetBeginOpAddress() == 0
				&& schedule.GetUserProc().GetEndOpAddress() == 0 )
			{
				SetError();
			}

			if( schedule.GetType() == Schedule::UserProc )
			{
				nativeCode.Overwrite(
					schedule.GetOffset(),
					static_cast<long>( schedule.GetUserProc().GetBeginOpAddress() - ( schedule.GetOffset() + sizeof(long) ) )
				);
			}
			else if( schedule.GetType() == Schedule::AddressOf )
			{
				nativeCode.Overwrite(
					schedule.GetOffset(),
					static_cast<long>( schedule.GetUserProc().GetBeginOpAddress() + imageBase + codeSectionBaseOffset )
				);
			}
		}
	}
}

// O[oϐXPW[
void Linker::ResolveGlobalVarSchedules( long rwSectionBaseOffset )
{
	int allInitVarSize = compiler.GetObjectModule().meta.GetGlobalVars().GetAllInitSize();

	BOOST_FOREACH( const Schedule &schedule, nativeCode.GetSchedules() )
	{
		if( schedule.GetType() == Schedule::GlobalVar )
		{
			if( nativeCode.GetLong( schedule.GetOffset() ) & 0x80000000 )
			{
				nativeCode.Overwrite(
					schedule.GetOffset(),
					static_cast<long>( allInitVarSize + (nativeCode.GetLong( schedule.GetOffset() ) & 0x7FFFFFFF) + imageBase + rwSectionBaseOffset )
				);
			}
			else
			{
				nativeCode.Overwrite(
					schedule.GetOffset(),
					static_cast<long>( nativeCode.GetLong( schedule.GetOffset() ) + imageBase + rwSectionBaseOffset )
				);
			}
		}
	}
}

void Linker::ResolveVtblSchedule( long dataSectionBaseOffset )
{
	BOOST_FOREACH( const Schedule &schedule, nativeCode.GetSchedules() )
	{
		if( schedule.GetType() == Schedule::Vtbl )
		{
			LONG_PTR vtblAddress = schedule.GetClass().GetVtblGlobalOffset();

			nativeCode.Overwrite(
				schedule.GetOffset(),
				static_cast<long>( vtblAddress + imageBase + dataSectionBaseOffset )
			);
		}
	}
}

void Linker::Link( ObjectModule &masterObjectModule )
{
	// nativeCode͏ԂłȂ΂ȂȂ
	if( nativeCode.GetSize() > 0 )
	{
		SetError();
	}

	nativeCode.Put( masterObjectModule.globalNativeCode );

	masterObjectModule.meta.GetUserProcs().Iterator_Reset();
	while( masterObjectModule.meta.GetUserProcs().Iterator_HasNext() )
	{
		const UserProc *pUserProc = masterObjectModule.meta.GetUserProcs().Iterator_GetNext();

		if( pUserProc->GetNativeCode().GetSize() > 0 )
		{
			pUserProc->SetBeginOpAddress( nativeCode.GetSize() );

			nativeCode.Put( pUserProc->GetNativeCode() );

			pUserProc->SetEndOpAddress( nativeCode.GetSize() );
		}
	}
}
