#include "stdafx.h"

#include <Compiler.h>

#define BREAK_EIP(checkEip)  (obp+0x00401000>=checkEip)

void NativeCode::Put( const NativeCode &nativeCode )
{
	long baseOffset = size;

	// R[hobt@ǉ
	Put( nativeCode.codeBuffer, nativeCode.size );

	// XPW[ǉ
	BOOST_FOREACH( const Schedule &schedule, nativeCode.schedules )
	{
		this->schedules.push_back(
			Schedule(
				schedule.GetType(),
				baseOffset + schedule.GetOffset(),
				schedule.GetLongPtrValue()
			)
		);
	}

	// \[XR[hsԍƃlCeBuR[hʒȗΉǉ
	BOOST_FOREACH( const SourceLine &sourceLine, nativeCode.sourceLines )
	{
		this->sourceLines.push_back(
			SourceLine(
				sourceLine.GetLineNum(),
				baseOffset + sourceLine.GetNativeCodePos(),
				sourceLine.GetSourceIndex(),
				sourceLine.GetSourceCodePos(),
				sourceLine.GetCodeType()
			)
		);
	}
}

void NativeCode::PutUserProcSchedule( const UserProc *pUserProc, bool isCall )
{
	pUserProc->Using();

	Schedule schedule( pUserProc, size );
	if( isCall == false )
	{
		schedule.SpecifyAddressOf();
	}
	schedules.push_back( schedule );

	*((long *)(codeBuffer+size))=0;
	size += sizeof(long);
}

void NativeCode::PutDllProcSchedule( const DllProc *pDllProc )
{
	pDllProc->Using();

	schedules.push_back( Schedule( pDllProc, size ) );

	*((long *)(codeBuffer+size))=0;
	size += sizeof(long);
}

void NativeCode::NextSourceLine()
{
	if( sourceLines.size() )
	{
		if( sourceLines.back().GetNativeCodePos() == size )
		{
			sourceLines.back().SetSourceCodePos( cp );
			return;
		}
	}

	extern BOOL bDebugSupportProc;
	extern BOOL bSystemProc;
	DWORD sourceLineType = 0;
	if( bDebugSupportProc )
	{
		sourceLineType |= CODETYPE_DEBUGPROC;
	}
	if( bSystemProc )
	{
		sourceLineType |= CODETYPE_SYSTEMPROC;
	}
	sourceLines.push_back(
		SourceLine(
			(long)sourceLines.size(),
			size,
			compiler.GetObjectModule().GetCurrentSourceIndex(),
			cp,
			sourceLineType
		)
	);
}

void NativeCode::ResetDataSectionBaseOffset( long dataSectionBaseOffset )
{
	BOOST_FOREACH( const Schedule &schedule, schedules )
	{
		if( schedule.GetType() == Schedule::DataTable )
		{
			Overwrite(
				schedule.GetOffset(),
				GetLong( schedule.GetOffset() ) + dataSectionBaseOffset
			);
		}
	}
}
void NativeCode::ResetSourceIndexes( long sourceIndexBase )
{
	BOOST_FOREACH( SourceLine &sourceLine, sourceLines )
	{
		sourceLine.SetSourceIndex( sourceLine.GetSourceIndex() + sourceIndexBase );
	}
}
