#include "../BasicCompiler_Common/common.h"
#include "opcode.h"

CParameter::CParameter(char *buffer){
	///////////////////////////
	// p[^𐮗
	///////////////////////////

	extern HANDLE hHeap;
	int i,i2,i3;
	char temporary[VN_SIZE];

	i=0;
	ParmsNum=0;
	while(1){
		if(buffer[i]=='\0') break;

		for(i2=0;;i2++,i++){
			if(buffer[i]=='\"'){
				temporary[i2]=buffer[i];
				for(i++,i2++;;i++,i2++){
					temporary[i2]=buffer[i];
					if(buffer[i]=='\"') break;
				}
				continue;
			}

			if(buffer[i]=='('){
				i3=GetStringInPare(temporary+i2,buffer+i);
				i2+=i3-1;
				i+=i3-1;
				continue;
			}
			if(buffer[i]=='['){
				i3=GetStringInBracket(temporary+i2,buffer+i);
				i2+=i3-1;
				i+=i3-1;
				continue;
			}

			if(buffer[i]==','||buffer[i]=='\0'){
				temporary[i2]=0;
				break;
			}
			temporary[i2]=buffer[i];
		}

		Parms[ParmsNum]=(char *)HeapAlloc(hHeap,0,lstrlen(temporary)+1);
		lstrcpy(Parms[ParmsNum],temporary);
		ParmsNum++;

		if(buffer[i]==',') i++;
	}

	ReturnTypeInfo.type=0;
	ReturnTypeInfo.u.lpIndex=0;
}
CParameter::CParameter(PARAMETER_INFO *pParamInfo,int ParmNum){
	int i;
	for(i=0;i<ParmNum;i++){
		Parms[i]=0;
		types[i].type=pParamInfo[i].type;
		types[i].u.lpIndex=pParamInfo[i].u.index;
	}
	this->ParmsNum=ParmNum;

	ReturnTypeInfo.type=0;
	ReturnTypeInfo.u.lpIndex=0;
}
CParameter::~CParameter(){
	int i2;

	//p[^
	for(i2=0;i2<ParmsNum;i2++){
		if(Parms[i2]==(char *)-1) continue;

		if(Parms[i2]) HeapDefaultFree(Parms[i2]);
	}
}


void CParameter::SetReturnType(TYPEINFO *pTypeInfo){
	ReturnTypeInfo=*pTypeInfo;
}

BOOL CParameter::_overload_check(PARAMETER_INFO *ppi,int pi_num,TYPEINFO *pReturnTypeInfo,int overload_level){
	//p[^ʂăI[o[[h

	//p[^̌sv̏ꍇ
	if(pi_num!=ParmsNum) return 0;

	int i,type;
	LONG_PTR lpIndex;
	for(i=0;i<pi_num;i++){
		if(Parms[i]){
			TYPEINFO BaseType={ppi[i].type,ppi[i].u.index};
			if(Parms[i][0]==1&&Parms[i][1]==ESC_BYVAL){
				type=NumOpe_GetType(Parms[i]+2,&BaseType,&lpIndex);
				type=MAKE_PTR_TYPE(NATURAL_TYPE(type),PTR_LEVEL(type)-1);
			}
			else{
				type=NumOpe_GetType(Parms[i],&BaseType,&lpIndex);
			}
		}
		else{
			type=types[i].type;
			lpIndex=types[i].u.lpIndex;
		}

		if(type!=ppi[i].type){
			if(overload_level==OVERLOAD_LEVEL1){
				return 0;
			}
			else if(overload_level==OVERLOAD_LEVEL2){
				if(!(
					IsWholeNumberType(type)&&IsWholeNumberType(ppi[i].type)||
					IsRealNumberType(type)&&IsRealNumberType(ppi[i].type)
					)) return 0;
			}
			else if(overload_level==OVERLOAD_LEVEL3){
				if(type==DEF_OBJECT||ppi[i].type==DEF_OBJECT) return 0;
			}
		}
		else{
			if(NATURAL_TYPE(type)==DEF_OBJECT){
				if(lpIndex!=ppi[i].u.index) return 0;
			}
		}
	}

	if(pReturnTypeInfo){
		//߂lrΏۂɂ
		if(ReturnTypeInfo.type==pReturnTypeInfo->type){
			if(NATURAL_TYPE(ReturnTypeInfo.type)==DEF_OBJECT){
				if(ReturnTypeInfo.u.lpIndex != pReturnTypeInfo->u.lpIndex) return 0;
			}
		}
		else return 0;
	}

	return 1;
}
SUBINFO *CParameter::OverloadSolutionWithReturnType(char *name,SUBINFO **ppsi,int num){
	int i,sw=0;
	SUBINFO *psi;
	psi=0;
	for(i=0;i<num;i++){
		psi=ppsi[i];

		TYPEINFO ReturnTypeInfo;
		ReturnTypeInfo.type=psi->ReturnType;
		ReturnTypeInfo.u.lpIndex=psi->u.ReturnIndex;

		//G[`FbN
		if(_overload_check(psi->pParmInfo,psi->ParmNum,&ReturnTypeInfo,OVERLOAD_LEVEL1)){
			if(sw){
				SetError(52,name,cp);
				return 0;
			}
			sw=1;
			break;
		}
	}

	if(!sw){
		for(i=0;i<num;i++){
			psi=ppsi[i];

			TYPEINFO ReturnTypeInfo;
			ReturnTypeInfo.type=psi->ReturnType;
			ReturnTypeInfo.u.lpIndex=psi->u.ReturnIndex;

			//G[`FbN
			if(_overload_check(psi->pParmInfo,psi->ParmNum,&ReturnTypeInfo,OVERLOAD_LEVEL2)){
				if(sw){
					SetError(52,name,cp);
					return 0;
				}
				sw=1;
				break;
			}
		}
	}

	if(!sw){
		for(i=0;i<num;i++){
			psi=ppsi[i];

			TYPEINFO ReturnTypeInfo;
			ReturnTypeInfo.type=psi->ReturnType;
			ReturnTypeInfo.u.lpIndex=psi->u.ReturnIndex;

			//G[`FbN
			if(_overload_check(psi->pParmInfo,psi->ParmNum,&ReturnTypeInfo,OVERLOAD_LEVEL3)){
				if(sw){
					SetError(52,name,cp);
					return 0;
				}
				sw=1;
				break;
			}
		}
	}

	if(!sw){
		SetError(52,name,cp);
		return 0;
	}

	return psi;
}

SUBINFO *CParameter::OverloadSolution(char *name,SUBINFO **ppsi,int num){
	int i,sw=0;
	SUBINFO *psi;
	psi=0;
	if(lstrcmp(name,"Abs")==0){
		MessageBeep(0);
	}
	for(i=0;i<num;i++){
		psi=ppsi[i];

		//G[`FbN
		if(_overload_check(psi->pParmInfo,psi->ParmNum,NULL,OVERLOAD_LEVEL1)){
			if(sw){
				return OverloadSolutionWithReturnType(name,ppsi,num);
			}
			sw=1;
			break;
		}
	}

	if(!sw){
		for(i=0;i<num;i++){
			psi=ppsi[i];

			//G[`FbN
			if(_overload_check(psi->pParmInfo,psi->ParmNum,NULL,OVERLOAD_LEVEL2)){
				if(sw){
					return OverloadSolutionWithReturnType(name,ppsi,num);
				}
				sw=1;
				break;
			}
		}
	}

	if(!sw){
		for(i=0;i<num;i++){
			psi=ppsi[i];

			//G[`FbN
			if(_overload_check(psi->pParmInfo,psi->ParmNum,NULL,OVERLOAD_LEVEL3)){
				if(sw){
					return OverloadSolutionWithReturnType(name,ppsi,num);
				}
				sw=1;
				break;
			}
		}
	}

	if(!sw){
		SUBINFO *temp_psi;
		for(i=0;i<num;i++){
			temp_psi=ppsi[i];

			//G[`FbN
			if(temp_psi->ParmNum==this->ParmsNum){
				if(sw){
					sw=0;
					break;
				}
				sw=1;

				psi=temp_psi;
			}
		}
	}

	if(!sw){
		SetError(52,name,cp);
		return 0;
	}

	return psi;
}

BOOL CParameter::ErrorCheck(char *FuncName,PARAMETER_INFO *ppi,int pi_num,int SecondParmNum){
	if(ParmsNum>pi_num){
		if(ppi[pi_num-1].type!=DEF_ELLIPSE){
			//p[^Ƃ
			SetError(10,FuncName,cp);
			return 0;
		}
	}
	else if(ParmsNum<pi_num){
		if(ParmsNum<SecondParmNum){
			if(ppi[ParmsNum].type==DEF_ELLIPSE){
				return 1;
			}

			//p[^ȂƂ
			SetError(10,FuncName,cp);
			return 0;
		}

		//ȗp[^ "0" w肷
		for(;ParmsNum < pi_num;ParmsNum++){
			extern HANDLE hHeap;
			char temporary[64];
			if(ppi[ParmsNum].bByVal) lstrcpy(temporary,"0");
			else sprintf(temporary,"%c%c0",1,ESC_BYVAL);
			Parms[ParmsNum]=(char *)HeapAlloc(hHeap,0,lstrlen(temporary)+1);
			lstrcpy(Parms[ParmsNum],temporary);
		}
	}

	return 1;
}
void CParameter::MacroParameterSupport(PARAMETER_INFO *ppi){
	int i;
	for(i=0;i<ParmsNum;i++){
		if(Parms[i][0]=='\0'){
			extern HANDLE hHeap;
			char temporary[64];
			if(ppi[i].bByVal) lstrcpy(temporary,"0");
			else sprintf(temporary,"%c%c0",1,ESC_BYVAL);
			HeapDefaultFree(Parms[i]);
			Parms[i]=(char *)HeapAlloc(hHeap,0,lstrlen(temporary)+1);
			lstrcpy(Parms[i],temporary);
		}
	}
}

void CParameter::NewTempParameters( char *FuncName,PARAMETER_INFO *ppi,int pi_num,int SecondParmNum ){
	///////////////////////////////////////////////////////
	// ꎞIuWFNg炩߃X^bNɐςł
	///////////////////////////////////////////////////////
	//TODO: 64rbgR[ĥ܂܂Ȃ̂ŁA32rbgpɏ

	useTempObject = false;

	//ꎞIuWFNg̐
	nCountOfTempObjects = 0;

	BOOL bEllipse;
	if(pi_num){
		if(ppi[pi_num-1].type==DEF_ELLIPSE) bEllipse=1;
		else bEllipse=0;
	}
	else bEllipse=0;

	for(int i2=ParmsNum-1;i2>=0;i2--){
		useTempParameters[i2] = false;

		if(bEllipse&&i2<=pi_num-2) bEllipse=0;

		if(i2==0&&ppi[i2].name){
			if(lstrcmp(ppi[i2].name,"_System_LocalThis")==0){
				//IuWFNgȏp[^This|C^
				continue;
			}
		}
		if((i2==0||i2==1)&&ppi[i2].name){
			if(lstrcmp(ppi[i2].name,FuncName)==0){
				//IuWFNgȏ܂͑p[^̖߂lpIuWFNg
				continue;
			}
		}

		TYPEINFO DummyTypeInfo;
		BOOL bByVal;
		if(bEllipse){
			DummyTypeInfo.type=NumOpe_GetType(Parms[i2],NULL,&DummyTypeInfo.u.lpIndex);
			bByVal=1;
		}
		else{
			DummyTypeInfo.type=ppi[i2].type;
			DummyTypeInfo.u.lpIndex=ppi[i2].u.index;
			bByVal=ppi[i2].bByVal;
		}


		if( !bByVal ){
			//|C^Q
			if(Parms[i2][0]==1&&Parms[i2][1]==ESC_BYVAL){
				//|C^w
				continue;
			}

			LONG_PTR lpVarIndex;
			if( GetVarType( Parms[i2], &lpVarIndex, FALSE ) == -1 ){
				//ϐł͂ȂƂ
				int reg = REG_RAX;
				int type = NumOpe( Parms[i2], DummyTypeInfo.type, DummyTypeInfo.u.lpIndex, &lpVarIndex );
				//ŃX^bNɐς

				useTempParameters[i2] = true;
				useTempObject = true;

				types[i2].type = type;
				types[i2].u.lpIndex = lpVarIndex;

				nCountOfTempObjects++;
			}
		}
	}
}
void CParameter::DeleteTempParameters(){
	///////////////////////////////////////////////////////
	// ꎞIuWFNgj
	///////////////////////////////////////////////////////
	//TODO: 64rbgR[ĥ܂܂Ȃ̂ŁA32rbgpɏ

	if( !useTempObject ) return;

	for(int i2=ParmsNum-1;i2>=0;i2--){
		if( useTempParameters[i2] ){
			//X^bNt[擾
			// ֐ĂяolՂebx𗘗p
			op_pop(REG_EBX);


			///////////////////////////
			// fXgN^Ăяo
			///////////////////////////

			//push ebx
			op_push(REG_EBX);

			//call destructor
			int i5 = types[i2].u.pobj_Class->DestructorMemberSubIndex;
			op_call( types[i2].u.pobj_Class->ppobj_Method[i5]->psi );


			/////////////////////////
			// 
			/////////////////////////

			//push ebx
			op_push(REG_EBX);

			//call free
			extern SUBINFO *pSub_free;
			op_call(pSub_free);
		}
	}
}

void CParameter::SetObjectParameter(CClass *pobj_Class,LPSTR Parameter){
	int object_size;
	object_size=GetSizeOfClass(pobj_Class);

	//push object_size
	op_push_value(object_size);

	//call calloc
	extern SUBINFO *pSub_calloc;
	op_call(pSub_calloc);

	//push eax
	op_push(REG_EAX);


	TYPEINFO BaseType={DEF_OBJECT,(LONG_PTR)pobj_Class};
	TYPEINFO CalcType;
	CalcType.type=NumOpe_GetType(Parameter,&BaseType,&CalcType.u.lpIndex);

	if(pobj_Class->CopyConstructorMemberSubIndex!=-1&&
		CalcType.type==DEF_OBJECT&&CalcType.u.pobj_Class==pobj_Class){
		////////////////////////////////////
		// Rs[RXgN^Ăяo
		////////////////////////////////////

		//push eax
		op_push(REG_EAX);

		BOOL bUseHeap;
		CalcType.type=NumOpe(Parameter,DEF_OBJECT,(LONG_PTR)pobj_Class,&CalcType.u.lpIndex,&bUseHeap);

		//pop ecx
		op_pop(REG_ECX);

		//pop eax
		op_pop(REG_EAX);

		if(bUseHeap){
			//pɑޔ
			//mov esi,ecx
			op_mov_RR(REG_ESI,REG_ECX);
		}

		//push ecx
		op_push(REG_ECX);

		//push eax
		op_push(REG_EAX);

		//call constructor
		op_call(pobj_Class->ppobj_Method[pobj_Class->CopyConstructorMemberSubIndex]->psi);


		if(bUseHeap){
			FreeTempObject(REG_ESI,pobj_Class);
		}
	}
	else{
		//push eax
		op_push(REG_EAX);


			if(pobj_Class->ConstructorMemberSubIndex!=-1){
				////////////////////////////////
				// RXgN^Ăяo
				////////////////////////////////

				//push this
				op_push(REG_EAX);

				//call constructor
				op_call(pobj_Class->ppobj_Method[pobj_Class->ConstructorMemberSubIndex]->psi);
			}


			TYPEINFO CalcType;
			BOOL bUseHeap;
			CalcType.type=NumOpe(Parameter,DEF_OBJECT,(LONG_PTR)pobj_Class,&CalcType.u.lpIndex,&bUseHeap);



		SetObjectVariable((LONG_PTR)pobj_Class,CalcType.type,CalcType.u.lpIndex,bUseHeap);
	}
}

int CParameter::SetParameter(char *FuncName,PARAMETER_INFO *ppi,int pi_num,int SecondParmNum){
	///////////////////////////////////////////////////////////
	// p[^WX^yуX^bNt[ɃZbg
	///////////////////////////////////////////////////////////
	int i2,i3;

	BOOL bEllipse;
	if(pi_num){
		if(ppi[pi_num-1].type==DEF_ELLIPSE) bEllipse=1;
		else bEllipse=0;
	}
	else bEllipse=0;

	BOOL bHas_System_LocalThis=0;
	if(ParmsNum>=1){
		if(lstrcmp(ppi[0].name,"_System_LocalThis")==0)
			bHas_System_LocalThis=1;
	}

	//߂lp̕ϐ擾
	char *lpszVarNameToReturn;
	if(FuncName[0]==1&&FuncName[1]==ESC_OPERATOR) lpszVarNameToReturn="_System_ReturnValue";
	else lpszVarNameToReturn=FuncName;

	//p[^WX^ƃX^bNɊi[
	int CalcType;
	LONG_PTR lpCalcIndex;
	BOOL bCalcUseHeap;
	int ParmSize=0;
	RELATIVE_VAR RelativeVar;
	int nCountOfNowTempObjects = 0;
	for(i2=ParmsNum-1;i2>=0;i2--){
		if(bEllipse&&i2<=pi_num-2) bEllipse=0;

		if(i2==0&&ppi[i2].name){
			if(lstrcmp(ppi[i2].name,"_System_LocalThis")==0){
				//IuWFNgȏp[^This|C^
				continue;
			}
		}
		if((i2==0||i2==1)&&ppi[i2].name){
			if(lstrcmp(ppi[i2].name,lpszVarNameToReturn)==0){
				//IuWFNgȏ܂͑p[^̖߂lpIuWFNg
				continue;
			}
		}

		TYPEINFO DummyTypeInfo;
		BOOL bByVal;
		if(bEllipse){
			DummyTypeInfo.type=NumOpe_GetType(Parms[i2],NULL,&DummyTypeInfo.u.lpIndex);
			bByVal=1;
		}
		else{
			DummyTypeInfo.type=ppi[i2].type;
			DummyTypeInfo.u.lpIndex=ppi[i2].u.index;
			bByVal=ppi[i2].bByVal;
		}

		if(bByVal==1){
			//lQ

			if(Parms[i2][0]==1&&Parms[i2][1]==ESC_BYVAL){
				char temp2[255];
				sprintf(temp2,"%s֐̑%dp[^",FuncName,i2+1);
				SetError(19,temp2,cp);
				continue;
			}

			if(DummyTypeInfo.type==DEF_OBJECT){
				SetObjectParameter(DummyTypeInfo.u.pobj_Class,Parms[i2]);
				goto next;
			}


			extern LONG_PTR ProcPtr_BaseIndex;
			LONG_PTR back_ProcPtr_BaseIndex;
			back_ProcPtr_BaseIndex=ProcPtr_BaseIndex;
			if(DummyTypeInfo.type==DEF_PTR_PROC) ProcPtr_BaseIndex=DummyTypeInfo.u.lpIndex;
			else ProcPtr_BaseIndex=-1;

			CalcType=NumOpe(Parms[i2],DummyTypeInfo.type,DummyTypeInfo.u.lpIndex,&lpCalcIndex,&bCalcUseHeap);

			ProcPtr_BaseIndex=back_ProcPtr_BaseIndex;

			if(CalcType==-1) break;

			if(CalcType==DEF_OBJECT){
				//LXgZq̃I[o[[hɑΉ
				CallCastOperatorProc(CalcType,lpCalcIndex,bCalcUseHeap,DummyTypeInfo.type,DummyTypeInfo.u.lpIndex);
			}

			if(!bEllipse){
				//^`FbN
				if(bHas_System_LocalThis) i3=i2-1;
				else i3=i2;
				CheckDifferentType(
					DummyTypeInfo.type,
					DummyTypeInfo.u.lpIndex,
					CalcType,
					lpCalcIndex,
					FuncName,
					i3);
			}

			if(DummyTypeInfo.type==DEF_DOUBLE){
				ChangeTypeToDouble(CalcType);
				ParmSize+=sizeof(long)*2;
			}
			else if(DummyTypeInfo.type==DEF_SINGLE){
				ChangeTypeToSingle(CalcType);
				ParmSize+=sizeof(long);
			}
			else if(DummyTypeInfo.type==DEF_INT64||DummyTypeInfo.type==DEF_QWORD){
				ChangeTypeToInt64(CalcType);
				ParmSize+=sizeof(long)*2;
			}
			else if(DummyTypeInfo.type==DEF_LONG||DummyTypeInfo.type==DEF_DWORD||
				(IsPtrType(DummyTypeInfo.type)/*&&DummyTypeInfo.type!=DEF_PTR_VOID&&DummyTypeInfo.type!=DEF_PTR_BYTE*/)){
				ChangeTypeToLong(CalcType);
				ParmSize+=sizeof(long);
			}
			else if(DummyTypeInfo.type==DEF_INTEGER||DummyTypeInfo.type==DEF_WORD){
				ChangeTypeToInteger(CalcType);
				ParmSize+=sizeof(long);
			}
			else if(DummyTypeInfo.type==DEF_CHAR||DummyTypeInfo.type==DEF_BYTE){
				ChangeTypeToByte(CalcType);
				ParmSize+=sizeof(long);
			}
			else{
				SetError(300,NULL,cp);
			}
		}
		else{
			//|C^Q
			if(Parms[i2][0]==1&&Parms[i2][1]==ESC_BYVAL){
				//|C^w
				i3=NumOpe(Parms[i2]+2,0,0,0);

				ChangeTypeToLong(i3);
			}
			else{
				//ϐ̃AhX擾
				int VarType;
				LONG_PTR lpVarIndex;
				if(GetVarOffset(
					false,
					false,
					Parms[i2],
					&VarType,
					&RelativeVar,
					&lpVarIndex)){
						if(DummyTypeInfo.type!=DEF_ANY){
							//^`FbNs
							if(DummyTypeInfo.type==VarType){
								if(DummyTypeInfo.type==DEF_OBJECT){
									if(DummyTypeInfo.u.lpIndex!=lpVarIndex){
										SetError(11,Parms[i2],cp);
									}
								}
							}
							else if((VarType&FLAG_PTR)&&((int)(VarType^FLAG_PTR)==DummyTypeInfo.type)){
								//|C^QƂŁAz̐擪|C^̂Ƃ
							}
							else{
								SetError(11,Parms[i2],cp);
							}
						}

						//ϐAhXWX^ɃZbg
						SetVarPtrToEax(&RelativeVar);

						//push eax
						op_push(REG_EAX);
				}
				else{
					//ꎞIuWFNgRs[

					//mov eax, dword ptr[esp+offset]
					op_mov_RM(
						sizeof(long),
						REG_EAX,
						REG_ESP,
						( ( ParmsNum - i2 - 1 ) + ( nCountOfTempObjects - nCountOfNowTempObjects - 1 ) ) * PTR_SIZE,
						MOD_BASE_DISP32 );

					nCountOfNowTempObjects++;

					//push eax
					op_push(REG_EAX);

					//VarType = NumOpe( Parms[i2], DummyTypeInfo.type, DummyTypeInfo.u.lpIndex, &lpVarIndex );
				}
			}

			ParmSize+=PTR_SIZE;
		}

next:;
	}

	return ParmSize;
}
