#pragma once

class ObjectModule : public Jenga::Common::BoostSerializationSupport<ObjectModule>
{
public:
	// ^
	Meta meta;

	// O[ö̃lCeBuR[h
	NativeCode globalNativeCode;

	// f[^e[u
	DataTable dataTable;

	// \[XR[h
	BasicSource source;

	// XMLVACYp
private:
	virtual const char *RootTagName() const
	{
		return "objectModule";
	}
	friend class boost::serialization::access;
	template<class Archive> void serialize(Archive& ar, const unsigned int version)
	{
		trace_for_serialize( "serializing - objectModule" );

		ar & BOOST_SERIALIZATION_NVP( meta );
		ar & BOOST_SERIALIZATION_NVP( globalNativeCode );
		ar & BOOST_SERIALIZATION_NVP( dataTable );
		ar & BOOST_SERIALIZATION_NVP( source );
	}

public:
	void StaticLink( ObjectModule &objectModule );

	bool Read( const std::string &filePath );
	bool Write( const std::string &filePath ) const;
	bool ReadString( const std::string &str );
	bool WriteString( std::string &str ) const;
};
typedef std::vector<ObjectModule *> ObjectModules;
