#include "stdafx.h"

#include <Compiler.h>

enum ObjectModuleDataType
{
	ObjectModuleDataTypeXml,
	ObjectModuleDataTypeText,
	ObjectModuleDataTypeBinaly,
};
const ObjectModuleDataType objectModuleDataType = ObjectModuleDataTypeText;


void ObjectModule::StaticLink( ObjectModule &objectModule )
{
	// ^
	meta.StaticLink( objectModule.meta, dataTable.GetSize() );

	// lCeBuR[h
	globalNativeCode.Put( objectModule.globalNativeCode );
	globalNativeCode.ResetDataSectionBaseOffset( dataTable.GetSize() );

	// f[^e[u
	dataTable.Add( objectModule.dataTable );
}

bool ObjectModule::Read( const std::string &filePath )
{
	switch( objectModuleDataType )
	{
	case ObjectModuleDataTypeXml:
		return ReadXml( filePath );
	case ObjectModuleDataTypeText:
		return ReadText( filePath );
	case ObjectModuleDataTypeBinaly:
		return ReadBinary( filePath );
	default:
		Jenga::Throw( "" );
		break;
	}
	return false;
}
bool ObjectModule::Write( const std::string &filePath ) const
{
	switch( objectModuleDataType )
	{
	case ObjectModuleDataTypeXml:
		return WriteXml( filePath );
	case ObjectModuleDataTypeText:
		return WriteText( filePath );
	case ObjectModuleDataTypeBinaly:
		return WriteBinary( filePath );
	default:
		Jenga::Throw( "" );
		break;
	}
	return false;
}
bool ObjectModule::ReadString( const std::string &str )
{
	switch( objectModuleDataType )
	{
	case ObjectModuleDataTypeXml:
		return ReadXmlString( str );
	case ObjectModuleDataTypeText:
		return ReadTextString( str );
	case ObjectModuleDataTypeBinaly:
		Jenga::Throw( "" );
		break;
	default:
		Jenga::Throw( "" );
		break;
	}
	return false;
}
bool ObjectModule::WriteString( std::string &str ) const
{
	switch( objectModuleDataType )
	{
	case ObjectModuleDataTypeXml:
		return WriteXmlString( str );
	case ObjectModuleDataTypeText:
		return WriteTextString( str );
	case ObjectModuleDataTypeBinaly:
		Jenga::Throw( "" );
		break;
	default:
		Jenga::Throw( "" );
		break;
	}
	return false;
}
