#pragma once

#include <vector>
#include <string>
#include <fstream>
#include <sstream>

#include <boost/serialization/serialization.hpp>
#include <boost/serialization/nvp.hpp>
#include <boost/serialization/export.hpp>

namespace Jenga{
namespace Common{

using namespace std;

template<class T_xml_schema> class BoostSerializationSupport{
	virtual const char *RootTagName() const = 0;

	void echo( const char *msg ) const;

public:
	bool ReadXml( istream& ifs, bool isShowExceptionMessage = true );
	bool WriteXml( ostream& ofs, bool isShowExceptionMessage = true ) const;
	bool ReadXml( const std::string &xmlFilePath, bool isShowExceptionMessage = true );
	bool WriteXml( const std::string &xmlFilePath, bool isShowExceptionMessage = true ) const;
	bool ReadXmlString( const std::string &xmlString );
	bool WriteXmlString( std::string &xmlString ) const;

	bool ReadBinary( const std::string &filePath, bool isShowExceptionMessage = true );
	bool WriteBinary( const std::string &filePath, bool isShowExceptionMessage = true ) const;

	bool ReadText( const std::string &filePath, bool isShowExceptionMessage = true );
	bool WriteText( const std::string &filePath, bool isShowExceptionMessage = true ) const;
	bool ReadTextString( const std::string &textString );
	bool WriteTextString( std::string &textString ) const;

	bool ReadXmlFromString( const std::string &xmlBuffer );
};


}}
