#pragma once

#include <option.h>
#include <Program.h>
#include <Symbol.h>
#include <Type.h>

class Variable : public Symbol
{
	Type type;
	bool isConst;
	bool isRef;
	bool isArray;
	Subscripts subscripts;

	bool isParameter;

	//RXgN^pp[^
	std::string paramStrForConstructor;


	/* --- ItZbg ---
		O[oϐŏobt@Ȃꍇ͍ŏʃrbg1ZbgA
		obt@̗LʂB
		ǐAXPW[sɂAۂ̔zuɕёւj*/
	int offset;


	//LVJXR[vp
	int scopeStartAddress;
	int scopeEndAddress;
	int scopeLevel;


	// XMLVACYp
private:
	friend class boost::serialization::access;
	template<class Archive> void serialize(Archive& ar, const unsigned int version)
	{
		trace_for_serialize( "serializing - Variable" );

		ar & BOOST_SERIALIZATION_BASE_OBJECT_NVP( Symbol );
		ar & BOOST_SERIALIZATION_NVP( type );
		ar & BOOST_SERIALIZATION_NVP( isConst );
		ar & BOOST_SERIALIZATION_NVP( isRef );
		ar & BOOST_SERIALIZATION_NVP( isArray );
		ar & BOOST_SERIALIZATION_NVP( subscripts );
		ar & BOOST_SERIALIZATION_NVP( isParameter );
		ar & BOOST_SERIALIZATION_NVP( paramStrForConstructor );
		ar & BOOST_SERIALIZATION_NVP( offset );
		ar & BOOST_SERIALIZATION_NVP( scopeStartAddress );
		ar & BOOST_SERIALIZATION_NVP( scopeEndAddress );
		ar & BOOST_SERIALIZATION_NVP( scopeLevel );
	}

public:
	Variable( const string &name, const Type &type, bool isConst, bool isRef, const std::string &paramStrForConstructor )
		: Symbol( name )
		, type( type )
		, isConst( isConst )
		, isRef( isRef )
		, isArray( false )
		, isParameter( false)
		, paramStrForConstructor( paramStrForConstructor )
	{
	}
	Variable( const NamespaceScopes &namespaceScopes, const string &name, const Type &type, bool isConst, bool isRef, const std::string &paramStrForConstructor )
		: Symbol( namespaceScopes, name )
		, type( type )
		, isConst( isConst )
		, isRef( isRef )
		, isArray( false )
		, isParameter( false)
		, paramStrForConstructor( paramStrForConstructor )
	{
	}
	Variable( const Variable &var )
		: Symbol( var )
		, type( var.type )
		, isConst( var.isConst )
		, isRef( var.isRef )
		, isArray( var.isArray )
		, subscripts( var.subscripts )
		, isParameter( false )
		, paramStrForConstructor( var.paramStrForConstructor )
	{
	}
	Variable()
	{
	}
	~Variable()
	{
	}

	void SetArray( const Subscripts &subscripts ){
		isArray = true;
		this->subscripts = subscripts;
	}

	const Type &GetType() const
	{
		return type;
	}
	void ConstOff(){
		isConst = false;
	}
	void ConstOn(){
		isConst = true;
	}
	bool IsConst() const
	{
		return isConst;
	}
	bool IsRef() const
	{
		return isRef;
	}
	bool IsArray()const
	{
		return isArray;
	}
	const Subscripts &GetSubscripts() const
	{
		return subscripts;
	}

	void ThisIsParameter(){
		isParameter = true;
	}
	bool IsParameter() const
	{
		return isParameter;
	}


	int GetMemorySize() const
	{
		if( isRef || isParameter ){
			return PTR_SIZE;
		}

		int size = type.GetSize();

		if( isArray ){
			int num = 1;
			for( int i=0; i<(int)subscripts.size(); i++){
				num *= subscripts[i]+1;
			}
			size *= num;
		}

		if( size % PTR_SIZE ){
			size += PTR_SIZE-(size%PTR_SIZE);
		}

		return size;
	}

	int GetOffsetAddress() const
	{
		return offset;
	}
	void SetOffsetAddress( int offset )
	{
		this->offset = offset;
	}

	const std::string &GetParamStrForConstructor() const
	{
		return paramStrForConstructor;
	}

	//LVJXR[vp
	int GetScopeStartAddress() const
	{
		return scopeStartAddress;
	}
	void SetScopeStartAddress( int scopeStartAddress )
	{
		this->scopeStartAddress = scopeStartAddress;
	}
	int GetScopeEndAddress() const
	{
		return scopeEndAddress;
	}
	void SetScopeEndAddress( int scopeEndAddress )
	{
		this->scopeEndAddress = scopeEndAddress;
	}
	int GetScopeLevel() const
	{
		return scopeLevel;
	}
	void SetScopeLevel( int scopeLevel )
	{
		this->scopeLevel = scopeLevel;
	}


	BOOL bLiving;
	int source_code_address;


	static int GetSubScriptCounts( const Subscripts &subscripts ){
		// z̗vf擾
		int i,i2;
		for(i=0,i2=1;i<(int)subscripts.size();i++){
			i2 *= subscripts[i]+1;
		}
		return i2;
	}
};

class Variables : public vector<Variable *>
{
	int allSize;
	int allInitSize;
public:
	Variables()
		: allSize( 0 )
		, allInitSize( 0 )
	{
	}
	~Variables(){
		Clear();
	}

	void Clear(){
		for( int i=0; i<(int)this->size(); i++ ){
			delete (*this)[i];
		}

		allSize = 0;
		allInitSize = 0;
		clear();
	}
	void PullOutAll()
	{
		clear();
	}

	bool DuplicateCheck( const Symbol &symbol ) const;

	const Variable *BackSearch( const Symbol &symbol ) const;
	const Variable *Find( const Symbol &symbol )const;

	void Add( Variable *pVar, bool isInitArea );

	int GetAllSize() const
	{
		return allSize;
	}
	int GetAllInitSize() const
	{
		return allInitSize;
	}


	// XMLVACYp
private:
	friend class boost::serialization::access;
	template<class Archive> void serialize(Archive& ar, const unsigned int version)
	{
		trace_for_serialize( "serializing - Variables" );

		ar & boost::serialization::make_nvp("vector_Variable", boost::serialization::base_object<vector<Variable *>>(*this));
	}
};
