#include "stdafx.h"

#include <jenga/include/smoothie/Smoothie.h>

#include <DataTable.h>

#include <memory.h>
#include <stdlib.h>

int DataTable::AddBinary( const void *buffer, int size ){
	int retSize = this->size;

	Realloc( this->size + size );
	memcpy( (char *)this->buffer + retSize, buffer, size );

	return retSize;
}
int DataTable::Add( _int64 i64data ){
	int retSize = size;
	AddBinary( &i64data, sizeof( _int64 ) );
	return retSize;
}
int DataTable::Add( int i32data ){
	int retSize = size;
	AddBinary( &i32data, sizeof( int ) );
	return retSize;
}
int DataTable::Add( double dbl ){
	int retSize = size;
	AddBinary( &dbl, sizeof( double ) );
	return retSize;
}
int DataTable::Add( float flt ){
	int retSize = size;
	AddBinary( &flt, sizeof( float ) );
	return retSize;
}
int DataTable::AddString( const char *str, int length ){
	int retSize = size;

	if( Smoothie::IsUnicode() ){
		//Shift-JIS  Unicode
		int size = MultiByteToWideChar(
			CP_ACP,
			0,
			str, length + 1,
			NULL, 0 ) * 2;

		LPWSTR pwstr = (LPWSTR)malloc( size );

		MultiByteToWideChar(
			CP_ACP,
			0,
			str, length + 1,
			pwstr, length + 1 );

		AddBinary( pwstr, size );

		free( pwstr );
	}
	else{
		AddBinary( str, length + 1 );
	}

	return retSize;
}
int DataTable::AddString( const char *str ){
	int retSize = size;
	AddString( str, lstrlen( str ) );
	return retSize;
}

const void *DataTable::GetPtr() const
{
	return buffer;
}
int DataTable::GetSize() const
{
	return size;
}
