#pragma once

#include <option.h>
#include <Program.h>
#include <Prototype.h>
#include <Method.h>
#include <Member.h>
#include <Source.h>

class UserProc;

class InheritedInterface
{
	CClass *pInterfaceClass;
	int vtblOffset;
public:
	InheritedInterface( CClass *pInterfaceClass, int vtblOffset )
		: pInterfaceClass( pInterfaceClass )
		, vtblOffset( vtblOffset )
	{
	}

	CClass &GetInterfaceClass() const{
		return *pInterfaceClass;
	}
	int GetVtblOffset() const
	{
		return vtblOffset;
	}
};
typedef vector<InheritedInterface> Interfaces;

class CClass: public Prototype, public Jenga::Common::ObjectInHashmap<CClass>
{
public:
	// ^̎
	enum ClassType{
		Class,
		Interface,
		Enum,
		Delegate,
		Structure,
	};

private:
	ClassType classType;

	// importĂ閼O
	NamespaceScopesCollection importedNamespaces;
	
	// pNX
	const CClass *pSuperClass;

	// Blittable^
	Type blittableType;

	// C^[tFCX
	Interfaces interfaces;

	// Io
	Members dynamicMembers;

	// ÓIo
	Members staticMembers;

	// I\bh
	Methods methods;
	int ConstructorMemberSubIndex;
	int DestructorMemberSubIndex;
	int vtblNum;					// z֐̐

	// ÓI\bh
	Methods staticMethods;

	//ACgl
	int fixedAlignment;

	// XMLVACYp
	// TODO: xml
private:
	friend class boost::serialization::access;
	template<class Archive> void serialize(Archive& ar, const unsigned int version)
	{
		trace_for_serialize( "serializing - CClass" );

		ar & BOOST_SERIALIZATION_BASE_OBJECT_NVP( Prototype );
		ar & BOOST_SERIALIZATION_NVP( classType );
		ar & BOOST_SERIALIZATION_NVP( importedNamespaces );
		ar & boost::serialization::make_nvp( "pSuperClass", const_cast<CClass *&>(pSuperClass) );
		ar & BOOST_SERIALIZATION_NVP( blittableType );
		//ar & BOOST_SERIALIZATION_NVP( interfaces );
		ar & BOOST_SERIALIZATION_NVP( dynamicMembers );
		ar & BOOST_SERIALIZATION_NVP( staticMembers );
		ar & BOOST_SERIALIZATION_NVP( methods );
		ar & BOOST_SERIALIZATION_NVP( ConstructorMemberSubIndex );
		ar & BOOST_SERIALIZATION_NVP( DestructorMemberSubIndex );
		ar & BOOST_SERIALIZATION_NVP( vtblNum );
		ar & BOOST_SERIALIZATION_NVP( staticMethods );
		ar & BOOST_SERIALIZATION_NVP( fixedAlignment );
	}

	bool isReady;
public:

	CClass( const NamespaceScopes &namespaceScopes, const NamespaceScopesCollection &importedNamespaces, const string &name )
		: Prototype( namespaceScopes, name )
		, importedNamespaces( importedNamespaces )
		, classType( Class )
		, pSuperClass( NULL )
		, isReady( false )
		, fixedAlignment( 0 )
		, ConstructorMemberSubIndex( -1 )
		, DestructorMemberSubIndex( -1 )
		, vtblNum( 0 )
		, vtbl_offset( -1 )
		, isCompilingConstructor( false )
		, isCompilingDestructor( false )
		, pobj_NextClass( NULL )
	{
	}
	CClass()
		: Prototype()
		, importedNamespaces()
		, classType()
		, pSuperClass( NULL )
		, isReady( false )
		, fixedAlignment( 0 )
		, ConstructorMemberSubIndex( -1 )
		, DestructorMemberSubIndex( -1 )
		, vtblNum( 0 )
		, vtbl_offset( -1 )
		, isCompilingConstructor( false )
		, isCompilingDestructor( false )
		, pobj_NextClass( NULL )
	{
	}
	~CClass()
	{
		// Io
		BOOST_FOREACH( CMember *member, dynamicMembers ){
			delete member;
		}

		// ÓIo
		BOOST_FOREACH( CMember *member, staticMembers ){
			delete member;
		}
	}

	virtual const std::string &GetKeyName() const
	{
		return GetName();
	}
	virtual bool IsDuplication( const CClass *pClass ) const
	{
		if( pClass->IsEqualSymbol( *this ) )
		{
			return true;
		}
		return false;
	}

	void Readed(){
		isReady = true;
	}
	bool IsReady() const{
		return isReady;
	}

	const NamespaceScopesCollection &GetImportedNamespaces() const
	{
		return importedNamespaces;
	}

	// pNX
	bool HasSuperClass() const
	{
		return ( pSuperClass != NULL );
	}
	const CClass &GetSuperClass() const
	{
		return *pSuperClass;
	}
	void SetSuperClass( const CClass *pSuperClass )
	{
		this->pSuperClass = pSuperClass;
	}

	// Blittable^
	bool IsBlittableType() const
	{
		return !blittableType.IsNull();
	}
	const Type &GetBlittableType() const
	{
		return blittableType;
	}
	void SetBlittableType( const Type &type ){
		blittableType = type;
	}

	bool IsClass() const;
	bool IsInterface() const;
	bool IsEnum() const;
	bool IsDelegate() const;
	bool IsStructure() const;
	void SetClassType( ClassType classType )
	{
		this->classType = classType;
	}


	//RXgN^RpCĂ邩ǂ̃`FbNtO
private:
	mutable bool isCompilingConstructor;
public:
	void NotifyStartConstructorCompile() const;
	void NotifyFinishConstructorCompile() const;
	bool IsCompilingConstructor() const;

	//fXgN^RpCĂ邩ǂ̃`FbNtO
private:
	mutable bool isCompilingDestructor;
public:
	void NotifyStartDestructorCompile() const;
	void NotifyFinishDestructorCompile() const;
	bool IsCompilingDestructor() const;


	//g̔hNXǂmF
	bool IsSubClass( const CClass *pClass ) const;

	//gƓ܂͔hNXǂmF
	bool IsEqualsOrSubClass( const CClass *pClass ) const;

	// gƓ܂͔hNXANXǂmF
	bool IsEqualsOrSubClassOrSuperClass( const CClass &objClass ) const;

	// C^[tFCX
	bool HasInterfaces() const
	{
		return ( interfaces.size() != 0 );
	}
	bool IsInheritsInterface( const CClass *pInterfaceClass ) const;

	//p
	bool Inherits( const char *inheritNames, int nowLine );
	bool InheritsClass( const CClass &inheritsClass, int nowLine );
	bool InheritsInterface( const CClass &inheritsClass, int nowLine );

	//oA\bh̒ǉ
	CMember *CreateMember( Prototype::Accessibility accessibility, bool isConst, bool isRef, char *buffer, int nowLine );
	void AddMember( Prototype::Accessibility accessibility, bool idConst, bool isRef, char *buffer, int nowLine );
	void AddStaticMember( Prototype::Accessibility accessibility, bool isConst, bool isRef, char *buffer, int nowLine );

	void AddMethod(CClass *pobj_c, Prototype::Accessibility accessibility, BOOL bStatic, bool isConst, bool isAbstract,
		bool isVirtual, bool isOverride, char *buffer, int nowLine);

	//d`FbN
	bool DupliCheckAll(const char *name);
	bool DupliCheckMember(const char *name);

	const Members &GetDynamicMembers() const
	{
		return dynamicMembers;
	}
	const Members &GetStaticMembers() const
	{
		return staticMembers;
	}
	Members &GetDynamicMembers()
	{
		return dynamicMembers;
	}
	Members &GetStaticMembers()
	{
		return staticMembers;
	}

	const Methods &GetMethods() const
	{
		return methods;
	}
	const Methods &GetStaticMethods() const
	{
		return staticMethods;
	}
	Methods &GetMethods()
	{
		return methods;
	}
	Methods &GetStaticMethods()
	{
		return staticMethods;
	}

	//ftHg RXgN^
	const CMethod *GetConstructorMethod() const
	{
		if( ConstructorMemberSubIndex == -1 ) return NULL;
		return methods[ConstructorMemberSubIndex];
	}
	void SetConstructorMemberSubIndex( int constructorMemberSubIndex )
	{
		this->ConstructorMemberSubIndex = constructorMemberSubIndex;
	}

	//fXgN^ \bh擾
	const CMethod *GetDestructorMethod() const
	{
		if( DestructorMemberSubIndex == -1 ) return NULL;
		return methods[DestructorMemberSubIndex];
	}
	void SetDestructorMemberSubIndex( int destructorMemberSubIndex )
	{
		this->DestructorMemberSubIndex = destructorMemberSubIndex;
	}

	// vtblɑ݂鉼z֐̐
	int GetVtblNum() const
	{
		return vtblNum;
	}
	void SetVtblNum( int vtblNum )
	{
		this->vtblNum = vtblNum;
	}
	void AddVtblNum( int vtblNum )
	{
		this->vtblNum += vtblNum;
	}
	bool IsExistVirtualFunctions() const
	{
		return ( vtblNum > 0 );
	}

	// [Uw̃ACgŒl
	int GetFixedAlignment() const
	{
		return fixedAlignment;
	}
	void SetFixedAlignment( int fixedAlignment )
	{
		this->fixedAlignment = fixedAlignment;
	}

	// ȏTCY擾
	int GetSize() const;

	// õItZbg擾
	int GetMemberOffset( const char *memberName, int *pMemberNum = NULL ) const;
private:
	// ACgl擾
	int GetAlignment() const;

	//vtbl
protected:
	mutable long vtbl_offset;
public:
	int GetFuncNumInVtbl( const UserProc *pUserProc ) const;
	LONG_PTR GetVtblGlobalOffset(void) const;
	void ActionVtblSchedule(LONG_PTR ImageBase, LONG_PTR MemPos_CodeSection);
	bool IsAbstract() const;


	//`Xgp
	CClass *pobj_NextClass;
};

class Classes : public Jenga::Common::Hashmap<CClass>
{
	// XMLVACYp
public:
	Classes()
		: pCompilingMethod( NULL )
		, pStringClass( NULL )
		, pObjectClass( NULL )
	{
	}
	~Classes()
	{
	}

	virtual CClass *Create( const NamespaceScopes &namespaceScopes, const NamespaceScopesCollection &importedNamespaces, const char *name);
	bool Insert( CClass *pClass );
	CClass *Add( const NamespaceScopes &namespaceScopes, const NamespaceScopesCollection &importedNamespaces, const char *name,int nowLine);
	virtual void CollectClassesForNameOnly( const BasicSource &source );

	void ActionVtblSchedule(LONG_PTR ImageBase, LONG_PTR MemPos_CodeSection);

	virtual void InitStaticMember();

private:
	bool MemberVar_LoopRefCheck(const CClass &objClass);
public:
	virtual void GetClass_recur(const char *lpszInheritsClass);
	virtual void GetAllClassInfo();
	virtual void Compile_System_InitializeUserTypes();

	const CClass *Find( const NamespaceScopes &namespaceScopes, const string &name ) const;
	const CClass *Find( const string &fullName ) const;


	/////////////////////////////
	// ݃RpC̏
	/////////////////////////////
private:
	const CMethod *pCompilingMethod;
public:
	void StartCompile( const UserProc *pUserProc );

	//݃RpC̃\bh擾
	const CMethod *GetNowCompilingMethodInfo(){
		return pCompilingMethod;
	}


	/////////////////////////////
	// NX
	/////////////////////////////
	CClass *pStringClass;
	CClass *pObjectClass;
	CClass *GetStringClassPtr() const;
	CClass *GetObjectClassPtr() const;
};
