#include "stdafx.h"

#include <jenga/include/smoothie/SmoothieException.h>

#include <Compiler.h>
#include <Type.h>

Compiler compiler;

void Compiler::StaticLink( ObjectModules &staticLibraries )
{
	BOOST_FOREACH( ObjectModule *pStaticLibrary, staticLibraries )
	{
		// ^
		pNowObjectModule->meta.StaticLink( pStaticLibrary->meta );
	}
}

bool Compiler::StringToType( const string &typeName, Type &type ){
	type.SetIndex( -1 );

	if( typeName[0] == '*' ){
		if( typeName.size() >= 3
			&& typeName[1] == 1 && ( typeName[2] == ESC_FUNCTION || typeName[2] == ESC_SUB ) ){
				//֐|C^i*Functionj
				type.SetBasicType( DEF_PTR_PROC );
				type.SetIndex( compiler.GetObjectModule().meta.GetProcPointers().Add( typeName ) );
				return true;
		}

		const string &nextTypeName = typeName.substr( 1 );

		if( !StringToType( nextTypeName, type ) ){
			return false;
		}

		type.PtrLevelUp();

		return true;
	}

	{
		int basicType;
		if( Type::StringToBasicType( typeName, basicType ) ){
			// {^Ƃ
			type.SetBasicType( basicType );
			return true;
		}
	}

	// Object^Ƃ
	if( typeName == "Object" ){
		type.SetType( DEF_OBJECT, compiler.GetObjectModule().meta.GetClasses().GetObjectClassPtr() );
		return true;
	}

	// String^Ƃ
	if( typeName == "String" ){
		type.SetType( DEF_OBJECT, compiler.GetObjectModule().meta.GetClasses().GetStringClassPtr() );
		return true;
	}


	////////////////////
	// TypeDefꂽ^
	////////////////////
	int i=compiler.GetObjectModule().meta.GetTypeDefs().GetIndex( typeName );
	if(i!=-1){
		type = compiler.GetObjectModule().meta.GetTypeDefs()[i].GetBaseType();
		return true;
	}

	//NX
	const CClass *pobj_c = compiler.GetObjectModule().meta.GetClasses().Find( typeName );
	if(pobj_c){
		type.SetClassPtr( pobj_c );

		if( pobj_c->IsStructure() ){
			type.SetBasicType( DEF_STRUCT );
		}
		else{
			type.SetBasicType( DEF_OBJECT );
		}
		return true;
	}

	return false;
}

const string Compiler::TypeToString( const Type &type )
{
	if( PTR_LEVEL( type.GetBasicType() ) ){
		//|C^x1ȏ̏ꍇ
		Type tempType( type );
		tempType.PtrLevelDown();

		return (string)"*" + TypeToString( tempType );
	}
	else if( type.IsObject() || type.IsStruct() ){
		//IuWFNg܂͍\

		if( !( type.GetIndex() == 0 || type.GetIndex() == -1 ) ){
			if( type.GetClass().GetNamespaceScopes().size() >= 1 )
			{
				return type.GetClass().GetNamespaceScopes().ToString() + "." + type.GetClass().GetName();
			}
			return type.GetClass().GetName();
		}
	}
	else if( type.IsProcPtr() ){
		if( type.GetIndex() == 0 || type.GetIndex() == -1 ){
			return "VoidPtr";
		}
		else{
			if( compiler.GetObjectModule().meta.GetProcPointers()[type.GetIndex()]->ReturnType().IsNull() ){
				return "*Sub";
			}
			return "*Function";
		}
	}
	else{
		// {^
		const char *lpszTypeName = Type::BasicTypeToCharPtr( type );
		if( lpszTypeName )
		{
			return (const string)lpszTypeName;
		}
	}

	SmoothieException::Throw( 1 );

	return (string)"(null)";
}
