#pragma once

#include <vector>
#include <string>

#include <windows.h>
#include <stdlib.h>

#include <jenga/include/common/Exception.h>
#include <jenga/include/smoothie/BasicFixed.h>

#include <BoostSerializationSupport.h>

using namespace std;

struct INCLUDEFILEINFO{
	char **ppFileNames;
	int FilesNum;
	int LineOfFile[MAX_LEN];
};

class Text{
protected:
	char *buffer;
	int length;

	// XMLVACYp
private:
	friend class boost::serialization::access;
	BOOST_SERIALIZATION_SPLIT_MEMBER();
	template<class Archive> void load(Archive& ar, const unsigned int version)
	{
		trace_for_serialize( "serializing(load) - Text" );

		std::string str;
		ar & BOOST_SERIALIZATION_NVP( str );

		// ǂݍ݌̏
		Clear();
		Add( str );
	}
	template<class Archive> void save(Archive& ar, const unsigned int version) const
	{
		trace_for_serialize( "serializing(save) - Text" );

		// ۑ
		std::string str( buffer, length );

		ar & BOOST_SERIALIZATION_NVP( str );
	}
public:

	Text(){
		buffer = (char *)calloc( 1, 1 );
		length = 0;
	}
	~Text(){
		free( buffer );
	}
	void Clear()
	{
		length = 0;
	}
	void Add( const std::string &str )
	{
		buffer = (char *)realloc( buffer, length + str.size() + 1 );
		lstrcpy( buffer + length, str.c_str() );
		length += (int)str.size();
	}

	bool ReadFile( const string &filePath );

	static void Text::SlideString(char *buffer, int slide){
		char *temp;
		temp=(char *)malloc(lstrlen(buffer)+1);
		lstrcpy(temp,buffer);
		lstrcpy(buffer+slide,temp);
		free(temp);
	}
};

class BasicSource : public Text
{
	// XMLVACYp
private:
	friend class boost::serialization::access;
	template<class Archive> void serialize(Archive& ar, const unsigned int version)
	{
		trace_for_serialize( "serializing - BasicSource" );

		ar & BOOST_SERIALIZATION_BASE_OBJECT_NVP( Text );
	}

	static const string generateDirectiveName;

	void Realloc( int newLength ){
		buffer = (char *)realloc( buffer, newLength + 255 );

		length = newLength;

		extern char *basbuf;
		basbuf = buffer + 2;
	}

	void IncludeFiles();

	void ChangeReturnLineChar();

	void RemoveComments();

	bool ReadFile_InIncludeDirective( const string &filePath );
	void DirectiveIncludeOrRequire();

	void RemoveReturnLineUnderbar();

public:
	BasicSource(){}
	~BasicSource(){}

	char *GetBuffer(){
		return buffer+2;
	}
	const char *GetBuffer() const
	{
		return buffer+2;
	}
	int GetLength() const
	{
		return length-2;
	}

	void SetBuffer( const char *buffer );

	bool ReadFile( const string &filePath );

	bool Generate( const string &genName, const char *buffer );

	void Addition( const char *buffer );

	void operator = ( const BasicSource &source ){
		Realloc( source.length );
		lstrcpy( buffer, source.buffer );
	}

	char operator[]( int index ) const
	{
		if( index>GetLength() )
		{
			Jenga::Throw( "BasicSource bad access" );
		}
		return buffer[2+index];
	}
};
