#pragma once

class ObjectModule : public Jenga::Common::BoostSerializationSupport<ObjectModule>
{
public:
	// ^
	Meta meta;

	// O[ö̃lCeBuR[h
	NativeCode globalNativeCode;

	// f[^e[u
	DataTable dataTable;

	// \[XR[h
	BasicSource source;

	// XMLVACYp
private:
	virtual const char *RootTagName() const
	{
		return "objectModule";
	}
	friend class boost::serialization::access;
	template<class Archive> void serialize(Archive& ar, const unsigned int version)
	{
		trace_for_serialize( "serializing - objectModule" );

		ar & BOOST_SERIALIZATION_NVP( meta );
		ar & BOOST_SERIALIZATION_NVP( globalNativeCode );
		ar & BOOST_SERIALIZATION_NVP( dataTable );
		ar & BOOST_SERIALIZATION_NVP( source );
	}
};

class Linker
{
	NativeCode nativeCode;
	DWORD imageBase;

public:

	Linker()
	{
	}

	const NativeCode &GetNativeCode() const
	{
		return nativeCode;
	}

	void SetImageBase( DWORD imageBase )
	{
		this->imageBase = imageBase;
	}

	// f[^e[uXPW[
	void ResolveDataTableSchedules( long dataSectionBaseOffset );

	// DLL֐XPW[
	void ResolveDllProcSchedules( long codeSectionBaseOffset, long importSectionBaseOffset, long lookupSize, long hintSize );

	// [U`֐XPW[
	void ResolveUserProcSchedules( long codeSectionBaseOffset );

	// O[oϐXPW[
	void ResolveGlobalVarSchedules( long rwSectionBaseOffset );

	// N
	void Link( vector<ObjectModule *> &objectModules );
};
