#pragma once

#include <CodeGenerator.h>
#include <NamespaceSupporter.h>
#include <Meta.h>
#include <DataTable.h>
#include <CodeGenerator.h>
#include <Linker.h>

class Compiler
{
	// OԃT|[g
	NamespaceSupporter namespaceSupporter;

	// IuWFNgW[
	ObjectModule *pObjectModule;
	ObjectModule *pNowObjectModule;

public:

	Compiler()
		: pObjectModule( new ObjectModule )
		, pNowObjectModule( pObjectModule )
		, targetModuleType( Exe )
	{
	}
	~Compiler()
	{
		delete pObjectModule;
	}

	NamespaceSupporter &GetNamespaceSupporter()
	{
		return namespaceSupporter;
	}

	// R[h@\
	CodeGenerator codeGenerator;

	// J
	Linker linker;

	// IuWFNgW[
	ObjectModule &GetObjectModule()
	{
		return *pNowObjectModule;
	}
	void SelectObjectModule( ObjectModule &objectModule )
	{
		pNowObjectModule = &objectModule;
	}


	// ^[Qbg
	enum TargetModuleType
	{
		Exe,
		Dll,
		StaticLibrary,
	};

	TargetModuleType targetModuleType;

	bool IsExe() const
	{
		if( targetModuleType == Exe )
		{
			return true;
		}
		return false;
	}
	bool IsDll() const
	{
		if( targetModuleType == Dll )
		{
			return true;
		}
		return false;
	}
	bool IsStaticLibrary() const
	{
		if( targetModuleType == StaticLibrary )
		{
			return true;
		}
		return false;
	}
	void SetTargetModuleType( TargetModuleType targetModuleType )
	{
		this->targetModuleType = targetModuleType;
	}



	static bool StringToType( const std::string &typeName, Type &type );
	static const std::string TypeToString( const Type &type );

	// RpC̃NX
	const CClass *pCompilingClass;
};

extern Compiler compiler;
