#include "stdafx.h"

#include <jenga/include/smoothie/Smoothie.h>

#include <Compiler.h>

#include "../BasicCompiler_Common/common.h"
#include "Opcode.h"

void ExtendTypeTo64(int type,int reg){
	if(type==DEF_LONG){
		//movsxd reg64,reg32
		compiler.codeGenerator.op_movsxd(reg,reg);
	}
	else if(type==DEF_DWORD){
		//and reg,00000000FFFFFFFFh
	}
	else if(type==DEF_INTEGER || (Smoothie::IsUnicode()&&type==DEF_CHAR)){
		//movsx reg64,reg16
		compiler.codeGenerator.op_movsx64_FromReg16(reg,reg);
	}
	else if(type==DEF_WORD){
		//and reg,000000000000FFFFh
		compiler.codeGenerator.op_and64_value(reg,(int)0xFFFF);
	}
	else if(type==DEF_SBYTE || (Smoothie::IsUnicode()==false&&type==DEF_CHAR)){
		//movsx reg64,reg8
		compiler.codeGenerator.op_movsx64_FromReg8(reg,reg);
	}
	else if(type==DEF_BYTE || type==DEF_BOOLEAN){
		//and reg,00000000000000FFh
		compiler.codeGenerator.op_and64_value(reg,(int)0x00FF);
	}
}
void ExtendTypeTo32(int type,int reg){
	if(type==DEF_INTEGER || (Smoothie::IsUnicode()&&type==DEF_CHAR)){
		//movsx reg32,reg16
		compiler.codeGenerator.op_movsx32_FromReg16(reg,reg);
	}
	else if(type==DEF_WORD){
		//and reg,0000FFFFh
		compiler.codeGenerator.op_and32_value(reg,(int)0xFFFF);
	}
	else if(type==DEF_SBYTE || (Smoothie::IsUnicode()==false&&type==DEF_CHAR)){
		//movsx reg32,reg8
		compiler.codeGenerator.op_movsx32_FromReg8(reg,reg);
	}
	else if(type==DEF_BYTE || type==DEF_BOOLEAN){
		//and reg,000000FFh
		compiler.codeGenerator.op_and32_value(reg,(int)0xFF);
	}
}
void ExtendTypeTo16(int type,int reg){
	if(type==DEF_SBYTE || (Smoothie::IsUnicode()==false&&type==DEF_CHAR)){
		//movsx reg16,reg8
		compiler.codeGenerator.op_movsx16_FromReg8(reg,reg);
	}
	else if(type==DEF_BYTE){
		//and reg,000000FFh
		compiler.codeGenerator.op_and32_value(reg,(int)0xFF);
	}
}

void ChangeTypeToXmm_Double(int type,int xmm_reg,int general_reg){
	if(type==DEF_DOUBLE){
		//ȂɂȂ
	}
	else if(type==DEF_SINGLE){
		//Single^

		//cvtss2sd
		compiler.codeGenerator.op_cvtss2sd(xmm_reg,xmm_reg);
	}
	else if(Is64Type(type)){
		//64rbg^

		//cvtsi2sd xmm_reg,reg
		compiler.codeGenerator.op_cvtsi2sd_reg(sizeof(_int64),xmm_reg,general_reg);

		if(type==DEF_QWORD){
			//Ȃ

			//test reg,reg
			compiler.codeGenerator.op_test(general_reg,general_reg);

			//jge 9
			compiler.codeGenerator.op_jge( 9 );

			//addsd xmm_reg,qword ptr[offset]	offset value:43f0000000000000
			_int64 i64data=0x43f0000000000000;
			long temp=compiler.GetObjectModule().dataTable.Add( i64data );
			compiler.codeGenerator.PutOld(
				(char)0xF2,
				(char)0x0F,
				(char)0x58,
				(char)(0x04 | REGISTER_OPERAND(xmm_reg)<<3),
				(char)0x25
			);
			compiler.codeGenerator.PutOld(
				temp,
				Schedule::DataTable
			);
		}
	}
	else if(type==DEF_DWORD){
		//Ȃ32rbgl

		//64rbgɃWX^lg
		ExtendTypeTo64(type,general_reg);

		//cvtsi2sd xmm_reg,reg
		compiler.codeGenerator.op_cvtsi2sd_reg(sizeof(_int64),xmm_reg,general_reg);
	}
	else{
		//̑

		//32rbgɃWX^lg
		ExtendTypeTo32(type,general_reg);

		//cvtsi2sd xmm_reg,reg
		compiler.codeGenerator.op_cvtsi2sd_reg(sizeof(long),xmm_reg,general_reg);
	}
}
void ChangeTypeToXmm_Single(int type,int xmm_reg,int general_reg){
	if(type==DEF_DOUBLE){
		//Double^

		//cvtsd2ss
		compiler.codeGenerator.op_cvtsd2ss(xmm_reg,xmm_reg);
	}
	else if(type==DEF_SINGLE){
		//ȂɂȂ
	}
	else if(Is64Type(type)){
		//64rbg^

		//cvtsi2ss xmm_reg,reg
		compiler.codeGenerator.op_cvtsi2ss_reg(sizeof(_int64),xmm_reg,general_reg);

		if(type==DEF_QWORD){
			//Ȃ

			//test reg,reg
			compiler.codeGenerator.op_test(general_reg,general_reg);

			//jge 9
			compiler.codeGenerator.op_jge( 9 );

			//addss xmm_reg,dword ptr[offset]	offset value:5f800000
			long i32data=0x5f800000;
			long temp=compiler.GetObjectModule().dataTable.Add( i32data );
			compiler.codeGenerator.PutOld(
				(char)0xF3,
				(char)0x0F,
				(char)0x58,
				(char)(0x04 | REGISTER_OPERAND(xmm_reg)<<3),
				(char)0x25
			);
			compiler.codeGenerator.PutOld(
				temp,
				Schedule::DataTable
			);
		}
	}
	else if(type==DEF_DWORD){
		//Ȃ32rbgl

		//64rbgɃWX^lg
		ExtendTypeTo64(type,general_reg);

		//cvtsi2ss xmm_reg,reg
		compiler.codeGenerator.op_cvtsi2ss_reg(sizeof(_int64),xmm_reg,general_reg);
	}
	else{
		//̑

		//32rbgɃWX^lg
		ExtendTypeTo32(type,general_reg);

		//cvtsi2ss xmm_reg,reg
		compiler.codeGenerator.op_cvtsi2ss_reg(sizeof(long),xmm_reg,general_reg);
	}
}

void ChangeTypeToWhole(int OldType,int NewType,int reg,int xmm_reg){
	if(OldType==DEF_DOUBLE){
		if(Is64Type(NewType)){
			//cvttsd2si reg,xmm_reg
			compiler.codeGenerator.op_cvttsd2si_xmm(sizeof(_int64),reg,xmm_reg);
		}
		else{
			//cvttsd2si reg,xmm_reg
			compiler.codeGenerator.op_cvttsd2si_xmm(sizeof(long),reg,xmm_reg);
		}
	}
	else if(OldType==DEF_SINGLE){
		if(Is64Type(NewType)){
			//cvttss2si reg,xmm_reg
			compiler.codeGenerator.op_cvttss2si_xmm(sizeof(_int64),reg,xmm_reg);
		}
		else{
			//cvttss2si reg,xmm_reg
			compiler.codeGenerator.op_cvttss2si_xmm(sizeof(long),reg,xmm_reg);
		}
	}
	else{
		//琮֕ϊ

		if(Is64Type(NewType)){
			ExtendTypeTo64(OldType,reg);
		}
		else if(GetTypeSize(NewType,-1)==sizeof(long)){
			ExtendTypeTo32(OldType,reg);
		}
		else if(GetTypeSize(NewType,-1)==sizeof(short)){
			ExtendTypeTo16(OldType,reg);
		}
	}
}



/////////////////////////////////////////
// 1̍K؂ȃWX^փZbg
/////////////////////////////////////////

void SetOneTermToReg_RealCalc(int TermType,int *pXmmReg){
	int xmm_reg;

	if(IsRealNumberType(TermType)){
		//^
		xmm_reg=pobj_reg->GetLockingXmmReg();

		if(xmm_reg==REG_XMM4){
			if(TermType==DEF_DOUBLE){
				//movlpd xmm4,qword ptr[rsp+offset]		X^bNt[𗘗p
				pobj_sf->pop(xmm_reg,sizeof(double));
			}
			if(TermType==DEF_SINGLE){
				//movss xmm4,dword ptr[rsp+offset]		X^bNt[𗘗p
				pobj_sf->pop(xmm_reg,sizeof(float));
			}
		}
	}
	else{
		SetError(300,NULL,cp);
	}

	*pXmmReg=xmm_reg;
}
void SetOneTermToReg_Whole64Calc(int TermType,int *pReg){
	//1̍K؂ȃWX^փZbgi64rbgZpj
	int reg;

	reg=pobj_reg->GetLockingReg();

	if(reg==REG_R14){
		//mov r14,qword ptr[rsp+offset]     X^bNt[𗘗p
		pobj_sf->pop(REG_R14);
	}

	//WX^l64rbgɊg
	ExtendTypeTo64(TermType,reg);

	*pReg=reg;
}
void SetOneTermToReg_Whole32Calc(int TermType,int *pReg){
	//1̍K؂ȃWX^փZbgi32rbgZpj
	int reg;

	reg=pobj_reg->GetLockingReg();

	if(reg==REG_R14){
		//mov r14,qword ptr[rsp+offset]     X^bNt[𗘗p
		pobj_sf->pop(REG_R14);
	}

	//WX^l32rbgɊg
	ExtendTypeTo32(TermType,reg);

	*pReg=reg;
}



/////////////////////////////////////////
// 2̍K؂ȃWX^փZbg
/////////////////////////////////////////

void SetTowTermToReg_RealCalc(int AnswerType,int *type,int sp,int *pXmmReg1,int *pXmmReg2){
	//2̍K؂ȃWX^փZbgiDoubleZpj
	int xmm_reg1,xmm_reg2,temp_reg;


	///////////////////
	// 2
	///////////////////

	if(IsRealNumberType(type[sp-1])){
		//^
		xmm_reg2=pobj_reg->UnlockXmmReg();

		if(xmm_reg2==REG_XMM4){
			xmm_reg2=REG_XMM5;

			if(type[sp-1]==DEF_DOUBLE){
				//movlpd xmm5,qword ptr[rsp+offset]		X^bNt[𗘗p
				pobj_sf->pop(xmm_reg2,sizeof(double));
			}
			if(type[sp-1]==DEF_SINGLE){
				//movss xmm5,dword ptr[rsp+offset]		X^bNt[𗘗p
				pobj_sf->pop(xmm_reg2,sizeof(float));
			}
		}
		else{
			if(!IsRealNumberType(type[sp-2])){
				if(type[sp-1]==DEF_DOUBLE){
					//movsd xmm5,xmm_reg
					compiler.codeGenerator.op_movsd_RR( REG_XMM5, xmm_reg2 );
				}
				if(type[sp-1]==DEF_SINGLE){
					//movss xmm5,xmm_reg
					compiler.codeGenerator.op_movss_RR( REG_XMM5, xmm_reg2 );
				}

				xmm_reg2=REG_XMM5;
			}
		}
	}
	else{
		//l

		temp_reg=pobj_reg->UnlockReg();

		if(temp_reg==REG_R14){
			//mov r14,qword ptr[rsp+offset]     X^bNt[𗘗p
			pobj_sf->pop(REG_R14);
		}

		xmm_reg2=REG_XMM5;
	}

	//ėpWX^itemp_regjXMMWX^ixmm_reg2jɃRs[
	if(AnswerType==DEF_DOUBLE)
		ChangeTypeToXmm_Double(type[sp-1],xmm_reg2,temp_reg);
	if(AnswerType==DEF_SINGLE)
		ChangeTypeToXmm_Single(type[sp-1],xmm_reg2,temp_reg);


	///////////////////
	// 1
	///////////////////

	if(IsRealNumberType(type[sp-2])){
		//
		xmm_reg1=pobj_reg->GetLockingXmmReg();

		if(xmm_reg1==REG_XMM4){
			if(type[sp-2]==DEF_DOUBLE){
				//movlpd xmm4,qword ptr[rsp+offset]		X^bNt[𗘗p
				pobj_sf->pop(xmm_reg1,sizeof(double));
			}
			if(type[sp-2]==DEF_SINGLE){
				//movss xmm4,dword ptr[rsp+offset]		X^bNt[𗘗p
				pobj_sf->pop(xmm_reg1,sizeof(float));
			}
		}
	}
	else{
		//

		temp_reg=pobj_reg->UnlockReg();

		if(temp_reg==REG_R14){
			//mov r14,qword ptr[rsp+offset]     X^bNt[𗘗p
			pobj_sf->pop(REG_R14);
		}

		xmm_reg1=pobj_reg->LockXmmReg();
	}

	//ėpWX^itemp_regjXMMWX^ixmm_reg1jɃRs[
	if(AnswerType==DEF_DOUBLE)
		ChangeTypeToXmm_Double(type[sp-2],xmm_reg1,temp_reg);
	if(AnswerType==DEF_SINGLE)
		ChangeTypeToXmm_Single(type[sp-2],xmm_reg1,temp_reg);


	*pXmmReg1=xmm_reg1;
	*pXmmReg2=xmm_reg2;
}
void SetTowTermToReg_Whole64Calc(int *type,int sp,int *pReg1,int *pReg2){
	//2̍K؂ȃWX^փZbgi64rbgZpj
	int reg1,reg2;

	//////////////////
	// 2
	//////////////////
	reg2=pobj_reg->UnlockReg();

	if(reg2==REG_R14){
		//mov r15,qword ptr[rsp+offset]     X^bNt[𗘗p
		pobj_sf->pop(REG_R15);

		reg2=REG_R15;
	}

	//WX^l64rbgɊg
	ExtendTypeTo64(type[sp-1],reg2);


	//////////////////
	// 1
	//////////////////
	reg1=pobj_reg->GetLockingReg();

	if(reg1==REG_R14){
		//mov r14,qword ptr[rsp+offset]     X^bNt[𗘗p
		pobj_sf->pop(REG_R14);
	}

	//WX^l64rbgɊg
	ExtendTypeTo64(type[sp-2],reg1);


	*pReg1=reg1;
	*pReg2=reg2;
}
void SetTowTermToReg_Whole32Calc(int *type,int sp,int *pReg1,int *pReg2){
	//2̍K؂ȃWX^փZbgi32rbgZpj
	int reg1,reg2;

	//////////////////
	// 2
	//////////////////
	reg2=pobj_reg->UnlockReg();

	if(reg2==REG_R14){
		//mov r15,qword ptr[rsp+offset]     X^bNt[𗘗p
		pobj_sf->pop(REG_R15);

		reg2=REG_R15;
	}

	//WX^l32rbgɊg
	ExtendTypeTo32(type[sp-1],reg2);


	//////////////////
	// 1
	//////////////////
	reg1=pobj_reg->GetLockingReg();

	if(reg1==REG_R14){
		//mov r14,qword ptr[rsp+offset]     X^bNt[𗘗p
		pobj_sf->pop(REG_R14);
	}

	//WX^l32rbgɊg
	ExtendTypeTo32(type[sp-2],reg1);


	*pReg1=reg1;
	*pReg2=reg2;
}



////////////////////////////
// As ZqɂLXg
////////////////////////////

BOOL Calc_Cast(int *type,LONG_PTR *index_stack,int *pStackPointer){
	//LXg

	int sp;
	sp=*pStackPointer;

	int CastType;
	CastType=type[sp-1];
	if((CastType&FLAG_CAST)==0){
		SetError(47,NULL,cp);
		return 0;
	}
	CastType=CastType&(~FLAG_CAST);

	int xmm_reg,reg;

	if(IsRealNumberType(CastType)){
		//^փLXg

		if(IsRealNumberType(type[sp-2])){
			SetOneTermToReg_RealCalc(type[sp-2],&xmm_reg);
		}
		else{
			if(Is64Type(type[sp-2]))
				SetOneTermToReg_Whole64Calc(type[sp-2],&reg);
			else if(IsWholeNumberType(type[sp-2]))
				SetOneTermToReg_Whole32Calc(type[sp-2],&reg);

			pobj_reg->UnlockReg();

			xmm_reg=pobj_reg->LockXmmReg();
		}

		if(CastType==DEF_DOUBLE){
			//Double^Ƀf[^ϊ
			ChangeTypeToXmm_Double(type[sp-2],xmm_reg,reg);
		}
		else if(CastType==DEF_SINGLE){
			//Single^Ƀf[^ϊ
			ChangeTypeToXmm_Single(type[sp-2],xmm_reg,reg);
		}

		if(xmm_reg==REG_XMM4){
			//movsd qword ptr[rsp+offset],xmm4		X^bNt[𗘗p
			pobj_sf->push(REG_XMM4,sizeof(double));
		}
	}
	else{
		//̑^֕ϊ

		if(IsRealNumberType(type[sp-2])){
			SetOneTermToReg_RealCalc(type[sp-2],&xmm_reg);

			pobj_reg->UnlockXmmReg();

			reg=pobj_reg->LockReg();

			//^փf[^ϊ
			ChangeTypeToWhole(type[sp-2],CastType,reg,xmm_reg);

			if(reg==REG_R14){
				//mov qword ptr[rsp+offset],r14     X^bNt[𗘗p
				pobj_sf->push(REG_R14);
			}
		}
		else{
			reg=pobj_reg->GetLockingReg();

			if(reg==REG_R14){
				//mov r14,qword ptr[rsp+offset]     X^bNt[𗘗p
				pobj_sf->pop(REG_R14);
			}

			//^փf[^ϊ
			ChangeTypeToWhole(type[sp-2],CastType,reg,0);

			if(reg==REG_R14){
				//mov qword ptr[rsp+offset],r14     X^bNt[𗘗p
				pobj_sf->push(REG_R14);
			}
		}
	}

	type[sp-2]=CastType;
	index_stack[sp-2]=index_stack[sp-1];

	sp--;

	*pStackPointer=sp;
	return 1;
}
