#include "stdafx.h"

#include <Compiler.h>

#include "../BasicCompiler_Common/common.h"
#include "../BasicCompiler_Common/DebugSection.h"

//fobOp
#include "../BasicCompiler_Common/debug.h"

extern char *OpBuffer;

extern DWORD dwStepRun;

HANDLE hDebugProcess;

DWORD _DebugSys_dwThreadID[MAX_DEBUG_THREAD];
HANDLE array_hDebugThread[MAX_DEBUG_THREAD];

int StepCursorObpSchedule=-1;
int StepCursor_BackupChar;

int NextStepThreadNum;


void Debugger_StepIn(void){
	dwStepRun=1;
}
void Debugger_StepOver(void){
	dwStepRun=2;
}

void Debugger_StepCursor(void){
	char temporary[MAX_PATH];
	GetTempPath(MAX_PATH,temporary);
	if(temporary[lstrlen(temporary)-1]!='\\') lstrcat(temporary,"\\");
	lstrcat(temporary,"ab_breakpoint.tmp");

	char *buffer;
	buffer=ReadBuffer_NonErrMsg(temporary);

	int i=0;
	char szFilePath[MAX_PATH];
	i=GetOneParameter(buffer,i,szFilePath);
	RemoveStringQuotes(szFilePath);

	int iLineNum;
	i=GetOneParameter(buffer,i,temporary);
	iLineNum=atoi(temporary);



	/////////////////////////////////////////////////////////
	// fobOvZX̃lCeBuobt@̈XV
	/////////////////////////////////////////////////////////

	extern INCLUDEFILEINFO IncludeFileInfo;

	int FileNum;
	for(FileNum=0;FileNum<IncludeFileInfo.FilesNum;FileNum++){
		if(lstrcmpi(IncludeFileInfo.ppFileNames[FileNum],szFilePath)==0) break;
	}
	if(FileNum==IncludeFileInfo.FilesNum) return;

	for(i=0;;i++){
		if(IncludeFileInfo.LineOfFile[i]==FileNum||
			IncludeFileInfo.LineOfFile[i]==-1) break;
	}
	if(IncludeFileInfo.LineOfFile[i]==-1) return;

	int FileBaseLine;
	FileBaseLine=i;

	int i2;
	for(i2=0;;i++,i2++){
		if(FileNum<IncludeFileInfo.LineOfFile[i]){
			while(FileNum!=IncludeFileInfo.LineOfFile[i]) i++;
		}

		if(i2==iLineNum){
			extern SourceLines oldSourceLines;

loop:
			int tempCp;
			tempCp=GetCpFromLine(FileBaseLine+i2);

			int i3;
			for(i3=0;i3<(int)oldSourceLines.size()-1;i3++){
				if(oldSourceLines[i3].GetSourceCodePos()==tempCp) break;
			}
			if(i3==oldSourceLines.size()-1){
				i2--;
				goto loop;
			}

			StepCursorObpSchedule=oldSourceLines[i3].GetNativeCodePos();
			StepCursor_BackupChar=pobj_DBDebugSection->pobj_now->BreakStepCodeBuffer[StepCursorObpSchedule];

			pobj_DBDebugSection->pobj_now->BreakStepCodeBuffer[StepCursorObpSchedule]=(char)0xCC;

			break;
		}
	}

	extern HWND hDebugWnd;
	SendMessage(hDebugWnd,WM_DEBUG_CONTINUE,0,0);



	HeapDefaultFree(buffer);
}
void Debugger_Stop(void){
	//vZXI
	TerminateProcess(hDebugProcess,0);
	hDebugProcess=0;

	//fobO_CAOI
	extern HWND hDebugWnd;
	if(hDebugWnd){
		DestroyWindow(hDebugWnd);
	}
}
void Debugger_Pause(void){
	///////////////////////////
	// fobOꎞf
	///////////////////////////

	//^[QbgvZX̃Xbhꎞf
	int i;
	for(i=0;i<MAX_DEBUG_THREAD;i++){
		if(_DebugSys_dwThreadID[i])
			SuspendThread(array_hDebugThread[i]);
	}

	//fobOWX^ɃtOZbg
	CONTEXT Context;
	for(i=0;i<MAX_DEBUG_THREAD;i++){
		if(_DebugSys_dwThreadID[i]){
			Context.ContextFlags=CONTEXT_CONTROL|CONTEXT_DEBUG_REGISTERS;
			GetThreadContext(array_hDebugThread[i],&Context);
			Context.EFlags|=0x100;
			SetThreadContext(array_hDebugThread[i],&Context);
		}
	}

	//XbhĊJ
	for(i=0;i<MAX_DEBUG_THREAD;i++){
		if(_DebugSys_dwThreadID[i])
			ResumeThread(array_hDebugThread[i]);
	}
}

void ReleaseCPUSingleStep(void){
	////////////////////////////////////////
	// CPU@\̃VOXebv
	////////////////////////////////////////

	//^[QbgvZX̃Xbhꎞf
	int i;
	for(i=0;i<MAX_DEBUG_THREAD;i++){
		if(_DebugSys_dwThreadID[i])
			SuspendThread(array_hDebugThread[i]);
	}

	//fobOWX^ɃtOZbg
	CONTEXT Context;
	for(i=0;i<MAX_DEBUG_THREAD;i++){
		if(_DebugSys_dwThreadID[i]){
			Context.ContextFlags=CONTEXT_CONTROL|CONTEXT_DEBUG_REGISTERS;
			GetThreadContext(array_hDebugThread[i],&Context);
			Context.EFlags&=~0x00000100;
			SetThreadContext(array_hDebugThread[i],&Context);
		}
	}

	//XbhĊJ
	for(i=0;i<MAX_DEBUG_THREAD;i++){
		if(_DebugSys_dwThreadID[i])
			ResumeThread(array_hDebugThread[i]);
	}
}


ULONG_PTR rva_to_real(DWORD p){
	extern DWORD ImageBase;
	extern int MemPos_CodeSection;
	return p+ImageBase+MemPos_CodeSection;
}

void ShowVarList(DEBUG_EVENT *pde,BOOL bExit){
	extern DWORD ImageBase;
	extern int MemPos_RWSection;

	//fobO_CAO\
	extern HINSTANCE hInst;
	extern HWND hMainDlg;
	extern HWND hDebugWnd;
	dwStepRun=0;
	if(!hDebugWnd) SendMessage(hMainDlg,WM_SHOWVARLIST,0,pde->dwThreadId);
	else InitVarList(pde->dwThreadId);

	if(bExit){
		//"f"
		SetDlgItemText(hMainDlg,IDOK,STRING_CLOSE);

		extern HWND hDebuggerToolbar;
		SendMessage(hDebuggerToolbar,TB_SETSTATE,IDC_DEBUG_START,TBSTATE_INDETERMINATE);
		SendMessage(hDebuggerToolbar,TB_SETSTATE,IDC_DEBUG_STEPOVER,TBSTATE_INDETERMINATE);
		SendMessage(hDebuggerToolbar,TB_SETSTATE,IDC_DEBUG_STEPIN,TBSTATE_INDETERMINATE);
	}
	else{
		//"p"
		SetDlgItemText(hDebugWnd,IDCANCEL,STRING_CONTINUE);
	}
	while(hDebugWnd&&dwStepRun==0) Sleep(1);
}
void DebugMessage(char *buffer){
	extern HWND hMainDlg;
	int pos;

	if(!IsWindowEnabled(GetDlgItem(hMainDlg,IDC_DEBUGLIST))){
		SetDlgItemText(hMainDlg,IDC_DEBUGLIST,"");
		EnableWindow(GetDlgItem(hMainDlg,IDC_DEBUGLIST),1);
	}

	pos=GetWindowTextLength(GetDlgItem(hMainDlg,IDC_DEBUGLIST));
	SendDlgItemMessage(hMainDlg,IDC_DEBUGLIST,EM_SETSEL,pos,pos);
	SendDlgItemMessage(hMainDlg,IDC_DEBUGLIST,EM_REPLACESEL,0,(LPARAM)buffer);
}
UserProc *GetSubFromObp(ULONG_PTR pos){
	compiler.GetObjectModule().meta.GetUserProcs().Iterator_Reset();
	while( compiler.GetObjectModule().meta.GetUserProcs().Iterator_HasNext() )
	{
		UserProc *pUserProc = compiler.GetObjectModule().meta.GetUserProcs().Iterator_GetNext();

		if(rva_to_real(pUserProc->GetBeginOpAddress()) <= pos  &&
			pos < rva_to_real(pUserProc->GetEndOpAddress()))
		{
			return pUserProc;
		}
	}
	return NULL;
}
void ReleaseSingleStep(DWORD dwBeforeStepRun,HANDLE hThread,CONTEXT *pContext){
	//ȑOɃVOXebvsꍇ
	extern DWORD ImageBase;
	extern int MemPos_CodeSection;
	extern int FileSize_CodeSection;
	int i2;
	ULONG_PTR lpAccBytes;

	///////////////////////////
	// VOXebvOFF
	///////////////////////////

	//[U[w̃u[N|CgZbg
	WriteProcessMemory(hDebugProcess,
		(void *)(ULONG_PTR)(ImageBase+MemPos_CodeSection),
		pobj_DBDebugSection->pobj_now->BreakStepCodeBuffer,
		FileSize_CodeSection,&lpAccBytes);

	//Ɏsׂ߂̓[U[wɂu[N|Cg͂Ă
	if(ImageBase+MemPos_CodeSection<=EIP_RIP(*pContext)&&EIP_RIP(*pContext)<ImageBase+MemPos_CodeSection+FileSize_CodeSection){
		if(OpBuffer[EIP_RIP(*pContext)-ImageBase-MemPos_CodeSection-1]!=
			pobj_DBDebugSection->pobj_now->BreakStepCodeBuffer[EIP_RIP(*pContext)-ImageBase-MemPos_CodeSection-1]){
			//Õu[N|Cg[U[wɂ̂Ƃ

			//eip/rip1
			EIP_RIP(*pContext)--;
			SetThreadContext(hThread,pContext);

			//u[N|Cg
			WriteProcessMemory(hDebugProcess,(void *)EIP_RIP(*pContext),&OpBuffer[EIP_RIP(*pContext)-ImageBase-MemPos_CodeSection],1,&lpAccBytes);


			extern int StepCursorObpSchedule;
			if(StepCursorObpSchedule==(int)(EIP_RIP(*pContext)-ImageBase-MemPos_CodeSection)){
				//J[\s܂ł̃Xebvs̏ꍇ
				pobj_DBDebugSection->pobj_now->BreakStepCodeBuffer[StepCursorObpSchedule]=StepCursor_BackupChar;
				StepCursorObpSchedule=-1;
			}

			return;
		}
	}


	if(dwBeforeStepRun){
		//OɃVOXebvsꍇ
		if(ImageBase+MemPos_CodeSection <= EIP_RIP(*pContext) &&
			EIP_RIP(*pContext) < ImageBase+MemPos_CodeSection+FileSize_CodeSection){
			//IWiR[ĥ݁AVOXebvp"int 3"l
			EIP_RIP(*pContext)--;
			SetThreadContext(hThread,pContext);
		}

		//̃Xbh̃TXyh
		for(i2=0;i2<MAX_DEBUG_THREAD;i2++){
			if(array_hDebugThread[i2] && hThread!=array_hDebugThread[i2])
				ResumeThread(array_hDebugThread[i2]);
		}
	}
}

void Set_DebugSys_dwThreadID(){
	int i;
	for(i=0;i<pobj_DBDebugSection->num;i++){
		ULONG_PTR lpAccBytes;
		WriteProcessMemory(hDebugProcess,
			(void *)(ULONG_PTR)(pobj_DBDebugSection->ppobj_ds[i]->dwImageBase + pobj_DBDebugSection->ppobj_ds[i]->dwRVA_RWSection),
			_DebugSys_dwThreadID,sizeof(DWORD)*MAX_DEBUG_THREAD,&lpAccBytes);
	}
}
void AddThread(DWORD dwThreadId, HANDLE hThread){
	int i;


	for(i=0;i<MAX_DEBUG_THREAD;i++){
		if(_DebugSys_dwThreadID[i]==0){
			_DebugSys_dwThreadID[i]=dwThreadId;
			array_hDebugThread[i]=hThread;
			break;
		}
	}

	Set_DebugSys_dwThreadID();
}
void DeleteThread(DWORD dwThreadId){
	int i;

	for(i=0;i<MAX_DEBUG_THREAD;i++){
		if(_DebugSys_dwThreadID[i]==dwThreadId){
			_DebugSys_dwThreadID[i]=0;
			array_hDebugThread[i]=0;
			break;
		}
	}

	Set_DebugSys_dwThreadID();
}

void DebugProgram(void){
	extern HWND hMainDlg;
	extern char OutputFileName[MAX_PATH];
	extern DWORD ImageBase;
	extern int MemPos_CodeSection;
	extern int MemPos_RWSection;
	extern int FileSize_CodeSection;
	int i2,i3,i4;
	char temporary[1024];

	extern BOOL bDll;
	char ExeFilePathForDll[MAX_PATH];
	if(bDll){
		//DLLfobOꍇ
		extern char szDebugExeForDll[1024];
		if(szDebugExeForDll[0]){
			//wς
			lstrcpy(ExeFilePathForDll,szDebugExeForDll);
		}
		else{
			//[U[Ɏst@CI
			extern HWND hOwnerEditor;
			extern LPSTR ExeFileFilter;
			if(!GetFilePathDialog(hOwnerEditor,ExeFilePathForDll,ExeFileFilter,"fobOp̎s\t@Cw肵ĂB",1)) return;
		}
	}


	//"f"
	SetDlgItemText(hMainDlg,IDOK,STRING_STOP);

	SendMessage(hOwnerEditor,WM_SETDEBUGGERBASE,0,0);

	//JgfBNgݒ
	extern char BasicCurDir[MAX_PATH];
	SetCurrentDirectory(BasicCurDir);

	SendDlgItemMessage(hMainDlg,IDC_SHOWERROR,BM_SETCHECK,BST_UNCHECKED,0);
	SendDlgItemMessage(hMainDlg,IDC_SHOWDEBUG,BM_SETCHECK,BST_CHECKED,0);
	SendMessage(hMainDlg,WM_COMMAND,IDC_SHOWDEBUG,0);

	//u[N|Cg𐶐
	pobj_DBBreakPoint=new CDBBreakPoint;


	extern BOOL bAttach;
	if(bAttach){
		extern DWORD dwAttachProcessId;

		//vZXIDɃnh擾
		HANDLE hProcess;
		hProcess=OpenProcess(PROCESS_ALL_ACCESS,0,dwAttachProcessId);
		if(!hProcess) goto AttachError;

		//̃vZXɂsW[̃CX^Xnh擾
		HINSTANCE hModule;
		DWORD cbReturned;
		if(!EnumProcessModules( hProcess, &hModule, sizeof(HINSTANCE), &cbReturned )) goto AttachError;

		//st@C擾
		GetModuleFileNameEx(hProcess,hModule,OutputFileName,MAX_PATH);

		CloseHandle(hProcess);

/*
		//fobOp̊g擾
		pobj_DebugSection->load(OutputFileName);*/

		if(!DebugActiveProcess(dwAttachProcessId)){
AttachError:
			DebugMessage("A^b`Ɏs܂B");
			return;
		}
	}
	else{
		/*if(!pobj_DebugSection->load(OutputFileName)){
			extern BOOL bDebugCompile;
			bDebugCompile=1;
			OutputExe();
			pobj_DebugSection->load(OutputFileName);
		}*/

		//Xbh𐶐
		extern char szDebugCmdLine[1024];
		STARTUPINFO si;
		PROCESS_INFORMATION pi;
		memset(&si,0,sizeof(STARTUPINFO));
		si.cb=sizeof(STARTUPINFO);
		if(!bDll){
			//EXEt@CfobO
			CreateProcess(OutputFileName,szDebugCmdLine,NULL,NULL,0,NORMAL_PRIORITY_CLASS|DEBUG_ONLY_THIS_PROCESS,NULL,NULL,&si,&pi);
		}
		else{
			//DLLt@CfobO
			CreateProcess(ExeFilePathForDll,szDebugCmdLine,NULL,NULL,0,NORMAL_PRIORITY_CLASS|DEBUG_ONLY_THIS_PROCESS,NULL,NULL,&si,&pi);
		}

		CloseHandle(pi.hProcess);
		CloseHandle(pi.hThread);
	}


	//fobOf[^x[X𐶐
	pobj_DBDebugSection=new CDBDebugSection();

	//fobOXbhivV[W̊Kw\Ǘj𐶐
	pobj_dti=new CDebugThreadInfo();

	UserProc *pUserProc;

	extern DWORD dwStepRun;
	BOOL bFirstBreak=1;
	CONTEXT Context;
	HANDLE hMainThread;
	ULONG_PTR lpAccBytes;

	DEBUG_EVENT de;
	memset(&de,0,sizeof(DEBUG_EVENT));

	while(WaitForDebugEvent(&de,INFINITE)){
		if(de.dwDebugEventCode==LOAD_DLL_DEBUG_EVENT){
			WCHAR wcBuf[MAX_PATH];
			LONG_PTR lpData;

			wcBuf[0]=0;
			temporary[0]=0;

			if(de.u.LoadDll.lpImageName){
				if(!ReadProcessMemory(hDebugProcess,de.u.LoadDll.lpImageName,&lpData,sizeof(LONG_PTR),&lpAccBytes)){
					sprintf(temporary,"[hꂽDLL̖O擾iAhX:&H%08xjɎs܂B\r\n",(ULONG_PTR)de.u.LoadDll.lpImageName);
					DebugMessage(temporary);
					goto NextContinue;
				}
				if(!lpData) goto Attach_DllLoad;

				if(!ReadProcessMemory(hDebugProcess,(void *)lpData,wcBuf,sizeof(WCHAR)*MAX_PATH,&lpAccBytes)){
					sprintf(temporary,"[hꂽDLL̖O擾iAhX:&H%08xjɎs܂B\r\n",lpData);
					DebugMessage(temporary);
					goto NextContinue;
				}

				if(de.dwThreadId,de.u.LoadDll.fUnicode)
					WideCharToMultiByte(CP_ACP,0,wcBuf,-1,temporary,255,NULL,NULL);
				else lstrcpy(temporary,(char *)wcBuf);
			}
			else{
Attach_DllLoad:
				//A^b`ꍇ
				GetModuleFileNameEx(hDebugProcess,(HINSTANCE)de.u.LoadDll.lpBaseOfDll,temporary,MAX_PATH);
			}

			char temp2[1024];
			sprintf(temp2,"\"%s\" [h܂B\r\n",temporary);
			DebugMessage(temp2);


			//\ł΃fobOǂ݂Ƃ
			if(pobj_DBDebugSection->add((HMODULE)de.u.LoadDll.lpBaseOfDll)){
				pobj_DBDebugSection->choice(0);
				Set_DebugSys_dwThreadID();
			}


			/*if(lstrcmpi(temporary, OutputFileName)==0){
				ImageBase=(DWORD)de.u.LoadDll.lpBaseOfDll;

				AddThread(de.dwThreadId,hMainThread);
			}*/
		}
		else if(de.dwDebugEventCode==UNLOAD_DLL_DEBUG_EVENT){
			//DLL̃A[h

			pobj_DBDebugSection->del((HMODULE)de.u.UnloadDll.lpBaseOfDll);
		}
		else if(de.dwDebugEventCode==CREATE_PROCESS_DEBUG_EVENT){
			hDebugProcess=de.u.CreateProcessInfo.hProcess;
			hMainThread=de.u.CreateProcessInfo.hThread;

			if(pobj_DBDebugSection->add((HMODULE)de.u.CreateProcessInfo.lpBaseOfImage)){
				pobj_DBDebugSection->choice(0);
			}

			AddThread(de.dwThreadId,de.u.CreateProcessInfo.hThread);
		}
		else if(de.dwDebugEventCode==CREATE_THREAD_DEBUG_EVENT){
			AddThread(de.dwThreadId,de.u.CreateThread.hThread);
		}
		else if(de.dwDebugEventCode==EXIT_PROCESS_DEBUG_EVENT){
			//fobO_CAOI
			SendMessage(hMainDlg,WM_CLOSE_DEBUGGER,0,0);

			DeleteThread(de.dwThreadId);

			//"Xbh(&H%X)̓R[h &H%X ŏI܂B\r\n"
			sprintf(temporary,STRING_DEBUG_THREADFINISH,de.dwThreadId,de.u.ExitProcess.dwExitCode);
			DebugMessage(temporary);

			//"vO̓R[h &H%X ŏI܂B\r\n"
			sprintf(temporary,STRING_DEBUG_PROCESSFINISH,de.u.ExitProcess.dwExitCode);
			DebugMessage(temporary);
			break;
		}
		else if(de.dwDebugEventCode==EXIT_THREAD_DEBUG_EVENT){
			//"Xbh(&H%X)̓R[h &H%X ŏI܂B\r\n"
			sprintf(temporary,STRING_DEBUG_THREADFINISH,de.dwThreadId,de.u.ExitThread.dwExitCode);
			DebugMessage(temporary);

			//ȑOɃVOXebvsꍇ
			//Xebvs
			if(dwStepRun){
				extern HWND hDebugWnd;
				if(hDebugWnd) SendMessage(hDebugWnd,WM_VARLIST_CLOSE,0,0);

				for(i4=0;i4<MAX_DEBUG_THREAD;i4++){
					if(de.dwThreadId==_DebugSys_dwThreadID[i4]) break;
				}
				Context.ContextFlags=CONTEXT_CONTROL;
				GetThreadContext(array_hDebugThread[i4],&Context);

				ReleaseSingleStep(dwStepRun,array_hDebugThread[i4],&Context);
			}

			DeleteThread(de.dwThreadId);
		}
		else if(de.dwDebugEventCode==OUTPUT_DEBUG_STRING_EVENT){
			ReadProcessMemory(hDebugProcess,(void *)de.u.DebugString.lpDebugStringData,temporary,de.u.DebugString.nDebugStringLength,&lpAccBytes);
			DebugMessage(temporary);
		}
		else if(de.dwDebugEventCode==EXCEPTION_DEBUG_EVENT){

			//////////////////////////////////////
			// W[ĊmF
			// DLLւ̃fobO\ɂ
			//////////////////////////////////////


			//O͖
			if(bFirstBreak){
				bFirstBreak=0;
				goto NextContinue;
			}

			for(i2=0;;i2++){
				if(_DebugSys_dwThreadID[i2]==de.dwThreadId) break;
			}

			//XbhtbV
			if(!pobj_dti->Reflesh(i2)){
				MessageBox(hOwnerEditor,"fobO񂪉Ă܂B^[Qbgt@CăRpCĂB","ActiveBasic",MB_OK|MB_ICONEXCLAMATION);

				break;
			}

			if(de.u.Exception.ExceptionRecord.ExceptionCode==EXCEPTION_ACCESS_VIOLATION){

				//"Xbh(&H%X)ŃANZXᔽ܂(EIP=&H%08X)B\r\n"
				sprintf(temporary,STRING_DEBUG_THREAD_ACCESSVIOLATION,de.dwThreadId,(ULONG_PTR)de.u.Exception.ExceptionRecord.ExceptionAddress);
				DebugMessage(temporary);

				MessageBeep(MB_ICONEXCLAMATION);
				ShowVarList(&de,1);
				break;
			}
			else if(de.u.Exception.ExceptionRecord.ExceptionCode==EXCEPTION_BREAKPOINT||
				de.u.Exception.ExceptionRecord.ExceptionCode==EXCEPTION_SINGLE_STEP){
				/////////////////////////
				// u[N|Cg
				/////////////////////////

				if(de.u.Exception.ExceptionRecord.ExceptionCode==EXCEPTION_SINGLE_STEP){
					//CPU@\̃VOXebvɂu[N|Cg
					//VOXebv
					ReleaseCPUSingleStep();
				}

				i3=dwStepRun;

				for(i4=0;i4<MAX_DEBUG_THREAD;i4++){
					if(de.dwThreadId==_DebugSys_dwThreadID[i4]) break;
				}
				Context.ContextFlags=CONTEXT_CONTROL | CONTEXT_INTEGER;
				GetThreadContext(array_hDebugThread[i4],&Context);

				if(i3==0||
					i3&&(!(ImageBase+MemPos_CodeSection<=EIP_RIP(Context)&&EIP_RIP(Context)<ImageBase+MemPos_CodeSection+FileSize_CodeSection))
					){
					//"Xbh(&H%X)̃u[N |Cg(EIP=&H%08X)B\r\n"
					sprintf(temporary,
						STRING_DEBUG_BREAKPOINT,
						de.dwThreadId,
						(ULONG_PTR)de.u.Exception.ExceptionRecord.ExceptionAddress,
#ifdef _AMD64_
						(ULONG_PTR)Context.Rsp
#else
						(ULONG_PTR)Context.Esp
#endif
					);
					DebugMessage(temporary);
				}

				ShowVarList(&de,0);

				//Xebvs
				ReleaseSingleStep(i3,array_hDebugThread[i4],&Context);

				if(dwStepRun){
					//VɃVOXebvsꍇ

					if(i4!=NextStepThreadNum){
						//̃XebvΏۂʃXbh̏ꍇ
						Context.ContextFlags=CONTEXT_CONTROL;
						GetThreadContext(array_hDebugThread[NextStepThreadNum],&Context);
					}

					if(ImageBase+MemPos_CodeSection <= EIP_RIP(Context) &&
						EIP_RIP(Context) < ImageBase+MemPos_CodeSection+FileSize_CodeSection){
						//Debugߌꂪꍇ̓VOXebv͕svɂȂ̂ŁAɂ
						//iIWiR[ĥ݁j
						if(OpBuffer[EIP_RIP(Context)-ImageBase-MemPos_CodeSection]==(char)0xCC)
							dwStepRun=0;
					}
					if(dwStepRun==1){
						//XebvC
StepIn:
						//VOXebvON
						WriteProcessMemory(hDebugProcess,(void *)(ULONG_PTR)(ImageBase+MemPos_CodeSection),
							pobj_DBDebugSection->pobj_now->SingleStepCodeBuffer,
							FileSize_CodeSection,&lpAccBytes);

						//̖ߌ̃u[N߂͉ĂiVOXebvŝ݁j
						//iIWiR[ĥ݁j
						if(i3&&ImageBase+MemPos_CodeSection<=EIP_RIP(Context)&&EIP_RIP(Context)<ImageBase+MemPos_CodeSection+FileSize_CodeSection)
							WriteProcessMemory(hDebugProcess,(void *)EIP_RIP(Context),&OpBuffer[EIP_RIP(Context)-ImageBase-MemPos_CodeSection],1,&lpAccBytes);

						//̃Xbhꎞf
						for(i4=0;i4<MAX_DEBUG_THREAD;i4++){
							if(_DebugSys_dwThreadID[i4] && NextStepThreadNum!=i4)
								SuspendThread(array_hDebugThread[i4]);
						}
					}
					else if(dwStepRun==2){
						//XebvI[o[

						BOOL bRet;
						bRet=ReadProcessMemory(hDebugProcess,
							(void *)EIP_RIP(Context),
							temporary,
							5,
							&lpAccBytes);
						if(!bRet) MessageBox(hMainDlg,"vZX[̓ǂݍ݂Ɏs","error",MB_OK);

						extern const UserProc *pSub_DebugSys_EndProc;
						if((BYTE)temporary[0]==0xE8&&
							*((long *)(temporary+1))+5==(long)rva_to_real(pSub_DebugSys_EndProc->GetBeginOpAddress())-(long)EIP_RIP(Context)){
							//vV[W̏I[ʒȕꍇ̓XebvCs
							goto StepIn;
						}

						extern int GlobalOpBufferSize;
						if(ImageBase+MemPos_CodeSection<=pobj_dti->lplpObp[pobj_dti->iProcLevel]&&
							pobj_dti->lplpObp[pobj_dti->iProcLevel]<ImageBase+MemPos_CodeSection+GlobalOpBufferSize){
							//VOXebvON
							WriteProcessMemory(hDebugProcess,
								(void *)(ULONG_PTR)(ImageBase+MemPos_CodeSection),
								pobj_DBDebugSection->pobj_now->SingleStepCodeBuffer,
								GlobalOpBufferSize,
								&lpAccBytes);
						}
						else{
							//vV[W
							pUserProc=GetSubFromObp(pobj_dti->lplpObp[pobj_dti->iProcLevel]);

							//VOXebvON
							WriteProcessMemory(hDebugProcess,
								(void *)rva_to_real(pUserProc->GetBeginOpAddress()),
								pobj_DBDebugSection->pobj_now->SingleStepCodeBuffer+pUserProc->GetBeginOpAddress(),
								pUserProc->GetEndOpAddress()-pUserProc->GetBeginOpAddress(),
								&lpAccBytes);
						}

						//̖ߌ̃u[N߂͉ĂiVOXebvŝ݁j
						//iIWiR[ĥ݁j
						if(i3&&ImageBase+MemPos_CodeSection<=EIP_RIP(Context)&&EIP_RIP(Context)<ImageBase+MemPos_CodeSection+FileSize_CodeSection)
							WriteProcessMemory(hDebugProcess,(void *)EIP_RIP(Context),&OpBuffer[EIP_RIP(Context)-ImageBase-MemPos_CodeSection],1,&lpAccBytes);

						//̃Xbhꎞf
						for(i4=0;i4<MAX_DEBUG_THREAD;i4++){
							if(_DebugSys_dwThreadID[i4] && NextStepThreadNum!=i4)
								SuspendThread(array_hDebugThread[i4]);
						}
					}
				}
			}
			else if(de.u.Exception.ExceptionRecord.ExceptionCode==STATUS_INTEGER_DIVIDE_BY_ZERO){
				//"0ɂ鏜Zs܂BXbh(&H%X) u[N |Cg(EIP=&H%08X)B\r\n"
				sprintf(temporary,STRING_DEBUG_DIVIDE_BY_ZERO,de.dwThreadId,(ULONG_PTR)de.u.Exception.ExceptionRecord.ExceptionAddress);
				DebugMessage(temporary);

				ShowVarList(&de,1);
				break;
			}
			else if(de.u.Exception.ExceptionRecord.ExceptionCode==STATUS_NO_MEMORY){
				//"sA܂̓q[vĂ邱ƂŁÅ蓖ĂɎs܂BXbh(&H%X) u[N |Cg(EIP=&H%08X)B\r\n"
				sprintf(temporary,STRING_DEBUG_DIVIDE_NO_MEMORY,de.dwThreadId,(ULONG_PTR)de.u.Exception.ExceptionRecord.ExceptionAddress);
				DebugMessage(temporary);

				ShowVarList(&de,1);
				break;
			}
			else{
				//"O\ncode:%X"
				sprintf(temporary,STRING_DEBUG_ERROR,de.u.Exception.ExceptionRecord.ExceptionCode);
				DebugMessage(temporary);
			}
		}
NextContinue:
		ContinueDebugEvent(de.dwProcessId,de.dwThreadId,DBG_CONTINUE);
	}

	extern HWND hDebugWnd;
	if(hDebugWnd) SendMessage(hDebugWnd,WM_COMMAND,IDCANCEL,0);

	//fobOɗp
	delete pobj_DBDebugSection;

	//fobOXbh
	delete pobj_dti;

	//u[N|Cg
	delete pobj_DBBreakPoint;

	//""
	SetDlgItemText(hMainDlg,IDOK,STRING_CLOSE);

	SendMessage(hOwnerEditor,WM_DESTROYDEBUGGERBASE,0,0);
}
