#include "stdafx.h"

#include <jenga/include/smoothie/SmoothieException.h>
#include <jenga/include/smoothie/LexicalAnalysis.h>

#include <Compiler.h>

bool NamespaceSupporter::ImportsNamespace( const std::string &namespaceStr )
{
	NamespaceScopes namespaceScopes( namespaceStr );
	if( !compiler.GetObjectModule().meta.GetNamespaces().IsExist( namespaceScopes ) ){
		return false;
	}

	this->importedNamespaces.push_back( namespaceScopes );

	return true;
}

bool NamespaceSupporter::CollectNamespaces( const char *source, NamespaceScopesCollection &namespaceScopesCollection )
{
	int i, i2;
	char temporary[1024];

	bool isSuccessful = true;

	// OԊǗ
	NamespaceScopes namespaceScopes;

	for(i=0;;i++){
		if(source[i]=='\0') break;

		if( source[i] == 1 && source[i+1] == ESC_NAMESPACE ){
			for(i+=2,i2=0;;i2++,i++){
				if( IsCommandDelimitation( source[i] ) ){
					temporary[i2]=0;
					break;
				}
				temporary[i2]=source[i];
			}
			namespaceScopes.push_back( temporary );

			if( !namespaceScopesCollection.IsExist( namespaceScopes ) ){
				namespaceScopesCollection.push_back( namespaceScopes );
			}

			continue;
		}
		else if( source[i] == 1 && source[i+1] == ESC_ENDNAMESPACE ){
			if( namespaceScopes.size() <= 0 ){
				SmoothieException::Throw( 12, "End Namespace", i );
				isSuccessful = false;
			}
			else{
				namespaceScopes.pop_back();
			}

			i += 2;
			continue;
		}
	}

	if( namespaceScopes.size() > 0 ){
		SmoothieException::Throw( 63 );
		isSuccessful = false;
	}

	return isSuccessful;
}
