#include "stdafx.h"

#include <jenga/include/smoothie/Smoothie.h>

#include <Compiler.h>
#include <Class.h>
#include <Variable.h>

#include "../BasicCompiler_Common/common.h"
#include "../BasicCompiler_Common/DebugSection.h"

#ifdef _AMD64_
#include "../BasicCompiler64/opcode.h"
#else
#include "../BasicCompiler32/opcode.h"
#endif

#define MDLFILE_VER	0x70000003


void SetLpIndex_DebugFile(char *buffer,int *p,const Type &type){
	if(NATURAL_TYPE(type.GetBasicType())==DEF_OBJECT || NATURAL_TYPE(type.GetBasicType())==DEF_STRUCT){
		lstrcpy(buffer+(*p),type.GetClass().GetName().c_str());
		(*p)+=lstrlen(buffer+(*p))+1;
	}
	else{
		*(LONG_PTR *)(buffer+(*p))=type.GetIndex();
		(*p)+=sizeof(LONG_PTR);
	}
}


void GetLpIndex_DebugFile(char *buffer,int *p,Type &type){
	if(NATURAL_TYPE(type.GetBasicType())==DEF_OBJECT || NATURAL_TYPE(type.GetBasicType())==DEF_STRUCT){
		char szClassName[VN_SIZE];
		lstrcpy(szClassName,buffer+(*p));
		(*p)+=lstrlen(buffer+(*p))+1;

		type.SetClassPtr( compiler.GetObjectModule().meta.GetClasses().Find(szClassName) );
	}
	else{
		type.SetIndex( *(LONG_PTR *)(buffer+(*p)) );
		(*p)+=sizeof(LONG_PTR);
	}
}



CDebugSection::~CDebugSection(){
	if(dwImageBase) DeleteDebugInfo();
	if(buffer){
		HeapDefaultFree(buffer);
		buffer=0;
	}
}
void CDebugSection::make(void){
	int i2,i3,BufferSize;

	if(buffer){
		HeapDefaultFree(buffer);
		buffer=0;
	}

	i2=0;

	extern char *basbuf;
	BufferSize=lstrlen(basbuf)+65535;
	buffer=(char *)HeapAlloc(hHeap,0,BufferSize);

	//fobOpt@C̃o[W
	*(long *)(buffer+i2)=MDLFILE_VER;
	i2+=sizeof(long);

	//vbgtH[̃rbg
	*(long *)(buffer+i2)=PLATFORM;
	i2+=sizeof(long);


	// IuWFNgW[
	{
		// eLXgf[^ɃVACY
		std::string textString;
		compiler.GetObjectModule().WriteTextString( textString );

		// TCY
		*(long *)(buffer+i2) = textString.size();
		i2+=sizeof(long);

		//obt@Ȃꍇ͍Ċm
		if(BufferSize<i2+(int)textString.size()+32768){
			while( BufferSize<i2+(int)textString.size()+32768 )
			{
				BufferSize+=32768;
			}

			buffer=(char *)HeapReAlloc(hHeap,0,buffer,BufferSize);
		}

		// obt@
		memcpy( buffer+i2, textString.c_str(), textString.size() );
		i2 += textString.size();
	}


	//CN[h
	extern INCLUDEFILEINFO IncludeFileInfo;
	*(long *)(buffer+i2)=IncludeFileInfo.FilesNum;
	i2+=sizeof(long);
	for(i3=0;i3<IncludeFileInfo.FilesNum;i3++){
		lstrcpy(buffer+i2,IncludeFileInfo.ppFileNames[i3]);
		i2+=lstrlen(buffer+i2)+1;
	}
	buffer[i2++]=0;
	for(i3=0;;i3++){
		buffer[i2++]=(char)IncludeFileInfo.LineOfFile[i3];
		if(IncludeFileInfo.LineOfFile[i3]==-1) break;

		//obt@Ȃꍇ͍Ċm
		if(BufferSize<i2+32768){
			BufferSize+=32768;
			buffer=(char *)HeapReAlloc(hHeap,0,buffer,BufferSize);
		}
	}

	//\[XR[h
	{
		//obt@Ȃꍇ͍Ċm
		int bufferLen = lstrlen( basbuf );
		if(BufferSize<i2+(int)bufferLen+32768){
			while( BufferSize<i2+(int)bufferLen+32768 )
			{
				BufferSize+=32768;
			}

			buffer=(char *)HeapReAlloc(hHeap,0,buffer,BufferSize);
		}
	}
	lstrcpy(buffer+i2,basbuf);
	i2+=lstrlen( buffer + i2 )+1;


	////////////////////////
	// R[hƍsԍ̊֌W
	////////////////////////
	extern SourceLines oldSourceLines;

	*(long *)(buffer+i2)=(long)oldSourceLines.size();
	i2+=sizeof(long);
	BOOST_FOREACH( const SourceLine &sourceLine, oldSourceLines )
	{
		*(long *)(buffer+i2) = sourceLine.GetLineNum();
		i2+=sizeof(long);

		*(long *)(buffer+i2) = sourceLine.GetNativeCodePos();
		i2+=sizeof(long);

		*(long *)(buffer+i2) = sourceLine.GetSourceCodePos();
		i2+=sizeof(long);

		*(long *)(buffer+i2) = sourceLine.GetCodeType();
		i2+=sizeof(long);

		//obt@Ȃꍇ͍Ċm
		if(BufferSize<i2+32768){
			BufferSize+=32768;
			buffer=(char *)HeapReAlloc(hHeap,0,buffer,BufferSize);
		}
	}

	//O[os̈̃TCY
	extern int GlobalOpBufferSize;
	*(long *)(buffer+i2)=GlobalOpBufferSize;
	i2+=sizeof(long);

	length=i2;
}

char *CDebugSection::MakeSingleStepCode(void){
	char *buffer;
	buffer=(char *)HeapAlloc(hHeap,0,SizeOf_CodeSection);

	memcpy(buffer,OpBuffer,SizeOf_CodeSection);

	BOOST_FOREACH( const SourceLine &sourceLine, _oldSourceLines )
	{
		if(!(
			sourceLine.IsInSystemProc()
			|| sourceLine.IsInDebugProc() ) )
		{
			//int 3
			buffer[sourceLine.GetNativeCodePos()]=(char)0xCC;
		}
	}

	return buffer;
}
BOOL CDebugSection::__load(void){
	int i2,i3;

	compiler.pCompilingClass = NULL;

	i2=0;

	//fobOpt@C̃o[W`FbN
	if(*(long *)(buffer+i2)<MDLFILE_VER){
		HeapDefaultFree(buffer);
		return 0;
	}
	i2+=sizeof(long);

	//vbgtH[̃rbg`FbN
	if(*(long *)(buffer+i2)!=PLATFORM){
		HeapDefaultFree(buffer);
		return 0;
	}
	i2+=sizeof(long);

	// IuWFNgW[
	{
		// TCY
		int size = *(long *)(buffer+i2);
		i2 += sizeof(long);

		// obt@
		const std::string textString( (const char *)(buffer + i2), size );
		i2 += size;

		// eLXgf[^VACY
		this->objectModule.ReadTextString( textString );

		compiler.SelectObjectModule( this->objectModule );
	}

	//CN[h
	_IncludeFileInfo.FilesNum=*(long *)(buffer+i2);
	i2+=sizeof(long);
	_IncludeFileInfo.ppFileNames=(char **)malloc(_IncludeFileInfo.FilesNum*sizeof(char *));
	for(i3=0;i3<_IncludeFileInfo.FilesNum;i3++){
		if(buffer[i2]=='\0') break;
		_IncludeFileInfo.ppFileNames[i3]=(char *)malloc(lstrlen(buffer+i2)+1);
		lstrcpy(_IncludeFileInfo.ppFileNames[i3],buffer+i2);
		i2+=lstrlen(buffer+i2)+1;
	}
	for(i2++,i3=0;;i2++,i3++){
		_IncludeFileInfo.LineOfFile[i3]=(long)buffer[i2];
		if(_IncludeFileInfo.LineOfFile[i3]==-1) break;
	}

	//\[XR[h
	i2++;
	source.SetBuffer( buffer + i2 );
	i2+=lstrlen(buffer+i2)+1;

	//R[hƍsԍ̊֌W
	int maxLineInfoNum;
	maxLineInfoNum=*(long *)(buffer+i2);
	i2+=sizeof(long);
	for(i3=0;i3<maxLineInfoNum;i3++){
		int lineNum = *(long *)(buffer+i2);
		i2+=sizeof(long);

		int nativeCodePos = *(long *)(buffer+i2);
		i2+=sizeof(long);

		int sourceCodePos = *(long *)(buffer+i2);
		i2+=sizeof(long);

		DWORD sourceLineType = *(DWORD *)(buffer+i2);
		i2+=sizeof(long);

		_oldSourceLines.push_back( SourceLine( lineNum, nativeCodePos, sourceCodePos, sourceLineType ) );
	}

	//O[os̈̃TCY
	GlobalOpBufferSize=*(long *)(buffer+i2);
	i2+=sizeof(long);


	HeapDefaultFree(buffer);
	buffer=0;


	this->pSub_DebugSys_EndProc=GetSubHash("_DebugSys_EndProc");
	if( this->pSub_DebugSys_EndProc == NULL )
	{
		MessageBox( 0, "_DebugSys_EndProcȂ", "ActiveBasic", MB_OK );
	}


	SingleStepCodeBuffer=MakeSingleStepCode();


	/////////////////////////////
	// u[N|CgKp
	/////////////////////////////

	//CN[h
	extern INCLUDEFILEINFO IncludeFileInfo;
	IncludeFileInfo=this->_IncludeFileInfo;

	//R[hƍsԍ̊֌W
	extern SourceLines oldSourceLines;
	oldSourceLines = this->_oldSourceLines;

	BreakStepCodeBuffer=pobj_DBBreakPoint->update(OpBuffer,SizeOf_CodeSection);

	//vZXɃRs[
	extern HANDLE hDebugProcess;
	SIZE_T accessBytes;
	WriteProcessMemory(hDebugProcess,(void *)(ULONG_PTR)(dwImageBase+dwRVA_CodeSection),
		BreakStepCodeBuffer,
		SizeOf_CodeSection,&accessBytes);


	return 1;
}

BOOL CDebugSection::load(HMODULE hModule){
	if(buffer){
		HeapDefaultFree(buffer);
		buffer=0;
	}


	extern HANDLE hDebugProcess;
	SIZE_T accessBytes;
	IMAGE_DOS_HEADER ImageDosHeader;
	ReadProcessMemory(hDebugProcess,hModule,&ImageDosHeader,sizeof(IMAGE_DOS_HEADER),&accessBytes);

	int pe_size;
#ifdef _AMD64_
	IMAGE_NT_HEADERS64 pe_hdr;
	pe_size=sizeof(IMAGE_NT_HEADERS64);
#else
	IMAGE_NT_HEADERS pe_hdr;
	pe_size=sizeof(IMAGE_NT_HEADERS);
#endif
	ReadProcessMemory(hDebugProcess,(void *)(((ULONG_PTR)hModule)+ImageDosHeader.e_lfanew),&pe_hdr,pe_size,&accessBytes);

	IMAGE_SECTION_HEADER *pSectionHdr;
	pSectionHdr=(IMAGE_SECTION_HEADER *)HeapAlloc(hHeap,0,pe_hdr.FileHeader.NumberOfSections*sizeof(IMAGE_SECTION_HEADER));
	ReadProcessMemory(hDebugProcess,
		(void *)(((ULONG_PTR)hModule)+ImageDosHeader.e_lfanew+pe_size),
		pSectionHdr,
		pe_hdr.FileHeader.NumberOfSections*sizeof(IMAGE_SECTION_HEADER),
		&accessBytes);

	int i;
	for(i=0;i<pe_hdr.FileHeader.NumberOfSections;i++){

		//C^uZNV̏
		if(lstrcmp((char *)pSectionHdr[i].Name,".data")==0){
			dwRVA_RWSection=pSectionHdr[i].VirtualAddress;
		}

		//R[hZNV̏
		if(lstrcmp((char *)pSectionHdr[i].Name,".text")==0){
			dwRVA_CodeSection=pSectionHdr[i].VirtualAddress;
			SizeOf_CodeSection=pSectionHdr[i].SizeOfRawData;
		}

		//fobOZNV̏
		if(lstrcmp((char *)pSectionHdr[i].Name,".debug")==0){
			length=pSectionHdr[i].Misc.VirtualSize;
			buffer=(char *)HeapAlloc(hHeap,0,length+1);

			ReadProcessMemory(hDebugProcess,
				(void *)(((ULONG_PTR)hModule)+pSectionHdr[i].VirtualAddress),
				buffer,
				length,
				&accessBytes);
			buffer[length]=0;
		}

	}
	HeapDefaultFree(pSectionHdr);

	if(!buffer) return 0;


	dwImageBase=(DWORD)(ULONG_PTR)hModule;



	if(OpBuffer) free(OpBuffer);
	OpBuffer=(char *)malloc(SizeOf_CodeSection);

	ReadProcessMemory(hDebugProcess,
		(void *)(ULONG_PTR)(dwImageBase+dwRVA_CodeSection),OpBuffer,
		SizeOf_CodeSection,&accessBytes);


	return __load();
}

void CDebugSection::choice(void){
	//C[Wx[X
	extern DWORD ImageBase;
	ImageBase=this->dwImageBase;

	//C^uZNVRVA
	extern int MemPos_RWSection;
	MemPos_RWSection=this->dwRVA_RWSection;

	//R[hZNVRVAƃTCY
	extern int MemPos_CodeSection;
	extern int FileSize_CodeSection;
	MemPos_CodeSection=this->dwRVA_CodeSection;
	FileSize_CodeSection=this->SizeOf_CodeSection;

	// IuWFNgW[
	compiler.SelectObjectModule( this->objectModule );

	//CN[h
	extern INCLUDEFILEINFO IncludeFileInfo;
	IncludeFileInfo=this->_IncludeFileInfo;

	//\[XR[h
	Smoothie::Lexical::source = source;

	//R[hƍsԍ̊֌W
	extern SourceLines oldSourceLines;
	oldSourceLines = this->_oldSourceLines;

	//O[os̈̃TCY
	extern int GlobalOpBufferSize;
	GlobalOpBufferSize=this->GlobalOpBufferSize;

	extern const UserProc *pSub_DebugSys_EndProc;
	pSub_DebugSys_EndProc=this->pSub_DebugSys_EndProc;

	//lCeBuR[hobt@
	extern char *OpBuffer;
	OpBuffer=this->OpBuffer;
}

void CDebugSection::DeleteDebugInfo(void){
	int i2;

	//CN[h
	for(i2=0;i2<_IncludeFileInfo.FilesNum;i2++)
	{
		free(_IncludeFileInfo.ppFileNames[i2]);
	}
	free(_IncludeFileInfo.ppFileNames);

	//R[hobt@
	free(OpBuffer);
	OpBuffer=0;

	HeapDefaultFree(SingleStepCodeBuffer);
	SingleStepCodeBuffer=0;

	HeapDefaultFree(BreakStepCodeBuffer);
	BreakStepCodeBuffer=0;
}



CDBDebugSection::CDBDebugSection(){
	ppobj_ds=(CDebugSection **)HeapAlloc(hHeap,0,1);
	num=0;
}
CDBDebugSection::~CDBDebugSection(){
	int i;
	for(i=0;i<num;i++){
		delete ppobj_ds[i];
	}
	HeapDefaultFree(ppobj_ds);
}

BOOL CDBDebugSection::add(HMODULE hModule){
	CDebugSection *pobj_d;
	pobj_d=new CDebugSection();
	if(!pobj_d->load(hModule)){
		//fobO񂪑݂ȂƂ
		delete pobj_d;
		return 0;
	}

	ppobj_ds=(CDebugSection **)HeapReAlloc(hHeap,0,ppobj_ds,(num+1)*sizeof(CDebugSection *));
	ppobj_ds[num]=pobj_d;
	num++;

	return 1;
}

void CDBDebugSection::del(HMODULE hModule){
	int i;
	for(i=0;i<num;i++){
		if((HMODULE)(ULONG_PTR)ppobj_ds[i]->dwImageBase==hModule){
			delete ppobj_ds[i];

			num--;
			for(;i<num;i++){
				ppobj_ds[i]=ppobj_ds[i+1];
			}
			break;
		}
	}
}

void CDBDebugSection::choice(int index){
	pobj_now=ppobj_ds[index];
	pobj_now->choice();
}



CDBDebugSection *pobj_DBDebugSection;
