#pragma once

#include <Type.h>
#include <Procedure.h>
#include "MachineFixed.h"


//ϐ̎
#define NON_VAR				0
#define VAR_GLOBAL			1	// Global Variable
#define VAR_REFGLOBAL		2	// Global Refference Variable
#define VAR_LOCAL			3	// Local Variable
#define VAR_REFLOCAL		4	// Local Refference Variable
#define VAR_DIRECTMEM		5	// Direct memory


extern int cp;

#define breakpoint compiler.codeGenerator.PutOld( (char)0xCC );


//vV[W̎
#define PROC_DEFAULT	1	//[U[`֐
#define PROC_DLL		2	//DLL֐
#define PROC_BUILTIN	3	//RpCߍ݌^
#define PROC_PTR		4	//֐|C^

//vV[W
struct PROCEDURE{
	char name[255];
	int address;
	int types[MAX_PARMS];
	_int8 ByVal[MAX_PARMS];
	BOOL ReturnType;
};

//With
struct WITHINFO{
	char **ppName;
	int *pWithCp;
	int num;
};


//RSrcSection.cpp
char *GetRSrcSectionBuffer(int *pLen);

//Compile.cpp
void ChangeOpcode(char *Command);
void GetGlobalDataForDll(void);
DWORD CompileBuffer(char Return_Sequence,WORD Return_Command);

//Compile_Calc.cpp
void ChangeTypeToDouble_ToFpuReg(int OldType);
void ChangeTypeToDouble(int OldType);
void ChangeTypeToSingle(int OldType);
void ChangeTypeToInt64(int OldType);
void ChangeTypeToLong(int OldType);
void ChangeTypeToInteger(int OldType);
void ChangeTypeToByte(int OldType);
void SetVariableFromEax(int VarType,int CalcType,RELATIVE_VAR *pRelativeVar);
void OpcodeCalc( const char *Command );

//NumOpe.cpp
void PushReturnValue(int type);
bool TermOpe(
			 const char *term,
			 const Type &baseType,
			 Type &resultType,
			 bool &isLiteral,
			 BOOL *pbUseHeap,
			 bool isWantObject = false,
			 bool *pIsClassName = NULL,
			 bool isProcedureCallOnly = false );
bool NumOpe( int reg,
			const char *expression,
			const Type &baseType,
			Type &resultType,
			BOOL *pbUseHeap = NULL );
bool NumOpe( const char *Command,
		   const Type &baseType,
		   Type &resultType,
		   BOOL *pbUseHeap = NULL );

//NumOpe_Arithmetic.cpp
void GetStackData_ToRegister(int *type,int sp);
BOOL CalcTwoTerm_Arithmetic(int idCalc,int *type,LONG_PTR *index_stack,int *pStackPointer);
BOOL Calc_Mod(int *type,int *pStackPointer);
BOOL Calc_Divide(int *type,int *pStackPointer,int BaseType);
BOOL Calc_IntDivide(int *type,LONG_PTR *index_stack,int *pStackPointer);
BOOL Calc_MinusMark(int *type,int sp);
BOOL Calc_Power(int *type,int *pStackPointer);
BOOL Calc_Cast(int *type,LONG_PTR *index_stack,int *pStackPointer);
BOOL Calc_SHL(int *type,int *pStackPointer);
BOOL Calc_SHR(int *type,int *pStackPointer);

//NumOpe_Logical.cpp
BOOL Calc_Xor(int *type,LONG_PTR *index_stack,int *pStackPointer);
BOOL Calc_Or(int *type,LONG_PTR *index_stack,int *pStackPointer);
BOOL Calc_And(int *type,LONG_PTR *index_stack,int *pStackPointer);
BOOL Calc_Not(int *type,int sp);

//NumOpe_Relation.cpp
BOOL Calc_Relation_PE(int *type_stack,LONG_PTR *index_stack,int *pStackPointer);
BOOL Calc_Relation_QE(int *type_stack,LONG_PTR *index_stack,int *pStackPointer);
BOOL Calc_Relation_P(int *type_stack,LONG_PTR *index_stack,int *pStackPointer);
BOOL Calc_Relation_Q(int *type_stack,LONG_PTR *index_stack,int *pStackPointer);
BOOL Calc_Relation_NotEqual(int *type,int *pStackPointer);
BOOL Calc_Relation_Equal(int *type,int *pStackPointer);

//NumOpe_TypeOperation.cpp
void ExtendStackTo64(int type);
void ChangeTypeToWhole(int OldType,int NewType);

//Compile_Set_Var.cpp
BOOL IsUse_ecx(RELATIVE_VAR *pRelativeVar);
void SetStructVariable( const Type &varType, const Type &calcType, BOOL bUseHeap);
void SetRealVariable(int VarType, int CalcType, RELATIVE_VAR *pRelativeVar);
void SetWholeVariable( int varSize,int calcType, RELATIVE_VAR *pRelative );

void SetDoubleVariable(int type,DWORD VarKind,DWORD offset,BOOL bOffsetOffset);
void SetSingleVariable(int type,DWORD VarKind,DWORD offset,BOOL bOffsetOffset);
void SetInt64Variable(int type,RELATIVE_VAR *pRelative);
void SetDWordVariable(int type,DWORD VarKind,DWORD offset,BOOL bOffsetOffset);
void SetLongVariable(int type,DWORD VarKind,DWORD offset,BOOL bOffsetOffset);
void Set16Variable(int type,DWORD VarKind,DWORD offset,BOOL bOffsetOffset);
void Set8Variable(int type,DWORD VarKind,DWORD offset,BOOL bOffsetOffset);
void SetBooleanVariable(int type,RELATIVE_VAR *pRelative);
void ExtendTypeTo64(int type);
void ExtendTypeTo32(int type,int reg);
void ExtendTypeTo16(int type,int reg);

//increment.cpp
void IncDec(int idCalc, const char *lpszLeft, const char *lpszRight);

//calc2.cpp
#define EXP_TYPE_NUMBER	1
#define EXP_TYPE_EAX	2
#define EXP_TYPE_FPU	3
#define EXP_TYPE_VAR	4
int NumOpEx(char *Command,double *pDbl,DWORD *pdwType,RELATIVE_VAR *pRelativeVar);

//SetVar.cpp
BOOL SetVariable(DWORD dwVarType,RELATIVE_VAR *pVarRelativeVar,
				 DWORD dwExpType,DWORD dwType,void *data);

//Compile_Calc_PushVar.cpp
void SetReg_RealVariable(int type,RELATIVE_VAR *pRelativeVar);
void SetReg_WholeVariable(int type,RELATIVE_VAR *pRelativeVar,int reg, bool is64Head = false);
void PushLongVariable(RELATIVE_VAR *pRelativeVar);

//Compile_Object.cpp
void Operator_New( const CClass &classObj, const char *objectSizeStr, const char *parameter, const Type &baseType );
void OpcodeDelete(const char *Parameter, bool isSweeping);

//Compile_Var.cpp
void SetRelativeOffset( RELATIVE_VAR &relativeVar );
bool _member_offset(bool isErrorEnabled, bool isWriteAccess, const CClass &objClass, const char *member, RELATIVE_VAR *pRelativeVar, Type &resultType, BOOL bPrivateAccess);
void SetThisPtrToReg(int reg);
bool GetVarOffset(bool isErrorEnabled,bool isWriteAccess,const char *NameBuffer,RELATIVE_VAR *pRelativeVar,Type &resultType, Subscripts *pResultSubscripts = NULL );
bool SetInitGlobalData(int offset,const Type &type,const Subscripts &subscripts,const char *InitBuf);
#define DIMFLAG_INITDEBUGVAR			1
#define DIMFLAG_NONCALL_CONSTRACTOR		2
#define DIMFLAG_STATIC					4
#define DIMFLAG_CONST					8
void dim( char *VarName, const Subscripts &subscripts, Type &type, const char *InitBuf,const char *ConstractParameter,DWORD dwFlags);
void SetVarPtrToEax(RELATIVE_VAR *pRelativeVar);
void SetVarPtrToReg(int reg,RELATIVE_VAR *pRelativeVar);
bool Compile_AddGlobalRootsForGc();

//ParamImpl.cpp
class ParamImpl{
	char *Parms[255];
	vector<Type> types;
	int ParmsNum;

	Type returnType;

	//ꎞIuWFNgǗp
	bool useTempObject;
	bool useTempParameters[255];
	int nCountOfTempObjects;

public:
	ParamImpl(const char *buffer);
	ParamImpl(const Parameters &params);
	~ParamImpl();
	void SetReturnType( const Type &returnType );

private:
	bool EvaluateOverloadScore( int level, const Parameters &targetParms, const Type &targetResultType );
public:
	const UserProc *_OverloadSolution( const char *name, std::vector<const UserProc *> &subs, bool isEnabledReturnType = false );
	const UserProc *OverloadSolution( const char *name, std::vector<const UserProc *> &subs, bool isEnabledReturnType = false );

	void ApplyDefaultParameters( const Parameters &params );
	bool ErrorCheck( const string &procName, const Parameters &params, int SecondParmNum = -1 );
	void MacroParameterSupport( const Parameters &params );
	void SetStructParameter( const Type &baseType, const char *expression );
	int SetParameter( const string &procName, const Parameters &params, int SecondParmNum = -1 );

	//ꎞIuWFNgp[^̐Ɣj
	int NewTempParameters( const string &procName, const Parameters &params, int SecondParmNum = -1 );
	void DeleteTempParameters();
};

//Compile_CallProc.cpp
#define PROCFLAG_NEW	1
bool Opcode_CallProcPtr( const char *variable, const char *lpszParms,ProcPointer *pProcPointer);
bool Opcode_CallProc(const char *Parameter,const UserProc *pUserProc,DWORD dwFlags,const char *ObjectName,int RefType);
bool Opcode_CallDllProc( const char *lpszParms, const DllProc *pDllProc );

//Compile_ProcOp.cpp
void CompileLocal();

//Compile_Func.cpp
int GetFunctionFromName(char *FuncName);
bool Opcode_CallFunc( const char *Parameter, const int FuncNum, Type &resultType, bool isCallOn = true );

//OperatorProc.cpp
void FreeTempObject(int reg,const CClass *pobj_c);
int CallOperatorProc(int idCalc, const Type &baseType, int *type_stack,LONG_PTR *index_stack,BOOL *bUseHeap,int &sp);
void CallCastOperatorProc(Type &calcType,BOOL bCalcUseHeap,const Type &toType);
void CallIndexerGetterProc(const CClass *pobj_Class,char *ObjectName,char *Parameter,Type &resultType);

//Compile_Statement.cpp
void OpcodeOthers( const char *Command );
void OpcodeIf(char *Parameter);
void OpcodeGoto(char *Parameter);
void OpcodeWhile(char *Parameter);
void OpcodeFor(char *Parameter);
void OpcodeDo(char *Parameter);
void OpcodeContinue(void);
void OpcodeExitSub(void);
void OpcodeSelect(const char *lpszParms);
void OpcodeCase(char *Parameter);
void OpcodeGosub(char *Parameter);
void OpcodeReturn(char *Parameter);
void OpcodeSetPtrData(char *Parameter,int type);




//op32_main.cpp
BOOL IsSafeReg(int reg);
